/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command;

import com.l2jserver.cli.command.AbstractCommand;
import java.io.File;
import java.util.Properties;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="build", aliases={"b"})
public class BuildCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(BuildCommand.class);
    @CommandLine.Option(names={"--login-directory", "-lsdir"}, defaultValue="./l2j/git/l2j-server-login", description={"Login directory"})
    private String loginDirectory = "./l2j/git/l2j-server-login";
    @CommandLine.Option(names={"--game-directory", "-gsdir"}, defaultValue="./l2j/git/l2j-server-game", description={"Game directory"})
    private String gameDirectory = "./l2j/git/l2j-server-game";
    @CommandLine.Option(names={"--datapack-directory", "-dpdir"}, defaultValue="./l2j/git/l2j-server-datapack", description={"DataPack directory"})
    private String datapackDirectory = "./l2j/git/l2j-server-datapack";
    @CommandLine.Option(names={"--skip-tests", "-st"}, defaultValue="true", description={"Skip Tests"})
    private boolean skipTests = true;

    @Override
    public void run() {
        try {
            boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
            Properties properties = new Properties();
            if (this.skipTests) {
                properties.setProperty("skipTests", "true");
            }
            System.out.println("Building L2J Loginserver");
            this.executeMavenWrapper("install", this.loginDirectory, properties, isWindows);
            System.out.println("Building L2J Gameserver");
            this.executeMavenWrapper("install", this.gameDirectory, properties, isWindows);
            System.out.println("Building L2J DataPack");
            this.executeMavenWrapper("install", this.datapackDirectory, properties, isWindows);
        }
        catch (Exception e) {
            LOG.error("Unable to build the code!", (Throwable)e);
        }
    }

    private void executeMavenWrapper(String goal, String sourceDir, Properties properties, boolean isWindows) throws Exception {
        String mavenExecutableName = "mvnw" + (isWindows ? ".cmd" : "");
        File mavenExecutableFile = new File(sourceDir, mavenExecutableName).getAbsoluteFile();
        mavenExecutableFile.setExecutable(true);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(sourceDir, "pom.xml"));
        request.addArg(goal);
        request.setProperties(properties);
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(sourceDir));
        invoker.setMavenExecutable(mavenExecutableFile);
        invoker.execute((InvocationRequest)request);
    }
}

