/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.model.CloneType;
import com.l2jserver.cli.util.LoggerProgressMonitor;
import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="code", aliases={"c"})
public class CodeCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(CodeCommand.class);
    private static final LoggerProgressMonitor LOGGER_PROGRESS_MONITOR = new LoggerProgressMonitor(LOG);
    @CommandLine.Option(names={"--login-repository", "-lsrepo"}, defaultValue="https://bitbucket.org/l2jserver/l2j-server-login.git", description={"Login repository"})
    private String loginRepository = "https://bitbucket.org/l2jserver/l2j-server-login.git";
    @CommandLine.Option(names={"--game-repository", "-gsrepo"}, defaultValue="https://bitbucket.org/l2jserver/l2j-server-game.git", description={"Game repository"})
    private String gameRepository = "https://bitbucket.org/l2jserver/l2j-server-game.git";
    @CommandLine.Option(names={"--datapack-repository", "-dprepo"}, defaultValue="https://bitbucket.org/l2jserver/l2j-server-datapack.git", description={"Datapack repository"})
    private String datapackRepository = "https://bitbucket.org/l2jserver/l2j-server-datapack.git";
    @CommandLine.Option(names={"--login-directory", "-lsdir"}, defaultValue="./l2j/git/l2j-server-login", description={"Login directory"})
    private String loginDirectory = "./l2j/git/l2j-server-login";
    @CommandLine.Option(names={"--game-directory", "-gsdir"}, defaultValue="./l2j/git/l2j-server-game", description={"Game directory"})
    private String gameDirectory = "./l2j/git/l2j-server-game";
    @CommandLine.Option(names={"--datapack-directory", "-dpdir"}, defaultValue="./l2j/git/l2j-server-datapack", description={"DataPack directory"})
    private String datapackDirectory = "./l2j/git/l2j-server-datapack";
    @CommandLine.Option(names={"--clone"}, defaultValue="ALL", description={"Clone ALL|LOGIN|GAME|DATAPACK"})
    private CloneType cloneType = CloneType.ALL;

    @Override
    public void run() {
        try {
            switch (this.cloneType) {
                case ALL: {
                    LOG.info("Cloning L2J Loginserver");
                    this.cloneRepository(this.loginRepository, this.loginDirectory);
                    LOG.info("Cloning L2J Gameserver");
                    this.cloneRepository(this.gameRepository, this.gameDirectory);
                    LOG.info("Cloning L2J DataPack");
                    this.cloneRepository(this.datapackRepository, this.datapackDirectory);
                    break;
                }
                case LOGIN: {
                    LOG.info("Cloning L2J Loginserver");
                    this.cloneRepository(this.loginRepository, this.loginDirectory);
                    break;
                }
                case GAME: {
                    LOG.info("Cloning L2J Gameserver");
                    this.cloneRepository(this.gameRepository, this.gameDirectory);
                    break;
                }
                case DATAPACK: {
                    LOG.info("Cloning L2J DataPack");
                    this.cloneRepository(this.datapackRepository, this.datapackDirectory);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to get the code!", (Throwable)ex);
        }
    }

    private void cloneRepository(String repository, String directoryStr) {
        try {
            File directory = new File(directoryStr);
            if (directory.exists()) {
                Git.open((File)directory).pull();
            } else {
                Git.cloneRepository().setURI(repository).setDirectory(directory).setProgressMonitor((ProgressMonitor)LOGGER_PROGRESS_MONITOR).call();
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to get the code!", (Throwable)ex);
        }
    }
}

