/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command;

import com.l2jserver.cli.command.AbstractCommand;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="deploy", aliases={"d"})
public class DeployCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DeployCommand.class);
    @CommandLine.Option(names={"--login-source-directory", "-lssrc"}, defaultValue="./l2j/git/l2j-server-login", description={"Login directory"})
    private String loginSourceDirectory = "./l2j/git/l2j-server-login";
    @CommandLine.Option(names={"--game-source-directory", "-gssrc"}, defaultValue="./l2j/git/l2j-server-game", description={"Game directory"})
    private String gameSourceDirectory = "./l2j/git/l2j-server-game";
    @CommandLine.Option(names={"--datapack-source-directory", "-dpsrc"}, defaultValue="./l2j/git/l2j-server-datapack", description={"DataPack directory"})
    private String datapackSourceDirectory = "./l2j/git/l2j-server-datapack";
    @CommandLine.Option(names={"--login-deploy-directory", "-lsdepl"}, defaultValue="./l2j/deploy/login", description={"Login directory"})
    private String loginDeployDirectory = "./l2j/deploy/login";
    @CommandLine.Option(names={"--game-deploy-directory", "-gsdepl"}, defaultValue="./l2j/deploy/game", description={"Game directory"})
    private String gameDeployDirectory = "./l2j/deploy/game";
    @CommandLine.Option(names={"--datapack-deploy-directory", "-dpdepl"}, defaultValue="./l2j/deploy/game", description={"DataPack directory"})
    private String datapackDeployDirectory = "./l2j/deploy/game";

    @Override
    public void run() {
        try {
            LOG.info("Deploying L2J Loginserver");
            this.processArtifact(this.loginSourceDirectory, this.loginDeployDirectory);
            LOG.info("Deploying L2J Gameserver");
            this.processArtifact(this.gameSourceDirectory, this.gameDeployDirectory);
            LOG.info("Deploying L2J DataPack");
            this.processArtifact(this.datapackSourceDirectory, this.datapackDeployDirectory);
        }
        catch (Exception e) {
            LOG.error("Unable to deploy components!", (Throwable)e);
        }
    }

    public void processArtifact(String srcDirPath, String dstDirPathStr) throws Exception {
        Files.list(Paths.get(srcDirPath, "target")).forEach(p -> {
            if (!p.toString().endsWith(".zip")) {
                return;
            }
            LOG.info("Processing zip file {}", (Object)p.toString());
            try {
                this.processZip((Path)p, Path.of(dstDirPathStr, new String[0]));
            }
            catch (Exception e) {
                LOG.error("Unable to process zip file!", (Throwable)e);
            }
        });
    }

    public void processZip(Path zipFilePath, Path dstDirPath) throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:file:" + zipFilePath.toAbsolutePath().toUri().getPath());
        try (FileSystem zipFs = FileSystems.newFileSystem(uri, env);){
            if (!Files.exists(dstDirPath, new LinkOption[0])) {
                dstDirPath.toFile().mkdirs();
            }
            for (Path p : zipFs.getRootDirectories()) {
                this.processZipEntry(p, dstDirPath);
            }
        }
    }

    public void processZipEntry(Path zipFsPath, Path dstDirPath) throws Exception {
        if (Files.isDirectory(zipFsPath, new LinkOption[0])) {
            LOG.info("Process directory {}", (Object)zipFsPath.toString());
            Files.list(zipFsPath).forEach(p -> {
                try {
                    this.processZipEntry((Path)p, dstDirPath);
                }
                catch (Exception e) {
                    LOG.info("Unable to unzip {}!", p, (Object)e);
                }
            });
        } else if (Files.isRegularFile(zipFsPath, new LinkOption[0])) {
            DeployCommand.checkZipSlip(dstDirPath, zipFsPath);
            Path outFilePath = Paths.get(dstDirPath.toString(), zipFsPath.toString());
            Path parentDirPath = outFilePath.getParent();
            if (!Files.exists(parentDirPath, new LinkOption[0])) {
                parentDirPath.toFile().mkdirs();
            }
            Files.copy(zipFsPath, Paths.get(dstDirPath.toString(), zipFsPath.toString()), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void checkZipSlip(Path dstDirPath, Path zipFsPath) throws Exception {
        Path dstFilePath = Paths.get(dstDirPath.toString(), zipFsPath.toString());
        if (!dstFilePath.toAbsolutePath().startsWith(dstDirPath.toAbsolutePath())) {
            throw new Exception("ZipSlipAttack detected: " + zipFsPath.toString());
        }
    }
}

