/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.account;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.dao.AccountDAO;
import java.util.Scanner;
import picocli.CommandLine;

@CommandLine.Command(name="delete")
public class AccountDeleteCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-u", "--username"}, required=true, description={"Username"})
    private String username;

    @Override
    public void run() {
        System.out.print("WARNING: This will not delete the gameserver data (characters, items, etc...)");
        System.out.print(" it will only delete the account login server data.");
        System.out.println();
        System.out.print("Do you really want to delete this account? y/N: ");
        try (Scanner s = new Scanner(FILTER_INPUT_STREAM);){
            if ("y".equalsIgnoreCase(s.next())) {
                boolean deleted = AccountDAO.getInstance().delete(this.username);
                if (deleted) {
                    System.out.println("Account " + this.username + " has been deleted.");
                } else {
                    System.out.println("Account " + this.username + " does not exist!");
                }
            } else {
                System.out.println("Account " + this.username + " has not been deleted.");
            }
        }
    }
}

