/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.dao;

import com.l2jserver.cli.config.Configuration;
import com.l2jserver.cli.dao.AbstractDAO;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class GameServerDAO
extends AbstractDAO {
    private static final String SELECT_SERVERS = "SELECT * FROM gameservers";
    private static final String INSERT_SERVER = "INSERT INTO gameservers (hexid, server_id, host) values (?,?,?)";
    private static final String DELETE_SERVER = "DELETE FROM gameservers WHERE server_id = ?";
    private static final String DELETE_ALL_SERVERS = "DELETE FROM gameservers";

    private GameServerDAO() {
        super(Configuration.loginServer());
    }

    public void unregister(int id) throws SQLException {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_SERVER);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void unregisterAll() throws SQLException {
        try (Connection con = this.getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate(DELETE_ALL_SERVERS);
        }
    }

    public void register(byte[] hexId, int id, String externalHost) throws SQLException {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_SERVER);){
            ps.setString(1, new BigInteger(hexId).toString(16));
            ps.setInt(2, id);
            ps.setString(3, externalHost);
            ps.executeUpdate();
        }
    }

    public Set<Integer> gameServers() throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        try (Connection con = this.getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(SELECT_SERVERS);){
            while (rs.next()) {
                result.add(rs.getInt("server_id"));
            }
        }
        return result;
    }

    public static GameServerDAO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final GameServerDAO INSTANCE = new GameServerDAO();

        private SingletonHolder() {
        }
    }
}

