/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.database;

import java.util.Properties;

public enum DatabaseType {
    MARIADB("MariaDB", "mariadb", true),
    MYSQL("MySQL", "mysql", true){

        @Override
        public Properties getParameters() {
            this.properties.setProperty("serverTimezone", "UTC");
            this.properties.setProperty("useSSL", "false");
            this.properties.setProperty("allowPublicKeyRetrieval", "true");
            return this.properties;
        }
    }
    ,
    SQLSERVER("Microsoft SQL Server", "sqlserver", false),
    HSQLDB("HyperSQL DataBase", "hsqldb", false),
    H2("H2 Database Engine", "h2", false),
    POSTGRESQL("PostgreSQL", "postgresql", false),
    ORACLE("Oracle Database", "oracle", false),
    DERBY("Apache Derby", "derby", false);

    final String name;
    final String jdbcPrefix;
    final boolean supported;
    final Properties properties;

    private DatabaseType(String name, String jdbcPrefix, boolean supported) {
        this.name = name;
        this.jdbcPrefix = jdbcPrefix;
        this.supported = supported;
        this.properties = new Properties();
    }

    public Properties getParameters() {
        return this.properties;
    }

    public static DatabaseType getType(String url) {
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (url == null || !url.startsWith("jdbc:" + databaseType.jdbcPrefix)) continue;
            return databaseType;
        }
        return null;
    }
}

