/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.PropertiesManager;
import org.aeonbits.owner.util.Util;

class HotReloadLogic
implements Serializable {
    private final PropertiesManager manager;
    private final long interval;
    private final Config.HotReloadType type;
    private volatile long lastCheckTime = Util.now();
    private final List<WatchableResource> watchableResources = new ArrayList<WatchableResource>();

    HotReloadLogic(Config.HotReload hotReload, List<URI> uris, PropertiesManager manager) {
        this.manager = manager;
        this.type = hotReload.type();
        this.interval = hotReload.unit().toMillis(hotReload.value());
        this.setupWatchableResources(uris);
    }

    private void setupWatchableResources(List<URI> uris) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (URI uri : uris) {
            if (uri.toString().equals("system:properties")) {
                this.watchableResources.add(new WatchableSystemProperties());
                continue;
            }
            File file = Util.fileFromURI(uri);
            if (file == null) continue;
            files.add(file);
        }
        for (File file : files) {
            this.watchableResources.add(new WatchableFile(file));
        }
    }

    synchronized void checkAndReload() {
        if (this.needsReload()) {
            this.manager.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsReload() {
        if (this.manager.isLoading()) {
            return false;
        }
        long now = Util.now();
        if (now < this.lastCheckTime + this.interval) {
            return false;
        }
        try {
            for (WatchableResource resource : this.watchableResources) {
                if (!resource.isChanged()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastCheckTime = now;
        }
    }

    boolean isAsync() {
        return this.type == Config.HotReloadType.ASYNC;
    }

    boolean isSync() {
        return this.type == Config.HotReloadType.SYNC;
    }

    private static class WatchableSystemProperties
    implements WatchableResource {
        private final Properties props = Util.system().getProperties();
        private int lastHashCode = this.props.hashCode();

        WatchableSystemProperties() {
        }

        @Override
        public boolean isChanged() {
            boolean changed;
            int newHashCode = this.props.hashCode();
            boolean bl = changed = this.lastHashCode != newHashCode;
            if (changed) {
                this.lastHashCode = newHashCode;
            }
            return changed;
        }
    }

    private static class WatchableFile
    implements WatchableResource {
        private final File file;
        private long lastModifiedTime;

        WatchableFile(File file) {
            this.file = file;
            this.lastModifiedTime = file.lastModified();
        }

        @Override
        public boolean isChanged() {
            boolean changed;
            long lastModifiedTimeNow = this.file.lastModified();
            boolean bl = changed = this.lastModifiedTime != lastModifiedTimeNow;
            if (changed) {
                this.lastModifiedTime = lastModifiedTimeNow;
            }
            return changed;
        }
    }

    private static interface WatchableResource
    extends Serializable {
        public boolean isChanged();
    }
}

