/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import org.aeonbits.owner.Config;

public abstract class Util {
    static TimeProvider timeProvider = new TimeProvider(){

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }
    };
    static SystemProvider system = new SystemProvider(){

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public Map<String, String> getenv() {
            return System.getenv();
        }

        @Override
        public Properties getProperties() {
            return (Properties)System.getProperties().clone();
        }
    };

    private Util() {
    }

    public static <T> List<T> reverse(List<T> src) {
        ArrayList<T> copy = new ArrayList<T>(src);
        Collections.reverse(copy);
        return copy;
    }

    public static <T> T[] reverse(T[] array) {
        Object[] copy = (Object[])array.clone();
        Collections.reverse(Arrays.asList(copy));
        return copy;
    }

    public static String expandUserHome(String text) {
        if (text.equals("~")) {
            return Util.getUserHome();
        }
        if (text.indexOf("~/") == 0 || text.indexOf("file:~/") == 0 || text.indexOf("jar:file:~/") == 0) {
            return text.replaceFirst("~/", Matcher.quoteReplacement(Util.getUserHome()) + "/");
        }
        if (text.indexOf("~\\") == 0 || text.indexOf("file:~\\") == 0 || text.indexOf("jar:file:~\\") == 0) {
            return text.replaceFirst("~\\\\", Matcher.quoteReplacement(Util.getUserHome()) + "\\\\");
        }
        return text;
    }

    private static String getUserHome() {
        return system.getProperty("user.home");
    }

    public static String fixBackslashesToSlashes(String path) {
        return path.replace('\\', '/');
    }

    public static String fixSpacesToPercentTwenty(String path) {
        return path.replace(" ", "%20");
    }

    public static <T> T ignoreAndReturnNull() {
        return null;
    }

    public static void ignore() {
    }

    public static boolean isFeatureDisabled(Method method, Config.DisableableFeature feature) {
        Class<Config.DisableFeature> annotation = Config.DisableFeature.class;
        return Util.isFeatureDisabled(feature, method.getDeclaringClass().getAnnotation(annotation)) || Util.isFeatureDisabled(feature, method.getAnnotation(annotation));
    }

    private static boolean isFeatureDisabled(Config.DisableableFeature feature, Config.DisableFeature annotation) {
        return annotation != null && Arrays.asList(annotation.value()).contains((Object)feature);
    }

    public static UnsupportedOperationException unsupported(Throwable cause, String msg, Object ... args) {
        return new UnsupportedOperationException(String.format(msg, args), cause);
    }

    public static UnsupportedOperationException unsupported(String msg, Object ... args) {
        return new UnsupportedOperationException(String.format(msg, args));
    }

    public static <T> T unreachableButCompilerNeedsThis() {
        throw new AssertionError((Object)"this code should never be reached");
    }

    public static String asString(Object result) {
        if (result == null) {
            return null;
        }
        return String.valueOf(result);
    }

    public static long now() {
        return timeProvider.getTime();
    }

    public static File fileFromURI(URI uri) {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            String path = uri.getSchemeSpecificPart();
            try {
                path = URLDecoder.decode(path, "utf-8");
                return new File(path);
            }
            catch (UnsupportedEncodingException e) {
                return (File)Util.unreachableButCompilerNeedsThis();
            }
        }
        if ("jar".equalsIgnoreCase(uri.getScheme())) {
            String path = uri.getSchemeSpecificPart();
            try {
                return Util.fileFromURI(path.substring(0, path.indexOf(33)));
            }
            catch (URISyntaxException e) {
                return (File)Util.ignoreAndReturnNull();
            }
        }
        return null;
    }

    public static File fileFromURI(String uriSpec) throws URISyntaxException {
        try {
            return Util.fileFromURI(new URI(uriSpec));
        }
        catch (URISyntaxException e) {
            uriSpec = uriSpec.replace('\\', '/');
            return Util.fileFromURI(new URI(uriSpec));
        }
    }

    public static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static SystemProvider system() {
        return system;
    }

    public static void save(File target, Properties p) throws IOException {
        File parent = target.getParentFile();
        parent.mkdirs();
        if (Util.isWindows()) {
            Util.store(target, p);
        } else {
            File tempFile = File.createTempFile(target.getName(), ".temp", parent);
            Util.store(tempFile, p);
            Util.rename(tempFile, target);
        }
    }

    private static boolean isWindows() {
        return system.getProperty("os.name").toLowerCase().contains("win");
    }

    public static void delete(File target) {
        target.delete();
    }

    private static void store(File target, Properties p) throws IOException {
        FileOutputStream out = new FileOutputStream(target);
        try {
            Util.store(out, p);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static void store(OutputStream out, Properties p) throws IOException {
        p.store(out, "saved for test");
    }

    public static void saveJar(File target, String entryName, Properties props) throws IOException {
        File parent = target.getParentFile();
        parent.mkdirs();
        Util.storeJar(target, entryName, props);
    }

    private static void rename(File source, File target) throws IOException {
        if (!source.renameTo(target)) {
            throw new IOException(String.format("Failed to overwrite %s to %s", source.toString(), target.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeJar(File target, String entryName, Properties props) throws IOException {
        byte[] bytes = Util.toBytes(props);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            try {
                JarOutputStream output = new JarOutputStream(fileOutputStream);
                try {
                    int size;
                    ZipEntry entry = new ZipEntry(entryName);
                    output.putNextEntry(entry);
                    byte[] buffer = new byte[4096];
                    while ((size = input.read(buffer)) != -1) {
                        output.write(buffer, 0, size);
                    }
                }
                finally {
                    output.close();
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        finally {
            ((InputStream)input).close();
        }
    }

    private static byte[] toBytes(Properties props) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Util.store(out, props);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Util.unsupported(e, "Class '%s' cannot be instantiated; see the cause below in the stack trace", clazz.getCanonicalName());
        }
    }

    public static <T> List<T> newInstance(Class<? extends T>[] classes, List<T> result) {
        for (Class<? extends T> clazz : classes) {
            result.add(Util.newInstance(clazz));
        }
        return result;
    }

    public static interface SystemProvider {
        public String getProperty(String var1);

        public Map<String, String> getenv();

        public Properties getProperties();
    }

    public static interface TimeProvider {
        public long getTime();
    }
}

