/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.gameserver;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.dao.GameServerDAO;
import com.l2jserver.cli.model.ServerNames;
import de.vandermeer.asciitable.AsciiTable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"l"}, description={"Lists all game servers from login server."})
public class GameServerListCommand
extends AbstractCommand {
    private static final String IN_USE = "In Use";
    private static final String FREE = "Free";
    @CommandLine.Option(names={"-u", "--used-only"}, description={"List servers in use only."}, defaultValue="false")
    private boolean usedOnly = false;

    @Override
    public void run() {
        try {
            this.listGameServers();
        }
        catch (Exception ex) {
            System.err.println("There has been an error listing the game servers!");
            ex.printStackTrace();
        }
    }

    private void listGameServers() throws SQLException {
        AsciiTable at = new AsciiTable();
        at.addRule();
        at.addRow(new Object[]{"Id", "Name", "Status"});
        at.addRule();
        Set<Integer> gameservers = GameServerDAO.getInstance().gameServers();
        for (Map.Entry<Integer, String> gs : ServerNames.getServers().entrySet()) {
            boolean inUse = gameservers.contains(gs.getKey());
            if (this.usedOnly && !inUse) continue;
            at.addRow(new Object[]{gs.getKey(), gs.getValue(), inUse ? IN_USE : FREE});
            at.addRule();
        }
        System.out.println(at.render());
    }
}

