/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.gameserver;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.dao.GameServerDAO;
import com.l2jserver.cli.model.ServerNames;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="register", aliases={"r"}, description={"Adds a game server to the login server."})
public class GameServerRegisterCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-fb", "--fallback"}, description={"If during registration the specified game server Id is in use, an attempt with the first available Id will be made."})
    private boolean fallback;
    @CommandLine.Option(names={"-f", "--force"}, description={"Forces a game server register operation to overwrite a previous registration on the specified Id, if necessary."})
    private boolean force = false;
    @CommandLine.Option(names={"-id"}, description={"Game Server Id."})
    private Integer id;
    @CommandLine.Option(names={"-o", "--output"}, description={"Path where the file will be saved."}, defaultValue=".")
    private File outputPath = new File(".");

    @Override
    public void run() {
        try {
            this.register();
        }
        catch (Exception ex) {
            System.err.println("There has been an error registering a Game Server!");
            ex.printStackTrace();
        }
    }

    private void register() throws SQLException, IOException, NoSuchAlgorithmException {
        Set<Integer> gameservers;
        block5: {
            block4: {
                gameservers = GameServerDAO.getInstance().gameServers();
                if (!this.force) break block4;
                if (this.id == null) {
                    System.err.println("A Game Server Id must be specified when using --force!");
                    return;
                }
                if (!gameservers.contains(this.id)) break block5;
                GameServerDAO.getInstance().unregister(this.id);
                gameservers.remove(this.id);
                break block5;
            }
            if (this.fallback && (this.id == null || gameservers.contains(this.id))) {
                for (Map.Entry<Integer, String> gs : ServerNames.getServers().entrySet()) {
                    if (gameservers.contains(gs.getKey())) continue;
                    this.id = gs.getKey();
                    break;
                }
            }
        }
        if (gameservers.contains(this.id)) {
            System.err.println("The Id " + this.id + " is in use!");
            return;
        }
        GameServerRegisterCommand.registerGameServer(this.id, this.outputPath);
    }

    public static void registerGameServer(int id, File outputPath) throws IOException, SQLException, NoSuchAlgorithmException {
        byte[] hexId = GameServerRegisterCommand.generateHex();
        GameServerDAO.getInstance().register(hexId, id, "");
        Properties hexSetting = new Properties();
        File file = new File(outputPath, "hexid.txt");
        file.createNewFile();
        try (FileOutputStream out = new FileOutputStream(file);){
            hexSetting.setProperty("ServerID", String.valueOf(id));
            hexSetting.setProperty("HexID", new BigInteger(hexId).toString(16));
            hexSetting.store(out, "The HexId to Auth into LoginServer");
        }
        System.out.println("Registered Game Server Id " + id + ".");
    }

    private static byte[] generateHex() throws NoSuchAlgorithmException {
        byte[] bytes = new byte[16];
        SecureRandom.getInstanceStrong().nextBytes(bytes);
        return bytes;
    }
}

