/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.gameserver;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.dao.GameServerDAO;
import picocli.CommandLine;

@CommandLine.Command(name="unregister", aliases={"u"}, description={"Removes a game server from the login server."})
public class GameServerUnregisterCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-a", "--all"}, description={"If true, all Game Servers will be unregistered."}, defaultValue="false")
    private boolean all = false;
    @CommandLine.Option(names={"-id"}, description={"Game Server Id."})
    private Integer id;

    @Override
    public void run() {
        try {
            if (this.all) {
                GameServerDAO.getInstance().unregisterAll();
                System.out.println("Unregistered all Game Servers.");
            } else {
                if (this.id == null) {
                    System.err.println("The Game Server Id is required!");
                    return;
                }
                GameServerDAO.getInstance().unregister(this.id);
                System.out.println("Unregistered Game Server Id " + this.id + ".");
            }
        }
        catch (Exception ex) {
            System.err.println("There has been an error unregistering " + (String)(this.all ? "all servers!" : this.id + " game server!"));
            ex.printStackTrace();
        }
    }
}

