/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.util;

import java.time.Duration;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.slf4j.Logger;

public class LoggerProgressMonitor
extends BatchingProgressMonitor {
    private final Logger log;

    public LoggerProgressMonitor(Logger log) {
        this.log = log;
    }

    protected void onUpdate(String taskName, int workCurr, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        this.send(s);
    }

    protected void onEndTask(String taskName, int workCurr, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int workCurr) {
        s.append("\r");
        s.append(taskName);
        s.append(": ");
        while (s.length() < 25) {
            s.append(' ');
        }
        s.append(workCurr);
    }

    protected void onUpdate(String taskName, int workCurr, int workTotal, int percentDone, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr, workTotal, percentDone);
        this.send(s);
    }

    protected void onEndTask(String taskName, int workCurr, int workTotal, int percentDone, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr, workTotal, percentDone);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int cmp, int totalWork, int pcnt) {
        s.append("\r");
        s.append(taskName);
        s.append(": ");
        while (s.length() < 25) {
            s.append(' ');
        }
        String endStr = String.valueOf(totalWork);
        StringBuilder curStr = new StringBuilder(String.valueOf(cmp));
        while (curStr.length() < endStr.length()) {
            curStr.insert(0, " ");
        }
        if (pcnt < 100) {
            s.append(' ');
        }
        if (pcnt < 10) {
            s.append(' ');
        }
        s.append(pcnt);
        s.append("% (");
        s.append((CharSequence)curStr);
        s.append("/");
        s.append(endStr);
        s.append(")");
    }

    private void send(StringBuilder s) {
        this.log.info(s.toString());
    }
}

