/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gui.editor;

import com.l2jserver.gui.editor.JIPTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class ConfigUserInterface
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 2609592249095305857L;
    private static final String IMAGE_PATH = "/images/";
    private static final String EOL = System.lineSeparator();
    private final JTabbedPane _tabPane = new JTabbedPane();
    private final JFileChooser fileChooser;
    private List<ConfigFile> _configs = new ArrayList<ConfigFile>();

    public ConfigUserInterface() {
        this.setTitle("Server Configuration Tool");
        this.setDefaultCloseOperation(3);
        this.setSize(750, 500);
        this.setLayout(new GridBagLayout());
        ConfigUserInterface.setDefaultLookAndFeelDecorated(true);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/images/l2j.png")).getImage());
        this.fileChooser = new JFileChooser("Open");
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setCurrentDirectory(new File("."));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setActionCommand("exit");
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setIcon(new ImageIcon(this.getClass().getResource("/images/help.png")));
        aboutItem.setActionCommand("about");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        menubar.add(fileMenu);
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this.createToolButton("disk.png", "Save", "save"));
        this.add((Component)toolBar, cons);
        ++cons.gridy;
        cons.fill = 1;
        cons.weighty = 1.0;
        this.loadConfigs();
        this.buildInterface();
        this.add((Component)this._tabPane, cons);
    }

    private JButton createToolButton(String image, String text, String action) {
        JButton button = new JButton(text, new ImageIcon(this.getClass().getResource(IMAGE_PATH + image)));
        button.setActionCommand(action);
        button.addActionListener(this);
        return button;
    }

    private void buildInterface() {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 0;
        cons.anchor = 23;
        cons.insets = new Insets(2, 2, 2, 2);
        for (ConfigFile cf : this.getConfigs()) {
            JPanel panel = new JPanel(){
                private static final long serialVersionUID = -323928678804839054L;

                @Override
                public void scrollRectToVisible(Rectangle r) {
                }
            };
            panel.setLayout(new GridBagLayout());
            cons.gridy = 0;
            cons.weighty = 0.0;
            for (ConfigFile.ConfigComment cc : cf.getConfigProperties()) {
                if (!(cc instanceof ConfigFile.ConfigProperty)) continue;
                ConfigFile.ConfigProperty cp = (ConfigFile.ConfigProperty)cc;
                cons.gridx = 0;
                JLabel keyLabel = new JLabel(cp.getDisplayName() + ":", new ImageIcon(this.getClass().getResource("/images/help.png")), 2);
                Object comments = "<b>" + cp.getName() + ":</b><br>" + cp.getComments();
                comments = ((String)comments).replace(EOL, "<br>");
                comments = "<html>" + (String)comments + "</html>";
                keyLabel.setToolTipText((String)comments);
                cons.weightx = 0.0;
                panel.add((Component)keyLabel, cons);
                ++cons.gridx;
                JComponent valueComponent = cp.getValueComponent();
                valueComponent.setToolTipText((String)comments);
                cons.weightx = 1.0;
                panel.add((Component)valueComponent, cons);
                ++cons.gridx;
                ++cons.gridy;
            }
            ++cons.gridy;
            cons.weighty = 1.0;
            panel.add((Component)new JLabel(), cons);
            this._tabPane.addTab(cf.getName(), new JScrollPane(panel));
        }
    }

    private void loadConfigs() {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            JOptionPane.showMessageDialog(this, "Must select a configuration folder!", "Error", 0);
            return;
        }
        File configsDir = this.fileChooser.getSelectedFile();
        File[] files = configsDir.listFiles();
        if (files == null) {
            JOptionPane.showMessageDialog(this, "Error reading config", "Error", 0);
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".properties") || !file.isFile() || !file.canWrite()) continue;
            try {
                this.parsePropertiesFile(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error reading " + file.getName(), "Error", 0);
                System.exit(3);
            }
        }
    }

    private void parsePropertiesFile(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader(fis);
             LineNumberReader lnr = new LineNumberReader(isr);){
            String line;
            StringBuilder commentBuffer = new StringBuilder();
            ConfigFile cf = new ConfigFile(file);
            while ((line = lnr.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) {
                    if (commentBuffer.length() > 0) {
                        cf.addConfigComment(commentBuffer.toString());
                    }
                    commentBuffer.setLength(0);
                    continue;
                }
                if (line.charAt(0) == '#') {
                    if (commentBuffer.length() > 0) {
                        commentBuffer.append(EOL);
                    }
                    commentBuffer.append(line.substring(1));
                    continue;
                }
                if (line.indexOf(61) < 0) continue;
                String[] kv = line.split("=", 2);
                String key = kv[0].trim();
                StringBuilder value = new StringBuilder();
                if (kv.length > 1) {
                    value.append(kv[1].trim());
                }
                if (line.indexOf(92) >= 0) {
                    while ((line = lnr.readLine()) != null && line.indexOf(92) >= 0) {
                        value.append(EOL + line);
                    }
                    value.append(EOL + line);
                }
                String comments = commentBuffer.toString();
                commentBuffer.setLength(0);
                cf.addConfigProperty(key, this.parseValue(value.toString()), comments);
            }
            this.getConfigs().add(cf);
        }
    }

    private Object parseValue(String value) {
        String[] parts;
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            return Boolean.parseBoolean(value);
        }
        if (value.equals("localhost")) {
            value = "127.0.0.1";
        }
        if ((parts = value.split("\\.")).length == 4) {
            boolean ok = true;
            for (int i = 0; i < 4 && ok; ++i) {
                try {
                    int parseInt = Integer.parseInt(parts[i]);
                    if (parseInt >= 0 && parseInt <= 255) continue;
                    ok = false;
                    continue;
                }
                catch (NumberFormatException e) {
                    ok = false;
                }
            }
            if (ok) {
                try {
                    InetAddress address = InetAddress.getByName(value);
                    return address;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        StringBuilder errors = new StringBuilder();
        if (cmd.equals("save")) {
            for (ConfigFile cf : this.getConfigs()) {
                try {
                    cf.save();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    errors.append("Error saving" + cf.getName() + ".properties. Reason:" + e1.getLocalizedMessage() + EOL);
                }
            }
            if (errors.length() == 0) {
                JOptionPane.showMessageDialog(this, "Configuration saved successfully", "OK", 1);
            } else {
                JOptionPane.showMessageDialog(this, errors, "Error", 0);
                System.exit(2);
            }
        } else if (cmd.equals("exit")) {
            System.exit(0);
        } else if (cmd.equals("about")) {
            JOptionPane.showMessageDialog(this, "\u00a9 2019 L2J Team. All rights reserved." + EOL + "http://www.l2jserver.com" + EOL + EOL + "Icons by http://www.famfamfam.com" + EOL + EOL + "Language: English" + EOL + "Translation: L2J Team", "About", 1, new ImageIcon(this.getClass().getResource("/images/l2jserverlogo.png")));
        }
    }

    public void setConfigs(List<ConfigFile> configs) {
        this._configs = configs;
    }

    public List<ConfigFile> getConfigs() {
        return this._configs;
    }

    public static String unCamelize(String keyName) {
        Pattern p = Pattern.compile("\\p{Lu}");
        Matcher m = p.matcher(keyName);
        StringBuffer sb = new StringBuffer();
        int last = 0;
        while (m.find()) {
            if (m.start() != last + 1) {
                m.appendReplacement(sb, " " + m.group());
            }
            last = m.start();
        }
        m.appendTail(sb);
        return sb.toString().trim();
    }

    static class ConfigFile {
        private final File _file;
        private String _name;
        private final List<ConfigComment> _configs = new ArrayList<ConfigComment>();

        public ConfigFile(File file) {
            this._file = file;
            int lastIndex = file.getName().lastIndexOf(46);
            this.setName(file.getName().substring(0, lastIndex));
        }

        public void addConfigProperty(String name, Object value, ValueType type, String comments) {
            this._configs.add(new ConfigProperty(this, name, value, type, comments));
        }

        public void addConfigComment(String comment) {
            this._configs.add(new ConfigComment(this, comment));
        }

        public void addConfigProperty(String name, Object value, String comments) {
            this.addConfigProperty(name, value, ValueType.firstTypeMatch(value), comments);
        }

        public List<ConfigComment> getConfigProperties() {
            return this._configs;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void save() throws IOException {
            try (FileOutputStream fos = new FileOutputStream(this._file);
                 OutputStreamWriter osw = new OutputStreamWriter(fos);
                 BufferedWriter bufWriter = new BufferedWriter(osw);){
                for (ConfigComment cc : this._configs) {
                    cc.save(bufWriter);
                }
            }
        }

        class ConfigProperty
        extends ConfigComment {
            private String _propname;
            private Object _value;
            private ValueType _type;
            private JComponent _component;

            public ConfigProperty(ConfigFile this$0, String name, Object value, ValueType type, String comments) {
                super(this$0, comments);
                if (!type.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Value Instance Type doesn't match the type argument.");
                }
                this._propname = name;
                this._type = type;
                this._value = value;
            }

            public String getName() {
                return this._propname;
            }

            public String getDisplayName() {
                return ConfigUserInterface.unCamelize(this._propname);
            }

            public void setName(String name) {
                this._propname = name;
            }

            public Object getValue() {
                return this._value;
            }

            public void setValue(String value) {
                this._value = value;
            }

            public ValueType getType() {
                return this._type;
            }

            public void setType(ValueType type) {
                this._type = type;
            }

            public JComponent getValueComponent() {
                if (this._component == null) {
                    this._component = this.createValueComponent();
                }
                return this._component;
            }

            public JComponent createValueComponent() {
                switch (this.getType().ordinal()) {
                    case 0: {
                        boolean bool = (Boolean)this.getValue();
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(bool);
                        return checkBox;
                    }
                    case 3: {
                        return new JIPTextField((Inet4Address)this.getValue());
                    }
                }
                String val = this.getValue().toString();
                JTextArea textArea = new JTextArea(val);
                textArea.setFont(UIManager.getFont("TextField.font"));
                int rows = 1;
                for (int i = 0; i < val.length(); ++i) {
                    if (val.charAt(i) != '\\') continue;
                    ++rows;
                }
                textArea.setRows(rows);
                textArea.setColumns(Math.max(val.length() / rows, 20));
                return textArea;
            }

            @Override
            public void save(Writer writer) throws IOException {
                Object value;
                if (this.getValueComponent() instanceof JCheckBox) {
                    value = Boolean.toString(((JCheckBox)this.getValueComponent()).isSelected());
                    value = ((String)value).substring(0, 1).toUpperCase() + ((String)value).substring(1);
                } else if (this.getValueComponent() instanceof JIPTextField) {
                    value = ((JIPTextField)this.getValueComponent()).getText();
                } else if (this.getValueComponent() instanceof JTextArea) {
                    value = ((JTextArea)this.getValueComponent()).getText();
                } else {
                    throw new IllegalStateException("Unhandled component value");
                }
                StringBuilder sb = new StringBuilder();
                sb.append('#');
                sb.append(this.getComments().replace(EOL, EOL + "#"));
                sb.append(EOL);
                sb.append(this.getName());
                sb.append(" = ");
                sb.append((String)value);
                sb.append(EOL);
                sb.append(EOL);
                writer.write(sb.toString());
            }
        }

        class ConfigComment {
            private String _comments;

            public ConfigComment(ConfigFile this$0, String comments) {
                this._comments = comments;
            }

            public String getComments() {
                return this._comments;
            }

            public void setComments(String comments) {
                this._comments = comments;
            }

            public void save(Writer writer) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append('#');
                sb.append(this.getComments().replace(EOL, EOL + "#"));
                sb.append(EOL + EOL);
                writer.write(sb.toString());
            }
        }
    }

    public static enum ValueType {
        BOOLEAN(Boolean.class),
        DOUBLE(Double.class),
        INTEGER(Integer.class),
        IPv4(Inet4Address.class),
        STRING(String.class);

        private final Class<?> _type;

        private ValueType(Class<?> type) {
            this._type = type;
        }

        public Class<?> getType() {
            return this._type;
        }

        public static ValueType firstTypeMatch(Object value) {
            for (ValueType vt : ValueType.values()) {
                if (vt.getType() != value.getClass()) continue;
                return vt;
            }
            throw new NoSuchElementException("No match for: " + value.getClass().getName());
        }
    }
}

