/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.account;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.dao.AccountDAO;
import picocli.CommandLine;

@CommandLine.Command(name="update")
public class AccountUpdateCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-u", "--username"}, required=true, description={"Username"})
    private String username;
    @CommandLine.Option(names={"-p", "--password"}, interactive=true, description={"Password"})
    private String password;
    @CommandLine.Option(names={"-a", "--access-level"}, description={"Access Level"})
    private Integer accessLevel;

    @Override
    public void run() {
        System.out.println("Updating account " + this.username + " (" + this.accessLevel + ")");
        if (this.password != null && this.accessLevel != null) {
            boolean createdUpdated = AccountDAO.getInstance().upsert(this.username, this.password, this.accessLevel);
            if (createdUpdated) {
                System.out.println("Account " + this.username + " has been created or updated.");
            }
            return;
        }
        if (this.accessLevel != null) {
            boolean updated = AccountDAO.getInstance().changeAccountLevel(this.username, this.accessLevel);
            if (updated) {
                System.out.println("Account " + this.username + " has been updated.");
            } else {
                System.out.println("Account " + this.username + " does not exist!");
            }
        }
    }
}

