/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.command.database;

import com.l2jserver.cli.command.AbstractCommand;
import com.l2jserver.cli.config.Configuration;
import com.l2jserver.cli.dao.AbstractDatabaseDAO;
import com.l2jserver.cli.dao.GameServerDatabaseDAO;
import com.l2jserver.cli.dao.LoginServerDatabaseDAO;
import com.l2jserver.cli.model.DatabaseInstallType;
import com.l2jserver.cli.model.ServerType;
import com.l2jserver.cli.util.CloseShieldInputStreamReader;
import java.io.File;
import java.util.Scanner;
import org.aeonbits.owner.Mutable;
import picocli.CommandLine;

@CommandLine.Command(name="install")
public class DatabaseInstallCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-sql"}, required=true, description={"SQL Files location"})
    private String path;
    @CommandLine.Option(names={"-url"}, description={"Database URL"})
    private String url;
    @CommandLine.Option(names={"-db"}, description={"Database Name"})
    private String name;
    @CommandLine.Option(names={"-u"}, description={"Database User"})
    private String user;
    @CommandLine.Option(names={"-p"}, description={"Database Password"})
    private String password;
    @CommandLine.Option(names={"-m"}, required=true, description={"Database installation mode"})
    private DatabaseInstallType mode;
    @CommandLine.Option(names={"-t"}, required=true, description={"Server Type"})
    private ServerType serverType;
    @CommandLine.Option(names={"-c"}, description={"Custom Tables"})
    private boolean customs;
    @CommandLine.Option(names={"-mods"}, description={"Mods Tables"})
    private boolean mods;

    @Override
    public void run() {
        File sqlPath = new File(this.path);
        if (!sqlPath.exists()) {
            System.err.println("The path does not exist!");
            return;
        }
        AbstractDatabaseDAO databaseDAO = this.databaseDAO();
        try {
            if (this.mode == DatabaseInstallType.FULL) {
                databaseDAO.createDatabase();
            }
        }
        catch (Exception ex) {
            System.out.print("Seems database already exists, do you want to continue installing? (y/N): ");
            try (Scanner reader = new Scanner(new CloseShieldInputStreamReader(System.in));){
                String input = reader.next();
                if (!"y".equalsIgnoreCase(input) && !"yes".equalsIgnoreCase(input)) {
                    return;
                }
            }
        }
        databaseDAO.createDump();
        databaseDAO.updates(this.mode, sqlPath);
        databaseDAO.basic(sqlPath);
        if (this.customs) {
            databaseDAO.custom(sqlPath);
        }
        if (this.mods) {
            databaseDAO.mods(sqlPath);
        }
        System.out.println("Database installation complete.");
    }

    private AbstractDatabaseDAO databaseDAO() {
        return switch (this.serverType) {
            default -> throw new MatchException(null, null);
            case ServerType.GAME -> {
                this.overrideConfigs(Configuration.gameServer());
                yield new GameServerDatabaseDAO();
            }
            case ServerType.LOGIN -> {
                this.overrideConfigs(Configuration.loginServer());
                yield new LoginServerDatabaseDAO();
            }
        };
    }

    private void overrideConfigs(Mutable databaseConfiguration) {
        if (this.url != null) {
            databaseConfiguration.setProperty("DatabaseURL", this.url);
        }
        if (this.user != null) {
            databaseConfiguration.setProperty("DatabaseUser", this.user);
        }
        if (this.password != null) {
            databaseConfiguration.setProperty("DatabasePassword", this.password);
        }
        if (this.name != null) {
            databaseConfiguration.setProperty("DatabaseName", this.name);
        }
    }
}

