/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.dao;

import com.l2jserver.cli.config.ServerConfiguration;
import com.l2jserver.cli.database.ConnectionFactory;
import com.l2jserver.cli.util.FileWriterStdout;
import com.l2jserver.cli.util.SQLFilter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

class AbstractDAO {
    private static final String CREATE_DATABASE = "CREATE DATABASE ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private final ConnectionFactory connectionFactory;
    private final String database;

    AbstractDAO(ServerConfiguration server) {
        this.database = server.getDatabaseName();
        this.connectionFactory = ConnectionFactory.builder().withDatabaseName(server.getDatabaseName()).withUrl(server.getDatabaseURL()).withUser(server.getDatabaseUser()).withPassword(server.getDatabasePassword()).build();
    }

    public String getDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return this.connectionFactory.getConnection();
    }

    public void createDatabase() throws SQLException {
        try (Connection con = this.connectionFactory.getPlainConnection();
             Statement st = con.createStatement();){
            st.executeUpdate(CREATE_DATABASE + this.database);
        }
    }

    public void executeSQLScript(File file) {
        String line = "";
        try (Connection con = this.getConnection();
             Statement stmt = con.createStatement();
             Scanner scn = new Scanner(file);){
            StringBuilder sb = new StringBuilder();
            while (scn.hasNextLine()) {
                line = scn.nextLine();
                if (line.startsWith("--")) continue;
                if (line.contains("--")) {
                    line = line.split("--")[0];
                }
                if (!(line = line.trim()).isEmpty()) {
                    sb.append(line).append(System.lineSeparator());
                }
                if (!line.endsWith(";")) continue;
                stmt.execute(sb.toString());
                sb = new StringBuilder();
            }
        }
        catch (Exception ex) {
            System.err.println("There has been an error executing file " + file.getName() + "!");
            ex.printStackTrace();
        }
    }

    public void executeDirectoryOfSQLScripts(File dir, boolean skipErrors) {
        Object[] files = dir.listFiles(new SQLFilter());
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (skipErrors) {
                    try {
                        this.executeSQLScript((File)file);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                this.executeSQLScript((File)file);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void createDump() {
        try {
            con = this.getConnection();
            try {
                s = con.createStatement();
                try {
                    rset = s.executeQuery("SHOW TABLES");
                    try {
                        fileName = this.database + "_dump_" + AbstractDAO.DATE_TIME_FORMATTER.format(LocalDateTime.now()) + ".sql";
                        dump = new File("dumps", fileName);
                        new File("dumps").mkdir();
                        dump.createNewFile();
                        if (rset.last()) {
                            rset.beforeFirst();
                        }
                        fileWriter = new FileWriter(dump);
                        try {
                            fws = new FileWriterStdout(fileWriter);
lbl19:
                            // 3 sources

                            try {
                                while (rset.next()) {
                                    fws.println("CREATE TABLE `" + rset.getString(1) + "`");
                                    fws.println("(");
                                    desc = con.createStatement();
                                    try {
                                        dset = desc.executeQuery("DESC " + rset.getString(1));
                                        try {
                                            keys = new HashMap<String, ArrayList<E>>();
                                            isFirst = true;
                                            while (dset.next()) {
                                                if (!isFirst) {
                                                    fws.println(",");
                                                }
                                                fws.print("\t`" + dset.getString(1) + "`");
                                                fws.print(" " + dset.getString(2));
                                                if (dset.getString(3).equals("NO")) {
                                                    fws.print(" NOT NULL");
                                                }
                                                if (!dset.getString(4).isEmpty()) {
                                                    if (!keys.containsKey(dset.getString(4))) {
                                                        keys.put(dset.getString(4), new ArrayList<E>());
                                                    }
                                                    ((List)keys.get(dset.getString(4))).add(dset.getString(1));
                                                }
                                                if (dset.getString(5) != null) {
                                                    fws.print(" DEFAULT '" + dset.getString(5) + "'");
                                                }
                                                if (!dset.getString(6).isEmpty()) {
                                                    fws.print(" " + dset.getString(6));
                                                }
                                                isFirst = false;
                                            }
                                            if (keys.containsKey("PRI")) {
                                                fws.println(",");
                                                fws.print("\tPRIMARY KEY (");
                                                isFirst = true;
                                                for (String key : (List)keys.get("PRI")) {
                                                    if (!isFirst) {
                                                        fws.print(", ");
                                                    }
                                                    fws.print("`" + key + "`");
                                                    isFirst = false;
                                                }
                                                fws.print(")");
                                            }
                                            if (keys.containsKey("MUL")) {
                                                fws.println(",");
                                                isFirst = true;
                                                for (String key : (List)keys.get("MUL")) {
                                                    if (!isFirst) {
                                                        fws.println(", ");
                                                    }
                                                    fws.print("\tKEY `key_" + key + "` (`" + key + "`)");
                                                    isFirst = false;
                                                }
                                            }
                                            fws.println();
                                            fws.println(");");
                                            fws.flush();
                                        }
                                        finally {
                                            if (dset != null) {
                                                dset.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (desc != null) {
                                            desc.close();
                                        }
                                    }
                                    desc = con.createStatement();
                                    try {
                                        dset = desc.executeQuery("SELECT * FROM " + rset.getString(1));
                                        try {
                                            isFirst = true;
                                            cnt = 0;
                                            while (dset.next()) {
                                                if (cnt % 100 == 0) {
                                                    fws.println("INSERT INTO `" + rset.getString(1) + "` VALUES ");
                                                } else {
                                                    fws.println(",");
                                                }
                                                fws.print("\t(");
                                                isInFirst = true;
                                                for (i = 1; i <= dset.getMetaData().getColumnCount(); ++i) {
                                                    if (!isInFirst) {
                                                        fws.print(", ");
                                                    }
                                                    if (dset.getString(i) == null) {
                                                        fws.print("NULL");
                                                    } else {
                                                        fws.print("'" + dset.getString(i).replace("'", "\\'") + "'");
                                                    }
                                                    isInFirst = false;
                                                }
                                                fws.print(")");
                                                isFirst = false;
                                                if (cnt % 100 == 99) {
                                                    fws.println(";");
                                                }
                                                ++cnt;
                                            }
                                            if (!isFirst && cnt % 100 != 0) {
                                                fws.println(";");
                                            }
                                            fws.println();
                                            fws.flush();
                                        }
                                        finally {
                                            if (dset == null) ** GOTO lbl19
                                            dset.close();
                                        }
                                    }
                                    finally {
                                        if (desc == null) ** GOTO lbl19
                                        desc.close();
                                    }
                                }
                                fws.flush();
                            }
                            finally {
                                fws.close();
                            }
                        }
                        finally {
                            fileWriter.close();
                        }
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception ex) {
            System.err.println("There has been an error creating a database backup for " + this.database + "!");
            ex.printStackTrace();
        }
    }
}

