/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.dao;

import com.l2jserver.cli.config.ServerConfiguration;
import com.l2jserver.cli.dao.AbstractDAO;
import com.l2jserver.cli.model.DatabaseInstallType;
import com.l2jserver.cli.util.SQLFilter;
import java.io.File;
import java.util.Arrays;
import java.util.prefs.Preferences;

public abstract class AbstractDatabaseDAO
extends AbstractDAO {
    AbstractDatabaseDAO(ServerConfiguration server) {
        super(server);
    }

    public void mods(File sqlPath) {
        File modsPath = new File(sqlPath, "mods");
        if (modsPath.exists()) {
            System.out.println("Installing mod tables...");
            this.runSQLFiles(modsPath.listFiles(new SQLFilter()));
        }
    }

    public void custom(File sqlPath) {
        File customPath = new File(sqlPath, "custom");
        if (customPath.exists()) {
            System.out.println("Installing custom tables...");
            this.runSQLFiles(customPath.listFiles(new SQLFilter()));
        }
    }

    public void basic(File sqlPath) {
        System.out.println("Installing basic SQL scripts...");
        File[] files = sqlPath.listFiles(new SQLFilter());
        this.runSQLFiles(files);
    }

    protected void updates(DatabaseInstallType mode, String cleanup, File sqlPath) {
        Preferences userPreferences = Preferences.userRoot();
        File updatePath = new File(sqlPath, "updates");
        String updatePreferences = this.getDatabase() + "_update";
        switch (mode) {
            case FULL: {
                System.out.println("Executing cleanup script...");
                this.runSQLFiles(new File(sqlPath, cleanup));
                if (!updatePath.exists()) break;
                StringBuilder sb = new StringBuilder();
                for (File sqlFile : updatePath.listFiles(new SQLFilter())) {
                    sb.append(sqlFile.getName() + ";");
                }
                userPreferences.put(updatePreferences, sb.toString());
                break;
            }
            case UPDATE: {
                System.out.println("Installing update SQL scripts...");
                String updated = userPreferences.get(updatePreferences, "");
                if (!updatePath.exists()) break;
                for (File sqlFile : updatePath.listFiles(new SQLFilter())) {
                    if (updated.contains(sqlFile.getName())) continue;
                    try {
                        System.out.println("Installing " + sqlFile.getName() + "...");
                        this.executeSQLScript(sqlFile);
                    }
                    catch (Exception ex) {
                        System.err.println("There has been an error executing SQL update!");
                        ex.printStackTrace();
                        return;
                    }
                    userPreferences.put(updatePreferences, updated + sqlFile.getName() + ";");
                }
                break;
            }
        }
    }

    public void updates(DatabaseInstallType mode, File sqlPath) {
        this.updates(mode, "cleanup/cleanup.sql", sqlPath);
    }

    private void runSQLFiles(File ... sqlFiles) {
        Arrays.sort(sqlFiles);
        for (File sqlFile : sqlFiles) {
            try {
                System.out.println("Running " + sqlFile.getName() + "...");
                this.executeSQLScript(sqlFile);
            }
            catch (Exception ex) {
                System.err.println("There has been an error executing SQL file " + sqlFile.getName() + "!");
                ex.printStackTrace();
            }
        }
    }
}

