/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.dao;

import com.l2jserver.cli.config.Configuration;
import com.l2jserver.cli.dao.AbstractDAO;
import com.l2jserver.cli.model.AccountListType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class AccountDAO
extends AbstractDAO {
    private static final String REPLACE_ACCOUNT = "REPLACE accounts(login, password, accessLevel) VALUES (?, ?, ?)";
    private static final String DELETE_ACCOUNT = "DELETE FROM accounts WHERE login = ?";
    private static final String UPDATE_ACCOUNT_LEVEL = "UPDATE accounts SET accessLevel = ? WHERE login = ?";
    private static final String[] SELECT_ACCOUNTS = new String[]{"SELECT login, accessLevel FROM accounts ORDER BY login", "SELECT login, accessLevel FROM accounts WHERE accessLevel < 0 ORDER BY login", "SELECT login, accessLevel FROM accounts WHERE accessLevel > 0 ORDER BY login", "SELECT login, accessLevel FROM accounts WHERE accessLevel = 0 ORDER BY login"};
    private static final String ALGORITHM = "SHA";

    private AccountDAO() {
        super(Configuration.loginServer());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean upsert(String username, String password, int accessLevel) {
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = con.prepareStatement(REPLACE_ACCOUNT);
                try {
                    MessageDigest md = MessageDigest.getInstance(ALGORITHM);
                    byte[] newPassword = md.digest(password.getBytes(StandardCharsets.UTF_8));
                    ps.setString(1, username);
                    ps.setString(2, Base64.getEncoder().encodeToString(newPassword));
                    ps.setInt(3, accessLevel);
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (Exception ex) {
            System.out.println("There was error while creating/updating account " + username + "!");
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean changeAccountLevel(String username, int accessLevel) {
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = con.prepareStatement(UPDATE_ACCOUNT_LEVEL);
                try {
                    ps.setInt(1, accessLevel);
                    ps.setString(2, username);
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (Exception ex) {
            System.out.println("There was error while updating account " + username + " level!");
            return false;
        }
    }

    public Map<String, Integer> listAccounts(AccountListType accountListType) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(SELECT_ACCOUNTS[accountListType.ordinal()]);){
            while (rs.next()) {
                result.put(rs.getString("login"), rs.getInt("accessLevel"));
            }
        }
        catch (Exception ex) {
            System.out.println("There was error while listing " + accountListType.name().toLowerCase() + " accounts!");
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean delete(String username) {
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = con.prepareStatement(DELETE_ACCOUNT);
                try {
                    ps.setString(1, username);
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (Exception ex) {
            System.out.println("There was error while deleting account " + username + "!");
            return false;
        }
    }

    public static AccountDAO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final AccountDAO INSTANCE = new AccountDAO();

        private SingletonHolder() {
        }
    }
}

