/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.cli.database;

import com.l2jserver.cli.database.DatabaseType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class ConnectionFactory {
    private final String url;
    private final String databaseName;
    private final Properties properties = new Properties();

    private ConnectionFactory(Builder builder) {
        this.url = builder.url;
        this.databaseName = builder.databaseName;
        this.properties.setProperty("user", builder.user);
        this.properties.setProperty("password", builder.password);
        this.properties.putAll((Map<?, ?>)DatabaseType.getType(builder.url).getParameters());
    }

    public Connection getPlainConnection() {
        try {
            return DriverManager.getConnection(this.url, this.properties);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Connection getConnection() {
        try {
            Connection con = DriverManager.getConnection(this.url + "/" + this.databaseName, this.properties);
            con.setCatalog(this.databaseName);
            return con;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String url;
        private String user;
        private String password;
        private String databaseName;

        private Builder() {
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public ConnectionFactory build() {
            return new ConnectionFactory(this);
        }
    }
}

