DROP TABLE IF EXISTS `spawnlist`;
CREATE TABLE `spawnlist` (
  `location` varchar(40) NOT NULL DEFAULT '',
  `count` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `npc_templateid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `locx` mediumint(6) NOT NULL DEFAULT '0',
  `locy` mediumint(6) NOT NULL DEFAULT '0',
  `locz` mediumint(6) NOT NULL DEFAULT '0',
  `randomx` mediumint(6) NOT NULL DEFAULT '0',
  `randomy` mediumint(6) NOT NULL DEFAULT '0',
  `heading` mediumint(6) NOT NULL DEFAULT '0',
  `respawn_delay` mediumint(5) NOT NULL DEFAULT '0',
  `respawn_random` mediumint(5) NOT NULL DEFAULT '0',
  `loc_id` int(9) NOT NULL DEFAULT '0',
  `periodOfDay` tinyint(1) unsigned NOT NULL DEFAULT '0',
 PRIMARY KEY (`npc_templateid`,`locx`,`locy`,`locz`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `spawnlist` VALUES
-- [12_24]

-- Red Star Stone
("unset", 1, 18684, -246875, 219422, 5187, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18685, -244980, 217986, 4050, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -247254, 219422, 5221, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18686, -246875, 219422, 5187, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -246496, 218704, 5302, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -245738, 219422, 3517, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -248012, 215114, 4357, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -248770, 217986, 4858, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18690, -233159, 208943, 4962, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18691, -233159, 208539, 5007, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -233723, 209347, 4907, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -253796, 227892, 2893, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18692, -237107, 207327, 5257, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -236543, 208539, 5307, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -239927, 208539, 4875, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -232595, 208943, 5296, 0, 0, 0, 60, 0, 0, 0),

-- [12_25]

-- Red Star Stone
("unset", 1, 18684, -230881, 238048, 2951, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18686, -248155, 234778, 3102, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18687, -249275, 235195, 2520, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -250377, 232360, 2797, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -253234, 244508, 4273, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -255434, 243993, 4937, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -254114, 247083, 4517, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -256314, 247083, 5493, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -250928, 236410, 3884, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18688, -252794, 242448, 5226, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -253234, 244508, 4273, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -253674, 245538, 5036, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -255434, 242448, 5203, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -252581, 231955, 4181, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -253132, 237220, 2912, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -252581, 236005, 2550, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -249826, 236815, 2698, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -254785, 233575, 3836, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18689, -254234, 233575, 3847, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -248724, 238435, 2647, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -254994, 247598, 4876, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -252354, 242963, 5399, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -253674, 242963, 3945, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -252030, 233170, 2513, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -251479, 235195, 2791, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18690, -232708, 247705, 3400, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -232121, 248613, 1343, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -233295, 248159, 2152, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -255616, 253680, 5078, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18691, -239752, 248613, 3231, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18692, -233295, 246797, 2610, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -232121, 249067, 1101, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -232708, 242711, 1854, 0, 0, 0, 60, 0, 0, 0),
-- Mutated Drake Wing
("unset", 1, 22610, -254240, 233870, 3090, 0, 0, 44139, 60, 0, 0, 0),
("unset", 1, 22610, -254012, 232299, 4743, 0, 0, 21621, 60, 0, 0, 0),
("unset", 1, 22610, -249540, 237894, 3019, 0, 0, 62131, 60, 0, 0, 0),
("unset", 1, 22610, -248680, 238871, 4095, 0, 0, 60348, 60, 0, 0, 0),
("unset", 1, 22610, -252016, 235656, 5130, 0, 0, 27342, 60, 0, 0, 0),
("unset", 1, 22610, -251866, 235985, 4651, 0, 0, 39721, 60, 0, 0, 0),
("unset", 1, 22610, -253894, 233800, 2259, 0, 0, 26608, 60, 0, 0, 0),
("unset", 1, 22610, -248623, 235115, 3415, 0, 0, 58700, 60, 0, 0, 0),
("unset", 1, 22610, -252567, 236696, 3845, 0, 0, 25708, 60, 0, 0, 0),
("unset", 1, 22610, -251462, 236616, 4868, 0, 0, 17734, 60, 0, 0, 0),
-- Mutated Drake Wing
("unset", 1, 22611, -251944, 232495, 1978, 0, 0, 25135, 60, 0, 0, 0),
("unset", 1, 22611, -249392, 234058, 5132, 0, 0, 14049, 60, 0, 0, 0),
("unset", 1, 22611, -253102, 234702, 1980, 0, 0, 58468, 60, 0, 0, 0),
("unset", 1, 22611, -251590, 235463, 3357, 0, 0, 2178, 60, 0, 0, 0),
("unset", 1, 22611, -248721, 237442, 2744, 0, 0, 38419, 60, 0, 0, 0),
("unset", 1, 22611, -249797, 236596, 4934, 0, 0, 8744, 60, 0, 0, 0),
("unset", 1, 22611, -249078, 235946, 2531, 0, 0, 33043, 60, 0, 0, 0),
("unset", 1, 22611, -249593, 239258, 4041, 0, 0, 4823, 60, 0, 0, 0),
("unset", 1, 22611, -248093, 238780, 4258, 0, 0, 64792, 60, 0, 0, 0),
("unset", 1, 22611, -252548, 235512, 5983, 0, 0, 65192, 60, 0, 0, 0),
-- Drak
("unset", 1, 22612, -253451, 236686, 5779, 0, 0, 9122, 60, 0, 0, 0),
("unset", 1, 22612, -249299, 239571, 5372, 0, 0, 21266, 60, 0, 0, 0),
("unset", 1, 22612, -248149, 238390, 3884, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 22612, -250429, 236683, 5005, 0, 0, 9701, 60, 0, 0, 0),
("unset", 1, 22612, -249386, 234526, 5466, 0, 0, 60887, 60, 0, 0, 0),
("unset", 1, 22612, -251754, 236589, 4013, 0, 0, 4285, 60, 0, 0, 0),
("unset", 1, 22612, -255030, 232361, 2203, 0, 0, 34790, 60, 0, 0, 0),
("unset", 1, 22612, -255086, 232391, 2610, 0, 0, 57545, 60, 0, 0, 0),
("unset", 1, 22612, -249848, 239564, 4854, 0, 0, 15592, 60, 0, 0, 0),
-- Drak
("unset", 1, 22613, -252628, 235699, 4932, 0, 0, 18585, 60, 0, 0, 0),
("unset", 1, 22613, -249576, 233790, 5304, 0, 0, 11369, 60, 0, 0, 0),
("unset", 1, 22613, -251862, 235578, 4033, 0, 0, 12066, 60, 0, 0, 0),
("unset", 1, 22613, -249614, 234940, 4902, 0, 0, 52821, 60, 0, 0, 0),
("unset", 1, 22613, -250763, 239057, 1607, 0, 0, 55475, 60, 0, 0, 0),
("unset", 1, 22613, -250423, 239751, 1513, 0, 0, 23074, 60, 0, 0, 0),
("unset", 1, 22613, -248263, 238425, 3928, 0, 0, 58351, 60, 0, 0, 0),
("unset", 1, 22613, -249372, 238679, 2922, 0, 0, 64880, 60, 0, 0, 0),
("unset", 1, 22613, -249581, 238794, 4562, 0, 0, 32411, 60, 0, 0, 0),
-- Allenos
("unset", 1, 32526, -248793, 250271, 4328, 0, 0, 57344, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32605, -246857, 251960, 4352, 0, 0, 40960, 60, 0, 0, 0),

-- [13_23]

-- Elite Kanibi
("SOA", 1, 22763, -215396, 182501, -11008, 0, 0, 20565, 60, 0, 0, 0),
("SOA", 1, 22763, -213255, 179293, -12720, 0, 0, 59997, 60, 0, 0, 0),
("SOA", 1, 22763, -210890, 180809, -11712, 0, 0, 1736, 60, 0, 0, 0),
("SOA", 1, 22763, -207286, 179045, -12656, 0, 0, 12044, 60, 0, 0, 0),
("SOA", 1, 22763, -207366, 179572, -11344, 0, 0, 62799, 60, 0, 0, 0),
("SOA", 1, 22763, -207695, 184037, -11336, 0, 0, 19833, 60, 0, 0, 0),
("SOA", 1, 22763, -206167, 179809, -11328, 0, 0, 20140, 60, 0, 0, 0),
("SOA", 1, 22763, -206285, 180574, -12640, 0, 0, 13656, 60, 0, 0, 0),
("SOA", 1, 22763, -206538, 175999, -12656, 0, 0, 55758, 60, 0, 0, 0),
("SOA", 1, 22763, -206903, 174718, -11336, 0, 0, 35194, 60, 0, 0, 0),
("SOA", 1, 22763, -218946, 185959, -11352, 0, 0, 49910, 60, 0, 0, 0),
("SOA", 1, 22763, -219676, 183420, -11344, 0, 0, 2289, 60, 0, 0, 0),
("SOA", 1, 22763, -220077, 183760, -12600, 0, 0, 31753, 60, 0, 0, 0),
("SOA", 1, 22763, -218995, 179786, -12584, 0, 0, 3432, 60, 0, 0, 0),
("SOA", 1, 22763, -220184, 179668, -11352, 0, 0, 50213, 60, 0, 0, 0),
("SOA", 1, 22763, -219097, 177817, -11336, 0, 0, 48926, 60, 0, 0, 0),
("SOA", 1, 22763, -220005, 177495, -12592, 0, 0, 38596, 60, 0, 0, 0),
("SOA", 1, 22763, -218706, 175965, -12600, 0, 0, 48868, 60, 0, 0, 0),
("SOA", 1, 22763, -218887, 177956, -12584, 0, 0, 25293, 60, 0, 0, 0),
("SOA", 1, 22763, -218590, 175308, -11344, 0, 0, 10830, 60, 0, 0, 0),
-- Elite Kiriona
("SOA", 1, 22764, -214045, 178977, -12720, 0, 0, 34361, 60, 0, 0, 0),
("SOA", 1, 22764, -210505, 180580, -11664, 0, 0, 54924, 60, 0, 0, 0),
("SOA", 1, 22764, -208383, 184182, -11336, 0, 0, 11104, 60, 0, 0, 0),
("SOA", 1, 22764, -207167, 179006, -12656, 0, 0, 27751, 60, 0, 0, 0),
("SOA", 1, 22764, -207380, 179318, -11360, 0, 0, 44081, 60, 0, 0, 0),
("SOA", 1, 22764, -207205, 176530, -12664, 0, 0, 27575, 60, 0, 0, 0),
("SOA", 1, 22764, -206107, 179815, -11328, 0, 0, 62553, 60, 0, 0, 0),
("SOA", 1, 22764, -206493, 180892, -12648, 0, 0, 46264, 60, 0, 0, 0),
("SOA", 1, 22764, -206055, 174993, -11336, 0, 0, 21223, 60, 0, 0, 0),
("SOA", 1, 22764, -218663, 183190, -12592, 0, 0, 10875, 60, 0, 0, 0),
("SOA", 1, 22764, -218219, 186361, -11352, 0, 0, 36849, 60, 0, 0, 0),
("SOA", 1, 22764, -219715, 180868, -11328, 0, 0, 24007, 60, 0, 0, 0),
("SOA", 1, 22764, -219613, 180152, -12592, 0, 0, 43295, 60, 0, 0, 0),
("SOA", 1, 22764, -219793, 183500, -11344, 0, 0, 38985, 60, 0, 0, 0),
("SOA", 1, 22764, -220218, 178150, -12592, 0, 0, 61069, 60, 0, 0, 0),
("SOA", 1, 22764, -218896, 178158, -11344, 0, 0, 31767, 60, 0, 0, 0),
("SOA", 1, 22764, -218931, 177957, -12584, 0, 0, 37252, 60, 0, 0, 0),
("SOA", 1, 22764, -218932, 177160, -12584, 0, 0, 59512, 60, 0, 0, 0),
("SOA", 1, 22764, -218991, 174856, -11336, 0, 0, 53195, 60, 0, 0, 0),
-- Elite Kaiona
("SOA", 1, 22765, -214752, 182572, -11000, 0, 0, 55826, 60, 0, 0, 0),
("SOA", 1, 22765, -210813, 180829, -11704, 0, 0, 63511, 60, 0, 0, 0),
("SOA", 1, 22765, -213702, 178784, -12712, 0, 0, 5446, 60, 0, 0, 0),
("SOA", 1, 22765, -207074, 179930, -11344, 0, 0, 7853, 60, 0, 0, 0),
("SOA", 1, 22765, -206811, 181485, -12648, 0, 0, 62957, 60, 0, 0, 0),
("SOA", 1, 22765, -208050, 183126, -11328, 0, 0, 19999, 60, 0, 0, 0),
("SOA", 1, 22765, -206387, 178245, -12648, 0, 0, 26045, 60, 0, 0, 0),
("SOA", 1, 22765, -206305, 179331, -11352, 0, 0, 10325, 60, 0, 0, 0),
("SOA", 1, 22765, -206752, 175031, -12656, 0, 0, 43369, 60, 0, 0, 0),
("SOA", 1, 22765, -206176, 175098, -11344, 0, 0, 8963, 60, 0, 0, 0),
("SOA", 1, 22765, -219364, 180831, -11328, 0, 0, 29563, 60, 0, 0, 0),
("SOA", 1, 22765, -218823, 183106, -12592, 0, 0, 19678, 60, 0, 0, 0),
("SOA", 1, 22765, -218815, 183328, -11344, 0, 0, 64327, 60, 0, 0, 0),
("SOA", 1, 22765, -217903, 185836, -11336, 0, 0, 42862, 60, 0, 0, 0),
("SOA", 1, 22765, -219962, 179876, -12600, 0, 0, 25398, 60, 0, 0, 0),
("SOA", 1, 22765, -219194, 178226, -11320, 0, 0, 38995, 60, 0, 0, 0),
("SOA", 1, 22765, -220139, 176714, -12592, 0, 0, 538, 60, 0, 0, 0),
("SOA", 1, 22765, -218788, 177838, -12584, 0, 0, 32160, 60, 0, 0, 0),
("SOA", 1, 22765, -218988, 175296, -12592, 0, 0, 37279, 60, 0, 0, 0),
("SOA", 1, 22765, -219350, 175732, -11344, 0, 0, 40086, 60, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32769, -214021, 178783, -12720, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -207123, 181046, -12648, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -206201, 177767, -11344, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -218812, 175373, -11344, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32770, -207358, 180258, -11352, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -206182, 175547, -12664, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -219090, 182766, -11336, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -219269, 178788, -11328, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -220074, 176943, -12600, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -219108, 177044, -12584, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32771, -210934, 180397, -11640, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -206960, 175312, -11336, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -218946, 186288, -11344, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -218996, 178493, -12592, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32772, -206090, 179480, -12656, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -207613, 184400, -11336, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -218624, 180897, -11320, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -219733, 182869, -12600, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -218650, 180024, -12584, 0, 0, 0, 1800, 0, 0, 0),

-- [13_24]

-- Red Star Stone
("unset", 1, 18684, -226264, 213859, 2798, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -207300, 207514, 4294, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -208644, 204910, 3260, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -212676, 204042, 5250, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18685, -205284, 207080, 2798, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -212004, 203174, 4540, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -212676, 205778, 5384, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18686, -205284, 207080, 2798, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -205284, 205778, 5489, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -205956, 205344, 5371, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -210660, 206646, 4175, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -212676, 206212, 2721, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18687, -206356, 215773, 2435, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -204481, 214701, 1198, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -201981, 213093, 2728, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -203231, 209877, 3577, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18688, -206356, 217917, 3692, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -205731, 214165, 3425, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -202606, 213629, 1820, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -201981, 212557, 1900, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -199481, 209877, 1971, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18689, -208231, 219525, 3072, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -203856, 217917, 2214, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -198856, 216309, 2550, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -200106, 215773, 1233, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -201981, 209877, 1054, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18690, -225749, 225634, 4894, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -226355, 222616, 4356, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -216659, 217586, 5188, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -216659, 222113, 3732, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -219083, 225634, 5363, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18691, -218477, 219095, 3013, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -216053, 217586, 5331, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -215447, 218089, 4822, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -218477, 219598, 4032, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -216053, 226137, 2598, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18692, -219083, 220604, 4327, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -217871, 220604, 3863, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -215447, 223119, 5034, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -216659, 223622, 4427, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -215447, 224628, 3320, 0, 0, 0, 60, 0, 0, 0),
-- Jaedin
("unset", 1, 32534, -212831, 209536, 4272, 0, 0, 16384, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32604, -213770, 210760, 4400, 0, 0, 57343, 60, 0, 0, 0),

-- [13_25]

-- Green Star Stone
("unset", 1, 18690, -223331, 233909, 4166, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -224189, 233518, 4569, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -224618, 237037, 4867, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -226334, 232736, 5046, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -221615, 233518, 4360, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18690, -221615, 232736, 4569, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18691, -220757, 233127, 4864, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -222044, 233127, 4246, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -222473, 237037, 5276, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -224189, 233909, 4879, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -226763, 233909, 5393, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -226334, 234300, 5411, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18691, -227192, 233909, 5229, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18692, -223760, 237037, 4733, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -225476, 238601, 4107, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -224618, 232345, 5341, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -221186, 232345, 5436, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -221186, 235082, 3960, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18692, -222473, 235473, 4018, 0, 0, 0, 60, 0, 0, 0),
-- Vortex Gate 
("unset", 1, 32518, -204849, 242148, 1781, 0, 0, 0, 60, 0, 0, 0),
-- Vortex Gate 
("unset", 1, 32519, -223211, 247803, 1781, 0, 0, 0, 60, 0, 0, 0),

-- [14_22]

-- Klemis
("SOA", 1, 32734, -178467, 153371, 2472, 0, 0, 11632, 60, 0, 0, 0),
-- Nemo
("SOA", 1, 32735, -175533, 153808, 2704, 0, 0, 16016, 60, 0, 0, 0),
-- Seyo
("SOA", 1, 32737, -181199, 153605, 2704, 0, 0, 11632, 60, 0, 0, 0),
-- Flight Control
("SOA", 1, 32779, -175533, 154851, 2720, 0, 0, 16016, 60, 0, 0, 0),

-- [14_23]

-- Elite Bgurent
("SOA", 1, 22750, -184510, 183037, -10456, 0, 0, 43779, 60, 0, 0, 0),
("SOA", 1, 22750, -184326, 183082, -10464, 0, 0, 30886, 60, 0, 0, 0),
("SOA", 1, 22750, -183838, 180626, -10440, 0, 0, 33335, 60, 0, 0, 0),
("SOA", 1, 22750, -184808, 182012, -10496, 0, 0, 24816, 60, 0, 0, 0),
("SOA", 1, 22750, -177467, 182600, -10600, 0, 0, 4456, 60, 0, 0, 0),
("SOA", 1, 22750, -176376, 182912, -10520, 0, 0, 20433, 60, 0, 0, 0),
("SOA", 1, 22750, -179236, 179818, -10440, 0, 0, 25296, 60, 0, 0, 0),
("SOA", 1, 22750, -180797, 179960, -10464, 0, 0, 27437, 60, 0, 0, 0),
("SOA", 1, 22750, -185089, 179418, -10392, 0, 0, 26067, 60, 0, 0, 0),
("SOA", 1, 22750, -185196, 179110, -10384, 0, 0, 15407, 60, 0, 0, 0),
("SOA", 1, 22750, -185049, 179394, -10392, 0, 0, 28121, 60, 0, 0, 0),
("SOA", 1, 22750, -181450, 179204, -10408, 0, 0, 44619, 60, 0, 0, 0),
("SOA", 1, 22750, -183621, 176854, -10256, 0, 0, 55102, 60, 0, 0, 0),
("SOA", 1, 22750, -176018, 176768, -10264, 0, 0, 33636, 60, 0, 0, 0),
("SOA", 1, 22750, -176607, 179162, -10432, 0, 0, 59555, 60, 0, 0, 0),
("SOA", 1, 22750, -175742, 177469, -10272, 0, 0, 9592, 60, 0, 0, 0),
("SOA", 1, 22750, -176019, 178242, -10352, 0, 0, 58321, 60, 0, 0, 0),
("SOA", 1, 22750, -174952, 177824, -10232, 0, 0, 43787, 60, 0, 0, 0),
("SOA", 1, 22750, -175165, 177753, -10248, 0, 0, 24997, 60, 0, 0, 0),
("SOA", 1, 22750, -175742, 182469, -10496, 0, 0, 48222, 60, 0, 0, 0),
-- Elite Brakian
("SOA", 1, 22751, -184171, 183580, -10416, 0, 0, 5920, 60, 0, 0, 0),
("SOA", 1, 22751, -184303, 180988, -10480, 0, 0, 33372, 60, 0, 0, 0),
("SOA", 1, 22751, -184782, 181435, -10496, 0, 0, 41325, 60, 0, 0, 0),
("SOA", 1, 22751, -177566, 182548, -10600, 0, 0, 53903, 60, 0, 0, 0),
("SOA", 1, 22751, -179181, 179801, -10432, 0, 0, 62353, 60, 0, 0, 0),
("SOA", 1, 22751, -181829, 179940, -10456, 0, 0, 16298, 60, 0, 0, 0),
("SOA", 1, 22751, -181184, 179591, -10416, 0, 0, 46320, 60, 0, 0, 0),
("SOA", 1, 22751, -184320, 177946, -10248, 0, 0, 56448, 60, 0, 0, 0),
("SOA", 1, 22751, -182001, 179628, -10408, 0, 0, 33668, 60, 0, 0, 0),
("SOA", 1, 22751, -185201, 178318, -10320, 0, 0, 62950, 60, 0, 0, 0),
("SOA", 1, 22751, -184360, 176536, -10224, 0, 0, 22492, 60, 0, 0, 0),
("SOA", 1, 22751, -183598, 176026, -10248, 0, 0, 36773, 60, 0, 0, 0),
("SOA", 1, 22751, -177063, 177600, -10376, 0, 0, 46345, 60, 0, 0, 0),
("SOA", 1, 22751, -176882, 178142, -10384, 0, 0, 17670, 60, 0, 0, 0),
("SOA", 1, 22751, -174736, 177780, -10224, 0, 0, 39455, 60, 0, 0, 0),
("SOA", 1, 22751, -175674, 177254, -10256, 0, 0, 62342, 60, 0, 0, 0),
("SOA", 1, 22751, -175603, 177816, -10288, 0, 0, 38008, 60, 0, 0, 0),
("SOA", 1, 22751, -175641, 183165, -10448, 0, 0, 28623, 60, 0, 0, 0),
("SOA", 1, 22751, -175720, 182480, -10488, 0, 0, 37605, 60, 0, 0, 0),
("SOA", 1, 22751, -175579, 182672, -10480, 0, 0, 55356, 60, 0, 0, 0),
-- Elite Groikan
("SOA", 1, 22752, -182681, 183767, -10528, 0, 0, 42221, 60, 0, 0, 0),
("SOA", 1, 22752, -183453, 183667, -10464, 0, 0, 13282, 60, 0, 0, 0),
("SOA", 1, 22752, -184856, 181481, -10496, 0, 0, 39074, 60, 0, 0, 0),
("SOA", 1, 22752, -184473, 180980, -10480, 0, 0, 55910, 60, 0, 0, 0),
("SOA", 1, 22752, -178189, 182923, -10576, 0, 0, 54026, 60, 0, 0, 0),
("SOA", 1, 22752, -178465, 179650, -10408, 0, 0, 61735, 60, 0, 0, 0),
("SOA", 1, 22752, -181641, 179592, -10416, 0, 0, 43141, 60, 0, 0, 0),
("SOA", 1, 22752, -178665, 180142, -10464, 0, 0, 32725, 60, 0, 0, 0),
("SOA", 1, 22752, -181250, 180194, -10480, 0, 0, 11748, 60, 0, 0, 0),
("SOA", 1, 22752, -181012, 179901, -10456, 0, 0, 58782, 60, 0, 0, 0),
("SOA", 1, 22752, -185493, 178709, -10344, 0, 0, 36339, 60, 0, 0, 0),
("SOA", 1, 22752, -185287, 178709, -10352, 0, 0, 9023, 60, 0, 0, 0),
("SOA", 1, 22752, -185514, 178063, -10280, 0, 0, 4911, 60, 0, 0, 0),
("SOA", 1, 22752, -183938, 176097, -10240, 0, 0, 11067, 60, 0, 0, 0),
("SOA", 1, 22752, -176222, 176836, -10280, 0, 0, 64522, 60, 0, 0, 0),
("SOA", 1, 22752, -176214, 176661, -10272, 0, 0, 26516, 60, 0, 0, 0),
("SOA", 1, 22752, -175359, 179023, -10312, 0, 0, 24876, 60, 0, 0, 0),
("SOA", 1, 22752, -176039, 182993, -10496, 0, 0, 42644, 60, 0, 0, 0),
-- Elite Treykan
("SOA", 1, 22753, -183904, 180988, -10496, 0, 0, 9312, 60, 0, 0, 0),
("SOA", 1, 22753, -183371, 183001, -10560, 0, 0, 59166, 60, 0, 0, 0),
("SOA", 1, 22753, -184636, 181358, -10496, 0, 0, 61388, 60, 0, 0, 0),
("SOA", 1, 22753, -183786, 182917, -10520, 0, 0, 40829, 60, 0, 0, 0),
("SOA", 1, 22753, -183072, 182953, -10568, 0, 0, 37138, 60, 0, 0, 0),
("SOA", 1, 22753, -176257, 182989, -10512, 0, 0, 62486, 60, 0, 0, 0),
("SOA", 1, 22753, -177823, 182767, -10584, 0, 0, 21469, 60, 0, 0, 0),
("SOA", 1, 22753, -178087, 182951, -10576, 0, 0, 64988, 60, 0, 0, 0),
("SOA", 1, 22753, -180864, 180259, -10488, 0, 0, 39546, 60, 0, 0, 0),
("SOA", 1, 22753, -178647, 180331, -10488, 0, 0, 62181, 60, 0, 0, 0),
("SOA", 1, 22753, -180925, 180452, -10512, 0, 0, 11178, 60, 0, 0, 0),
("SOA", 1, 22753, -184488, 179241, -10432, 0, 0, 15897, 60, 0, 0, 0),
("SOA", 1, 22753, -185198, 179575, -10408, 0, 0, 54968, 60, 0, 0, 0),
("SOA", 1, 22753, -183972, 176120, -10240, 0, 0, 15412, 60, 0, 0, 0),
("SOA", 1, 22753, -183985, 175900, -10232, 0, 0, 27352, 60, 0, 0, 0),
("SOA", 1, 22753, -176938, 177653, -10360, 0, 0, 58266, 60, 0, 0, 0),
("SOA", 1, 22753, -176460, 177738, -10344, 0, 0, 58105, 60, 0, 0, 0),
("SOA", 1, 22753, -177505, 179565, -10408, 0, 0, 33523, 60, 0, 0, 0),
("SOA", 1, 22753, -177779, 180106, -10464, 0, 0, 64890, 60, 0, 0, 0),
("SOA", 1, 22753, -176052, 177727, -10320, 0, 0, 61568, 60, 0, 0, 0),
("SOA", 1, 22753, -175404, 181858, -10448, 0, 0, 53097, 60, 0, 0, 0),
-- Elite Turtlelian
("SOA", 1, 22757, -186289, 183343, -15672, 0, 0, 55151, 60, 0, 0, 0),
("SOA", 1, 22757, -184845, 183307, -15616, 0, 0, 52044, 60, 0, 0, 0),
("SOA", 1, 22757, -185721, 181713, -15488, 0, 0, 12872, 60, 0, 0, 0),
("SOA", 1, 22757, -185032, 183317, -15624, 0, 0, 44559, 60, 0, 0, 0),
("SOA", 1, 22757, -182407, 180302, -15096, 0, 0, 47734, 60, 0, 0, 0),
("SOA", 1, 22757, -185949, 184948, -15672, 0, 0, 41962, 60, 0, 0, 0),
("SOA", 1, 22757, -184889, 184538, -15664, 0, 0, 13548, 60, 0, 0, 0),
("SOA", 1, 22757, -185705, 180371, -15480, 0, 0, 34828, 60, 0, 0, 0),
("SOA", 1, 22757, -185113, 180546, -15528, 0, 0, 59538, 60, 0, 0, 0),
("SOA", 1, 22757, -184503, 186498, -15816, 0, 0, 4287, 60, 0, 0, 0),
("SOA", 1, 22757, -180934, 180929, -15152, 0, 0, 40036, 60, 0, 0, 0),
("SOA", 1, 22757, -180107, 180440, -15128, 0, 0, 28737, 60, 0, 0, 0),
("SOA", 1, 22757, -176117, 181434, -15624, 0, 0, 50782, 60, 0, 0, 0),
("SOA", 1, 22757, -185394, 178800, -15336, 0, 0, 40151, 60, 0, 0, 0),
("SOA", 1, 22757, -185219, 178766, -15336, 0, 0, 7497, 60, 0, 0, 0),
("SOA", 1, 22757, -184498, 176430, -15320, 0, 0, 3526, 60, 0, 0, 0),
("SOA", 1, 22757, -183842, 177201, -15312, 0, 0, 23524, 60, 0, 0, 0),
("SOA", 1, 22757, -180517, 177511, -15152, 0, 0, 22471, 60, 0, 0, 0),
("SOA", 1, 22757, -186120, 179614, -15392, 0, 0, 50020, 60, 0, 0, 0),
("SOA", 1, 22757, -177188, 177787, -15824, 0, 0, 31287, 60, 0, 0, 0),
("SOA", 1, 22757, -175826, 178054, -15824, 0, 0, 13234, 60, 0, 0, 0),
("SOA", 1, 22757, -174923, 179845, -15680, 0, 0, 21146, 60, 0, 0, 0),
("SOA", 1, 22757, -174895, 180235, -15680, 0, 0, 36843, 60, 0, 0, 0),
("SOA", 1, 22757, -175628, 182504, -15688, 0, 0, 9639, 60, 0, 0, 0),
("SOA", 1, 22757, -174791, 181324, -15624, 0, 0, 25661, 60, 0, 0, 0),
-- Elite Krajian
("SOA", 1, 22758, -186417, 182888, -15600, 0, 0, 12413, 60, 0, 0, 0),
("SOA", 1, 22758, -185436, 184774, -15664, 0, 0, 45631, 60, 0, 0, 0),
("SOA", 1, 22758, -186187, 184514, -15680, 0, 0, 62858, 60, 0, 0, 0),
("SOA", 1, 22758, -184741, 185949, -15816, 0, 0, 14102, 60, 0, 0, 0),
("SOA", 1, 22758, -186411, 181841, -15528, 0, 0, 57503, 60, 0, 0, 0),
("SOA", 1, 22758, -184749, 183247, -15608, 0, 0, 24415, 60, 0, 0, 0),
("SOA", 1, 22758, -186050, 181701, -15488, 0, 0, 46888, 60, 0, 0, 0),
("SOA", 1, 22758, -185510, 180548, -15512, 0, 0, 31821, 60, 0, 0, 0),
("SOA", 1, 22758, -185023, 186810, -15816, 0, 0, 38619, 60, 0, 0, 0),
("SOA", 1, 22758, -185401, 186718, -15816, 0, 0, 49041, 60, 0, 0, 0),
("SOA", 1, 22758, -182002, 181111, -15104, 0, 0, 62818, 60, 0, 0, 0),
("SOA", 1, 22758, -184782, 178540, -15336, 0, 0, 60298, 60, 0, 0, 0),
("SOA", 1, 22758, -186191, 179734, -15432, 0, 0, 1527, 60, 0, 0, 0),
("SOA", 1, 22758, -180233, 177581, -15152, 0, 0, 34516, 60, 0, 0, 0),
("SOA", 1, 22758, -180608, 177374, -15152, 0, 0, 57265, 60, 0, 0, 0),
("SOA", 1, 22758, -184648, 176491, -15336, 0, 0, 46598, 60, 0, 0, 0),
("SOA", 1, 22758, -183781, 176933, -15304, 0, 0, 56868, 60, 0, 0, 0),
("SOA", 1, 22758, -180489, 177149, -15152, 0, 0, 56868, 60, 0, 0, 0),
("SOA", 1, 22758, -184625, 175788, -15304, 0, 0, 2500, 60, 0, 0, 0),
("SOA", 1, 22758, -176709, 177888, -15824, 0, 0, 50506, 60, 0, 0, 0),
("SOA", 1, 22758, -175332, 179413, -15720, 0, 0, 38706, 60, 0, 0, 0),
("SOA", 1, 22758, -175987, 177651, -15824, 0, 0, 52343, 60, 0, 0, 0),
("SOA", 1, 22758, -174801, 179198, -15760, 0, 0, 58499, 60, 0, 0, 0),
("SOA", 1, 22758, -175381, 180571, -15664, 0, 0, 3742, 60, 0, 0, 0),
("SOA", 1, 22758, -175001, 181783, -15608, 0, 0, 31063, 60, 0, 0, 0),
("SOA", 1, 22758, -175286, 181753, -15584, 0, 0, 30350, 60, 0, 0, 0),
-- Elite Tardyon
("SOA", 1, 22759, -185011, 184626, -15664, 0, 0, 56190, 60, 0, 0, 0),
("SOA", 1, 22759, -184793, 181046, -15528, 0, 0, 52982, 60, 0, 0, 0),
("SOA", 1, 22759, -186132, 183422, -15672, 0, 0, 37392, 60, 0, 0, 0),
("SOA", 1, 22759, -186042, 185917, -15800, 0, 0, 14567, 60, 0, 0, 0),
("SOA", 1, 22759, -186296, 184817, -15664, 0, 0, 61544, 60, 0, 0, 0),
("SOA", 1, 22759, -184732, 182386, -15568, 0, 0, 60296, 60, 0, 0, 0),
("SOA", 1, 22759, -184949, 184012, -15680, 0, 0, 55609, 60, 0, 0, 0),
("SOA", 1, 22759, -186360, 180387, -15528, 0, 0, 30708, 60, 0, 0, 0),
("SOA", 1, 22759, -184460, 187066, -15808, 0, 0, 25998, 60, 0, 0, 0),
("SOA", 1, 22759, -184533, 186578, -15816, 0, 0, 33348, 60, 0, 0, 0),
("SOA", 1, 22759, -180393, 180374, -15152, 0, 0, 28017, 60, 0, 0, 0),
("SOA", 1, 22759, -182328, 180294, -15112, 0, 0, 48963, 60, 0, 0, 0),
("SOA", 1, 22759, -182310, 180862, -15104, 0, 0, 25251, 60, 0, 0, 0),
("SOA", 1, 22759, -185916, 178327, -15336, 0, 0, 51045, 60, 0, 0, 0),
("SOA", 1, 22759, -180576, 178619, -15152, 0, 0, 63335, 60, 0, 0, 0),
("SOA", 1, 22759, -184590, 176037, -15320, 0, 0, 52928, 60, 0, 0, 0),
("SOA", 1, 22759, -180147, 177278, -15152, 0, 0, 11463, 60, 0, 0, 0),
("SOA", 1, 22759, -176224, 177467, -15824, 0, 0, 36245, 60, 0, 0, 0),
("SOA", 1, 22759, -175016, 179428, -15720, 0, 0, 16383, 60, 0, 0, 0),
("SOA", 1, 22759, -174310, 182020, -15688, 0, 0, 24847, 60, 0, 0, 0),
-- Ermian
("SOA", 1, 32736, -180232, 186256, -10608, 0, 0, 11632, 60, 0, 0, 0),
-- Bomona
("SOA", 1, 32739, -174654, 184277, -15408, 0, 0, 0, 60, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32769, -186060, 185113, -15720, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -186387, 184931, -15672, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -178104, 183412, -10552, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -180684, 180340, -15152, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -182125, 180739, -15120, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -181994, 180454, -15152, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -185356, 178800, -10360, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -184572, 178800, -10384, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -177062, 177469, -15800, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32769, -175361, 186569, -15128, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32770, -186442, 180512, -15528, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -183773, 180772, -10464, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -185697, 180908, -15480, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -184304, 181000, -10480, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -178217, 180304, -10496, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -178323, 179954, -10432, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -180710, 177036, -15152, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -176193, 177386, -10304, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -174453, 178028, -10224, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32770, -175323, 177600, -10248, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32771, -186684, 182872, -15568, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -186388, 182808, -15592, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -184817, 181347, -10488, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -181937, 180452, -10520, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -182072, 180012, -10456, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -185224, 179492, -15408, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -181532, 180012, -10464, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32771, -174778, 179102, -15768, 0, 0, 0, 1800, 0, 0, 0),
-- Gracian Soldier's Corpse
("SOA", 1, 32772, -183067, 183297, -10560, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -184867, 186582, -15816, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -176143, 183062, -10496, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -184988, 176880, -15328, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -184003, 176960, -10232, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -183506, 176492, -10272, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -174510, 181976, -15696, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -175455, 181727, -15600, 0, 0, 0, 1800, 0, 0, 0),
("SOA", 1, 32772, -176017, 182610, -10512, 0, 0, 0, 1800, 0, 0, 0),
-- Jakan
("SOA", 1, 32773, -180354, 186274, -10584, 0, 0, 64009, 60, 0, 0, 0),
-- Elmina
("SOA", 1, 32774, -180090, 186277, -10584, 0, 0, 34300, 60, 0, 0, 0),
-- Gracian Soldier
("SOA", 1, 32775, -180397, 186353, -10576, 0, 0, 59993, 60, 0, 0, 0),
("SOA", 1, 32775, -180234, 186114, -10584, 0, 0, 16236, 60, 0, 0, 0),
("SOA", 1, 32775, -180395, 186180, -10576, 0, 0, 4550, 60, 0, 0, 0),
("SOA", 1, 32775, -180249, 186380, -10592, 0, 0, 50574, 60, 0, 0, 0),
("SOA", 1, 32775, -180105, 186193, -10584, 0, 0, 27964, 60, 0, 0, 0),
("SOA", 1, 32775, -180162, 186440, -10576, 0, 0, 45361, 60, 0, 0, 0),
("SOA", 1, 32775, -180057, 186411, -10568, 0, 0, 40330, 60, 0, 0, 0),
-- Gracian Soldier
("SOA", 1, 32776, -180326, 186350, -10584, 0, 0, 57345, 60, 0, 0, 0),
("SOA", 1, 32776, -180298, 186173, -10592, 0, 0, 9376, 60, 0, 0, 0),
("SOA", 1, 32776, -180243, 186487, -10568, 0, 0, 49649, 60, 0, 0, 0),
("SOA", 1, 32776, -180383, 186436, -10568, 0, 0, 56433, 60, 0, 0, 0),
("SOA", 1, 32776, -180158, 186177, -10592, 0, 0, 24234, 60, 0, 0, 0),
("SOA", 1, 32776, -180214, 186159, -10592, 0, 0, 18297, 60, 0, 0, 0),
("SOA", 1, 32776, -180156, 186280, -10600, 0, 0, 35959, 60, 0, 0, 0),
("SOA", 1, 32776, -180195, 186307, -10608, 0, 0, 42606, 60, 0, 0, 0),
("SOA", 1, 32776, -180201, 186216, -10608, 0, 0, 23260, 60, 0, 0, 0),

-- [14_24]

-- Red Star Stone
("unset", 1, 18684, -173067, 224195, 971, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -175303, 227425, -341, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -191025, 207174, 4062, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -190466, 208274, 4859, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -187112, 215974, 3719, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -193820, 214874, 5198, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -189348, 211574, 4474, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -188230, 209374, 4444, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -172604, 211293, 3682, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -175862, 217735, 265, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -172508, 226133, 681, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -171999, 210081, 4661, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -171999, 210485, 5371, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -171394, 207657, 4337, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -170789, 208869, 4642, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18684, -178049, 208465, 4068, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18685, -174185, 228071, 801, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -194938, 215424, 4858, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -192702, 213224, 5328, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -190466, 208274, 4859, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -192143, 211024, 5082, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -188230, 214324, 4613, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -187671, 213774, 5452, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -187671, 214874, 3774, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -171394, 211697, 3464, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -173209, 210081, 3689, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -171999, 210081, 4661, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -174419, 208061, 3465, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -173209, 207253, 5029, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -173626, 216443, 115, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -172604, 214525, 3037, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -173626, 217735, 397, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -171949, 219673, 839, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18685, -173626, 226133, -163, 0, 0, 0, 60, 0, 0, 0),
-- Red Star Stone
("unset", 1, 18686, -177444, 210485, 3314, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -173209, 214121, 4920, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -170831, 222257, 436, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -171390, 221611, -157, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -170831, 224195, 191, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -173626, 225487, 327, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -173209, 213717, 3779, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -175629, 213717, 3467, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -170789, 207657, 3581, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -171394, 208869, 3130, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -178049, 210081, 5349, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -188789, 211024, 4945, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -174744, 227425, -91, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -191025, 208274, 5093, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -192143, 213224, 5103, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -192143, 213774, 5186, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -192702, 213224, 5328, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18686, -194379, 215424, 4176, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18687, -190387, 218925, 1625, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -192515, 224343, 3970, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -193047, 224343, 2928, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18688, -194111, 219699, 3720, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -191451, 223569, 2739, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -191451, 223956, 2545, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18689, -193047, 218925, 1505, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -188791, 218925, 1998, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -191451, 219312, 3018, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -191451, 223956, 2545, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18690, -180800, 202823, 3918, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18691, -180800, 202823, 3918, 0, 0, 0, 60, 0, 0, 0),
-- Green Star Stone
("unset", 1, 18692, -176546, 202823, 3291, 0, 0, 0, 60, 0, 0, 0),
-- Mutant Bird
("unset", 1, 22602, -176721, 225626, 2328, 0, 0, 702, 60, 0, 0, 0),
("unset", 1, 22602, -176070, 222253, 3133, 0, 0, 20710, 60, 0, 0, 0),
("unset", 1, 22602, -176009, 221535, 5677, 0, 0, 4977, 60, 0, 0, 0),
("unset", 1, 22602, -170102, 218471, 4674, 0, 0, 12414, 60, 0, 0, 0),
("unset", 1, 22602, -169499, 220264, 1841, 0, 0, 20046, 60, 0, 0, 0),
("unset", 1, 22602, -171558, 216328, 1930, 0, 0, 22402, 60, 0, 0, 0),
("unset", 1, 22602, -171584, 217034, 4279, 0, 0, 47573, 60, 0, 0, 0),
("unset", 1, 22602, -175668, 216773, 1992, 0, 0, 36387, 60, 0, 0, 0),
-- Mutant Bird
("unset", 1, 22603, -178553, 225346, 2250, 0, 0, 39188, 60, 0, 0, 0),
("unset", 1, 22603, -173278, 223444, 3122, 0, 0, 41927, 60, 0, 0, 0),
("unset", 1, 22603, -175547, 221999, 2206, 0, 0, 16973, 60, 0, 0, 0),
("unset", 1, 22603, -171665, 219582, 4759, 0, 0, 10967, 60, 0, 0, 0),
("unset", 1, 22603, -170098, 222213, 4292, 0, 0, 8368, 60, 0, 0, 0),
("unset", 1, 22603, -171048, 222975, 3914, 0, 0, 28091, 60, 0, 0, 0),
("unset", 1, 22603, -170221, 214808, 2705, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 22603, -173958, 218160, 4179, 0, 0, 52746, 60, 0, 0, 0),
("unset", 1, 22603, -169307, 222542, 4579, 0, 0, 37693, 60, 0, 0, 0),
-- Dra Hawk
("unset", 1, 22604, -169622, 215472, 3003, 0, 0, 59103, 60, 0, 0, 0),
("unset", 1, 22604, -169602, 221626, 4410, 0, 0, 3188, 60, 0, 0, 0),
("unset", 1, 22604, -169499, 220264, 1841, 0, 0, 3956, 60, 0, 0, 0),
("unset", 1, 22604, -171631, 224209, 3611, 0, 0, 27239, 60, 0, 0, 0),
("unset", 1, 22604, -170862, 225208, 3446, 0, 0, 55307, 60, 0, 0, 0),
("unset", 1, 22604, -175317, 218211, 2882, 0, 0, 55294, 60, 0, 0, 0),
("unset", 1, 22604, -171845, 217276, 5233, 0, 0, 64642, 60, 0, 0, 0),
("unset", 1, 22604, -169499, 216854, 3064, 0, 0, 0, 60, 0, 0, 0),
-- Dra Hawk
("unset", 1, 22605, -173372, 222688, 2358, 0, 0, 21595, 60, 0, 0, 0),
("unset", 1, 22605, -171365, 223016, 5160, 0, 0, 42000, 60, 0, 0, 0),
("unset", 1, 22605, -171609, 217919, 4418, 0, 0, 40366, 60, 0, 0, 0),
("unset", 1, 22605, -171570, 217366, 4985, 0, 0, 933, 60, 0, 0, 0),
("unset", 1, 22605, -169499, 220264, 1841, 0, 0, 9492, 60, 0, 0, 0),
("unset", 1, 22605, -169596, 215561, 4627, 0, 0, 28317, 60, 0, 0, 0),
("unset", 1, 22605, -169309, 216245, 2862, 0, 0, 22714, 60, 0, 0, 0),
-- Floating Skull
("unset", 1, 22606, -181932, 208206, 2801, 0, 0, 29987, 60, 0, 0, 0),
("unset", 1, 22606, -179766, 209570, 2139, 0, 0, 45733, 60, 0, 0, 0),
("unset", 1, 22606, -180213, 204906, 4762, 0, 0, 62043, 60, 0, 0, 0),
("unset", 1, 22606, -177683, 203385, 2608, 0, 0, 40137, 60, 0, 0, 0),
("unset", 1, 22606, -187311, 208249, 4589, 0, 0, 27246, 60, 0, 0, 0),
("unset", 1, 22606, -186258, 211737, 4346, 0, 0, 1264, 60, 0, 0, 0),
("unset", 1, 22606, -183519, 209702, 4811, 0, 0, 23799, 60, 0, 0, 0),
("unset", 1, 22606, -179455, 209697, 1997, 0, 0, 40217, 60, 0, 0, 0),
-- Floating Skull
("unset", 1, 22607, -178239, 207069, 2594, 0, 0, 42230, 60, 0, 0, 0),
("unset", 1, 22607, -178322, 202750, 1852, 0, 0, 28697, 60, 0, 0, 0),
("unset", 1, 22607, -180488, 207524, 4877, 0, 0, 50893, 60, 0, 0, 0),
("unset", 1, 22607, -188430, 210934, 3151, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 22607, -187004, 211826, 2963, 0, 0, 1107, 60, 0, 0, 0),
("unset", 1, 22607, -184366, 205248, 3507, 0, 0, 28883, 60, 0, 0, 0),
("unset", 1, 22607, -188473, 205478, 2471, 0, 0, 56891, 60, 0, 0, 0),
("unset", 1, 22607, -185638, 209710, 2452, 0, 0, 29533, 60, 0, 0, 0),
("unset", 1, 22607, -183869, 207676, 2972, 0, 0, 12119, 60, 0, 0, 0),
-- Floating Zombie
("unset", 1, 22608, -179766, 205478, 3085, 0, 0, 24651, 60, 0, 0, 0),
("unset", 1, 22608, -180084, 206649, 4621, 0, 0, 65168, 60, 0, 0, 0),
("unset", 1, 22608, -179766, 208206, 2398, 0, 0, 52359, 60, 0, 0, 0),
("unset", 1, 22608, -188117, 211395, 2535, 0, 0, 38616, 60, 0, 0, 0),
("unset", 1, 22608, -184341, 211418, 3096, 0, 0, 62304, 60, 0, 0, 0),
("unset", 1, 22608, -186986, 212980, 4668, 0, 0, 62787, 60, 0, 0, 0),
("unset", 1, 22608, -188430, 210252, 2400, 0, 0, 48121, 60, 0, 0, 0),
("unset", 1, 22608, -182496, 204993, 2576, 0, 0, 27280, 60, 0, 0, 0),
-- Floating Zombie
("unset", 1, 22609, -179044, 210252, 2431, 0, 0, 22572, 60, 0, 0, 0),
("unset", 1, 22609, -178322, 207524, 4174, 0, 0, 37683, 60, 0, 0, 0),
("unset", 1, 22609, -181860, 210790, 4903, 0, 0, 1302, 60, 0, 0, 0),
("unset", 1, 22609, -185542, 207524, 2917, 0, 0, 65402, 60, 0, 0, 0),
("unset", 1, 22609, -183343, 209982, 2323, 0, 0, 22488, 60, 0, 0, 0),
-- Mouth of Ekimus
("unset", 1, 32537, -182996, 206510, -12896, 0, 0, 40959, 60, 0, 0, 0),
("unset", 1, 32537, -183002, 205944, -12896, 0, 0, 24576, 60, 0, 0, 0),
("unset", 1, 32537, -183589, 206510, -12896, 0, 0, 57343, 60, 0, 0, 0),
("unset", 1, 32537, -183586, 205947, -12896, 0, 0, 8192, 60, 0, 0, 0),
-- Gatekeeper of Abyss
("unset", 1, 32539, -183295, 205861, -12896, 0, 0, 16384, 60, 0, 0, 0),
-- Asyatei
("unset", 1, 32546, -183443, 206013, -12896, 0, 0, 24186, 60, 0, 0, 0),
-- Tepios
("unset", 1, 32603, -183282, 205703, -12896, 0, 0, 16384, 60, 0, 0, 0),

-- [14_25]

-- 
("unset", 1, 18669, -184991, 242893, 1554, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18687, -186110, 236129, 4186, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -180386, 236960, 4340, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -180863, 234190, 5172, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -181340, 235021, 4601, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -180386, 232528, 3779, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18687, -185633, 234190, 4954, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18688, -184202, 234467, 4573, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -183725, 234467, 3910, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -179909, 234190, 4357, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -179909, 233636, 4262, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -182771, 233082, 4076, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18688, -179432, 233359, 5079, 0, 0, 0, 60, 0, 0, 0),
-- Blue Star Stone
("unset", 1, 18689, -181817, 236406, 3771, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -179909, 235575, 4752, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -183725, 232528, 3829, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 18689, -184202, 232251, 4312, 0, 0, 0, 60, 0, 0, 0),
-- Vulture Rider
("unset", 1, 22614, -189962, 253369, 2401, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 22614, -195647, 252963, 4566, 0, 0, 26119, 60, 0, 0, 0),
("unset", 1, 22614, -195647, 254587, 1056, 0, 0, 58911, 60, 0, 0, 0),
("unset", 1, 22614, -194647, 254505, 5352, 0, 0, 25770, 60, 0, 0, 0),
("unset", 1, 22614, -194772, 255632, 4378, 0, 0, 13199, 60, 0, 0, 0),
("unset", 1, 22614, -193752, 255399, 4801, 0, 0, 55768, 60, 0, 0, 0),
("unset", 1, 22614, -192726, 256115, 5663, 0, 0, 44838, 60, 0, 0, 0),
("unset", 1, 22614, -193156, 257934, 1142, 0, 0, 57616, 60, 0, 0, 0),
("unset", 1, 22614, -192686, 256429, 5288, 0, 0, 15914, 60, 0, 0, 0),
("unset", 1, 22614, -190677, 256634, 1530, 0, 0, 63082, 60, 0, 0, 0),
("unset", 1, 22614, -192443, 257682, 2991, 0, 0, 28247, 60, 0, 0, 0),
("unset", 1, 22614, -190323, 254742, 2446, 0, 0, 59433, 60, 0, 0, 0),
("unset", 1, 22614, -195268, 257429, 5214, 0, 0, 50397, 60, 0, 0, 0),
("unset", 1, 22614, -194889, 257835, 3036, 0, 0, 29146, 60, 0, 0, 0),
("unset", 1, 22614, -195325, 257089, 4733, 0, 0, 12368, 60, 0, 0, 0),
("unset", 1, 22614, -195781, 256584, 5663, 0, 0, 57903, 60, 0, 0, 0),
-- Vulture Rider
("unset", 1, 22615, -194155, 250573, 5622, 0, 0, 56527, 60, 0, 0, 0),
("unset", 1, 22615, -195530, 251829, 2218, 0, 0, 23196, 60, 0, 0, 0),
("unset", 1, 22615, -195561, 253438, 1069, 0, 0, 137, 60, 0, 0, 0),
("unset", 1, 22615, -195268, 252151, 4383, 0, 0, 58020, 60, 0, 0, 0),
("unset", 1, 22615, -194958, 256443, 4416, 0, 0, 19283, 60, 0, 0, 0),
("unset", 1, 22615, -195004, 256852, 4750, 0, 0, 48553, 60, 0, 0, 0),
("unset", 1, 22615, -191537, 255875, 2979, 0, 0, 44282, 60, 0, 0, 0),
("unset", 1, 22615, -194040, 255960, 1388, 0, 0, 63449, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32517, -185775, 246408, 1280, 0, 0, 2273, 60, 0, 0, 0),
-- Keucereus
("unset", 1, 32548, -186399, 242412, 2552, 0, 0, 3200, 60, 0, 0, 0),
-- Dilios
("unset", 1, 32549, -185615, 240748, 1568, 0, 0, 3200, 60, 0, 0, 0),
-- Kirklan
("unset", 1, 32550, -184460, 242848, 1584, 0, 0, 27321, 60, 0, 0, 0),
-- Noiless
("unset", 1, 32551, -182991, 241681, 1448, 0, 0, 19200, 60, 0, 0, 0),
-- Tomaris
("unset", 1, 32552, -182914, 241429, 1448, 0, 0, 52199, 60, 0, 0, 0),
-- Jisans
("unset", 1, 32553, -184048, 245160, 1448, 0, 0, 19200, 60, 0, 0, 0),
-- Moira
("unset", 1, 32554, -183970, 244911, 1448, 0, 0, 52199, 60, 0, 0, 0),
-- Tenius
("unset", 1, 32555, -186177, 242341, 1680, 0, 0, 3200, 60, 0, 0, 0),
-- El
("unset", 1, 32556, -186252, 242594, 1680, 0, 0, 3200, 60, 0, 0, 0),
-- Lekon
("unset", 1, 32557, -184545, 243120, 1576, 0, 0, 25803, 60, 0, 0, 0),
-- Barrier Orb
("unset", 1, 32558, -186213, 242469, 2552, 0, 0, 3200, 60, 0, 0, 0),
-- Artius
("unset", 1, 32559, -186109, 242500, 2552, 0, 0, 53862, 60, 0, 0, 0),
-- Orbyu
("unset", 1, 32560, -186072, 241295, 2608, 0, 0, 41831, 60, 0, 0, 0),
-- Kunota
("unset", 1, 32561, -184773, 240380, 1568, 0, 0, 19400, 60, 0, 0, 0),
-- Siest
("unset", 1, 32562, -186170, 245014, 1568, 0, 0, 52199, 60, 0, 0, 0),
-- Plenos
("unset", 1, 32563, -186692, 243539, 2608, 0, 0, 37361, 60, 0, 0, 0),
-- Ginby
("unset", 1, 32566, -185090, 242809, 1576, 0, 0, 3200, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32606, -183661, 239438, 1280, 0, 0, 35999, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32607, -186762, 244230, 2664, 0, 0, 19409, 60, 0, 0, 0),
-- Tolonis
("unset", 1, 32611, -184406, 243017, 1576, 0, 0, 23162, 60, 0, 0, 0),
-- Thyimi
("unset", 1, 32618, -186650, 244239, 1568, 0, 0, 3200, 60, 0, 0, 0),
-- 
("unset", 1, 32619, -185169, 240805, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -184998, 240937, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185287, 240849, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185191, 240878, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -184976, 240865, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185116, 240979, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185384, 240819, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185213, 240950, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185072, 240835, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185502, 240861, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185458, 240717, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185480, 240790, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185020, 241009, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185406, 240891, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185265, 240777, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185362, 240747, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185094, 240907, 1568, 0, 0, 35800, 60, 0, 0, 0),
("unset", 1, 32619, -185309, 240921, 1568, 0, 0, 35800, 60, 0, 0, 0),
-- Anatole
("unset", 1, 32622, -184856, 245248, 1528, 0, 0, 3200, 60, 0, 0, 0),
-- Anbram
("unset", 1, 32624, -183543, 240912, 1528, 0, 0, 3200, 60, 0, 0, 0),
-- Royal Guard
("unset", 1, 32626, -186450, 242431, 2552, 0, 0, 3200, 60, 0, 0, 0),
("unset", 1, 32626, -186431, 242367, 2552, 0, 0, 3200, 60, 0, 0, 0),
-- Nottingale
("unset", 1, 32627, -186449, 243338, 2616, 0, 0, 46014, 60, 0, 0, 0),
-- Kbaldir
("Keucereus_Base", 1, 32733, -185957, 245068, 1568, 0, 0, 52054, 60, 0, 0, 0),
-- Lionel
("Keucereus_Alliance_Base", 1, 32782, -183980, 242722, 1576, 0, 0, 35544, 60, 0, 0, 0),
-- Emery Compressor
("unset", 1, 36570, -184110, 238592, 1432, 0, 0, 19200, 60, 0, 0, 0),

-- [15_25]

-- Zealot of Shilen
("Gludio_AirShip_Field", 1, 18782, -148656, 254304, -185, 0, 0, 0, 420, 0, 0, 0),
("Gludio_AirShip_Field", 1, 18782, -150107, 254288, -185, 0, 0, 0, 780, 0, 0, 0),
-- Papiku
("unset", 1, 32564, -149484, 253680, -184, 0, 0, 16384, 60, 0, 0, 0),
-- Felix
("unset", 1, 32565, -149235, 253680, -184, 0, 0, 16384, 60, 0, 0, 0),
-- Flight Control
("unset", 1, 32609, -149360, 252936, -136, 0, 0, 20771, 60, 0, 0, 0),
-- Lamcedas
("unset", 1, 32614, -149649, 255028, -80, 0, 0, 16384, 60, 0, 0, 0),
-- Ishuma
("unset", 1, 32615, -149067, 255028, -80, 0, 0, 16384, 60, 0, 0, 0),
-- Mine
("unset", 1, 32616, -148656, 253841, -184, 0, 0, 24576, 60, 0, 0, 0),
-- Wharf Patrol
("unset", 1, 32628, -148777, 254544, -186, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 32628, -148804, 254521, -187, 0, 0, 0, 60, 0, 0, 0),
-- Wharf Patrol
("unset", 1, 32629, -149929, 254543, -187, 0, 0, 0, 60, 0, 0, 0),
("unset", 1, 32629, -149909, 254506, -187, 0, 0, 0, 60, 0, 0, 0),

-- [16_12]

-- Rift Post Recruit
("ssqteleport1_npc1622_01", 1, 31488, -114224, -181504, -6752, 0, 0, 32768, 60, 0, 0, 0),
-- Rift Post Private
("ssqteleport1_npc1622_01", 1, 31489, -114216, -178698, -6752, 0, 0, 32768, 60, 0, 0, 0),
-- Rift Post Officer
("ssqteleport1_npc1622_01", 1, 31490, -114798, -178084, -6752, 0, 0, 49152, 60, 0, 0, 0),
-- Rift Post Captain
("ssqteleport1_npc1622_01", 1, 31491, -115362, -178692, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Rift Post Commander
("ssqteleport1_npc1622_01", 1, 31492, -115364, -181517, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Rift Post Hero
("ssqteleport1_npc1622_01", 1, 31493, -114793, -182125, -6752, 0, 0, 16384, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_31", 1, 31865, -111976, -182448, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_32", 1, 31866, -111088, -182448, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_33", 1, 31867, -110296, -180560, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_34", 1, 31868, -109416, -180560, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_35", 1, 31869, -113264, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_36", 1, 31870, -111592, -180560, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_37", 1, 31871, -109800, -182448, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_38", 1, 31872, -111592, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_39", 1, 31873, -109912, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_41", 1, 31874, -111976, -179624, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_42", 1, 31875, -111088, -179624, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_43", 1, 31876, -110296, -177744, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_44", 1, 31877, -109416, -177744, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_45", 1, 31878, -113264, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_46", 1, 31879, -111592, -177744, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_47", 1, 31880, -109800, -179624, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_48", 1, 31881, -111592, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_49", 1, 31882, -109912, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_51", 1, 31883, -113872, -175824, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_52", 1, 31884, -113872, -174944, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_53", 1, 31885, -115752, -174152, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_54", 1, 31886, -115752, -173264, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_55", 1, 31887, -114800, -177120, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_56", 1, 31888, -115760, -175440, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_57", 1, 31889, -113872, -173648, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_58", 1, 31890, -114800, -175440, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_59", 1, 31891, -114800, -173832, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_61", 1, 31892, -117632, -177760, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_62", 1, 31893, -118512, -177760, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_63", 1, 31894, -119304, -179640, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_64", 1, 31895, -120192, -179640, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_65", 1, 31896, -116336, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_66", 1, 31897, -118016, -179648, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_67", 1, 31898, -119808, -177760, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_68", 1, 31899, -118016, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_69", 1, 31900, -119696, -178688, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_71", 1, 31901, -117632, -180584, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_72", 1, 31902, -118512, -180584, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_73", 1, 31903, -119304, -182464, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_74", 1, 31904, -120192, -182464, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_75", 1, 31905, -116336, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_76", 1, 31906, -118016, -182464, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_77", 1, 31907, -119808, -180592, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_78", 1, 31908, -118016, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_79", 1, 31909, -119696, -181520, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_81", 1, 31910, -115728, -184384, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_82", 1, 31911, -115728, -185264, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_83", 1, 31912, -113856, -186064, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_84", 1, 31913, -113856, -186944, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_85", 1, 31914, -114800, -183088, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_86", 1, 31915, -113856, -184768, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_87", 1, 31916, -115728, -186423, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_1612_88", 1, 31917, -114800, -184768, -6752, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Border
("ssqteleport1_mb1612_89", 1, 31918, -114800, -186448, -6752, 0, 0, 0, 60, 0, 0, 0),

-- [16_13]

-- Guardian of Eastern Seal
("Chamber of Delusion", 1, 32658, -114602, -151279, -6720, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Western Seal
("Chamber of Delusion", 1, 32659, -114051, -151873, -6720, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Southern Seal
("Chamber of Delusion", 1, 32660, -115162, -151868, -6720, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Northern Seal
("Chamber of Delusion", 1, 32661, -115152, -154688, -6720, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Great Seal
("Chamber of Delusion", 1, 32662, -114608, -155280, -6720, 0, 0, 0, 60, 0, 0, 0),
-- Guardian of Tower of Seal
("Chamber of Delusion", 1, 32663, -114048, -154688, -6720, 0, 0, 0, 60, 0, 0, 0),

-- [16_19]

-- Worshipper
("unset", 1, 4327, -104260, 45060, -1464, 0, 0, 0, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, -104153, 45196, -1459, 0, 0, 7128, 0, 0, 0, 0),
("unset", 1, 4328, -104175, 44925, -1459, 0, 0, 51751, 0, 0, 0, 0),
-- Gremlin
("Kamael Island", 1, 18342, -125478, 38195, 1176, 0, 0, 21472, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -125039, 37647, 1144, 0, 0, 28655, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -125192, 37532, 1144, 0, 0, 26820, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -125000, 38530, 1152, 0, 0, 13787, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124845, 37478, 1144, 0, 0, 63524, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124932, 38757, 1144, 0, 0, 22184, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -125000, 37644, 1144, 0, 0, 2859, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124963, 37597, 1144, 0, 0, 33410, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -125084, 37611, 1144, 0, 0, 2555, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124675, 37657, 1176, 0, 0, 41865, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124834, 38638, 1144, 0, 0, 21215, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124748, 38655, 1160, 0, 0, 65515, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124314, 38658, 1176, 0, 0, 2058, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124371, 38732, 1176, 0, 0, 17975, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124257, 38591, 1176, 0, 0, 15784, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124411, 38732, 1176, 0, 0, 15264, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124765, 38582, 1152, 0, 0, 29864, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124589, 37667, 1176, 0, 0, 7519, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124464, 37741, 1176, 0, 0, 39664, 60, 0, 0, 0),
("Kamael Island", 1, 18342, -124538, 37573, 1176, 0, 0, 46672, 60, 0, 0, 0),
-- Black Wolf
("unset", 1, 20317, -124396, 57280, -2274, 0, 0, 22854, 60, 0, 0, 0),
("unset", 1, 20317, -124297, 57436, -2274, 0, 0, 10486, 60, 0, 0, 0),
("unset", 1, 20317, -123867, 57630, -2269, 0, 0, 14897, 60, 0, 0, 0),
("unset", 1, 20317, -123725, 57662, -2226, 0, 0, 2312, 60, 0, 0, 0),
("unset", 1, 20317, -123687, 57401, -2235, 0, 0, 50272, 60, 0, 0, 0),
("unset", 1, 20317, -124213, 57818, -2273, 0, 0, 22789, 60, 0, 0, 0),
("unset", 1, 20317, -124127, 57758, -2282, 0, 0, 58806, 60, 0, 0, 0),
("unset", 1, 20317, -123791, 58010, -2278, 0, 0, 5927, 60, 0, 0, 0),
("unset", 1, 20317, -124347, 57589, -2286, 0, 0, 51432, 60, 0, 0, 0),
("unset", 1, 20317, -124558, 58162, -2393, 0, 0, 20065, 60, 0, 0, 0),
("unset", 1, 20317, -124457, 58240, -2370, 0, 0, 6860, 60, 0, 0, 0),
("unset", 1, 20317, -124165, 58228, -2337, 0, 0, 7113, 60, 0, 0, 0),
("unset", 1, 20317, -123893, 58367, -2318, 0, 0, 6075, 60, 0, 0, 0),
("unset", 1, 20317, -125074, 59904, -2627, 0, 0, 23825, 60, 0, 0, 0),
("unset", 1, 20317, -125010, 60041, -2642, 0, 0, 6803, 60, 0, 0, 0),
("unset", 1, 20317, -124828, 60057, -2639, 0, 0, 62322, 60, 0, 0, 0),
("unset", 1, 20317, -124903, 60459, -2643, 0, 0, 16302, 60, 0, 0, 0),
("unset", 1, 20317, -125027, 60299, -2642, 0, 0, 42275, 60, 0, 0, 0),
("unset", 1, 20317, -125262, 59950, -2658, 0, 0, 49152, 60, 0, 0, 0),
("unset", 1, 20317, -125778, 60277, -2712, 0, 0, 32694, 60, 0, 0, 0),
("unset", 1, 20317, -126086, 60457, -2702, 0, 0, 34129, 60, 0, 0, 0),
("unset", 1, 20317, -125998, 60395, -2679, 0, 0, 59134, 60, 0, 0, 0),
("unset", 1, 20317, -126296, 60589, -2687, 0, 0, 23102, 60, 0, 0, 0),
("unset", 1, 20317, -126038, 60651, -2647, 0, 0, 64304, 60, 0, 0, 0),
("unset", 1, 20317, -125782, 60703, -2638, 0, 0, 1333, 60, 0, 0, 0),
("unset", 1, 20317, -125414, 61094, -2643, 0, 0, 19167, 60, 0, 0, 0),
("unset", 1, 20317, -125713, 60976, -2631, 0, 0, 33769, 60, 0, 0, 0),
("unset", 1, 20317, -125958, 60966, -2633, 0, 0, 39362, 60, 0, 0, 0),
("unset", 1, 20317, -126153, 60794, -2643, 0, 0, 35451, 60, 0, 0, 0),
("unset", 1, 20317, -126366, 60695, -2659, 0, 0, 37306, 60, 0, 0, 0),
("unset", 1, 20317, -126582, 60808, -2667, 0, 0, 27741, 60, 0, 0, 0),
("unset", 1, 20317, -126513, 60944, -2653, 0, 0, 11487, 60, 0, 0, 0),
("unset", 1, 20317, -126428, 61043, -2644, 0, 0, 8985, 60, 0, 0, 0),
("unset", 1, 20317, -126236, 61308, -2651, 0, 0, 11109, 60, 0, 0, 0),
("unset", 1, 20317, -126785, 61472, -2724, 0, 0, 19668, 60, 0, 0, 0),
("unset", 1, 20317, -126978, 61638, -2708, 0, 0, 13602, 60, 0, 0, 0),
("unset", 1, 20317, -127218, 61670, -2730, 0, 0, 31386, 60, 0, 0, 0),
("unset", 1, 20317, -127520, 61661, -2740, 0, 0, 26153, 60, 0, 0, 0),
("unset", 1, 20317, -127574, 61535, -2755, 0, 0, 49214, 60, 0, 0, 0),
("unset", 1, 20317, -127610, 61403, -2760, 0, 0, 46374, 60, 0, 0, 0),
("unset", 1, 20317, -127781, 61646, -2777, 0, 0, 22780, 60, 0, 0, 0),
("unset", 1, 20317, -127464, 61891, -2734, 0, 0, 6361, 60, 0, 0, 0),
("unset", 1, 20317, -127348, 62095, -2716, 0, 0, 13322, 60, 0, 0, 0),
("unset", 1, 20317, -127523, 62333, -2681, 0, 0, 22998, 60, 0, 0, 0),
("unset", 1, 20317, -127691, 62217, -2697, 0, 0, 39071, 60, 0, 0, 0),
("unset", 1, 20317, -127935, 62466, -2674, 0, 0, 29450, 60, 0, 0, 0),
("unset", 1, 20317, -127838, 62543, -2668, 0, 0, 6999, 60, 0, 0, 0),
("unset", 1, 20317, -127717, 62610, -2683, 0, 0, 5275, 60, 0, 0, 0),
("unset", 1, 20317, -127858, 62891, -2653, 0, 0, 14713, 60, 0, 0, 0),
("unset", 1, 20317, -128055, 62881, -2695, 0, 0, 33297, 60, 0, 0, 0),
("unset", 1, 20317, -127971, 63018, -2659, 0, 0, 10648, 60, 0, 0, 0),
("unset", 1, 20317, -127834, 63076, -2650, 0, 0, 4178, 60, 0, 0, 0),
("unset", 1, 20317, -127582, 62907, -2645, 0, 0, 60246, 60, 0, 0, 0),
("unset", 1, 20317, -127411, 62868, -2651, 0, 0, 10143, 60, 0, 0, 0),
("unset", 1, 20317, -127408, 63115, -2662, 0, 0, 20957, 60, 0, 0, 0),
("unset", 1, 20317, -127644, 63279, -2657, 0, 0, 27084, 60, 0, 0, 0),
("unset", 1, 20317, -127519, 63518, -2675, 0, 0, 12854, 60, 0, 0, 0),
("unset", 1, 20317, -127349, 63553, -2723, 0, 0, 58410, 60, 0, 0, 0),
("unset", 1, 20317, -127103, 63391, -2706, 0, 0, 57926, 60, 0, 0, 0),
("unset", 1, 20317, -126907, 62838, -2695, 0, 0, 52581, 60, 0, 0, 0),
("unset", 1, 20317, -126714, 62172, -2706, 0, 0, 52033, 60, 0, 0, 0),
("unset", 1, 20317, -120428, 60337, -2063, 0, 0, 45676, 60, 0, 0, 0),
("unset", 1, 20317, -120873, 60186, -2166, 0, 0, 25906, 60, 0, 0, 0),
("unset", 1, 20317, -120738, 60429, -2133, 0, 0, 11095, 60, 0, 0, 0),
("unset", 1, 20317, -121272, 60338, -2250, 0, 0, 13641, 60, 0, 0, 0),
("unset", 1, 20317, -121430, 60385, -2278, 0, 0, 29753, 60, 0, 0, 0),
("unset", 1, 20317, -121417, 60608, -2287, 0, 0, 35000, 60, 0, 0, 0),
("unset", 1, 20317, -121452, 60719, -2296, 0, 0, 19570, 60, 0, 0, 0),
("unset", 1, 20317, -121688, 60586, -2355, 0, 0, 54915, 60, 0, 0, 0),
("unset", 1, 20317, -121566, 60619, -2310, 0, 0, 2756, 60, 0, 0, 0),
("unset", 1, 20317, -122046, 60558, -2410, 0, 0, 34086, 60, 0, 0, 0),
("unset", 1, 20317, -121876, 60458, -2356, 0, 0, 59989, 60, 0, 0, 0),
("unset", 1, 20317, -122169, 60403, -2394, 0, 0, 7794, 60, 0, 0, 0),
("unset", 1, 20317, -122325, 60519, -2421, 0, 0, 26099, 60, 0, 0, 0),
("unset", 1, 20317, -122153, 60667, -2403, 0, 0, 114, 60, 0, 0, 0),
("unset", 1, 20317, -122107, 60922, -2406, 0, 0, 16933, 60, 0, 0, 0),
("unset", 1, 20317, -121885, 61033, -2409, 0, 0, 4837, 60, 0, 0, 0),
("unset", 1, 20317, -122109, 61247, -2433, 0, 0, 41049, 60, 0, 0, 0),
("unset", 1, 20317, -122412, 61444, -2496, 0, 0, 10492, 60, 0, 0, 0),
("unset", 1, 20317, -122751, 61881, -2544, 0, 0, 31173, 60, 0, 0, 0),
("unset", 1, 20317, -122673, 62494, -2563, 0, 0, 10473, 60, 0, 0, 0),
("unset", 1, 20317, -122511, 62691, -2572, 0, 0, 9206, 60, 0, 0, 0),
("unset", 1, 20317, -121977, 62982, -2522, 0, 0, 5731, 60, 0, 0, 0),
("unset", 1, 20317, -122227, 62871, -2526, 0, 0, 44175, 60, 0, 0, 0),
("unset", 1, 20317, -122076, 63113, -2543, 0, 0, 10566, 60, 0, 0, 0),
("unset", 1, 20317, -121788, 63455, -2517, 0, 0, 9087, 60, 0, 0, 0),
("unset", 1, 20317, -121804, 63667, -2489, 0, 0, 21840, 60, 0, 0, 0),
("unset", 1, 20317, -122015, 63715, -2514, 0, 0, 30435, 60, 0, 0, 0),
("unset", 1, 20317, -122188, 63767, -2564, 0, 0, 29723, 60, 0, 0, 0),
("unset", 1, 20317, -122030, 64030, -2535, 0, 0, 10731, 60, 0, 0, 0),
("unset", 1, 20317, -122163, 64151, -2525, 0, 0, 25485, 60, 0, 0, 0),
("unset", 1, 20317, -122287, 64011, -2549, 0, 0, 41591, 60, 0, 0, 0),
("unset", 1, 20317, -122479, 63670, -2549, 0, 0, 43787, 60, 0, 0, 0),
("unset", 1, 20317, -122406, 63417, -2569, 0, 0, 6105, 60, 0, 0, 0),
("unset", 1, 20317, -122397, 63277, -2563, 0, 0, 49821, 60, 0, 0, 0),
("unset", 1, 20317, -122958, 62953, -2581, 0, 0, 37656, 60, 0, 0, 0),
("unset", 1, 20317, -122972, 63348, -2611, 0, 0, 12000, 60, 0, 0, 0),
("unset", 1, 20317, -122792, 63544, -2599, 0, 0, 5892, 60, 0, 0, 0),
("unset", 1, 20317, -122694, 64040, -2601, 0, 0, 15486, 60, 0, 0, 0),
("unset", 1, 20317, -122808, 64335, -2618, 0, 0, 18174, 60, 0, 0, 0),
("unset", 1, 20317, -122853, 63963, -2641, 0, 0, 5958, 60, 0, 0, 0),
("unset", 1, 20317, -123208, 63372, -2615, 0, 0, 42375, 60, 0, 0, 0),
("unset", 1, 20317, -123586, 63228, -2643, 0, 0, 34342, 60, 0, 0, 0),
("unset", 1, 20317, -123371, 63638, -2653, 0, 0, 6423, 60, 0, 0, 0),
("unset", 1, 20317, -123278, 63498, -2639, 0, 0, 55267, 60, 0, 0, 0),
("unset", 1, 20317, -123829, 63403, -2661, 0, 0, 34557, 60, 0, 0, 0),
("unset", 1, 20317, -123598, 63674, -2668, 0, 0, 8911, 60, 0, 0, 0),
("unset", 1, 20317, -123282, 64192, -2637, 0, 0, 19313, 60, 0, 0, 0),
("unset", 1, 20317, -123389, 64244, -2642, 0, 0, 42999, 60, 0, 0, 0),
("unset", 1, 20317, -123629, 64008, -2656, 0, 0, 42531, 60, 0, 0, 0),
("unset", 1, 20317, -123748, 63722, -2666, 0, 0, 43296, 60, 0, 0, 0),
("unset", 1, 20317, -126872, 62638, -2724, 0, 0, 22318, 60, 0, 0, 0),
("unset", 1, 20317, -127166, 62534, -2707, 0, 0, 36314, 60, 0, 0, 0),
("unset", 1, 20317, -126313, 61901, -2733, 0, 0, 54313, 60, 0, 0, 0),
("unset", 1, 20317, -125686, 61570, -2685, 0, 0, 4921, 60, 0, 0, 0),
-- Grey Elpy
("Kamael Island", 1, 22228, -121558, 37934, 1416, 0, 0, 59770, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120836, 40009, 1368, 0, 0, 64083, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120822, 39995, 1360, 0, 0, 55391, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120008, 37813, 1400, 0, 0, 7452, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120242, 38834, 1416, 0, 0, 8863, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120197, 38566, 1416, 0, 0, 49721, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -119799, 38111, 1384, 0, 0, 20281, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -119793, 38138, 1384, 0, 0, 44719, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120469, 39799, 1360, 0, 0, 23946, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -120460, 39320, 1408, 0, 0, 26880, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -118191, 37783, 1296, 0, 0, 7015, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -116587, 38543, 1296, 0, 0, 6711, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -117497, 37749, 1280, 0, 0, 34492, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -118624, 37751, 1304, 0, 0, 35201, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -117573, 38437, 1352, 0, 0, 13448, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -118113, 38059, 1320, 0, 0, 24665, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -118520, 37335, 1320, 0, 0, 710, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -116350, 38366, 1296, 0, 0, 17145, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -122528, 41350, 1080, 0, 0, 18727, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -122437, 41471, 1096, 0, 0, 32767, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -124675, 45009, 888, 0, 0, 13088, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -124014, 44010, 888, 0, 0, 65157, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -124757, 43964, 936, 0, 0, 49721, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -123068, 44601, 968, 0, 0, 30359, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -125194, 46159, 984, 0, 0, 63715, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -125110, 46046, 960, 0, 0, 8828, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -125016, 46068, 944, 0, 0, 36667, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -123735, 45091, 912, 0, 0, 18293, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -124000, 45660, 904, 0, 0, 18349, 60, 0, 0, 0),
("Kamael Island", 1, 22228, -124842, 46238, 944, 0, 0, 36967, 60, 0, 0, 0),
-- Young Grey Keltir
("Kamael Island", 1, 22229, -121668, 38442, 1432, 0, 0, 6822, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121420, 40354, 1320, 0, 0, 53806, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120320, 38690, 1416, 0, 0, 18585, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120589, 38312, 1408, 0, 0, 3661, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120542, 37880, 1408, 0, 0, 41448, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119675, 37725, 1424, 0, 0, 36430, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119147, 38043, 1344, 0, 0, 12011, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119999, 37852, 1400, 0, 0, 30891, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120437, 40075, 1376, 0, 0, 36125, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120493, 40127, 1376, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120030, 39255, 1384, 0, 0, 11979, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116806, 37271, 1288, 0, 0, 3681, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117564, 37742, 1288, 0, 0, 16175, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117177, 37316, 1296, 0, 0, 49357, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117921, 37971, 1296, 0, 0, 65434, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116416, 38799, 1328, 0, 0, 33463, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116110, 38418, 1312, 0, 0, 54893, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116035, 38549, 1312, 0, 0, 18278, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -122591, 41499, 1064, 0, 0, 24428, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -122753, 41476, 1056, 0, 0, 50808, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123215, 44188, 920, 0, 0, 45362, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -122911, 44298, 960, 0, 0, 31079, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -125464, 45457, 944, 0, 0, 48328, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123872, 45580, 912, 0, 0, 39916, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124802, 46014, 928, 0, 0, 20223, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124661, 45259, 888, 0, 0, 56500, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123913, 46065, 928, 0, 0, 30136, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123321, 45287, 960, 0, 0, 7899, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123424, 45351, 952, 0, 0, 61340, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123290, 45315, 968, 0, 0, 60579, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116154, 50661, -696, 0, 0, 17629, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116557, 49472, -856, 0, 0, 15138, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -116616, 50154, -784, 0, 0, 7681, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124042, 55415, -1808, 0, 0, 14489, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119636, 55384, -1536, 0, 0, 42276, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119900, 58558, -1896, 0, 0, 4348, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120658, 59401, -2072, 0, 0, 17002, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120587, 59011, -2040, 0, 0, 6990, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119870, 58361, -1888, 0, 0, 3661, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123369, 54508, -1680, 0, 0, 21281, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123243, 54843, -1704, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -122164, 54527, -1496, 0, 0, 46453, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119802, 55258, -1528, 0, 0, 52703, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121069, 53587, -1344, 0, 0, 22516, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120973, 53695, -1360, 0, 0, 28363, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121044, 53887, -1376, 0, 0, 19443, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121979, 54601, -1496, 0, 0, 36451, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120470, 53759, -1272, 0, 0, 5566, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119613, 52363, -960, 0, 0, 47919, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120360, 53191, -1176, 0, 0, 56477, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121338, 52504, -1176, 0, 0, 43020, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119844, 52701, -1048, 0, 0, 3742, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -119167, 52418, -1088, 0, 0, 26808, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120496, 52850, -1200, 0, 0, 45051, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121054, 52748, -1232, 0, 0, 36430, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120405, 51954, -1016, 0, 0, 3030, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121059, 50711, -1104, 0, 0, 61492, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -121090, 50210, -1048, 0, 0, 59099, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120891, 50243, -1096, 0, 0, 13979, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120706, 50079, -1088, 0, 0, 28449, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120554, 51229, -1088, 0, 0, 17629, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -120698, 50102, -1064, 0, 0, 44317, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117150, 49233, -840, 0, 0, 65230, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117473, 49442, -912, 0, 0, 54631, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -117375, 49851, -896, 0, 0, 2058, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -118028, 50197, -984, 0, 0, 33602, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -118059, 50263, -984, 0, 0, 49766, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -118353, 51024, -1080, 0, 0, 26490, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -118313, 50686, -1056, 0, 0, 52748, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124922, 43923, 960, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124084, 44004, 888, 0, 0, 53001, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123443, 44634, 928, 0, 0, 44855, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -123246, 44540, 944, 0, 0, 28543, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124621, 44308, 896, 0, 0, 20352, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -122896, 43836, 912, 0, 0, 19968, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124094, 44969, 888, 0, 0, 58784, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124334, 45475, 888, 0, 0, 26808, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -124349, 45019, 880, 0, 0, 56573, 60, 0, 0, 0),
("Kamael Island", 1, 22229, -125473, 45431, 936, 0, 0, 9962, 60, 0, 0, 0),
-- Grey Keltir
("Kamael Island", 1, 22230, -121025, 58978, -2072, 0, 0, 42420, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120803, 59372, -2080, 0, 0, 51641, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119233, 55593, -1528, 0, 0, 16592, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119751, 57191, -1816, 0, 0, 21311, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119987, 57313, -1840, 0, 0, 11730, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119797, 56546, -1696, 0, 0, 60426, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119078, 57216, -1792, 0, 0, 3814, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120529, 56135, -1640, 0, 0, 47228, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120992, 57452, -1952, 0, 0, 21469, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120660, 56378, -1688, 0, 0, 51010, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120270, 57154, -1808, 0, 0, 64100, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -118993, 56079, -1600, 0, 0, 36125, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119654, 59052, -1888, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120457, 58461, -1960, 0, 0, 1436, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119580, 58695, -1856, 0, 0, 2921, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119688, 59180, -1928, 0, 0, 26346, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120078, 57683, -1880, 0, 0, 39936, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120026, 58450, -1904, 0, 0, 57200, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121814, 54675, -1504, 0, 0, 64517, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -122179, 54639, -1512, 0, 0, 8873, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -122455, 54308, -1496, 0, 0, 27095, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -123655, 54639, -1728, 0, 0, 45797, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -123778, 54538, -1728, 0, 0, 58355, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119877, 53482, -1192, 0, 0, 55905, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120617, 53222, -1256, 0, 0, 57779, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119949, 53348, -1176, 0, 0, 9071, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120802, 53176, -1264, 0, 0, 38441, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120421, 52444, -1160, 0, 0, 52154, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119767, 52370, -968, 0, 0, 31316, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120661, 52278, -1176, 0, 0, 23842, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -119945, 52363, -968, 0, 0, 2355, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121031, 52635, -1224, 0, 0, 36125, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120691, 52114, -1144, 0, 0, 34346, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121123, 51898, -1120, 0, 0, 35274, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121431, 51625, -1048, 0, 0, 35862, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121136, 52088, -1128, 0, 0, 22804, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121304, 51215, -1080, 0, 0, 49974, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121364, 51381, -1056, 0, 0, 52055, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120930, 50334, -1096, 0, 0, 55681, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -121097, 50553, -1072, 0, 0, 57634, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -120466, 50402, -1040, 0, 0, 45797, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -118054, 49695, -920, 0, 0, 6437, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -117658, 51025, -784, 0, 0, 38759, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -117156, 49512, -904, 0, 0, 63212, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -117731, 49735, -928, 0, 0, 63080, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -117076, 50651, -744, 0, 0, 28213, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -118154, 49951, -960, 0, 0, 19542, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -118065, 50144, -968, 0, 0, 40228, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -117962, 50116, -960, 0, 0, 50776, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -116285, 49727, -800, 0, 0, 38388, 60, 0, 0, 0),
("Kamael Island", 1, 22230, -116734, 50875, -696, 0, 0, 62634, 60, 0, 0, 0),
-- Dominant Grey Keltir
("Kamael Island", 1, 22231, -123748, 64119, -2656, 0, 0, 2355, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -122734, 63416, -2584, 0, 0, 27743, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123549, 62733, -2592, 0, 0, 54907, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -126713, 63388, -2648, 0, 0, 19772, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123978, 63421, -2696, 0, 0, 31727, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123217, 62451, -2544, 0, 0, 40575, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -122089, 61932, -2464, 0, 0, 42564, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -124254, 59675, -2592, 0, 0, 21407, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123584, 59184, -2480, 0, 0, 11547, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -124148, 58629, -2376, 0, 0, 58212, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123985, 59600, -2568, 0, 0, 29182, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123609, 55942, -1880, 0, 0, 25122, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -122613, 55781, -1712, 0, 0, 21219, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -123643, 54719, -1728, 0, 0, 4957, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -122981, 54888, -1664, 0, 0, 64720, 60, 0, 0, 0),
("Kamael Island", 1, 22231, -122230, 54543, -1512, 0, 0, 27438, 60, 0, 0, 0),
-- Black Wolf
("Kamael Island", 1, 22232, -122648, 63742, -2584, 0, 0, 16383, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -126171, 63365, -2632, 0, 0, 12610, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122688, 63374, -2584, 0, 0, 29025, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -124192, 63378, -2736, 0, 0, 13780, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -126999, 62564, -2680, 0, 0, 23015, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122645, 61298, -2512, 0, 0, 23578, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122100, 61653, -2448, 0, 0, 52757, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -124041, 59418, -2536, 0, 0, 61227, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122134, 59619, -2376, 0, 0, 63707, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -123754, 59165, -2456, 0, 0, 18986, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -123733, 59072, -2424, 0, 0, 55041, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -124719, 58133, -2368, 0, 0, 8960, 60, 0, 0, 0),
-- Dominant Black Wolf
("Kamael Island", 1, 22233, -123311, 64537, -2624, 0, 0, 1981, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123118, 63535, -2616, 0, 0, 50827, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123440, 64321, -2640, 0, 0, 61227, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122707, 62959, -2560, 0, 0, 53376, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -126769, 62649, -2688, 0, 0, 5721, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122698, 63174, -2576, 0, 0, 16784, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -126573, 63042, -2656, 0, 0, 55394, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122480, 62500, -2528, 0, 0, 25374, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122903, 62784, -2552, 0, 0, 65340, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123104, 63168, -2600, 0, 0, 52591, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122481, 62857, -2536, 0, 0, 56928, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124192, 63320, -2736, 0, 0, 1175, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -126984, 63034, -2680, 0, 0, 18986, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123463, 61758, -2656, 0, 0, 32968, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122241, 62001, -2496, 0, 0, 32767, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -121528, 61687, -2336, 0, 0, 39931, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122607, 63612, -2576, 0, 0, 22590, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -126422, 61504, -2672, 0, 0, 30260, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124194, 59700, -2592, 0, 0, 61568, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123561, 58756, -2336, 0, 0, 60582, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123844, 59284, -2496, 0, 0, 20921, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123600, 58546, -2280, 0, 0, 17845, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123595, 58966, -2408, 0, 0, 31767, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124456, 58987, -2464, 0, 0, 61095, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124021, 57591, -2232, 0, 0, 3170, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124370, 57592, -2272, 0, 0, 58039, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124244, 57623, -2272, 0, 0, 4703, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -124605, 57820, -2320, 0, 0, 16251, 60, 0, 0, 0),
("unset", 1, 22233, -127022, 61477, -2709, 0, 0, 36191, 60, 0, 0, 0),
("unset", 1, 22233, -127295, 61496, -2737, 0, 0, 44806, 60, 0, 0, 0),
("unset", 1, 22233, -127683, 62383, -2674, 0, 0, 15882, 60, 0, 0, 0),
("unset", 1, 22233, -127885, 62724, -2659, 0, 0, 26550, 60, 0, 0, 0),
-- Muertos Archer
("Kamael Island", 1, 22236, -105414, 61653, -2960, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -104893, 62389, -2912, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -104644, 63136, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -106310, 63016, -2856, 0, 0, 13200, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -105208, 63288, -2896, 0, 0, 19375, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -103973, 62837, -2888, 0, 0, 44715, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -106478, 59178, -2696, 0, 0, 4601, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -107877, 60037, -2528, 0, 0, 21219, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108256, 59979, -2600, 0, 0, 16295, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -104859, 64833, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109435, 59878, -2512, 0, 0, 24604, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109458, 60910, -2664, 0, 0, 51542, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109380, 60704, -2656, 0, 0, 9599, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110313, 61653, -2720, 0, 0, 40961, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108773, 61988, -2608, 0, 0, 10629, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112314, 63436, -2656, 0, 0, 11429, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114176, 63400, -2584, 0, 0, 63476, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112790, 63819, -2656, 0, 0, 12479, 60, 0, 0, 0),
-- Mountain Fungus
("Kamael Island", 1, 22237, -105869, 59452, -2704, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -105545, 60332, -2816, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -106567, 59243, -2680, 0, 0, 49686, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -106918, 60095, -2536, 0, 0, 21843, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -106933, 60414, -2544, 0, 0, 57693, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -107706, 60708, -2560, 0, 0, 27023, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -107813, 60772, -2568, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -107813, 62092, -2920, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -106651, 64771, -2728, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -107806, 64008, -2808, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110314, 61298, -2680, 0, 0, 56618, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108956, 59912, -2592, 0, 0, 48792, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109757, 61872, -2688, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110366, 61534, -2712, 0, 0, 19399, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109291, 64117, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108708, 64247, -2896, 0, 0, 24575, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112355, 63459, -2656, 0, 0, 20508, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -111761, 63375, -2592, 0, 0, 17793, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113314, 62654, -2616, 0, 0, 28986, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114527, 64279, -2568, 0, 0, 25954, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114292, 63816, -2584, 0, 0, 15510, 60, 0, 0, 0),
-- Mountain Werewolf Chief
("Kamael Island", 1, 22238, -99574, 59788, -3496, 0, 0, 58158, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -100936, 59887, -3448, 0, 0, 31867, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -100839, 60804, -3456, 0, 0, 7015, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -101062, 60105, -3456, 0, 0, 44781, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -101388, 60287, -3392, 0, 0, 25806, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -101068, 60669, -3464, 0, 0, 39481, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -105387, 59785, -2728, 0, 0, 5799, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -105599, 61653, -2968, 0, 0, 60278, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -104674, 62289, -2896, 0, 0, 23452, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -105153, 62675, -2904, 0, 0, 2934, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -101571, 62323, -3328, 0, 0, 56633, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -101682, 62536, -3320, 0, 0, 9131, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -102317, 61919, -3344, 0, 0, 42757, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -106747, 59144, -2672, 0, 0, 61289, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108448, 60568, -2576, 0, 0, 64528, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -107914, 60312, -2496, 0, 0, 53841, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -106517, 60992, -2848, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -106377, 60852, -2816, 0, 0, 22210, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108136, 63899, -2856, 0, 0, 26788, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -107971, 63572, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108466, 63899, -2928, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -104489, 63985, -2856, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -102856, 63812, -3296, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -104304, 63561, -2912, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108943, 60411, -2640, 0, 0, 13886, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108530, 60973, -2544, 0, 0, 16766, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -108642, 60977, -2544, 0, 0, 40927, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -109276, 60807, -2624, 0, 0, 14143, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -109114, 60911, -2592, 0, 0, 62121, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -110050, 61863, -2760, 0, 0, 36411, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -110094, 62419, -2808, 0, 0, 2616, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -109170, 64125, -2904, 0, 0, 44867, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -111752, 63467, -2592, 0, 0, 17910, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -112837, 63365, -2640, 0, 0, 40201, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -114583, 64431, -2536, 0, 0, 14278, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -112713, 64119, -2648, 0, 0, 58248, 60, 0, 0, 0),
("Kamael Island", 1, 22238, -113368, 65040, -2616, 0, 0, 33152, 60, 0, 0, 0),
-- Muertos Guard
("Kamael Island", 1, 22239, -99955, 60354, -3456, 0, 0, 28986, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -100616, 60882, -3456, 0, 0, 15987, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -100829, 59964, -3448, 0, 0, 50865, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -100445, 59859, -3440, 0, 0, 30749, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -100925, 59819, -3440, 0, 0, 32314, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -100300, 60002, -3456, 0, 0, 16788, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -105599, 62289, -2928, 0, 0, 49981, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -102856, 61964, -3280, 0, 0, 13828, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -104727, 63136, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -104810, 63136, -2904, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -104561, 63468, -2912, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -104433, 63427, -2912, 0, 0, 9960, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -103934, 62925, -2856, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -103396, 62651, -2856, 0, 0, 46304, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -101856, 61765, -3384, 0, 0, 14531, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -107641, 64008, -2784, 0, 0, 1826, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -106651, 64117, -2816, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -107971, 64117, -2824, 0, 0, 2756, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -103260, 64120, -3208, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -102957, 63812, -3272, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -104119, 64197, -2968, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22239, -109030, 64322, -2848, 0, 0, 14966, 60, 0, 0, 0),
-- Muertos Scout
("Kamael Island", 1, 22240, -111062, 46262, -1032, 0, 0, 13055, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111043, 47029, -1040, 0, 0, 30630, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111011, 47213, -1032, 0, 0, 63171, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111639, 47593, -960, 0, 0, 40722, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111241, 47670, -960, 0, 0, 23641, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -110884, 47483, -992, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -112138, 47628, -912, 0, 0, 53989, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -110911, 48803, -1064, 0, 0, 58825, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111925, 47785, -944, 0, 0, 7678, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -111638, 47278, -968, 0, 0, 45368, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -110046, 50248, -960, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109850, 50816, -1008, 0, 0, 50337, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109066, 50532, -1072, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109303, 51617, -1000, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109027, 52027, -984, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109654, 51384, -1016, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109654, 51526, -1016, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108870, 51810, -1008, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -109458, 51668, -1000, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108071, 48014, -1464, 0, 0, 53559, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108750, 47150, -1400, 0, 0, 12972, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108426, 45870, -1440, 0, 0, 64849, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106337, 46077, -1528, 0, 0, 18441, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108531, 47186, -1440, 0, 0, 10396, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108529, 46835, -1392, 0, 0, 4635, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107091, 46505, -1400, 0, 0, 33122, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107607, 47611, -1448, 0, 0, 52176, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108318, 47449, -1464, 0, 0, 62139, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -108159, 47717, -1456, 0, 0, 45133, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106499, 47662, -1408, 0, 0, 30298, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106769, 47276, -1472, 0, 0, 31773, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107845, 43340, -1448, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107048, 43582, -1448, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106837, 43458, -1568, 0, 0, 18702, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106674, 42985, -1552, 0, 0, 25791, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107907, 42610, -1440, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -107782, 42305, -1440, 0, 0, 27929, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106447, 41087, -1680, 0, 0, 12047, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106944, 41698, -1528, 0, 0, 48484, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106675, 42171, -1408, 0, 0, 12909, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106622, 41141, -1624, 0, 0, 23525, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106590, 41435, -1608, 0, 0, 64132, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106449, 43121, -1752, 0, 0, 65070, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104418, 41045, -1888, 0, 0, 59458, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105456, 43768, -1680, 0, 0, 52343, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105108, 44184, -1608, 0, 0, 6315, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105496, 43505, -1720, 0, 0, 55433, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105869, 45071, -1448, 0, 0, 33835, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -106130, 45074, -1456, 0, 0, 48493, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105719, 45260, -1440, 0, 0, 13844, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104820, 45119, -1496, 0, 0, 58825, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105101, 45565, -1520, 0, 0, 55469, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103129, 44010, -1432, 0, 0, 57113, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103828, 43781, -1432, 0, 0, 41085, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103570, 44963, -1344, 0, 0, 50725, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103414, 44270, -1448, 0, 0, 48459, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103569, 44095, -1448, 0, 0, 7637, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103119, 46454, -1136, 0, 0, 2650, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103126, 46016, -1152, 0, 0, 12733, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104443, 46141, -1328, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -102909, 46196, -1144, 0, 0, 60662, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -102760, 46234, -1144, 0, 0, 32061, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103525, 46130, -1120, 0, 0, 11547, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105351, 40391, -1824, 0, 0, 14169, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104536, 40826, -1792, 0, 0, 17625, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104591, 39962, -1840, 0, 0, 49853, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -105175, 39787, -1776, 0, 0, 13552, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -104727, 40561, -1800, 0, 0, 19359, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103993, 40033, -1816, 0, 0, 10067, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -103930, 39637, -1800, 0, 0, 6975, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -102773, 40075, -2032, 0, 0, 33474, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -102512, 39951, -2112, 0, 0, 4066, 60, 0, 0, 0),
-- Colossus
("Kamael Island", 1, 22241, -111246, 46926, -1016, 0, 0, 44930, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111961, 46210, -912, 0, 0, 20045, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111134, 46479, -1016, 0, 0, 56766, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111523, 46269, -944, 0, 0, 35928, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111000, 45894, -1056, 0, 0, 27559, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111510, 45894, -1008, 0, 0, 22574, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111007, 45583, -1088, 0, 0, 53084, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -112078, 47652, -928, 0, 0, 40888, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -110859, 48047, -960, 0, 0, 33186, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -111478, 47891, -960, 0, 0, 34424, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109527, 47081, -1264, 0, 0, 40305, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109630, 47916, -1192, 0, 0, 11494, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109487, 50879, -1000, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108713, 50767, -1032, 0, 0, 20525, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108828, 50624, -1072, 0, 0, 11916, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109066, 51668, -1008, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109262, 51810, -984, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109066, 51952, -992, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -110242, 51242, -1024, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108674, 52236, -968, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107848, 47208, -1456, 0, 0, 21592, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108316, 46278, -1392, 0, 0, 22342, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -109029, 46235, -1312, 0, 0, 17526, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107005, 45279, -1632, 0, 0, 11362, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107576, 46269, -1288, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106867, 46888, -1432, 0, 0, 37373, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107410, 46684, -1424, 0, 0, 48431, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107701, 47552, -1440, 0, 0, 20223, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107065, 47808, -1464, 0, 0, 60287, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108509, 50601, -1016, 0, 0, 20787, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108162, 43614, -1440, 0, 0, 20533, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107603, 43031, -1448, 0, 0, 62408, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107639, 43420, -1424, 0, 0, 41347, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106618, 43514, -1744, 0, 0, 61154, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107899, 42832, -1440, 0, 0, 15035, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107631, 42915, -1440, 0, 0, 21876, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108027, 42920, -1440, 0, 0, 52445, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107642, 42437, -1464, 0, 0, 13862, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -108020, 43208, -1440, 0, 0, 17834, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106684, 41606, -1552, 0, 0, 21562, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -107267, 42838, -1432, 0, 0, 38617, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105773, 41336, -1792, 0, 0, 31727, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105908, 41612, -1816, 0, 0, 9561, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105782, 44870, -1464, 0, 0, 46648, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105561, 43610, -1704, 0, 0, 39785, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105107, 43576, -1648, 0, 0, 58116, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104782, 44233, -1392, 0, 0, 43586, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106376, 44420, -1696, 0, 0, 30464, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105881, 45358, -1440, 0, 0, 21126, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106220, 45179, -1456, 0, 0, 49162, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105761, 44957, -1456, 0, 0, 42732, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105291, 46729, -1504, 0, 0, 23550, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104623, 46400, -1448, 0, 0, 37467, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106613, 47252, -1480, 0, 0, 22516, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -106073, 47102, -1504, 0, 0, 13778, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103641, 44104, -1448, 0, 0, 28163, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103615, 44531, -1432, 0, 0, 33186, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103314, 44346, -1440, 0, 0, 19215, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104418, 44371, -1408, 0, 0, 41253, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -102852, 44284, -1424, 0, 0, 17766, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103532, 43597, -1408, 0, 0, 41401, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103473, 45157, -1304, 0, 0, 38902, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -102687, 46441, -1144, 0, 0, 55173, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -102354, 46156, -1112, 0, 0, 65332, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104950, 40347, -1832, 0, 0, 2058, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104340, 40248, -1824, 0, 0, 42564, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105434, 40696, -1824, 0, 0, 62652, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -105582, 40354, -1816, 0, 0, 40160, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104367, 40837, -1800, 0, 0, 18938, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103203, 39612, -1832, 0, 0, 16590, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -104126, 39839, -1824, 0, 0, 25467, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -102714, 39599, -1968, 0, 0, 63999, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103610, 39934, -1824, 0, 0, 30464, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103231, 39878, -1864, 0, 0, 1364, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -102909, 40314, -1992, 0, 0, 58496, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -103105, 39858, -1904, 0, 0, 52379, 60, 0, 0, 0),
-- Muertos Warrior
("Kamael Island", 1, 22242, -106810, 44986, -1632, 0, 0, 41705, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -106751, 45772, -1584, 0, 0, 6903, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -107021, 47307, -1464, 0, 0, 13652, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -107330, 47194, -1464, 0, 0, 16774, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -106362, 44509, -1704, 0, 0, 18243, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -105641, 45531, -1432, 0, 0, 15856, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -105726, 45446, -1432, 0, 0, 40472, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -105469, 46423, -1512, 0, 0, 3552, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -105856, 45460, -1432, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -105907, 45495, -1432, 0, 0, 1711, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -104236, 43809, -1416, 0, 0, 18851, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103416, 44344, -1440, 0, 0, 17443, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103145, 44626, -1424, 0, 0, 48802, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103222, 44614, -1432, 0, 0, 10096, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103500, 43621, -1408, 0, 0, 26144, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103630, 45292, -1328, 0, 0, 57406, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103976, 44926, -1440, 0, 0, 58273, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103050, 46123, -1144, 0, 0, 51177, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -103366, 46353, -1144, 0, 0, 3895, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -102373, 46844, -1128, 0, 0, 63341, 60, 0, 0, 0),
-- Lottery Ticket Seller
("unset", 1, 30990, -117079, 47175, 448, 0, 0, 16384, 60, 0, 0, 0),
-- Grand Olympiad Manager
("unset", 1, 31688, -115008, 47488, 496, 0, 0, 37504, 60, 0, 0, 0),
-- Monument of Heroes 
("unset", 1, 31690, -114991, 47563, 496, 0, 0, 32768, 60, 0, 0, 0),
-- Perwan
("unset", 1, 32133, -125872, 38208, 1232, 0, 0, 0, 60, 0, 0, 0),
-- Newbie Helper
("unset", 1, 32134, -125872, 38016, 1232, 0, 0, 0, 60, 0, 0, 0),
-- Newbie Helper
("unset", 1, 32135, -119692, 44504, 360, 0, 0, 33324, 60, 0, 0, 0),
-- Basil
("unset", 1, 32136, -122400, 38432, 1440, 0, 0, 0, 60, 0, 0, 0),
-- Sucrete
("unset", 1, 32137, -122396, 37784, 1432, 0, 0, 0, 60, 0, 0, 0),
-- Kekropus
("unset", 1, 32138, -118080, 42835, 712, 0, 0, 15964, 60, 0, 0, 0),
-- Casca
("unset", 1, 32139, -118132, 42788, 712, 0, 0, 17008, 60, 0, 0, 0),
-- Zenya
("unset", 1, 32140, -118028, 42778, 712, 0, 0, 16688, 60, 0, 0, 0),
-- Nerga
("unset", 1, 32141, -119104, 43280, 544, 0, 0, 0, 60, 0, 0, 0),
-- Tenor
("unset", 1, 32142, -119104, 43152, 544, 0, 0, 0, 60, 0, 0, 0),
-- Belkis
("unset", 1, 32143, -117056, 43168, 544, 0, 0, 33556, 60, 0, 0, 0),
-- Xonia
("unset", 1, 32144, -117060, 43296, 544, 0, 0, 32568, 60, 0, 0, 0),
-- Maynard
("unset", 1, 32145, -118192, 42384, 824, 0, 0, 16400, 60, 0, 0, 0),
-- Valfar
("unset", 1, 32146, -117968, 42384, 824, 0, 0, 15880, 60, 0, 0, 0),
-- Rivian
("unset", 1, 32147, -120400, 46921, 400, 0, 0, 0, 60, 0, 0, 0),
-- Cindet
("unset", 1, 32148, -120407, 46755, 408, 0, 0, 0, 60, 0, 0, 0),
-- Ennear
("unset", 1, 32149, -120442, 47125, 408, 0, 0, 0, 60, 0, 0, 0),
-- Took
("unset", 1, 32150, -120294, 46013, 384, 0, 0, 16416, 60, 0, 0, 0),
-- Herz
("unset", 1, 32151, -120157, 45813, 344, 0, 0, 16416, 60, 0, 0, 0),
-- Henri
("unset", 1, 32152, -120158, 46221, 344, 0, 0, 49252, 60, 0, 0, 0),
-- Franco
("unset", 1, 32153, -120432, 45296, 408, 0, 0, 45056, 60, 0, 0, 0),
-- Aldenia
("unset", 1, 32154, -120706, 45079, 408, 0, 0, 6956, 60, 0, 0, 0),
-- Nabot
("unset", 1, 32155, -120356, 45293, 408, 0, 0, 45392, 60, 0, 0, 0),
-- Talbot
("unset", 1, 32156, -120604, 44960, 408, 0, 0, 24308, 60, 0, 0, 0),
-- Moka
("unset", 1, 32157, -117824, 48080, 464, 0, 0, 50060, 60, 0, 0, 0),
-- Fisler
("unset", 1, 32158, -117605, 48079, 456, 0, 0, 43644, 60, 0, 0, 0),
-- Kincaid
("unset", 1, 32159, -118030, 47930, 456, 0, 0, 0, 60, 0, 0, 0),
-- Devon
("unset", 1, 32160, -118720, 48062, 464, 0, 0, 49308, 60, 0, 0, 0),
-- Black
("unset", 1, 32161, -118527, 47955, 464, 0, 0, 32936, 60, 0, 0, 0),
-- Martika
("unset", 1, 32162, -118918, 47956, 464, 0, 0, 0, 60, 0, 0, 0),
-- Teleport Device
("unset", 1, 32163, -116879, 46591, 360, 0, 0, 44352, 60, 0, 0, 0),
-- Erinu
("unset", 1, 32164, -115888, 43568, 524, 0, 0, 8372, 60, 0, 0, 0),
-- Zakone
("unset", 1, 32165, -115486, 43567, 525, 0, 0, 24616, 60, 0, 0, 0),
-- Trevor
("unset", 1, 32166, -116749, 48077, 462, 0, 0, 41732, 60, 0, 0, 0),
-- Nika
("unset", 1, 32167, -117153, 48075, 456, 0, 0, 58116, 60, 0, 0, 0),
-- Benis
("unset", 1, 32170, -114975, 44658, 512, 0, 0, 15332, 60, 0, 0, 0),
-- Hoffa
("unset", 1, 32171, -114802, 44821, 524, 0, 0, 32144, 60, 0, 0, 0),
-- Saylem
("unset", 1, 32172, -114801, 45031, 525, 0, 0, 32164, 60, 0, 0, 0),
-- Marcela
("unset", 1, 32173, -119378, 49242, 8, 0, 0, 32812, 60, 0, 0, 0),
-- Maddy
("unset", 1, 32174, -119774, 49245, 8, 0, 0, 0, 60, 0, 0, 0),
-- Bixon
("unset", 1, 32175, -119830, 51860, -792, 0, 0, 2960, 60, 0, 0, 0),
-- Ambra
("unset", 1, 32176, -119362, 51862, -792, 0, 0, 31496, 60, 0, 0, 0),
-- Syzar
("unset", 1, 32177, -112872, 46850, 48, 0, 0, 8944, 60, 0, 0, 0),
-- Carver
("unset", 1, 32178, -112352, 47392, 48, 0, 0, 41568, 60, 0, 0, 0),
-- Putin
("unset", 1, 32179, -110544, 49040, -1128, 0, 0, 63440, 60, 0, 0, 0),
-- Kato
("unset", 1, 32180, -110536, 45162, -1128, 0, 0, 3072, 60, 0, 0, 0),
-- Hanarin
("unset", 1, 32191, -124624, 51584, -540, 0, 0, 8172, 60, 0, 0, 0),
-- Falken
("unset", 1, 32192, -124064, 51584, -540, 0, 0, 22896, 60, 0, 0, 0),
-- Marksman
("Kamael Island", 1, 32335, -117363, 38449, 1328, 0, 0, 63872, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -124570, 45944, 920, 0, 0, 9766, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -110900, 46093, -1040, 0, 0, 64236, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -107864, 48329, -1424, 0, 0, 32928, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -104017, 42471, -1912, 0, 0, 6395, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -103892, 44887, -1432, 0, 0, 7172, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -107777, 62680, -2976, 0, 0, 42400, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -102448, 64126, -3256, 0, 0, 54930, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -111186, 62110, -2592, 0, 0, 16621, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -124570, 63088, -2776, 0, 0, 29962, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -122260, 60127, -2392, 0, 0, 38351, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -122074, 56592, -1976, 0, 0, 6659, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -117290, 50962, -744, 0, 0, 6996, 60, 0, 0, 0),
-- Adventure Guildsman
("unset", 1, 32337, -119808, 47760, 403, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("unset", 1, 32338, -120048, 45296, 405, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("unset", 1, 32339, -115680, 44144, 515, 0, 0, 17712, 60, 0, 0, 0),
-- Adventure Guildsman
("unset", 1, 32340, -115088, 46784, 515, 0, 0, -32572, 60, 0, 0, 0),
-- Burang
("unset", 1, 32348, -116944, 48144, 456, 0, 0, 49152, 60, 0, 0, 0),
-- Eindburgh
("Kamael Village", 1, 32469, -111519, 41742, 2175, 0, 0, 31385, 60, 0, 0, 0),
-- Dimensional Merchant
("unset", 1, 32478, -115215, 45059, 496, 0, 0, 32768, 60, 0, 0, 0),
-- Manor Manager
("unset", 1, 36456, -115169, 44156, 512, 0, 0, 25360, 60, 0, 0, 0),

-- [16_20]

-- Black Wolf
("unset", 1, 20317, -123140, 72347, -2957, 0, 0, 46848, 60, 0, 0, 0),
("unset", 1, 20317, -122842, 72599, -2967, 0, 0, 63841, 60, 0, 0, 0),
("unset", 1, 20317, -122754, 72116, -2984, 0, 0, 49913, 60, 0, 0, 0),
("unset", 1, 20317, -122872, 72161, -2978, 0, 0, 1504, 60, 0, 0, 0),
("unset", 1, 20317, -123012, 71995, -2979, 0, 0, 44894, 60, 0, 0, 0),
("unset", 1, 20317, -121752, 72287, -2963, 0, 0, 6631, 60, 0, 0, 0),
("unset", 1, 20317, -122281, 71680, -2992, 0, 0, 63692, 60, 0, 0, 0),
("unset", 1, 20317, -123275, 69408, -3066, 0, 0, 58318, 60, 0, 0, 0),
("unset", 1, 20317, -123673, 69549, -3116, 0, 0, 38345, 60, 0, 0, 0),
("unset", 1, 20317, -123382, 69403, -3088, 0, 0, 4437, 60, 0, 0, 0),
("unset", 1, 20317, -123840, 69120, -3094, 0, 0, 8192, 60, 0, 0, 0),
("unset", 1, 20317, -123691, 68804, -3077, 0, 0, 50373, 60, 0, 0, 0),
("unset", 1, 20317, -123869, 68491, -3029, 0, 0, 64238, 60, 0, 0, 0),
("unset", 1, 20317, -123719, 68551, -3020, 0, 0, 25271, 60, 0, 0, 0),
-- Black Wolf
("Kamael Island", 1, 22232, -122840, 72088, -2976, 0, 0, 42718, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122592, 71941, -2992, 0, 0, 6272, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -122849, 71379, -3064, 0, 0, 45734, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -123395, 70821, -3128, 0, 0, 25279, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -123603, 69389, -3096, 0, 0, 6975, 60, 0, 0, 0),
("Kamael Island", 1, 22232, -123767, 68916, -3056, 0, 0, 39123, 60, 0, 0, 0),
-- Dominant Black Wolf
("Kamael Island", 1, 22233, -123109, 71678, -3016, 0, 0, 41100, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122958, 72148, -2968, 0, 0, 5365, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -122237, 71474, -2944, 0, 0, 45111, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123236, 69741, -3056, 0, 0, 30260, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123790, 68770, -3048, 0, 0, 44324, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123401, 69432, -3088, 0, 0, 56650, 60, 0, 0, 0),
("Kamael Island", 1, 22233, -123366, 69388, -3056, 0, 0, 41100, 60, 0, 0, 0),
-- Green Goblin
("Kamael Island", 1, 22234, -112948, 83052, -3304, 0, 0, 14097, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -113041, 82990, -3304, 0, 0, 52100, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -113508, 82945, -3296, 0, 0, 64885, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -114213, 84309, -3176, 0, 0, 54282, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -115545, 83473, -3208, 0, 0, 43894, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -115090, 83039, -3208, 0, 0, 55046, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -116713, 83098, -3128, 0, 0, 31698, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -114943, 82249, -3136, 0, 0, 58290, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -115796, 84527, -3184, 0, 0, 4482, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -115874, 86104, -3552, 0, 0, 22518, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -119211, 88323, -3360, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -118755, 89024, -3688, 0, 0, 1547, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -116794, 87058, -3552, 0, 0, 40289, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -116732, 86070, -3552, 0, 0, 19025, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121292, 86866, -3480, 0, 0, 59525, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -120603, 84898, -3504, 0, 0, 45023, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -118706, 84380, -3416, 0, 0, 58730, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -118752, 84453, -3416, 0, 0, 2012, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125004, 83394, -3384, 0, 0, 27507, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126044, 83033, -3400, 0, 0, 21406, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125958, 83348, -3408, 0, 0, 15669, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125784, 82414, -3416, 0, 0, 45487, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121606, 81600, -3088, 0, 0, 6428, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125045, 81892, -3440, 0, 0, 58896, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125822, 80228, -3488, 0, 0, 42757, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125393, 81477, -3432, 0, 0, 18419, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -123536, 80454, -3424, 0, 0, 23813, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -123745, 79689, -3432, 0, 0, 39844, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121156, 80886, -3112, 0, 0, 39576, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121841, 80400, -3120, 0, 0, 13987, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121430, 80768, -3096, 0, 0, 34072, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -122034, 80635, -3120, 0, 0, 44317, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121594, 80859, -3096, 0, 0, 63896, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121032, 79644, -3048, 0, 0, 47171, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126167, 77772, -3424, 0, 0, 16381, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -123455, 78578, -3384, 0, 0, 47739, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -123707, 78688, -3400, 0, 0, 52185, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121895, 78282, -3168, 0, 0, 26783, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121720, 79984, -3120, 0, 0, 42512, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -121982, 77721, -3144, 0, 0, 44950, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125646, 77792, -3352, 0, 0, 36261, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125869, 77369, -3360, 0, 0, 13799, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126363, 76414, -3280, 0, 0, 31472, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126515, 76329, -3280, 0, 0, 27263, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126029, 75245, -3304, 0, 0, 34677, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -125528, 75677, -3312, 0, 0, 14635, 60, 0, 0, 0),
("Kamael Island", 1, 22234, -126746, 74967, -3320, 0, 0, 46446, 60, 0, 0, 0),
-- Mountain Werewolf
("Kamael Island", 1, 22235, -112210, 91690, -3184, 0, 0, 4920, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112619, 91908, -3176, 0, 0, 42125, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115094, 89492, -3568, 0, 0, 39747, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115679, 89438, -3672, 0, 0, 25417, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115126, 88989, -3680, 0, 0, 64591, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -116340, 89857, -3344, 0, 0, 27376, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112835, 92432, -3168, 0, 0, 21134, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118425, 88325, -3576, 0, 0, 1226, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118743, 88568, -3616, 0, 0, 64591, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118909, 90826, -3640, 0, 0, 16638, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119611, 92186, -3664, 0, 0, 18106, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120258, 91241, -3632, 0, 0, 8726, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120257, 90280, -3632, 0, 0, 38968, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119079, 91307, -3624, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119262, 91348, -3616, 0, 0, 48396, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119986, 90811, -3600, 0, 0, 39304, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118780, 87619, -3400, 0, 0, 12185, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118677, 87590, -3400, 0, 0, 62737, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118015, 87766, -3440, 0, 0, 44359, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120033, 87105, -3520, 0, 0, 11604, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119755, 86657, -3520, 0, 0, 62467, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120042, 86639, -3520, 0, 0, 48108, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -119796, 88078, -3392, 0, 0, 63441, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -116498, 86327, -3552, 0, 0, 15180, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -118761, 86305, -3400, 0, 0, 29971, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121168, 90647, -3656, 0, 0, 28186, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121560, 90436, -3656, 0, 0, 33245, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122071, 89457, -3696, 0, 0, 15575, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122399, 85406, -3592, 0, 0, 46872, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120338, 84075, -3424, 0, 0, 31817, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -126059, 83069, -3400, 0, 0, 11973, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125208, 82592, -3408, 0, 0, 13836, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125275, 82442, -3392, 0, 0, 55600, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -124964, 81152, -3480, 0, 0, 19574, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125028, 81170, -3472, 0, 0, 38560, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125793, 80455, -3496, 0, 0, 45079, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125117, 80602, -3536, 0, 0, 1901, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -123628, 80053, -3440, 0, 0, 26951, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122090, 80548, -3120, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120803, 81526, -3120, 0, 0, 1836, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122267, 80170, -3088, 0, 0, 21326, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121818, 79801, -3136, 0, 0, 25841, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121224, 80665, -3096, 0, 0, 3341, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -123503, 79555, -3432, 0, 0, 18985, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122494, 79071, -3200, 0, 0, 6302, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -123084, 79586, -3416, 0, 0, 18098, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125522, 77786, -3344, 0, 0, 61462, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -123610, 77975, -3352, 0, 0, 57879, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -122591, 78434, -3208, 0, 0, 35401, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121723, 78056, -3144, 0, 0, 44232, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -121809, 78257, -3176, 0, 0, 59981, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -120590, 79774, -3048, 0, 0, 65347, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125437, 77081, -3312, 0, 0, 10421, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -125996, 75033, -3296, 0, 0, 59535, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115346, 72913, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115674, 72913, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115674, 72714, -3120, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112886, 73709, -3224, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113870, 72913, -3152, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -114690, 74306, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -114854, 74505, -3120, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -114690, 74505, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113856, 75661, -3176, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112328, 75661, -3184, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109646, 75752, -3184, 0, 0, 43672, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -108980, 74767, -2928, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109202, 74570, -2984, 0, 0, 44987, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109646, 76737, -3056, 0, 0, 59622, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112563, 76268, -3200, 0, 0, 30413, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113283, 77452, -3200, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -111946, 77054, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112435, 79348, -3392, 0, 0, 43386, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109219, 79665, -3280, 0, 0, 55469, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -108500, 78700, -3248, 0, 0, 8370, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -110466, 78832, -3336, 0, 0, 1892, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109767, 80335, -3192, 0, 0, 30662, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -108950, 80780, -3280, 0, 0, 13289, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113474, 80348, -3368, 0, 0, 33531, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112858, 81639, -3408, 0, 0, 44359, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113050, 79717, -3352, 0, 0, 45201, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -114453, 83382, -3128, 0, 0, 46215, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113201, 82400, -3336, 0, 0, 62764, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113457, 83247, -3304, 0, 0, 55338, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -111517, 83829, -3368, 0, 0, 10496, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -111428, 83301, -3328, 0, 0, 46483, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109010, 82224, -3472, 0, 0, 17910, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -110503, 82278, -3608, 0, 0, 8370, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -108816, 82150, -3408, 0, 0, 51249, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109875, 83089, -3600, 0, 0, 55338, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112798, 85030, -3432, 0, 0, 55770, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113441, 83927, -3392, 0, 0, 37067, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113790, 85769, -3352, 0, 0, 57545, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -110723, 84410, -3560, 0, 0, 14212, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112923, 86606, -3464, 0, 0, 13357, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113623, 87384, -3608, 0, 0, 19469, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109424, 86655, -3328, 0, 0, 64685, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109272, 87656, -3248, 0, 0, 37972, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -108980, 87964, -3248, 0, 0, 710, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109826, 86765, -3368, 0, 0, 37972, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109298, 88184, -3272, 0, 0, 30351, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -109564, 87696, -3376, 0, 0, 17333, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115564, 83580, -3208, 0, 0, 39007, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115466, 83793, -3208, 0, 0, 51777, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115053, 83653, -3208, 0, 0, 56544, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115918, 83967, -3168, 0, 0, 47539, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -116015, 84909, -3120, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -115923, 86505, -3552, 0, 0, 29864, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113036, 88473, -3296, 0, 0, 56053, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -111317, 88908, -3272, 0, 0, 50432, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113130, 88173, -3344, 0, 0, 48774, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112007, 89855, -3320, 0, 0, 54391, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -111528, 90685, -3288, 0, 0, 39405, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -113596, 91029, -3320, 0, 0, 63589, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112614, 92123, -3176, 0, 0, 945, 60, 0, 0, 0),
("Kamael Island", 1, 22235, -112588, 91163, -3280, 0, 0, 5555, 60, 0, 0, 0),
-- Muertos Archer
("Kamael Island", 1, 22236, -111233, 71094, -2872, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110906, 71253, -2840, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115510, 71520, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114854, 71719, -3112, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114690, 72515, -3144, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115182, 72515, -3104, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113050, 73510, -3224, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114362, 73311, -3152, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113706, 72515, -3208, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112432, 72048, -3080, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114690, 74107, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113283, 75462, -3200, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109202, 74570, -2984, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112901, 76855, -3200, 0, 0, 46545, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114062, 77026, -3176, 0, 0, 43777, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111946, 76656, -3152, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109757, 75949, -3184, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108869, 77328, -2960, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114581, 77724, -3128, 0, 0, 25137, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112534, 79484, -3392, 0, 0, 3466, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112760, 79791, -3384, 0, 0, 20862, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109387, 79426, -3280, 0, 0, 13978, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109764, 79390, -3264, 0, 0, 13662, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108763, 78856, -3248, 0, 0, 33475, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112917, 80584, -3320, 0, 0, 32590, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113412, 80566, -3384, 0, 0, 12805, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110594, 80949, -3520, 0, 0, 17386, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109685, 79723, -3280, 0, 0, 6976, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110598, 79944, -3344, 0, 0, 10641, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113677, 82918, -3312, 0, 0, 18520, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113587, 83523, -3328, 0, 0, 17043, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109175, 83419, -3608, 0, 0, 43494, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109275, 84200, -3592, 0, 0, 42545, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108856, 83531, -3600, 0, 0, 47789, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109892, 83782, -3608, 0, 0, 35834, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110167, 84214, -3608, 0, 0, 28683, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110262, 84973, -3432, 0, 0, 65102, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113507, 84878, -3344, 0, 0, 37010, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114444, 84651, -3200, 0, 0, 61810, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114603, 85284, -3424, 0, 0, 64315, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -110910, 85512, -3672, 0, 0, 3854, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108338, 83893, -3560, 0, 0, 21338, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109900, 84247, -3608, 0, 0, 14267, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114267, 86280, -3544, 0, 0, 21634, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113770, 88009, -3616, 0, 0, 54958, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109726, 87874, -3416, 0, 0, 47747, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115379, 87791, -3488, 0, 0, 15706, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115779, 82548, -3208, 0, 0, 2329, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115855, 83833, -3192, 0, 0, 65276, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115772, 83297, -3208, 0, 0, 26020, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -116001, 83106, -3208, 0, 0, 27341, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115727, 84299, -3032, 0, 0, 51814, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114507, 89153, -3272, 0, 0, 25936, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111871, 89965, -3328, 0, 0, 53754, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111618, 89612, -3320, 0, 0, 18419, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -112041, 89817, -3320, 0, 0, 34492, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111523, 89567, -3304, 0, 0, 2650, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111965, 89269, -3320, 0, 0, 35453, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109612, 88171, -3424, 0, 0, 48191, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -108538, 88491, -3224, 0, 0, 51983, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109148, 88451, -3272, 0, 0, 20094, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -109258, 87853, -3264, 0, 0, 22997, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111131, 90548, -3248, 0, 0, 21667, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113116, 91082, -3288, 0, 0, 49283, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -111985, 90413, -3320, 0, 0, 12169, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -113993, 91176, -3328, 0, 0, 57530, 60, 0, 0, 0),
("unset", 1, 22236, -119483, 92740, -3751, 0, 0, 65503, 60, 0, 0, 0),
("unset", 1, 22236, -118932, 92718, -3717, 0, 0, 60989, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115314, 89212, -3680, 0, 0, 45257, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -114817, 88555, -3696, 0, 0, 35324, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115623, 89154, -3704, 0, 0, 44844, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -115164, 88699, -3704, 0, 0, 19359, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -116268, 88433, -3488, 0, 0, 49158, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -117637, 88689, -3680, 0, 0, 55191, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -119854, 91444, -3624, 0, 0, 41333, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -119923, 91684, -3640, 0, 0, 34274, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -120401, 91864, -3720, 0, 0, 31701, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -120967, 91625, -3712, 0, 0, 12545, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -119388, 87863, -3392, 0, 0, 2052, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -119573, 86028, -3496, 0, 0, 59495, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -116594, 86133, -3552, 0, 0, 56913, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -117173, 86965, -3544, 0, 0, 31023, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -116778, 86954, -3552, 0, 0, 30372, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -120936, 86560, -3520, 0, 0, 260, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -121714, 91381, -3672, 0, 0, 50949, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -121692, 88886, -3712, 0, 0, 49218, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122009, 89452, -3696, 0, 0, 53402, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -121973, 90169, -3592, 0, 0, 12610, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122163, 90947, -3584, 0, 0, 27780, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122066, 90747, -3576, 0, 0, 11725, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122320, 85509, -3584, 0, 0, 29959, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122164, 85519, -3576, 0, 0, 51177, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -118722, 84199, -3384, 0, 0, 62886, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -121602, 83011, -3368, 0, 0, 44930, 60, 0, 0, 0),
("Kamael Island", 1, 22236, -122620, 82791, -3496, 0, 0, 58930, 60, 0, 0, 0),
-- Mountain Fungus
("Kamael Island", 1, 22237, -111887, 70299, -2928, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112868, 71253, -3104, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -111778, 70935, -3024, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112323, 71094, -3088, 0, 0, 33374, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -115182, 73510, -3144, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -115018, 72913, -3144, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -115018, 72714, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114854, 72316, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114854, 72515, -3128, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113378, 73709, -3104, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113706, 73112, -3096, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114362, 73709, -3144, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -111233, 72048, -2968, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113665, 75263, -3184, 0, 0, 1750, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109424, 75555, -3168, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109424, 74373, -3032, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108869, 75555, -2920, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112519, 76258, -3200, 0, 0, 37219, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114047, 75860, -3168, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113412, 76262, -3200, 0, 0, 733, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113474, 75860, -3200, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -114429, 76656, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109868, 77525, -2992, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112920, 79140, -3336, 0, 0, 51437, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108915, 79282, -3280, 0, 0, 64156, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109750, 79092, -3288, 0, 0, 18538, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108622, 78626, -3224, 0, 0, 15936, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113809, 80247, -3296, 0, 0, 21218, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108586, 80516, -3232, 0, 0, 13070, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -108828, 80145, -3280, 0, 0, 41468, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -112633, 80478, -3328, 0, 0, 11310, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -113176, 80806, -3360, 0, 0, 56002, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110237, 81320, -3512, 0, 0, 10213, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109156, 81141, -3328, 0, 0, 40961, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110334, 81266, -3520, 0, 0, 52380, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110453, 82905, -3608, 0, 0, 57019, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110606, 82884, -3568, 0, 0, 65531, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109358, 84290, -3568, 0, 0, 54602, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110374, 84258, -3600, 0, 0, 3062, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -109970, 84161, -3608, 0, 0, 63047, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110909, 85658, -3672, 0, 0, 47318, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -111681, 85029, -3520, 0, 0, 52615, 60, 0, 0, 0),
("Kamael Island", 1, 22237, -110282, 85035, -3432, 0, 0, 0, 60, 0, 0, 0),
-- Mellon
("unset", 1, 32181, -122360, 73206, -2872, 0, 0, 40960, 60, 0, 0, 0),
-- Coplan
("unset", 1, 32182, -122118, 73302, -2872, 0, 0, 0, 60, 0, 0, 0),
-- Yunha
("unset", 1, 32183, -122254, 73438, -2872, 0, 0, 16384, 60, 0, 0, 0),
-- Rodenpicula
("Nornil Garden", 1, 32237, -119832, 87098, -12608, 0, 0, 0, 240, 0, 0, 0),
-- Mother Nornil
("Nornil Garden", 1, 32239, -120080, 87176, -12608, 0, 0, 0, 240, 0, 0, 0),
-- Marksman
("Kamael Island", 1, 32335, -113933, 72067, -3136, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -112631, 78053, -3096, 0, 0, 34508, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -111861, 80846, -3520, 0, 0, 1280, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -109576, 87763, -3384, 0, 0, 16225, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -115813, 86463, -3552, 0, 0, 38741, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -111844, 89063, -3320, 0, 0, 53424, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -115927, 90142, -3360, 0, 0, 62875, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -118114, 90850, -3408, 0, 0, 38351, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -126133, 83062, -3408, 0, 0, 5082, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -125073, 72456, -2688, 0, 0, 35439, 60, 0, 0, 0),
-- Marksman
("Kamael Island", 1, 32336, -122057, 74316, -3000, 0, 0, 16576, 60, 0, 0, 0),
("Kamael Island", 1, 32336, -122455, 72302, -2976, 0, 0, 49232, 60, 0, 0, 0),

-- [16_24]

-- Stone Golem
("Talking_Island", 1, 20016, -102066, 228127, -3656, 0, 0, 59667, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -103105, 228033, -3704, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -106583, 227737, -3528, 0, 0, 64720, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -105811, 224546, -3640, 0, 0, 22901, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -103780, 223010, -3440, 0, 0, 15551, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -104030, 223096, -3440, 0, 0, 53806, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -102101, 225451, -3680, 0, 0, 49701, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101723, 225419, -3664, 0, 0, 1364, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -104281, 217588, -3120, 0, 0, 44686, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101319, 214963, -3232, 0, 0, 6132, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101287, 215181, -3240, 0, 0, 1436, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101944, 215858, -3296, 0, 0, 59516, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -100125, 215119, -3304, 0, 0, 44363, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -102866, 213581, -3144, 0, 0, 37697, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101817, 214338, -3200, 0, 0, 29807, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -99554, 214608, -3208, 0, 0, 41906, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -105014, 216576, -3232, 0, 0, 5158, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -106292, 215626, -3280, 0, 0, 17952, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -104464, 216630, -3256, 0, 0, 9260, 20, 0, 0, 0),
-- Orc Fighter Leader
("Talking_Island", 1, 20098, -107208, 226403, -3632, 0, 0, 59099, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -107521, 225689, -3600, 0, 0, 65257, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -106830, 225485, -3632, 0, 0, 39576, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -106045, 226005, -3672, 0, 0, 23123, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -106638, 224823, -3616, 0, 0, 24577, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -106706, 224191, -3608, 0, 0, 19388, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -105805, 223055, -3632, 0, 0, 32555, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -105731, 222999, -3616, 0, 0, 10289, 20, 0, 0, 0),
-- Crasher
("Talking_Island", 1, 20101, -103846, 227388, -3656, 0, 0, 41828, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -103943, 226455, -3632, 0, 0, 20223, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -106519, 225089, -3632, 0, 0, 49766, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -105606, 224597, -3640, 0, 0, 38902, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -106024, 223607, -3648, 0, 0, 32350, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -104396, 217614, -3112, 0, 0, 11854, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -103438, 217055, -3312, 0, 0, 43586, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -99576, 215146, -3312, 0, 0, 34583, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -102666, 214500, -3232, 0, 0, 46672, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -100921, 213376, -3088, 0, 0, 22660, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -101963, 214415, -3208, 0, 0, 54534, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -99560, 215158, -3312, 0, 0, 25751, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -107092, 215430, -3312, 0, 0, 43095, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -107755, 216192, -3264, 0, 0, 1019, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -108474, 216079, -3264, 0, 0, 29147, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -104522, 217424, -3152, 0, 0, 22144, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -109074, 215442, -3248, 0, 0, 41840, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -111753, 216421, -3168, 0, 0, 13678, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -110720, 217937, -2968, 0, 0, 37512, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -110309, 218116, -2960, 0, 0, 40995, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -113902, 218976, -3152, 0, 0, 2258, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -113275, 217777, -3096, 0, 0, 34747, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -114445, 220017, -3088, 0, 0, 41540, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -114948, 219858, -3112, 0, 0, 41253, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -116004, 227238, -2784, 0, 0, 3918, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -117491, 227411, -2896, 0, 0, 45362, 20, 0, 0, 0),
-- Giant Spider
("Talking_Island", 1, 20103, -105974, 223945, -3640, 0, 0, 56231, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -107333, 215560, -3288, 0, 0, 32864, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -106858, 216014, -3248, 0, 0, 29216, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -108435, 216537, -3280, 0, 0, 36897, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -111735, 216856, -3120, 0, 0, 14999, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -110668, 216771, -3168, 0, 0, 27529, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -112311, 217457, -3096, 0, 0, 41203, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -110330, 217886, -2960, 0, 0, 52170, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -114465, 218575, -3080, 0, 0, 37485, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -113732, 219619, -3072, 0, 0, 16515, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -116273, 220777, -3064, 0, 0, 53892, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -116902, 222917, -3048, 0, 0, 9979, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -115277, 224513, -2800, 0, 0, 46156, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -115782, 223855, -2880, 0, 0, 27013, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -115989, 223263, -2928, 0, 0, 4522, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -117753, 227151, -2880, 0, 0, 6224, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -117251, 228960, -2864, 0, 0, 62697, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -118138, 228308, -2864, 0, 0, 19050, 20, 0, 0, 0),
-- Talon Spider
("Talking_Island", 1, 20106, -117015, 221616, -3040, 0, 0, 11952, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -116157, 224472, -2920, 0, 0, 16383, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -116002, 225103, -2856, 0, 0, 56507, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -115969, 226580, -2784, 0, 0, 51046, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -115598, 226140, -2728, 0, 0, 54400, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -118256, 227618, -2840, 0, 0, 36501, 20, 0, 0, 0),
-- Werewolf Chieftain
("Talking_Island", 1, 20342, -106640, 227270, -3616, 0, 0, 44444, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -106542, 226783, -3648, 0, 0, 7610, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -106553, 226876, -3640, 0, 0, 12002, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -106853, 227383, -3624, 0, 0, 38349, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -107013, 224543, -3600, 0, 0, 62710, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -105625, 223215, -3608, 0, 0, 945, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -105100, 223132, -3576, 0, 0, 54984, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -105262, 223088, -3568, 0, 0, 43130, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104624, 221418, -3432, 0, 0, 23744, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103390, 222032, -3440, 0, 0, 16431, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103509, 222211, -3440, 0, 0, 48490, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103394, 222397, -3416, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -101573, 222478, -3312, 0, 0, 5625, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -100956, 223683, -3440, 0, 0, 58548, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -100198, 224119, -3440, 0, 0, 53289, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -100888, 223201, -3400, 0, 0, 1660, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -102003, 224148, -3608, 0, 0, 30027, 20, 0, 0, 0),
-- Marius
("Talking_Island_Npc", 1, 30405, -115080, 222168, -2928, 0, 0, 42000, 60, 0, 0, 0),
-- Mesella
("Talking_Island_Npc", 1, 30407, -104240, 222064, -3440, 0, 0, 16384, 60, 0, 0, 0),
-- Edmond
("Talking_Island_Npc", 1, 30497, -114685, 222291, -2928, 0, 0, 44000, 60, 0, 0, 0),
-- Guard
("Talking_Island_Npc", 1, 31032, -107079, 222548, -3504, 0, 0, 60658, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -108073, 223050, -3320, 0, 0, 65252, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -103715, 219240, -2872, 0, 0, 19724, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -104900, 218224, -2960, 0, 0, 62614, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -113552, 220493, -2912, 0, 0, 22404, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -114731, 221050, -2944, 0, 0, 51830, 60, 0, 0, 0),

-- [16_25]

-- Orc Archer
("Talking_Island", 1, 20006, -101473, 247996, -3424, 0, 0, 23196, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -100507, 246584, -3600, 0, 0, 11305, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -100400, 249973, -3448, 0, 0, 18515, 20, 0, 0, 0),
-- Stone Golem
("Talking_Island", 1, 20016, -101297, 230649, -3544, 0, 0, 25308, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -101026, 230118, -3616, 0, 0, 32251, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -103747, 229743, -3720, 0, 0, 14203, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -104956, 229482, -3720, 0, 0, 58499, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -106164, 233389, -3640, 0, 0, 53027, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -105223, 234531, -3608, 0, 0, 16487, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -106583, 233457, -3616, 0, 0, 50374, 20, 0, 0, 0),
("Talking_Island", 1, 20016, -106750, 233439, -3608, 0, 0, 55512, 20, 0, 0, 0),
-- Orc Fighter
("Talking_Island", 1, 20093, -104617, 250752, -3384, 0, 0, 3489, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -103217, 245563, -3592, 0, 0, 17654, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -104315, 246176, -3464, 0, 0, 46598, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -103199, 247673, -3376, 0, 0, 24995, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -101912, 248003, -3400, 0, 0, 3871, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -100439, 249796, -3440, 0, 0, 32910, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -100517, 248592, -3464, 0, 0, 28641, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -101765, 253928, -3312, 0, 0, 16965, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -100888, 253858, -3368, 0, 0, 63849, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -100521, 253525, -3424, 0, 0, 22840, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -101766, 253523, -3352, 0, 0, 29922, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -103552, 252085, -3376, 0, 0, 3864, 20, 0, 0, 0),
-- Orc Lieutenant
("Talking_Island", 1, 20096, -109751, 253377, -3320, 0, 0, 51979, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -108204, 252104, -3336, 0, 0, 19739, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -108372, 252001, -3336, 0, 0, 62114, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -107765, 252170, -3336, 0, 0, 65047, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -107218, 247848, -3312, 0, 0, 8191, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -107682, 246821, -3256, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -106486, 248010, -3376, 0, 0, 17845, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -104582, 248773, -3392, 0, 0, 13278, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -104855, 251216, -3384, 0, 0, 24650, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -107178, 245435, -3288, 0, 0, 41110, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -106534, 244963, -3360, 0, 0, 29075, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -102811, 244862, -3672, 0, 0, 47258, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -102952, 244752, -3664, 0, 0, 30549, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -103398, 246565, -3496, 0, 0, 33562, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -102862, 249697, -3360, 0, 0, 17811, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -101500, 252947, -3384, 0, 0, 24189, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -101638, 254241, -3296, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -100951, 254998, -3256, 0, 0, 47361, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -103550, 250553, -3424, 0, 0, 26634, 20, 0, 0, 0),
("Talking_Island", 1, 20096, -100766, 251379, -3448, 0, 0, 27937, 20, 0, 0, 0),
-- Orc Fighter Leader
("Talking_Island", 1, 20098, -108735, 252765, -3320, 0, 0, 31317, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -109566, 253387, -3320, 0, 0, 32220, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -110094, 253518, -3320, 0, 0, 34092, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -109056, 253433, -3312, 0, 0, 55591, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -106773, 251968, -3368, 0, 0, 19762, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -107950, 249033, -3256, 0, 0, 20551, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -107992, 246875, -3224, 0, 0, 48244, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -104990, 250961, -3376, 0, 0, 35836, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -107007, 245098, -3328, 0, 0, 65530, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -103714, 248646, -3376, 0, 0, 36637, 20, 0, 0, 0),
("Talking_Island", 1, 20098, -102494, 252975, -3320, 0, 0, 49889, 20, 0, 0, 0),
-- Crasher
("Talking_Island", 1, 20101, -118082, 236739, -3040, 0, 0, 16280, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -118544, 235558, -2896, 0, 0, 20429, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -116550, 243796, -3168, 0, 0, 39646, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -115992, 246155, -3224, 0, 0, 39094, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -114986, 246695, -3184, 0, 0, 39936, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -113909, 244823, -3352, 0, 0, 19014, 20, 0, 0, 0),
("Talking_Island", 1, 20101, -113823, 244886, -3344, 0, 0, 11916, 20, 0, 0, 0),
-- Giant Spider
("Talking_Island", 1, 20103, -119340, 229900, -2872, 0, 0, 46047, 20, 0, 0, 0),
("Talking_Island", 1, 20103, -119572, 232082, -2848, 0, 0, 619, 20, 0, 0, 0),
-- Talon Spider
("Talking_Island", 1, 20106, -119454, 230923, -2872, 0, 0, 12877, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -117719, 230592, -2928, 0, 0, 51029, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -119016, 231584, -2880, 0, 0, 22992, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -119979, 235867, -2824, 0, 0, 26983, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -119392, 236833, -2856, 0, 0, 23476, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -118710, 236512, -2944, 0, 0, 60289, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -118017, 239194, -2984, 0, 0, 59344, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -117454, 239105, -2968, 0, 0, 6951, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -117423, 240312, -3112, 0, 0, 44745, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -116925, 240779, -3112, 0, 0, 58565, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -118493, 240395, -3160, 0, 0, 36271, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -116103, 244074, -3176, 0, 0, 45094, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -115434, 244656, -3152, 0, 0, 56835, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -114323, 244133, -3168, 0, 0, 6315, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -115104, 248521, -3224, 0, 0, 8185, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -114165, 248644, -3128, 0, 0, 32466, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -114340, 248640, -3120, 0, 0, 15686, 20, 0, 0, 0),
("Talking_Island", 1, 20106, -113868, 249601, -3224, 0, 0, 53268, 20, 0, 0, 0),
-- Blade Spider
("Talking_Island", 1, 20108, -119653, 235050, -2888, 0, 0, 56786, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -121408, 235297, -3680, 0, 0, 43390, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -118555, 237406, -2928, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -119030, 239680, -3080, 0, 0, 28076, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -117203, 238820, -2904, 0, 0, 17179, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -117333, 238358, -2904, 0, 0, 33809, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -118202, 240924, -3184, 0, 0, 52073, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -116693, 240647, -3112, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -115825, 243499, -3128, 0, 0, 59995, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -116727, 246480, -3200, 0, 0, 15001, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -116515, 247772, -3184, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -113790, 247966, -3024, 0, 0, 25936, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -115853, 249563, -3264, 0, 0, 5357, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -115007, 248796, -3224, 0, 0, 19404, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -115095, 248767, -3232, 0, 0, 41426, 20, 0, 0, 0),
("Talking_Island", 1, 20108, -113710, 249147, -3208, 0, 0, 7246, 20, 0, 0, 0),
-- Werewolf
("Talking_Island", 1, 20132, -100355, 239910, -3632, 0, 0, 13794, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -100391, 240375, -3608, 0, 0, 46674, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -100722, 240904, -3504, 0, 0, 58145, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -100628, 242854, -3624, 0, 0, 23495, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -101037, 242710, -3608, 0, 0, 24373, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -98931, 233843, -3312, 0, 0, 64358, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -99806, 234116, -3256, 0, 0, 54749, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -99241, 234029, -3272, 0, 0, 32896, 20, 0, 0, 0);
INSERT INTO `spawnlist` VALUES
("Talking_Island", 1, 20132, -106262, 236865, -3648, 0, 0, 8796, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -104412, 238785, -3560, 0, 0, 10974, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -104348, 239086, -3536, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -100623, 247074, -3528, 0, 0, 28527, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -102586, 248154, -3384, 0, 0, 46036, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -100367, 248203, -3488, 0, 0, 18367, 20, 0, 0, 0),
-- Goblin Scout
("Talking_Island", 1, 20326, -101610, 241693, -3528, 0, 0, 25841, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -101783, 242233, -3576, 0, 0, 43787, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -101815, 253711, -3320, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -101434, 253391, -3368, 0, 0, 27931, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -100870, 254739, -3296, 0, 0, 61758, 20, 0, 0, 0),
-- Werewolf Chieftain
("Talking_Island", 1, 20342, -101863, 230259, -3664, 0, 0, 25024, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -101044, 231756, -3376, 0, 0, 1226, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -101821, 232203, -3416, 0, 0, 14044, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -102239, 232831, -3488, 0, 0, 10747, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103347, 233401, -3552, 0, 0, 48144, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103867, 229595, -3720, 0, 0, 5344, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -102445, 231470, -3648, 0, 0, 13874, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -106250, 230552, -3736, 0, 0, 19830, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -105686, 232806, -3688, 0, 0, 1660, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -105837, 231601, -3720, 0, 0, 16431, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104919, 234819, -3624, 0, 0, 47887, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -103259, 233874, -3480, 0, 0, 44232, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -102638, 233509, -3488, 0, 0, 30569, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104208, 234750, -3552, 0, 0, 46215, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -107063, 230300, -3656, 0, 0, 59013, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104397, 239506, -3488, 0, 0, 5685, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104405, 238632, -3560, 0, 0, 60362, 20, 0, 0, 0),
("Talking_Island", 1, 20342, -104419, 239312, -3520, 0, 0, 6447, 20, 0, 0, 0),
-- Werewolf Hunter
("Talking_Island", 1, 20343, -101011, 241109, -3456, 0, 0, 29170, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -102248, 240104, -3368, 0, 0, 45937, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -100881, 241697, -3536, 0, 0, 26511, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -100493, 241943, -3584, 0, 0, 6067, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -102132, 235427, -3352, 0, 0, 9267, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -101818, 232865, -3424, 0, 0, 39205, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -102549, 231448, -3656, 0, 0, 4074, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -102959, 233195, -3560, 0, 0, 27959, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -104706, 235279, -3624, 0, 0, 34921, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -105522, 233463, -3648, 0, 0, 24037, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -103618, 233315, -3600, 0, 0, 55325, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -103469, 234772, -3488, 0, 0, 60982, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -106774, 232796, -3392, 0, 0, 0, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -104402, 237489, -3600, 0, 0, 11334, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -104372, 238122, -3544, 0, 0, 10421, 20, 0, 0, 0),
("Talking_Island", 1, 20343, -104346, 238352, -3552, 0, 0, 8359, 20, 0, 0, 0),
-- Spirit Of Mirrors
("Talking_Island", 1, 27004, -99679, 235855, -3384, 0, 0, 0, 180, 0, 0, 0),
-- Spirit Of Mirrors
("Talking_Island", 1, 27005, -121206, 235888, -3672, 0, 0, 62660, 180, 0, 0, 0),
-- Pako the Cat
("Talking_Island", 1, 27102, -118589, 233309, -2912, 0, 0, 0, 180, 0, 0, 0),
-- Sir Collin Windawood
("Talking_Island_Npc", 1, 30311, -100332, 238019, -3568, 0, 0, 36864, 60, 0, 0, 0),
-- Lionel
("Talking_Island_Npc", 1, 30408, -106485, 233377, -3624, 0, 0, 12288, 60, 0, 0, 0),
-- Siff
("Talking_Island_Npc", 1, 30427, -113490, 235526, -3640, 0, 0, 57800, 60, 0, 0, 0),
-- Tiramisa
("Talking_Island_Npc", 1, 30429, -115744, 235924, -4032, 0, 0, 16384, 60, 0, 0, 0),
-- Almors
("Talking_Island_Npc", 1, 30635, -118618, 233239, -2912, 0, 0, 32768, 60, 0, 0, 0),
-- Ramus
("Talking_Island_Npc", 1, 30667, -112206, 244303, -3448, 0, 0, 16384, 60, 0, 0, 0),
-- Guard
("Talking_Island_Npc", 1, 30733, -100536, 237822, -3568, 0, 0, 24576, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 30733, -99843, 237523, -3568, 0, 0, 0, 60, 0, 0, 0),
-- Guard
("Talking_Island_Npc", 1, 31032, -102089, 242425, -3576, 0, 0, 58749, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -99511, 230949, -3624, 0, 0, 7555, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -119798, 231677, -2840, 0, 0, 25251, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -118213, 231826, -2928, 0, 0, 38349, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -115758, 245607, -3256, 0, 0, 1854, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -114762, 250902, -3272, 0, 0, 25521, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -104971, 246465, -3520, 0, 0, 56230, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -104951, 246489, -3496, 0, 0, 2616, 60, 0, 0, 0),

-- [17_16]

-- Kuram
("Underground Coliseum", 1, 32377, -79120, -45440, -10683, 0, 0, -23248, 60, 0, 0, 0),
-- Underground Coliseum Helper
("Underground Coliseum", 1, 32491, -82168, -49167, -10321, 0, 0, 32084, 60, 0, 0, 0),
-- Kun
("Underground Coliseum", 1, 32513, -84640, -45360, -10683, 0, 0, -9380, 60, 0, 0, 0),
-- Tarion
("Underground Coliseum", 1, 32514, -77408, -50656, -10683, 0, 0, 29664, 60, 0, 0, 0),
-- Leo
("Underground Coliseum", 1, 32515, -81904, -53904, -10683, 0, 0, 17044, 60, 0, 0, 0),
-- Candice
("Underground Coliseum", 1, 32516, -86359, -50593, -10679, 0, 0, 3704, 60, 0, 0, 0),

-- [17_17]

-- Match Manager
("CrateiCube", 1, 32504, -87148, -16396, -8320, 0, 0, 0, 60, 0, 0, 0),

-- [17_19]

-- Muertos Scout
("Kamael Island", 1, 22240, -79659, 51510, -3320, 0, 0, 26403, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -83315, 53215, -3152, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -79659, 52874, -3352, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -78662, 53086, -3352, 0, 0, 36233, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -78745, 53215, -3344, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -85143, 54920, -2592, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -84686, 54579, -2552, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -81944, 53897, -3272, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -81030, 54579, -3456, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -81487, 53556, -3392, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -81487, 53897, -3368, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88006, 53710, -2384, 0, 0, 11312, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -87538, 53711, -2384, 0, 0, 13576, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -87969, 53866, -2384, 0, 0, 2313, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88123, 56085, -2512, 0, 0, 38519, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -85921, 55794, -2544, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -85921, 55456, -2416, 0, 0, 24547, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -84686, 56284, -2560, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -83772, 56966, -2744, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -87166, 57484, -2816, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -89656, 55456, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -91649, 55623, -2688, 0, 0, 30897, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -91228, 56344, -2592, 0, 0, 50605, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -90888, 55308, -2696, 0, 0, 42729, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -91565, 54551, -2680, 0, 0, 42269, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -92001, 55083, -2680, 0, 0, 4309, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -90964, 53957, -2408, 0, 0, 37605, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88328, 54108, -2384, 0, 0, 55418, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88278, 54392, -2384, 0, 0, 22892, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88803, 53701, -2448, 0, 0, 20664, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88809, 54401, -2360, 0, 0, 55411, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -88579, 53931, -2400, 0, 0, 45380, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -92232, 54823, -2672, 0, 0, 19995, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -93542, 54710, -2520, 0, 0, 34893, 60, 0, 0, 0),
("Kamael Island", 1, 22240, -92978, 54936, -2592, 0, 0, 787, 60, 0, 0, 0),
-- Colossus
("Kamael Island", 1, 22241, -90174, 37410, -2304, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -90746, 37923, -2368, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -90917, 37310, -2256, 0, 0, 39274, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -90118, 37510, -2312, 0, 0, 56334, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -90880, 37280, -2272, 0, 0, 16796, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -91024, 39656, -2376, 0, 0, 42715, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -91762, 40393, -2288, 0, 0, 32664, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -89773, 38449, -2360, 0, 0, 34015, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -89521, 38717, -2416, 0, 0, 58988, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -87864, 36984, -2160, 0, 0, 59479, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82470, 40517, -2544, 0, 0, 34288, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82230, 39862, -2536, 0, 0, 46448, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82908, 40248, -2520, 0, 0, 40863, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82383, 39896, -2544, 0, 0, 36559, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81922, 39837, -2552, 0, 0, 40473, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82832, 38746, -2584, 0, 0, 411, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81495, 40687, -2656, 0, 0, 42115, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81326, 41809, -2696, 0, 0, 53484, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77554, 43764, -2600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77190, 44232, -2584, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -78220, 45978, -2744, 0, 0, 63056, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -79463, 45412, -2744, 0, 0, 41108, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -78654, 45639, -2760, 0, 0, 6739, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -76826, 46572, -2704, 0, 0, 5990, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77554, 46104, -2712, 0, 0, 46054, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -75734, 46572, -2904, 0, 0, 26055, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -79723, 48226, -3120, 0, 0, 28257, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -76090, 48763, -3272, 0, 0, 48226, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77184, 48450, -3192, 0, 0, 2238, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -75691, 48470, -3232, 0, 0, 32560, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -78383, 49743, -3176, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77190, 49380, -3320, 0, 0, 20223, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -77012, 49257, -3312, 0, 0, 52251, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -75740, 50294, -3552, 0, 0, 46054, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -79591, 51244, -3328, 0, 0, 8702, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -80779, 50796, -3352, 0, 0, 53071, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -79659, 51510, -3320, 0, 0, 11854, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -80436, 52958, -3392, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81080, 52574, -3376, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81154, 52303, -3304, 0, 0, 34855, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -80919, 51934, -3264, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -80116, 51510, -3304, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -78258, 53174, -3368, 0, 0, 55741, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -79659, 52533, -3424, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -84229, 54920, -2424, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -84686, 54579, -2552, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -85143, 54920, -2592, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -85921, 55118, -2440, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -83084, 54309, -2776, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82760, 54484, -2960, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82401, 53556, -3160, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -81030, 54238, -3424, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -88008, 52773, -2280, 0, 0, 27559, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -87861, 53529, -2384, 0, 0, 32142, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -87749, 55030, -2384, 0, 0, 42564, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -86312, 54839, -2304, 0, 0, 63080, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -86757, 55824, -2408, 0, 0, 31934, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -86479, 56010, -2488, 0, 0, 39274, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -86414, 56012, -2488, 0, 0, 46664, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -87658, 56460, -2512, 0, 0, 26808, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -86755, 55965, -2448, 0, 0, 18687, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82922, 55709, -2576, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -82598, 55359, -2792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -83315, 55602, -2536, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -83315, 56284, -2592, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -87581, 57484, -2792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -88756, 57186, -2752, 0, 0, 42523, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -88270, 56439, -2536, 0, 0, 3226, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -89241, 57822, -2688, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -91713, 55458, -2680, 0, 0, 10711, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -91213, 55264, -2688, 0, 0, 52055, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -91430, 54527, -2672, 0, 0, 57489, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -88103, 54623, -2384, 0, 0, 39980, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -89747, 55081, -2552, 0, 0, 58355, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -89474, 54350, -2544, 0, 0, 15138, 60, 0, 0, 0),
("Kamael Island", 1, 22241, -90038, 53175, -2536, 0, 0, 10934, 60, 0, 0, 0),
-- Muertos Warrior
("Kamael Island", 1, 22242, -93184, 39920, -2312, 0, 0, 29955, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -93258, 39576, -2352, 0, 0, 4601, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -91089, 37141, -2240, 0, 0, 58291, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -90913, 37523, -2320, 0, 0, 26056, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -91674, 37803, -2312, 0, 0, 13362, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -92258, 40160, -2320, 0, 0, 17069, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -88997, 38645, -2368, 0, 0, 9249, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87901, 37402, -2168, 0, 0, 56416, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87445, 37820, -2008, 0, 0, 588, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82967, 39471, -2472, 0, 0, 1183, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82571, 40088, -2520, 0, 0, 15193, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -83438, 40177, -2512, 0, 0, 34099, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82576, 40305, -2528, 0, 0, 1248, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82871, 39518, -2488, 0, 0, 34828, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82196, 39160, -2584, 0, 0, 41621, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82715, 41007, -2584, 0, 0, 56848, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81602, 40523, -2640, 0, 0, 20352, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79110, 44996, -2704, 0, 0, 39903, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79565, 44765, -2728, 0, 0, 31966, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79558, 39477, -2616, 0, 0, 61008, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78054, 39477, -2456, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78430, 41757, -2600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78083, 41889, -2656, 0, 0, 44240, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -77302, 40237, -2584, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -76926, 41947, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -77678, 41187, -2648, 0, 0, 14883, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -77114, 41377, -2608, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -80198, 46320, -2656, 0, 0, 44930, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79533, 45751, -2752, 0, 0, 40986, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78263, 45886, -2752, 0, 0, 4199, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78535, 45585, -2760, 0, 0, 31349, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78390, 45369, -2752, 0, 0, 13335, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79581, 45762, -2752, 0, 0, 36125, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -76462, 47040, -2696, 0, 0, 32334, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78924, 48842, -3224, 0, 0, 14878, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -76161, 48443, -3256, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -76493, 50785, -3528, 0, 0, 32248, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79740, 51396, -3320, 0, 0, 19958, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81725, 51296, -3280, 0, 0, 21732, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81509, 51257, -3248, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -83315, 53215, -3152, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -80919, 51806, -3256, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -79953, 52062, -3344, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81670, 53372, -3392, 0, 0, 25371, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78987, 52958, -3336, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -77831, 52874, -3448, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -77831, 52533, -3456, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78745, 52192, -3432, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -78745, 52533, -3352, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -84229, 52874, -2584, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -84229, 54238, -2672, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -85143, 55261, -2600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -82922, 54834, -2872, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -83408, 54484, -2752, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81944, 53556, -3344, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81788, 54309, -3312, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -81030, 53556, -3320, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -83732, 56234, -2608, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87581, 53766, -2384, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87581, 55456, -2320, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87166, 57146, -2792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87684, 57012, -2560, 0, 0, 14580, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -85921, 55794, -2544, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -87996, 57484, -2784, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -88826, 55666, -2560, 0, 0, 16383, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -90075, 56903, -2688, 0, 0, 50002, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -90259, 57294, -2680, 0, 0, 19516, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -89753, 55777, -2632, 0, 0, 28486, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -89002, 56904, -2752, 0, 0, 61325, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -89241, 57484, -2688, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -90876, 56895, -2688, 0, 0, 37339, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -90592, 55740, -2728, 0, 0, 6132, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -91523, 54400, -2672, 0, 0, 64153, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -91591, 53102, -2448, 0, 0, 52343, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -89248, 54638, -2520, 0, 0, 51932, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -89579, 55247, -2632, 0, 0, 10067, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -92297, 55356, -2680, 0, 0, 37635, 60, 0, 0, 0),
("Kamael Island", 1, 22242, -96034, 57216, -3008, 0, 0, 57633, 60, 0, 0, 0),
-- Muertos Captain
("Kamael Island", 1, 22243, -92213, 40037, -2328, 0, 0, 14377, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -91683, 37421, -2296, 0, 0, 61293, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -90439, 40151, -2352, 0, 0, 16373, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -90403, 40093, -2352, 0, 0, 34811, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -88209, 37420, -2176, 0, 0, 12160, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -87855, 36771, -2144, 0, 0, 8471, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83390, 38952, -2424, 0, 0, 54907, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83166, 39578, -2472, 0, 0, 60349, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83389, 40064, -2512, 0, 0, 41539, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83788, 40692, -2584, 0, 0, 24582, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -84010, 40343, -2536, 0, 0, 38315, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -81914, 39370, -2576, 0, 0, 10655, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -82207, 39458, -2528, 0, 0, 31306, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -81906, 39805, -2568, 0, 0, 6709, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83422, 44492, -2520, 0, 0, 28539, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -79746, 39477, -2592, 0, 0, 7276, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77890, 40257, -2592, 0, 0, 25493, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -78778, 40104, -2648, 0, 0, 11798, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77302, 41567, -2640, 0, 0, 12904, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77490, 40807, -2552, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -76362, 41567, -2544, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -76926, 41947, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77114, 42137, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -76826, 43296, -2592, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -80511, 45091, -2664, 0, 0, 19819, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77554, 45636, -2752, 0, 0, 473, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -75476, 45314, -3024, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -75370, 45636, -3024, 0, 0, 63419, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -75056, 45866, -3016, 0, 0, 3883, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -75734, 44232, -2872, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -74426, 45176, -2992, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -75006, 46104, -3024, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -78805, 48439, -3144, 0, 0, 25092, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -79012, 48615, -3208, 0, 0, 55164, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77315, 48860, -3272, 0, 0, 32662, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77278, 49781, -3296, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -76746, 50436, -3448, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -76098, 49380, -3432, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -77893, 50207, -3264, 0, 0, 39269, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -81916, 48050, -3016, 0, 0, 36819, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -81576, 48679, -3056, 0, 0, 13663, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -82796, 46363, -2848, 0, 0, 32901, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -82826, 48060, -3024, 0, 0, 25936, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83445, 49058, -3152, 0, 0, 55851, 60, 0, 0, 0),
("Kamael Island", 1, 22243, -83022, 49165, -3192, 0, 0, 45526, 60, 0, 0, 0),
-- Crimson Spider
("Kamael Island", 1, 22244, -78242, 39097, -2464, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -78054, 39287, -2584, 0, 0, 63606, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -78806, 40617, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77554, 42828, -2664, 0, 0, 39721, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77302, 39667, -2592, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77490, 39287, -2544, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77490, 41377, -2640, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77490, 41757, -2640, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77114, 42137, -2656, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -78553, 45392, -2752, 0, 0, 35548, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -76462, 47040, -2696, 0, 0, 46765, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77510, 45771, -2752, 0, 0, 3332, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -77616, 46585, -2688, 0, 0, 30486, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -78620, 46821, -2744, 0, 0, 19558, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -75581, 45866, -2952, 0, 0, 31669, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -75581, 46004, -2968, 0, 0, 12201, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -75161, 46418, -3024, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -78869, 47873, -2736, 0, 0, 1353, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -76098, 50784, -3528, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -76098, 49380, -3432, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -80879, 49340, -3152, 0, 0, 44181, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -81207, 49132, -3096, 0, 0, 7633, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -82558, 46614, -2856, 0, 0, 24108, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -82128, 47245, -2944, 0, 0, 15059, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -82091, 49544, -3240, 0, 0, 29794, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -83627, 49243, -3080, 0, 0, 33107, 60, 0, 0, 0),
("Kamael Island", 1, 22244, -85770, 49536, -2752, 0, 0, 15995, 60, 0, 0, 0),
-- Muertos Lieutenant
("Kamael Island", 1, 22245, -83264, 44735, -2704, 0, 0, 54939, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -82222, 44285, -2768, 0, 0, 44670, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -82030, 46001, -2840, 0, 0, 42142, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -83526, 48786, -3152, 0, 0, 24079, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -81962, 47434, -2960, 0, 0, 39085, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -83324, 49880, -2992, 0, 0, 390, 60, 0, 0, 0),
("Kamael Island", 1, 22245, -82992, 49176, -3192, 0, 0, 13444, 60, 0, 0, 0),
-- Grotto Golem
("Kamael Island", 1, 22247, -79676, 49687, -4264, 0, 0, 44363, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -80113, 50985, -4536, 0, 0, 14932, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -81460, 47225, -4192, 0, 0, 6732, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -80314, 48121, -4216, 0, 0, 9362, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -80129, 49819, -4216, 0, 0, 25600, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -82503, 47101, -3848, 0, 0, 33463, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -83433, 47041, -3832, 0, 0, 17423, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -83269, 47562, -3832, 0, 0, 4529, 60, 0, 0, 0),
("Kamael Island", 1, 22247, -79436, 51405, -4696, 0, 0, 0, 60, 0, 0, 0),
-- Shady Muertos Guard
("Kamael Island", 1, 22249, -80457, 47092, -4216, 0, 0, 48278, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -78940, 49546, -4312, 0, 0, 9488, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -79333, 49870, -4312, 0, 0, 8191, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -78679, 49732, -4312, 0, 0, 12021, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80790, 47432, -4216, 0, 0, 33475, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80341, 48096, -4216, 0, 0, 26059, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80099, 49371, -4216, 0, 0, 17184, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -81378, 47234, -4216, 0, 0, 1492, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80548, 47585, -4216, 0, 0, 33565, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80509, 49174, -4216, 0, 0, 30630, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80145, 50815, -4480, 0, 0, 14966, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -82787, 47098, -3832, 0, 0, 43494, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -83166, 47052, -3832, 0, 0, 25178, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -80022, 51390, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22249, -79788, 51293, -4624, 0, 0, 0, 60, 0, 0, 0),
-- Grotto Leopard
("Kamael Island", 1, 22250, -79560, 49839, -4296, 0, 0, 49889, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80053, 49243, -4216, 0, 0, 63661, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80493, 48424, -4216, 0, 0, 9015, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -79926, 50517, -4384, 0, 0, 51365, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80212, 49393, -4216, 0, 0, 45096, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -78762, 51521, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -83054, 53163, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80513, 52623, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -78930, 51314, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -79500, 51325, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -85756, 53597, -4400, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -84376, 53662, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -82858, 54766, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -83218, 54846, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -81512, 53759, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -81584, 53743, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80524, 53591, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22250, -80494, 53538, -4696, 0, 0, 0, 60, 0, 0, 0),
-- Shady Muertos Captain
("Kamael Island", 1, 22251, -80509, 52902, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -80257, 52511, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -85024, 53694, -4640, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -85024, 53598, -4640, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -83918, 53339, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -82930, 54798, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -83146, 54830, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -82304, 53695, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -81944, 53647, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -81526, 54680, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -81658, 54779, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -81625, 54548, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -80494, 53273, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -86515, 52255, -4312, 0, 0, 12017, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -86631, 53142, -4312, 0, 0, 41890, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -86593, 53737, -4312, 0, 0, 13828, 60, 0, 0, 0),
("Kamael Island", 1, 22251, -85964, 53579, -4328, 0, 0, 60935, 60, 0, 0, 0),
-- Grotto Grizzly
("Kamael Island", 1, 22252, -82694, 53243, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -80366, 53032, -4696, 0, 0, 8955, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -85808, 53625, -4384, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -84376, 53694, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -84289, 54389, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -84454, 54422, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -84190, 54752, -4792, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -83434, 54782, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -82714, 54750, -4888, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -81728, 53647, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -81728, 53631, -4696, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -86774, 51394, -4216, 0, 0, 29261, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -87774, 52737, -4408, 0, 0, 17930, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -88014, 52481, -4408, 0, 0, 8592, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -87214, 52522, -4408, 0, 0, 64591, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -86640, 52520, -4312, 0, 0, 11707, 60, 0, 0, 0),
("Kamael Island", 1, 22252, -86615, 52273, -4312, 0, 0, 40793, 60, 0, 0, 0),
-- Shady Muertos Warrior
("Kamael Island", 1, 22253, -81210, 50566, -4600, 0, 0, 43738, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -81188, 51229, -4600, 0, 0, 10250, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -81465, 49924, -4600, 0, 0, 15588, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -81528, 52159, -4600, 0, 0, 33245, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -82704, 49706, -4552, 0, 0, 43607, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -82888, 50763, -4728, 0, 0, 8614, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -83302, 51042, -4728, 0, 0, 20389, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -83782, 49623, -4216, 0, 0, 54924, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -82112, 52114, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -81893, 52144, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -83914, 49901, -4216, 0, 0, 23078, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -85036, 50232, -4416, 0, 0, 902, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -85394, 49483, -4216, 0, 0, 55394, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -86142, 49380, -4216, 0, 0, 26507, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -85647, 49984, -4312, 0, 0, 51538, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -86903, 51428, -4216, 0, 0, 659, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -87190, 52485, -4408, 0, 0, 29234, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -86555, 52501, -4312, 0, 0, 16789, 60, 0, 0, 0),
("Kamael Island", 1, 22253, -86571, 52317, -4312, 0, 0, 56399, 60, 0, 0, 0),
-- Shady Muertos Archer
("Kamael Island", 1, 22254, -82404, 51250, -4728, 0, 0, 20548, 60, 0, 0, 0),
("Kamael Island", 1, 22254, -81455, 52129, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22254, -81174, 51255, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22254, -84953, 50602, -4536, 0, 0, 32203, 60, 0, 0, 0),
("Kamael Island", 1, 22254, -84085, 49903, -4216, 0, 0, 1981, 60, 0, 0, 0),
("Kamael Island", 1, 22254, -85653, 49369, -4216, 0, 0, 19160, 60, 0, 0, 0),
-- Shady Muertos Commander
("Kamael Island", 1, 22255, -81354, 51223, -4600, 0, 0, 26903, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -81219, 51619, -4600, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -82802, 49838, -4512, 0, 0, 449, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -82419, 51266, -4728, 0, 0, 24012, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -83149, 49821, -4400, 0, 0, 41522, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -83854, 51085, -4728, 0, 0, 48498, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -84916, 50960, -4600, 0, 0, 14342, 60, 0, 0, 0),
("Kamael Island", 1, 22255, -85784, 49965, -4312, 0, 0, 60078, 60, 0, 0, 0),
-- Shady Muertos Wizard
("Kamael Island", 1, 22256, -81861, 49752, -4600, 0, 0, 61399, 60, 0, 0, 0),
("Kamael Island", 1, 22256, -81465, 49729, -4600, 0, 0, 53048, 60, 0, 0, 0),
("Kamael Island", 1, 22256, -83259, 51201, -4728, 0, 0, 1582, 60, 0, 0, 0),
("Kamael Island", 1, 22256, -82856, 51231, -4728, 0, 0, 16119, 60, 0, 0, 0),
("Kamael Island", 1, 22256, -83947, 49752, -4216, 0, 0, 55411, 60, 0, 0, 0),
("Kamael Island", 1, 22256, -81966, 52069, -4600, 0, 0, 0, 60, 0, 0, 0),
-- Yinir
("unset", 1, 32184, -95500, 52164, -2024, 0, 0, 51276, 60, 0, 0, 0),
-- Peregrine
("unset", 1, 32185, -95571, 52496, -2024, 0, 0, 18720, 60, 0, 0, 0),
-- Yung
("unset", 1, 32186, -85952, 37120, -2048, 0, 0, 8432, 60, 0, 0, 0),
-- Nadir
("unset", 1, 32187, -86224, 36848, -2048, 0, 0, 42344, 60, 0, 0, 0),
-- Morelin
("unset", 1, 32188, -85952, 36864, -2048, 0, 0, 16062, 60, 0, 0, 0),
-- Largo
("unset", 1, 32189, -74016, 51932, -3680, 0, 0, 0, 60, 0, 0, 0),
-- Mao
("unset", 1, 32190, -74016, 52896, -3680, 0, 0, 0, 60, 0, 0, 0),
-- Icon of the Past
("unset", 1, 32255, -79624, 55755, -4952, 0, 0, 49152, 60, 0, 0, 0),
-- Icon of the Present
("unset", 1, 32256, -88066, 55755, -4568, 0, 0, 49152, 60, 0, 0, 0),
-- Icon of the Future
("unset", 1, 32257, -88453, 51531, -4472, 0, 0, 49152, 60, 0, 0, 0),
-- Garden Guard
("unset", 1, 32330, -84728, 60089, -2576, 0, 0, 49216, 60, 0, 0, 0),
-- Marksman
("Kamael Island", 1, 32335, -79795, 43483, -2792, 0, 0, 51899, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -76165, 46857, -2704, 0, 0, 1463, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -84401, 54603, -2488, 0, 0, 0, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -85373, 59294, -2632, 0, 0, 6753, 60, 0, 0, 0),
("Kamael Island", 1, 32335, -89003, 57507, -2688, 0, 0, 7185, 60, 0, 0, 0),
-- Marksman
("Kamael Island", 1, 32336, -85904, 37816, -2104, 0, 0, 15736, 60, 0, 0, 0),
("unset", 1, 32336, -86288, 36152, -2096, 0, 0, 50144, 60, 0, 0, 0),

-- [17_20]

-- Gora Werewolf
("gludio33_1721_02", 1, 20012, -74814, 94702, -3731, 0, 0, 42676, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -66830, 98219, -3659, 0, 0, 39828, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -65624, 96522, -3633, 0, 0, 52675, 25, 0, 0, 0),
-- Red Bear
("gludio33_1821_01", 1, 20021, -65668, 96568, -3637, 0, 0, 17128, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -66898, 97446, -3690, 0, 0, 61760, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -68464, 97561, -3679, 0, 0, 34249, 25, 0, 0, 0),
-- Venomous Spider
("Dark_Elf_Village", 1, 20038, -66549, 72640, -3328, 0, 0, 43787, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -66575, 74604, -3328, 0, 0, 18184, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -66744, 74839, -3336, 0, 0, 16066, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -66124, 75034, -3288, 0, 0, 42616, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -66031, 75700, -3296, 0, 0, 18660, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -67577, 77001, -3344, 0, 0, 17661, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -67218, 76897, -3344, 0, 0, 24538, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -65886, 76280, -3280, 0, 0, 45947, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -74051, 96605, -3698, 0, 0, 39746, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -71047, 96029, -3734, 0, 0, 45796, 20, 0, 0, 0),
-- Arachnid Tracker
("Dark_Elf_Village", 1, 20043, -69974, 72992, -3200, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -72118, 74257, -3232, 0, 0, 6536, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -73477, 72536, -3136, 0, 0, 20232, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -71850, 73751, -3240, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -73190, 76028, -3152, 0, 0, 4341, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -72150, 77142, -3152, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -70986, 77733, -3224, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -70197, 78152, -3232, 0, 0, 60818, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -70658, 78430, -3216, 0, 0, 29763, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -71433, 83095, -3480, 0, 0, 41110, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -67348, 82300, -3368, 0, 0, 31764, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -66594, 84026, -3488, 0, 0, 17071, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -73129, 81207, -3408, 0, 0, 28717, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -73509, 81433, -3424, 0, 0, 55781, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -71528, 85271, -3456, 0, 0, 7352, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -71569, 84259, -3472, 0, 0, 33935, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -74925, 83288, -3304, 0, 0, 63797, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -68080, 87591, -3328, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -68869, 86449, -3472, 0, 0, 6996, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -68405, 86561, -3448, 0, 0, 12610, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -66590, 87385, -3632, 0, 0, 13252, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -66109, 88840, -3560, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -66772, 88123, -3600, 0, 0, 0, 20, 0, 0, 0),
-- Whispering Wind
("gludio20_1720_01", 1, 20078, -85351, 83447, -3286, 0, 0, 18245, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -84898, 81463, -3194, 0, 0, 19207, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -84681, 77237, -3468, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -82312, 77088, -3400, 0, 0, 54324, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -85141, 78774, -3095, 0, 0, 48036, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -83343, 79454, -3265, 0, 0, 2926, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -85789, 77771, -3468, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -86359, 81920, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -87093, 81992, -2913, 0, 0, 55586, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -84994, 85128, -3359, 0, 0, 9008, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -85755, 81208, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -86964, 80852, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -82949, 78827, -3335, 0, 0, 3969, 26, 0, 0, 0),
("gludio20_1720_01", 1, 20078, -84861, 88258, -3529, 0, 0, 9190, 26, 0, 0, 0),
-- Grizzly Bear
("gludio33_1721_02", 1, 20335, -70254, 96698, -3739, 0, 0, 53946, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20335, -71062, 98057, -3711, 0, 0, 34872, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20335, -72306, 96723, -3714, 0, 0, 30546, 25, 0, 0, 0),
-- Crystalline Beast
("Dark_Elf_Village", 1, 20418, -71333, 74963, -3232, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -71582, 74763, -3240, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -72467, 74615, -3200, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -72719, 75079, -3152, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -70242, 76028, -3280, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -71582, 76281, -3144, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -73417, 84967, -3360, 0, 0, 58450, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -73802, 83942, -3344, 0, 0, 26789, 20, 0, 0, 0),
-- Dark Succubus
("Dark_Elf_Village", 1, 20776, -72150, 77733, -3152, 0, 0, 34846, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -69822, 77339, -3272, 0, 0, 57077, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -69319, 77769, -3328, 0, 0, 58458, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -66926, 81746, -3352, 0, 0, 20020, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -66595, 80868, -3328, 0, 0, 18224, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -66689, 80503, -3336, 0, 0, 37127, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -69687, 79329, -3384, 0, 0, 26034, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -70053, 82195, -3472, 0, 0, 41407, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -73940, 80959, -3376, 0, 0, 23650, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -73218, 83196, -3376, 0, 0, 3880, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -71171, 85282, -3456, 0, 0, 4328, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -70428, 84408, -3464, 0, 0, 22546, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -68373, 85203, -3504, 0, 0, 42420, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -74793, 80604, -3304, 0, 0, 11724, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -74683, 81919, -3320, 0, 0, 54600, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -69559, 86773, -3376, 0, 0, 6988, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20776, -69593, 86947, -3312, 0, 0, 44707, 20, 0, 0, 0),
-- Sobbing Wind
("gludio20_1720_08", 1, 21023, -92310, 91011, -3664, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -92713, 91367, -3664, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -93504, 96117, -3547, 0, 0, 32718, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -93819, 97300, -3541, 0, 0, 24493, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -93216, 91901, -3664, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -92210, 92257, -3664, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -92165, 97908, -3508, 0, 0, 64066, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -91807, 91545, -3664, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -80096, 88181, -3497, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -79895, 88181, -3497, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -79895, 88537, -3497, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -79995, 89071, -3497, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -80539, 87221, -3544, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -80847, 89980, -3728, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -76154, 93392, -3711, 0, 0, 26734, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -78139, 92824, -3731, 0, 0, 38703, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -73557, 95743, -3713, 0, 0, 43772, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -74387, 93231, -3677, 0, 0, 52128, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -72203, 98208, -3690, 0, 0, 9072, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -72580, 93981, -3683, 0, 0, 55176, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -68695, 95649, -3678, 0, 0, 58328, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -79421, 92234, -3721, 0, 0, 32937, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -80736, 91181, -3704, 0, 0, 51423, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -77433, 91329, -3807, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_08", 1, 21023, -82086, 92164, -3608, 0, 0, 33135, 26, 0, 0, 0),
-- Babbling Wind
("gludio20_1720_04", 1, 21024, -83115, 86429, -3546, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82712, 86429, -3546, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82210, 86607, -3546, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82394, 87151, -3547, 0, 0, 16721, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82623, 85838, -3511, 0, 0, 47398, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -84242, 87822, -3520, 0, 0, 10988, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -89487, 87115, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -88883, 86759, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -88781, 88717, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -92568, 93090, -3398, 0, 0, 62933, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -89386, 87649, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91995, 96200, -3565, 0, 0, 46645, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -88783, 87293, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -92669, 96049, -3553, 0, 0, 50887, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -89336, 92108, -2676, 0, 0, 38215, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91309, 87521, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91007, 88411, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -90534, 87621, -3431, 0, 0, 53340, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91387, 94965, -3520, 0, 0, 15792, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91245, 88948, -3342, 0, 0, 26684, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -88454, 92853, -2507, 0, 0, 11172, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -91812, 88055, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -95560, 96005, -3529, 0, 0, 41018, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -88832, 98186, -3529, 0, 0, 39634, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -92779, 94785, -3481, 0, 0, 17945, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -95498, 98295, -3525, 0, 0, 31330, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -93627, 95659, -3518, 0, 0, 56123, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82290, 89012, -3691, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -80265, 90406, -3721, 0, 0, 8736, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -82270, 87969, -3561, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -79693, 88537, -3400, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -80291, 87825, -3533, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -80524, 87925, -3534, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -71447, 94303, -3817, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -71447, 96911, -3718, 0, 0, 5621, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -75065, 95616, -3690, 0, 0, 14460, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -76262, 94972, -3692, 0, 0, 30660, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -77008, 93755, -3701, 0, 0, 38161, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -72554, 95193, -3817, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -75650, 94668, -3709, 0, 0, 7653, 26, 0, 0, 0),
-- Giggling Wind
("gludio20_1720_02", 1, 21025, -86807, 88378, -3392, 0, 0, 18315, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -87772, 89139, -3334, 0, 0, 18185, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -85757, 80140, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84196, 81857, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84095, 82747, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -82586, 82213, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84297, 82747, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -83994, 82925, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84398, 82213, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -83692, 82391, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84297, 82391, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84095, 82391, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -82512, 86785, -3546, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84256, 84750, -3365, 0, 0, 45905, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -85857, 87651, -3475, 0, 0, 32000, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -83242, 86592, -3548, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -81309, 87802, -3549, 0, 0, 24576, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -83115, 87141, -3546, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -87815, 83186, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -87412, 84610, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -88319, 83720, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -88320, 84432, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -86466, 90325, -3294, 0, 0, 16931, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -88388, 85882, -3300, 0, 0, 35833, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -84958, 90200, -3346, 0, 0, 12127, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -93923, 94493, -3440, 0, 0, 22732, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -91498, 89927, -3307, 0, 0, 42585, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -91413, 93954, -3414, 0, 0, 58507, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -88374, 88254, -3419, 0, 0, 52444, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -90180, 97773, -3512, 0, 0, 901, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -95212, 95271, -3480, 0, 0, 36259, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -89542, 91609, -2830, 0, 0, 43572, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -91141, 92955, -3410, 0, 0, 17220, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -92346, 89977, -3257, 0, 0, 28632, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -92014, 88767, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -88524, 89957, -3300, 0, 0, 7559, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -90872, 90225, -3313, 0, 0, 23621, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -90474, 88956, -3377, 0, 0, 51682, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -93744, 93572, -3386, 0, 0, 35442, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -92819, 88055, -3649, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -80763, 89249, -3533, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -81023, 88715, -3533, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -80500, 88893, -3533, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -81842, 89903, -3725, 0, 0, 47015, 26, 0, 0, 0),
("gludio20_1720_02", 1, 21025, -77113, 92535, -3712, 0, 0, 46125, 26, 0, 0, 0),
-- Singing Wind
("gludio20_1720_01", 1, 21026, -84424, 79288, -3165, 0, 0, 13029, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83890, 77849, -3292, 0, 0, 33058, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -85184, 77415, -3468, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -85830, 79214, -2978, 0, 0, 36123, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -85655, 81386, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -86359, 80852, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87902, 86984, -3420, 0, 0, 52971, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87308, 82295, -2909, 0, 0, 23863, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -89876, 89091, -3398, 0, 0, 28124, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -86747, 85293, -3309, 0, 0, 52833, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -85956, 81564, -3404, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -86503, 82889, -3132, 0, 0, 45430, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -84297, 83103, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83692, 82747, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -84095, 82035, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83794, 81857, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83894, 83103, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -84398, 82925, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83390, 82213, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83490, 82035, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -83793, 82213, -3278, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -82933, 88005, -3565, 0, 0, 27340, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -80743, 86612, -3546, 0, 0, 56129, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -84059, 89310, -3525, 0, 0, 24246, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87110, 83008, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87111, 83720, -3189, 0, 0, 0, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87191, 91248, -3104, 0, 0, 9949, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87425, 85713, -3332, 0, 0, 12923, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -86187, 84653, -3267, 0, 0, 53805, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87149, 86902, -3413, 0, 0, 14605, 26, 0, 0, 0),
("gludio20_1720_01", 1, 21026, -87692, 88096, -3401, 0, 0, 20675, 26, 0, 0, 0),
-- Umbar Orc
("Dark_Elf_Village", 1, 27054, -74012, 81878, -3384, 0, 0, 61863, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74941, 83708, -3328, 0, 0, 48204, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74391, 83803, -3336, 0, 0, 6806, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74110, 83461, -3344, 0, 0, 13400, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74433, 83329, -3344, 0, 0, 19486, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -73798, 81919, -3416, 0, 0, 50817, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -73896, 81913, -3400, 0, 0, 47790, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74038, 81899, -3384, 0, 0, 37897, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74893, 83735, -3336, 0, 0, 42222, 35, 0, 0, 0),
("Dark_Elf_Village", 1, 27054, -74007, 83885, -3328, 0, 0, 54121, 35, 0, 0, 0),
-- Abyssal Jewel 1
("gludio01_qm1720_01", 1, 27165, -81247, 75607, -3360, 0, 0, 0, 180, 0, 0, 0),
-- Broadcasting Tower
("blood_of_sacrifice_broadcast", 1, 31031, -79884, 86529, -5182, 0, 0, 16384, 5, 0, 0, 0),
("blood_of_sacrifice_broadcast", 1, 31031, -76973, 87136, -5182, 0, 0, 16384, 5, 0, 0, 0),
-- Festival Guide
("ssqe2_npc1720_01", 1, 31137, -80208, 87120, -5153, 0, 0, 49000, 60, 0, 0, 0),
-- Festival Guide
("ssqe2_npc1720_02", 1, 31138, -77200, 87728, -5153, 0, 0, 49000, 60, 0, 0, 0),
-- Festival Guide
("ssqe2_npc1720_03", 1, 31139, -76096, 87136, -5153, 0, 0, 32500, 60, 0, 0, 0),
-- Festival Guide
("ssqe2_npc1720_04", 1, 31140, -76944, 86544, -5153, 0, 0, 16500, 60, 0, 0, 0),
-- Festival Guide
("ssqe2_npc1720_05", 1, 31141, -79968, 85936, -5153, 0, 0, 16500, 60, 0, 0, 0),

-- [17_21]

-- Felim Lizardman
("gludio33_1821_02", 1, 20008, -66745, 102598, -3726, 0, 0, 45385, 25, 0, 0, 0),
("gludio33_1821_02", 1, 20008, -65619, 104603, -3600, 0, 0, 3435, 25, 0, 0, 0),
-- Felim Lizardman Scout
("gludio33_1721_02", 1, 20010, -69260, 101588, -3888, 0, 0, 7438, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -69222, 100116, -3854, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -70026, 100116, -3862, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -69427, 98402, -3714, 0, 0, 15989, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -66443, 104024, -3697, 0, 0, 7100, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -67621, 104406, -3780, 0, 0, 29691, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -67597, 103531, -3763, 0, 0, 31864, 25, 0, 0, 0),
-- Gora Werewolf
("gludio33_1721_02", 1, 20012, -71567, 99865, -3630, 0, 0, 557, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -71094, 102790, -3870, 0, 0, 24647, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -73890, 99919, -3624, 0, 0, 31070, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -68318, 98984, -3708, 0, 0, 32381, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -65955, 99422, -3656, 0, 0, 0, 25, 0, 0, 0),
-- Felim Lizardman Warrior
("gludio33_1721_04", 1, 20014, -67512, 105524, -3948, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -68508, 108879, -3725, 0, 0, 23126, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -70370, 105549, -3856, 0, 0, 12183, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -66589, 107904, -3756, 0, 0, 18805, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -68016, 106414, -3948, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -66203, 105702, -3948, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -69924, 103349, -3869, 0, 0, 42206, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -69211, 107278, -3844, 0, 0, 35813, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -65621, 107481, -3697, 0, 0, 17696, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -65897, 102322, -3671, 0, 0, 48956, 25, 0, 0, 0),
-- Red Bear
("gludio33_1821_01", 1, 20021, -66363, 100229, -3727, 0, 0, 25317, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -67116, 99470, -3740, 0, 0, 22457, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -66690, 101492, -3705, 0, 0, 58001, 25, 0, 0, 0),
-- Venomous Spider
("oren25_1820_01", 1, 20038, -74912, 100898, -3680, 0, 0, 33429, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -70543, 99298, -3722, 0, 0, 4097, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -74995, 98553, -3300, 0, 0, 35046, 20, 0, 0, 0),
-- Arachnid Tracker
("oren25_1820_14s", 1, 20043, -77619, 103240, -3862, 0, 0, 20013, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -76306, 102318, -3866, 0, 0, 55328, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -77664, 101062, -3639, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -77261, 101418, -3750, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -83115, 105912, -3738, 0, 0, 40463, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -83771, 104768, -3684, 0, 0, 52532, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -78269, 100706, -3551, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -69807, 105253, -3856, 0, 0, 19090, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -73428, 105424, -3611, 0, 0, 5485, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -74647, 104942, -3654, 0, 0, 27871, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -74767, 103280, -3865, 0, 0, 45919, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67081, 102255, -3754, 0, 0, 56883, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -66102, 106236, -3948, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67241, 105985, -3822, 0, 0, 23866, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -70530, 107632, -3701, 0, 0, 24065, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -72202, 108805, -3525, 0, 0, 32707, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -68970, 105170, -3856, 0, 0, 52218, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67512, 106948, -3948, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -69031, 106365, -3856, 0, 0, 30805, 20, 0, 0, 0),
-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -80501, 104730, -3809, 0, 0, 49467, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -78740, 99554, -3619, 0, 0, 53305, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -78334, 104638, -3782, 0, 0, 60263, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -83006, 106790, -3741, 0, 0, 1978, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -84369, 107290, -3635, 0, 0, 33163, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -76389, 104528, -3956, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -76426, 105975, -3600, 0, 0, 11040, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -71177, 103594, -3826, 0, 0, 63582, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72927, 103774, -3812, 0, 0, 990, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -75266, 106405, -3598, 0, 0, 42068, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -73023, 106950, -3581, 0, 0, 16811, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -73117, 112676, -3432, 0, 0, 19760, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72825, 111166, -3194, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72321, 110988, -3194, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72852, 101474, -3868, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72852, 102186, -3889, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72651, 102186, -3891, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -73154, 101652, -3877, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -72751, 102008, -3890, 0, 0, 0, 21, 0, 0, 0),
-- Grizzly Bear
("gludio33_1721_02", 1, 20335, -69221, 99760, -3799, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20335, -73252, 98416, -3610, 0, 0, 32266, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20335, -72479, 100018, -3655, 0, 0, 30515, 25, 0, 0, 0),
-- Ratman Hunter
("gludio38_1921_04", 1, 20358, -78470, 100706, -3448, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -81991, 107952, -3301, 0, 0, 54085, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -78168, 100172, -3561, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -81062, 106609, -3678, 0, 0, 3108, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -76959, 100884, -3635, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -77563, 101596, -3747, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -79606, 105646, -3747, 0, 0, 22713, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -77765, 101240, -3667, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -85018, 107753, -3554, 0, 0, 23955, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -83758, 106431, -3711, 0, 0, 30735, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -80886, 105531, -3811, 0, 0, 61927, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -78570, 101240, -3530, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -77462, 100350, -3568, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -66707, 105880, -3948, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -69995, 104584, -3858, 0, 0, 42146, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -71944, 104618, -3780, 0, 0, 34536, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -68460, 103518, -3824, 0, 0, 52282, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -68134, 102114, -3810, 0, 0, 45955, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -66404, 106414, -3948, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -67108, 107304, -3948, 0, 0, 0, 30, 0, 0, 0),
-- Babbling Wind
("gludio20_1720_04", 1, 21024, -91208, 98553, -3476, 0, 0, 418, 26, 0, 0, 0),
("gludio20_1720_04", 1, 21024, -93953, 98926, -3541, 0, 0, 29315, 26, 0, 0, 0),
-- Giggling Wind
("gludio20_1720_02", 1, 21025, -88768, 98917, -3562, 0, 0, 2134, 26, 0, 0, 0),
-- Giant Poison Bee
("gludio33_1721_03", 1, 21095, -75836, 103189, -3894, 0, 0, 55208, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -74773, 104787, -3680, 0, 0, 4129, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -73892, 102971, -3871, 0, 0, 53156, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -72934, 104841, -3663, 0, 0, 7792, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76919, 103021, -3879, 0, 0, 40708, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -71616, 111878, -3194, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -73229, 111522, -3263, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -67904, 111914, -3483, 0, 0, 2900, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -73127, 110988, -3194, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -70468, 111402, -3595, 0, 0, 63768, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76773, 116022, -1882, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -74861, 116173, -2888, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76358, 117043, -2664, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -75752, 116926, -2768, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76254, 117493, -2721, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -75453, 114729, -2213, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76660, 117577, -2656, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -75756, 115263, -2368, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76359, 116331, -2128, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -76862, 116865, -2504, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -72846, 117455, -3564, 0, 0, 55695, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -75836, 119514, -3466, 0, 0, 27932, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -72732, 120532, -3598, 0, 0, 9298, 25, 0, 0, 0),
("gludio33_1721_03", 1, 21095, -74136, 118226, -3824, 0, 0, 0, 25, 0, 0, 0),
-- Cloudy Beast 
("gludio33_1721_05", 1, 21096, -72523, 110632, -3194, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -71617, 111166, -3194, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -69556, 109638, -3743, 0, 0, 44932, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -70115, 108037, -3691, 0, 0, 16064, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -67958, 106907, -3849, 0, 0, 56747, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -71209, 104167, -3827, 0, 0, 45754, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -75857, 115797, -2352, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -74849, 116509, -2856, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -75352, 114907, -2280, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -76156, 117399, -2736, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -75956, 116331, -2360, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -76258, 116865, -2528, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -75453, 115797, -2512, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -76961, 117399, -2632, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -75353, 115975, -2576, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -76359, 115975, -2104, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -71863, 126233, -3620, 0, 0, 50249, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -74897, 125041, -3963, 0, 0, 7030, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -77375, 123566, -3624, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -68625, 121731, -3610, 0, 0, 54658, 25, 0, 0, 0),
("gludio33_1721_05", 1, 21096, -77596, 123341, -3600, 0, 0, 0, 25, 0, 0, 0),
-- Young Araneid
("gludio33_1721_06", 1, 21097, -75957, 115619, -2288, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75051, 116153, -2840, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75453, 117221, -2808, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75251, 115441, -2464, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75152, 115975, -2688, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75151, 116687, -2824, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75857, 115441, -2320, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -76560, 117043, -2648, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75554, 116331, -2584, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -76459, 116865, -2496, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -72817, 122074, -3696, 0, 0, 57277, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -76538, 124803, -3714, 0, 0, 49249, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -75323, 125798, -3917, 0, 0, 16274, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -76805, 127649, -3671, 0, 0, 65281, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -70018, 124797, -3593, 0, 0, 57946, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -77395, 124053, -3642, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -82060, 124317, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -78934, 125447, -3682, 0, 0, 47314, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -80563, 128807, -3647, 0, 0, 56608, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -66377, 110970, -3548, 0, 0, 25137, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -67473, 112756, -3497, 0, 0, 26296, 25, 0, 0, 0),
-- Plain Grizzly
("gludio33_1721_06", 1, 21098, -74950, 115619, -2616, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -76661, 116509, -2128, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -76661, 116153, -1944, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -75554, 117043, -2776, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -75051, 116509, -2848, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -74546, 115263, -2632, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -74949, 117043, -2912, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -74951, 115975, -2816, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -75956, 117399, -2736, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -75554, 114907, -2256, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -76210, 127167, -3744, 0, 0, 13455, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -72013, 127093, -3649, 0, 0, 8014, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -75105, 123405, -3709, 0, 0, 55214, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -77837, 126001, -3699, 0, 0, 62686, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -81656, 125029, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -81556, 124495, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -80442, 126622, -3599, 0, 0, 52089, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -85156, 130751, -3297, 0, 0, 31594, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -78684, 126897, -3700, 0, 0, 2221, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -67632, 109800, -4024, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -66827, 109800, -4024, 0, 0, 0, 25, 0, 0, 0),
-- Cloudy Beast Turen
("gludio33_1721_07", 1, 21099, -77035, 122105, -3661, 0, 0, 43959, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -70833, 128529, -3386, 0, 0, 14039, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -75984, 123697, -3736, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -82161, 125563, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -80980, 127444, -3596, 0, 0, 2719, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -82161, 125207, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -81657, 124317, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -81757, 124851, -3752, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -82976, 130056, -3580, 0, 0, 51764, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -81354, 125207, -3752, 0, 0, 0, 25, 0, 0, 0),
-- Toruku
("gludio33_npc1721_005", 1, 30591, -69734, 116264, -3536, 0, 0, 16384, 60, 0, 0, 0),
-- Piotur
("gludio15_npc1721_004", 1, 30597, -85700, 106591, -3555, 0, 0, 16384, 60, 0, 0, 0),
-- Burai
("gludio15_npc1721_003", 1, 30617, -94294, 110818, -3696, 0, 0, 0, 60, 0, 0, 0),
-- Santiago
("gludio15_npc1721_002", 1, 30648, -85002, 105749, -3593, 0, 0, 20480, 60, 0, 0, 0),
-- Daurin Hammercrush
("gludio15_npc1721_001", 1, 30674, -97611, 106574, -3388, 0, 0, 0, 60, 0, 0, 0),
-- Broadcasting Tower
("blood_of_sacrifice_broadcast", 1, 31031, -78858, 111358, -4926, 0, 0, 16384, 5, 0, 0, 0),
("blood_of_sacrifice_broadcast", 1, 31031, -75850, 111968, -4926, 0, 0, 16384, 5, 0, 0, 0),
-- Festival Guide
("ssqe1_npc1721_01", 1, 31127, -79184, 111952, -4897, 0, 0, 49000, 60, 0, 0, 0),
-- Festival Guide
("ssqe1_npc1721_02", 1, 31128, -76176, 112560, -4897, 0, 0, 49000, 60, 0, 0, 0),
-- Festival Guide
("ssqe1_npc1721_03", 1, 31129, -75072, 111968, -4897, 0, 0, 32500, 60, 0, 0, 0),
-- Festival Guide
("ssqe1_npc1721_04", 1, 31130, -75920, 111376, -4897, 0, 0, 16500, 60, 0, 0, 0),
-- Festival Guide
("ssqe1_npc1721_05", 1, 31131, -78928, 110768, -4897, 0, 0, 16500, 60, 0, 0, 0),

-- [17_22]

-- Worshipper
("unset", 1, 4327, -86687, 151321, -3059, 0, 0, 11094, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, -86780, 151449, -3059, 0, 0, 21042, 0, 0, 0, 0),
("unset", 1, 4328, -86521, 151365, -3059, 0, 0, 990, 0, 0, 0, 0),
-- Vuku Orc Fighter
("gludio34_1722_04", 1, 20017, -66417, 161576, -3659, 0, 0, 58864, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -69501, 160029, -3130, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -69401, 159139, -2804, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -67750, 162311, -3613, 0, 0, 5587, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -75475, 163051, -3417, 0, 0, 12225, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -72579, 162741, -3623, 0, 0, 8330, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73497, 161882, -3411, 0, 0, 5111, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -74678, 158947, -2907, 0, 0, 56053, 21, 0, 0, 0),
-- Langk Lizardman
("gludio34_1722_01", 1, 20030, -80393, 162362, -3368, 0, 0, 22327, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -78445, 160396, -3231, 0, 0, 29911, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -73915, 158907, -2772, 0, 0, 11189, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -74131, 157026, -2291, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -75912, 157019, -2718, 0, 0, 11987, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -79306, 161821, -3476, 0, 0, 35139, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -80828, 160430, -3403, 0, 0, 45136, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -79747, 159854, -3251, 0, 0, 12178, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -82377, 161530, -3076, 0, 0, 33460, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -79619, 158256, -3154, 0, 0, 59709, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -83864, 159358, -3158, 0, 0, 34418, 21, 0, 0, 0),
-- Venomous Spider
("oren25_1820_01", 1, 20038, -75803, 161828, -3342, 0, 0, 47695, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -71697, 163312, -3550, 0, 0, 45876, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -65755, 162618, -3695, 0, 0, 63110, 20, 0, 0, 0),
-- Arachnid Tracker
("oren25_1820_14s", 1, 20043, -74050, 163262, -3593, 0, 0, 45252, 20, 0, 0, 0),
-- Brown Bear
("gludio34_1822_01", 1, 20310, -74598, 160993, -3263, 0, 0, 14807, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -76679, 159918, -3744, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -72742, 157692, -2507, 0, 0, 21289, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -73628, 157204, -2148, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -74432, 157204, -2148, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -73929, 156670, -2148, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -73131, 163650, -3676, 0, 0, 21818, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -71458, 161503, -3744, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -69703, 158961, -2606, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -69703, 160029, -3097, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -69105, 161646, -3430, 0, 0, 61289, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -69100, 158961, -2804, 0, 0, 0, 21, 0, 0, 0),
-- Plain Grizzly
("gludio33_1721_06", 1, 21098, -80989, 131108, -3626, 0, 0, 19787, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -80067, 134153, -3261, 0, 0, 8423, 25, 0, 0, 0),
-- Cloudy Beast Turen
("gludio33_1721_07", 1, 21099, -81868, 131935, -3500, 0, 0, 13571, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -79687, 131129, -3594, 0, 0, 57562, 25, 0, 0, 0),
("gludio33_1721_07", 1, 21099, -77903, 134429, -3343, 0, 0, 6344, 25, 0, 0, 0),
-- Auron
("gludio06_npc1722_017", 1, 30010, -81861, 149197, -3125, 0, 0, 16384, 60, 0, 0, 0),
-- Celma
("gludio06_npc1722_017", 1, 30014, -82212, 149197, -3125, 0, 0, 16384, 60, 0, 0, 0),
-- Zigaunt
("gludio06_npc1722_018", 1, 30022, -79256, 150676, -3043, 0, 0, 16384, 60, 0, 0, 0),
-- Iris
("gludio06_npc1722_018", 1, 30034, -79559, 150661, -3043, 0, 0, 16384, 60, 0, 0, 0),
-- Levian
("gludio06_npc1722_019", 1, 30037, -78982, 150830, -3033, 0, 0, 32768, 60, 0, 0, 0),
-- Arodin
("gludio06_npc1722_001", 1, 30207, -80343, 154897, -3162, 0, 0, 16384, 60, 0, 0, 0),
-- Damion
("gludio06_npc1722_001", 1, 30208, -80935, 155526, -3162, 0, 0, 0, 60, 0, 0, 0),
-- Colleen
("gludio06_npc1722_036", 1, 30209, -81908, 152077, -3125, 0, 0, 0, 60, 0, 0, 0),
-- Norman
("gludio06_npc1722_020", 1, 30210, -81857, 153545, -3171, 0, 0, 49152, 60, 0, 0, 0),
-- Xenos
("gludio06_npc1722_032", 1, 30290, -84401, 149606, -3127, 0, 0, 16384, 60, 0, 0, 0),
-- Asha
("gludio06_npc1722_035", 1, 30313, -81266, 152076, -3125, 0, 0, 32768, 60, 0, 0, 0),
-- Nestle
("gludio06_npc1722_034", 1, 30314, -80108, 153307, -3162, 0, 0, 0, 60, 0, 0, 0),
-- Poesia
("gludio06_npc1722_031", 1, 30315, -79405, 153963, -3160, 0, 0, 49152, 60, 0, 0, 0),
-- Raut
("gludio06_npc1722_020", 1, 30316, -81966, 153547, -3170, 0, 0, 49152, 60, 0, 0, 0),
-- Kluto
("gludio06_npc1722_021", 1, 30317, -83172, 155483, -3174, 0, 0, 0, 60, 0, 0, 0),
-- Richlin
("gludio06_npc1722_038", 1, 30320, -80752, 149776, -3044, 0, 0, 20480, 60, 0, 0, 0),
-- Baenedes
("gludio06_npc1722_017", 1, 30369, -81864, 149502, -3125, 0, 0, 49152, 60, 0, 0, 0),
-- Ramos
("gludio06_npc1722_017", 1, 30373, -81688, 149350, -3125, 0, 0, 32768, 60, 0, 0, 0),
-- Rhodiell
("gludio06_npc1722_017", 1, 30374, -82211, 149504, -3125, 0, 0, 49152, 60, 0, 0, 0),
-- Adonius
("gludio06_npc1722_018", 1, 30375, -79274, 150966, -3031, 0, 0, 49152, 60, 0, 0, 0),
-- Nell
("gludio06_npc1722_018", 1, 30376, -79557, 150982, -3043, 0, 0, 49152, 60, 0, 0, 0),
-- Talbot
("gludio06_npc1722_024", 1, 30377, -84642, 149630, -3127, 0, 0, 8192, 60, 0, 0, 0),
-- Estella
("gludio06_npc1722_032", 1, 30378, -84661, 149989, -3127, 0, 0, 0, 60, 0, 0, 0),
-- Bezique
("gludio06_npc1722_040", 1, 30379, -85019, 152887, -3178, 0, 0, 32768, 60, 0, 0, 0),
-- Plink
("gludio06_npc1722_041", 1, 30380, -85019, 152592, -3178, 0, 0, 32768, 60, 0, 0, 0),
-- Alvah
("gludio06_npc1722_046", 1, 30381, -83520, 149262, -3120, 0, 0, 49152, 60, 0, 0, 0),
-- Leikan
("gludio06_npc1722_043", 1, 30382, -82822, 149258, -3120, 0, 0, 49152, 60, 0, 0, 0),
-- Scott
("gludio06_npc1722_044", 1, 30383, -78621, 152517, -3168, 0, 0, 0, 60, 0, 0, 0),
-- Linus
("gludio06_npc1722_045", 1, 30384, -78621, 152973, -3168, 0, 0, 0, 60, 0, 0, 0),
-- Weisz
("gludio06_npc1722_037", 1, 30385, -77291, 155983, -3191, 0, 0, 12288, 60, 0, 0, 0),
-- Luis
("gludio06_npc1722_039", 1, 30386, -77989, 156475, -3187, 0, 0, 8192, 60, 0, 0, 0),
-- Clancy
("gludio06_npc1722_042", 1, 30387, -91792, 149968, -3629, 0, 0, 0, 60, 0, 0, 0),
-- Parina
("gludio06_npc1722_023", 1, 30391, -80430, 150694, -3040, 0, 0, 24576, 60, 0, 0, 0),
-- Sir Klaus Vasper
("gludio06_npc1722_033", 1, 30417, -82437, 150282, -3129, 0, 0, 16384, 60, 0, 0, 0),
-- Kalinta
("gludio06_npc1722_024", 1, 30422, -84400, 149872, -3129, 0, 0, 49152, 60, 0, 0, 0),
-- Allana
("gludio06_npc1722_025", 1, 30424, -92310, 154223, -3284, 0, 0, 57344, 60, 0, 0, 0),
-- Neti
("gludio06_npc1722_003", 1, 30425, -83414, 151924, -3127, 0, 0, 57344, 60, 0, 0, 0),
-- Perrin
("gludio06_npc1722_026", 1, 30428, -93275, 147654, -2674, 0, 0, 0, 60, 0, 0, 0),
-- Leopold
("gludio06_npc1722_047", 1, 30435, -79705, 155131, -3176, 0, 0, 49152, 60, 0, 0, 0),
-- Moke
("gludio06_npc1722_020", 1, 30498, -81913, 153545, -3171, 0, 0, 49152, 60, 0, 0, 0),
-- Tapoy
("gludio06_npc1722_016", 1, 30499, -82954, 155618, -3180, 0, 0, 47152, 60, 0, 0, 0),
-- Osborn
("gludio06_npc1722_053", 1, 30500, -80386, 153282, -3176, 0, 0, 32000, 60, 0, 0, 0),
-- Kasman
("gludio06_npc1722_053", 1, 30501, -80448, 153408, -3176, 0, 0, 32000, 60, 0, 0, 0),
-- Umos
("gludio06_npc1722_053", 1, 30502, -80448, 153208, -3176, 0, 0, 32000, 60, 0, 0, 0),
-- Duda-Mara Totem Spirit
("gludio06_npc1722_022", 1, 30593, -85923, 136496, -3170, 0, 0, 44485, 60, 0, 0, 0),
-- Triff
("gludio06_npc1722_015", 1, 30611, -93523, 152513, -3623, 0, 0, 28672, 60, 0, 0, 0),
-- Galatea
("gludio06_npc1722_014", 1, 30634, -81199, 151904, -3118, 0, 0, 27000, 60, 0, 0, 0),
-- Martin
("gludio06_npc1722_002", 1, 30731, -84624, 150832, -3129, 0, 0, 0, 60, 0, 0, 0),
-- Auctioneer
("gludio06_npc1722_064", 1, 30767, -81376, 151715, -3132, 0, 0, 49152, 60, 0, 0, 0),
-- Lottery Ticket Seller
("Lottery Ticket Seller", 1, 30990, -80785, 149735, -3040, 0, 0, 23000, 5, 0, 0, 0),
-- Broadcasting Tower
("gludin_broadcast", 1, 31031, -81280, 154369, -3165, 0, 0, 16384, 5, 0, 0, 0),
-- Marsden
("gludio06_npc1722_050", 1, 31046, -81520, 152256, -3120, 0, 0, -16160, 60, 0, 0, 0),
-- Newbie Helper
("gludio06_npc1722_051", 1, 31076, -83123, 150868, -3120, 0, 0, 0, 60, 0, 0, 0),
-- Priest of Dawn
("gludio06_npc1722_ssq01", 1, 31078, -80555, 150387, -3040, 0, 0, 45000, 60, 0, 0, 0),
-- Dusk Priestess
("gludio06_npc1722_ssq02", 1, 31085, -82368, 151618, -3120, 0, 0, 48000, 60, 0, 0, 0),
-- Black Marketeer of Mammon
("gludio06_npc1722_ssq03", 1, 31092, -84745, 151732, -3128, 0, 0, 50000, 60, 0, 0, 0),
-- Maximus
("unset", 1, 31202, -84624, 150832, -3129, 0, 0, 50307, 5, 0, 0, 0),
-- Aren
("gludio06_npc1722_055", 1, 31416, -80324, 150762, -3039, 0, 0, 0, 60, 0, 0, 0),
-- Koram
("gludio06_npc1722_053", 1, 31425, -80387, 153328, -3176, 0, 0, 32000, 60, 0, 0, 0),
-- Rogen
("gludio06_npc1722_054", 1, 31439, -83197, 155347, -3174, 0, 0, 0, 60, 0, 0, 0),
-- Bleaker
("gludio06_npc1722_057", 1, 31567, -79369, 153318, -3159, 0, 0, 26000, 60, 0, 0, 0),
-- Cyano
("gludio06_npc1722_056", 1, 31569, -91328, 149392, -3625, 0, 0, 16000, 60, 0, 0, 0),
-- Grand Olympiad Manager
("gludio25_npc1725_018", 1, 31688, -84816, 151056, -3127, 0, 0, 0, 60, 0, 0, 0),
-- Monument of Heroes 
("gludio25_npc1725_018", 1, 31690, -84816, 151008, -3127, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio06_npc1722_059", 1, 31787, -78992, 152512, -3170, 0, 0, 33000, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio06_npc1722_060", 1, 31788, -79400, 155400, -3176, 0, 0, 49000, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio06_npc1722_061", 1, 31789, -81904, 153824, -3176, 0, 0, 16500, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio06_npc1722_062", 1, 31790, -83160, 150844, -3127, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio06_npc1722_063", 1, 31791, -83524, 149488, -3127, 0, 0, 16500, 60, 0, 0, 0),
-- Yeniche
("unset", 1, 32193, -84734, 153122, -3160, 0, 0, 8489, 60, 0, 0, 0),
-- Shubain
("unset", 1, 32194, -84773, 153134, -3160, 0, 0, 16384, 60, 0, 0, 0),
-- Sione
("unset", 1, 32195, -84697, 153134, -3160, 0, 0, 16384, 60, 0, 0, 0),
-- Dimensional Merchant
("unset", 1, 32478, -82368, 153664, -3168, 0, 0, 16500, 60, 0, 0, 0),
-- Inspector Adler
("Gludin Pailaka NPC", 1, 32497, -80570, 151298, -3040, 0, 0, 20480, 60, 0, 0, 0),
-- Lyann
("gludio06_npc1722_054", 1, 32874, -82930, 155352, -3176, 0, 0, 24000, 60, 0, 0, 0),
-- Manor Manager
("gludio25_npc1725_015", 1, 35103, -82640, 150016, -3120, 0, 0, 15012, 60, 0, 0, 0),
("gludio25_npc1725_015", 1, 35103, -81824, 155264, -3168, 0, 0, -17076, 60, 0, 0, 0),
-- Bremmer
("gludio06_npc1722_009", 1, 35392, -84596, 152253, -3125, 0, 0, 53248, 60, 0, 0, 0),
-- Faolan
("gludio06_npc1722_008", 1, 35393, -83954, 151814, -3127, 0, 0, 49152, 60, 0, 0, 0),
-- Kalis
("gludio06_npc1722_007", 1, 35394, -84276, 153321, -3161, 0, 0, 0, 60, 0, 0, 0),
-- Kogan
("gludio06_npc1722_006", 1, 35395, -83943, 153704, -3178, 0, 0, 0, 60, 0, 0, 0),
-- Winker
("gludio06_npc1722_004", 1, 35396, -84282, 155597, -3160, 0, 0, 48512, 60, 0, 0, 0),
-- Merton
("gludio06_npc1722_005", 1, 35397, -83884, 155274, -3178, 0, 0, 57344, 60, 0, 0, 0),
-- Ruben
("gludio06_npc1722_013", 1, 35398, -79357, 150232, -3037, 0, 0, 40000, 60, 0, 0, 0),
-- Luce
("gludio06_npc1722_012", 1, 35399, -79803, 150032, -3044, 0, 0, 32768, 60, 0, 0, 0),
-- Horner
("gludio06_npc1722_011", 1, 35400, -79587, 151436, -3041, 0, 0, 8192, 60, 0, 0, 0),
-- Amiel
("gludio06_npc1722_010", 1, 35401, -79800, 151598, -3044, 0, 0, 32768, 60, 0, 0, 0),

-- [17_23]

-- Vuku Orc Fighter
("gludio34_1722_04", 1, 20017, -74565, 166708, -3695, 0, 0, 41717, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -75813, 166985, -3602, 0, 0, 13975, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -74779, 164316, -3588, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -75181, 165028, -35924, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -74578, 163960, -3586, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -71834, 169851, -3678, 0, 0, 46214, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -70068, 166041, -3631, 0, 0, 33805, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -71479, 164878, -3588, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -70879, 164139, -3475, 0, 0, 2450, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73303, 169251, -3532, 0, 0, 6612, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -70941, 171515, -3675, 0, 0, 10838, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -72094, 166238, -3686, 0, 0, 56553, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73891, 169834, -3487, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73892, 167698, -3664, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -76734, 169397, -3714, 0, 0, 37483, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -74093, 168054, -3593, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73189, 168232, -3687, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -67270, 173094, -3617, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -67572, 173272, -3617, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -69660, 169646, -3600, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -69515, 167013, -3617, 0, 0, 45900, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -68131, 164862, -3686, 0, 0, 59227, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -69614, 164342, -3608, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -72948, 165515, -3719, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_04", 1, 20017, -73452, 166049, -3730, 0, 0, 0, 21, 0, 0, 0),
-- Langk Lizardman
("gludio34_1722_01", 1, 20030, -80652, 165584, -3072, 0, 0, 13749, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -77564, 166914, -3728, 0, 0, 28723, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -67975, 172916, -3608, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -67371, 172916, -3609, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -69761, 168756, -3578, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -75048, 172848, -3682, 0, 0, 30623, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -79915, 167040, -3171, 0, 0, 41853, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -76494, 170334, -3723, 0, 0, 5115, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -79112, 165818, -3427, 0, 0, 4088, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -80281, 164284, -3262, 0, 0, 16078, 21, 0, 0, 0),
("gludio34_1722_01", 1, 20030, -78600, 166752, -3483, 0, 0, 15215, 21, 0, 0, 0),
-- Venomous Spider
("oren25_1820_01", 1, 20038, -74678, 164850, -3647, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -73476, 165084, -3721, 0, 0, 47247, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -78321, 165606, -3699, 0, 0, 32633, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -76642, 165247, -3576, 0, 0, 52938, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -72385, 164700, -3663, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -71882, 164878, -3650, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -71882, 164166, -3588, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -71878, 168697, -3682, 0, 0, 62117, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -73328, 166706, -3721, 0, 0, 65147, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -72284, 167730, -3712, 0, 0, 27332, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -73993, 167876, -3638, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -76234, 168135, -3692, 0, 0, 23857, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -68417, 164204, -3678, 0, 0, 52524, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -69714, 164876, -3649, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -66626, 175110, -3719, 0, 0, 61545, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -65928, 177221, -3440, 0, 0, 8192, 20, 0, 0, 0),
-- Arachnid Tracker
("oren25_1820_14s", 1, 20043, -75402, 166261, -3640, 0, 0, 20561, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -71205, 166715, -3605, 0, 0, 25852, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -70894, 167511, -3564, 0, 0, 58223, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -78418, 167720, -3487, 0, 0, 29255, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -73790, 169656, -3483, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -71632, 172379, -3501, 0, 0, 10631, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -68986, 172429, -3673, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -69165, 179355, -3689, 0, 0, 33151, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -73232, 174816, -3673, 0, 0, 29464, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -75000, 171985, -3680, 0, 0, 50412, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -72646, 165693, -3713, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -66925, 164395, -3704, 0, 0, 58791, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -70541, 170542, -3720, 0, 0, 32601, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -72775, 170782, -3507, 0, 0, 27366, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67271, 167544, -3538, 0, 0, 57896, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67210, 171898, -3629, 0, 0, 37664, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -67983, 175104, -3718, 0, 0, 29162, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -68912, 176291, -3530, 0, 0, 30542, 20, 0, 0, 0),
-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -70354, 173829, -3457, 0, 0, 6298, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -71875, 176836, -3631, 0, 0, 35874, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -66035, 168070, -3378, 0, 0, 19578, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -68043, 170156, -3580, 0, 0, 34893, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -66063, 170709, -3401, 0, 0, 19075, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -68847, 168007, -3633, 0, 0, 43853, 21, 0, 0, 0),
-- Brown Bear
("gludio34_1822_01", 1, 20310, -77527, 167428, -3696, 0, 0, 17067, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -78808, 163971, -3699, 0, 0, 24364, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -68707, 165842, -3660, 0, 0, 15525, 21, 0, 0, 0),

-- [17_25]

-- Worshipper
("unset", 1, 4327, -92545, 244590, -3547, 0, 0, 12868, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, -92657, 244716, -3547, 0, 0, 48184, 0, 0, 0, 0),
("unset", 1, 4328, -92383, 244642, -3547, 0, 0, 5431, 0, 0, 0, 0),
-- Gremlin
("Talking_Island", 1, 18342, -71438, 258005, -3104, 0, 0, 2077, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71355, 257928, -3104, 0, 0, 44930, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71544, 258371, -3104, 0, 0, 53460, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71224, 258443, -3104, 0, 0, 0, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71075, 258448, -3104, 0, 0, 57841, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71331, 258505, -3104, 0, 0, 64748, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71127, 258699, -3096, 0, 0, 11208, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71346, 258501, -3104, 0, 0, 52509, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71139, 258295, -3104, 0, 0, 51281, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -71134, 258686, -3096, 0, 0, 34518, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90302, 248399, -3568, 0, 0, 56429, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90408, 248285, -3568, 0, 0, 47973, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90411, 248457, -3568, 0, 0, 4906, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90386, 248436, -3568, 0, 0, 61222, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -91040, 248299, -3568, 0, 0, 21326, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90590, 248507, -3568, 0, 0, 36961, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90753, 248238, -3568, 0, 0, 46598, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90734, 248397, -3568, 0, 0, 21778, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90349, 248368, -3568, 0, 0, 19132, 15, 0, 0, 0),
("Talking_Island", 1, 18342, -90646, 248466, -3568, 0, 0, 41911, 15, 0, 0, 0),
-- Orc Archer
("Talking_Island", 1, 20006, -97176, 234686, -3544, 0, 0, 45952, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -95622, 233391, -3640, 0, 0, 44682, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -93897, 251080, -3552, 0, 0, 19403, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -97004, 254019, -3512, 0, 0, 25348, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -93980, 253442, -3344, 0, 0, 62783, 20, 0, 0, 0),
("Talking_Island", 1, 20006, -97189, 254850, -3424, 0, 0, 25376, 20, 0, 0, 0),
-- Orc Fighter
("Talking_Island", 1, 20093, -97571, 249433, -3632, 0, 0, 55789, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -98007, 249707, -3608, 0, 0, 41361, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -97529, 252171, -3600, 0, 0, 28089, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -97418, 254057, -3504, 0, 0, 54489, 20, 0, 0, 0),
("Talking_Island", 1, 20093, -97483, 256185, -3432, 0, 0, 18567, 20, 0, 0, 0),
-- Wolf
("Talking_Island", 1, 20120, -82338, 249868, -3648, 0, 0, 30747, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -84254, 239065, -3712, 0, 0, 57345, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -84453, 238707, -3696, 0, 0, 17374, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -85122, 238721, -3680, 0, 0, 31470, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -84750, 238544, -3688, 0, 0, 43295, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -88640, 237848, -3656, 0, 0, 50336, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -88281, 238175, -3624, 0, 0, 43965, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -88778, 238422, -3608, 0, 0, 32767, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -88082, 241256, -3584, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -88374, 240511, -3608, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -89202, 240446, -3592, 0, 0, 56374, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -89796, 241674, -3568, 0, 0, 22190, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -90892, 241569, -3536, 0, 0, 54252, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -92232, 244668, -3496, 0, 0, 33265, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -90995, 244724, -3592, 0, 0, 18188, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -91439, 244022, -3472, 0, 0, 53067, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -91281, 244515, -3528, 0, 0, 61810, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -93602, 239944, -3392, 0, 0, 57070, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -93079, 242740, -3480, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -93572, 241937, -3440, 0, 0, 59135, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -92893, 239381, -3464, 0, 0, 43645, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -92797, 239238, -3512, 0, 0, 59877, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -93064, 235717, -3688, 0, 0, 64223, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -93737, 235133, -3672, 0, 0, 23296, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -95193, 240426, -3264, 0, 0, 63053, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -96878, 238526, -3312, 0, 0, 64885, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -97105, 242615, -3504, 0, 0, 13589, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -97160, 242240, -3504, 0, 0, 10030, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -86607, 255074, -3736, 0, 0, 25698, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -85466, 254235, -3728, 0, 0, 14661, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -84970, 254138, -3720, 0, 0, 3772, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -83023, 251911, -3704, 0, 0, 42638, 25, 0, 0, 0),
("Talking_Island", 1, 20120, -85241, 239152, -3712, 0, 0, 13473, 25, 0, 0, 0),
-- Giant Toad
("Talking_Island", 1, 20121, -92338, 245975, -3696, 0, 0, 64654, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -93586, 246443, -3656, 0, 0, 40693, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -93937, 246361, -3624, 0, 0, 35405, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -93091, 245752, -3648, 0, 0, 58617, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97072, 245898, -3672, 0, 0, 42852, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97153, 245398, -3680, 0, 0, 48311, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97154, 245279, -3672, 0, 0, 24844, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97643, 244917, -3696, 0, 0, 56544, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -95108, 245505, -3560, 0, 0, 42125, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97945, 247252, -3648, 0, 0, 17335, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97793, 247922, -3592, 0, 0, 22134, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -96731, 247552, -3648, 0, 0, 31529, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -97052, 247372, -3672, 0, 0, 6889, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -95602, 246483, -3624, 0, 0, 38003, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -94362, 246378, -3656, 0, 0, 29612, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -96288, 245894, -3624, 0, 0, 19031, 25, 0, 0, 0),
("Talking_Island", 1, 20121, -94641, 246526, -3640, 0, 0, 19469, 25, 0, 0, 0),
-- Orc
("Talking_Island", 1, 20130, -92721, 240446, -3408, 0, 0, 28523, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -93840, 240955, -3368, 0, 0, 46330, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -93243, 238461, -3536, 0, 0, 38668, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -93300, 239085, -3464, 0, 0, 30212, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -92038, 235991, -3688, 0, 0, 45364, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -93134, 235880, -3688, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -94727, 237159, -3432, 0, 0, 841, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -94718, 238741, -3424, 0, 0, 1069, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -95149, 238478, -3400, 0, 0, 10289, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -94924, 237465, -3424, 0, 0, 48626, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -96885, 238751, -3296, 0, 0, 19940, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -96554, 242002, -3408, 0, 0, 30417, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -95161, 243914, -3544, 0, 0, 40114, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -94790, 244730, -3616, 0, 0, 15217, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -96332, 244550, -3576, 0, 0, 42346, 25, 0, 0, 0),
("Talking_Island", 1, 20130, -94885, 243725, -3544, 0, 0, 31402, 25, 0, 0, 0),
-- Orc Grunt
("Talking_Island", 1, 20131, -95175, 237294, -3400, 0, 0, 46929, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -95227, 237177, -3400, 0, 0, 32697, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -95481, 238672, -3360, 0, 0, 3505, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -94534, 238728, -3424, 0, 0, 18733, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -97235, 243770, -3560, 0, 0, 11714, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -96911, 244488, -3560, 0, 0, 9313, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -96761, 244405, -3552, 0, 0, 44328, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -97112, 234061, -3560, 0, 0, 45324, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -96774, 234431, -3592, 0, 0, 57986, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -97739, 232283, -3520, 0, 0, 50411, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -94253, 251462, -3520, 0, 0, 34361, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -94256, 250266, -3560, 0, 0, 21314, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -92330, 253564, -3344, 0, 0, 35015, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -92209, 252849, -3416, 0, 0, 60630, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -91184, 254658, -3416, 0, 0, 62516, 25, 0, 0, 0),
("Talking_Island", 1, 20131, -88883, 254930, -3680, 0, 0, 45443, 25, 0, 0, 0),
-- Werewolf
("Talking_Island", 1, 20132, -95277, 233415, -3672, 0, 0, 51570, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -96285, 234919, -3640, 0, 0, 54411, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -96519, 233461, -3616, 0, 0, 18293, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -96506, 250440, -3536, 0, 0, 35985, 20, 0, 0, 0),
("Talking_Island", 1, 20132, -97003, 252424, -3576, 0, 0, 51249, 20, 0, 0, 0),
-- Goblin Scout
("Talking_Island", 1, 20326, -95822, 234307, -3664, 0, 0, 15665, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -98146, 235067, -3400, 0, 0, 48502, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -96772, 234819, -3608, 0, 0, 46161, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -97755, 248630, -3592, 0, 0, 4554, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -97185, 250412, -3568, 0, 0, 45272, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -94272, 251906, -3480, 0, 0, 26534, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -94231, 251177, -3544, 0, 0, 19589, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -94339, 254082, -3312, 0, 0, 24659, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -92897, 252507, -3424, 0, 0, 3243, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -92238, 252902, -3416, 0, 0, 13103, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -93993, 254292, -3280, 0, 0, 27345, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -97780, 256068, -3432, 0, 0, 25195, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -90115, 252869, -3472, 0, 0, 27074, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -90544, 255716, -3592, 0, 0, 64239, 20, 0, 0, 0),
("Talking_Island", 1, 20326, -88975, 253760, -3624, 0, 0, 51708, 20, 0, 0, 0),
-- Elpy
("Talking_Island", 1, 20432, -80215, 246216, -3720, 0, 0, 17910, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -81749, 246401, -3672, 0, 0, 63194, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -81038, 246626, -3680, 0, 0, 27589, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -82100, 247820, -3648, 0, 0, 41297, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -83121, 246573, -3608, 0, 0, 2219, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -81114, 245082, -3720, 0, 0, 61761, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -83436, 239577, -3720, 0, 0, 38585, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -80967, 241193, -3656, 0, 0, 45757, 25, 0, 0, 0),
("Talking_Island", 1, 20432, -80967, 244245, -3720, 0, 0, 27803, 25, 0, 0, 0),
-- Elder Wolf
("Talking_Island", 1, 20442, -88323, 237533, -3648, 0, 0, 47171, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -89224, 238032, -3648, 0, 0, 40160, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -88200, 237890, -3632, 0, 0, 62981, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -90132, 238055, -3632, 0, 0, 55041, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -93843, 240907, -3368, 0, 0, 45330, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -93510, 240541, -3384, 0, 0, 27302, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -93335, 239807, -3408, 0, 0, 26994, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -90461, 237100, -3688, 0, 0, 27266, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -92595, 236306, -3696, 0, 0, 5536, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -94455, 238810, -3432, 0, 0, 25419, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -95878, 241385, -3312, 0, 0, 59898, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -95650, 241111, -3296, 0, 0, 31767, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -96817, 240100, -3352, 0, 0, 1443, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -97766, 241963, -3544, 0, 0, 28465, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -95371, 243512, -3544, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -95159, 243277, -3544, 0, 0, 22876, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -96952, 244160, -3552, 0, 0, 16911, 25, 0, 0, 0),
("Talking_Island", 1, 20442, -94835, 245073, -3592, 0, 0, 26856, 25, 0, 0, 0),
-- Bearded Keltir
("Talking_Island", 1, 20481, -74661, 256302, -3128, 0, 0, 46973, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -71616, 255341, -3272, 0, 0, 25664, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -72086, 254636, -3288, 0, 0, 10623, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -72738, 254789, -3304, 0, 0, 34990, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -73235, 254744, -3272, 0, 0, 4006, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -71360, 255081, -3240, 0, 0, 17216, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -74261, 252908, -3336, 0, 0, 53084, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -74471, 253546, -3328, 0, 0, 14830, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -73913, 252998, -3368, 0, 0, 31727, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -73423, 253588, -3352, 0, 0, 25972, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81375, 247668, -3648, 0, 0, 36738, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81945, 247298, -3640, 0, 0, 43516, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -80690, 246025, -3704, 0, 0, 56621, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81584, 247779, -3664, 0, 0, 56190, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -83459, 246582, -3584, 0, 0, 18197, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -82208, 249873, -3640, 0, 0, 685, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -83131, 250184, -3648, 0, 0, 64579, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -80764, 245858, -3712, 0, 0, 22286, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -80552, 243378, -3728, 0, 0, 25308, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -82049, 240960, -3704, 0, 0, 59233, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -88229, 241024, -3568, 0, 0, 62634, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -88175, 241833, -3584, 0, 0, 64924, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -90663, 241147, -3504, 0, 0, 53376, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -90859, 241032, -3496, 0, 0, 11916, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -87354, 254561, -3720, 0, 0, 3742, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -86670, 250888, -3600, 0, 0, 9507, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -86373, 251399, -3592, 0, 0, 17216, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -86195, 254977, -3736, 0, 0, 60426, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -84912, 251195, -3584, 0, 0, 49153, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -84450, 252876, -3672, 0, 0, 59091, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -85215, 252867, -3672, 0, 0, 20845, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -80521, 247242, -3640, 0, 0, 46960, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81166, 248377, -3688, 0, 0, 33186, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81895, 245637, -3704, 0, 0, 58948, 25, 0, 0, 0),
("Talking_Island", 1, 20481, -81721, 240745, -3696, 0, 0, 49701, 25, 0, 0, 0),
-- Elder Keltir
("Talking_Island", 1, 20544, -81683, 248641, -3696, 0, 0, 37047, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82024, 246684, -3656, 0, 0, 49701, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -80402, 246692, -3704, 0, 0, 48604, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -80314, 245873, -3720, 0, 0, 6437, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82230, 247813, -3632, 0, 0, 1131, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82419, 246577, -3648, 0, 0, 19343, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -83698, 246659, -3544, 0, 0, 9423, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82848, 246532, -3616, 0, 0, 55342, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -83463, 246535, -3584, 0, 0, 45602, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82943, 250309, -3664, 0, 0, 53806, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82766, 239995, -3704, 0, 0, 6739, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82949, 239382, -3704, 0, 0, 11362, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -83811, 238717, -3704, 0, 0, 60247, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -83442, 239153, -3704, 0, 0, 30789, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -85854, 239160, -3704, 0, 0, 35274, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -85867, 239600, -3704, 0, 0, 26117, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -88443, 240801, -3560, 0, 0, 39274, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -88282, 240608, -3592, 0, 0, 3098, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -89374, 240660, -3560, 0, 0, 42564, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -89667, 241841, -3576, 0, 0, 18071, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -91069, 240967, -3472, 0, 0, 44042, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -92001, 243390, -3488, 0, 0, 63256, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -91248, 244230, -3504, 0, 0, 25945, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -92570, 244155, -3472, 0, 0, 816, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -86719, 253223, -3712, 0, 0, 32211, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -86310, 254405, -3736, 0, 0, 12414, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -85308, 252888, -3672, 0, 0, 4006, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -84759, 253513, -3704, 0, 0, 27184, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -84192, 251922, -3664, 0, 0, 50247, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -82351, 246310, -3664, 0, 0, 61618, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -80898, 245807, -3720, 0, 0, 14932, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -83003, 240397, -3728, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -80935, 241831, -3736, 0, 0, 0, 25, 0, 0, 0),
("Talking_Island", 1, 20544, -80371, 243265, -3736, 0, 0, 0, 25, 0, 0, 0),
-- Young Keltir
("Talking_Island", 1, 20545, -74866, 255282, -3216, 0, 0, 3550, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -74250, 256558, -3120, 0, 0, 2192, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -74019, 256725, -3120, 0, 0, 63612, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -73186, 254866, -3280, 0, 0, 40305, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -72971, 255123, -3256, 0, 0, 22286, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -71081, 254981, -3232, 0, 0, 48948, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -74412, 253200, -3328, 0, 0, 41180, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -75504, 252167, -3328, 0, 0, 13878, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -73363, 253876, -3328, 0, 0, 21407, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -76457, 254228, -3208, 0, 0, 52895, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -87140, 251482, -3608, 0, 0, 62051, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -86529, 251952, -3624, 0, 0, 37512, 25, 0, 0, 0),
("Talking_Island", 1, 20545, -84860, 251242, -3592, 0, 0, 23095, 25, 0, 0, 0),
-- Spirit Of Mirrors
("Talking_Island", 1, 27003, -96984, 247644, -3640, 0, 0, 20794, 180, 0, 0, 0),
-- Lector
("Talking_Island_Npc", 1, 30001, -86385, 243267, -3717, 0, 0, 52000, 60, 0, 0, 0),
-- Jackson
("Talking_Island_Npc", 1, 30002, -86733, 242918, -3720, 0, 0, 61440, 60, 0, 0, 0),
-- Silvia
("Talking_Island_Npc", 1, 30003, -83789, 240799, -3717, 0, 0, 32768, 60, 0, 0, 0),
-- Katerina
("Talking_Island_Npc", 1, 30004, -84204, 240403, -3720, 0, 0, 14000, 60, 0, 0, 0),
-- Wilford
("Talking_Island_Npc", 1, 30005, -81512, 243424, -3712, 0, 0, 38000, 60, 0, 0, 0),
-- Milia
("Talking_Island_Npc", 1, 30006, -84108, 244604, -3728, 0, 0, 40960, 60, 0, 0, 0),
-- Roien
("Talking_Island_Npc", 1, 30008, -71384, 258304, -3104, 0, 0, 42000, 60, 0, 0, 0),
-- Newbie Helper
("Talking_Island_Npc", 1, 30009, -71424, 258336, -3104, 0, 0, 42000, 60, 0, 0, 0),
-- Gallint
("Talking_Island_Npc", 1, 30017, -91008, 248016, -3560, 0, 0, 6000, 60, 0, 0, 0),
-- Newbie Helper
("Talking_Island_Npc", 1, 30019, -91036, 248044, -3560, 0, 0, 6000, 60, 0, 0, 0),
-- Bitz
("Talking_Island_Npc", 1, 30026, -83326, 242964, -3720, 0, 0, 55344, 60, 0, 0, 0),
-- Gwinter
("Talking_Island_Npc", 1, 30027, -83020, 242553, -3720, 0, 0, 11200, 60, 0, 0, 0),
-- Pintage
("Talking_Island_Npc", 1, 30028, -82809, 242751, -3720, 0, 0, 36864, 60, 0, 0, 0),
-- Minia
("Talking_Island_Npc", 1, 30029, -83175, 243065, -3720, 0, 0, 45956, 60, 0, 0, 0),
-- Biotin
("Talking_Island_Npc", 1, 30031, -84516, 245449, -3712, 0, 0, 40960, 60, 0, 0, 0),
-- Yohanes
("Talking_Island_Npc", 1, 30032, -84981, 244764, -3720, 0, 0, 24576, 60, 0, 0, 0),
-- Baulro
("Talking_Island_Npc", 1, 30033, -84729, 245001, -3720, 0, 0, 24576, 60, 0, 0, 0),
-- Harrys
("Talking_Island_Npc", 1, 30035, -84965, 245222, -3720, 0, 0, 57000, 60, 0, 0, 0),
-- Petron
("Talking_Island_Npc", 1, 30036, -85186, 245001, -3720, 0, 0, 57000, 60, 0, 0, 0),
-- Gilbert
("Talking_Island_Npc", 1, 30039, -82236, 241573, -3728, 0, 0, 58500, 60, 0, 0, 0),
-- Leon
("Talking_Island_Npc", 1, 30040, -82515, 241221, -3728, 0, 0, 58500, 60, 0, 0, 0),
-- Arnold
("Talking_Island_Npc", 1, 30041, -82319, 244709, -3728, 0, 0, 9000, 60, 0, 0, 0),
-- Abellos
("Talking_Island_Npc", 1, 30042, -82659, 244992, -3712, 0, 0, 9000, 60, 0, 0, 0),
-- Johnstone
("Talking_Island_Npc", 1, 30043, -86114, 244682, -3728, 0, 0, 25500, 60, 0, 0, 0),
-- Chiperan
("Talking_Island_Npc", 1, 30044, -86328, 244448, -3720, 0, 0, 25500, 60, 0, 0, 0),
-- Kenyos
("Talking_Island_Npc", 1, 30045, -86322, 241215, -3728, 0, 0, 42500, 60, 0, 0, 0),
-- Hanks
("Talking_Island_Npc", 1, 30046, -85964, 240947, -3728, 0, 0, 42500, 60, 0, 0, 0),
-- Firon
("Talking_Island_Npc", 1, 30047, -97131, 258946, -3616, 0, 0, 0, 60, 0, 0, 0),
-- Darin
("Talking_Island_Npc", 1, 30048, -84436, 242793, -3728, 0, 0, 42000, 60, 0, 0, 0),
-- Bonnie
("Talking_Island_Npc", 1, 30049, -83163, 243560, -3728, 0, 0, 20480, 60, 0, 0, 0),
-- Elias
("Talking_Island_Npc", 1, 30050, -84057, 242832, -3728, 0, 0, 59000, 60, 0, 0, 0),
-- Cristel
("Talking_Island_Npc", 1, 30051, -82041, 242718, -3720, 0, 0, 20480, 60, 0, 0, 0),
-- Rant
("Talking_Island_Npc", 1, 30054, -81895, 243917, -3712, 0, 0, 41500, 60, 0, 0, 0),
-- Rolfe
("Talking_Island_Npc", 1, 30055, -81840, 243534, -3712, 0, 0, 5000, 60, 0, 0, 0),
-- Altran
("Talking_Island_Npc", 1, 30283, -85026, 242689, -3720, 0, 0, 57344, 60, 0, 0, 0),
-- Rockswell
("Talking_Island_Npc", 1, 30312, -78939, 240305, -3440, 0, 0, 28672, 60, 0, 0, 0),
-- Lilith
("Talking_Island_Npc", 1, 30368, -85301, 244587, -3720, 0, 0, 24576, 60, 0, 0, 0),
-- Matheo
("Talking_Island_Npc", 1, 30406, -92622, 254108, -3304, 0, 0, 0, 60, 0, 0, 0),
-- Newbie Helper
("Talking_Island_Npc", 1, 30598, -84081, 243227, -3728, 0, 0, 9000, 60, 0, 0, 0),
-- Guard
("Talking_Island_Npc", 1, 30733, -77978, 250458, -3544, 0, 0, 36863, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 30733, -87406, 250079, -3592, 0, 0, 8192, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 30733, -87847, 250564, -3608, 0, 0, 4096, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 30733, -97211, 258230, -3544, 0, 0, 57343, 60, 0, 0, 0),
-- Lottery Ticket Seller
("Talking_Island_Npc", 1, 30990, -84143, 244637, -3728, 0, 0, 41000, 60, 0, 0, 0),
-- Broadcasting Tower
("Talking_Island_Npc", 1, 31031, -82795, 243147, -3718, 0, 0, 16384, 5, 0, 0, 0),
-- Guard
("Talking_Island_Npc", 1, 31032, -75001, 255290, -3208, 0, 0, 20103, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -83171, 246286, -3640, 0, 0, 36185, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -82178, 245112, -3720, 0, 0, 61401, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -82045, 239424, -3688, 0, 0, 53735, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -86666, 237396, -3696, 0, 0, 54603, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -87718, 238995, -3608, 0, 0, 8594, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -95034, 234451, -3688, 0, 0, 15432, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -97475, 231246, -3608, 0, 0, 14380, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -87346, 254668, -3720, 0, 0, 25594, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -82901, 253704, -3728, 0, 0, 18004, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -94533, 257153, -3312, 0, 0, 33909, 60, 0, 0, 0),
("Talking_Island_Npc", 1, 31032, -96710, 257075, -3520, 0, 0, 37435, 60, 0, 0, 0),
-- Remy
("Talking_Island", 1, 31356, -81920, 243892, -3714, 0, 0, 7000, 60, 0, 0, 0),
-- Leandro
("Talking_Island", 1, 31357, -82428, 245203, -3712, 0, 0, 0, 60, 0, 0, 0),
-- Antonio
("Talking_Island_Npc", 1, 31413, -85312, 244752, -3725, 0, 0, 8000, 60, 0, 0, 0),
-- Klufe
("Talking_Island_Npc", 1, 31562, -83904, 240576, -3712, 0, 0, 25000, 60, 0, 0, 0),
-- Grand Olympiad Manager
("Talking_Island_Npc", 1, 31688, -85151, 241476, -3728, 0, 0, 25000, 60, 0, 0, 0),
-- Monument of Heroes 
("Talking_Island_Npc", 1, 31690, -85096, 241516, -3728, 0, 0, 25000, 60, 0, 0, 0),
-- Adventure Guildsman
("Talking_Island_Npc", 1, 31775, -83472, 242896, -3730, 0, 0, 39000, 60, 0, 0, 0),
-- Adventure Guildsman
("Talking_Island_Npc", 1, 31776, -86080, 241488, -3730, 0, 0, 57000, 60, 0, 0, 0),
-- Dimensional Merchant
("Talking_Island_Npc", 1, 32478, -81920, 243360, -3728, 0, 0, 40000, 60, 0, 0, 0),
-- Manor Manager
("Talking_Island_Npc", 1, 35103, -83536, 243280, -3728, 0, 0, 24400, 60, 0, 0, 0),

-- [18_10]

-- Catacomb Scavenger Bat
("HereticsCatacomb", 1, 21143, -47124, -245873, -7903, 0, 0, 41625, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -46985, -250288, -7903, 0, 0, 6408, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -46962, -248760, -7905, 0, 0, 54566, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -46727, -248990, -7905, 0, 0, 63881, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -45345, -250164, -7905, 0, 0, 33310, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -44854, -247827, -7905, 0, 0, 17313, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -44803, -247025, -7905, 0, 0, 48044, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -44492, -250381, -7905, 0, 0, 19162, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -44292, -247419, -7935, 0, 0, 62622, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -43644, -249747, -7905, 0, 0, 52861, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -43413, -250176, -7903, 0, 0, 1723, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -42961, -247469, -7903, 0, 0, 33409, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -42578, -247726, -7905, 0, 0, 14768, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -42541, -245463, -7903, 0, 0, 15847, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21143, -42324, -250266, -7903, 0, 0, 29481, 120, 0, 0, 0),
-- Catacomb Shadow
("HereticsCatacomb", 1, 21144, -47422, -250271, -7903, 0, 0, 33115, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -47239, -249049, -7905, 0, 0, 47254, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -47147, -245414, -7903, 0, 0, 16953, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -46314, -248768, -7903, 0, 0, 3385, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -45182, -250409, -7905, 0, 0, 23750, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -44986, -247222, -7905, 0, 0, 26360, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -44781, -246458, -7905, 0, 0, 14379, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -44713, -250116, -7905, 0, 0, 4093, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -44368, -247669, -7905, 0, 0, 479, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -43477, -250450, -7903, 0, 0, 5960, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -43371, -249418, -7905, 0, 0, 16384, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -43180, -247705, -7905, 0, 0, 48872, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -42712, -250273, -7903, 0, 0, 33989, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -42547, -245924, -7903, 0, 0, 50948, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21144, -42412, -247395, -7905, 0, 0, 10251, 120, 0, 0, 0),
-- Catacomb Stakato Soldier
("HereticsCatacomb", 1, 21145, -47360, -244576, -7903, 0, 0, 33065, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -47229, -242766, -7903, 0, 0, 43146, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -47151, -240197, -7903, 0, 0, 49014, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -46940, -241947, -7905, 0, 0, 57530, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -45625, -239841, -7905, 0, 0, 59652, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -45263, -244779, -7935, 0, 0, 65095, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -45131, -240094, -7905, 0, 0, 48284, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -45019, -242963, -7905, 0, 0, 25920, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -44713, -244400, -7905, 0, 0, 20306, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -44562, -243515, -7903, 0, 0, 46656, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -44392, -242458, -7905, 0, 0, 60, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -43631, -240181, -7903, 0, 0, 49152, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -42734, -242081, -7905, 0, 0, 19468, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -42544, -240118, -7903, 0, 0, 49889, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -42543, -244785, -7903, 0, 0, 47818, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21145, -42447, -242524, -7903, 0, 0, 48010, 120, 0, 0, 0),
-- Grave Keeper Dark Horror
("HereticsCatacomb", 1, 21146, -47347, -242015, -7905, 0, 0, 6570, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -47129, -239799, -7903, 0, 0, 53120, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -47110, -242446, -7903, 0, 0, 46617, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -46987, -244567, -7903, 0, 0, 27015, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -45775, -240074, -7905, 0, 0, 58896, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -45467, -244408, -7905, 0, 0, 579, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -44833, -239747, -7905, 0, 0, 44955, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -44715, -241946, -7933, 0, 0, 19267, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -44477, -244756, -7905, 0, 0, 1955, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -44451, -243041, -7935, 0, 0, 55408, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -44270, -242341, -7935, 0, 0, 57344, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -43633, -239765, -7903, 0, 0, 49152, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -42633, -241466, -7903, 0, 0, 42905, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -42548, -239779, -7903, 0, 0, 49371, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -42540, -244405, -7933, 0, 0, 17757, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21146, -42508, -241870, -7903, 0, 0, 43560, 120, 0, 0, 0),
-- Lith Guard
("HereticsCatacomb", 1, 21169, -52644, -245662, -7903, 0, 0, 31533, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -52212, -247378, -7903, 0, 0, 58685, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -52172, -247098, -7905, 0, 0, 17853, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -51209, -249375, -7935, 0, 0, 17647, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -50920, -248826, -7903, 0, 0, 14375, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -50841, -246338, -7905, 0, 0, 51138, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -50840, -250255, -7905, 0, 0, 19046, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -50498, -246337, -7905, 0, 0, 1553, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -49785, -249292, -7905, 0, 0, 20700, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -49709, -250142, -7903, 0, 0, 12480, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -49619, -249763, -7903, 0, 0, 19091, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -48772, -246818, -7903, 0, 0, 31346, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -48556, -247069, -7905, 0, 0, 49070, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -48242, -245468, -7903, 0, 0, 13933, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21169, -48095, -250265, -7903, 0, 0, 3356, 120, 0, 0, 0),
-- Lith Medium
("HereticsCatacomb", 1, 21170, -52851, -240188, -7933, 0, 0, 48802, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -52646, -242859, -7905, 0, 0, 45796, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -52643, -244577, -7933, 0, 0, 2238, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -52300, -242715, -7903, 0, 0, 61061, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -52014, -240460, -7905, 0, 0, 48746, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -51719, -239970, -7905, 0, 0, 28030, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -51118, -242747, -7935, 0, 0, 38095, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -50976, -239967, -7903, 0, 0, 59989, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -50852, -242346, -7905, 0, 0, 41970, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -50775, -243149, -7905, 0, 0, 55856, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -49949, -240092, -7905, 0, 0, 3339, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -48985, -241270, -7935, 0, 0, 34172, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -48257, -241487, -7905, 0, 0, 22626, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -48248, -240148, -7903, 0, 0, 51033, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21170, -48229, -244403, -7903, 0, 0, 18641, 120, 0, 0, 0),
-- Lith Overlord
("HereticsCatacomb", 1, 21171, -47362, -248785, -7903, 0, 0, 44702, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -47348, -245685, -7903, 0, 0, 28931, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -47144, -250123, -7903, 0, 0, 18082, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -46306, -248958, -7903, 0, 0, 817, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -45433, -250386, -7903, 0, 0, 35891, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -44658, -246770, -7933, 0, 0, 16435, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -44647, -247336, -7903, 0, 0, 10845, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -44399, -250193, -7903, 0, 0, 30060, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -44285, -247764, -7905, 0, 0, 55452, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -43663, -250206, -7905, 0, 0, 56978, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -43378, -249818, -7905, 0, 0, 14087, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -43340, -247472, -7903, 0, 0, 34010, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -42542, -250033, -7933, 0, 0, 18366, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -42434, -247553, -7903, 0, 0, 41059, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21171, -42318, -245666, -7903, 0, 0, 33042, 120, 0, 0, 0),
-- Lith Patrolman
("HereticsCatacomb", 1, 21172, -47325, -242393, -7905, 0, 0, 11315, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -47175, -244728, -7903, 0, 0, 49992, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -46988, -239965, -7933, 0, 0, 32302, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -46980, -242203, -7905, 0, 0, 2613, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -45509, -244618, -7903, 0, 0, 5458, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -45379, -240082, -7905, 0, 0, 46659, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -45240, -239753, -7905, 0, 0, 48069, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -44991, -242710, -7905, 0, 0, 23586, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -44679, -242929, -7905, 0, 0, 58704, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -44606, -242301, -7903, 0, 0, 15979, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -44505, -244470, -7905, 0, 0, 62163, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -43837, -239964, -7903, 0, 0, 64668, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -42738, -239963, -7903, 0, 0, 64110, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -42729, -241753, -7905, 0, 0, 24416, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -42657, -242517, -7905, 0, 0, 47012, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21172, -42355, -244575, -7903, 0, 0, 29212, 120, 0, 0, 0),
-- Gigant Footman
("HereticsCatacomb", 1, 21190, -52851, -245845, -7933, 0, 0, 51419, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -52570, -247371, -7905, 0, 0, 147, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -51887, -247084, -7905, 0, 0, 24164, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -51136, -249757, -7903, 0, 0, 21039, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -51118, -248929, -7903, 0, 0, 16911, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -50884, -249753, -7905, 0, 0, 37722, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -50864, -246058, -7935, 0, 0, 44251, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -50543, -246541, -7905, 0, 0, 2672, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -49861, -249551, -7905, 0, 0, 52833, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -49792, -249103, -7905, 0, 0, 14636, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -49412, -249595, -7905, 0, 0, 5489, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -49044, -247003, -7903, 0, 0, 33166, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -48454, -245683, -7903, 0, 0, 27342, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -48306, -246829, -7903, 0, 0, 37672, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21190, -48237, -250475, -7903, 0, 0, 12299, 120, 0, 0, 0),
-- Gigant Cleric
("HereticsCatacomb", 1, 21191, -53019, -239982, -7903, 0, 0, 63953, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -52858, -244747, -7933, 0, 0, 51782, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -52495, -242498, -7905, 0, 0, 5531, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -52019, -242824, -7905, 0, 0, 61284, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -51998, -240069, -7905, 0, 0, 34302, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -51716, -240379, -7905, 0, 0, 22233, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -50909, -243839, -7905, 0, 0, 51338, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -50637, -239816, -7905, 0, 0, 42923, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -50601, -242293, -7905, 0, 0, 42576, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -50373, -243300, -7935, 0, 0, 1282, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -50205, -240156, -7905, 0, 0, 12292, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -48665, -241548, -7935, 0, 0, 53089, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -48535, -241219, -7905, 0, 0, 33311, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -48395, -239962, -7903, 0, 0, 31968, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21191, -48087, -244585, -7933, 0, 0, 2136, 120, 0, 0, 0),
-- Gigant Officer
("HereticsCatacomb", 1, 21192, -47139, -250477, -7903, 0, 0, 13359, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -47041, -249035, -7905, 0, 0, 48788, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -46941, -245665, -7933, 0, 0, 60738, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -46639, -248757, -7905, 0, 0, 40960, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -45028, -246946, -7905, 0, 0, 39405, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -44906, -250407, -7905, 0, 0, 13530, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -44898, -250110, -7905, 0, 0, 17410, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -44708, -247302, -7903, 0, 0, 56813, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -44532, -246410, -7905, 0, 0, 9302, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -43597, -249364, -7933, 0, 0, 21620, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -43312, -250376, -7935, 0, 0, 4398, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -42967, -247704, -7905, 0, 0, 54415, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -42769, -245683, -7933, 0, 0, 26548, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -42647, -247411, -7905, 0, 0, 17179, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21192, -42548, -250490, -7903, 0, 0, 15984, 120, 0, 0, 0),
-- Gigant Raider
("HereticsCatacomb", 1, 21193, -47294, -239956, -7903, 0, 0, 34240, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -47202, -241723, -7903, 0, 0, 53120, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -47138, -244396, -7903, 0, 0, 17977, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -47049, -242762, -7935, 0, 0, 51130, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -45830, -239748, -7905, 0, 0, 62075, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44890, -239986, -7903, 0, 0, 35256, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44885, -244738, -7905, 0, 0, 25030, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44818, -244444, -7935, 0, 0, 1723, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44690, -242593, -7933, 0, 0, 38417, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44648, -243258, -7933, 0, 0, 41549, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -44503, -241934, -7905, 0, 0, 9723, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -43458, -239973, -7903, 0, 0, 35782, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -42685, -244570, -7903, 0, 0, 34136, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -42404, -242162, -7905, 0, 0, 53005, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -42378, -241638, -7905, 0, 0, 53481, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21193, -42350, -239959, -7903, 0, 0, 37951, 120, 0, 0, 0),
-- Barrow Sentinel
("HereticsCatacomb", 1, 21236, -53051, -245666, -7903, 0, 0, 61958, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -52728, -247261, -7903, 0, 0, 57730, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -51717, -247268, -7903, 0, 0, 29991, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -51323, -249263, -7905, 0, 0, 29764, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -51051, -250022, -7905, 0, 0, 12397, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -50915, -249488, -7905, 0, 0, 47503, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -50733, -245800, -7903, 0, 0, 41538, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -50653, -246786, -7903, 0, 0, 50861, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -49775, -248775, -7903, 0, 0, 18468, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -49768, -249936, -7903, 0, 0, 22632, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -49671, -249334, -7905, 0, 0, 27445, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -48780, -247058, -7905, 0, 0, 52337, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -48413, -250272, -7933, 0, 0, 1781, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -48239, -245851, -7903, 0, 0, 16655, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21236, -47981, -246787, -7905, 0, 0, 19848, 120, 0, 0, 0),
-- Barrow Monk
("HereticsCatacomb", 1, 21237, -52843, -245438, -7903, 0, 0, 16955, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -52470, -247099, -7905, 0, 0, 47381, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -51962, -247397, -7905, 0, 0, 47690, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -51338, -249509, -7905, 0, 0, 35178, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -51144, -250255, -7905, 0, 0, 19436, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -50902, -249194, -7905, 0, 0, 46135, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -50875, -246803, -7935, 0, 0, 47913, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -50509, -245981, -7905, 0, 0, 40205, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -49558, -248778, -7905, 0, 0, 14994, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -49551, -250223, -7905, 0, 0, 16275, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -49337, -249268, -7905, 0, 0, 60126, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -49056, -246805, -7905, 0, 0, 31941, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -48240, -250075, -7903, 0, 0, 17128, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -48160, -247079, -7905, 0, 0, 28015, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21237, -47999, -245671, -7903, 0, 0, 65229, 120, 0, 0, 0),
-- Grave Sentinel
("HereticsCatacomb", 1, 21238, -52918, -242867, -7905, 0, 0, 43301, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -52849, -244356, -7903, 0, 0, 16529, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -52642, -239969, -7903, 0, 0, 64890, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -52258, -242521, -7905, 0, 0, 15306, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -52034, -240816, -7905, 0, 0, 49358, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -51871, -239788, -7903, 0, 0, 35497, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -51098, -242590, -7905, 0, 0, 29690, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -50720, -243572, -7903, 0, 0, 44951, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -50684, -240105, -7905, 0, 0, 48627, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -50417, -242993, -7905, 0, 0, 59731, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -49931, -239879, -7933, 0, 0, 2165, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -49142, -241465, -7903, 0, 0, 36091, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -48462, -244583, -7903, 0, 0, 34686, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -48148, -241186, -7935, 0, 0, 13473, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21238, -47992, -239969, -7933, 0, 0, 290, 120, 0, 0, 0),
-- Grave Monk
("HereticsCatacomb", 1, 21239, -53045, -244575, -7903, 0, 0, 1481, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -52927, -242626, -7903, 0, 0, 1769, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -52848, -239776, -7903, 0, 0, 43474, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -52042, -239856, -7935, 0, 0, 37041, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -51899, -242592, -7935, 0, 0, 63352, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -51799, -240859, -7903, 0, 0, 50831, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -50780, -242673, -7903, 0, 0, 52233, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -50775, -243373, -7903, 0, 0, 10902, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -50626, -243854, -7935, 0, 0, 52649, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -50499, -240123, -7905, 0, 0, 51536, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -50197, -239791, -7905, 0, 0, 44655, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -48924, -241537, -7905, 0, 0, 59947, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -48305, -241180, -7905, 0, 0, 18732, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -48252, -244750, -7903, 0, 0, 54265, 120, 0, 0, 0),
("HereticsCatacomb", 1, 21239, -48249, -239779, -7903, 0, 0, 44209, 120, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq06_npc2122_01", 1, 31120, -52832, -250272, -7905, 0, 0, 16500, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq06_npc2122_03", 1, 31495, -53067, -250565, -7907, 0, 0, 16000, 60, 0, 0, 0),

-- [18_14]

-- Worshipper
("unset", 1, 4327, -45559, -118327, -208, 0, 0, 64163, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, -45482, -118196, -208, 0, 0, 38012, 0, 0, 0, 0),
("unset", 1, 4328, -45460, -118477, -208, 0, 0, 55285, 0, 0, 0, 0),
-- Gremlin
("Orc_Village", 1, 18342, -56331, -113710, -672, 0, 0, 0, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56510, -113570, -672, 0, 0, 19739, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56170, -113897, -672, 0, 0, 62823, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56412, -113395, -672, 0, 0, 6867, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56152, -113896, -672, 0, 0, 2612, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56627, -113559, -672, 0, 0, 6001, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56120, -113471, -672, 0, 0, 55746, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56098, -113524, -672, 0, 0, 45495, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56354, -113405, -672, 0, 0, 16067, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56349, -113506, -672, 0, 0, 31930, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -55890, -113493, -672, 0, 0, 14970, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56036, -113582, -672, 0, 0, 18995, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56298, -113816, -672, 0, 0, 56784, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -55861, -113506, -672, 0, 0, 24659, 15, 0, 0, 0),
("Orc_Village", 1, 18342, -56276, -113462, -672, 0, 0, 6469, 15, 0, 0, 0),
-- Rakeclaw Imp
("Orc_Village", 1, 20311, -42016, -102497, -2728, 0, 0, 19017, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -40128, -103244, -2800, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -39784, -103742, -2784, 0, 0, 10752, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37900, -108958, -1816, 0, 0, 49073, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37299, -109324, -1776, 0, 0, 57659, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -38682, -108343, -1840, 0, 0, 57241, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -35608, -110336, -2096, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37007, -112192, -1792, 0, 0, 56450, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -40368, -113086, -2016, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37446, -113752, -1944, 0, 0, 60092, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37382, -113648, -1936, 0, 0, 48042, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -38316, -116754, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -36676, -116754, -1648, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -39403, -120742, -1704, 0, 0, 63529, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -39090, -119654, -1776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37004, -119328, -1728, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -38480, -119094, -1688, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -37501, -119852, -1664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -38863, -120050, -1712, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -42142, -117976, -1920, 0, 0, 28055, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -42436, -117928, -1920, 0, 0, 16699, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -42217, -118174, -1920, 0, 0, 62006, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -41978, -117627, -1920, 0, 0, 53989, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -41357, -110856, -1816, 0, 0, 54829, 20, 0, 0, 0),
("Orc_Village", 1, 20311, -41280, -111098, -1832, 0, 0, 23158, 20, 0, 0, 0),
-- Rakeclaw Imp Hunter
("Orc_Village", 1, 20312, -41184, -102321, -2712, 0, 0, 46039, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -41928, -104056, -2768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -41686, -103617, -2784, 0, 0, 63478, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -40185, -109045, -1776, 0, 0, 52279, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -39698, -109599, -1816, 0, 0, 29108, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -38194, -104735, -2840, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -38384, -102803, -3528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -36877, -102779, -2912, 0, 0, 5365, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -36142, -102666, -2800, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -41620, -101870, -2712, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -40717, -102214, -2736, 0, 0, 1099, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -36877, -101988, -3000, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -37624, -102320, -3352, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -38104, -112652, -1840, 0, 0, 61230, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -37863, -113018, -1856, 0, 0, 40737, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -40919, -117378, -1920, 0, 0, 59945, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -37576, -117704, -1672, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -37672, -117436, -1664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -40829, -117309, -1920, 0, 0, 2542, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -40995, -118016, -1920, 0, 0, 55176, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -38831, -121342, -1680, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -38831, -121108, -1680, 0, 0, 27587, 20, 0, 0, 0),
-- Goblin Grave Robber
("Orc_Village", 1, 20319, -43351, -107890, -1560, 0, 0, 23569, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -42478, -108605, -1736, 0, 0, 45439, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40626, -105037, -2776, 0, 0, 44637, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -39699, -108171, -1888, 0, 0, 39769, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -39028, -105775, -2576, 0, 0, 57849, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -41607, -110159, -1832, 0, 0, 12766, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -42888, -109272, -1752, 0, 0, 5838, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40793, -110543, -1896, 0, 0, 64112, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37183, -108168, -1944, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40850, -110699, -1896, 0, 0, 54165, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40384, -112413, -1912, 0, 0, 17446, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -38366, -110835, -1824, 0, 0, 14602, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37859, -112090, -1816, 0, 0, 13943, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -36288, -111336, -1840, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -36645, -110897, -1768, 0, 0, 34534, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40253, -115587, -1888, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40054, -116514, -1904, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -39656, -116205, -1832, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37988, -118158, -1696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -36676, -118392, -1792, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37496, -119562, -1672, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40613, -120104, -1872, 0, 0, 45607, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37274, -120644, -1672, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -38182, -119654, -1688, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -37728, -119852, -1648, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40272, -123156, -480, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -39000, -124076, -576, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -40590, -122926, -424, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20319, -36593, -122624, -1664, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Wolf
("Orc_Village", 1, 20475, -48318, -107541, -456, 0, 0, 52802, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -46159, -107287, -592, 0, 0, 15793, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -45680, -107257, -560, 0, 0, 39699, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -47870, -118214, -240, 0, 0, 5970, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -43351, -109174, -1744, 0, 0, 17267, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -43118, -107618, -1568, 0, 0, 42799, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -40155, -105065, -2776, 0, 0, 57415, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -42580, -109756, -1752, 0, 0, 11982, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -40828, -109360, -1824, 0, 0, 46758, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -39235, -109625, -1792, 0, 0, 57297, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -38567, -108996, -1784, 0, 0, 7915, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -38365, -108656, -1840, 0, 0, 18494, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -37251, -108492, -1880, 0, 0, 41098, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -40861, -115619, -1896, 0, 0, 63362, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -39059, -117441, -1784, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -40054, -117441, -1896, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -39184, -120413, -1712, 0, 0, 64746, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -38182, -119654, -1688, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -37501, -121436, -1688, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -39615, -123824, -544, 0, 0, 55231, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -40173, -123634, -536, 0, 0, 48855, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -39897, -123782, -544, 0, 0, 26194, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -45031, -118320, -240, 0, 0, 29537, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -47172, -119733, -240, 0, 0, 17863, 20, 0, 0, 0),
("Orc_Village", 1, 20475, -46959, -120220, -184, 0, 0, 5703, 20, 0, 0, 0),
-- Kasha Timber Wolf
("Orc_Village", 1, 20477, -41371, -103398, -2784, 0, 0, 13400, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -40928, -103853, -2816, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -40707, -101702, -2720, 0, 0, 61054, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -36628, -109586, -1832, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -39688, -112586, -1912, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -35948, -111836, -1928, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -35608, -111836, -1976, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -36143, -112891, -1864, 0, 0, 9714, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -37004, -116520, -1632, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -37004, -117456, -1672, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -38152, -118392, -1696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20477, -38808, -116754, -1784, 0, 0, 0, 20, 0, 0, 0),
-- Young Prairie Keltir
("Orc_Village", 1, 20531, -50634, -116189, -224, 0, 0, 3323, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -50513, -111927, -240, 0, 0, 53160, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -47918, -114077, -216, 0, 0, 64517, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -48690, -112753, -240, 0, 0, 53294, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -48141, -108987, -272, 0, 0, 6588, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -48032, -108984, -272, 0, 0, 34322, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -49437, -108496, -280, 0, 0, 64307, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -49744, -108298, -272, 0, 0, 24065, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -48755, -116753, -160, 0, 0, 48946, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -48025, -116775, -224, 0, 0, 53160, 20, 0, 0, 0),
("Orc_Village", 1, 20531, -49952, -116863, -176, 0, 0, 35928, 20, 0, 0, 0),
-- Prairie Keltir
("Orc_Village", 1, 20535, -51350, -112249, -192, 0, 0, 3098, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -50648, -114781, -176, 0, 0, 55948, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -50383, -115232, -176, 0, 0, 59594, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49139, -116767, -160, 0, 0, 44317, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49900, -115757, -160, 0, 0, 49985, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -50994, -115732, -216, 0, 0, 31316, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -50691, -111548, -240, 0, 0, 52113, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -50282, -110900, -240, 0, 0, 1221, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -51197, -110723, -240, 0, 0, 34645, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49179, -111225, -240, 0, 0, 35072, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49329, -110000, -240, 0, 0, 51374, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -51088, -109720, -240, 0, 0, 39980, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49166, -110081, -240, 0, 0, 62717, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49932, -109036, -248, 0, 0, 58078, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49412, -108587, -272, 0, 0, 51456, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -47845, -113971, -240, 0, 0, 32767, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -48771, -109243, -248, 0, 0, 4472, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -48453, -115643, -160, 0, 0, 15972, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49027, -116361, -160, 0, 0, 11959, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -48318, -116406, -160, 0, 0, 63478, 20, 0, 0, 0),
("Orc_Village", 1, 20535, -49332, -116146, -160, 0, 0, 51674, 20, 0, 0, 0),
-- Elder Prairie Keltir
("Orc_Village", 1, 20538, -49339, -115212, -160, 0, 0, 50295, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -50951, -114876, -176, 0, 0, 29807, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -50159, -112204, -240, 0, 0, 2409, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -49829, -111014, -240, 0, 0, 20850, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -50283, -110906, -240, 0, 0, 26405, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -49752, -109897, -240, 0, 0, 57272, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -48545, -114417, -160, 0, 0, 54825, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -48443, -111639, -240, 0, 0, 32350, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -48615, -109267, -248, 0, 0, 27148, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -48239, -109293, -248, 0, 0, 55429, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -50197, -108663, -248, 0, 0, 52312, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -46375, -107460, -536, 0, 0, 29978, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -45671, -108810, -272, 0, 0, 51809, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -45251, -107404, -488, 0, 0, 60884, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -49259, -115072, -160, 0, 0, 25600, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -48651, -115302, -160, 0, 0, 31096, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -47905, -116567, -192, 0, 0, 6057, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -45227, -119021, -240, 0, 0, 47482, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -45032, -118246, -240, 0, 0, 1453, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -46811, -120308, -208, 0, 0, 32142, 20, 0, 0, 0),
("Orc_Village", 1, 20538, -44757, -120625, -232, 0, 0, 1205, 20, 0, 0, 0),
-- Jakal
("Orc_Village_Npc", 1, 30558, -44416, -111486, -216, 0, 0, 57600, 60, 0, 0, 0),
-- Kunai
("Orc_Village_Npc", 1, 30559, -43905, -111824, -216, 0, 0, 28672, 60, 0, 0, 0),
-- Uska
("Orc_Village_Npc", 1, 30560, -43910, -115518, -194, 0, 0, 39000, 60, 0, 0, 0),
-- Papuma
("Orc_Village_Npc", 1, 30561, -43950, -115457, -194, 0, 0, 39000, 60, 0, 0, 0),
-- Grookin
("Orc_Village_Npc", 1, 30562, -43109, -113770, -216, 0, 0, 24576, 60, 0, 0, 0),
-- Imantu
("Orc_Village_Npc", 1, 30563, -43114, -113404, -216, 0, 0, 38000, 60, 0, 0, 0),
-- Sumari
("Orc_Village_Npc", 1, 30564, -43264, -112532, -216, 0, 0, 32768, 60, 0, 0, 0),
-- Kakai
("Orc_Village_Npc", 1, 30565, -46768, -113610, -3, 0, 0, 0, 60, 0, 0, 0),
-- Varkees
("Orc_Village_Npc", 1, 30566, -46802, -114011, -112, 0, 0, 0, 60, 0, 0, 0),
-- Tantus
("Orc_Village_Npc", 1, 30567, -46247, -113866, -16, 0, 0, 16384, 60, 0, 0, 0),
-- Hatos
("Orc_Village_Npc", 1, 30568, -46808, -113184, -112, 0, 0, 0, 60, 0, 0, 0),
-- Brukurse
("Orc_Village_Npc", 1, 30569, -45952, -114784, -200, 0, 0, 32768, 60, 0, 0, 0);
INSERT INTO `spawnlist` VALUES
-- Karukia
("Orc_Village_Npc", 1, 30570, -45952, -114496, -200, 0, 0, 32768, 60, 0, 0, 0),
-- Tanapi
("Orc_Village_Npc", 1, 30571, -45863, -112621, -200, 0, 0, 32768, 60, 0, 0, 0),
-- Livina
("Orc_Village_Npc", 1, 30572, -45864, -112540, -200, 0, 0, 32768, 60, 0, 0, 0),
-- Vulkus
("Orc_Village_Npc", 1, 30573, -56736, -113536, -672, 0, 0, 0, 60, 0, 0, 0),
-- Newbie Helper
("Orc_Village_Npc", 1, 30575, -56736, -113680, -672, 0, 0, 0, 60, 0, 0, 0),
-- Teleport Device
("Orc_Village_Npc", 1, 30576, -45264, -112512, -240, 0, 0, 0, 60, 0, 0, 0),
-- Rukain
("Orc_Village_Npc", 1, 30577, -46576, -117311, -240, 0, 0, 49152, 60, 0, 0, 0),
-- Nakusin
("Orc_Village_Npc", 1, 30578, -47360, -113791, -224, 0, 0, 32768, 60, 0, 0, 0),
-- Tamai
("Orc_Village_Npc", 1, 30579, -47360, -113424, -224, 0, 0, 32768, 60, 0, 0, 0),
-- Parugon
("Orc_Village_Npc", 1, 30580, -45744, -117165, -240, 0, 0, 49152, 60, 0, 0, 0),
-- Orinak
("Orc_Village_Npc", 1, 30581, -46528, -109968, -248, 0, 0, 16384, 60, 0, 0, 0),
-- Tiku
("Orc_Village_Npc", 1, 30582, -45808, -110055, -256, 0, 0, 16384, 60, 0, 0, 0),
-- Petukai
("Orc_Village_Npc", 1, 30583, -45731, -113844, -240, 0, 0, 0, 60, 0, 0, 0),
-- Vapook
("Orc_Village_Npc", 1, 30584, -45728, -113360, -240, 0, 0, 0, 60, 0, 0, 0),
-- Tataru Zu Hestui
("Orc_Village_Npc", 1, 30585, -45328, -114736, -240, 0, 0, 0, 60, 0, 0, 0),
-- Gantaki Zu Urutu
("Orc_Village_Npc", 1, 30587, -44624, -111873, -240, 0, 0, 40960, 60, 0, 0, 0),
-- Hestui Totem Spirit
("Orc_Village_Npc", 1, 30592, -49542, -109564, -240, 0, 0, 51000, 60, 0, 0, 0),
-- Newbie Helper
("Orc_Village_Npc", 1, 30602, -45032, -113598, -192, 0, 0, 32768, 60, 0, 0, 0),
-- Lottery Ticket Seller
("Orc_Village_Npc", 1, 30994, -45266, -112468, -240, 0, 0, 500, 60, 0, 0, 0),
-- Broadcasting Tower
("Orc_Village_Npc", 1, 31031, -44032, -114000, -236, 0, 0, 16384, 5, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, -39610, -104724, -2744, 0, 0, 16857, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -35567, -107319, -2136, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -38816, -120209, -1696, 0, 0, 58825, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -37400, -119399, -1672, 0, 0, 18664, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -41358, -122663, -336, 0, 0, 52108, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -33192, -107319, -2064, 0, 0, 12938, 60, 0, 0, 0),
-- Rokar
("Orc_Village", 1, 31364, -46512, -117696, -252, 0, 0, 0, 60, 0, 0, 0),
-- Yakand
("Orc_Village", 1, 31365, -48820, -113748, -233, 0, 0, 0, 60, 0, 0, 0),
-- Shantra
("Orc_Village_Npc", 1, 31424, -46397, -112935, -229, 0, 0, 16000, 60, 0, 0, 0),
-- Ogord
("Orc_Village_Npc", 1, 31565, -44112, -115824, -220, 0, 0, 23000, 60, 0, 0, 0),
-- Grand Olympiad Manager
("Orc_Village_Npc", 1, 31688, -45360, -114640, -240, 0, 0, 0, 60, 0, 0, 0),
-- Monument of Heroes
("Orc_Village_Npc", 1, 31771, -45360, -114688, -240, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("Orc_Village_Npc", 1, 31784, -44976, -113696, -199, 0, 0, 33000, 60, 0, 0, 0),
-- Adventure Guildsman
("Orc_Village_Npc", 1, 31785, -45840, -116688, -240, 0, 0, 33000, 60, 0, 0, 0),
-- Adventure Guildsman
("Orc_Village_Npc", 1, 31786, -45616, -110320, -240, 0, 0, 49000, 60, 0, 0, 0),
-- Dimensional Merchant
("Orc_Village_Npc", 1, 32478, -43728, -113472, -240, 0, 0, 33000, 60, 0, 0, 0),
-- Manor Manager
("Orc_Village_Npc", 1, 35645, -44172, -112236, -240, 0, 0, 40000, 60, 0, 0, 0),

-- [18_16]

-- Photo Snow
("FantasyIsle", 1, 4317, -57388, -54785, -2008, 0, 0, 55472, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4318, -58015, -53375, -2008, 0, 0, 43828, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4319, -55347, -56519, -2008, 0, 0, 39053, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4320, -55560, -58525, -2008, 0, 0, 16384, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4321, -59110, -59139, -2024, 0, 0, 16384, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4322, -61822, -59510, -2016, 0, 0, 0, 60, 0, 0, 0),
-- Photo Snow
("FantasyIsle", 1, 4323, -61155, -57755, -2008, 0, 0, 0, 60, 0, 0, 0),
-- Fantasy Isle Paddies
("FantasyIsle", 1, 32378, -59234, -56897, -2032, 0, 0, 0, 60, 0, 0, 0),
-- Fantasy Isle Warehouse
("FantasyIsle", 1, 4315, -59234, -56825, -2039, 0, 0, 65275, 60, 0, 0, 0),
-- Entrance Manager
("unset", 1, 32521, -57712, -61490, -2376, 0, 0, 16384, 60, 0, 0, 0),
-- Entrance Manager
("unset", 1, 32522, -57557, -61488, -2376, 0, 0, 16384, 60, 0, 0, 0),
-- Entrance Manager
("unset", 1, 32523, -57395, -61488, -2376, 0, 0, 16384, 60, 0, 0, 0),
-- Entrance Manager
("unset", 1, 32524, -57240, -61493, -2376, 0, 0, 16384, 60, 0, 0, 0),
-- Handy
("unset", 1, 32613, -57470, -60765, -2360, 0, 0, 16384, 60, 0, 0, 0),

-- [18_19]

-- Misery Skeleton
("Dark_Elf_Village", 1, 20022, -50408, 47896, -5400, 0, 0, 26214, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -50562, 47171, -5400, 0, 0, 48125, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -49359, 53023, -4888, 0, 0, 8079, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -49464, 52667, -4888, 0, 0, 59783, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -48681, 53154, -4888, 0, 0, 14583, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -48542, 53715, -4888, 0, 0, 65378, 100, 0, 0, 0),
("Dark_Elf_Village", 1, 20022, -49036, 53726, -4888, 0, 0, 60498, 100, 0, 0, 0),
-- Omen Beast
("Dark_Elf_Village", 1, 20031, -47349, 43011, -5400, 0, 0, 8042, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -50584, 44898, -5400, 0, 0, 48995, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -50832, 44533, -5400, 0, 0, 41183, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -49530, 43457, -5400, 0, 0, 16223, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -49943, 43838, -5400, 0, 0, 6963, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -47391, 43134, -5400, 0, 0, 59810, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -45264, 44160, -5400, 0, 0, 52443, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -45076, 43797, -5400, 0, 0, 7185, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -44450, 44486, -5400, 0, 0, 11074, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -44015, 44743, -5400, 0, 0, 11074, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -44006, 45532, -5400, 0, 0, 55634, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20031, -50853, 45399, -5400, 0, 0, 47094, 60, 0, 0, 0),
-- Prowler
("Dark_Elf_Village", 1, 20034, -43503, 62916, -3320, 0, 0, 55322, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -43546, 63009, -3320, 0, 0, 15930, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -43111, 63476, -3320, 0, 0, 54100, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -43431, 63184, -3320, 0, 0, 26056, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -44662, 63681, -3336, 0, 0, 35300, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -42207, 63218, -3312, 0, 0, 11136, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -40400, 63037, -3328, 0, 0, 17389, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -40513, 65324, -3328, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -40036, 64951, -3328, 0, 0, 43912, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -40767, 63543, -3328, 0, 0, 41637, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -39873, 64965, -3328, 0, 0, 27013, 20, 0, 0, 0),
-- Tainted Zombie
("Dark_Elf_Village", 1, 20041, -49735, 43457, -5400, 0, 0, 29157, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -49754, 43594, -5400, 0, 0, 57567, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -49572, 43929, -5400, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -50135, 43953, -5400, 0, 0, 4835, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -45192, 44029, -5400, 0, 0, 58793, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -45488, 43454, -5400, 0, 0, 11404, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -45503, 43245, -5400, 0, 0, 832, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -45798, 43491, -5400, 0, 0, 26693, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -44187, 45837, -5400, 0, 0, 34859, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -44366, 45486, -5400, 0, 0, 48528, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -50777, 45264, -5400, 0, 0, 18473, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20041, -50633, 45215, -5400, 0, 0, 51518, 60, 0, 0, 0),
-- Stink Zombie
("Dark_Elf_Village", 1, 20046, -47682, 43292, -5400, 0, 0, 41297, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -47250, 43940, -5400, 0, 0, 46394, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -47072, 43982, -5400, 0, 0, 45301, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -47230, 43197, -5400, 0, 0, 21219, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -45333, 43272, -5400, 0, 0, 61259, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -45446, 45966, -5400, 0, 0, 52895, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -45805, 45600, -5400, 0, 0, 4554, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -45087, 45707, -5400, 0, 0, 18132, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -45091, 45701, -5400, 0, 0, 51670, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -49345, 46012, -5400, 0, 0, 53499, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -49339, 45338, -5400, 0, 0, 3852, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -49368, 45532, -5400, 0, 0, 45947, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20046, -49581, 45076, -5400, 0, 0, 12892, 60, 0, 0, 0),
-- Lesser Succubus
("Dark_Elf_Village", 1, 20048, -49872, 44748, -5400, 0, 0, 45448, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -47406, 42934, -5400, 0, 0, 17572, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -47410, 43891, -5400, 0, 0, 40738, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -45794, 45524, -5400, 0, 0, 39724, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -45061, 45509, -5400, 0, 0, 60102, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -45890, 45282, -5400, 0, 0, 60102, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -47978, 44910, -5400, 0, 0, 58351, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -48186, 46020, -5400, 0, 0, 36992, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -47466, 45441, -5400, 0, 0, 8079, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -49335, 45824, -5400, 0, 0, 14323, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -49180, 45324, -5400, 0, 0, 61932, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20048, -49267, 46000, -5400, 0, 0, 2027, 60, 0, 0, 0),
-- Lesser Succubus Turen
("Dark_Elf_Village", 1, 20052, -46817, 45186, -5400, 0, 0, 4041, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -48003, 44962, -5400, 0, 0, 53659, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -47851, 47169, -5912, 0, 0, 21621, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -47318, 47525, -5912, 0, 0, 13502, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -47557, 48535, -5720, 0, 0, 34557, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -47566, 49357, -5768, 0, 0, 19564, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20052, -47136, 49197, -5736, 0, 0, 25025, 60, 0, 0, 0),
-- Lesser Succubus Tilfo
("Dark_Elf_Village", 1, 20057, -47027, 47142, -5912, 0, 0, 28759, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47109, 50036, -5720, 0, 0, 41659, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47135, 50132, -5720, 0, 0, 15960, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -48102, 45762, -5400, 0, 0, 17706, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47867, 47195, -5912, 0, 0, 11618, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47302, 47214, -5912, 0, 0, 13377, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47452, 47162, -5912, 0, 0, 16898, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47603, 48344, -5656, 0, 0, 36337, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -47631, 50345, -5720, 0, 0, 17071, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20057, -48040, 50044, -5696, 0, 0, 33007, 60, 0, 0, 0),
-- Cave Spider
("Dark_Elf_Village", 1, 20348, -44350, 47577, -5400, 0, 0, 41203, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -44630, 49452, -5912, 0, 0, 18986, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -44416, 49866, -5912, 0, 0, 15590, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -44231, 49505, -5912, 0, 0, 29453, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -44551, 49919, -5912, 0, 0, 19377, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -50643, 47820, -5400, 0, 0, 20311, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -50551, 49242, -5912, 0, 0, 10128, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -50606, 48893, -5912, 0, 0, 56048, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -50355, 49590, -5912, 0, 0, 50438, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -50306, 49464, -5912, 0, 0, 43885, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -49284, 52448, -4888, 0, 0, 16812, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -45665, 52371, -4888, 0, 0, 39085, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20348, -45522, 52186, -4888, 0, 0, 48458, 60, 0, 0, 0),
-- Cave Bat
("Dark_Elf_Village", 1, 20349, -48976, 52524, -4888, 0, 0, 21857, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -50345, 53863, -4888, 0, 0, 48784, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -50404, 54033, -4888, 0, 0, 19689, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -45327, 53627, -4888, 0, 0, 17740, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -45535, 53656, -4888, 0, 0, 27221, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -44116, 53680, -4888, 0, 0, 3580, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20349, -43728, 53216, -4888, 0, 0, 48207, 60, 0, 0, 0),
-- Cave Fang Spider
("Dark_Elf_Village", 1, 20350, -49812, 43028, -5400, 0, 0, 56324, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -45147, 43512, -5400, 0, 0, 22810, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -44301, 44506, -5400, 0, 0, 54958, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -44309, 44677, -5400, 0, 0, 31974, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -43861, 45204, -5400, 0, 0, 25571, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -44353, 49281, -5912, 0, 0, 7819, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -44631, 49272, -5912, 0, 0, 9534, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -50393, 45464, -5400, 0, 0, 14856, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -50578, 45095, -5400, 0, 0, 59546, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -50731, 45118, -5400, 0, 0, 27324, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -50012, 49087, -5912, 0, 0, 13263, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20350, -50579, 49235, -5912, 0, 0, 28069, 60, 0, 0, 0),
-- Stone Soldier
("Dark_Elf_Village", 1, 20379, -40804, 58590, -3280, 0, 0, 53122, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -40441, 58930, -3304, 0, 0, 63746, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -39357, 58518, -3312, 0, 0, 4196, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -39700, 58734, -3312, 0, 0, 8385, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -37242, 55035, -3048, 0, 0, 59479, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -35781, 53711, -3240, 0, 0, 29608, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -36061, 53723, -3232, 0, 0, 20937, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -33689, 54728, -3408, 0, 0, 55892, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -33942, 56007, -3384, 0, 0, 45969, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -35951, 58936, -3368, 0, 0, 20533, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -36358, 61220, -3360, 0, 0, 26517, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -42315, 60392, -3304, 0, 0, 48878, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -41719, 60012, -3288, 0, 0, 28179, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -41379, 59550, -3288, 0, 0, 24575, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -41037, 59438, -3272, 0, 0, 14932, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -35873, 61583, -3376, 0, 0, 27274, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -35187, 64193, -3400, 0, 0, 306, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -35515, 64529, -3368, 0, 0, 30681, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -33637, 59712, -3416, 0, 0, 53071, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -33881, 64436, -3496, 0, 0, 5760, 16, 0, 0, 0),
-- Stone Guardian
("Dark_Elf_Village", 1, 20380, -44740, 63321, -3344, 0, 0, 16522, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -43606, 62267, -3280, 0, 0, 14830, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -43200, 62987, -3320, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -44397, 63440, -3336, 0, 0, 1756, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -43203, 64879, -3304, 0, 0, 48331, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -42645, 63840, -3312, 0, 0, 55087, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -40300, 64836, -3320, 0, 0, 15966, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -38933, 63015, -3328, 0, 0, 5566, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -39738, 65283, -3320, 0, 0, 26952, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -40158, 64946, -3328, 0, 0, 204, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -40215, 64309, -3328, 0, 0, 65262, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -36564, 63285, -3352, 0, 0, 19343, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -36284, 64485, -3344, 0, 0, 8481, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33323, 62593, -3488, 0, 0, 20533, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -34550, 64253, -3448, 0, 0, 9362, 20, 0, 0, 0),
-- Vaiss Orc
("Dark_Elf_Village", 1, 20381, -49462, 54706, -4888, 0, 0, 32024, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -47361, 54854, -4888, 0, 0, 35836, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -48612, 55014, -4888, 0, 0, 17127, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -48678, 56344, -4888, 0, 0, 13822, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -47463, 57535, -4376, 0, 0, 34301, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -47492, 57927, -4376, 0, 0, 11547, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -47689, 57275, -4376, 0, 0, 35768, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -46132, 55182, -4888, 0, 0, 42806, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20381, -46159, 54696, -4888, 0, 0, 56060, 60, 0, 0, 0),
-- Vaiss Orc Warrior Leader
("Dark_Elf_Village", 1, 20382, -48917, 54939, -4888, 0, 0, 44999, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -49077, 55089, -4888, 0, 0, 7651, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -48328, 55063, -4888, 0, 0, 55434, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -48844, 56674, -4888, 0, 0, 18664, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -48869, 56340, -4888, 0, 0, 13023, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -47484, 57856, -4376, 0, 0, 18193, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -46644, 57830, -4376, 0, 0, 64168, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -46244, 54410, -4888, 0, 0, 42041, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -45634, 54966, -4888, 0, 0, 7152, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20382, -47050, 54928, -4888, 0, 0, 16809, 60, 0, 0, 0),
-- Redeye Bat
("Dark_Elf_Village", 1, 20392, -39826, 57193, -3216, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -39188, 58987, -3312, 0, 0, 8272, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -39786, 57735, -3200, 0, 0, 24265, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -34193, 57554, -3400, 0, 0, 62867, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -34739, 57905, -3376, 0, 0, 46929, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -38930, 57925, -3336, 0, 0, 17706, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -40721, 60162, -3256, 0, 0, 7745, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -40700, 61044, -3256, 0, 0, 21326, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -36271, 61578, -3368, 0, 0, 28784, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -42490, 60905, -3304, 0, 0, 28622, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -42997, 60854, -3280, 0, 0, 54587, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -42258, 60032, -3304, 0, 0, 47032, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -40795, 62548, -3328, 0, 0, 50489, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -36359, 63660, -3368, 0, 0, 16066, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -35000, 65142, -3408, 0, 0, 18784, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -36555, 64386, -3336, 0, 0, 41584, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -35826, 64240, -3376, 0, 0, 26325, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -34245, 60588, -3416, 0, 0, 55286, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -33549, 59738, -3416, 0, 0, 43408, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -34865, 63235, -3416, 0, 0, 11171, 16, 0, 0, 0),
-- Festering Bat
("Dark_Elf_Village", 1, 20433, -37496, 54211, -3256, 0, 0, 18372, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -36836, 53525, -3248, 0, 0, 39404, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -37830, 54467, -3280, 0, 0, 41744, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -37320, 55206, -2968, 0, 0, 56231, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -36321, 53653, -3240, 0, 0, 40500, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -36389, 54160, -3296, 0, 0, 58351, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -34090, 54687, -3392, 0, 0, 24183, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -35181, 56710, -3360, 0, 0, 45269, 16, 0, 0, 0),
-- Doom Soldier
("Dark_Elf_Village", 1, 20455, -44471, 47917, -5400, 0, 0, 17071, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -44279, 47466, -5400, 0, 0, 46559, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -45301, 53581, -4888, 0, 0, 61831, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -45482, 53615, -4888, 0, 0, 35900, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -45898, 53007, -4888, 0, 0, 32410, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -45623, 52499, -4888, 0, 0, 28857, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -46345, 52876, -4888, 0, 0, 45096, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20455, -46018, 51979, -4888, 0, 0, 61437, 60, 0, 0, 0),
-- Skeleton Hunter
("Dark_Elf_Village", 1, 20517, -50699, 53087, -4888, 0, 0, 43414, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -50444, 53175, -4888, 0, 0, 39441, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -50764, 53644, -4888, 0, 0, 59250, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -50865, 53875, -4888, 0, 0, 62580, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -49501, 55345, -4888, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -49107, 55222, -4888, 0, 0, 6286, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -48922, 56275, -4888, 0, 0, 52962, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -46016, 54668, -4888, 0, 0, 30693, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -46962, 54575, -4888, 0, 0, 28710, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -46619, 54551, -4888, 0, 0, 3206, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -43701, 53389, -4888, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -43815, 53760, -4888, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -44487, 53638, -4888, 0, 0, 48129, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20517, -44141, 53763, -4888, 0, 0, 56117, 60, 0, 0, 0),
-- Skeleton Hunter Archer
("Dark_Elf_Village", 1, 20518, -50632, 53187, -4888, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20518, -48633, 53323, -4888, 0, 0, 44527, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20518, -48409, 56061, -4888, 0, 0, 33008, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20518, -46363, 54859, -4888, 0, 0, 6506, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20518, -46479, 52713, -4888, 0, 0, 22753, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 20518, -43872, 53230, -4888, 0, 0, 2111, 60, 0, 0, 0),
-- Merkenis
("Dark_Elf_Village", 1, 27022, -47938, 49195, -5720, 0, 0, 25025, 50, 0, 0, 0),
-- Calpico
("Dark_Elf_Village", 1, 27036, -50872, 40816, -3320, 0, 0, 47836, 480, 0, 0, 0),
-- Annika
("Dark_Elf_Village_Npc", 1, 30418, -46464, 59263, -3312, 0, 0, 20480, 60, 0, 0, 0),
-- Sentry
("Dark_Elf_Village_Npc", 1, 31034, -34955, 50590, -2656, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -36379, 45913, -1928, 0, 0, 52349, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -53975, 58336, -1768, 0, 0, 0, 60, 0, 0, 0),
-- Bloody Pixy
("Dark_Elf_Village_Npc", 1, 31845, -36309, 40197, -3304, 0, 0, 14752, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -42191, 45436, -3240, 0, 0, 15046, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -37360, 56348, -3120, 0, 0, 36150, 60, 0, 0, 0),
-- Blight Treant
("Dark_Elf_Village_Npc", 1, 31850, -42918, 39890, -3232, 0, 0, 60000, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -58806, 63064, -3328, 0, 0, 0, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -39795, 64627, -3320, 0, 0, 31966, 60, 0, 0, 0),

-- [18_20]

-- Red Bear
("gludio33_1821_01", 1, 20021, -65332, 97867, -3705, 0, 0, 48377, 25, 0, 0, 0),
-- Prowler
("Dark_Elf_Village", 1, 20034, -44499, 66980, -3376, 0, 0, 56627, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -44766, 67274, -3384, 0, 0, 28233, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -42823, 66561, -3368, 0, 0, 11826, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -41682, 66923, -3328, 0, 0, 24950, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -43063, 66614, -3368, 0, 0, 41738, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -41949, 67264, -3256, 0, 0, 19656, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -42300, 65725, -3344, 0, 0, 62201, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -41035, 66837, -3328, 0, 0, 28921, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -39049, 66271, -3328, 0, 0, 17402, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -37376, 67133, -3416, 0, 0, 32723, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -34339, 68471, -3408, 0, 0, 37692, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -33099, 68680, -3384, 0, 0, 50602, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -35209, 67100, -3496, 0, 0, 42648, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -35741, 67674, -3456, 0, 0, 12464, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -40868, 67759, -3304, 0, 0, 52455, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -41064, 68300, -3360, 0, 0, 37153, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -43165, 68320, -3336, 0, 0, 20692, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -55001, 71672, -3048, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -57830, 71199, -3120, 0, 0, 38760, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -60754, 68950, -3240, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -60559, 69854, -3216, 0, 0, 9188, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -60426, 70906, -3280, 0, 0, 45380, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -61673, 69772, -3296, 0, 0, 30300, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -59956, 70293, -3240, 0, 0, 39168, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -58326, 73082, -3176, 0, 0, 23738, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64998, 77269, -3312, 0, 0, 23545, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64372, 76990, -3280, 0, 0, 48458, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64722, 77488, -3304, 0, 0, 2975, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -65110, 76382, -3304, 0, 0, 8985, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64706, 79350, -3328, 0, 0, 52841, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -63392, 79425, -3352, 0, 0, 55030, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64071, 78677, -3320, 0, 0, 39910, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -62505, 78998, -3448, 0, 0, 26867, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -59285, 78656, -3488, 0, 0, 55122, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -59891, 78186, -3480, 0, 0, 60546, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -65040, 85124, -3624, 0, 0, 64793, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -64547, 85214, -3640, 0, 0, 47972, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -63416, 85566, -3624, 0, 0, 57628, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -63473, 84226, -3576, 0, 0, 10105, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -60665, 82259, -3512, 0, 0, 21499, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -61100, 82011, -3480, 0, 0, 9407, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -60619, 82230, -3512, 0, 0, 35911, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -63815, 82565, -3440, 0, 0, 4689, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -59199, 78337, -3480, 0, 0, 10628, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -58720, 73537, -3136, 0, 0, 53915, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -58619, 73859, -3144, 0, 0, 39323, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -58898, 74890, -3200, 0, 0, 682, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -59557, 74388, -3264, 0, 0, 15511, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -55331, 75754, -3056, 0, 0, 16845, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -56210, 75326, -3168, 0, 0, 17070, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -53947, 73519, -3128, 0, 0, 27369, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -54034, 72416, -3216, 0, 0, 3562, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -54277, 73513, -3088, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -54538, 75503, -3112, 0, 0, 33799, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -53922, 75197, -3136, 0, 0, 51177, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -51970, 74044, -3152, 0, 0, 23129, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -49654, 72486, -3360, 0, 0, 54470, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -49597, 74834, -3448, 0, 0, 10690, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -49586, 73686, -3392, 0, 0, 33565, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -48903, 73922, -3328, 0, 0, 30714, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -48259, 73868, -3320, 0, 0, 23367, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -48971, 75337, -3424, 0, 0, 24108, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -48736, 73453, -3136, 0, 0, 19522, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -50194, 77791, -3296, 0, 0, 14922, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -50595, 76992, -3296, 0, 0, 87, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -48992, 77308, -3296, 0, 0, 42599, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -51740, 79943, -3424, 0, 0, 7454, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20034, -49142, 77715, -3296, 0, 0, 40589, 20, 0, 0, 0),
-- Venomous Spider
("Dark_Elf_Village", 1, 20038, -52701, 71089, -3248, 0, 0, 5447, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -53937, 71432, -3208, 0, 0, 15116, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -58629, 70273, -3160, 0, 0, 9109, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -58672, 70762, -3136, 0, 0, 20391, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -58671, 71250, -3152, 0, 0, 36578, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -61576, 69192, -3352, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -61612, 71145, -3272, 0, 0, 37958, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -62262, 69871, -3312, 0, 0, 22714, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -63678, 72168, -3184, 0, 0, 35388, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60857, 73319, -3272, 0, 0, 65326, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -63512, 73427, -3320, 0, 0, 21030, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -64725, 72561, -3288, 0, 0, 5880, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -65242, 72632, -3336, 0, 0, 36025, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -63407, 73425, -3312, 0, 0, 53180, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -64692, 74780, -3280, 0, 0, 64201, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -64879, 74023, -3280, 0, 0, 36822, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60527, 76424, -3384, 0, 0, 23087, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -59376, 76578, -3352, 0, 0, 64669, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60878, 77954, -3456, 0, 0, 60013, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -59481, 77117, -3416, 0, 0, 56043, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -59282, 78860, -3496, 0, 0, 1826, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60187, 77857, -3464, 0, 0, 36992, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60613, 85018, -3592, 0, 0, 15906, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60027, 85474, -3632, 0, 0, 22088, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -59803, 85573, -3680, 0, 0, 48243, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -59737, 85359, -3672, 0, 0, 47361, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -60914, 82007, -3496, 0, 0, 12627, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -58913, 78259, -3472, 0, 0, 118, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -56548, 73190, -3112, 0, 0, 48679, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -55807, 75062, -3104, 0, 0, 21626, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -55293, 75719, -3056, 0, 0, 53848, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -53457, 71867, -3264, 0, 0, 61582, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -55294, 73695, -2896, 0, 0, 40961, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -55436, 73635, -2936, 0, 0, 37958, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -49983, 76180, -3312, 0, 0, 63710, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -50886, 77806, -3296, 0, 0, 10294, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -50083, 77413, -3288, 0, 0, 38551, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -50870, 77604, -3296, 0, 0, 33935, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -50872, 77467, -3296, 0, 0, 19188, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -49050, 76909, -3296, 0, 0, 11194, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -50882, 77549, -3296, 0, 0, 8752, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -48654, 77345, -3304, 0, 0, 5541, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -54419, 76357, -3160, 0, 0, 13328, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20038, -54560, 77466, -3136, 0, 0, 49863, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -53466, 77727, -3285, 0, 0, 11481, 20, 0, 0, 0),
-- Arachnid Tracker
("Dark_Elf_Village", 1, 20043, -64223, 84636, -3640, 0, 0, 8191, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -64453, 86297, -3672, 0, 0, 14470, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -63295, 85494, -3616, 0, 0, 55523, 20, 0, 0, 0),
-- Stone Guardian
("Dark_Elf_Village", 1, 20380, -45580, 66073, -3400, 0, 0, 49664, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -44081, 67352, -3352, 0, 0, 61794, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -43763, 66545, -3368, 0, 0, 53682, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -43954, 66349, -3360, 0, 0, 56255, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -41319, 67627, -3272, 0, 0, 29807, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -37460, 67606, -3368, 0, 0, 13979, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -34079, 67542, -3464, 0, 0, 2058, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33852, 67015, -3520, 0, 0, 62832, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -34144, 67523, -3240, 0, 0, 64041, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -34557, 67733, -3448, 0, 0, 21682, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33385, 69189, -3384, 0, 0, 56399, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33728, 68513, -3376, 0, 0, 44500, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33046, 68984, -3376, 0, 0, 61064, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -33831, 68756, -3376, 0, 0, 56190, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -34938, 67910, -3448, 0, 0, 46894, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -41645, 69160, -3536, 0, 0, 6588, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -51091, 71168, -3224, 0, 0, 29674, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -62840, 70867, -3184, 0, 0, 43305, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -62054, 71848, -3288, 0, 0, 38158, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -63537, 74957, -3240, 0, 0, 40520, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -63667, 73936, -3304, 0, 0, 38595, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -62282, 75248, -3352, 0, 0, 8770, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -56196, 72422, -2968, 0, 0, 13552, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -55265, 73546, -2872, 0, 0, 64114, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -55005, 72495, -3000, 0, 0, 40814, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -54698, 72228, -3072, 0, 0, 37173, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -53717, 74787, -3152, 0, 0, 45699, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -55462, 75507, -3080, 0, 0, 46054, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -51346, 72635, -3280, 0, 0, 9651, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -47205, 74269, -3376, 0, 0, 28489, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -48465, 73555, -3280, 0, 0, 43586, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -46414, 74617, -3424, 0, 0, 26346, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -46729, 73551, -3432, 0, 0, 15758, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -46264, 73611, -3496, 0, 0, 29182, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20380, -54763, 76939, -3184, 0, 0, 6505, 20, 0, 0, 0),
-- Crystalline Beast
("Dark_Elf_Village", 1, 20418, -64899, 72884, -3336, 0, 0, 51536, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64336, 72301, -3240, 0, 0, 55112, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -65072, 73565, -3296, 0, 0, 27647, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -63688, 76841, -3256, 0, 0, 22294, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64176, 76085, -3280, 0, 0, 3206, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64435, 76615, -3296, 0, 0, 15589, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -63342, 76869, -3256, 0, 0, 8528, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -62224, 77143, -3312, 0, 0, 40739, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64234, 78104, -3304, 0, 0, 24650, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -63770, 79173, -3344, 0, 0, 61684, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64798, 79004, -3328, 0, 0, 3355, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64598, 83969, -3592, 0, 0, 62677, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64853, 85120, -3640, 0, 0, 19538, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -64465, 85453, -3624, 0, 0, 24500, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -63249, 85717, -3616, 0, 0, 22840, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -60241, 82099, -3528, 0, 0, 9926, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -60295, 83344, -3576, 0, 0, 2229, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -60612, 81968, -3504, 0, 0, 4695, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20418, -63945, 82582, -3440, 0, 0, 29636, 20, 0, 0, 0),
-- Purgatory Shadow
("DevotionNecropolis", 1, 21156, -46375, 81519, -4746, 0, 0, 15067, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -46280, 80217, -4746, 0, 0, 65311, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -46232, 79227, -4744, 0, 0, 16209, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -46100, 83759, -4744, 0, 0, 59081, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -46010, 81449, -4746, 0, 0, 59795, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -45364, 80229, -4746, 0, 0, 62141, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -44986, 83215, -4746, 0, 0, 57344, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -44658, 83386, -4746, 0, 0, 3094, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -43776, 81006, -4746, 0, 0, 61173, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -43603, 79078, -4746, 0, 0, 6971, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -43392, 79858, -4746, 0, 0, 16684, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -42924, 81537, -4767, 0, 0, 17203, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -42292, 81102, -4746, 0, 0, 55545, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -41804, 83634, -4744, 0, 0, 24119, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21156, -41464, 79079, -4744, 0, 0, 8827, 120, 0, 0, 0),
-- Purgatory Tarantula
("DevotionNecropolis", 1, 21157, -46227, 84570, -4744, 0, 0, 46137, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45936, 89405, -4765, 0, 0, 65001, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45695, 87620, -4744, 0, 0, 2446, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45693, 86392, -4746, 0, 0, 53293, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45484, 85866, -4746, 0, 0, 49937, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45205, 87871, -4767, 0, 0, 20979, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -45042, 86198, -4744, 0, 0, 6571, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -44668, 87493, -4744, 0, 0, 62653, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -43403, 88739, -4746, 0, 0, 31645, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -43079, 85319, -4746, 0, 0, 32683, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -43061, 88568, -4746, 0, 0, 2018, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -42644, 84820, -4746, 0, 0, 43357, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -42458, 87126, -4746, 0, 0, 44845, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -42081, 87399, -4746, 0, 0, 32924, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -41615, 84550, -4744, 0, 0, 47906, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21157, -41609, 89255, -4744, 0, 0, 27495, 120, 0, 0, 0),
-- Hell Keeper Crimson Doll
("DevotionNecropolis", 1, 21158, -46413, 89426, -4744, 0, 0, 3969, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -46213, 84977, -4744, 0, 0, 53308, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -46197, 87640, -4744, 0, 0, 13797, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -46168, 86117, -4746, 0, 0, 53403, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -45495, 87831, -4746, 0, 0, 13290, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -45282, 86015, -4767, 0, 0, 60699, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -44989, 87597, -4744, 0, 0, 8712, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -44797, 86387, -4746, 0, 0, 63237, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -43299, 88211, -4744, 0, 0, 27736, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -43098, 89091, -4767, 0, 0, 57292, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -42954, 84714, -4765, 0, 0, 20646, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -42790, 85640, -4744, 0, 0, 12539, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -42688, 87157, -4744, 0, 0, 36547, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -41869, 87186, -4744, 0, 0, 28052, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -41620, 84993, -4744, 0, 0, 10927, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21158, -41618, 89629, -4744, 0, 0, 50534, 120, 0, 0, 0),
-- Lilim Priest
("DevotionNecropolis", 1, 21179, -52034, 81368, -4744, 0, 0, 46969, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -51754, 81680, -4746, 0, 0, 43290, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -51673, 83707, -4744, 0, 0, 232, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -50702, 81093, -4744, 0, 0, 36742, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -49740, 83924, -4746, 0, 0, 24160, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -49596, 81246, -4765, 0, 0, 34467, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -49522, 80985, -4746, 0, 0, 6810, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -49269, 83521, -4746, 0, 0, 37130, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -49256, 78981, -4746, 0, 0, 16801, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -48945, 79050, -4744, 0, 0, 32287, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -47431, 81638, -4746, 0, 0, 18918, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -47295, 80029, -4744, 0, 0, 32768, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -47177, 83691, -4744, 0, 0, 1227, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -47107, 79078, -4744, 0, 0, 3516, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21179, -47076, 82125, -4746, 0, 0, 54812, 120, 0, 0, 0),
-- Lilim Knight
("DevotionNecropolis", 1, 21180, -46314, 81916, -4744, 0, 0, 14030, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -46205, 83533, -4744, 0, 0, 44621, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -46053, 81152, -4746, 0, 0, 59782, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -45986, 79105, -4744, 0, 0, 62410, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -45985, 80094, -4744, 0, 0, 60323, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -45291, 79964, -4744, 0, 0, 59760, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -44921, 82911, -4746, 0, 0, 50860, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -44748, 83656, -4744, 0, 0, 28406, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -43751, 81334, -4746, 0, 0, 6966, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -43587, 80030, -4744, 0, 0, 6840, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -43304, 79056, -4746, 0, 0, 65224, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -43154, 81295, -4744, 0, 0, 43904, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -42576, 81065, -4746, 0, 0, 63760, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -41617, 83417, -4744, 0, 0, 44315, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21180, -41601, 79275, -4744, 0, 0, 22828, 120, 0, 0, 0),
-- Lilim Assassin
("DevotionNecropolis", 1, 21181, -46262, 89605, -4744, 0, 0, 63631, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -45984, 84796, -4744, 0, 0, 59442, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -45958, 87737, -4746, 0, 0, 2719, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -45921, 86093, -4746, 0, 0, 64254, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -45396, 87608, -4744, 0, 0, 54205, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -45240, 86247, -4746, 0, 0, 14326, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -44770, 87697, -4746, 0, 0, 3144, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -44718, 86130, -4746, 0, 0, 57641, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -43397, 88584, -4767, 0, 0, 19409, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -43024, 85005, -4746, 0, 0, 18837, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -43006, 88761, -4746, 0, 0, 54313, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -42793, 87368, -4744, 0, 0, 30981, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -42689, 85264, -4746, 0, 0, 42902, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -41875, 89412, -4744, 0, 0, 30330, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -41869, 87402, -4746, 0, 0, 25710, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21181, -41411, 84792, -4765, 0, 0, 33302, 120, 0, 0, 0),
-- Nephilim Bishop
("DevotionNecropolis", 1, 21200, -52086, 83711, -4744, 0, 0, 60246, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -51988, 82049, -4744, 0, 0, 56431, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -51761, 81107, -4744, 0, 0, 62275, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -50042, 83579, -4746, 0, 0, 31310, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -50026, 80795, -4746, 0, 0, 48548, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -50019, 81534, -4746, 0, 0, 23219, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -49860, 79237, -4767, 0, 0, 30391, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -49331, 79205, -4744, 0, 0, 10607, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -49286, 81100, -4765, 0, 0, 3757, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -49021, 83921, -4746, 0, 0, 41307, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -47445, 82239, -4746, 0, 0, 48227, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -47339, 79272, -4744, 0, 0, 10293, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -47322, 80377, -4765, 0, 0, 33782, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -47307, 83907, -4744, 0, 0, 50472, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21200, -47113, 81507, -4746, 0, 0, 32190, 120, 0, 0, 0),
-- Nephilim Centurion
("DevotionNecropolis", 1, 21201, -46470, 79101, -4744, 0, 0, 32325, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -46377, 83711, -4765, 0, 0, 32903, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -46191, 80950, -4744, 0, 0, 13829, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -46153, 79893, -4746, 0, 0, 53763, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -46153, 82044, -4744, 0, 0, 11323, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -45790, 79989, -4744, 0, 0, 59077, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -44993, 83799, -4744, 0, 0, 31321, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -44700, 82786, -4746, 0, 0, 54887, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -43632, 79717, -4746, 0, 0, 31373, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -43599, 80873, -4746, 0, 0, 48050, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -43327, 79254, -4746, 0, 0, 8593, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -43173, 81450, -4746, 0, 0, 10718, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -42733, 81283, -4744, 0, 0, 58095, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -41889, 79104, -4744, 0, 0, 32234, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21201, -41458, 83740, -4744, 0, 0, 33548, 120, 0, 0, 0),
-- Nephilim Scout
("DevotionNecropolis", 1, 21202, -46444, 84810, -4744, 0, 0, 1861, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -46211, 89243, -4744, 0, 0, 28683, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -46131, 87395, -4746, 0, 0, 1406, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -46052, 86381, -4746, 0, 0, 58655, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -45636, 87394, -4767, 0, 0, 55863, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -45571, 86091, -4746, 0, 0, 152, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -45229, 87405, -4746, 0, 0, 63864, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -44991, 86427, -4746, 0, 0, 4858, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -43318, 89103, -4767, 0, 0, 48583, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -43059, 88289, -4746, 0, 0, 16622, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -42994, 85603, -4767, 0, 0, 12572, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -42767, 84574, -4746, 0, 0, 31769, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -42324, 87305, -4744, 0, 0, 37558, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -42228, 87108, -4746, 0, 0, 52375, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -41831, 84810, -4744, 0, 0, 8674, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21202, -41396, 89417, -4744, 0, 0, 38216, 120, 0, 0, 0),
-- Sepulcher Guardian
("DevotionNecropolis", 1, 21224, -52017, 81070, -4744, 0, 0, 50330, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -51914, 83554, -4744, 0, 0, 12161, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -51765, 81972, -4746, 0, 0, 43077, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -50818, 81278, -4744, 0, 0, 31163, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -50326, 81540, -4746, 0, 0, 6283, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -50044, 81240, -4746, 0, 0, 55636, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -49856, 79002, -4744, 0, 0, 37604, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -49508, 83508, -4746, 0, 0, 49673, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -49481, 78961, -4746, 0, 0, 29009, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -49297, 83942, -4746, 0, 0, 34969, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -47595, 79107, -4744, 0, 0, 36123, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -47576, 80199, -4744, 0, 0, 33649, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -47545, 83710, -4744, 0, 0, 30213, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -47452, 81924, -4746, 0, 0, 38057, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21224, -47065, 81818, -4746, 0, 0, 48530, 120, 0, 0, 0),
-- Sepulcher Sage
("DevotionNecropolis", 1, 21225, -51986, 81751, -4744, 0, 0, 49563, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -51941, 83914, -4744, 0, 0, 35894, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -51759, 81304, -4746, 0, 0, 5593, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -50297, 81264, -4746, 0, 0, 40154, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -50044, 83843, -4746, 0, 0, 24233, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -49798, 80785, -4746, 0, 0, 48169, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -49577, 79300, -4746, 0, 0, 51167, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -49257, 81358, -4746, 0, 0, 2059, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -49075, 79270, -4746, 0, 0, 8430, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -48983, 83598, -4746, 0, 0, 45583, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -47403, 81413, -4746, 0, 0, 26244, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -47315, 78934, -4744, 0, 0, 15499, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -47306, 83555, -4744, 0, 0, 16893, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -47198, 82400, -4744, 0, 0, 54147, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21225, -47107, 80193, -4744, 0, 0, 33922, 120, 0, 0, 0),
-- Sepulcher Guardian
("DevotionNecropolis", 1, 21226, -46411, 81074, -4746, 0, 0, 20397, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -46352, 79929, -4767, 0, 0, 56378, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -46248, 83922, -4744, 0, 0, 15903, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -46222, 78925, -4744, 0, 0, 11548, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -46107, 81740, -4744, 0, 0, 51959, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -45639, 80205, -4744, 0, 0, 7915, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -44956, 83568, -4746, 0, 0, 32768, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -44604, 83169, -4746, 0, 0, 14859, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -43660, 79458, -4767, 0, 0, 41191, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -43391, 80893, -4746, 0, 0, 43594, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -43369, 79535, -4746, 0, 0, 17498, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -42896, 81109, -4746, 0, 0, 29026, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -42423, 81344, -4746, 0, 0, 5239, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -41620, 83893, -4744, 0, 0, 10068, 120, 0, 0, 0),
("DevotionNecropolis", 1, 21226, -41611, 78928, -4744, 0, 0, 15119, 120, 0, 0, 0),
-- Tumran Orc Brigand
("Dark_Elf_Village", 1, 27070, -49860, 74910, -3464, 0, 0, 0, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -49661, 74477, -3424, 0, 0, 24183, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -47835, 73071, -3352, 0, 0, 47539, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -48310, 74145, -3352, 0, 0, 49153, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -46330, 74142, -3464, 0, 0, 1084, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -46109, 75736, -3344, 0, 0, 0, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -46791, 73671, -3424, 0, 0, 0, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -47060, 74918, -3376, 0, 0, 6438, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -50527, 76540, -3296, 0, 0, 2223, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -48642, 76191, -3312, 0, 0, 40603, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -47035, 76234, -3376, 0, 0, 6994, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -46883, 77224, -3312, 0, 0, 18088, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -51360, 77820, -3296, 0, 0, 54741, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -51330, 79871, -3384, 0, 0, 34329, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27070, -51327, 80212, -3432, 0, 0, 20794, 180, 0, 0, 0),
-- Arkenia
("Dark_Elf_Village_Npc", 1, 30419, -44015, 79683, -3648, 0, 0, 47152, 60, 0, 0, 0),
-- Tyra
("Dark_Elf_Village_Npc", 1, 30420, -61717, 75401, -3352, 0, 0, 58500, 60, 0, 0, 0),
-- Varika
("Dark_Elf_Village_Npc", 1, 30421, -44225, 79721, -3648, 0, 0, 47152, 60, 0, 0, 0),
-- Mysterious Dark Elf
("Dark_Elf_Village_Npc", 1, 30661, -59985, 79234, -3496, 0, 0, 5300, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 30661, -44358, 79442, -3704, 0, 0, 48000, 60, 0, 0, 0),
-- Slein Shining Blade
("Dark_Elf_Village_Npc", 1, 30663, -42525, 80087, -3856, 0, 0, 49152, 60, 0, 0, 0),
-- Cain Flying Knife
("Dark_Elf_Village_Npc", 1, 30664, -59997, 79458, -3528, 0, 0, 0, 60, 0, 0, 0),
-- Kristina
("Dark_Elf_Village_Npc", 1, 30665, -53664, 85862, -3504, 0, 0, 53248, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq02_npc1820_02", 1, 31099, -52784, 79104, -4739, 0, 0, 33000, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq02_npc1820_01", 1, 31107, -51920, 79104, -4737, 0, 0, 0, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq02_npc1820_03", 1, 31502, -52142, 78814, -4736, 0, 0, 16000, 60, 0, 0, 0),
-- Bloody Pixy
("Dark_Elf_Village_Npc", 1, 31845, -43976, 67099, -3360, 0, 0, 9707, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -43560, 71673, -3544, 0, 0, 56954, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -51861, 85223, -3552, 0, 0, 15046, 60, 0, 0, 0),
-- Blight Treant
("Dark_Elf_Village_Npc", 1, 31850, -58139, 73386, -3192, 0, 0, 59546, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -52258, 72756, -3176, 0, 0, 7348, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -53724, 79155, -3248, 0, 0, 17779, 60, 0, 0, 0),

-- [18_21]

-- Felim Lizardman
("gludio33_1821_02", 1, 20008, -64494, 105826, -3530, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1821_02", 1, 20008, -63526, 103765, -3515, 0, 0, 41676, 25, 0, 0, 0),
("gludio33_1821_02", 1, 20008, -64503, 108374, -3592, 0, 0, 24424, 25, 0, 0, 0),
("gludio33_1821_02", 1, 20008, -63890, 105826, -3532, 0, 0, 0, 25, 0, 0, 0),
-- Felim Lizardman Scout
("gludio33_1721_02", 1, 20010, -64897, 105826, -3564, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20010, -64886, 102715, -3563, 0, 0, 54315, 25, 0, 0, 0),
-- Gora Werewolf
("gludio33_1721_02", 1, 20012, -64446, 98532, -3656, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_02", 1, 20012, -65535, 98327, -3704, 0, 0, 25579, 25, 0, 0, 0),
-- Felim Lizardman Warrior
("gludio33_1721_04", 1, 20014, -64199, 107138, -3589, 0, 0, 14992, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -61598, 105360, -3554, 0, 0, 36384, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -64997, 106360, -3584, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -64673, 103731, -3516, 0, 0, 35009, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -63486, 106182, -3544, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1721_04", 1, 20014, -64052, 104928, -3500, 0, 0, 7777, 25, 0, 0, 0),
-- Red Bear
("gludio33_1821_01", 1, 20021, -65048, 99244, -3656, 0, 0, 0, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -63893, 98503, -3621, 0, 0, 59754, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -64602, 100018, -3616, 0, 0, 19359, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -62589, 99688, -3533, 0, 0, 59234, 25, 0, 0, 0),
("gludio33_1821_01", 1, 20021, -65370, 101193, -3648, 0, 0, 32224, 25, 0, 0, 0),
-- Ruin Zombie
("gludio03_1821_01", 1, 20026, -57330, 109304, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -59113, 104131, -3735, 0, 0, 48237, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -58830, 109295, -3548, 0, 0, 47501, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -43271, 106861, -3275, 0, 0, 9602, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -48345, 109735, -3571, 0, 0, 31358, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -46175, 112674, -3807, 0, 0, 3917, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -50244, 105636, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20026, -49439, 105280, -3552, 0, 0, 0, 30, 0, 0, 0),
-- Ruin Zombie Leader
("gludio03_1821_01", 1, 20029, -58236, 110550, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -60424, 107193, -3642, 0, 0, 25631, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -59483, 107209, -3674, 0, 0, 20459, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -59083, 105645, -3727, 0, 0, 14773, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -58364, 106052, -3745, 0, 0, 58031, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -60113, 117445, -3302, 0, 0, 3993, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -58448, 117937, -3128, 0, 0, 31701, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -57561, 116486, -2977, 0, 0, 57300, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -58691, 116069, -3091, 0, 0, 65242, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -50581, 121873, -2831, 0, 0, 17913, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -48725, 121904, -2899, 0, 0, 4715, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -47330, 121950, -3002, 0, 0, 33882, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -49575, 123213, -2843, 0, 0, 18882, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -46613, 120660, -3320, 0, 0, 21534, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -57859, 112469, -3014, 0, 0, 55793, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -57507, 113205, -2952, 0, 0, 45992, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -53698, 118081, -3011, 0, 0, 59830, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -58549, 123052, -3008, 0, 0, 43206, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -57654, 120538, -3103, 0, 0, 53836, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -59189, 121770, -3097, 0, 0, 22472, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -43572, 111126, -3800, 0, 0, 34403, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -42153, 112010, -3264, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -46161, 107939, -3615, 0, 0, 8220, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -48145, 106713, -3335, 0, 0, 36293, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -44759, 110233, -3807, 0, 0, 18973, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -49339, 105458, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20029, -50043, 105992, -3552, 0, 0, 0, 30, 0, 0, 0),
-- Skeleton Tracker
("gludio03_1821_01", 1, 20035, -58639, 110194, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57632, 110194, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57229, 109838, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57027, 109838, -3624, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57009, 118233, -3039, 0, 0, 60737, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -59335, 116066, -3153, 0, 0, 8056, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56493, 119183, -3005, 0, 0, 14662, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -61232, 117186, -3371, 0, 0, 34055, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -49941, 118709, -3014, 0, 0, 45445, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -49702, 121490, -3508, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -48694, 120066, -3508, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -48302, 118773, -3133, 0, 0, 48643, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -47309, 119580, -3190, 0, 0, 56332, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -58251, 113182, -3240, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57974, 114509, -2958, 0, 0, 10765, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -60079, 111188, -3458, 0, 0, 10807, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56374, 111552, -3168, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -60059, 110320, -3550, 0, 0, 42968, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56864, 111003, -3274, 0, 0, 46330, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56286, 119787, -2996, 0, 0, 16480, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -53564, 120427, -2890, 0, 0, 10543, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56814, 119938, -3003, 0, 0, 32397, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -54806, 120062, -3116, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -54450, 116169, -3169, 0, 0, 11949, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -49622, 117407, -3250, 0, 0, 4527, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -51871, 115010, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -50737, 118563, -2948, 0, 0, 22284, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -47972, 117861, -3264, 0, 0, 6854, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56573, 108819, -3291, 0, 0, 39488, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -57409, 111004, -3334, 0, 0, 23529, 30, 0, 0, 0),
("gludio03_1821_01", 1, 20035, -56074, 109746, -3211, 0, 0, 48208, 30, 0, 0, 0),
-- Skeleton Tracker Leader
("gludio03_1821_04", 1, 20042, -58851, 117350, -3352, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -57914, 118688, -3077, 0, 0, 47880, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -58268, 119659, -3144, 0, 0, 8004, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -58690, 116608, -3098, 0, 0, 16418, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -51146, 120328, -2934, 0, 0, 36292, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -49621, 120566, -3008, 0, 0, 33653, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -48597, 120641, -3129, 0, 0, 31187, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -46288, 122196, -2942, 0, 0, 5969, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -47277, 122641, -2924, 0, 0, 1823, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -57244, 115590, -2976, 0, 0, 9297, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -58086, 115061, -2968, 0, 0, 19710, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -55063, 111730, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -55726, 112267, -3165, 0, 0, 41113, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -56172, 110840, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -57495, 110673, -3366, 0, 0, 59567, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -54856, 116967, -3124, 0, 0, 51193, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -53598, 118994, -3116, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -56167, 117960, -3013, 0, 0, 19287, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -54705, 120952, -3116, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -52888, 115143, -3310, 0, 0, 33419, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -51175, 117863, -2988, 0, 0, 6696, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -51868, 117255, -2997, 0, 0, 64787, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -55895, 113049, -3140, 0, 0, 40071, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -55473, 113815, -3161, 0, 0, 43924, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -38560, 112840, -3031, 0, 0, 57876, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -40407, 114100, -3360, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -41348, 112010, -3264, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -41850, 112188, -3264, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -41182, 111123, -3399, 0, 0, 62841, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -42317, 109382, -3336, 0, 0, 17275, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -40737, 110060, -3298, 0, 0, 35131, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -42156, 108152, -3243, 0, 0, 45139, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -41100, 109074, -3484, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -40093, 109074, -3484, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -42248, 107213, -3252, 0, 0, 48133, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -43972, 108503, -3351, 0, 0, 24817, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -43412, 107346, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -49841, 105280, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -49238, 105280, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -54513, 107444, -3720, 0, 0, 19269, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -52711, 107830, -3724, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -52408, 108642, -3722, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -49560, 108195, -3785, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -51564, 108796, -3720, 0, 0, 30156, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -51153, 113702, -3572, 0, 0, 10663, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -52036, 112870, -3575, 0, 0, 12898, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -47382, 111853, -3630, 0, 0, 1458, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -48502, 110705, -3572, 0, 0, 21976, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -49700, 109466, -3569, 0, 0, 51384, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -42643, 112948, -3688, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -43820, 117596, -3558, 0, 0, 33708, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -43402, 117090, -3557, 0, 0, 29107, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -43724, 117989, -3553, 0, 0, 25256, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -47339, 118574, -3156, 0, 0, 29201, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20042, -45302, 117936, -3558, 0, 0, 49715, 30, 0, 0, 0),
-- Skeleton Scout
("gludio03_1821_04", 1, 20045, -59732, 115614, -3205, 0, 0, 48786, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -57765, 119852, -3092, 0, 0, 59263, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -59858, 118062, -3352, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -59606, 116855, -3240, 0, 0, 58379, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -49198, 120956, -3508, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -48073, 120915, -3130, 0, 0, 27102, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -46149, 118056, -3524, 0, 0, 58082, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -46184, 119888, -3403, 0, 0, 21209, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -47360, 120516, -3259, 0, 0, 34409, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -57446, 113894, -3240, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -56805, 115229, -3008, 0, 0, 1598, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -57090, 116321, -2977, 0, 0, 25923, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -56380, 116407, -3014, 0, 0, 11371, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54863, 111018, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -59684, 108967, -3647, 0, 0, 47168, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -56072, 111374, -3149, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54760, 112264, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -56524, 122179, -2987, 0, 0, 28966, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -59843, 121388, -3132, 0, 0, 33120, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -56696, 121471, -3024, 0, 0, 23125, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54504, 119528, -3116, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -50720, 117039, -3148, 0, 0, 61366, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -50563, 115900, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -53525, 113833, -3290, 0, 0, 52986, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -51772, 116256, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -51871, 115366, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -39542, 116768, -3244, 0, 0, 3564, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -40429, 115566, -3144, 0, 0, 14038, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -39811, 110330, -3321, 0, 0, 36614, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -40899, 109074, -3484, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -38930, 111090, -3328, 0, 0, 54494, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -42305, 108767, -3219, 0, 0, 41035, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54349, 108443, -3725, 0, 0, 9500, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -53913, 107808, -3723, 0, 0, 8298, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54640, 108399, -3722, 0, 0, 28683, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -54889, 112994, -3220, 0, 0, 44058, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -53706, 113071, -3314, 0, 0, 46144, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -45503, 111118, -3795, 0, 0, 5759, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -46347, 112226, -3807, 0, 0, 62309, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -47265, 109501, -3785, 0, 0, 42878, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -40882, 110681, -3345, 0, 0, 60102, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -44403, 112344, -3807, 0, 0, 44850, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -43901, 116860, -3570, 0, 0, 37112, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -45672, 116179, -3551, 0, 0, 26614, 30, 0, 0, 0),
("gludio03_1821_04", 1, 20045, -45063, 118837, -3481, 0, 0, 12409, 30, 0, 0, 0),
-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -54408, 127488, -3192, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -54408, 128200, -3192, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -54006, 127488, -3192, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -50958, 126652, -3051, 0, 0, 46819, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -49146, 129959, -2560, 0, 0, 34758, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -48050, 130222, -2387, 0, 0, 14543, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -47311, 124911, -2877, 0, 0, 62758, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -49304, 124364, -2930, 0, 0, 23187, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -51775, 123883, -2975, 0, 0, 20981, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -51433, 122478, -2830, 0, 0, 52177, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -50507, 124296, -3104, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -44113, 129564, -2826, 0, 0, 20486, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -45577, 128975, -2844, 0, 0, 28057, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -41806, 130995, -2885, 0, 0, 58068, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -45009, 125846, -2875, 0, 0, 48511, 21, 0, 0, 0),
-- Skeleton Bowman
("gludio03_1821_08", 1, 20051, -57338, 111945, -3092, 0, 0, 21875, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -55971, 111908, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -55467, 110662, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -56528, 109866, -3208, 0, 0, 50249, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -55980, 120296, -2978, 0, 0, 20033, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -54604, 120774, -3116, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -57953, 121473, -3102, 0, 0, 21221, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -51468, 115010, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -49499, 116495, -3321, 0, 0, 53415, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -55561, 114744, -3136, 0, 0, 24742, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -50161, 115544, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_08", 1, 20051, -51066, 115366, -3588, 0, 0, 0, 30, 0, 0, 0),
-- Ruin Spartoi
("gludio03_1821_07", 1, 20054, -59221, 114490, -3092, 0, 0, 36393, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -58352, 114072, -3240, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -59230, 111151, -3378, 0, 0, 50124, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -59658, 110868, -3478, 0, 0, 46651, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -58169, 112033, -3087, 0, 0, 25717, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -55769, 111196, -3460, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -54693, 114431, -3222, 0, 0, 36607, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -50664, 115722, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -53804, 114908, -3238, 0, 0, 35571, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -53552, 116598, -3169, 0, 0, 12877, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -50462, 115010, -3588, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -41011, 114456, -3360, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -41194, 116113, -3157, 0, 0, 26108, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -41664, 110447, -3339, 0, 0, 47890, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -41649, 112188, -3264, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -44102, 106900, -3278, 0, 0, 37687, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -46071, 107458, -3553, 0, 0, 34734, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -45319, 107687, -3496, 0, 0, 9520, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49440, 105636, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49640, 105280, -3552, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -54967, 108015, -3731, 0, 0, 19808, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -55120, 107052, -3720, 0, 0, 27972, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -52610, 107652, -3724, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -53451, 108552, -3728, 0, 0, 37008, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -50008, 108045, -3720, 0, 0, 61492, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -51860, 111150, -3585, 0, 0, 17614, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -51057, 112756, -3572, 0, 0, 9097, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49193, 110501, -3637, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -52091, 109146, -3718, 0, 0, 41064, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49085, 108222, -3720, 0, 0, 54457, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -53994, 110215, -3578, 0, 0, 26002, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -46543, 111584, -3857, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49012, 109317, -3571, 0, 0, 33859, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49364, 112180, -3571, 0, 0, 24295, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -48465, 113164, -3577, 0, 0, 52179, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -47132, 114013, -3670, 0, 0, 4529, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -48437, 114287, -3649, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -42179, 111051, -3558, 0, 0, 54963, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -42938, 118889, -3559, 0, 0, 36362, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -43498, 118299, -3554, 0, 0, 8682, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -46544, 116229, -3551, 0, 0, 35471, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -49118, 118319, -3143, 0, 0, 25486, 30, 0, 0, 0),
("gludio03_1821_07", 1, 20054, -45672, 117134, -3554, 0, 0, 7771, 30, 0, 0, 0),
-- Hungry Eye
("gludio35_1822_01", 1, 20059, -52557, 130749, -3060, 0, 0, 30948, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -54548, 130736, -3012, 0, 0, 65337, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -50650, 130323, -3002, 0, 0, 37738, 20, 0, 0, 0),
-- Raging Spartoi
("gludio03_1821_17", 1, 20060, -55192, 107539, -3740, 0, 0, 29786, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -54631, 107273, -3720, 0, 0, 58780, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -52812, 108720, -3724, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -52006, 108008, -3724, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49862, 108373, -3785, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -50621, 110376, -3592, 0, 0, 45868, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -52784, 112340, -3574, 0, 0, 53988, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -52265, 111908, -3622, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49698, 111225, -3572, 0, 0, 14717, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49394, 110501, -3637, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -51131, 110047, -3674, 0, 0, 6285, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49293, 110679, -3637, 0, 0, 0, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49554, 114801, -3638, 0, 0, 21135, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -45451, 109688, -3807, 0, 0, 64619, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -46476, 110339, -3807, 0, 0, 55564, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -49588, 113849, -3600, 0, 0, 40675, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -47814, 113694, -3670, 0, 0, 39655, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -47303, 112893, -3572, 0, 0, 56065, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -42698, 112143, -3218, 0, 0, 61530, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -41998, 111169, -3535, 0, 0, 56664, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -43313, 119048, -3551, 0, 0, 50785, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -44038, 115979, -3623, 0, 0, 41570, 30, 0, 0, 0),
("gludio03_1821_17", 1, 20060, -42778, 118637, -3552, 0, 0, 12675, 30, 0, 0, 0),
-- Tumran Bugbear
("dion15_2022_05", 1, 20062, -55355, 108487, -3720, 0, 0, 33568, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -52812, 108364, -3724, 0, 0, 0, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -49459, 108373, -3785, 0, 0, 0, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -50157, 113470, -3580, 0, 0, 22059, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -52499, 109135, -3728, 0, 0, 5711, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -53226, 110386, -3574, 0, 0, 20895, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -49058, 111332, -3571, 0, 0, 31506, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -47634, 112088, -3606, 0, 0, 4903, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -46148, 108675, -3761, 0, 0, 50612, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -45708, 112999, -3807, 0, 0, 8672, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -47538, 115383, -3647, 0, 0, 38720, 24, 0, 0, 0),
("dion15_2022_05", 1, 20062, -48416, 114641, -3672, 0, 0, 0, 24, 0, 0, 0),
-- Tumran Bugbear Warrior
("gludio03_1821_21", 1, 20064, -50966, 108514, -3720, 0, 0, 61899, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -51806, 113835, -3555, 0, 0, 12213, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -50958, 112129, -3590, 0, 0, 7678, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -53818, 108329, -3732, 0, 0, 38719, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -48295, 108309, -3720, 0, 0, 37572, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -48667, 109930, -3562, 0, 0, 46737, 30, 0, 0, 0),
("gludio03_1821_21", 1, 20064, -44756, 113781, -3805, 0, 0, 8414, 30, 0, 0, 0),
-- Ratman Hunter
("gludio38_1921_04", 1, 20358, -65441, 107975, -3699, 0, 0, 3843, 30, 0, 0, 0),
-- Ratman Warrior
("gludio35_1821_01", 1, 20359, -54509, 127666, -3192, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -54106, 128022, -3192, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -55012, 127844, -3192, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -49314, 129223, -3156, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -47999, 128412, -2544, 0, 0, 62926, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -49716, 128867, -3156, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -53427, 128994, -3073, 0, 0, 57260, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -51889, 125954, -3236, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -50406, 127457, -2993, 0, 0, 10528, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -48112, 123165, -2843, 0, 0, 54184, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -50926, 125315, -3007, 0, 0, 42656, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -49531, 125430, -2963, 0, 0, 5021, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -43741, 127604, -2976, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -43223, 128901, -2838, 0, 0, 3682, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -41229, 128177, -2882, 0, 0, 65446, 20, 0, 0, 0),
-- Ol Mahum Deserter
("gludio35_1822_01", 1, 20548, -52926, 129218, -3062, 0, 0, 46168, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -51980, 129940, -3036, 0, 0, 6379, 20, 0, 0, 0),
-- Maille Lizardman Guard
("gludio23_1921_07", 1, 20921, -34576, 111539, -2347, 0, 0, 23709, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -33961, 117697, -2505, 0, 0, 28418, 32, 0, 0, 0),
-- Maille Lizardman Warrior
("gludio23_1921_03", 1, 20922, -32973, 103935, -2619, 0, 0, 61696, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -32918, 109173, -2607, 0, 0, 14413, 32, 0, 0, 0),
-- Maille Lizardman Matriarch
("gludio23_1921_01", 1, 20924, -34382, 103712, -2362, 0, 0, 38685, 32, 0, 0, 0),
-- Giant Araneid
("gludio23_1921_07", 1, 20925, -33096, 105962, -2591, 0, 0, 49441, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32879, 106280, -2635, 0, 0, 52543, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32919, 119353, -2575, 0, 0, 23451, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -33286, 116530, -2509, 0, 0, 41268, 32, 0, 0, 0),
-- Poison Araneid
("gludio23_1921_07", 1, 20926, -32940, 106921, -2570, 0, 0, 23854, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -33566, 107810, -2452, 0, 0, 43355, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -32935, 115125, -2408, 0, 0, 41878, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -32944, 118172, -2582, 0, 0, 34285, 32, 0, 0, 0),
-- King of the Araneid
("gludio23_1921_01", 1, 20927, -33565, 109600, -2503, 0, 0, 24004, 32, 0, 0, 0),
-- Young Araneid
("gludio33_1721_06", 1, 21097, -65235, 109484, -3627, 0, 0, 64632, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21097, -65023, 111105, -3546, 0, 0, 14252, 25, 0, 0, 0),
-- Plain Grizzly
("gludio33_1721_06", 1, 21098, -65516, 113081, -3545, 0, 0, 12472, 25, 0, 0, 0),
("gludio33_1721_06", 1, 21098, -63889, 109122, -3555, 0, 0, 33072, 25, 0, 0, 0),
-- Water Seer
("gludio01_qm1821_01", 1, 27030, -58644, 122172, -3136, 0, 0, 0, 300, 0, 0, 0),
("gludio01_qm1821_01", 1, 27030, -58543, 122350, -3136, 0, 0, 0, 300, 0, 0, 0),
("gludio01_qm1821_01", 1, 27030, -58947, 122706, -3136, 0, 0, 0, 300, 0, 0, 0),
("gludio01_qm1821_01", 1, 27030, -52291, 122745, -2886, 0, 0, 15149, 300, 0, 0, 0),
("gludio01_qm1821_01", 1, 27030, -54853, 123542, -3120, 0, 0, 0, 300, 0, 0, 0),
("gludio01_qm1821_01", 1, 27030, -53881, 122037, -2875, 0, 0, 22533, 300, 0, 0, 0),
-- Singing Flower of Phantasm
("gludio01_qm1821_03", 1, 27095, -57972, 126924, -2944, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1821_03", 1, 27095, -57670, 127102, -2944, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1821_03", 1, 27095, -57871, 127458, -2944, 0, 0, 0, 180, 0, 0, 0),
-- Earth Snake
("gludio03_npc1821_003", 1, 30409, -53760, 110720, -3610, 0, 0, 0, 60, 0, 0, 0),
-- Water Undine
("gludio17_npc1821_002", 1, 30413, -60672, 126592, -2957, 0, 0, 0, 60, 0, 0, 0),

-- [18_22]

-- Venomous Spider
("oren25_1820_01", 1, 20038, -64570, 163147, -3785, 0, 0, 17118, 20, 0, 0, 0),
-- Arachnid Tracker
("oren25_1820_14s", 1, 20043, -65331, 160718, -3629, 0, 0, 37447, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -63137, 162561, -3739, 0, 0, 58170, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -61705, 163761, -3769, 0, 0, 749, 20, 0, 0, 0),
-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -42341, 132260, -2952, 0, 0, 6149, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -34298, 135205, -3905, 0, 0, 63643, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -35342, 137644, -3604, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -35948, 137644, -3604, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -37022, 141190, -3174, 0, 0, 22218, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -35982, 140221, -3302, 0, 0, 22404, 21, 0, 0, 0),
-- Ol Mahum Patrol
("gludio09_1822_01", 1, 20053, -44651, 141678, -3020, 0, 0, 4785, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -46021, 140517, -2918, 0, 0, 19560, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -45074, 138187, -2867, 0, 0, 61497, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -46207, 141691, -2862, 0, 0, 28874, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -45287, 144958, -3006, 0, 0, 1906, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -47012, 143874, -2848, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -47218, 141785, -2941, 0, 0, 53845, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -47314, 143340, -2888, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -46260, 145685, -3016, 0, 0, 38052, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -46300, 148153, -2968, 0, 0, 2215, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -48067, 146574, -3085, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -49354, 148422, -3164, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20053, -49868, 149683, -2743, 0, 0, 6444, 27, 0, 0, 0),
-- Wandering Eye
("gludio35_1822_02", 1, 20055, -48138, 134908, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -48057, 135260, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -47534, 134908, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -44472, 131568, -3176, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -42886, 131376, -2837, 0, 0, 27370, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -44573, 131746, -3176, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -45070, 135956, -2833, 0, 0, 22093, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -43795, 135045, -2894, 0, 0, 23863, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -42604, 133643, -2968, 0, 0, 10234, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -35919, 131938, -2850, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -36015, 133185, -3085, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -35858, 134423, -3257, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -35760, 134949, -3339, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -33734, 134853, -3817, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -36458, 136158, -3536, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -34292, 133030, -3270, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -35548, 133977, -3278, 0, 0, 34929, 20, 0, 0, 0),
-- Ol Mahum Guard
("gludio40_1922_01", 1, 20058, -43556, 141171, -2928, 0, 0, 63486, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -44536, 139956, -2872, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -49563, 146998, -2791, 0, 0, 25321, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -45046, 143034, -3017, 0, 0, 63224, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -47930, 147942, -2943, 0, 0, 28290, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -47464, 146218, -29200, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -49656, 148600, -3164, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -50810, 148962, -2712, 0, 0, 18056, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -49994, 150719, -2780, 0, 0, 23679, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -47759, 139986, -2925, 0, 0, 53230, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -50555, 143460, -2889, 0, 0, 15531, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -49360, 143242, -2644, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -49727, 144522, -2640, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -51527, 147061, -2275, 0, 0, 17682, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -54378, 146505, -2875, 0, 0, 21009, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -53816, 145021, -2880, 0, 0, 29728, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -53892, 143078, -3004, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -52153, 139080, -2953, 0, 0, 61207, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -52456, 142112, -2996, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -51544, 139663, -2889, 0, 0, 28428, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -51523, 137906, -2860, 0, 0, 2439, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -50560, 137328, -2864, 0, 0, 65054, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -52049, 137202, -2874, 0, 0, 43669, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -54070, 139084, -2920, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -53884, 137794, -2824, 0, 0, 47738, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -57024, 142156, -2804, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -59687, 139298, -2455, 0, 0, 40736, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -51949, 134390, -3026, 0, 0, 4681, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -52076, 135568, -2866, 0, 0, 20841, 20, 0, 0, 0),
-- Hungry Eye
("gludio35_1822_01", 1, 20059, -53490, 131081, -3061, 0, 0, 49625, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -50990, 131448, -3292, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -48831, 131138, -2485, 0, 0, 17109, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -52392, 132627, -3190, 0, 0, 22409, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -48862, 133293, -2479, 0, 0, 37282, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -47332, 134908, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -47534, 135264, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -47332, 135620, -2315, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -44202, 133755, -2824, 0, 0, 32861, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -41005, 132093, -3048, 0, 0, 30797, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -35645, 137110, -3604, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -33984, 135888, -3919, 0, 0, 32688, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -35293, 141034, -3468, 0, 0, 16020, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -35341, 138938, -3372, 0, 0, 27801, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -33539, 137701, -3479, 0, 0, 3629, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -33152, 139744, -4044, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32899, 141007, -3988, 0, 0, 26154, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32944, 143061, -3934, 0, 0, 14845, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -36751, 142470, -2964, 0, 0, 7696, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32960, 147880, -3982, 0, 0, 23224, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -34564, 149952, -3954, 0, 0, 21918, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -35812, 147137, -3219, 0, 0, 47107, 20, 0, 0, 0),
-- Ol Mahum Straggler
("gludio09_1822_11", 1, 20061, -54812, 142617, -2844, 0, 0, 32461, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -52817, 143258, -2902, 0, 0, 24683, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -53096, 139389, -2922, 0, 0, 46490, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -54027, 140309, -2852, 0, 0, 31813, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -56822, 142868, -2804, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -58487, 141377, -2562, 0, 0, 39644, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -59298, 138520, -2416, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20061, -59339, 136358, -2387, 0, 0, 59510, 27, 0, 0, 0),
-- Ol Mahum Shooter
("dion03_2121_01", 1, 20063, -35374, 163836, -2818, 0, 0, 31190, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -53723, 136861, -2773, 0, 0, 36011, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -54473, 139440, -2864, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -56283, 135048, -2434, 0, 0, 62693, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -56875, 137665, -2778, 0, 0, 12660, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -55973, 139307, -2504, 0, 0, 21403, 60, 0, 0, 0),
-- Ol Mahum Captain
("gludio40_1922_03", 1, 20066, -33097, 162559, -2823, 0, 0, 30774, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -58609, 135970, -2437, 0, 0, 64902, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -57300, 134414, -2680, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -54870, 136354, -2747, 0, 0, 60916, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -58140, 138730, -2747, 0, 0, 27575, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -52068, 143364, -2888, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -50782, 140112, -2854, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -53724, 140620, -2856, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -52463, 137716, -2918, 0, 0, 45201, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -54634, 135848, -2904, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -58184, 137488, -2784, 0, 0, 0, 20, 0, 0, 0),
-- Ol Mahum Commander
("gludio09_1822_33s", 1, 20076, -51828, 143838, -2889, 0, 0, 4278, 27, 0, 0, 0),
("gludio09_1822_33s", 1, 20076, -50709, 140056, -2858, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_33s", 1, 20076, -53926, 140976, -2856, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_33s", 1, 20076, -52811, 138024, -2918, 0, 0, 36236, 27, 0, 0, 0),
("gludio09_1822_33s", 1, 20076, -54735, 136026, -2904, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_33s", 1, 20076, -58184, 137844, -2996, 0, 0, 0, 27, 0, 0, 0),
-- Brown Bear
("gludio34_1822_01", 1, 20310, -64594, 159928, -3662, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -63604, 161057, -3715, 0, 0, 16866, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -62036, 158026, -3359, 0, 0, 53548, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -65195, 161740, -3708, 0, 0, 51110, 21, 0, 0, 0),
("gludio34_1822_01", 1, 20310, -63420, 158796, -3548, 0, 0, 55272, 21, 0, 0, 0),
-- Ratman Warrior
("gludio35_1821_01", 1, 20359, -34331, 131807, -3162, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -35066, 132583, -3192, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -36695, 134792, -3040, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -37233, 135308, -3000, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -34892, 133080, -3968, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -33223, 134072, -3774, 0, 0, 37765, 20, 0, 0, 0),
-- Ol Mahum Supplier
("gludio09_1822_10", 1, 20436, -53832, 146954, -2864, 0, 0, 6475, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -53932, 145952, -2874, 0, 0, 55561, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -54656, 146789, -2875, 0, 0, 23477, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -51550, 141934, -2996, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -52309, 140661, -2916, 0, 0, 12575, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -49902, 138473, -2886, 0, 0, 29289, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -51340, 136731, -2891, 0, 0, 51469, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -51087, 139191, -2917, 0, 0, 15479, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -50430, 137503, -2868, 0, 0, 25538, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -49118, 137337, -2679, 0, 0, 29969, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -53108, 137084, -2904, 0, 0, 35682, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -52398, 138038, -2918, 0, 0, 8786, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -58986, 140128, -2512, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -57549, 140491, -2636, 0, 0, 40697, 27, 0, 0, 0),
("gludio09_1822_10", 1, 20436, -60540, 136909, -2339, 0, 0, 31046, 27, 0, 0, 0),
-- Ol Mahum Recruit
("gludio09_1822_01", 1, 20437, -44032, 140134, -2880, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -43742, 142064, -2983, 0, 0, 6573, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -46407, 144225, -2967, 0, 0, 61052, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -45315, 142039, -2976, 0, 0, 6748, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -46938, 147495, -2971, 0, 0, 1711, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -51394, 148400, -2702, 0, 0, 27942, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -48549, 148778, -3164, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -49072, 150020, -2824, 0, 0, 6279, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -48212, 149589, -3002, 0, 0, 54076, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -48732, 140400, -2808, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -49614, 140172, -2874, 0, 0, 28319, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -49676, 142000, -2792, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -49662, 143420, -2644, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -49828, 144344, -2640, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_01", 1, 20437, -51869, 146126, -2761, 0, 0, 17878, 27, 0, 0, 0),
-- Ol Mahum General
("gludio09_1822_23", 1, 20438, -54541, 136472, -2748, 0, 0, 4951, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -57931, 138031, -2782, 0, 0, 15978, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -57779, 137645, -2782, 0, 0, 13666, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -56979, 136277, -2732, 0, 0, 57709, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -57375, 139330, -2808, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -56257, 138646, -2536, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -56623, 140378, -2625, 0, 0, 19527, 27, 0, 0, 0),
("gludio09_1822_23", 1, 20438, -56642, 140748, -2625, 0, 0, 16920, 27, 0, 0, 0),
-- Ol Mahum Officer
("gludio09_1822_11", 1, 20439, -53792, 142544, -3004, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55772, 143391, -2549, 0, 0, 5729, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -50873, 142377, -2889, 0, 0, 2184, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -51884, 143533, -2889, 0, 0, 28676, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -50567, 139350, -2880, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -49764, 138994, -2920, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -51180, 137400, -2880, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -52815, 137942, -2918, 0, 0, 50087, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -52658, 137886, -2918, 0, 0, 11425, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -53483, 140079, -2852, 0, 0, 9351, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -54946, 138466, -2914, 0, 0, 46596, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -60160, 138075, -2346, 0, 0, 43557, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -59613, 137140, -2373, 0, 0, 56165, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -60035, 136630, -2580, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -59497, 136085, -2426, 0, 0, 52894, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -57947, 135536, -2444, 0, 0, 59164, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -59020, 135132, -2544, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55398, 133867, -2142, 0, 0, 50808, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55423, 135714, -2734, 0, 0, 1481, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -56965, 135102, -2429, 0, 0, 61818, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55682, 136774, -2774, 0, 0, 28842, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -56931, 138292, -2704, 0, 0, 21862, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -58017, 136978, -2872, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -57173, 139686, -2624, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55888, 139860, -2764, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -56960, 140976, -2776, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -55172, 137644, -2840, 0, 0, 0, 27, 0, 0, 0),
("gludio09_1822_11", 1, 20439, -56408, 136122, -2730, 0, 0, 11315, 27, 0, 0, 0),
-- Ol Mahum Deserter
("gludio35_1822_01", 1, 20548, -53165, 132698, -2905, 0, 0, 65025, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -50312, 133892, -2599, 0, 0, 4001, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -49960, 132024, -2892, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -49960, 132380, -2892, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -50162, 132380, -2892, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -35528, 143318, -3262, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -34735, 144384, -3373, 0, 0, 45441, 20, 0, 0, 0),
-- Ol Mahum Novice
("gludio01_qm1822_02", 1, 20782, -49948, 152710, -2831, 0, 0, 10583, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -48261, 151987, -3148, 0, 0, 0, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -49167, 151809, -3148, 0, 0, 0, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -47588, 151263, -2936, 0, 0, 10018, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -49248, 152745, -2914, 0, 0, 43805, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -50145, 151922, -2790, 0, 0, 22843, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -47822, 153699, -3047, 0, 0, 19867, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -48362, 151809, -3148, 0, 0, 0, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -49254, 153430, -2946, 0, 0, 15484, 45, 0, 0, 0),
("gludio01_qm1822_02", 1, 20782, -48865, 151275, -3148, 0, 0, 0, 45, 0, 0, 0),
-- Cat's Eye Bandit
("gludio01_qm1822_01", 1, 27038, -46027, 145033, -3026, 0, 0, 11372, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -45905, 146758, -2964, 0, 0, 17318, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -48062, 143345, -2954, 0, 0, 51023, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -46190, 143296, -2928, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -46975, 144858, -2934, 0, 0, 29016, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -46602, 144609, -2964, 0, 0, 17668, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -46895, 143118, -3071, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -48801, 145604, -2841, 0, 0, 25118, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -47803, 145100, -2851, 0, 0, 21385, 180, 0, 0, 0),
("gludio01_qm1822_01", 1, 27038, -49201, 147781, -2784, 0, 0, 14037, 180, 0, 0, 0),

-- [18_23]

-- Langk Lizardman Scout
("gludio22_1824_01", 1, 20027, -52558, 195892, -3703, 0, 0, 41558, 20, 0, 0, 0),
-- Venomous Spider
("oren25_1820_01", 1, 20038, -64272, 165493, -3723, 0, 0, 16406, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -65029, 164604, -3724, 0, 0, 0, 20, 0, 0, 0),
("oren25_1820_01", 1, 20038, -64774, 174821, -3788, 0, 0, 0, 20, 0, 0, 0),
-- Arachnid Tracker
("oren25_1820_14s", 1, 20043, -62869, 165074, -3723, 0, 0, 23964, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -64689, 167803, -3702, 0, 0, 46115, 20, 0, 0, 0),
("oren25_1820_14s", 1, 20043, -64076, 170116, -3756, 0, 0, 0, 20, 0, 0, 0),
-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -65273, 179436, -3666, 0, 0, 295, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -58877, 164659, -3723, 0, 0, 6386, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -64379, 171006, -3756, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -64323, 172464, -3723, 0, 0, 51474, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -63266, 176727, -3568, 0, 0, 3054, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -63173, 173184, -3722, 0, 0, 49809, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -62181, 175230, -3608, 0, 0, 53045, 21, 0, 0, 0),
-- Ol Mahum Shooter
("dion03_2121_01", 1, 20063, -33278, 163880, -2918, 0, 0, 31305, 60, 0, 0, 0),
-- Monster Eye Watcher
("gludio04_1823_01", 1, 20067, -45535, 180464, -3719, 0, 0, 28673, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -45891, 180873, -3685, 0, 0, 32883, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -47331, 178970, -3674, 0, 0, 39699, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -51006, 177281, -3626, 0, 0, 38070, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -43004, 180820, -3474, 0, 0, 25056, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -43940, 181728, -3641, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -43135, 181372, -3563, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -44153, 183001, -3629, 0, 0, 1180, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -45457, 182873, -3629, 0, 0, 48247, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -42496, 178358, -3626, 0, 0, 17451, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -48656, 177423, -3722, 0, 0, 44852, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -38635, 174792, -3629, 0, 0, 53070, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -37412, 170252, -3942, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -36774, 170370, -3666, 0, 0, 13574, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -37028, 170359, -3632, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -35640, 167462, -3247, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -35422, 168647, -3621, 0, 0, 0, 27, 0, 0, 0),
-- Monster Eye Destroyer
("dion17_2023_01", 1, 20068, -49061, 178914, -3630, 0, 0, 17909, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -43101, 179679, -3568, 0, 0, 19365, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -41913, 184353, -3465, 0, 0, 9093, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -43028, 186427, -3628, 0, 0, 5469, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -42284, 186054, -3694, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -40709, 174686, -2672, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -40306, 175042, -2798, 0, 0, 0, 29, 0, 0, 0),
-- Lesser Basilisk
("gludio04_1823_02", 1, 20070, -42197, 180392, -3427, 0, 0, 334, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -43537, 181372, -3632, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -44531, 184665, -3718, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -42559, 184088, -3465, 0, 0, 5434, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -40967, 187653, -3375, 0, 0, 5362, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -44007, 185844, -3628, 0, 0, 38582, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -45508, 184499, -3538, 0, 0, 45034, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -40280, 184859, -3629, 0, 0, 8160, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -39077, 183803, -3935, 0, 0, 1420, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -39429, 176420, -3732, 0, 0, 25463, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -43893, 179788, -3610, 0, 0, 61480, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -35888, 169336, -3577, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -35459, 170837, -3927, 0, 0, 36620, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -33919, 170623, -3935, 0, 0, 63143, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -36646, 172233, -3628, 0, 0, 56049, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -37014, 174203, -3935, 0, 0, 59480, 27, 0, 0, 0),
-- Basilisk
("gludio04_1823_06", 1, 20072, -41841, 185049, -3688, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -42966, 187579, -3629, 0, 0, 19528, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -38513, 185580, -3629, 0, 0, 5331, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -45166, 181807, -3629, 0, 0, 42895, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -37595, 188421, -3719, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -36745, 188127, -3640, 0, 0, 12345, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -33631, 191291, -3629, 0, 0, 46312, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -33772, 192327, -3719, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -40306, 175398, -3049, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -39851, 176914, -3672, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -40698, 173083, -3208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -37108, 171360, -3629, 0, 0, 52106, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -36445, 169129, -3628, 0, 0, 47557, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -34737, 174777, -4328, 0, 0, 32780, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -33533, 173416, -4236, 0, 0, 53496, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -37179, 175910, -3935, 0, 0, 45189, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -37352, 175377, -3935, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -38209, 178642, -4001, 0, 0, 21774, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -39277, 180329, -3975, 0, 0, 17843, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -39954, 183172, -3935, 0, 0, 18388, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -42356, 182467, -3810, 0, 0, 34657, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -39244, 182085, -4200, 0, 0, 0, 27, 0, 0, 0),
-- Androscorpio
("gludio04_1823_08", 1, 20074, -36836, 189055, -3641, 0, 0, 11345, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -35724, 186297, -3212, 0, 0, 53020, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -37595, 189133, -3719, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -38116, 186379, -3629, 0, 0, 31291, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -35179, 189467, -3719, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -32949, 192577, -3628, 0, 0, 18650, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -35714, 192111, -3637, 0, 0, 33837, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -36829, 190334, -3635, 0, 0, 45165, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -34113, 171324, -3946, 0, 0, 24244, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -35910, 173152, -4400, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -34864, 172613, -3935, 0, 0, 26491, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -36942, 175270, -3935, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -37546, 175270, -3935, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -37007, 176438, -3935, 0, 0, 62333, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -39835, 178474, -3935, 0, 0, 42599, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -39942, 179949, -3933, 0, 0, 15430, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -37518, 177337, -3935, 0, 0, 53580, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -37912, 183683, -3936, 0, 0, 533, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -39950, 181551, -4200, 0, 0, 0, 27, 0, 0, 0),
-- Androscorpio Hunter
("gludio04_1823_08", 1, 20077, -40819, 185255, -3629, 0, 0, 32084, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -38723, 185252, -3719, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -37266, 185899, -3630, 0, 0, 49798, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -33236, 190814, -3629, 0, 0, 4649, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -32816, 175542, -4212, 0, 0, 19064, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -41164, 182603, -3927, 0, 0, 34099, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -34995, 183969, -3999, 0, 0, 2933, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -36730, 178768, -4374, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -33255, 178214, -4221, 0, 0, 59441, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -36427, 179302, -4374, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -34495, 178788, -4221, 0, 0, 43551, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -34790, 179483, -4221, 0, 0, 21894, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -34363, 177808, -4399, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -32974, 176644, -4221, 0, 0, 57599, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -35574, 180113, -4221, 0, 0, 25410, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -34089, 181052, -4221, 0, 0, 6565, 27, 0, 0, 0),
-- Ant
("gludio04_1823_24", 1, 20079, -36730, 179124, -4374, 0, 0, 0, 27, 0, 0, 0),
-- Ant Captain
("gludio04_1823_25", 1, 20080, -35428, 178720, -4221, 0, 0, 32674, 27, 0, 0, 0),
-- Granite Golem
("dion02_2122_22", 1, 20083, -35780, 190219, -3719, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -37357, 187042, -3636, 0, 0, 48943, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -36083, 191109, -3719, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -34193, 185171, -4036, 0, 0, 10251, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -37035, 183275, -3935, 0, 0, 37382, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -35841, 180995, -4221, 0, 0, 23714, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -36730, 179480, -4374, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -37270, 181157, -4223, 0, 0, 25241, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -35044, 180846, -4221, 0, 0, 11467, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -35843, 178675, -4222, 0, 0, 52223, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -35442, 178109, -4227, 0, 0, 34009, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -34918, 174172, -4302, 0, 0, 31635, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -33134, 176182, -4221, 0, 0, 22035, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -33411, 187689, -3935, 0, 0, 45908, 35, 0, 0, 0),
-- Puncher
("gludio04_1823_12", 1, 20085, -37025, 192088, -3634, 0, 0, 15240, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -37889, 189954, -3639, 0, 0, 19442, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -35195, 184413, -3992, 0, 0, 1828, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -33093, 178593, -4221, 0, 0, 65094, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -33485, 174462, -4224, 0, 0, 32496, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -32794, 188935, -3929, 0, 0, 11068, 27, 0, 0, 0),
-- Ant Soldier
("gludio04_1823_23", 1, 20087, -36586, 184048, -3935, 0, 0, 3151, 27, 0, 0, 0),
-- Tyrant
("gludio04_1823_26", 1, 20192, -33183, 183861, -4221, 0, 0, 6023, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -33020, 177378, -4221, 0, 0, 46862, 27, 0, 0, 0),
-- Brown Bear
("gludio34_1822_01", 1, 20310, -62415, 164101, -3759, 0, 0, 5336, 21, 0, 0, 0),
-- Kuran Kobold
("gludio16_1823_33", 1, 20606, -57426, 185996, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -55058, 186496, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -54824, 186787, -4811, 0, 0, 34660, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -55560, 186347, -4811, 0, 0, 36213, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -54950, 186494, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -54274, 186872, -4811, 0, 0, 36155, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20606, -53925, 186921, -4811, 0, 0, 0, 80, 0, 0, 0),
-- Kuran Kobold Warrior
("gludio16_1823_33", 1, 20607, -57178, 186219, -4811, 0, 0, 51843, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20607, -55129, 186589, -4811, 0, 0, 38773, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20607, -55398, 186588, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_33", 1, 20607, -53790, 186948, -4811, 0, 0, 48284, 80, 0, 0, 0),
-- Patin Archer
("gludio16_1823_30", 1, 20608, -59776, 183408, -4811, 0, 0, 24146, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -59451, 183243, -4811, 0, 0, 60872, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -59521, 184466, -4811, 0, 0, 48829, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -61163, 184077, -4811, 0, 0, 1868, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -62495, 184039, -4811, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -58535, 184506, -4811, 0, 0, 10575, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -58260, 184090, -4811, 0, 0, 63863, 68, 0, 0, 0),
("gludio16_1823_30", 1, 20608, -57253, 186487, -4811, 0, 0, 30934, 68, 0, 0, 0),
-- Lakin Salamander
("gludio16_1823_21", 1, 20609, -56188, 179309, -4811, 0, 0, 6134, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -56912, 179084, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -59140, 181940, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -59260, 182457, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -59706, 183823, -4811, 0, 0, 28445, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -59514, 183198, -4811, 0, 0, 17375, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -59498, 183845, -4811, 0, 0, 40087, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -60656, 184164, -4811, 0, 0, 603, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -61913, 183575, -4811, 0, 0, 6533, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -61147, 183444, -4811, 0, 0, 32523, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -62193, 182793, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -58598, 183922, -4811, 0, 0, 22518, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -58260, 184379, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -57194, 186279, -4911, 0, 0, 16245, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20609, -57060, 186378, -4811, 0, 0, 11356, 80, 0, 0, 0),
-- Sentinel Of Water
("gludio16_1823_21", 1, 20610, -56437, 179348, -4811, 0, 0, 927, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -55389, 179235, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -59510, 180897, -4811, 0, 0, 50179, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -59547, 181520, -4811, 0, 0, 48620, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -62224, 182265, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -62224, 182621, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -58454, 182457, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -58756, 182279, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -61498, 183488, -4811, 0, 0, 31468, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -62225, 183532, -4811, 0, 0, 32901, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -61873, 184076, -4811, 0, 0, 22093, 80, 0, 0, 0),
("gludio16_1823_21", 1, 20610, -58739, 184223, -4811, 0, 0, 3214, 80, 0, 0, 0),
-- Dre Vanul Warrior
("gludio16_1823_22", 1, 20611, -59991, 181574, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -60092, 181040, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -59186, 181218, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -58863, 181297, -4811, 0, 0, 3912, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -56520, 181295, -4811, 0, 0, 97, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -57777, 181146, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -61926, 181366, -4811, 0, 0, 19984, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -60899, 181110, -4811, 0, 0, 57553, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -61923, 182799, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -62063, 182566, -4811, 0, 0, 28741, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -61366, 179920, -4811, 0, 0, 10761, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -61583, 179623, -4811, 0, 0, 33269, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -61818, 179874, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20611, -58555, 182279, -4811, 0, 0, 0, 80, 0, 0, 0),
-- Salamander Rowin
("gludio16_1823_22", 1, 20612, -59664, 181357, -4811, 0, 0, 32897, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -59690, 181040, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -59093, 180915, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -57641, 181246, -4811, 0, 0, 36259, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -58007, 181225, -4811, 0, 0, 33749, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -61395, 180962, -4811, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -61433, 181114, -4811, 0, 0, 40329, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -62143, 179645, -4811, 0, 0, 35718, 80, 0, 0, 0),
("gludio16_1823_22", 1, 20612, -61415, 179336, -4811, 0, 0, 52325, 80, 0, 0, 0),
-- Lafi Lizardman
("gludio16_1823_02", 1, 20613, -55025, 190369, -4473, 0, 0, 1465, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -55579, 190308, -4473, 0, 0, 33911, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -55997, 190804, -4520, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -55997, 190092, -4520, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -58049, 187628, -4511, 0, 0, 36022, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -57241, 188290, -4494, 0, 0, 1634, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20613, -57245, 188223, -4494, 0, 0, 2338, 80, 0, 0, 0),
-- Lafi Lizardman Scout
("gludio16_1823_02", 1, 20614, -55594, 190448, -4520, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -55795, 190448, -4520, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -57517, 188161, -4494, 0, 0, 31078, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -57447, 188283, -4494, 0, 0, 16536, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -59538, 188565, -4511, 0, 0, 16660, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -59662, 188337, -4511, 0, 0, 49371, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -58792, 188115, -4511, 0, 0, 570, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -56474, 187767, -4552, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -56373, 188301, -4552, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_02", 1, 20614, -55288, 188289, -4511, 0, 0, 64445, 80, 0, 0, 0),
-- Ritmal Swordsman
("gludio16_1823_04", 1, 20615, -58703, 188496, -4511, 0, 0, 1940, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -59458, 188142, -4511, 0, 0, 41960, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -56172, 187945, -4552, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -55312, 188129, -4511, 0, 0, 57229, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -57802, 184949, -4548, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -57410, 186591, -4511, 0, 0, 13474, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -58218, 185335, -4511, 0, 0, 32136, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -58778, 185799, -4556, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -58251, 186100, -4511, 0, 0, 33336, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -58577, 185799, -4556, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -56794, 185085, -4548, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -55879, 185716, -4511, 0, 0, 5087, 80, 0, 0, 0),
("gludio16_1823_04", 1, 20615, -56209, 186117, -4511, 0, 0, 24458, 80, 0, 0, 0),
-- Lakin Undine
("gludio16_1823_08", 1, 20616, -57400, 185534, -4512, 0, 0, 38573, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -57699, 185878, -4511, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -57392, 185712, -4511, 0, 0, 47144, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -57399, 185305, -4548, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -57387, 190067, -3570, 0, 0, 46058, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -58577, 186155, -4556, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -58970, 185319, -4517, 0, 0, 14152, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -58689, 184989, -4556, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -58686, 184625, -3203, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -56391, 185441, -4548, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -56290, 185263, -4548, 0, 0, 0, 68, 0, 0, 0),
("gludio16_1823_08", 1, 20616, -55788, 185441, -4548, 0, 0, 0, 68, 0, 0, 0),
-- Sentinel Of Water
("gludio16_1823_10", 1, 20617, -59018, 185379, -4517, 0, 0, 14497, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -58286, 185345, -4556, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55326, 183565, -4511, 0, 0, 33405, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55822, 183417, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55068, 182248, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55744, 184460, -4511, 0, 0, 65149, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55515, 184575, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_10", 1, 20617, -55596, 183876, -4512, 0, 0, 0, 80, 0, 0, 0),
-- Kanil Succubus
("gludio16_1823_12", 1, 20618, -55903, 183748, -4511, 0, 0, 15087, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -55785, 183469, -4511, 0, 0, 18035, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -55963, 180911, -4514, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -55780, 181516, -4510, 0, 0, 40960, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54991, 181305, -4510, 0, 0, 17400, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -56353, 184460, -4511, 0, 0, 41905, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54975, 183562, -4511, 0, 0, 54141, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -55993, 184451, -4511, 0, 0, 64496, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54964, 184622, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54690, 185108, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54993, 184218, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -53894, 181258, -4511, 0, 0, 49997, 80, 0, 0, 0),
("gludio16_1823_12", 1, 20618, -54321, 180889, -4592, 0, 0, 0, 80, 0, 0, 0),
-- Rowin Undine
("gludio16_1823_13", 1, 20619, -54966, 181821, -4510, 0, 0, 50710, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -55060, 181570, -4510, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -55795, 181336, -4510, 0, 0, 18920, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -54886, 184362, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -54691, 184396, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -55041, 184492, -4512, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -53616, 181067, -4592, 0, 0, 0, 80, 0, 0, 0),
("gludio16_1823_13", 1, 20619, -53844, 181994, -4551, 0, 0, 17587, 80, 0, 0, 0),
-- Gigantiops
("gludio04_1923_p15", 1, 20745, -32996, 174394, -4221, 0, 0, 47578, 55, 0, 0, 0),
-- Roxide
("gludio16_1823_p13", 1, 20747, -55793, 180617, -4517, 0, 0, 48590, 120, 0, 0, 0),
("gludio16_1823_p13", 1, 20747, -54974, 180637, -4517, 0, 0, 48998, 120, 0, 0, 0),
("gludio16_1823_p13", 1, 20747, -53853, 181390, -4551, 0, 0, 47529, 120, 0, 0, 0),
("gludio16_1823_p13", 1, 20747, -53856, 182238, -4551, 0, 0, 49829, 120, 0, 0, 0),
("gludio16_1823_p13", 1, 20747, -54922, 184531, -4511, 0, 0, 0, 120, 0, 0, 0),
-- Death Fire
("gludio16_1823_p21", 1, 20749, -56769, 179320, -4811, 0, 0, 31191, 120, 0, 0, 0),
("gludio16_1823_p21", 1, 20749, -55822, 179298, -4811, 0, 0, 35958, 120, 0, 0, 0),
("gludio16_1823_p21", 1, 20749, -57562, 181492, -4811, 0, 0, 3724, 120, 0, 0, 0),
("gludio16_1823_p21", 1, 20749, -61401, 181631, -4811, 0, 0, 15740, 120, 0, 0, 0),
("gludio16_1823_p21", 1, 20749, -61054, 179619, -4811, 0, 0, 1805, 120, 0, 0, 0),
-- Ol Mahum Van Grunt
("gludio36_1823_01", 1, 21011, -55697, 167851, -3278, 0, 0, 19066, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -55399, 168971, -3302, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -53115, 173592, -3672, 0, 0, 44310, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -53187, 168965, -3669, 0, 0, 48580, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -52928, 170780, -3656, 0, 0, 48509, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -54840, 177913, -3110, 0, 0, 11587, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -45900, 168264, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -46605, 169154, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -46001, 168442, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -45397, 169154, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -45095, 168620, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -46505, 169332, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -43060, 169480, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -42959, 169658, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -42859, 169836, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -42859, 170192, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -42557, 170370, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21011, -42859, 169124, -3111, 0, 0, 0, 25, 0, 0, 0),
-- Magical Eye
("gludio36_1823_01", 1, 21012, -52765, 175765, -3628, 0, 0, 15388, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -53704, 174241, -3629, 0, 0, 7325, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -53938, 172525, -3629, 0, 0, 62842, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -51776, 175659, -3660, 0, 0, 3097, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -60439, 174663, -3022, 0, 0, 30661, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -55840, 176228, -3368, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -53473, 179975, -3212, 0, 0, 31549, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -52485, 171820, -3722, 0, 0, 56891, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -52529, 174226, -3702, 0, 0, 14230, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -50858, 176817, -3653, 0, 0, 6640, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -56234, 180432, -3072, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -56033, 180432, -3072, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -48588, 180680, -3352, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -48891, 181926, -3352, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46456, 186606, -3392, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -44261, 189522, -3296, 0, 0, 45253, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46729, 188875, -3220, 0, 0, 32733, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -45800, 168798, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46403, 168798, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46202, 168442, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46303, 169332, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -46504, 168620, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -42658, 169124, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -42456, 170548, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -42758, 170726, -3111, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_01", 1, 21012, -42557, 169302, -3111, 0, 0, 0, 25, 0, 0, 0),
-- Ol Mahum Van Archer
("gludio36_1823_04", 1, 21013, -54707, 172409, -3629, 0, 0, 44729, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -54873, 178394, -3292, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -51030, 180253, -3162, 0, 0, 13208, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -47555, 181931, -3271, 0, 0, 48140, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -46960, 187140, -3392, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -45506, 189330, -3192, 0, 0, 7880, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -40916, 188770, -3257, 0, 0, 4132, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -44120, 192104, -2979, 0, 0, 28140, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -38746, 195058, -3371, 0, 0, 55963, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -39789, 194522, -3337, 0, 0, 56686, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -45195, 168798, -3147, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -45295, 168976, -3147, 0, 0, 0, 25, 0, 0, 0),
-- Lesser Warlike Tyrant
("gludio36_1823_04", 1, 21014, -54974, 178928, -3292, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -53373, 178876, -3087, 0, 0, 5985, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -53959, 175421, -3629, 0, 0, 25815, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -55831, 180788, -3072, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -56335, 180966, -3072, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -47983, 185355, -2975, 0, 0, 16942, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -49784, 181689, -2854, 0, 0, 33884, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -47161, 183812, -3197, 0, 0, 9184, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -47162, 187496, -3392, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -44255, 190775, -3248, 0, 0, 9757, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -46565, 185717, -3027, 0, 0, 11647, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -41488, 191990, -3237, 0, 0, 34449, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -41337, 194208, -3287, 0, 0, 22826, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -43409, 190075, -3552, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -38068, 193024, -3464, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -37537, 191645, -3636, 0, 0, 60048, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -41186, 196017, -3129, 0, 0, 58241, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -36773, 195815, -3274, 0, 0, 10077, 25, 0, 0, 0),
-- Ol Mahum Van Leader
("gludio36_1823_08", 1, 21015, -40171, 192433, -3191, 0, 0, 11778, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -40828, 191225, -3187, 0, 0, 17678, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -43007, 190431, -3552, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -38582, 193019, -3223, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -37096, 194945, -3256, 0, 0, 32835, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -37558, 193766, -3208, 0, 0, 2333, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -39351, 193199, -3212, 0, 0, 24341, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -35305, 194910, -3792, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -43797, 194999, -3201, 0, 0, 23152, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -42333, 194515, -3083, 0, 0, 27600, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -42991, 192331, -3166, 0, 0, 47711, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -38457, 196327, -3116, 0, 0, 9469, 25, 0, 0, 0),
-- Warlike Tyrant
("gludio36_1824_02", 1, 21016, -34132, 195649, -3484, 0, 0, 45749, 25, 0, 0, 0),
-- Lava Salamander
("gludio01_qm1823_01", 1, 27116, -61264, 182384, -4821, 0, 0, 0, 60, 0, 0, 0),
("gludio01_qm1823_01", 1, 27116, -61312, 182848, -4821, 0, 0, 0, 60, 0, 0, 0),
("gludio01_qm1823_01", 1, 27116, -61211, 182513, -4811, 0, 0, 26175, 60, 0, 0, 0),
("gludio01_qm1823_01", 1, 27116, -60816, 182384, -4821, 0, 0, 0, 60, 0, 0, 0),
-- Wasteland Lizardman
("gludio04_npc1823_002", 1, 30410, -45040, 179909, -3680, 0, 0, 16312, 60, 0, 0, 0),
-- Wind Sylph
("gludio04_npc1823_001", 1, 30412, -41452, 167329, -3560, 0, 0, 12288, 60, 0, 0, 0),

-- [18_24]

-- Langk Lizardman Warrior
("gludio22_1824_01", 1, 20024, -51136, 197165, -3676, 0, 0, 11419, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -52042, 197963, -3635, 0, 0, 55015, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -49086, 200929, -3461, 0, 0, 46596, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -49142, 198488, -3721, 0, 0, 54625, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -48973, 201885, -3435, 0, 0, 17898, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -39582, 202837, -2939, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -39884, 203015, -2939, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -46032, 199604, -3499, 0, 0, 52546, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20024, -46208, 199341, -3496, 0, 0, 0, 20, 0, 0, 0),
-- Langk Lizardman Scout
("gludio22_1824_01", 1, 20027, -51855, 197991, -3635, 0, 0, 12448, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20027, -52139, 200856, -3447, 0, 0, 21211, 20, 0, 0, 0),
("gludio22_1824_01", 1, 20027, -50651, 199125, -3792, 0, 0, 0, 20, 0, 0, 0),
-- Wandering Eye
("gludio35_1822_02", 1, 20055, -47739, 201625, -3808, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -47611, 197622, -3240, 0, 0, 47344, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -45499, 202177, -3638, 0, 0, 8939, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -44837, 206826, -3473, 0, 0, 17588, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -48241, 207287, -3592, 0, 0, 20901, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -43521, 204747, -3706, 0, 0, 31967, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -46126, 203318, -3718, 0, 0, 39689, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -40860, 208633, -3176, 0, 0, 44382, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -39188, 207870, -3782, 0, 0, 0, 20, 0, 0, 0),
-- Hungry Eye
("gludio35_1822_01", 1, 20059, -42349, 210640, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -42148, 211352, -3567, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -42249, 211174, -3536, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -36736, 211299, -3744, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -38157, 213074, -3693, 0, 0, 13170, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -36683, 214073, -3733, 0, 0, 6319, 20, 0, 0, 0),
-- Langk Lizardman Leader
("gludio22_1824_05", 1, 20356, -51261, 210669, -3032, 0, 0, 38807, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -50304, 212432, -3100, 0, 0, 9692, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -46296, 213910, -3490, 0, 0, 22872, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -49313, 212245, -3163, 0, 0, 2611, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -50805, 209320, -3600, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -53434, 211813, -2747, 0, 0, 19171, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -47163, 211311, -3356, 0, 0, 1754, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -45667, 211628, -3324, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -46372, 211450, -3324, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -45704, 205661, -3670, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -46972, 206767, -3437, 0, 0, 20657, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -42934, 210313, -3329, 0, 0, 2241, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -43502, 208668, -3403, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -41177, 211073, -3560, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 20356, -40976, 210717, -3504, 0, 0, 0, 20, 0, 0, 0),
-- Langk Lizardman Lieutenant
("gludio22_1824_03", 1, 20357, -46514, 202201, -3708, 0, 0, 23096, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -50351, 196941, -3719, 0, 0, 41403, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -47938, 200902, -3676, 0, 0, 41266, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -50358, 203384, -3582, 0, 0, 23813, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -45364, 203231, -3590, 0, 0, 61706, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -46528, 204623, -3801, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -44351, 205886, -3621, 0, 0, 19208, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -52875, 211582, -2758, 0, 0, 64912, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -53512, 210477, -3262, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -44404, 208346, -3413, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -40489, 206840, -3399, 0, 0, 57438, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -41861, 207834, -3137, 0, 0, 2093, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -45487, 208044, -3443, 0, 0, 61890, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -40263, 209192, -3254, 0, 0, 19514, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -37966, 209507, -3697, 0, 0, 48678, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -38642, 211824, -3700, 0, 0, 30575, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -39590, 207870, -3782, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -41846, 210462, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -41443, 210462, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -42954, 211352, -3460, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -41745, 210640, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -42652, 211886, -3648, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -36643, 205669, -3495, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -39381, 203193, -2939, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -50251, 201153, -3393, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -45927, 200876, -3654, 0, 0, 56253, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -47299, 203966, -3663, 0, 0, 52425, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -47969, 203574, -3587, 0, 0, 20389, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -43758, 209312, -3355, 0, 0, 43784, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -41177, 210717, -3560, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -40219, 214729, -3733, 0, 0, 21073, 20, 0, 0, 0),
-- Ol Mahum Deserter
("gludio35_1822_01", 1, 20548, -42163, 204856, -3530, 0, 0, 64794, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -46126, 204979, -3801, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -45019, 204445, -3801, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -46157, 207403, -3482, 0, 0, 29580, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -46661, 212816, -3425, 0, 0, 4363, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -50677, 211200, -2994, 0, 0, 6724, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -48188, 211926, -3286, 0, 0, 6787, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -50906, 209854, -3600, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -46272, 210916, -3376, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -45587, 212800, -3350, 0, 0, 18883, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -46365, 208366, -3510, 0, 0, 25092, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -44697, 209597, -3363, 0, 0, 9362, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -38393, 206469, -3478, 0, 0, 60259, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -37845, 213979, -3722, 0, 0, 3038, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -36434, 212189, -3717, 0, 0, 0, 20, 0, 0, 0),
-- Ol Mahum Van Archer
("gludio36_1823_04", 1, 21013, -37823, 197083, -2841, 0, 0, 5004, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21013, -39110, 197220, -3399, 0, 0, 0, 25, 0, 0, 0),
-- Lesser Warlike Tyrant
("gludio36_1823_04", 1, 21014, -42743, 196858, -3086, 0, 0, 10214, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -41541, 197725, -2686, 0, 0, 9322, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -38068, 199169, -2449, 0, 0, 23923, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -35105, 196746, -3804, 0, 0, 0, 25, 0, 0, 0),
-- Ol Mahum Van Leader
("gludio36_1823_08", 1, 21015, -32917, 198532, -3658, 0, 0, 12869, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -39815, 196686, -3399, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -36756, 197067, -3007, 0, 0, 22093, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -35425, 199876, -3076, 0, 0, 24119, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -33395, 201760, -3229, 0, 0, 21710, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -33663, 203488, -3113, 0, 0, 38160, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -34487, 201852, -3027, 0, 0, 22135, 25, 0, 0, 0),
-- Warlike Tyrant
("gludio36_1824_02", 1, 21016, -35506, 197458, -3804, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -33196, 196730, -3666, 0, 0, 46079, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -33755, 197330, -3583, 0, 0, 39898, 25, 0, 0, 0),
-- Langk Lizardman Sentinel
("gludio22_1824_02", 1, 21100, -51184, 200145, -3426, 0, 0, 12228, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -48558, 199837, -3632, 0, 0, 63889, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -51408, 199660, -3529, 0, 0, 11684, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -50350, 199303, -3792, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -49990, 200154, -3423, 0, 0, 11539, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -47537, 200557, -3808, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -46934, 200913, -3808, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -47868, 203324, -3587, 0, 0, 14076, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -48637, 207016, -3702, 0, 0, 21585, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -44918, 204979, -3801, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -43781, 204010, -3593, 0, 0, 4068, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -44606, 207634, -3413, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -44203, 207990, -3413, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -37146, 205491, -3495, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -36844, 206025, -3495, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -39784, 203193, -2939, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -40085, 203015, -2939, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -46087, 199767, -3499, 0, 0, 6420, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -51812, 196817, -3725, 0, 0, 37726, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -51745, 198237, -3637, 0, 0, 8403, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -52961, 202061, -3566, 0, 0, 27775, 20, 0, 0, 0),
-- Langk Lizardman Shaman
("gludio22_1824_05", 1, 21101, -49275, 211251, -3108, 0, 0, 62103, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -47763, 210332, -3321, 0, 0, 60243, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -50705, 209854, -3600, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -47633, 211662, -3330, 0, 0, 35415, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -51611, 210744, -3600, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -54102, 211622, -2663, 0, 0, 31413, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -51479, 211761, -2991, 0, 0, 65247, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -53952, 210939, -2598, 0, 0, 40537, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -46574, 211094, -3376, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -44924, 213852, -3324, 0, 0, 14071, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -46674, 211628, -3376, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -42854, 211530, -3533, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -42047, 210818, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -42148, 210640, -3344, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -42350, 211708, -3608, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -39144, 213652, -3707, 0, 0, 27132, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -34456, 211577, -3704, 0, 0, 2457, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -35585, 213715, -3720, 0, 0, 61678, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -49282, 204885, -3732, 0, 0, 18635, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -46609, 205483, -3670, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -47642, 204991, -3646, 0, 0, 39510, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -46191, 210097, -3389, 0, 0, 23678, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -45832, 211180, -3372, 0, 0, 12559, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -41076, 211607, -3560, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -41177, 211429, -3560, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -39020, 208901, -3676, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_05", 1, 21101, -38517, 208723, -3696, 0, 0, 0, 20, 0, 0, 0);
INSERT INTO `spawnlist` VALUES
-- Catacomb Barbed Bat
("NecropolisSacrifice", 1, 21139, -51898, 213064, -5090, 0, 0, 48335, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -51872, 214565, -5090, 0, 0, 20881, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -51866, 209926, -5090, 0, 0, 18155, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -51756, 212050, -5092, 0, 0, 51755, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -50398, 212042, -5092, 0, 0, 32575, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49965, 211899, -5092, 0, 0, 50090, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49767, 210039, -5111, 0, 0, 34222, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49481, 212275, -5090, 0, 0, 25337, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49467, 214567, -5092, 0, 0, 51191, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49300, 209942, -5092, 0, 0, 20877, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -49280, 214714, -5090, 0, 0, 37121, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -47432, 213411, -5092, 0, 0, 49352, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -47264, 214560, -5090, 0, 0, 20559, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -47255, 211432, -5090, 0, 0, 51582, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -47253, 209948, -5090, 0, 0, 17313, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21139, -47193, 212449, -5090, 0, 0, 12860, 120, 0, 0, 0),
-- Catacomb Wisp
("NecropolisSacrifice", 1, 21140, -52057, 212804, -5092, 0, 0, 46441, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -52054, 214735, -5090, 0, 0, 1905, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -52021, 210144, -5090, 0, 0, 4104, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -51713, 212164, -5092, 0, 0, 12622, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -50730, 212107, -5092, 0, 0, 30779, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49988, 212630, -5092, 0, 0, 20699, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49951, 214639, -5090, 0, 0, 31003, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49775, 210256, -5092, 0, 0, 18750, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49552, 214909, -5092, 0, 0, 27161, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49214, 210319, -5113, 0, 0, 45077, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -49105, 212076, -5092, 0, 0, 4450, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -47490, 214712, -5090, 0, 0, 26443, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -47370, 212713, -5092, 0, 0, 30733, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -47287, 213101, -5090, 0, 0, 43240, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -47056, 210123, -5090, 0, 0, 2677, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21140, -47049, 211222, -5090, 0, 0, 37506, 120, 0, 0, 0),
-- Catacomb Serpent
("NecropolisSacrifice", 1, 21141, -52053, 217346, -5092, 0, 0, 8529, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -52040, 217905, -5092, 0, 0, 31216, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -51869, 220626, -5090, 0, 0, 47854, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -51682, 215816, -5090, 0, 0, 1723, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -50800, 219909, -5092, 0, 0, 32520, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -50714, 216731, -5090, 0, 0, 19740, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -50594, 217826, -5090, 0, 0, 16564, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -50485, 219003, -5092, 0, 0, 49419, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -50460, 219767, -5092, 0, 0, 53877, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -49972, 216023, -5092, 0, 0, 32050, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -49375, 215972, -5092, 0, 0, 19896, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -48958, 218741, -5092, 0, 0, 21717, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -48675, 217393, -5092, 0, 0, 34490, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -48218, 216944, -5092, 0, 0, 48177, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -48211, 218682, -5092, 0, 0, 9590, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -47262, 220178, -5090, 0, 0, 44315, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -47262, 215990, -5111, 0, 0, 53068, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21141, -47230, 217438, -5092, 0, 0, 23501, 120, 0, 0, 0),
-- Grave Keeper Spartoi
("NecropolisSacrifice", 1, 21142, -52058, 220435, -5090, 0, 0, 6371, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -52028, 217657, -5092, 0, 0, 17937, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -51968, 216985, -5092, 0, 0, 55063, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -51871, 216034, -5111, 0, 0, 19740, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -50993, 219787, -5092, 0, 0, 35261, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -50881, 216941, -5090, 0, 0, 4489, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -50779, 220487, -5092, 0, 0, 47769, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -50707, 218990, -5092, 0, 0, 51707, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -50588, 218347, -5090, 0, 0, 16575, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -49595, 215997, -5092, 0, 0, 13607, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -48998, 216043, -5090, 0, 0, 577, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -48899, 218408, -5113, 0, 0, 788, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -48438, 218632, -5090, 0, 0, 1314, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -47980, 217419, -5092, 0, 0, 29625, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -47498, 217602, -5092, 0, 0, 14185, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -47455, 220397, -5090, 0, 0, 25851, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -47258, 215632, -5090, 0, 0, 44897, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21142, -47170, 217160, -5113, 0, 0, 43230, 120, 0, 0, 0),
-- Lith Scout
("NecropolisSacrifice", 1, 21166, -46359, 214732, -5090, 0, 0, 35778, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -46171, 210431, -5090, 0, 0, 16619, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -46044, 212966, -5092, 0, 0, 64211, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -45009, 213292, -5092, 0, 0, 24217, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -44543, 211352, -5092, 0, 0, 15271, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -44475, 211060, -5092, 0, 0, 19004, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -44214, 210641, -5092, 0, 0, 13701, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -44098, 213568, -5090, 0, 0, 50755, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -44081, 214072, -5090, 0, 0, 7985, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -43084, 210161, -5090, 0, 0, 19832, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -42931, 211440, -5090, 0, 0, 5596, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -42868, 210757, -5092, 0, 0, 62817, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -42078, 213287, -5092, 0, 0, 51284, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -41825, 214740, -5090, 0, 0, 35248, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21166, -41305, 213677, -5092, 0, 0, 36708, 120, 0, 0, 0),
-- Lith Witch
("NecropolisSacrifice", 1, 21167, -46201, 216009, -5090, 0, 0, 10501, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -46177, 220625, -5090, 0, 0, 50555, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -45861, 217434, -5092, 0, 0, 3666, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -45584, 217104, -5092, 0, 0, 61931, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -44527, 215740, -5090, 0, 0, 37604, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -44077, 215621, -5092, 0, 0, 31921, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -43689, 218269, -5090, 0, 0, 19287, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -43590, 219772, -5090, 0, 0, 14274, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -43274, 218715, -5092, 0, 0, 54046, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -42663, 216725, -5092, 0, 0, 16652, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -42628, 215753, -5092, 0, 0, 63170, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -42378, 218663, -5092, 0, 0, 24844, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -41575, 220155, -5090, 0, 0, 49152, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -41454, 218483, -5090, 0, 0, 30611, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21167, -41434, 215834, -5090, 0, 0, 36736, 120, 0, 0, 0),
-- Lith Warrior
("NecropolisSacrifice", 1, 21168, -52012, 212407, -5092, 0, 0, 58038, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -51884, 214939, -5090, 0, 0, 12603, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -51877, 210329, -5090, 0, 0, 15087, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -51673, 212538, -5092, 0, 0, 63963, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -50492, 212365, -5092, 0, 0, 22909, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -50250, 212549, -5092, 0, 0, 17424, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -50050, 214872, -5113, 0, 0, 31520, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -49654, 212156, -5090, 0, 0, 58465, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -49448, 210267, -5113, 0, 0, 28726, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -48987, 214769, -5090, 0, 0, 33645, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -48867, 210014, -5090, 0, 0, 36790, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -47369, 212899, -5092, 0, 0, 33942, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -47289, 214907, -5090, 0, 0, 18940, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -47272, 210309, -5090, 0, 0, 48390, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -47268, 211039, -5090, 0, 0, 13962, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21168, -47034, 212908, -5092, 0, 0, 16512, 120, 0, 0, 0),
-- Lith Guard
("NecropolisSacrifice", 1, 21169, -52063, 215811, -5090, 0, 0, 62345, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -51877, 220156, -5090, 0, 0, 49386, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -51793, 217028, -5090, 0, 0, 52803, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -51696, 217674, -5092, 0, 0, 37055, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50817, 219348, -5092, 0, 0, 16008, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50708, 217119, -5090, 0, 0, 58341, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50614, 220180, -5090, 0, 0, 52650, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50383, 218040, -5090, 0, 0, 37145, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50350, 220459, -5113, 0, 0, 49334, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -50023, 216226, -5090, 0, 0, 27875, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -49464, 216259, -5092, 0, 0, 33256, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -49255, 218533, -5090, 0, 0, 4681, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -48306, 217163, -5090, 0, 0, 43636, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -48280, 218444, -5090, 0, 0, 60327, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -47859, 217108, -5092, 0, 0, 16848, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -47533, 217252, -5090, 0, 0, 33409, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -47266, 220622, -5090, 0, 0, 51244, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21169, -47072, 215813, -5090, 0, 0, 1383, 120, 0, 0, 0),
-- Gigant Slave
("NecropolisSacrifice", 1, 21187, -46181, 214527, -5090, 0, 0, 46134, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -45949, 210123, -5090, 0, 0, 35622, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -45657, 213175, -5090, 0, 0, 1259, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -45469, 212943, -5092, 0, 0, 50306, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -44693, 210974, -5113, 0, 0, 38017, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -44533, 210449, -5092, 0, 0, 509, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -44335, 211333, -5090, 0, 0, 13689, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -43957, 214421, -5090, 0, 0, 47497, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -43894, 213607, -5092, 0, 0, 43902, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -43151, 211659, -5092, 0, 0, 14280, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -42846, 210208, -5092, 0, 0, 15836, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -42770, 211096, -5092, 0, 0, 60934, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -42350, 213617, -5092, 0, 0, 27954, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -41574, 214946, -5090, 0, 0, 9673, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21187, -41495, 213483, -5090, 0, 0, 35362, 120, 0, 0, 0),
-- Gigant Acolyte
("NecropolisSacrifice", 1, 21188, -46275, 217051, -5092, 0, 0, 52324, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -46161, 215586, -5111, 0, 0, 43807, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -46156, 220222, -5090, 0, 0, 41147, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -45288, 217318, -5090, 0, 0, 62397, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -44059, 219142, -5092, 0, 0, 40354, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -44004, 216012, -5092, 0, 0, 11616, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -43858, 218436, -5092, 0, 0, 3171, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -43746, 215654, -5092, 0, 0, 30465, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -43675, 218796, -5090, 0, 0, 56434, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -42443, 216466, -5090, 0, 0, 16716, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -42329, 215760, -5092, 0, 0, 61140, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -42191, 218372, -5092, 0, 0, 50019, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -41761, 215792, -5090, 0, 0, 27894, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -41700, 218748, -5092, 0, 0, 9923, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21188, -41613, 220586, -5090, 0, 0, 40884, 120, 0, 0, 0),
-- Gigant Overseer
("NecropolisSacrifice", 1, 21189, -51955, 212073, -5090, 0, 0, 49789, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -51739, 212822, -5092, 0, 0, 44237, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -51576, 214734, -5090, 0, 0, 65423, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -51565, 210129, -5090, 0, 0, 65259, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -50795, 212325, -5092, 0, 0, 35434, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -50216, 212171, -5090, 0, 0, 61757, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -49782, 214749, -5090, 0, 0, 47247, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -49315, 210109, -5090, 0, 0, 37328, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -49281, 214570, -5113, 0, 0, 52087, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -49200, 212318, -5092, 0, 0, 222, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -49083, 210322, -5092, 0, 0, 15772, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -47440, 210122, -5090, 0, 0, 30536, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -47424, 211215, -5090, 0, 0, 33758, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -47111, 214739, -5090, 0, 0, 63418, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -47101, 213449, -5090, 0, 0, 58661, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21189, -47009, 212633, -5092, 0, 0, 38963, 120, 0, 0, 0),
-- Gigant Footman
("NecropolisSacrifice", 1, 21190, -51874, 215665, -5090, 0, 0, 49723, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -51759, 218085, -5092, 0, 0, 17865, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -51711, 217426, -5092, 0, 0, 12807, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -51690, 220430, -5090, 0, 0, 34796, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -50968, 219574, -5092, 0, 0, 34241, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -50777, 218029, -5090, 0, 0, 2953, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -50590, 219375, -5111, 0, 0, 43064, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -50398, 216943, -5090, 0, 0, 62944, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -50196, 220004, -5092, 0, 0, 4636, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -49696, 216226, -5111, 0, 0, 31901, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -49042, 216247, -5090, 0, 0, 1868, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -48822, 218739, -5092, 0, 0, 15797, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -48650, 217164, -5090, 0, 0, 35192, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -48583, 218406, -5092, 0, 0, 63868, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -48033, 217309, -5090, 0, 0, 35338, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -47634, 217668, -5092, 0, 0, 23051, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -47581, 215822, -5090, 0, 0, 33449, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21190, -47021, 220433, -5090, 0, 0, 628, 120, 0, 0, 0),
-- Hallowed Watchman
("NecropolisSacrifice", 1, 21208, -46179, 209937, -5090, 0, 0, 19740, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -45989, 214731, -5090, 0, 0, 33331, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -45506, 213315, -5113, 0, 0, 17828, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -45097, 213048, -5090, 0, 0, 33853, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -44467, 210716, -5113, 0, 0, 23923, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -44424, 211621, -5090, 0, 0, 16491, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -44279, 214629, -5092, 0, 0, 55966, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -44200, 210128, -5092, 0, 0, 4023, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -43800, 213903, -5092, 0, 0, 61921, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -43168, 210725, -5092, 0, 0, 58498, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -43050, 211305, -5111, 0, 0, 16677, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -42621, 211012, -5092, 0, 0, 4385, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -41898, 213525, -5090, 0, 0, 55013, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -41895, 213305, -5092, 0, 0, 55592, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21208, -41377, 214764, -5090, 0, 0, 14979, 120, 0, 0, 0),
-- Hallowed Seer
("NecropolisSacrifice", 1, 21209, -46370, 210130, -5090, 0, 0, 33190, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -46179, 214955, -5090, 0, 0, 16930, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -45332, 213302, -5113, 0, 0, 14604, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -45315, 212955, -5092, 0, 0, 47074, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -44713, 211124, -5113, 0, 0, 39683, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -44449, 210157, -5090, 0, 0, 15002, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -44255, 211605, -5090, 0, 0, 15733, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -44072, 213793, -5090, 0, 0, 6889, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -43798, 214151, -5092, 0, 0, 2694, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -43170, 211027, -5092, 0, 0, 2457, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -42905, 211587, -5113, 0, 0, 18658, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -42622, 210892, -5092, 0, 0, 1610, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -42241, 213407, -5090, 0, 0, 34143, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -42127, 213539, -5090, 0, 0, 48624, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21209, -41576, 214610, -5090, 0, 0, 29342, 120, 0, 0, 0),
-- Vault Guardian
("NecropolisSacrifice", 1, 21210, -46105, 217025, -5092, 0, 0, 53314, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -45927, 220416, -5090, 0, 0, 114, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -45879, 215821, -5090, 0, 0, 65438, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -45642, 217464, -5092, 0, 0, 23776, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -44534, 215905, -5090, 0, 0, 31410, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -43630, 218956, -5090, 0, 0, 20087, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -43515, 219497, -5113, 0, 0, 14724, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -43483, 215896, -5090, 0, 0, 44789, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -43342, 218501, -5092, 0, 0, 1754, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -42613, 216424, -5090, 0, 0, 2439, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -42341, 215910, -5092, 0, 0, 64538, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -42093, 218577, -5090, 0, 0, 47910, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -42015, 218370, -5092, 0, 0, 51285, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -41569, 215568, -5090, 0, 0, 49430, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21210, -41374, 220434, -5090, 0, 0, 40653, 120, 0, 0, 0),
-- Vault Seer
("NecropolisSacrifice", 1, 21211, -46399, 220411, -5090, 0, 0, 25897, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -46390, 215804, -5090, 0, 0, 30452, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -46197, 217310, -5090, 0, 0, 60345, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -45271, 217136, -5090, 0, 0, 58609, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -44351, 215836, -5090, 0, 0, 28518, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -44078, 218883, -5092, 0, 0, 23676, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -43745, 216020, -5092, 0, 0, 22518, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -43736, 219741, -5090, 0, 0, 17720, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -43701, 219274, -5090, 0, 0, 28730, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -42458, 216669, -5090, 0, 0, 16175, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -42452, 218473, -5090, 0, 0, 32832, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -42432, 216130, -5090, 0, 0, 55621, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -41740, 220408, -5090, 0, 0, 35213, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -41585, 216011, -5090, 0, 0, 8133, 120, 0, 0, 0),
("NecropolisSacrifice", 1, 21211, -41511, 218749, -5092, 0, 0, 22424, 120, 0, 0, 0),
-- Harak
("gludio22_npc1824_001", 1, 30618, -55217, 200628, -3724, 0, 0, 28672, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq01_npc1824_02", 1, 31095, -41568, 209344, -5085, 0, 0, 49000, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq01_npc1824_01", 1, 31103, -41568, 210128, -5088, 0, 0, 16500, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq01_npc1824_03", 1, 31494, -41251, 209886, -5085, 0, 0, 32000, 60, 0, 0, 0),

-- [18_25]

-- Ingenious Contraption
("tower_of_naia_room_1", 1, 18494, -46200, 246120, -9120, 0, 0, 0, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_2", 1, 18495, -48148, 249165, -9120, 0, 0, 32768, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_3", 1, 18496, -51625, 246509, -9984, 0, 0, -16384, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_4", 1, 18497, -49749, 243406, -9984, 0, 0, 0, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_5", 1, 18498, -46185, 245905, -9984, 0, 0, 16380, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_6", 1, 18499, -48682, 248290, -9984, 0, 0, 32768, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_7", 1, 18500, -51633, 246339, -10848, 0, 0, -16384, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_8", 1, 18501, -49150, 243968, -10848, 0, 0, 0, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_9", 1, 18502, -46227, 245908, -11704, 0, 0, 16384, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_10", 1, 18503, -48706, 248287, -11712, 0, 0, 32768, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_11", 1, 18504, -51630, 246340, -12568, 0, 0, -16384, 10, 0, 0, 0),
-- Ingenious Contraption
("tower_of_naia_room_12", 1, 18505, -48537, 243648, -13376, 0, 0, -13094, 10, 0, 0, 0),
-- Old Dwarven Ghost
("tower_of_naia", 1, 32370, -45531, 245872, -14192, 0, 0, 49151, 60, 0, 0, 0),

-- [19_10]

-- Purgatory Wisp
("ApostateCatacomb", 1, 21152, -14450, -246403, -8168, 0, 0, 45290, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -14322, -250797, -8168, 0, 0, 20111, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -13968, -247830, -8168, 0, 0, 1355, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -13611, -247620, -8168, 0, 0, 20691, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -13057, -250019, -8170, 0, 0, 35799, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -12909, -249478, -8170, 0, 0, 46452, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -12525, -246251, -8170, 0, 0, 47997, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -12511, -249997, -8170, 0, 0, 18274, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -12188, -247046, -8170, 0, 0, 7498, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -11306, -249726, -8168, 0, 0, 23480, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -11291, -250589, -8168, 0, 0, 23314, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -11034, -250056, -8170, 0, 0, 9687, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -10224, -247600, -8191, 0, 0, 49976, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -9951, -245962, -8168, 0, 0, 13775, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -9904, -251021, -8168, 0, 0, 16025, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21152, -9710, -247307, -8170, 0, 0, 30150, 120, 0, 0, 0),
-- Purgatory Serpent
("ApostateCatacomb", 1, 21153, -14685, -246187, -8168, 0, 0, 23324, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -14519, -250972, -8168, 0, 0, 15332, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -13857, -247659, -8170, 0, 0, 15946, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -13426, -247902, -8170, 0, 0, 29174, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -13071, -249846, -8170, 0, 0, 35706, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -12832, -249244, -8170, 0, 0, 14971, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -12503, -247001, -8170, 0, 0, 52412, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -12464, -250462, -8170, 0, 0, 16576, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -12236, -246800, -8170, 0, 0, 63890, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -11475, -249903, -8170, 0, 0, 64122, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -11244, -249353, -8168, 0, 0, 15151, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -11161, -250755, -8170, 0, 0, 11548, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -10435, -247599, -8170, 0, 0, 56346, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -10255, -247252, -8170, 0, 0, 32640, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -10210, -246168, -8168, 0, 0, 33108, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21153, -10111, -250766, -8168, 0, 0, 22195, 120, 0, 0, 0),
-- Hell Keeper Medusa
("ApostateCatacomb", 1, 21154, -14603, -243274, -8168, 0, 0, 43361, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -14530, -245303, -8168, 0, 0, 55576, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -14378, -242882, -8170, 0, 0, 5637, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -14355, -240478, -8168, 0, 0, 31446, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -12315, -244967, -8170, 0, 0, 62847, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -12236, -243040, -8170, 0, 0, 40514, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -12163, -245171, -8168, 0, 0, 61591, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -11915, -243919, -8168, 0, 0, 46737, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -11865, -242373, -8168, 0, 0, 7970, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -10999, -240785, -8168, 0, 0, 48914, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -10123, -242255, -8170, 0, 0, 33873, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -9763, -242840, -8168, 0, 0, 55485, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -9757, -245084, -8168, 0, 0, 31176, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21154, -9698, -240475, -8168, 0, 0, 32165, 120, 0, 0, 0),
-- Purgatory Conjurer
("ApostateCatacomb", 1, 21155, -14704, -242604, -8170, 0, 0, 43653, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -14656, -245125, -8168, 0, 0, 33966, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -14592, -240315, -8168, 0, 0, 32475, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -14382, -243221, -8170, 0, 0, 47831, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -12572, -245000, -8168, 0, 0, 5762, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -12080, -242579, -8191, 0, 0, 17292, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -12070, -244976, -8170, 0, 0, 18608, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -11926, -242736, -8168, 0, 0, 46893, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -11786, -243143, -8170, 0, 0, 62391, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -11251, -240517, -8168, 0, 0, 26057, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -10143, -242620, -8170, 0, 0, 23031, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -9937, -240315, -8168, 0, 0, 48015, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -9923, -244912, -8168, 0, 0, 13600, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21155, -9912, -242636, -8168, 0, 0, 38418, 120, 0, 0, 0),
-- Lilim Magus
("ApostateCatacomb", 1, 21176, -20295, -249596, -8168, 0, 0, 50507, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -20230, -248740, -8168, 0, 0, 15658, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -20200, -245887, -8168, 0, 0, 16384, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -19307, -246781, -8168, 0, 0, 36009, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -19051, -247406, -8170, 0, 0, 56898, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -18934, -248417, -8189, 0, 0, 17941, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -18876, -249668, -8168, 0, 0, 1840, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -18729, -247039, -8168, 0, 0, 8827, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -18472, -250400, -8168, 0, 0, 37365, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -17467, -250325, -8170, 0, 0, 30835, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -17106, -247908, -8170, 0, 0, 24576, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -16762, -248172, -8170, 0, 0, 56189, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -16364, -249287, -8189, 0, 0, 40922, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -15995, -248993, -8170, 0, 0, 16231, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -15887, -250765, -8168, 0, 0, 32025, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -15643, -249525, -8170, 0, 0, 33193, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21176, -15311, -246176, -8168, 0, 0, 1022, 120, 0, 0, 0),
-- Lilim Knight-Errant
("ApostateCatacomb", 1, 21177, -20385, -240533, -8168, 0, 0, 52382, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -20203, -244819, -8168, 0, 0, 16265, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -19523, -241922, -8170, 0, 0, 22733, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -19210, -242075, -8168, 0, 0, 32202, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -18707, -244362, -8191, 0, 0, 32002, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -18563, -244026, -8170, 0, 0, 39492, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -18171, -244623, -8170, 0, 0, 14727, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -18162, -241281, -8170, 0, 0, 51588, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -17897, -241071, -8170, 0, 0, 61854, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -17250, -243895, -8170, 0, 0, 23355, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -17034, -244768, -8168, 0, 0, 15126, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -16879, -244352, -8191, 0, 0, 13829, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -16381, -241872, -8191, 0, 0, 30408, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -15906, -241706, -8168, 0, 0, 31746, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -15815, -240503, -8168, 0, 0, 31152, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21177, -15773, -245084, -8168, 0, 0, 59047, 120, 0, 0, 0),
-- Lilim Marauder
("ApostateCatacomb", 1, 21178, -14785, -250778, -8168, 0, 0, 32606, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -14504, -245900, -8168, 0, 0, 16304, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -14211, -247651, -8170, 0, 0, 60340, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -13819, -247965, -8170, 0, 0, 48597, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -12717, -249688, -8168, 0, 0, 56519, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -12608, -249305, -8170, 0, 0, 20942, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -12485, -250764, -8170, 0, 0, 8414, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -12466, -247344, -8168, 0, 0, 51279, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -12226, -246367, -8170, 0, 0, 47330, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -11502, -250338, -8170, 0, 0, 6037, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -11433, -249281, -8168, 0, 0, 18495, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -11034, -249697, -8170, 0, 0, 57634, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -10786, -247516, -8168, 0, 0, 40747, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -9915, -247544, -8170, 0, 0, 25241, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -9903, -246383, -8168, 0, 0, 17782, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21178, -9895, -250479, -8168, 0, 0, 15915, 120, 0, 0, 0),
-- Lilim Priest
("ApostateCatacomb", 1, 21179, -14659, -242911, -8170, 0, 0, 50333, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -14525, -240715, -8168, 0, 0, 48735, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -14503, -244771, -8168, 0, 0, 16384, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -14349, -242512, -8170, 0, 0, 4370, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -12846, -244909, -8170, 0, 0, 57344, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -12251, -243288, -8170, 0, 0, 28075, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -11858, -244992, -8168, 0, 0, 405, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -11824, -243494, -8170, 0, 0, 44937, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -11648, -242949, -8170, 0, 0, 63292, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -10786, -240451, -8168, 0, 0, 59059, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -9925, -240780, -8168, 0, 0, 48351, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -9892, -245388, -8168, 0, 0, 47236, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -9863, -242055, -8168, 0, 0, 50115, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21179, -9819, -243050, -8168, 0, 0, 50643, 120, 0, 0, 0),
-- Nephilim Priest
("ApostateCatacomb", 1, 21197, -20210, -249370, -8168, 0, 0, 51676, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -19248, -246957, -8170, 0, 0, 40501, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -19027, -249460, -8168, 0, 0, 62910, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -18930, -246709, -8168, 0, 0, 12601, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -18795, -248476, -8170, 0, 0, 15852, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -18670, -246399, -8170, 0, 0, 58997, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -17792, -250585, -8170, 0, 0, 63875, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -17591, -247979, -8168, 0, 0, 60534, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -17294, -250357, -8170, 0, 0, 63090, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -16607, -249424, -8168, 0, 0, 37881, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -16574, -248167, -8170, 0, 0, 53066, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -16163, -249215, -8168, 0, 0, 28692, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -15619, -246377, -8189, 0, 0, 55991, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -15603, -250990, -8168, 0, 0, 15658, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -15573, -249312, -8168, 0, 0, 34788, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -20394, -246190, -8168, 0, 0, 63227, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21197, -20348, -248648, -8170, 0, 0, 16232, 120, 0, 0, 0),
-- Nephilim Swordsman
("ApostateCatacomb", 1, 21198, -20219, -240740, -8168, 0, 0, 48225, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -20014, -245052, -8168, 0, 0, 32592, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -19605, -242118, -8168, 0, 0, 3168, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -19331, -241886, -8191, 0, 0, 19966, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -18732, -244028, -8170, 0, 0, 39648, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -18378, -243837, -8168, 0, 0, 24751, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -18218, -245016, -8170, 0, 0, 17010, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -18190, -240908, -8170, 0, 0, 54639, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -17883, -241278, -8170, 0, 0, 55891, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -17046, -244005, -8168, 0, 0, 18355, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -16890, -244991, -8170, 0, 0, 8070, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -16720, -244464, -8170, 0, 0, 11458, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -16471, -241682, -8168, 0, 0, 27015, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -15619, -240628, -8168, 0, 0, 13870, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -15614, -244881, -8189, 0, 0, 25028, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21198, -15436, -241896, -8170, 0, 0, 33070, 120, 0, 0, 0),
-- Nephilim Guard
("ApostateCatacomb", 1, 21199, -14530, -250594, -8168, 0, 0, 11498, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -14334, -247904, -8170, 0, 0, 52342, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -14330, -246171, -8168, 0, 0, 38795, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -13627, -247979, -8170, 0, 0, 53626, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -12894, -250446, -8170, 0, 0, 16666, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -12821, -250051, -8191, 0, 0, 43872, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -12534, -246508, -8170, 0, 0, 50894, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -12492, -249604, -8170, 0, 0, 15761, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -12276, -247359, -8168, 0, 0, 48609, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -11486, -250716, -8170, 0, 0, 59814, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -11274, -249945, -8168, 0, 0, 18318, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -11173, -250405, -8168, 0, 0, 10023, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -10737, -247331, -8191, 0, 0, 32989, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -10017, -247248, -8170, 0, 0, 27537, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -9746, -246115, -8168, 0, 0, 16881, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21199, -9701, -250730, -8168, 0, 0, 20449, 120, 0, 0, 0),
-- Nephilim Bishop
("ApostateCatacomb", 1, 21200, -14755, -240482, -8189, 0, 0, 24509, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -14548, -242336, -8168, 0, 0, 50009, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -14389, -245094, -8168, 0, 0, 33272, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -14296, -242649, -8170, 0, 0, 63638, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -12902, -245125, -8168, 0, 0, 63035, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -12293, -243478, -8170, 0, 0, 24428, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -12111, -243848, -8170, 0, 0, 51031, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -12006, -243309, -8168, 0, 0, 16672, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -11765, -245162, -8189, 0, 0, 54373, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -11022, -240291, -8168, 0, 0, 12357, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -10093, -240535, -8168, 0, 0, 44162, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -10058, -245142, -8168, 0, 0, 23984, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -10017, -243050, -8170, 0, 0, 52377, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21200, -9752, -242286, -8170, 0, 0, 52708, 120, 0, 0, 0),
-- Crypt Archon
("ApostateCatacomb", 1, 21244, -20102, -249591, -8168, 0, 0, 52588, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -20020, -246136, -8168, 0, 0, 30263, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -20014, -249070, -8170, 0, 0, 57588, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -19113, -248602, -8168, 0, 0, 59800, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -19044, -249860, -8168, 0, 0, 63071, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -18894, -247327, -8168, 0, 0, 52845, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -18889, -246366, -8168, 0, 0, 48033, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -18572, -246677, -8170, 0, 0, 9074, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -18478, -250541, -8189, 0, 0, 42219, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -18114, -250580, -8170, 0, 0, 59576, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -17569, -248247, -8170, 0, 0, 14962, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -17319, -247873, -8170, 0, 0, 23243, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -16983, -249494, -8170, 0, 0, 28393, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -16468, -249710, -8191, 0, 0, 40795, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -15793, -249008, -8191, 0, 0, 18403, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -15566, -245951, -8168, 0, 0, 23988, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21244, -15391, -250782, -8168, 0, 0, 652, 120, 0, 0, 0),
-- Crypt Inquisitor
("ApostateCatacomb", 1, 21245, -20349, -249053, -8170, 0, 0, 63040, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -20171, -246385, -8168, 0, 0, 43466, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -20105, -248571, -8170, 0, 0, 16323, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -19185, -249643, -8189, 0, 0, 4573, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -19101, -246125, -8170, 0, 0, 49026, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -19017, -247004, -8189, 0, 0, 24576, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -18911, -248704, -8168, 0, 0, 13182, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -18803, -247561, -8170, 0, 0, 53163, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -17955, -250329, -8170, 0, 0, 32930, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -17319, -250557, -8168, 0, 0, 0, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -17040, -248125, -8168, 0, 0, 64856, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -17030, -249238, -8170, 0, 0, 27549, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -16750, -247977, -8168, 0, 0, 1593, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -16673, -249734, -8191, 0, 0, 49873, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -16074, -249536, -8170, 0, 0, 29442, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -15801, -246149, -8168, 0, 0, 39470, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21245, -15591, -250569, -8168, 0, 0, 46077, 120, 0, 0, 0),
-- Tomb Archon
("ApostateCatacomb", 1, 21246, -20200, -245240, -8168, 0, 0, 57840, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -20038, -240523, -8189, 0, 0, 49605, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -19883, -241964, -8170, 0, 0, 59402, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -19593, -242250, -8170, 0, 0, 52265, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -18572, -244709, -8170, 0, 0, 14451, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -18502, -243678, -8170, 0, 0, 16021, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -18195, -244392, -8170, 0, 0, 17870, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -18182, -241642, -8170, 0, 0, 57849, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -17917, -240766, -8170, 0, 0, 41869, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -17210, -244218, -8170, 0, 0, 7533, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -16959, -243689, -8168, 0, 0, 15499, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -16771, -244114, -8170, 0, 0, 1448, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -16271, -241716, -8168, 0, 0, 38733, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -15946, -241931, -8170, 0, 0, 56890, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -15594, -245313, -8189, 0, 0, 49700, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21246, -15356, -240479, -8168, 0, 0, 63588, 120, 0, 0, 0),
-- Tomb Inquisitor
("ApostateCatacomb", 1, 21247, -20332, -245120, -8168, 0, 0, 58243, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -20201, -240400, -8168, 0, 0, 48531, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -19930, -242206, -8191, 0, 0, 55362, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -19366, -242234, -8170, 0, 0, 55230, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -18440, -245027, -8168, 0, 0, 8192, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -18282, -243632, -8168, 0, 0, 17052, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -18221, -244104, -8170, 0, 0, 17107, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -18048, -240519, -8168, 0, 0, 36818, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -17934, -241578, -8170, 0, 0, 47308, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -17201, -244938, -8170, 0, 0, 1808, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -17098, -243705, -8168, 0, 0, 21525, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -17049, -244485, -8168, 0, 0, 17555, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -16088, -241929, -8170, 0, 0, 46910, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -15626, -241643, -8168, 0, 0, 12256, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -15584, -240305, -8168, 0, 0, 49416, 120, 0, 0, 0),
("ApostateCatacomb", 1, 21247, -15373, -245102, -8168, 0, 0, 6499, 120, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq11_npc2220_01", 1, 31122, -20208, -250784, -8161, 0, 0, 0, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq11_npc2220_03", 1, 31499, -20429, -251079, -8160, 0, 0, 16000, 60, 0, 0, 0),

-- [19_13]

-- Grizzly
("Orc_Village", 1, 20143, -18546, -132217, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -18256, -132048, -2184, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -18401, -133231, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15677, -131850, -1856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15796, -131850, -1856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15915, -131556, -1944, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -13259, -131780, -2864, 0, 0, 64182, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -10895, -132320, -2872, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -11683, -132644, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -11683, -133292, -2736, 0, 0, 0, 21, 0, 0, 0),
-- Rakeclaw Imp Hunter
("Orc_Village", 1, 20312, -21754, -131416, -664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -23374, -132336, -696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -23239, -131600, -664, 0, 0, 0, 20, 0, 0, 0),
-- Darkwing Bat
("Orc_Village", 1, 20316, -18256, -131372, -2048, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -19561, -131710, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -17821, -132724, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -18981, -134245, -2176, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -16034, -132928, -1568, 0, 0, 36727, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -16272, -132438, -1736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -15677, -132732, -1600, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -13259, -131888, -2888, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -12668, -131672, -2824, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -12374, -137236, -2520, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -11289, -132968, -2800, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -12135, -138402, -2216, 0, 0, 4642, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -10244, -138772, -1880, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -9818, -138004, -2032, 0, 0, 0, 21, 0, 0, 0),
-- Goblin Tomb Raider Leader
("Orc_Village", 1, 20320, -13456, -132104, -2928, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -13259, -132968, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -12668, -132428, -2960, 0, 0, 49297, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -4230, -134958, -2600, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -6911, -134705, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -7294, -134199, -2808, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -1932, -134958, -2888, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -2698, -133693, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5762, -131922, -2984, 0, 0, 0, 21, 0, 0, 0),
-- Greystone Golem
("Orc_Village", 1, 20333, -5379, -134199, -2784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -6911, -131922, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -2698, -134705, -2832, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -3847, -133187, -2776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -1549, -131922, -2696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -1166, -131416, -2624, 0, 0, 0, 21, 0, 0, 0),
-- Maraku Werewolf
("Orc_Village", 1, 20363, -19773, -136952, -1440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -16618, -135608, -856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -14880, -136644, -1080, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -14880, -136792, -1104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -17907, -137617, -1472, 0, 0, 34078, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -19332, -138272, -1616, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -11522, -137748, -2312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -11948, -137748, -2344, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -8540, -139028, -1456, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -9818, -138772, -1848, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -10457, -139540, -1768, 0, 0, 0, 21, 0, 0, 0),
-- Maraku Werewolf Chieftain
("Orc_Village", 1, 20364, -6152, -133156, -2848, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -6544, -133458, -2856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -5466, -133307, -2800, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -2646, -134928, -2848, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -3009, -134400, -2776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -2767, -133696, -2792, 0, 0, 43027, 21, 0, 0, 0),
-- Mountain Fungus
("Orc_Village", 1, 20365, -22024, -132520, -776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -15196, -135904, -1040, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -14880, -136200, -1032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -15196, -137680, -1064, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -19479, -137480, -1512, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -19038, -137348, -1480, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -19185, -138536, -1648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -24049, -131876, -672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -23644, -131324, -664, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye
("Orc_Village", 1, 20426, -17105, -131556, -1992, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -16748, -131752, -1912, 0, 0, 37011, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -16510, -131458, -1960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -18256, -132893, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -18981, -133231, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -10883, -135956, -2624, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -10457, -136212, -2592, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -12161, -139284, -1968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -10883, -139796, -1752, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye Patroller
("Orc_Village", 1, 20428, -5379, -133946, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -7294, -132681, -2912, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -6528, -132428, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -3081, -135211, -2696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -4996, -131922, -2952, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -4613, -131922, -2968, 0, 0, 0, 21, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, -12047, -139035, -2048, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -6634, -132558, -2984, 0, 0, 0, 60, 0, 0, 0),

-- [19_14]

-- Grizzly
("Orc_Village", 1, 20143, -19372, -130406, -2120, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -18670, -130568, -2032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -19138, -129758, -2040, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -14980, -129366, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15340, -129831, -2976, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -16515, -124139, -2056, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15060, -127064, -1712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15351, -127064, -1704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -15933, -125039, -1880, 0, 0, 4347, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -12495, -130450, -2696, 0, 0, 32486, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -12844, -129804, -2688, 0, 0, 24331, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -13896, -124139, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -21290, -107592, -2152, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -23187, -104732, -1936, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -22103, -104472, -1712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -20477, -104992, -1776, 0, 0, 0, 21, 0, 0, 0),
-- Rakeclaw Imp Hunter
("Orc_Village", 1, 20312, -30488, -124100, -2112, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -28500, -123240, -2200, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -29920, -125132, -2200, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -27932, -125992, -2192, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -31056, -124444, -2040, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -29268, -127356, -1208, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -26508, -130416, -960, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -23288, -130668, -664, 0, 0, 58480, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -22325, -130091, -664, 0, 0, 48439, 20, 0, 0, 0),
("Orc_Village", 1, 20312, -31176, -102202, -2664, 0, 0, 0, 20, 0, 0, 0),
-- Rakeclaw Imp Chieftain
("Orc_Village", 1, 20313, -21290, -106552, -2024, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -20477, -106552, -2040, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -21832, -105772, -1992, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -19664, -105512, -2032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -18556, -102088, -2096, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -18860, -101528, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -16884, -101752, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20313, -17188, -101752, -2104, 0, 0, 0, 21, 0, 0, 0),
-- Darkwing Bat
("Orc_Village", 1, 20316, -22815, -115162, -2984, 0, 0, 28710, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -23619, -116772, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -19372, -129758, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -19606, -128624, -2128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -20074, -128300, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -16096, -130730, -2136, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -15340, -129211, -2984, 0, 0, 63211, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -17970, -124814, -2048, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -17388, -124139, -2120, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -16224, -125264, -1856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -14187, -127064, -1736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -14243, -130554, -2904, 0, 0, 13196, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -12460, -129521, -2768, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -12820, -129366, -2696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -13314, -125264, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -22212, -115852, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -20604, -115622, -2760, 0, 0, 0, 21, 0, 0, 0),
-- Goblin Tomb Raider Leader
("Orc_Village", 1, 20320, -16806, -125489, -1824, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -17097, -126164, -1784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -14620, -129366, -2888, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -18694, -122679, -2256, 0, 0, 7786, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -18694, -120852, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -18347, -121896, -2232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -15933, -125939, -1784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -15642, -124139, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -14769, -127289, -1784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -15918, -122940, -2208, 0, 0, 42452, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -12460, -130296, -2712, 0, 0, 32120, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -13900, -128901, -2688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -11740, -130761, -2800, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -16959, -119547, -2192, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -17306, -119547, -2184, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -19152, -117904, -2424, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -16672, -117316, -2152, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -16135, -116539, -2168, 0, 0, 10283, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -16058, -118445, -2088, 0, 0, 57793, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -12337, -116160, -2200, 0, 0, 37445, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -12549, -116010, -2192, 0, 0, 10424, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -11169, -116289, -2248, 0, 0, 58290, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -22645, -104732, -1840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -23458, -103952, -2048, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -22374, -103432, -1576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -22103, -103172, -1480, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -17860, -103810, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -16724, -103441, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -17292, -103564, -680, 0, 0, 0, 21, 0, 0, 0),
-- Greystone Golem
("Orc_Village", 1, 20333, -18694, -121896, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -17653, -122157, -2160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -16612, -122940, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -16612, -120852, -2144, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -19041, -120330, -2296, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -18904, -117708, -2432, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -17416, -115748, -2344, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -17168, -116140, -2272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -15359, -115651, -2192, 0, 0, 1221, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -14148, -114855, -2400, 0, 0, 29608, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -13288, -115881, -2208, 0, 0, 22821, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -11829, -116290, -2216, 0, 0, 52378, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -11459, -115952, -2240, 0, 0, 5289, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -16240, -119644, -2136, 0, 0, 60517, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -15412, -110856, -2224, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -16276, -109524, -2376, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -15556, -109524, -2328, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -17376, -108501, -2272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -18960, -108066, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -20016, -108066, -1976, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -21312, -104793, -1784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -22082, -105448, -1896, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -21862, -104269, -1648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -18144, -103933, -736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -18428, -103810, -656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -5756, -130114, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -5024, -129466, -2960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -5024, -128818, -2840, 0, 0, 6671, 21, 0, 0, 0),
-- Maraku Werewolf
("Orc_Village", 1, 20363, -27024, -111592, -2232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25089, -108858, -1368, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24915, -109380, -1344, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24580, -112908, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25520, -114553, -2192, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24567, -108858, -1312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25144, -114882, -2160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28100, -118714, -2096, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25909, -117394, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25991, -119521, -2112, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -27787, -120694, -2160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -27474, -120364, -2192, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -26293, -119267, -2168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24934, -120537, -1976, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -26848, -121024, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28726, -122014, -2160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25020, -124840, -2672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24676, -126808, -2208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24676, -127136, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22349, -124449, -2656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21580, -123528, -2872, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22063, -125403, -2576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21924, -126152, -2472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22063, -124290, -2688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21920, -123813, -2776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22268, -122216, -2936, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -18818, -121618, -2272, 0, 0, 8708, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -16862, -121618, -2136, 0, 0, 33342, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -16536, -120934, -2144, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -16373, -122302, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21012, -117014, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22128, -117266, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -20604, -116772, -2984, 0, 0, 64269, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21006, -117462, -2984, 0, 0, 38012, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -22376, -116132, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21880, -116510, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -21207, -114242, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -20403, -114472, -2952, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -19164, -101416, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -18708, -101752, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -16884, -101416, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -18252, -101192, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -25370, -99208, -2368, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -24942, -99808, -2400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -26440, -99358, -2440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28460, -99602, -2720, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28516, -101857, -3104, 0, 0, 10440, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -29160, -99990, -2712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28392, -102504, -3104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20363, -28392, -102960, -3088, 0, 0, 0, 21, 0, 0, 0),
-- Maraku Werewolf Chieftain
("Orc_Village", 1, 20364, -5207, -128818, -2848, 0, 0, 63168, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -4292, -128980, -2912, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -2748, -128670, -2920, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -1708, -125800, -3192, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -4568, -125513, -2512, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -5348, -125800, -2696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -4828, -124652, -2600, 0, 0, 0, 21, 0, 0, 0),
-- Mountain Fungus
("Orc_Village", 1, 20365, -25089, -110598, -1688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -25520, -111592, -2408, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -25332, -111921, -2416, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -24915, -108336, -1360, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -26648, -112908, -2224, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -24580, -114224, -2080, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -26848, -117394, -2128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -28100, -120364, -2016, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -24344, -121024, -2032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27787, -121354, -2192, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -25283, -121024, -2000, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -29039, -120034, -1680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -28216, -123756, -2208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27648, -123756, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27932, -124272, -2224, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27080, -124788, -2296, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -28216, -124444, -2208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -29700, -126900, -1232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27756, -128116, -1064, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -24332, -125168, -2704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -23644, -125168, -2656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -22268, -124840, -2624, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -20892, -124184, -2872, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -25864, -130668, -824, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -23610, -130290, -664, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -26830, -129786, -992, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -21580, -122216, -2992, 0, 0, 58644, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -22268, -122544, -2952, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -25156, -100258, -2448, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27296, -99658, -2544, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27082, -98908, -2560, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -28160, -100281, -2608, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -29160, -100087, -2712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -29286, -101592, -3104, 0, 0, 8131, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -31176, -101785, -2736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -27945, -102656, -3104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -32416, -102480, -2624, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20365, -28693, -103506, -3104, 0, 0, 16986, 21, 0, 0, 0),
-- Evil Eye
("Orc_Village", 1, 20426, -26836, -112250, -2136, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -25002, -110598, -1640, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -25524, -109206, -1464, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -26272, -113895, -2200, 0, 0, 56694, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24956, -115211, -2168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24768, -116527, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -25909, -118054, -2168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -25596, -118714, -2080, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24344, -118714, -1960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -28413, -120364, -1896, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -27161, -122344, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -26222, -122014, -2024, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -22956, -121232, -2808, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24676, -126808, -2208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -23644, -126152, -2352, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -22612, -125168, -2600, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24332, -123528, -2912, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -22956, -124840, -2656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -18670, -130568, -2032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -19840, -129920, -2144, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -18202, -128786, -1912, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -22413, -116082, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -22212, -115852, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -20202, -115852, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -20202, -116082, -2976, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -18860, -100520, -2112, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -19012, -100184, -2136, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -19012, -99960, -2144, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -17340, -101192, -2104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -25584, -99508, -2400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -26012, -100108, -2440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -26226, -99958, -2464, 0, 0, 20882, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -28360, -99020, -2736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -28360, -98826, -2736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -28690, -101896, -3104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -28392, -103112, -3096, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -30031, -102960, -3104, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye Patroller
("Orc_Village", 1, 20428, -19735, -121113, -2232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -19041, -123723, -2216, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -18694, -121113, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -18694, -122418, -2256, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -17653, -121113, -2128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -17306, -122157, -2152, 0, 0, 50127, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -16672, -118688, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -16920, -115552, -2256, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -15686, -117851, -2056, 0, 0, 50420, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -14662, -115835, -2272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -15319, -116681, -2112, 0, 0, 8228, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -13492, -116778, -2072, 0, 0, 30801, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -12691, -115735, -2192, 0, 0, 34179, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -11696, -115418, -2232, 0, 0, 56413, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -15020, -103441, -1456, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -14452, -103195, -1528, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -19280, -104179, -984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -4841, -129142, -2888, 0, 0, 30375, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -4658, -129142, -2896, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Spider
("Orc_Village", 1, 20474, -3788, -127809, -2720, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, -1708, -125226, -3104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, -1188, -124078, -2864, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, -3528, -124365, -2640, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, -2228, -124365, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, -3788, -126661, -2576, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Fang Spider
("Orc_Village", 1, 20476, -404, -123072, -2912, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -2312, -122574, -2752, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -2100, -120582, -2576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -4432, -123072, -2648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -4220, -122574, -2640, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Blade Spider
("Orc_Village", 1, 20478, -1252, -123819, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -404, -123819, -2920, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -1888, -122574, -2768, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -1040, -120582, -2776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -2524, -120831, -2528, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Bear
("Orc_Village", 1, 20479, -4048, -128383, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -1448, -126374, -3264, 0, 0, 62521, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -408, -124365, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -616, -121329, -2832, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -2948, -123321, -2520, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -2100, -122574, -2760, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -2736, -120084, -2616, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -4568, -126948, -2608, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -3268, -126661, -2744, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Imp
("Orc_Village", 1, 21117, -2648, -117308, -2600, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -2452, -117948, -2664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -1148, -114437, -3520, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -2681, -114615, -3384, 0, 0, 0, 20, 0, 0, 0),
-- Baar Dre Vanul
("Orc_Village", 1, 21118, -1472, -118588, -2696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -1864, -118108, -2608, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -2024, -114081, -3416, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -929, -114437, -3528, 0, 0, 0, 20, 0, 0, 0),
-- Hobgoblin
("Orc_Village", 1, 21119, -3190, -110676, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2746, -108516, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -3190, -107652, -2752, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2080, -108084, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -970, -108516, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2746, -104628, -2752, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2302, -105060, -2736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -1889, -102973, -2608, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -4040, -101518, -2752, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -455, -102100, -2256, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -694, -100645, -2200, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2367, -99190, -2632, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2845, -99190, -2744, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Imp Turen
("Orc_Village", 1, 21120, -1192, -111540, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -2746, -110676, -2768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -3190, -111108, -2704, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1414, -108516, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -4078, -104628, -2720, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1414, -105924, -2744, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -933, -103555, -2552, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -2606, -101227, -2664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1172, -100645, -2392, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -3562, -99190, -2904, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1172, -98899, -2384, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1172, -99772, -2368, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Dire Wolf
("Orc_Village", 1, 21121, -1192, -111972, -2512, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1414, -109380, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -970, -109380, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -2524, -109812, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -4078, -108084, -2704, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -3856, -105492, -2712, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1192, -104628, -2664, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1411, -103555, -2600, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -455, -102973, -2384, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1889, -103264, -2624, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1650, -103846, -2640, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1411, -101227, -2448, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1889, -102391, -2592, 0, 0, 0, 20, 0, 0, 0),
-- Evil Eye Seer
("Orc_Village", 1, 21257, -1668, -117468, -2544, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -688, -118348, -2584, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -929, -115238, -3512, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -1805, -114259, -3432, 0, 0, 0, 60, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, -26140, -115295, -2200, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -21039, -126082, -2552, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -17091, -124282, -2088, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -16602, -117132, -2144, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -18125, -110686, -2216, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -1589, -129313, -2688, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -2180, -104722, -2736, 0, 0, 0, 60, 0, 0, 0),

-- [19_15]

-- Grizzly
("Orc_Village", 1, 20143, -24432, -97332, -2488, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -25072, -97160, -2576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -25392, -96816, -2672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -26732, -94814, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -27678, -95048, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -27678, -93878, -2824, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5579, -94358, -2392, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5030, -94358, -2272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5762, -94358, -2440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5396, -94513, -2376, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5762, -93428, -2416, 0, 0, 47196, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -5579, -93583, -2360, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -7409, -94048, -2624, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20143, -7409, -94203, -2624, 0, 0, 1496, 21, 0, 0, 0),
-- Darkwing Bat
("Orc_Village", 1, 20316, -24112, -97418, -2472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -26352, -97676, -2632, 0, 0, 43251, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -26672, -96558, -2816, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -27592, -95984, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -26646, -94346, -2760, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -27420, -94112, -2792, 0, 0, 22779, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -5213, -94513, -2328, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -5762, -95133, -2512, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -4847, -94513, -2264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -5762, -93273, -2416, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -5945, -93273, -2440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -7043, -94513, -2672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -7226, -94203, -2632, 0, 0, 40351, 21, 0, 0, 0),
("Orc_Village", 1, 20316, -7043, -93738, -2600, 0, 0, 0, 21, 0, 0, 0),
-- Goblin Tomb Raider Leader
("Orc_Village", 1, 20320, -26904, -94580, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -27764, -95048, -2840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -27764, -93176, -2808, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5213, -94358, -2320, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5396, -94358, -2360, 0, 0, 52284, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5579, -93893, -2360, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5030, -92963, -2288, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5945, -93583, -2424, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -5213, -94048, -2296, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20320, -6677, -94823, -2664, 0, 0, 0, 21, 0, 0, 0),
-- Greystone Golem
("Orc_Village", 1, 20333, -23744, -94845, -3520, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -21594, -92155, -3648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -21594, -93500, -3672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, -23314, -92424, -3688, 0, 0, 26178, 21, 0, 0, 0),
-- Maraku Werewolf Chieftain
("Orc_Village", 1, 20364, -23529, -94576, -3472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -23314, -94576, -3464, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -24587, -88200, -3336, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -25862, -87408, -3432, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -25862, -87144, -3416, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -26117, -87672, -3400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -25352, -86880, -3632, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -22024, -91348, -3552, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, -22454, -92693, -3680, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye
("Orc_Village", 1, 20426, -23152, -97762, -2440, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -24432, -97246, -2504, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20426, -27952, -97934, -2768, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye Patroller
("Orc_Village", 1, 20428, -23529, -94845, -3488, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -27137, -88728, -3272, 0, 0, 30010, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -26882, -87936, -3256, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -26372, -87672, -3360, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -26117, -87936, -3400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -22454, -91886, -3648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, -22454, -92424, -3688, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Fang Spider
("Orc_Village", 1, 20476, -26730, -88880, -3232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -26016, -88040, -3408, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -26118, -87620, -3400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -19174, -90645, -2552, 0, 0, 24807, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -13292, -96672, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -13292, -97047, -2520, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -18232, -96422, -2584, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -17092, -96172, -2312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -22488, -89050, -2856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -21648, -89665, -2784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -20808, -89665, -2592, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, -23324, -92558, -3696, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Blade Spider
("Orc_Village", 1, 20478, -14052, -97547, -2376, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -14812, -97172, -2224, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -14812, -96422, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -15192, -98047, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -17472, -96797, -2416, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -22488, -88025, -2768, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -22488, -88435, -2816, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -21648, -89665, -2784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, -20023, -90918, -2576, 0, 0, 3257, 21, 0, 0, 0),
-- Kasha Bear
("Orc_Village", 1, 20479, -27392, -90840, -2944, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -26117, -90840, -2680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -28157, -88992, -3288, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -26627, -87144, -3240, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -26372, -86616, -3296, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -19152, -90921, -2584, 0, 0, 41287, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -13292, -96547, -2000, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -11392, -97922, -2736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -16332, -97047, -2232, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -15572, -96922, -2200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -16712, -97422, -2240, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -22208, -88025, -2664, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -21928, -89050, -2792, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, -23048, -88845, -3000, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Imp
("Orc_Village", 1, 21117, -23539, -80709, -3176, 0, 0, 36930, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -23282, -80709, -3216, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -23308, -78459, -2888, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -22228, -78024, -2712, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -20924, -76297, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -20674, -76554, -2464, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -16562, -77353, -3520, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -2953, -77889, -2776, 0, 0, 62521, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -1336, -77368, -2496, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -1389, -78185, -2544, 0, 0, 43925, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -870, -78831, -2632, 0, 0, 60489, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -5213, -93583, -2296, 0, 0, 24614, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -5945, -93893, -2424, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -10240, -92845, -2552, 0, 0, 45974, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -7368, -92794, -2560, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -7368, -92448, -2544, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -6494, -93893, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -11448, -93486, -2728, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -7368, -90718, -2280, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -9408, -88642, -2256, 0, 0, 29244, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -10224, -89680, -2296, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -9408, -88988, -2288, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -12932, -78087, -3400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -14386, -80690, -3400, 0, 0, 3917, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -15844, -79766, -3400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -16232, -79555, -3440, 0, 0, 57582, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -17882, -81023, -3544, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -17222, -81390, -3600, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, -17882, -79922, -3536, 0, 0, 0, 20, 0, 0, 0),
-- Baar Dre Vanul
("Orc_Village", 1, 21118, -25081, -81534, -3048, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -24053, -81534, -3208, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -23796, -79884, -2912, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -24388, -79039, -2952, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -23524, -78604, -2880, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -22444, -79184, -2672, 0, 0, 39073, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -20924, -77582, -2520, 0, 0, 32395, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -20674, -76040, -2448, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -18674, -76297, -2368, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -5030, -94513, -2280, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -4664, -92498, -2184, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -4847, -94203, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -8876, -92600, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -8592, -92448, -2584, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -9000, -92794, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -7842, -92474, -2608, 0, 0, 36727, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -9408, -92102, -2424, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -7886, -90920, -2288, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -6960, -92102, -2440, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -8592, -88642, -2360, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -14252, -81023, -3400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -14912, -79922, -3400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -14912, -81757, -3448, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -16232, -79922, -3400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -17552, -81390, -3584, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, -17222, -81023, -3544, 0, 0, 0, 20, 0, 0, 0),
-- Hobgoblin
("Orc_Village", 1, 21119, -16595, -71732, -1928, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -13755, -74387, -2072, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -12690, -73148, -2096, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -12006, -75049, -2216, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -11005, -74932, -2296, 0, 0, 49109, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -9678, -76703, -2552, 0, 0, 56372, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -8954, -77020, -2600, 0, 0, 35273, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2004, -77204, -2680, 0, 0, 38931, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -754, -76694, -2224, 0, 0, 41942, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -595, -77197, -2288, 0, 0, 51170, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -458, -76917, -2216, 0, 0, 31658, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -2960, -96450, -2464, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -1712, -97476, -2512, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -464, -96108, -2016, 0, 0, 27603, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -8634, -87904, -2320, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -7275, -86584, -2336, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -8181, -87640, -2368, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -6039, -88896, -2496, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -4474, -87132, -2488, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, -5916, -87376, -2328, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Imp Turen
("Orc_Village", 1, 21120, -13755, -72617, -2080, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -13045, -73679, -2088, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -13400, -72971, -2096, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -12149, -75166, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -10862, -75166, -2328, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -8841, -77032, -2600, 0, 0, 53953, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -8914, -77038, -2600, 0, 0, 24156, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -2544, -96450, -2408, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -3584, -96621, -2576, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -3168, -96963, -2600, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -1712, -96621, -2384, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -7275, -88168, -2408, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -5463, -86320, -2344, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -5010, -90016, -2336, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -5057, -86822, -2328, 0, 0, 27681, 20, 0, 0, 0),
("Orc_Village", 1, 21120, -5010, -86848, -2328, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Dire Wolf
("Orc_Village", 1, 21121, -15175, -72440, -2064, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -15906, -73150, -2016, 0, 0, 33966, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -14465, -71378, -1944, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -11720, -75517, -2264, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -11291, -74230, -2240, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -8064, -77062, -2712, 0, 0, 38687, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -7595, -77063, -2712, 0, 0, 64361, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -672, -96279, -2080, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1920, -97476, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -1088, -96963, -2320, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -6822, -86848, -2288, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -8181, -87640, -2368, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -5010, -89488, -2424, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, -5916, -86848, -2280, 0, 0, 61781, 20, 0, 0, 0),
-- Evil Eye Seer
("Orc_Village", 1, 21257, -6144, -92448, -2392, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -6677, -94823, -2664, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -8592, -94178, -2944, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -7368, -93140, -2584, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -11856, -93486, -2728, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -6552, -91756, -2344, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -8592, -90026, -2328, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -8592, -89334, -2360, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -14912, -81390, -3400, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -16892, -81757, -3624, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -24310, -81369, -3120, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -25595, -81534, -3040, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -25081, -81699, -3096, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -23092, -78459, -2824, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -20932, -79184, -2576, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -20924, -77839, -2520, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -21796, -78459, -2584, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -20174, -76297, -2440, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -17424, -74498, -2072, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -17882, -78454, -3512, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -16232, -77353, -3520, 0, 0, 53577, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -13922, -78087, -3520, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -2345, -77627, -2760, 0, 0, 23792, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -1738, -76990, -2584, 0, 0, 19739, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -1187, -77031, -2440, 0, 0, 48039, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -981, -77277, -2384, 0, 0, 23314, 60, 0, 0, 0),
("Orc_Village", 1, 21257, -5396, -94978, -2392, 0, 0, 0, 60, 0, 0, 0),
-- Crimson Werewolf
("Orc_Village_Npc", 1, 27199, -16732, -79832, -3616, 0, 0, 0, 180, 0, 0, 0),
-- Kakan
("Orc_Village_Npc", 1, 30669, -9563, -89959, -2320, 0, 0, 0, 60, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, -22184, -94711, -3496, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -4780, -88368, -2736, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, -14792, -80536, -3400, 0, 0, 16719, 60, 0, 0, 0),

-- [19_16]

-- Penance Guard
("Pagan Temple", 1, 22137, -10220, -40763, -10917, 0, 0, 48342, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -10303, -40763, -10917, 0, 0, 48342, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -10385, -40763, -10917, 0, 0, 48342, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12245, -38916, -10725, 0, 0, 48792, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12247, -42612, -10725, 0, 0, 48441, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12330, -38916, -10725, 0, 0, 48792, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12341, -42612, -10725, 0, 0, 48441, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12423, -38920, -10725, 0, 0, 48792, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -12434, -42612, -10725, 0, 0, 48441, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -13049, -40716, -10725, 0, 0, 15777, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -13153, -40716, -10725, 0, 0, 15777, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -13239, -40716, -10725, 0, 0, 15777, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -19485, -40761, -10725, 0, 0, 49152, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -19576, -40767, -10725, 0, 0, 49066, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -19661, -40783, -10725, 0, 0, 47076, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20298, -42608, -10725, 0, 0, 17185, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20304, -38884, -10725, 0, 0, 16561, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20385, -42608, -10725, 0, 0, 17185, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20389, -38884, -10725, 0, 0, 16561, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20487, -38884, -10725, 0, 0, 16561, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -20488, -42608, -10725, 0, 0, 17185, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -22315, -40731, -10917, 0, 0, 53141, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -22410, -40731, -10917, 0, 0, 53141, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -22508, -40731, -10917, 0, 0, 53141, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23039, -38882, -10917, 0, 0, 16428, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23045, -42582, -10917, 0, 0, 48397, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23136, -38882, -10917, 0, 0, 16428, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23136, -42582, -10917, 0, 0, 48397, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23219, -42582, -10917, 0, 0, 48397, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -23231, -38882, -10917, 0, 0, 16428, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9495, -38911, -10917, 0, 0, 48556, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9506, -42615, -10917, 0, 0, 16303, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9586, -38911, -10917, 0, 0, 48556, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9599, -42615, -10917, 0, 0, 16303, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9677, -38911, -10917, 0, 0, 48556, 60, 0, 0, 0),
("Pagan Temple", 1, 22137, -9691, -42615, -10917, 0, 0, 16303, 60, 0, 0, 0),
-- Chapel Guard
("Pagan Temple", 1, 22138, -12913, -45558, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12913, -45612, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12913, -45667, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12914, -49649, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12914, -49717, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12914, -49791, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12930, -47615, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12930, -47675, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12930, -47735, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12946, -51690, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12946, -51745, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -12946, -51822, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14448, -44446, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14448, -44508, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14448, -44567, -10725, 0, 0, 32698, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14500, -46511, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14500, -46582, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14500, -46643, -10821, 0, 0, 32651, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14503, -48557, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14503, -48612, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14503, -48681, -10917, 0, 0, 31928, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14504, -50621, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14504, -50681, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -14504, -50740, -11013, 0, 0, 33522, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15763, -50095, -10917, 0, 0, 40662, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15819, -50061, -10917, 0, 0, 40662, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15854, -50010, -10917, 0, 0, 40662, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15870, -49941, -10917, 0, 0, 40662, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15912, -49879, -10917, 0, 0, 40662, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15984, -45983, -10725, 0, 0, 34769, 60, 0, 0, 0),
("Pagan Temple", 1, 22138, -15993, -47783, -10821, 0, 0, 31547, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15993, -47857, -10821, 0, 0, 31547, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15993, -47940, -10821, 0, 0, 31547, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15993, -48016, -10821, 0, 0, 31547, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15994, -45737, -10725, 0, 0, 32768, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15994, -45806, -10725, 0, 0, 31399, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15994, -45873, -10725, 0, 0, 31399, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -15994, -45937, -10725, 0, 0, 31399, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16777, -45739, -10725, 0, 0, 211, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16777, -45805, -10725, 0, 0, 211, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16777, -45878, -10725, 0, 0, 211, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16777, -45942, -10725, 0, 0, 211, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16777, -45990, -10725, 0, 0, 211, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16781, -47807, -10821, 0, 0, 64708, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16781, -47886, -10821, 0, 0, 64708, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16781, -47959, -10821, 0, 0, 64708, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16781, -48025, -10821, 0, 0, 64708, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16794, -49896, -10917, 0, 0, 63262, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16818, -49975, -10917, 0, 0, 63262, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16842, -50040, -10917, 0, 0, 63262, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16876, -50098, -10918, 0, 0, 63262, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -16921, -50149, -10936, 0, 0, 63262, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18308, -50625, -11013, 0, 0, 63878, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18308, -50680, -11013, 0, 0, 63878, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18308, -50743, -11013, 0, 0, 63878, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18311, -48556, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18311, -48620, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18311, -48688, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18323, -46505, -10821, 0, 0, 264, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18323, -46570, -10821, 0, 0, 264, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18323, -46639, -10821, 0, 0, 264, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18329, -44461, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18329, -44516, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -18329, -44575, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19876, -47606, -10821, 0, 0, 65001, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19876, -47674, -10821, 0, 0, 65001, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19876, -47737, -10821, 0, 0, 65001, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19883, -45560, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19883, -45617, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19883, -45675, -10725, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19884, -49645, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19884, -49712, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19884, -49778, -10917, 0, 0, 0, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19886, -51688, -11013, 0, 0, 63878, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19886, -51754, -11013, 0, 0, 63878, 180, 0, 0, 0),
("Pagan Temple", 1, 22138, -19886, -51826, -11013, 0, 0, 63878, 180, 0, 0, 0),
-- Old Aristocrat's Soldier
("Pagan Temple", 1, 22139, -12047, -37909, -10725, 0, 0, 7099, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -12440, -39877, -10758, 0, 0, 746, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -12691, -41687, -10757, 0, 0, 31106, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -12744, -37861, -10758, 0, 0, 2967, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -12839, -43346, -10725, 0, 0, 30282, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -12971, -39915, -10758, 0, 0, 35143, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -13519, -43539, -10725, 0, 0, 817, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -17619, -40821, -10725, 0, 0, 45039, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -17809, -37901, -10725, 0, 0, 47429, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -17886, -42848, -10725, 0, 0, 17100, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -19345, -41780, -10725, 0, 0, 10251, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -19766, -43585, -10758, 0, 0, 33441, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20105, -39783, -10783, 0, 0, 9483, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20214, -37951, -10758, 0, 0, 32889, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20274, -40000, -10758, 0, 0, 37584, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20648, -41742, -10725, 0, 0, 63671, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20672, -37716, -10725, 0, 0, 27807, 60, 0, 0, 0),
("Pagan Temple", 1, 22139, -20730, -39814, -10725, 0, 0, 33653, 60, 0, 0, 0),
-- Zombie Worker
("Pagan Temple", 1, 22140, -12300, -39649, -10725, 0, 0, 49443, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12353, -43587, -10751, 0, 0, 48903, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12474, -37921, -10758, 0, 0, 60239, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12512, -41573, -10757, 0, 0, 29413, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12570, -39730, -10758, 0, 0, 21299, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12749, -43543, -10758, 0, 0, 12061, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -12950, -37895, -10758, 0, 0, 57898, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -13025, -41823, -10757, 0, 0, 37729, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -13098, -43422, -10784, 0, 0, 30495, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -13134, -37770, -10728, 0, 0, 6344, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -13164, -39841, -10736, 0, 0, 7405, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -14837, -37923, -10725, 0, 0, 15439, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15135, -39452, -10725, 0, 0, 11376, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15165, -40378, -10725, 0, 0, 57526, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15171, -41568, -10725, 0, 0, 16535, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15494, -40568, -10725, 0, 0, 19919, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15840, -39597, -10725, 0, 0, 64055, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -15933, -41882, -10725, 0, 0, 10120, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -16354, -39428, -10725, 0, 0, 25717, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -16401, -42162, -10725, 0, 0, 50404, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -16754, -41865, -10725, 0, 0, 9642, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -16786, -39826, -10725, 0, 0, 41663, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -17101, -42004, -10725, 0, 0, 51274, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -17233, -40250, -10725, 0, 0, 7346, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -17247, -40930, -10725, 0, 0, 43895, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -17819, -39778, -10725, 0, 0, 49089, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -19314, -41703, -10725, 0, 0, 34376, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -19425, -43618, -10725, 0, 0, 34207, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -19737, -39915, -10758, 0, 0, 61162, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -19977, -37970, -10758, 0, 0, 36848, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -20060, -43480, -10758, 0, 0, 63557, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -20157, -37957, -10758, 0, 0, 4486, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -20190, -43670, -10758, 0, 0, 6665, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -20207, -41686, -10758, 0, 0, 38448, 60, 0, 0, 0),
("Pagan Temple", 1, 22140, -20225, -39752, -10758, 0, 0, 57344, 60, 0, 0, 0),
-- Forgotten Victim
("Pagan Temple", 1, 22141, -12113, -43522, -10725, 0, 0, 29949, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -12457, -41840, -10757, 0, 0, 37604, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -12493, -38004, -10758, 0, 0, 49577, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -12531, -39813, -10758, 0, 0, 30336, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -12892, -38012, -10758, 0, 0, 31224, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -13053, -41674, -10757, 0, 0, 9028, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -16342, -41608, -10725, 0, 0, 63541, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -19641, -39685, -10758, 0, 0, 17041, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -19872, -37947, -10758, 0, 0, 38713, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -19990, -41670, -10784, 0, 0, 1137, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -20035, -41735, -10758, 0, 0, 30787, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -20058, -43478, -10758, 0, 0, 29101, 60, 0, 0, 0),
("Pagan Temple", 1, 22141, -20561, -43677, -10725, 0, 0, 6712, 60, 0, 0, 0),
-- Triol's Layperson
("Pagan Temple", 1, 22142, -11917, -45146, -10751, 0, 0, 47515, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -12435, -45293, -10725, 0, 0, 9548, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -12454, -44814, -10725, 0, 0, 27245, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -12724, -41679, -10757, 0, 0, 4346, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -12786, -39819, -10758, 0, 0, 399, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -13442, -44992, -10725, 0, 0, 14745, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -13519, -45360, -10725, 0, 0, 15580, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -13597, -47740, -10821, 0, 0, 36933, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -13825, -46598, -10821, 0, 0, 65033, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -13877, -47143, -10821, 0, 0, 45718, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -18965, -47297, -10821, 0, 0, 15280, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -20069, -43496, -10758, 0, 0, 31352, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -22771, -41766, -10950, 0, 0, 60584, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -22823, -43708, -10976, 0, 0, 37111, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -22855, -38040, -10950, 0, 0, 27932, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -23576, -39625, -10917, 0, 0, 4787, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -23617, -41787, -10916, 0, 0, 4149, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9415, -41586, -10950, 0, 0, 15017, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9487, -39854, -10950, 0, 0, 51898, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9518, -43678, -10949, 0, 0, 33195, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9556, -39949, -10950, 0, 0, 63860, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9936, -37826, -10950, 0, 0, 24142, 60, 0, 0, 0),
("Pagan Temple", 1, 22142, -9957, -43441, -10950, 0, 0, 28959, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22143, -11877, -45580, -10725, 0, 0, 24100, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -11888, -47273, -10821, 0, 0, 5637, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -11934, -46889, -10821, 0, 0, 18012, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -12220, -46913, -10847, 0, 0, 43474, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -12293, -44811, -10725, 0, 0, 48806, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -12387, -46718, -10821, 0, 0, 20484, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13412, -47364, -10821, 0, 0, 58824, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13575, -51224, -11013, 0, 0, 21221, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13828, -46779, -10821, 0, 0, 56780, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13850, -50893, -11013, 0, 0, 54001, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13895, -45771, -10725, 0, 0, 1771, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13913, -45022, -10725, 0, 0, 52082, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13947, -44709, -10725, 0, 0, 17513, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -13955, -47384, -10847, 0, 0, 45283, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -14855, -48563, -10917, 0, 0, 45676, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -14984, -47559, -10821, 0, 0, 28760, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -15017, -46770, -10821, 0, 0, 46292, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -15226, -45380, -10725, 0, 0, 32352, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -15231, -44868, -10725, 0, 0, 49057, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -15298, -49363, -10917, 0, 0, 23643, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -17567, -45494, -10725, 0, 0, 26460, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -17655, -44940, -10725, 0, 0, 49152, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -17677, -49159, -10943, 0, 0, 18694, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -18766, -47136, -10821, 0, 0, 55702, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -19062, -51129, -11013, 0, 0, 4422, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -19149, -49305, -10917, 0, 0, 45931, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -19317, -50749, -11013, 0, 0, 63270, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -19369, -47280, -10821, 0, 0, 14697, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -20370, -48944, -10917, 0, 0, 12985, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -20560, -46717, -10821, 0, 0, 51482, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -20773, -45369, -10725, 0, 0, 30343, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -22380, -39862, -10916, 0, 0, 54039, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -22892, -41607, -10950, 0, 0, 2051, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -22984, -43545, -10950, 0, 0, 64947, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -9472, -41566, -10950, 0, 0, 1467, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -9709, -43572, -10950, 0, 0, 23422, 60, 0, 0, 0),
("Pagan Temple", 1, 22143, -9777, -39919, -10950, 0, 0, 62590, 60, 0, 0, 0),
-- Resurrected Temple Knight
("Pagan Temple", 1, 22144, -22903, -41620, -10950, 0, 0, 24052, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23010, -39829, -10950, 0, 0, 3559, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23181, -37889, -10915, 0, 0, 325, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23186, -43569, -10950, 0, 0, 43933, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23303, -39933, -10950, 0, 0, 63919, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23713, -43550, -10915, 0, 0, 65285, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -23791, -37982, -10915, 0, 0, 61526, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -8984, -43532, -10915, 0, 0, 32556, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -9444, -41806, -10976, 0, 0, 62277, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -9720, -37984, -10950, 0, 0, 35843, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -9854, -41608, -10950, 0, 0, 64693, 60, 0, 0, 0),
("Pagan Temple", 1, 22144, -9906, -39738, -10950, 0, 0, 29951, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22145, -10003, -41792, -10950, 0, 0, 6435, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -22677, -37801, -10950, 0, 0, 9708, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -22741, -39928, -10950, 0, 0, 59503, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -23069, -43355, -10950, 0, 0, 22733, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -23175, -38053, -10950, 0, 0, 36909, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -23879, -41651, -10915, 0, 0, 29838, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -8956, -41718, -10916, 0, 0, 5610, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -9482, -37912, -10950, 0, 0, 177, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -9666, -43537, -10950, 0, 0, 62212, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -9671, -38065, -10950, 0, 0, 57906, 60, 0, 0, 0),
("Pagan Temple", 1, 22145, -9846, -39902, -10950, 0, 0, 52810, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22146, -12291, -47375, -10821, 0, 0, 15065, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -13461, -46979, -10847, 0, 0, 59967, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -13676, -44920, -10725, 0, 0, 52319, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -15088, -44849, -10725, 0, 0, 44235, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -15249, -47257, -10821, 0, 0, 13363, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -17395, -47434, -10821, 0, 0, 20673, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -17504, -45841, -10725, 0, 0, 32140, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -18935, -46882, -10821, 0, 0, 43018, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -18938, -44829, -10725, 0, 0, 43183, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -19477, -47289, -10821, 0, 0, 8487, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -20433, -45589, -10725, 0, 0, 31970, 60, 0, 0, 0),
("Pagan Temple", 1, 22146, -20505, -47313, -10821, 0, 0, 2148, 60, 0, 0, 0),
-- Ritual Offering
("Pagan Temple", 1, 22147, -12422, -47167, -10821, 0, 0, 44200, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -13709, -50927, -11013, 0, 0, 62664, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -13774, -45393, -10725, 0, 0, 47714, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -13932, -51545, -11013, 0, 0, 36421, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -14015, -46842, -10821, 0, 0, 46950, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -15543, -45148, -10725, 0, 0, 21426, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -17608, -45188, -10751, 0, 0, 21419, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -17792, -47616, -10821, 0, 0, 43488, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -18725, -50823, -11013, 0, 0, 51912, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -19034, -46832, -10821, 0, 0, 52902, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -19048, -44780, -10725, 0, 0, 3830, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -19149, -45457, -10725, 0, 0, 13449, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -19423, -51456, -11013, 0, 0, 40167, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -20511, -46795, -10821, 0, 0, 44566, 60, 0, 0, 0),
("Pagan Temple", 1, 22147, -20795, -47631, -10821, 0, 0, 1066, 60, 0, 0, 0),
-- Ritual Offering
("Pagan Temple", 1, 22149, -14704, -45492, -10725, 0, 0, 51089, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -15002, -47068, -10821, 0, 0, 41941, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -15162, -46540, -10821, 0, 0, 49413, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -15243, -47635, -10821, 0, 0, 2657, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -15301, -40809, -10725, 0, 0, 9925, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -15333, -45553, -10725, 0, 0, 5532, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -16153, -42079, -10725, 0, 0, 59582, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17013, -39554, -10725, 0, 0, 42596, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17176, -41180, -10725, 0, 0, 45019, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17409, -44538, -10725, 0, 0, 36321, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17499, -45591, -10725, 0, 0, 25624, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17546, -47127, -10821, 0, 0, 45136, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17945, -44617, -10725, 0, 0, 54292, 60, 0, 0, 0),
("Pagan Temple", 1, 22149, -17993, -45540, -10725, 0, 0, 9073, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22151, -12407, -51523, -11013, 0, 0, 22227, 60, 0, 0, 0),
("Pagan Temple", 1, 22151, -13620, -50798, -11013, 0, 0, 64637, 60, 0, 0, 0),
("Pagan Temple", 1, 22151, -19026, -48907, -10917, 0, 0, 17369, 60, 0, 0, 0),
("Pagan Temple", 1, 22151, -19317, -51307, -11013, 0, 0, 5869, 60, 0, 0, 0),
("Pagan Temple", 1, 22151, -20347, -50677, -11013, 0, 0, 43591, 60, 0, 0, 0),
("Pagan Temple", 1, 22151, -20798, -51645, -11013, 0, 0, 30778, 60, 0, 0, 0),
-- Temple Guard
("Pagan Temple", 1, 22152, -12420, -53928, -11114, 0, 0, 33922, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -12509, -52569, -10938, 0, 0, 32156, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -13087, -54400, -11114, 0, 0, 65404, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -13899, -51207, -11013, 0, 0, 4363, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -15312, -49473, -10943, 0, 0, 38725, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -15380, -48542, -10917, 0, 0, 49337, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -17225, -48606, -10917, 0, 0, 47159, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -17717, -49655, -10917, 0, 0, 321, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -18700, -50818, -11013, 0, 0, 3874, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -19557, -54282, -11114, 0, 0, 36442, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -20391, -54318, -11114, 0, 0, 17297, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -20490, -51378, -11013, 0, 0, 47484, 60, 0, 0, 0),
("Pagan Temple", 1, 22152, -20898, -50927, -11013, 0, 0, 64243, 60, 0, 0, 0),
-- Temple Guard Captain
("Pagan Temple", 1, 22153, -12263, -51132, -11013, 0, 0, 37729, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -12312, -49582, -10943, 0, 0, 5009, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -12340, -49071, -10917, 0, 0, 54978, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -12367, -54299, -11114, 0, 0, 2327, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -13617, -49081, -10917, 0, 0, 23575, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -13642, -49653, -10917, 0, 0, 61593, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -14745, -49301, -10917, 0, 0, 33937, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -18053, -49327, -10917, 0, 0, 47311, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -19127, -48858, -10917, 0, 0, 61631, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -19437, -49344, -10917, 0, 0, 8961, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -20006, -54164, -11114, 0, 0, 44952, 60, 0, 0, 0),
("Pagan Temple", 1, 22153, -20237, -49432, -10917, 0, 0, 57132, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22154, -12255, -51607, -11013, 0, 0, 11412, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -12302, -51946, -11013, 0, 0, 26682, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -12606, -52727, -10938, 0, 0, 5934, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -13844, -51147, -11013, 0, 0, 54974, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -15001, -49006, -10943, 0, 0, 57447, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -15524, -49085, -10917, 0, 0, 16951, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -17425, -49086, -10917, 0, 0, 56058, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -17662, -49741, -10917, 0, 0, 30529, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -18895, -51265, -11013, 0, 0, 19425, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -18982, -49372, -10917, 0, 0, 64894, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -20091, -52681, -10938, 0, 0, 57155, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -20519, -49398, -10917, 0, 0, 64247, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -20604, -51170, -11013, 0, 0, 56571, 60, 0, 0, 0),
("Pagan Temple", 1, 22154, -20710, -48872, -10917, 0, 0, 61095, 60, 0, 0, 0),
-- Triol's High Priest
("Pagan Temple", 1, 22155, -12653, -54238, -11114, 0, 0, 2877, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -12687, -52666, -10938, 0, 0, 60928, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -15250, -57004, -10850, 0, 0, 37837, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -15658, -53286, -11565, 0, 0, 44488, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -16453, -53309, -11565, 0, 0, 49538, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -17703, -57011, -10850, 0, 0, 2320, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -17881, -53497, -11565, 0, 0, 0, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -19751, -52493, -10938, 0, 0, 34047, 60, 0, 0, 0),
("Pagan Temple", 1, 22155, -20330, -54215, -11114, 0, 0, 34741, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22156, -12305, -50814, -11013, 0, 0, 12548, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -12715, -54324, -11114, 0, 0, 4305, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -12739, -52757, -10938, 0, 0, 26747, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -13176, -51678, -11013, 0, 0, 6453, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -14162, -51125, -11013, 0, 0, 47330, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -14846, -53259, -11565, 0, 0, 7015, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -15679, -56564, -10850, 0, 0, 35078, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -15735, -54130, -11565, 0, 0, 5415, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -16979, -56601, -10850, 0, 0, 22146, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -17974, -53518, -11565, 0, 0, 1906, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -18807, -50796, -11013, 0, 0, 35504, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -20227, -54203, -11114, 0, 0, 6763, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -20360, -51837, -11013, 0, 0, 13414, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -20380, -52781, -10938, 0, 0, 53103, 60, 0, 0, 0),
("Pagan Temple", 1, 22156, -20871, -50721, -11013, 0, 0, 27767, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22157, -15205, -56909, -10850, 0, 0, 21495, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -16326, -56926, -10850, 0, 0, 31751, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -16844, -56562, -10850, 0, 0, 9084, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -17058, -54136, -11565, 0, 0, 16819, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -17185, -53128, -11565, 0, 0, 19068, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -17402, -56532, -10850, 0, 0, 16654, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -17638, -56994, -10850, 0, 0, 25248, 60, 0, 0, 0),
("Pagan Temple", 1, 22157, -17732, -57079, -10850, 0, 0, 57797, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22158, -12560, -54301, -11114, 0, 0, 34510, 60, 0, 0, 0),
("Pagan Temple", 1, 22158, -12657, -52762, -10938, 0, 0, 28108, 60, 0, 0, 0),
("Pagan Temple", 1, 22158, -20368, -54101, -11114, 0, 0, 14225, 60, 0, 0, 0),
-- Triol's High Priest
("Pagan Temple", 1, 22159, -15063, -56562, -10850, 0, 0, 33926, 60, 0, 0, 0),
("Pagan Temple", 1, 22159, -16816, -56567, -10850, 0, 0, 41346, 60, 0, 0, 0),
("Pagan Temple", 1, 22159, -17226, -53189, -11565, 0, 0, 49964, 60, 0, 0, 0),
("Pagan Temple", 1, 22159, -20069, -52782, -10938, 0, 0, 13633, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22160, -15316, -56955, -10850, 0, 0, 19811, 60, 0, 0, 0),
("Pagan Temple", 1, 22160, -15781, -53271, -11565, 0, 0, 24134, 60, 0, 0, 0),
("Pagan Temple", 1, 22160, -16541, -53421, -11565, 0, 0, 54984, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22161, -15706, -54049, -11565, 0, 0, 40042, 60, 0, 0, 0),
("Pagan Temple", 1, 22161, -15733, -53413, -11565, 0, 0, 45218, 60, 0, 0, 0),
("Pagan Temple", 1, 22161, -15792, -56538, -10850, 0, 0, 59496, 60, 0, 0, 0),
("Pagan Temple", 1, 22161, -16965, -56552, -10850, 0, 0, 27881, 60, 0, 0, 0),
("Pagan Temple", 1, 22161, -17589, -56614, -10850, 0, 0, 11548, 60, 0, 0, 0),
("Pagan Temple", 1, 22161, -17715, -57081, -10850, 0, 0, 42225, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22162, -15006, -56363, -10850, 0, 0, 47093, 60, 0, 0, 0),
("Pagan Temple", 1, 22162, -16354, -53302, -11565, 0, 0, 11548, 60, 0, 0, 0),
-- Triol's High Priest
("Pagan Temple", 1, 22163, -14941, -53216, -11565, 0, 0, 14739, 60, 0, 0, 0),
("Pagan Temple", 1, 22163, -16385, -57031, -10850, 0, 0, 34783, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22164, -15712, -53178, -11565, 0, 0, 47429, 60, 0, 0, 0),
("Pagan Temple", 1, 22164, -17589, -56499, -10850, 0, 0, 37846, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22165, -15635, -53961, -11565, 0, 0, 60699, 60, 0, 0, 0),
("Pagan Temple", 1, 22165, -16274, -56950, -10850, 0, 0, 38943, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22166, -14982, -53309, -11565, 0, 0, 36442, 60, 0, 0, 0),
("Pagan Temple", 1, 22166, -15665, -54709, -11565, 0, 0, 2099, 60, 0, 0, 0),
("Pagan Temple", 1, 22166, -15946, -56559, -10850, 0, 0, 51085, 60, 0, 0, 0),
("Pagan Temple", 1, 22166, -16591, -54688, -11565, 0, 0, 23897, 60, 0, 0, 0),
("Pagan Temple", 1, 22166, -17826, -53230, -11565, 0, 0, 35982, 60, 0, 0, 0),
-- Triol's High Priest
("Pagan Temple", 1, 22167, -17109, -54246, -11565, 0, 0, 42723, 60, 0, 0, 0),
("Pagan Temple", 1, 22167, -17535, -56542, -10850, 0, 0, 45583, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22168, -11919, -44432, -10725, 0, 0, 44579, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -12036, -49000, -10917, 0, 0, 561, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -12426, -47383, -10821, 0, 0, 45894, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -13852, -49069, -10917, 0, 0, 21528, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -14782, -46587, -10821, 0, 0, 64496, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -15300, -57065, -10850, 0, 0, 45680, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -16195, -56941, -10850, 0, 0, 64346, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -17489, -56574, -10850, 0, 0, 42536, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -17747, -47343, -10821, 0, 0, 25731, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -17844, -53590, -11565, 0, 0, 44758, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -18044, -44652, -10725, 0, 0, 46713, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -19366, -45267, -10725, 0, 0, 39762, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -20272, -47735, -10821, 0, 0, 924, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -20548, -49186, -10917, 0, 0, 55355, 60, 0, 0, 0),
("Pagan Temple", 1, 22168, -20593, -44559, -10725, 0, 0, 50212, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22169, -15001, -53177, -11565, 0, 0, 5290, 60, 0, 0, 0),
("Pagan Temple", 1, 22169, -15180, -57081, -10850, 0, 0, 48836, 60, 0, 0, 0),
("Pagan Temple", 1, 22169, -16250, -56843, -10850, 0, 0, 55221, 60, 0, 0, 0),
-- Triol's Believer
("Pagan Temple", 1, 22170, -17198, -54245, -11565, 0, 0, 28900, 60, 0, 0, 0),
("Pagan Temple", 1, 22170, -17217, -53386, -11565, 0, 0, 29991, 60, 0, 0, 0),
("Pagan Temple", 1, 22170, -17549, -57089, -10850, 0, 0, 56649, 60, 0, 0, 0),
-- Triol's High Priest
("Pagan Temple", 1, 22171, -15616, -53897, -11565, 0, 0, 52028, 60, 0, 0, 0),
("Pagan Temple", 1, 22171, -15764, -56612, -10850, 0, 0, 15163, 60, 0, 0, 0),
("Pagan Temple", 1, 22171, -20819, -49287, -10917, 0, 0, 61766, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22172, -15051, -56457, -10850, 0, 0, 35459, 60, 0, 0, 0),
("Pagan Temple", 1, 22172, -16483, -53313, -11565, 0, 0, 44967, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22173, -14983, -56505, -10850, 0, 0, 22943, 60, 0, 0, 0),
("Pagan Temple", 1, 22173, -16401, -54207, -11565, 0, 0, 47014, 60, 0, 0, 0),
-- Triol's Priest
("Pagan Temple", 1, 22174, -17067, -54418, -11565, 0, 0, 56664, 60, 0, 0, 0),
("Pagan Temple", 1, 22174, -17074, -56518, -10850, 0, 0, 62892, 60, 0, 0, 0),
-- Andreas' Captain of the Royal Guard
("Pagan Temple", 1, 22175, -14960, -53437, -10629, 0, 0, 7820, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -14964, -53766, -10603, 0, 0, 20066, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -15225, -52968, -10603, 0, 0, 55924, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -15522, -52625, -10629, 0, 0, 17737, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -15676, -52576, -10603, 0, 0, 23075, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -15879, -52521, -10603, 0, 0, 63322, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -16420, -52481, -10603, 0, 0, 4302, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -16590, -52575, -10603, 0, 0, 11742, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -16835, -52485, -10603, 0, 0, 40331, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17051, -52639, -10629, 0, 0, 4607, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17461, -52839, -10603, 0, 0, 13423, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17604, -53050, -10603, 0, 0, 39469, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17641, -53350, -10629, 0, 0, 14056, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17710, -53768, -10603, 0, 0, 47067, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17753, -53950, -10629, 0, 0, 14260, 60, 0, 0, 0),
("Pagan Temple", 1, 22175, -17841, -54312, -10603, 0, 0, 14180, 60, 0, 0, 0),
-- Andreas' Royal Guards
("Pagan Temple", 1, 22176, -16156, -47121, -10821, 0, 0, 16129, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16157, -46340, -10821, 0, 0, 16468, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16164, -48534, -10917, 0, 0, 16405, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16165, -49237, -10917, 0, 0, 16091, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16166, -47732, -10821, 0, 0, 16430, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16177, -49925, -10917, 0, 0, 16622, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16198, -44753, -10725, 0, 0, 16583, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16497, -48344, -10917, 0, 0, 16215, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16513, -49019, -10917, 0, 0, 15756, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16529, -46310, -10821, 0, 0, 17047, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16530, -47027, -10821, 0, 0, 16487, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16532, -47633, -10821, 0, 0, 16242, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16552, -49694, -10917, 0, 0, 15784, 60, 0, 0, 0),
("Pagan Temple", 1, 22176, -16594, -45094, -10725, 0, 0, 16166, 60, 0, 0, 0),
-- Andreas' Captain of the Royal Guard
("Pagan Temple", 1, 22188, -16341, -53449, -10449, 0, 0, 17661, 60, 0, 0, 0),
-- Andreas' Royal Guards
("Pagan Temple", 1, 22189, -16199, -53591, -10449, 0, 0, 14881, 60, 0, 0, 0),
("Pagan Temple", 1, 22189, -16331, -53260, -10449, 0, 0, 6134, 60, 0, 0, 0),
("Pagan Temple", 1, 22189, -16479, -53528, -10449, 0, 0, 11646, 60, 0, 0, 0),
-- Ritual Sacrifice
("Pagan Temple", 1, 22190, -15847, -53336, -10449, 0, 0, 31957, 60, 0, 0, 0),
("Pagan Temple", 1, 22190, -16297, -53086, -10449, 0, 0, 7806, 60, 0, 0, 0),
("Pagan Temple", 1, 22190, -16712, -53438, -10449, 0, 0, 4083, 60, 0, 0, 0),
-- Penance Guard
("Pagan Temple", 1, 22194, -11166, -43464, -10833, 0, 0, 32364, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11166, -43552, -10838, 0, 0, 32364, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11166, -43638, -10841, 0, 0, 32364, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11192, -39726, -10831, 0, 0, 31528, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11192, -39813, -10832, 0, 0, 31528, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11192, -39905, -10832, 0, 0, 31528, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11204, -41782, -10829, 0, 0, 32668, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11206, -41597, -10827, 0, 0, 32668, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11206, -41690, -10841, 0, 0, 32668, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11234, -37857, -10835, 0, 0, 30762, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11234, -37951, -10835, 0, 0, 30762, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -11234, -38039, -10821, 0, 0, 30762, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21521, -41586, -10850, 0, 0, 703, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21521, -41675, -10838, 0, 0, 703, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21521, -41762, -10826, 0, 0, 703, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21522, -39722, -10822, 0, 0, 2407, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21522, -39819, -10852, 0, 0, 2407, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21522, -39910, -10825, 0, 0, 2407, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21529, -43460, -10825, 0, 0, 99, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21529, -43548, -10831, 0, 0, 99, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21529, -43642, -10814, 0, 0, 99, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21531, -37854, -10831, 0, 0, 65271, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21531, -37951, -10845, 0, 0, 65271, 60, 0, 0, 0),
("Pagan Temple", 1, 22194, -21531, -38032, -10835, 0, 0, 65271, 60, 0, 0, 0),
-- Temple Gatekeeper
("Pagan Temple", 1, 32034, -15934, -36605, -10693, 0, 0, 15439, 60, 0, 0, 0),
-- Temple Gatekeeper
("Pagan Temple", 1, 32035, -16722, -36928, -10725, 0, 0, 52401, 60, 0, 0, 0),
-- Temple Gatekeeper
("Pagan Temple", 1, 32036, -15853, -43811, -10685, 0, 0, 16384, 60, 0, 0, 0),
-- Temple Gatekeeper
("Pagan Temple", 1, 32037, -16629, -44290, -10725, 0, 0, 54566, 60, 0, 0, 0),
-- Triol's Mirror
("Pagan Temple", 1, 32040, -11986, -35903, -10857, 0, 0, 31655, 60, 0, 0, 0),
-- Triol's Revelation
("Pagan Temple", 1, 32068, -12479, -54302, -11114, 0, 0, 20834, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -12761, -52626, -10938, 0, 0, 58419, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -14590, -52790, -11013, 0, 0, 54609, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -14686, -54745, -10603, 0, 0, 19962, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -15223, -54847, -10449, 0, 0, 11069, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -16396, -56768, -10850, 0, 0, 12416, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -17342, -54874, -10449, 0, 0, 12821, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -18079, -54816, -10603, 0, 0, 975, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -18161, -52778, -11013, 0, 0, 52976, 60, 0, 0, 0),
("Pagan Temple", 1, 32068, -20229, -54359, -11114, 0, 0, 51269, 60, 0, 0, 0),

-- [19_18]

-- Green Fungus
("Dark_Elf_Village", 1, 20007, -7874, 22997, -3480, 0, 0, 32787, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7891, 23367, -3464, 0, 0, 56676, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7419, 24684, -3488, 0, 0, 9183, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7605, 22973, -3496, 0, 0, 34979, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7548, 22981, -3504, 0, 0, 49964, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -8650, 24793, -3616, 0, 0, 11153, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9462, 24609, -3632, 0, 0, 24189, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -11070, 22634, -3648, 0, 0, 61003, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -14463, 25877, -3640, 0, 0, 47066, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10972, 22793, -3648, 0, 0, 27825, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10649, 21059, -3704, 0, 0, 29577, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10007, 21885, -3640, 0, 0, 4684, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9778, 22014, -3680, 0, 0, 24079, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -12484, 19851, -3672, 0, 0, 36354, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9418, 20587, -3704, 0, 0, 16315, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10066, 20594, -3704, 0, 0, 23560, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10294, 16680, -3696, 0, 0, 10665, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -11227, 17534, -3696, 0, 0, 63928, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10998, 17075, -3712, 0, 0, 59779, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9946, 18666, -3648, 0, 0, 11305, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -10105, 14475, -3496, 0, 0, 27809, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -11750, 13043, -3712, 0, 0, 35522, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7758, 12840, -2816, 0, 0, 2397, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -6962, 13306, -2696, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7131, 12870, -2656, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9776, 12030, -3360, 0, 0, 43499, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9196, 11945, -3232, 0, 0, 41057, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -8711, 12039, -3104, 0, 0, 12703, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9209, 10942, -3176, 0, 0, 8804, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9098, 9486, -3160, 0, 0, 31402, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -7677, 9154, -3040, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -8131, 8515, -3168, 0, 0, 5990, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -8291, 10114, -3000, 0, 0, 8101, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -9485, 7486, -3424, 0, 0, 44505, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -11425, 6030, -3472, 0, 0, 48044, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -11723, 9471, -3576, 0, 0, 12213, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -17874, 20888, -3720, 0, 0, 22375, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -18614, 23106, -3704, 0, 0, 50364, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -19166, 24281, -3440, 0, 0, 4680, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20007, -21830, 23214, -3640, 0, 0, 27540, 20, 0, 0, 0),
-- Marsh Zombie
("Dark_Elf_Village", 1, 20015, -16830, 31715, -3672, 0, 0, 8645, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -17472, 32449, -3712, 0, 0, 45301, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -17132, 31836, -3680, 0, 0, 40739, 16, 0, 0, 0),
-- Goblin Thief
("Dark_Elf_Village", 1, 20321, -12120, 10549, -3592, 0, 0, 46769, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -11996, 10616, -3592, 0, 0, 22701, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -11708, 5657, -3448, 0, 0, 43679, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -13510, 6302, -3448, 0, 0, 44847, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -13728, 7082, -3488, 0, 0, 24111, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -14229, 6845, -3432, 0, 0, 27905, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -12171, 10574, -3592, 0, 0, 9624, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -12353, 11915, -3696, 0, 0, 31816, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -12277, 10839, -3592, 0, 0, 12264, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -12391, 11776, -3680, 0, 0, 38162, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -16152, 10202, -3584, 0, 0, 54937, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -16093, 24478, -3624, 0, 0, 27233, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -14747, 23887, -3640, 0, 0, 48679, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -14995, 23217, -3712, 0, 0, 36427, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -17061, 18567, -3712, 0, 0, 7019, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -16655, 18536, -3696, 0, 0, 32648, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -17012, 19292, -3648, 0, 0, 1933, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -18109, 15573, -3160, 0, 0, 22714, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -18206, 10176, -3320, 0, 0, 54253, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -19045, 10197, -3192, 0, 0, 60806, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -17730, 10099, -3400, 0, 0, 43326, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -18144, 10226, -3344, 0, 0, 62237, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -20775, 11656, -3000, 0, 0, 39618, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -17833, 9956, -3384, 0, 0, 55335, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -16919, 8707, -3432, 0, 0, 10586, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -19058, 18455, -3664, 0, 0, 9198, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -19982, 18568, -3680, 0, 0, 63919, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -15254, 7329, -3472, 0, 0, 18805, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -16407, 24231, -3640, 0, 0, 21142, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -17238, 25343, -3464, 0, 0, 32508, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -20009, 22010, -3696, 0, 0, 53671, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -20047, 23814, -3544, 0, 0, 64826, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -19622, 23770, -3560, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -20900, 23295, -3632, 0, 0, 30125, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20321, -21411, 23423, -3624, 0, 0, 32290, 20, 0, 0, 0),
-- Goblin Lookout
("Dark_Elf_Village", 1, 20328, -7491, 24920, -3536, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7529, 24668, -3504, 0, 0, 27352, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7520, 24573, -3488, 0, 0, 49245, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -9058, 24686, -3608, 0, 0, 7352, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -11740, 23043, -3640, 0, 0, 9457, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -11692, 23162, -3640, 0, 0, 64239, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -10530, 24629, -3672, 0, 0, 17572, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -10328, 24731, -3664, 0, 0, 7731, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -12222, 20872, -3648, 0, 0, 49981, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -12463, 20888, -3648, 0, 0, 25030, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -13132, 20792, -3688, 0, 0, 15190, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -10641, 20527, -3712, 0, 0, 16383, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -11343, 22543, -3640, 0, 0, 44001, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -8919, 20579, -3624, 0, 0, 16145, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -9995, 18680, -3672, 0, 0, 39749, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -9541, 16545, -3608, 0, 0, 5414, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -10492, 15709, -3632, 0, 0, 47673, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -10597, 16073, -3664, 0, 0, 50566, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -11420, 16088, -3688, 0, 0, 63872, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -11079, 13890, -3656, 0, 0, 13009, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -8857, 13877, -3232, 0, 0, 42263, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -9226, 12262, -3256, 0, 0, 60543, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -9701, 12223, -3376, 0, 0, 55220, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -8119, 12521, -2944, 0, 0, 33649, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7961, 12043, -2888, 0, 0, 36738, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7829, 11211, -2816, 0, 0, 62910, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7138, 12399, -2664, 0, 0, 24071, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -7881, 11846, -2856, 0, 0, 25195, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -12752, 7826, -3520, 0, 0, 44612, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -13010, 7491, -3512, 0, 0, 16781, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -12424, 7840, -3184, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -14764, 7273, -3456, 0, 0, 36144, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20328, -15195, 7452, -3480, 0, 0, 32172, 20, 0, 0, 0),
-- Balor Orc Archer
("Dark_Elf_Village", 1, 20385, -10545, 20578, -3704, 0, 0, 38408, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -10218, 21839, -3632, 0, 0, 61548, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -10160, 21081, -3688, 0, 0, 63539, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -10660, 16405, -3680, 0, 0, 42015, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -10581, 15804, -3640, 0, 0, 8781, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -11705, 13127, -3712, 0, 0, 32407, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -11320, 6301, -3472, 0, 0, 4105, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -13257, 11049, -3688, 0, 0, 36708, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -12288, 12017, -3696, 0, 0, 12994, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -13939, 10229, -3648, 0, 0, 52243, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -18236, 10209, -3320, 0, 0, 42104, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -17254, 9049, -3416, 0, 0, 37105, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -17155, 9496, -3424, 0, 0, 15289, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -21373, 18511, -3680, 0, 0, 9137, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -20249, 18544, -3688, 0, 0, 5708, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -19758, 21497, -3720, 0, 0, 15323, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -18684, 22941, -3704, 0, 0, 61030, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20385, -21769, 23011, -3656, 0, 0, 34622, 20, 0, 0, 0),
-- Balor Orc Fighter
("Dark_Elf_Village", 1, 20386, -13493, 20615, -3712, 0, 0, 12414, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -10093, 22311, -3656, 0, 0, 15323, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -13984, 20182, -3712, 0, 0, 45126, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -13323, 12234, -3664, 0, 0, 17863, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -9027, 8368, -2872, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -8221, 8719, -3152, 0, 0, 4867, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -8554, 8762, -3160, 0, 0, 62557, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -7407, 8630, -3080, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -9297, 7844, -3368, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -11197, 6499, -3472, 0, 0, 44458, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -10330, 6899, -3472, 0, 0, 24837, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -11343, 7987, -3504, 0, 0, 21736, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -12997, 12153, -3656, 0, 0, 52354, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -14118, 10428, -3688, 0, 0, 15289, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -12391, 11097, -3608, 0, 0, 33863, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -12150, 10698, -3592, 0, 0, 57271, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -12324, 10724, -3600, 0, 0, 25100, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -12359, 11213, -3608, 0, 0, 23602, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -15149, 11343, -3608, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -14395, 22965, -3704, 0, 0, 7246, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -18093, 18651, -3720, 0, 0, 24825, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -18358, 18856, -3704, 0, 0, 61361, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -16518, 19880, -3224, 0, 0, 25751, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -16607, 21832, -3712, 0, 0, 29763, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -18739, 18550, -3672, 0, 0, 21030, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19062, 18527, -3672, 0, 0, 22105, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19655, 18443, -3656, 0, 0, 10104, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19675, 18510, -3656, 0, 0, 22840, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19235, 18507, -3664, 0, 0, 12994, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19832, 18492, -3656, 0, 0, 16925, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -18092, 23961, -3616, 0, 0, 54488, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -17531, 23313, -3672, 0, 0, 44930, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -19577, 22923, -3672, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20386, -20470, 22538, -3664, 0, 0, 10294, 20, 0, 0, 0),
-- Balor Orc Fighter Leader
("Dark_Elf_Village", 1, 20387, -12885, 10855, -3672, 0, 0, 31149, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -12373, 11144, -3608, 0, 0, 35256, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -15507, 9889, -3664, 0, 0, 34413, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -14520, 10171, -3672, 0, 0, 48663, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -14322, 14648, -3696, 0, 0, 3864, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -18644, 10223, -3264, 0, 0, 64324, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -19913, 13848, -3344, 0, 0, 42480, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -19529, 15963, -3704, 0, 0, 3577, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -18108, 10217, -3344, 0, 0, 5492, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -17593, 10216, -3416, 0, 0, 47396, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -17878, 10056, -3384, 0, 0, 46496, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -17867, 9978, -3384, 0, 0, 20418, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -20781, 18474, -3696, 0, 0, 13597, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -21279, 17292, -3672, 0, 0, 49083, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -19513, 16667, -3704, 0, 0, 53332, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -20182, 18498, -3680, 0, 0, 15112, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -25116, 17279, -3632, 0, 0, 7596, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -26120, 16679, -3592, 0, 0, 4458, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -25264, 18522, -3648, 0, 0, 12160, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -26499, 20328, -3640, 0, 0, 33772, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -26103, 18996, -3640, 0, 0, 34318, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -25164, 19235, -3664, 0, 0, 24924, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -24378, 19687, -3696, 0, 0, 50731, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -27472, 17606, -3600, 0, 0, 1549, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -28643, 20241, -3536, 0, 0, 20509, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -28338, 24264, -3528, 0, 0, 16383, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -28717, 25854, -3456, 0, 0, 45179, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -27625, 27644, -3400, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -27261, 28002, -3552, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -28628, 28297, -3504, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -29081, 29434, -3344, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -30532, 30277, -3296, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20387, -29188, 29737, -3320, 0, 0, 0, 20, 0, 0, 0),
-- Balor Orc Lieutenant
("Dark_Elf_Village", 1, 20388, -12252, 11909, -3696, 0, 0, 65221, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -14238, 10181, -3656, 0, 0, 51198, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -16080, 9500, -3600, 0, 0, 61782, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -15053, 9975, -3672, 0, 0, 578, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -14530, 10186, -3672, 0, 0, 41408, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -14455, 12998, -3656, 0, 0, 5662, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -16444, 18552, -3704, 0, 0, 9461, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -16527, 18678, -3688, 0, 0, 5213, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -18046, 18455, -3720, 0, 0, 25028, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -16590, 18456, -3704, 0, 0, 2389, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -18175, 18195, -3712, 0, 0, 64539, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -18421, 10149, -3304, 0, 0, 58909, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -18327, 10058, -3304, 0, 0, 62396, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -18105, 10055, -3344, 0, 0, 51263, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -17593, 9501, -3392, 0, 0, 8191, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -21017, 16466, -3608, 0, 0, 17444, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -24028, 17657, -3640, 0, 0, 47034, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -20708, 18489, -3704, 0, 0, 19024, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -20529, 18466, -3696, 0, 0, 12649, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -20803, 18452, -3696, 0, 0, 8688, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -20938, 18461, -3696, 0, 0, 28592, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -19540, 18566, -3664, 0, 0, 12114, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -20163, 18530, -3680, 0, 0, 10221, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -26040, 18565, -3640, 0, 0, 15393, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -24614, 19315, -3688, 0, 0, 13367, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -21155, 18599, -3696, 0, 0, 54082, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -27583, 19277, -3624, 0, 0, 65397, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -25438, 20494, -3696, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -25922, 21204, -3656, 0, 0, 46327, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -28454, 23003, -3464, 0, 0, 11736, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -29445, 25496, -3304, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -29081, 27286, -3496, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -29809, 28002, -3456, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -30084, 27037, -3456, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -30420, 29377, -3304, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -28353, 29076, -3400, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -25492, 24352, -3728, 0, 0, 263, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -25630, 24250, -3720, 0, 0, 25556, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20388, -25366, 24088, -3720, 0, 0, 32884, 20, 0, 0, 0),
-- Blood Fungus
("Dark_Elf_Village", 1, 20400, -14351, 23915, -3640, 0, 0, 32252, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -17999, 18577, -3728, 0, 0, 27340, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -18054, 18618, -3720, 0, 0, 48002, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -18098, 18854, -3728, 0, 0, 17757, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -16655, 21356, -3704, 0, 0, 42305, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20612, 18500, -3704, 0, 0, 11790, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -21687, 18525, -3688, 0, 0, 20946, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20764, 18548, -3696, 0, 0, 17267, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20694, 18555, -3704, 0, 0, 18568, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -19047, 18540, -3672, 0, 0, 15840, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -19300, 18451, -3664, 0, 0, 24094, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -25756, 16661, -3616, 0, 0, 541, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -27040, 17851, -3624, 0, 0, 32722, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -27272, 20978, -3528, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -25948, 21460, -3632, 0, 0, 29926, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -27112, 24277, -3632, 0, 0, 56645, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -29445, 25854, -3328, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -29809, 28718, -3392, 0, 0, 54018, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -30537, 29792, -3280, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -26606, 25664, -3696, 0, 0, 26873, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -26272, 25953, -3680, 0, 0, 8119, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -26411, 26100, -3680, 0, 0, 52380, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -26280, 26126, -3672, 0, 0, 42115, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20350, 18956, -3720, 0, 0, 19960, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20072, 24307, -3400, 0, 0, 0, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -19785, 23189, -3648, 0, 0, 54375, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20400, -20009, 22682, -3664, 0, 0, 18986, 20, 0, 0, 0),
-- Festering Bat
("Dark_Elf_Village", 1, 20433, -16732, 32250, -3712, 0, 0, 43927, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -17201, 32459, -3712, 0, 0, 22319, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -17982, 32422, -3688, 0, 0, 27298, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -18183, 32476, -3664, 0, 0, 65235, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -14465, 32076, -3448, 0, 0, 53054, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -16244, 31883, -3712, 0, 0, 50642, 16, 0, 0, 0),
-- Lesser Ancient Scout
("CatacombDarkOmen", 1, 21162, -19177, 15369, -4904, 0, 0, 64055, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -19169, 14732, -4904, 0, 0, 47062, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -19100, 17910, -4904, 0, 0, 52011, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -18151, 17435, -4906, 0, 0, 33713, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -17944, 16724, -4906, 0, 0, 46848, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -17786, 15520, -4904, 0, 0, 16980, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -17723, 17784, -4904, 0, 0, 52003, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -17671, 14619, -4904, 0, 0, 64915, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -17274, 13729, -4927, 0, 0, 34466, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -16506, 13961, -4927, 0, 0, 9862, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -16391, 16057, -4906, 0, 0, 6336, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -16021, 16385, -4906, 0, 0, 17919, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -15435, 14593, -4927, 0, 0, 49317, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -15194, 15137, -4906, 0, 0, 32598, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -14902, 15324, -4906, 0, 0, 15836, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -14678, 18096, -4904, 0, 0, 34538, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21162, -14484, 13269, -4904, 0, 0, 16914, 120, 0, 0, 0),
-- Lesser Ancient Shaman
("CatacombDarkOmen", 1, 21163, -13525, 16255, -4904, 0, 0, 43174, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -13407, 17912, -4904, 0, 0, 20214, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -13390, 13266, -4904, 0, 0, 14662, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -13193, 15474, -4906, 0, 0, 6165, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -11757, 15885, -4906, 0, 0, 12509, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -11505, 18233, -4906, 0, 0, 35715, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -11342, 15572, -4925, 0, 0, 61404, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -11286, 13586, -4904, 0, 0, 34505, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -10888, 15684, -4927, 0, 0, 2304, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -10637, 13271, -4906, 0, 0, 14396, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -10511, 17985, -4906, 0, 0, 31176, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -8779, 14396, -4904, 0, 0, 13071, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -8777, 17916, -4904, 0, 0, 13974, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21163, -8586, 13507, -4904, 0, 0, 37757, 120, 0, 0, 0),
-- Lesser Ancient Warrior
("CatacombDarkOmen", 1, 21165, -13454, 21984, -4904, 0, 0, 65448, 120, 0, 0, 0);
INSERT INTO `spawnlist` VALUES
("CatacombDarkOmen", 1, 21165, -13401, 23606, -4904, 0, 0, 18775, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -13399, 19027, -4925, 0, 0, 50191, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -12961, 20627, -4904, 0, 0, 1298, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -12434, 20401, -4906, 0, 0, 49080, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -12369, 22394, -4906, 0, 0, 23111, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -12321, 20802, -4906, 0, 0, 52539, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -11870, 21888, -4904, 0, 0, 395, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -10582, 23132, -4906, 0, 0, 34178, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -10270, 23468, -4906, 0, 0, 43453, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -9611, 21695, -4904, 0, 0, 36510, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -9407, 21466, -4906, 0, 0, 50383, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -9064, 23817, -4904, 0, 0, 32899, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -8943, 16110, -4906, 0, 0, 36123, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -8782, 19092, -4904, 0, 0, 50140, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21165, -8666, 16557, -4904, 0, 0, 44197, 120, 0, 0, 0),
-- Lilim Slayer
("CatacombDarkOmen", 1, 21184, -19334, 18089, -4904, 0, 0, 2059, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -19020, 15803, -4904, 0, 0, 26915, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -18903, 15053, -4906, 0, 0, 17723, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -17949, 14828, -4925, 0, 0, 3007, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -17816, 15932, -4904, 0, 0, 13463, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -17804, 17446, -4904, 0, 0, 46698, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -17695, 18160, -4906, 0, 0, 49317, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -17688, 16770, -4906, 0, 0, 52578, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -16979, 13717, -4904, 0, 0, 39091, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -16252, 13698, -4906, 0, 0, 7758, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -16022, 16020, -4906, 0, 0, 55710, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -15884, 15064, -4906, 0, 0, 32443, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -15439, 16133, -4904, 0, 0, 1419, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -15229, 14888, -4904, 0, 0, 32412, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -14478, 13709, -4904, 0, 0, 49409, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -14377, 14912, -4904, 0, 0, 23695, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21184, -14308, 18112, -4904, 0, 0, 64774, 120, 0, 0, 0),
-- Lilim Great Magus
("CatacombDarkOmen", 1, 21185, -13423, 15776, -4904, 0, 0, 57513, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -13403, 13691, -4904, 0, 0, 19201, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -13388, 18269, -4904, 0, 0, 19244, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -13208, 16178, -4906, 0, 0, 37821, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -12200, 15493, -4904, 0, 0, 31349, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -11385, 15489, -4906, 0, 0, 22287, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -10978, 17909, -4906, 0, 0, 52939, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -10968, 15411, -4906, 0, 0, 43018, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -10751, 13659, -4906, 0, 0, 19807, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -10618, 13518, -4904, 0, 0, 32334, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -9056, 13506, -4904, 0, 0, 33474, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -8794, 18296, -4904, 0, 0, 16672, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21185, -8766, 14782, -4904, 0, 0, 41538, 120, 0, 0, 0),
-- Lilim Guard Knight
("CatacombDarkOmen", 1, 21186, -13573, 19193, -4904, 0, 0, 877, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -13180, 23811, -4904, 0, 0, 0, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12980, 20423, -4906, 0, 0, 10611, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12888, 21791, -4906, 0, 0, 63496, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12683, 22329, -4906, 0, 0, 6794, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12639, 20708, -4904, 0, 0, 53202, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12249, 20532, -4906, 0, 0, 57881, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -12006, 21985, -4904, 0, 0, 1759, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -10387, 22700, -4904, 0, 0, 16092, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -10258, 23131, -4904, 0, 0, 422, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -9936, 21760, -4904, 0, 0, 39099, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -9013, 19191, -4904, 0, 0, 61265, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -8873, 21630, -4904, 0, 0, 38632, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -8833, 15811, -4904, 0, 0, 20763, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -8773, 23548, -4904, 0, 0, 14577, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21186, -8726, 16767, -4904, 0, 0, 54843, 120, 0, 0, 0),
-- Nephilim Royal Guard
("CatacombDarkOmen", 1, 21205, -19253, 15587, -4906, 0, 0, 12946, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -19170, 15028, -4904, 0, 0, 1702, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -19082, 18271, -4904, 0, 0, 53120, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -18154, 14656, -4904, 0, 0, 64427, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -17996, 18010, -4906, 0, 0, 48873, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -17992, 15701, -4904, 0, 0, 65033, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -17888, 16908, -4904, 0, 0, 58498, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -17419, 17529, -4906, 0, 0, 65275, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -16935, 13960, -4906, 0, 0, 52867, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -16471, 16332, -4904, 0, 0, 9915, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -16239, 13948, -4906, 0, 0, 64864, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -15888, 14834, -4906, 0, 0, 32768, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -15547, 16321, -4904, 0, 0, 626, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -14946, 14848, -4906, 0, 0, 17136, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -14760, 15030, -4904, 0, 0, 32884, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -14480, 18299, -4904, 0, 0, 48661, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21205, -14226, 13498, -4904, 0, 0, 3302, 120, 0, 0, 0),
-- Nephilim Cardinal
("CatacombDarkOmen", 1, 21206, -13579, 15927, -4906, 0, 0, 44380, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -13215, 15705, -4906, 0, 0, 2121, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -13211, 18108, -4904, 0, 0, 608, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -13197, 13509, -4904, 0, 0, 6643, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -11705, 15405, -4906, 0, 0, 35858, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -11332, 13378, -4927, 0, 0, 32187, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -11244, 15267, -4906, 0, 0, 50612, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -11136, 18034, -4904, 0, 0, 34690, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -10830, 17926, -4906, 0, 0, 51128, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -10708, 15476, -4906, 0, 0, 64202, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -10282, 13504, -4904, 0, 0, 34632, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -8765, 13728, -4904, 0, 0, 36334, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -8634, 18101, -4904, 0, 0, 31046, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21206, -8546, 14590, -4904, 0, 0, 31506, 120, 0, 0, 0),
-- Nephilim Commander
("CatacombDarkOmen", 1, 21207, -13592, 23808, -4904, 0, 0, 4486, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -13476, 20417, -4906, 0, 0, 64923, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -13181, 19204, -4904, 0, 0, 1597, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -13167, 21770, -4906, 0, 0, 56247, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -12561, 22034, -4904, 0, 0, 61814, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -12367, 20297, -4906, 0, 0, 40533, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -12272, 22175, -4906, 0, 0, 105, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -11928, 20756, -4904, 0, 0, 64543, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -10556, 22978, -4906, 0, 0, 36279, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -10525, 23663, -4906, 0, 0, 53351, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -9643, 21470, -4906, 0, 0, 55531, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -9248, 21907, -4906, 0, 0, 35919, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -8923, 16280, -4906, 0, 0, 34680, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -8773, 24014, -4904, 0, 0, 48239, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -8604, 19208, -4904, 0, 0, 32003, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21207, -8581, 16266, -4927, 0, 0, 39746, 120, 0, 0, 0),
-- Crypt Preacher
("CatacombDarkOmen", 1, 21253, -18967, 14774, -4906, 0, 0, 47671, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -18933, 18110, -4904, 0, 0, 32198, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -18855, 15370, -4906, 0, 0, 10831, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -18142, 17264, -4906, 0, 0, 34850, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -17928, 14482, -4904, 0, 0, 15529, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -17689, 17118, -4927, 0, 0, 57543, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -17631, 15702, -4904, 0, 0, 35287, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -17433, 17783, -4906, 0, 0, 62810, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -17250, 13918, -4904, 0, 0, 27932, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -16720, 13710, -4904, 0, 0, 62624, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -16187, 16407, -4906, 0, 0, 14434, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -15778, 16276, -4904, 0, 0, 10482, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -15634, 14556, -4906, 0, 0, 51451, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -15578, 14974, -4904, 0, 0, 51085, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -14735, 13504, -4904, 0, 0, 33209, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -14650, 15310, -4927, 0, 0, 18820, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21253, -14478, 17933, -4904, 0, 0, 49152, 120, 0, 0, 0),
-- Tomb Guard
("CatacombDarkOmen", 1, 21254, -13638, 13501, -4904, 0, 0, 34088, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -13596, 18100, -4904, 0, 0, 32768, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -13449, 15489, -4904, 0, 0, 47338, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -13320, 16462, -4904, 0, 0, 28800, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -12274, 15697, -4906, 0, 0, 35951, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -11502, 15849, -4906, 0, 0, 17066, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -11497, 15216, -4906, 0, 0, 52855, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -11488, 18014, -4904, 0, 0, 32966, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -11081, 13356, -4906, 0, 0, 14194, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -10563, 13714, -4906, 0, 0, 19246, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -10499, 18229, -4906, 0, 0, 33511, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -9027, 18112, -4904, 0, 0, 33419, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -8981, 14586, -4904, 0, 0, 33505, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21254, -8775, 13306, -4904, 0, 0, 22893, 120, 0, 0, 0),
-- Tomb Preacher
("CatacombDarkOmen", 1, 21255, -13392, 19374, -4904, 0, 0, 50465, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -13384, 24002, -4904, 0, 0, 49152, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -13382, 20716, -4925, 0, 0, 3804, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -13033, 22051, -4904, 0, 0, 5257, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -12624, 20238, -4906, 0, 0, 55580, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -12306, 21787, -4927, 0, 0, 57146, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -11924, 20577, -4904, 0, 0, 81, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -11892, 22154, -4927, 0, 0, 64576, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -10488, 23398, -4906, 0, 0, 48392, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -10258, 22966, -4906, 0, 0, 61239, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -9877, 21537, -4906, 0, 0, 29860, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -8957, 16697, -4906, 0, 0, 44119, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -8828, 21921, -4906, 0, 0, 35728, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -8819, 19394, -4904, 0, 0, 15464, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -8576, 15936, -4927, 0, 0, 22447, 120, 0, 0, 0),
("CatacombDarkOmen", 1, 21255, -8565, 23808, -4904, 0, 0, 33147, 120, 0, 0, 0),
-- Sentry
("Dark_Elf_Village_Npc", 1, 31034, -11606, 27214, -3016, 0, 0, 22727, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -15235, 10207, -3680, 0, 0, 40693, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -26294, 25095, -3712, 0, 0, 11802, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -19123, 21454, -3704, 0, 0, 16861, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -19937, 30046, -2480, 0, 0, 54116, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq04_npc1918_02", 1, 31118, -19888, 13504, -4899, 0, 0, 32500, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq04_npc1918_01", 1, 31124, -19072, 13504, -4897, 0, 0, 0, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq04_npc1918_03", 1, 31506, -19309, 13210, -4927, 0, 0, 16000, 60, 0, 0, 0),
-- Bloody Pixy
("Dark_Elf_Village_Npc", 1, 31845, -18245, 10122, -3320, 0, 0, 50725, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -14748, 29766, -3576, 0, 0, 16977, 60, 0, 0, 0),
-- Blight Treant
("Dark_Elf_Village_Npc", 1, 31850, -6151, 26309, -3344, 0, 0, 14324, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -8547, 18117, -3384, 0, 0, 51896, 60, 0, 0, 0),

-- [19_19]

-- Marsh Zombie
("Dark_Elf_Village", 1, 20015, -19044, 34028, -3376, 0, 0, 40739, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -22050, 43248, -3744, 0, 0, 45448, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -12345, 37226, -3696, 0, 0, 18526, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -17817, 38311, -3448, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -17793, 39030, -3528, 0, 0, 47584, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19654, 37971, -3088, 0, 0, 18526, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19405, 40848, -3768, 0, 0, 4764, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19088, 40288, -3592, 0, 0, 4764, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -21658, 41814, -3480, 0, 0, 51658, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -21421, 42568, -3624, 0, 0, 62829, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -20108, 35277, -3048, 0, 0, 21798, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19561, 35302, -3056, 0, 0, 40508, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19827, 35287, -3056, 0, 0, 57492, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -19034, 35526, -3064, 0, 0, 7300, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -15438, 36391, -3584, 0, 0, 44410, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -11697, 35750, -3600, 0, 0, 54199, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -13826, 34000, -3480, 0, 0, 9840, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -13691, 33874, -3424, 0, 0, 32767, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -16426, 34569, -3560, 0, 0, 27788, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -16659, 33155, -3592, 0, 0, 9302, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20015, -18834, 34569, -3192, 0, 0, 0, 16, 0, 0, 0),
-- Marsh Zombie Lord
("Dark_Elf_Village", 1, 20020, -28854, 44935, -3592, 0, 0, 63437, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28115, 40599, -3280, 0, 0, 31257, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27269, 41607, -3392, 0, 0, 57492, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27121, 42392, -3528, 0, 0, 29820, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28632, 42713, -3432, 0, 0, 64905, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27726, 46373, -3664, 0, 0, 58669, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27976, 47204, -3648, 0, 0, 16170, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28008, 50191, -3720, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -26368, 50605, -3768, 0, 0, 18526, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28562, 52311, -3624, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -26018, 51322, -3760, 0, 0, 39955, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25738, 51763, -3744, 0, 0, 63661, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -17338, 47461, -3728, 0, 0, 45994, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9461, 48545, -3696, 0, 0, 39955, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9444, 48055, -3752, 0, 0, 35716, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9347, 48157, -3736, 0, 0, 2758, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9425, 49748, -3664, 0, 0, 32441, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9379, 50386, -3696, 0, 0, 41259, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9760, 49706, -3672, 0, 0, 51333, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9481, 50428, -3704, 0, 0, 46973, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -7682, 47414, -3704, 0, 0, 60630, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -17468, 46695, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -16033, 46557, -3768, 0, 0, 53620, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -15085, 46332, -3696, 0, 0, 30625, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -22046, 45494, -3760, 0, 0, 37034, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -20866, 47317, -3696, 0, 0, 25254, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -21320, 48744, -3768, 0, 0, 19994, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -17886, 44524, -3688, 0, 0, 63849, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -22484, 44096, -3760, 0, 0, 5826, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -23792, 48601, -3728, 0, 0, 38728, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -24310, 48769, -3744, 0, 0, 41183, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25483, 46677, -3768, 0, 0, 59115, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25746, 50163, -3768, 0, 0, 50721, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28008, 48919, -3688, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27813, 44092, -3640, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28501, 44550, -3632, 0, 0, 29075, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27559, 43392, -3656, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -27840, 42088, -3432, 0, 0, 23896, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -28755, 41276, -3288, 0, 0, 39733, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25302, 42746, -3440, 0, 0, 12414, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25016, 42435, -3392, 0, 0, 1722, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -26346, 45951, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -26797, 41992, -3424, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -24511, 43042, -3624, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -24257, 43042, -3672, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -24961, 47223, -3712, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -18865, 41162, -3768, 0, 0, 2555, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -20280, 42553, -3696, 0, 0, 53989, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -16599, 41653, -3768, 0, 0, 55803, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -16021, 43013, -3760, 0, 0, 23421, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -15360, 42650, -3752, 0, 0, 54683, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -12413, 42761, -3776, 0, 0, 62677, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -11025, 41013, -3696, 0, 0, 60006, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9964, 37571, -3472, 0, 0, 55803, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -9454, 40606, -3736, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -14856, 40667, -3744, 0, 0, 38551, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -18152, 38639, -3408, 0, 0, 55371, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -19934, 37981, -3024, 0, 0, 62705, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -19597, 39959, -3504, 0, 0, 44457, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -19367, 39409, -3400, 0, 0, 55459, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -19628, 40441, -3608, 0, 0, 64815, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -26543, 38842, -3272, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -25074, 40210, -3056, 0, 0, 57492, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20020, -29393, 48071, -3640, 0, 0, 0, 16, 0, 0, 0),
-- Lesser Dark Horror
("Dark_Elf_Village", 1, 20025, -28918, 47305, -3664, 0, 0, 25585, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -28242, 50524, -3728, 0, 0, 43511, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -26208, 50498, -3768, 0, 0, 51639, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -25779, 50212, -3768, 0, 0, 62225, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -27177, 51887, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -28416, 51506, -3648, 0, 0, 14669, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -26112, 51204, -3760, 0, 0, 40558, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24639, 57266, -3736, 0, 0, 64992, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -27146, 57608, -3656, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -27501, 58283, -3672, 0, 0, 55381, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -27114, 57595, -3664, 0, 0, 13845, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -25711, 57608, -3776, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24542, 58846, -3760, 0, 0, 1551, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -25670, 60772, -3608, 0, 0, 17789, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24276, 60611, -3640, 0, 0, 36958, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -23811, 57494, -3768, 0, 0, 29333, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24298, 61296, -3624, 0, 0, 1935, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24062, 61161, -3624, 0, 0, 15859, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22004, 58293, -3768, 0, 0, 5707, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18234, 55158, -3720, 0, 0, 1359, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18821, 56449, -3744, 0, 0, 7003, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18831, 56247, -3744, 0, 0, 8761, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18359, 55465, -3728, 0, 0, 61559, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -19627, 52823, -3760, 0, 0, 9425, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -20116, 51672, -3664, 0, 0, 5430, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -20443, 52080, -3664, 0, 0, 28910, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -19670, 52488, -3744, 0, 0, 9961, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -14573, 51749, -3776, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -21559, 52405, -3752, 0, 0, 36207, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -21279, 53310, -3616, 0, 0, 4030, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22849, 51525, -3736, 0, 0, 15971, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -23751, 54464, -3672, 0, 0, 49224, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -24173, 56166, -3760, 0, 0, 1379, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -23256, 55849, -3760, 0, 0, 51440, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22711, 57487, -3760, 0, 0, 6408, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -13421, 50243, -3696, 0, 0, 53286, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -12211, 50165, -3752, 0, 0, 44296, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -12460, 52299, -3688, 0, 0, 7076, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -14195, 47754, -3760, 0, 0, 22240, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -13404, 48526, -3752, 0, 0, 4779, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -12023, 50583, -3752, 0, 0, 50961, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -11551, 52801, -3720, 0, 0, 2386, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -12281, 52725, -3712, 0, 0, 58648, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -11755, 49807, -3760, 0, 0, 37223, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -11798, 51175, -3752, 0, 0, 50356, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -10110, 50606, -3712, 0, 0, 57144, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -10607, 49466, -3720, 0, 0, 61931, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -10585, 45167, -3776, 0, 0, 25955, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -8455, 46573, -3752, 0, 0, 33272, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -10716, 44795, -3752, 0, 0, 34340, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -9876, 43954, -3712, 0, 0, 8099, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -9767, 51325, -3704, 0, 0, 48655, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18335, 46051, -3704, 0, 0, 24844, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -15819, 46615, -3768, 0, 0, 14110, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18969, 46390, -3624, 0, 0, 48845, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -19921, 48611, -3744, 0, 0, 32339, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -18520, 47226, -3632, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22487, 46325, -3760, 0, 0, 21049, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22214, 48240, -3752, 0, 0, 55391, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22242, 49208, -3776, 0, 0, 40860, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -17550, 43935, -3680, 0, 0, 30270, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22659, 47366, -3760, 0, 0, 56220, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -22763, 50894, -3784, 0, 0, 53650, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -25104, 47911, -3696, 0, 0, 61664, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -28008, 45527, -3648, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -26346, 45951, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -25792, 46799, -3768, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -27454, 47647, -3704, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -14327, 41245, -3704, 0, 0, 38764, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -15642, 43699, -3608, 0, 0, 42019, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -13656, 42634, -3648, 0, 0, 32991, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -13471, 42054, -3768, 0, 0, 11145, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -8924, 38726, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -9984, 38726, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -11357, 37844, -3680, 0, 0, 35915, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -14323, 40496, -3752, 0, 0, 63150, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -28485, 53297, -3608, 0, 0, 13193, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20025, -28405, 55479, -3648, 0, 0, 44444, 16, 0, 0, 0),
-- Dark Horror
("Dark_Elf_Village", 1, 20105, -21330, 59701, -3608, 0, 0, 45827, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21734, 59452, -3672, 0, 0, 33530, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -19378, 58177, -3776, 0, 0, 35019, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -16891, 54456, -3744, 0, 0, 52449, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -17795, 54994, -3736, 0, 0, 64163, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -16989, 55291, -3768, 0, 0, 94, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -18255, 55921, -3736, 0, 0, 63793, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -16455, 57188, -3656, 0, 0, 23475, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -20305, 54935, -3760, 0, 0, 59246, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -18859, 53667, -3768, 0, 0, 11488, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -20149, 55446, -3768, 0, 0, 10742, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -18276, 52134, -3688, 0, 0, 24002, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -17312, 52669, -3680, 0, 0, 47201, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -22532, 52281, -3632, 0, 0, 14120, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21606, 54334, -3656, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21483, 53507, -3608, 0, 0, 40458, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21388, 54290, -3744, 0, 0, 57790, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -15102, 49496, -3752, 0, 0, 31697, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -15546, 49645, -3752, 0, 0, 63682, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -14127, 49582, -3760, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -13796, 49197, -3752, 0, 0, 64525, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -14011, 49823, -3664, 0, 0, 2221, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -13369, 49151, -3744, 0, 0, 36679, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -13521, 48332, -3752, 0, 0, 10441, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -12165, 50717, -3744, 0, 0, 31112, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -11335, 49209, -3776, 0, 0, 33624, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -10764, 50023, -3744, 0, 0, 17716, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -10320, 49846, -3696, 0, 0, 55120, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -13803, 46676, -3632, 0, 0, 22905, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -16359, 46878, -3760, 0, 0, 18647, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -16180, 46715, -3768, 0, 0, 23634, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21849, 45838, -3736, 0, 0, 19022, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -21941, 47099, -3728, 0, 0, 56139, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20105, -24667, 50040, -3760, 0, 0, 3405, 16, 0, 0, 0),
-- Stone Soldier
("Dark_Elf_Village", 1, 20379, -28839, 47223, -3656, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -27454, 47223, -3664, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -25686, 45772, -3760, 0, 0, 41034, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -28285, 51887, -3632, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -27089, 51499, -3736, 0, 0, 408, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -19626, 53790, -3760, 0, 0, 36430, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -21385, 51396, -3736, 0, 0, 19343, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -20773, 52121, -3680, 0, 0, 59479, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -19508, 49226, -3672, 0, 0, 63344, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -20119, 50749, -3744, 0, 0, 15138, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -24223, 53501, -3696, 0, 0, 38068, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -24149, 55202, -3656, 0, 0, 34424, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -12213, 51742, -3728, 0, 0, 58689, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -17675, 47406, -3704, 0, 0, 2704, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -12160, 51399, -3752, 0, 0, 15344, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -10543, 52393, -3688, 0, 0, 43480, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -12259, 45718, -3760, 0, 0, 1019, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -9858, 46304, -3760, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -8598, 48608, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -8695, 47394, -3744, 0, 0, 25162, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -9503, 48058, -3760, 0, 0, 7312, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -7753, 43915, -3720, 0, 0, 44271, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -9659, 51964, -3704, 0, 0, 65262, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -10178, 51422, -3688, 0, 0, 31624, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -10150, 52193, -3688, 0, 0, 31624, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -9396, 52193, -3688, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -16679, 45633, -3784, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -16679, 46695, -3768, 0, 0, 5942, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -15654, 46774, -3768, 0, 0, 6732, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -16014, 45635, -3768, 0, 0, 6739, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -15189, 46673, -3720, 0, 0, 33182, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -19921, 48936, -3752, 0, 0, 23980, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -21453, 45854, -3680, 0, 0, 45926, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -20610, 49308, -3744, 0, 0, 14080, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -21257, 44567, -3752, 0, 0, 50808, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -22913, 48403, -3768, 0, 0, 28001, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -25238, 45527, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -26696, 50576, -3768, 0, 0, 4928, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -26117, 51945, -3744, 0, 0, 51212, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -26995, 46479, -3760, 0, 0, 16939, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -16357, 41619, -3776, 0, 0, 10994, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -14773, 40833, -3720, 0, 0, 22502, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -12592, 43988, -3592, 0, 0, 62634, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -11535, 40688, -3768, 0, 0, 49153, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -13738, 40969, -3768, 0, 0, 57773, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -14152, 40056, -3752, 0, 0, 15344, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -28839, 46375, -3664, 0, 0, 35691, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -28839, 45951, -3368, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -29749, 49552, -3520, 0, 0, 14297, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -30688, 63581, -3600, 0, 0, 7324, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -29298, 63960, -3616, 0, 0, 64037, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -30333, 64278, -3600, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20379, -30322, 64151, -3600, 0, 0, 60274, 16, 0, 0, 0),
-- Redeye Bat
("Dark_Elf_Village", 1, 20392, -27146, 56321, -3688, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -27329, 56491, -3688, 0, 0, 55155, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -26271, 56597, -3728, 0, 0, 11282, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -27365, 57692, -3648, 0, 0, 42283, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -26572, 58037, -3704, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -24850, 57608, -3752, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -25503, 59497, -3672, 0, 0, 27701, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -24822, 57843, -3760, 0, 0, 2983, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -24620, 61375, -3624, 0, 0, 57604, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -24276, 60611, -3640, 0, 0, 43709, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -28589, 63871, -3616, 0, 0, 30375, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -27357, 64533, -3648, 0, 0, 4650, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -22697, 59747, -3688, 0, 0, 35737, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -21784, 59006, -3768, 0, 0, 53307, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -19805, 57512, -3712, 0, 0, 27895, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -18014, 58199, -3760, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -18425, 59390, -3688, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -17297, 58220, -3752, 0, 0, 63300, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11536, 53158, -3712, 0, 0, 19764, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -16911, 54888, -3776, 0, 0, 45164, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -16796, 56320, -3752, 0, 0, 50732, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -19563, 54267, -3768, 0, 0, 44812, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -19895, 54937, -3776, 0, 0, 27529, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -18625, 55632, -3744, 0, 0, 10031, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -18258, 51736, -3696, 0, 0, 55896, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -22180, 54987, -3672, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -22349, 55096, -3688, 0, 0, 5212, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -23154, 55255, -3760, 0, 0, 12715, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -23320, 54062, -3696, 0, 0, 24613, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -22828, 55944, -3760, 0, 0, 40289, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -23029, 55132, -3744, 0, 0, 62065, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -12646, 49383, -3760, 0, 0, 31869, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -12780, 50340, -3760, 0, 0, 29411, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -12767, 51038, -3744, 0, 0, 10954, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -13208, 48468, -3752, 0, 0, 62045, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -12131, 50150, -3752, 0, 0, 2105, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11993, 50382, -3744, 0, 0, 63313, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11962, 48567, -3752, 0, 0, 59621, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11054, 49301, -3776, 0, 0, 15960, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11236, 51670, -3680, 0, 0, 8608, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -10725, 51966, -3680, 0, 0, 8186, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9773, 52537, -3680, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -12902, 46621, -3640, 0, 0, 46559, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -10698, 46304, -3736, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -10050, 48687, -3696, 0, 0, 40366, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9988, 47859, -3760, 0, 0, 37958, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9383, 50125, -3680, 0, 0, 39449, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -7908, 47342, -3704, 0, 0, 28515, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -6500, 43639, -3760, 0, 0, 49364, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9687, 51306, -3704, 0, 0, 20497, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9577, 51597, -3704, 0, 0, 37594, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -9969, 52336, -3680, 0, 0, 17016, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -11892, 43094, -3768, 0, 0, 21432, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -28221, 53397, -3616, 0, 0, 41618, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -31687, 63690, -3552, 0, 0, 28641, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -30055, 63847, -3624, 0, 0, 30615, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20392, -26859, 60611, -3568, 0, 0, 0, 16, 0, 0, 0),
-- Festering Bat
("Dark_Elf_Village", 1, 20433, -19198, 34105, -3344, 0, 0, 19922, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19929, 34251, -3224, 0, 0, 20057, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19398, 34518, -3192, 0, 0, 14713, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26764, 42595, -3520, 0, 0, 45103, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28423, 42098, -3368, 0, 0, 21413, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -27055, 42366, -3520, 0, 0, 29378, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28481, 44827, -3640, 0, 0, 368, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -27959, 44445, -3632, 0, 0, 25622, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -32042, 52727, -3456, 0, 0, 5189, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -32301, 52423, -3432, 0, 0, 12290, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -32134, 54964, -3392, 0, 0, 4600, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -31649, 54871, -3440, 0, 0, 39362, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -30739, 54828, -3472, 0, 0, 20580, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -29685, 60723, -3360, 0, 0, 23414, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -29821, 62878, -3560, 0, 0, 988, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -30298, 63293, -3608, 0, 0, 38683, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -29180, 61994, -3416, 0, 0, 50337, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28589, 64202, -3624, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28002, 64883, -3600, 0, 0, 17245, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26927, 65037, -3672, 0, 0, 35900, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -16950, 47333, -3760, 0, 0, 17157, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -16082, 47408, -3760, 0, 0, 2172, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -15484, 45470, -3728, 0, 0, 23955, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -15717, 45997, -3744, 0, 0, 28200, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -22506, 46135, -3768, 0, 0, 26238, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -22277, 48306, -3776, 0, 0, 22231, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -23729, 49048, -3760, 0, 0, 26899, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28302, 43970, -3648, 0, 0, 24692, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26797, 44442, -3680, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -28274, 42196, -3424, 0, 0, 12503, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -25553, 42477, -3424, 0, 0, 15727, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -25642, 41136, -3184, 0, 0, 27725, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19144, 41350, -3760, 0, 0, 58364, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -13211, 42264, -3760, 0, 0, 52260, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -14241, 42730, -3600, 0, 0, 59752, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -9454, 38350, -3760, 0, 0, 25612, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -8927, 37255, -3696, 0, 0, 6192, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -9586, 37330, -3696, 0, 0, 31444, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -10361, 38773, -3728, 0, 0, 27470, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -14195, 40434, -3768, 0, 0, 60842, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -18171, 37599, -3296, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19587, 38311, -3144, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -20295, 38311, -2976, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19564, 39865, -3480, 0, 0, 36407, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -21727, 42352, -3568, 0, 0, 5331, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -20331, 42877, -3696, 0, 0, 5212, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26035, 40942, -3176, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26289, 40592, -3176, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -26404, 40097, -3152, 0, 0, 34743, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -25755, 39863, -3072, 0, 0, 42615, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -25482, 40321, -3088, 0, 0, 29228, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -27426, 39960, -3272, 0, 0, 25548, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19243, 34725, -3152, 0, 0, 8482, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19003, 35115, -3112, 0, 0, 61546, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -12506, 36486, -3720, 0, 0, 53203, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -12648, 36291, -3712, 0, 0, 53883, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -10484, 35210, -3600, 0, 0, 45691, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -10980, 34634, -3488, 0, 0, 1314, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -13290, 34202, -3456, 0, 0, 11148, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -13196, 33425, -3296, 0, 0, 35672, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -15523, 34569, -3576, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -17682, 34388, -3416, 0, 0, 20190, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -17586, 34801, -3344, 0, 0, 30366, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -19436, 34292, -3272, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -20038, 34292, -3200, 0, 0, 0, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -31722, 56489, -3384, 0, 0, 46865, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -31722, 61960, -3496, 0, 0, 7913, 16, 0, 0, 0),
("Dark_Elf_Village", 1, 20433, -30226, 61505, -3440, 0, 0, 17740, 16, 0, 0, 0),
-- Black Willow Lurker
("Dark_Elf_Village", 1, 27079, -25339, 50226, -3760, 0, 0, 32899, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -24948, 54444, -3752, 0, 0, 41193, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -18498, 54124, -3768, 0, 0, 24850, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -21315, 57236, -3752, 0, 0, 54219, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -15555, 48346, -3760, 0, 0, 1552, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -11519, 45570, -3760, 0, 0, 25106, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -20020, 48368, -3768, 0, 0, 1906, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -18327, 44115, -3688, 0, 0, 19739, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27079, -13193, 41359, -3776, 0, 0, 50960, 180, 0, 0, 0),
-- Shyslassys
("Dark_Elf_Village", 1, 27110, -3336, 53135, -3480, 0, 0, 0, 180, 0, 0, 0),
-- Black Willow
("Dark_Elf_Village", 1, 27118, -10958, 57596, -3720, 0, 0, 29015, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27118, -11472, 57915, -3720, 0, 0, 15344, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27118, -11089, 58277, -3696, 0, 0, 24758, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27118, -9610, 57821, -3632, 0, 0, 41113, 180, 0, 0, 0),
("Dark_Elf_Village", 1, 27118, -9982, 57638, -3648, 0, 0, 63764, 180, 0, 0, 0),
-- Charkeren
("Dark_Elf_Village_Npc", 1, 30415, -11520, 57088, -3720, 0, 0, 18384, 60, 0, 0, 0),
-- Uruha
("Dark_Elf_Village_Npc", 1, 30652, -11692, 57028, -3712, 0, 0, 16384, 60, 0, 0, 0),
-- Mysterious Dark Elf
("Dark_Elf_Village_Npc", 1, 30661, -14158, 44933, -3592, 0, 0, 45056, 60, 0, 0, 0),
-- Piper Longbow
("Dark_Elf_Village_Npc", 1, 30662, -13742, 44298, -3592, 0, 0, 45056, 60, 0, 0, 0),
-- Katari
("Dark_Elf_Village_Npc", 1, 30668, -3826, 40264, -3672, 0, 0, 32768, 60, 0, 0, 0),
-- Holy Ark of Secrecy 1
("Dark_Elf_Village_Npc", 1, 30977, -418, 44174, -3568, 0, 0, 0, 60, 0, 0, 0),
-- Sentry
("Dark_Elf_Village_Npc", 1, 31034, -29594, 35490, -3352, 0, 0, 15240, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -31869, 51778, -3440, 0, 0, 6787, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -26542, 58877, -3648, 0, 0, 60560, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -7862, 51205, -3696, 0, 0, 31875, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -1904, 42441, -3680, 0, 0, 1390, 60, 0, 0, 0),
-- Bloody Pixy
("Dark_Elf_Village_Npc", 1, 31845, -26780, 60909, -3544, 0, 0, 62589, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -12007, 54903, -3584, 0, 0, 14202, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -22907, 54733, -3696, 0, 0, 16066, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31845, -26112, 39757, -3088, 0, 0, 11933, 60, 0, 0, 0),
-- Blight Treant
("Dark_Elf_Village_Npc", 1, 31850, -28463, 51046, -3688, 0, 0, 24432, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -24067, 61347, -3632, 0, 0, 61932, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31850, -17384, 44082, -3696, 0, 0, 19231, 60, 0, 0, 0),

-- [19_20]

-- Vuku Orc
("gludio38_1921_02", 1, 20009, -11667, 98036, -3292, 0, 0, 50602, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -11105, 97575, -3195, 0, 0, 52522, 30, 0, 0, 0),
-- Vuku Orc Archer
("gludio38_1921_01", 1, 20011, -15797, 97406, -3479, 0, 0, 40564, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -10770, 98260, -3299, 0, 0, 46664, 30, 0, 0, 0),
-- Shadow Beast
("gludio38_1921_01", 1, 20023, -19849, 98130, -3629, 0, 0, 51652, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -13007, 98087, -3363, 0, 0, 46789, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -15334, 97785, -3432, 0, 0, 5119, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -12375, 98276, -3311, 0, 0, 48158, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -10458, 97261, -3201, 0, 0, 60728, 30, 0, 0, 0),
-- Pincher
("gludio38_1921_01", 1, 20028, -18702, 97084, -3541, 0, 0, 36595, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -17983, 97900, -3573, 0, 0, 46727, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -19294, 98218, -3608, 0, 0, 64735, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -19371, 96758, -3542, 0, 0, 40075, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -16427, 98169, -3473, 0, 0, 30167, 30, 0, 0, 0),
-- Scavenger Wererat
("Elven_Village", 1, 20039, -14548, 75952, -3320, 0, 0, 31040, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -13644, 77168, -3400, 0, 0, 33186, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -5809, 82522, -3520, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -5542, 85112, -3616, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -5876, 83946, -3568, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -6796, 82956, -3512, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -7144, 85889, -3432, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -18702, 82046, -3568, 0, 0, 32708, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -18474, 81835, -3584, 0, 0, 31495, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -19393, 81524, -3640, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20039, -15430, 76238, -3360, 0, 0, 0, 20, 0, 0, 0),
-- Arachnid Tracker
("Dark_Elf_Village", 1, 20043, -15641, 74362, -3424, 0, 0, 56972, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -14299, 74882, -3296, 0, 0, 59360, 20, 0, 0, 0),
("Dark_Elf_Village", 1, 20043, -15895, 75384, -3424, 0, 0, 16423, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -12076, 78627, -3472, 0, 0, 32080, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6823, 78296, -3416, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6391, 79786, -3400, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -7741, 79786, -3432, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -5508, 83946, -3576, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -5809, 83040, -3536, 0, 0, 54034, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6033, 82230, -3512, 0, 0, 58710, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6452, 83419, -3552, 0, 0, 11987, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6968, 84018, -3544, 0, 0, 5597, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -16411, 85010, -3664, 0, 0, 30848, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -18593, 82577, -3600, 0, 0, 25754, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -17325, 82251, -3624, 0, 0, 28357, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -16722, 79853, -3560, 0, 0, 52359, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -17848, 81522, -3632, 0, 0, 30957, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -18434, 81439, -3592, 0, 0, 24575, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -14466, 79491, -3408, 0, 0, 36854, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -17220, 75774, -3552, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -16302, 74948, -3496, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -6841, 80620, -3472, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -12119, 80951, -3472, 0, 0, 4659, 20, 0, 0, 0),
("Elven_Village", 1, 20043, -13632, 80341, -3432, 0, 0, 8219, 20, 0, 0, 0),
-- Lycanthrope
("Elven_Village", 1, 20049, -12619, 78485, -3456, 0, 0, 64310, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -11176, 78137, -3512, 0, 0, 22615, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -11534, 78239, -3496, 0, 0, 42705, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -11893, 78874, -3472, 0, 0, 10356, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -9451, 78355, -3464, 0, 0, 35785, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -6924, 78824, -3408, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -5941, 79786, -3384, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -5941, 77840, -3416, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -4224, 79458, -3456, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -5292, 78268, -3392, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -5576, 81040, -3416, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -1316, 79780, -3640, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -2445, 84599, -3672, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -1774, 85519, -3688, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -421, 85757, -3608, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -1433, 85757, -3696, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -14176, 82910, -3552, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -14138, 82570, -3528, 0, 0, 48348, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -15843, 77013, -3456, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -15430, 76802, -3408, 0, 0, 5047, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -15245, 76238, -3352, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20049, -10754, 79743, -3552, 0, 0, 65347, 20, 0, 0, 0),
-- Ratman Spy
("gludio38_1921_05", 1, 20360, -3135, 97858, -3884, 0, 0, 0, 30, 0, 0, 0),
-- Moonstone Beast
("Elven_Village", 1, 20369, -14346, 76669, -3360, 0, 0, 18054, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -14065, 77067, -3384, 0, 0, 56227, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -11320, 78665, -3504, 0, 0, 16702, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -9603, 76427, -3592, 0, 0, 36474, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -6621, 78384, -3408, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -8191, 79786, -3424, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -4332, 79054, -3416, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -3304, 78268, -3440, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -2168, 79780, -3608, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -1316, 82300, -3592, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -2951, 84985, -3688, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -674, 84985, -3592, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -4975, 85757, -3688, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -5784, 84441, -3584, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -6054, 85352, -3568, 0, 0, 58070, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -5008, 82522, -3576, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -7138, 83698, -3560, 0, 0, 44630, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -7234, 85269, -3400, 0, 0, 22840, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -11805, 83438, -3552, 0, 0, 6286, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -15311, 82113, -3560, 0, 0, 3852, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -14768, 83836, -3632, 0, 0, 38171, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -19129, 80648, -3664, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -14466, 79491, -3408, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -16761, 77013, -3528, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -15843, 76187, -3408, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -7516, 80898, -3416, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -11236, 79890, -3528, 0, 0, 8528, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -10305, 81054, -3584, 0, 0, 1894, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -10770, 81863, -3504, 0, 0, 12752, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -10620, 81658, -3536, 0, 0, 21077, 20, 0, 0, 0),
("Elven_Village", 1, 20369, -13237, 81115, -3464, 0, 0, 24575, 20, 0, 0, 0),
-- Red Scavenger Spider
("Elven_Village", 1, 20393, -4156, 79528, -3472, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -2928, 79458, -3552, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -2168, 79276, -3584, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -1316, 79276, -3648, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -1032, 82552, -3576, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -3710, 85178, -3712, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -1864, 85620, -3688, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -674, 84599, -3576, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20393, -4722, 85371, -3696, 0, 0, 0, 20, 0, 0, 0),
-- Scavenger Spider
("Elven_Village", 1, 20410, -14160, 84273, -3672, 0, 0, 13173, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -17936, 82672, -3600, 0, 0, 20658, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -19175, 81524, -3616, 0, 0, 63235, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -19674, 80648, -3664, 0, 0, 0, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -18584, 80648, -3616, 0, 0, 20325, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -19674, 81392, -3656, 0, 0, 13474, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -17976, 81514, -3624, 0, 0, 24415, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -16781, 80754, -3624, 0, 0, 32989, 20, 0, 0, 0),
("Elven_Village", 1, 20410, -12288, 81227, -3488, 0, 0, 29651, 20, 0, 0, 0),
-- Maille Lizardman Warrior
("gludio23_1921_03", 1, 20922, -23848, 98139, -3727, 0, 0, 39366, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -25452, 98175, -3727, 0, 0, 28278, 32, 0, 0, 0),
-- Maille Lizardman Shaman
("gludio23_1921_01", 1, 20923, -31864, 97218, -3872, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29422, 97322, -3703, 0, 0, 57150, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -25769, 97651, -3711, 0, 0, 37761, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29210, 98297, -3727, 0, 0, 34254, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29984, 97980, -3727, 0, 0, 36822, 32, 0, 0, 0),
-- Maille Lizardman Matriarch
("gludio23_1921_01", 1, 20924, -29791, 98298, -3727, 0, 0, 41658, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -27509, 98234, -3723, 0, 0, 65479, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29017, 97761, -3727, 0, 0, 45477, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -28263, 98144, -3727, 0, 0, 46313, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -24595, 98018, -3723, 0, 0, 14810, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -23193, 98022, -3723, 0, 0, 783, 32, 0, 0, 0),
-- King of the Araneid
("gludio23_1921_01", 1, 20927, -26437, 97960, -3727, 0, 0, 11868, 32, 0, 0, 0),
-- Purgatory Serpent
("PatriotsNecropolis", 1, 21153, -13192, 77853, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -10966, 77367, -5168, 0, 0, 12154, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -12310, 78921, -5168, 0, 0, 38075, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -10890, 79005, -5168, 0, 0, 65446, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -10878, 82173, -5168, 0, 0, 14014, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -15505, 81744, -5168, 0, 0, 52102, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -14625, 81016, -5168, 0, 0, 42860, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -14413, 81233, -5168, 0, 0, 18433, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -15908, 78761, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -15534, 78956, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -14454, 79578, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -15821, 77659, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -14828, 78610, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -11988, 80078, -5168, 0, 0, 42776, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -12744, 80020, -5168, 0, 0, 37241, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21153, -13267, 77485, -5168, 0, 0, 47519, 120, 0, 0, 0),
-- Hell Keeper Medusa
("PatriotsNecropolis", 1, 21154, -18485, 83188, -5168, 0, 0, 25314, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -18477, 83237, -5168, 0, 0, 30951, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -17640, 84081, -5168, 0, 0, 49342, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -17388, 86064, -5168, 0, 0, 19031, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -17282, 85716, -5168, 0, 0, 31044, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -18330, 87591, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -16819, 87709, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -19115, 84315, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -19574, 85907, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -19642, 86303, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -18462, 86790, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -21275, 84121, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -20563, 84601, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -21391, 87445, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -21183, 83321, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21154, -16950, 83345, -5168, 0, 0, 28102, 120, 0, 0, 0),
-- Purgatory Conjurer
("PatriotsNecropolis", 1, 21155, -18304, 83120, -5168, 0, 0, 15391, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -17969, 84352, -5168, 0, 0, 37179, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -16789, 85771, -5168, 0, 0, 1463, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -16969, 85382, -5168, 0, 0, 49627, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -18132, 86523, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -18231, 86167, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -16819, 87677, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -19086, 84594, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -19472, 85907, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -19336, 86105, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -21008, 84441, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -21008, 84121, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -21481, 87573, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -21513, 82887, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -19084, 83090, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21155, -16960, 83349, -5168, 0, 0, 15696, 120, 0, 0, 0),
-- Nephilim Swordsman
("PatriotsNecropolis", 1, 21198, -16783, 81793, -5168, 0, 0, 51646, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -21423, 82000, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19279, 82316, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20137, 81986, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20203, 81887, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -21452, 81690, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -21076, 80019, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19426, 80669, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19246, 80605, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20269, 80637, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20269, 80925, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19873, 81887, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18186, 80972, -5168, 0, 0, 17595, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -16943, 80782, -5168, 0, 0, 55602, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18021, 80797, -5168, 0, 0, 971, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -17396, 80792, -5168, 0, 0, 25675, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18418, 79003, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18450, 79255, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -21236, 79751, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -21108, 79282, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20884, 79215, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18642, 79255, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -18834, 79507, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19856, 77421, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20219, 77601, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -20186, 77601, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -19691, 77511, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -16847, 77155, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -16934, 77571, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21198, -16696, 82031, -5168, 0, 0, 49210, 120, 0, 0, 0),
-- Nephilim Guard
("PatriotsNecropolis", 1, 21199, -12709, 77938, -5168, 0, 0, 18743, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -13753, 77715, -5168, 0, 0, 24005, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12252, 78653, -5168, 0, 0, 26878, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14479, 79730, -5168, 0, 0, 34642, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -13600, 77612, -5168, 0, 0, 47022, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11086, 77669, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11021, 77595, -5168, 0, 0, 35893, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12066, 78577, -5168, 0, 0, 35029, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11749, 78606, -5168, 0, 0, 386, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11029, 79039, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12032, 79870, -5168, 0, 0, 4672, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11074, 81730, -5168, 0, 0, 37279, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -10823, 81761, -5168, 0, 0, 55033, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15620, 82196, -5168, 0, 0, 32842, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15465, 82203, -5168, 0, 0, 29596, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15534, 78761, -5168, 0, 0, 20865, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15874, 79476, -5168, 0, 0, 61206, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14534, 81109, -5168, 0, 0, 22909, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14546, 80831, -5168, 0, 0, 12347, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14766, 78550, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14766, 78790, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14518, 79578, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15976, 78696, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15597, 77340, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15821, 77253, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -15466, 78826, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14249, 81566, -5168, 0, 0, 22699, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -11986, 80341, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12071, 80386, -5168, 0, 0, 43222, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -14116, 80717, -5168, 0, 0, 15086, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12940, 79838, -5168, 0, 0, 54140, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21199, -12750, 77542, -5168, 0, 0, 34576, 120, 0, 0, 0),
-- Nephilim Bishop
("PatriotsNecropolis", 1, 21200, -16573, 83201, -5168, 0, 0, 49342, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -16763, 83383, -5168, 0, 0, 25561, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18518, 83237, -5168, 0, 0, 36455, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17883, 83319, -5168, 0, 0, 2294, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17921, 82855, -5168, 0, 0, 53183, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17845, 84381, -5168, 0, 0, 3355, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18018, 84378, -5168, 0, 0, 30335, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17161, 85518, -5168, 0, 0, 29381, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17177, 84971, -5168, 0, 0, 24777, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -17261, 85754, -5168, 0, 0, 46276, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -16943, 85870, -5168, 0, 0, 23190, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18264, 86523, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18066, 87146, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18363, 87769, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18033, 87235, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -16999, 87581, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19202, 84501, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19260, 84501, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -20118, 84249, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19812, 85709, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19676, 85643, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19404, 86237, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -19744, 86369, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -20563, 84249, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -20563, 84281, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -21097, 84089, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -21511, 87797, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -21541, 87573, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -21633, 83135, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -21333, 82856, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -18889, 83378, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21200, -16609, 87837, -5168, 0, 0, 0, 120, 0, 0, 0),
-- Sepulcher Inquisitor
("PatriotsNecropolis", 1, 21221, -19279, 81821, -5168, 0, 0, 17697, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -21626, 81783, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -19126, 80893, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -20359, 80541, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -20005, 81887, -5168, 0, 0, 15037, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -17751, 80482, -5168, 0, 0, 47287, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -17044, 80755, -5168, 0, 0, 10300, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -20852, 79483, -5168, 0, 0, 24204, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -21108, 79282, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -18738, 78562, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -18962, 78373, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -20054, 78501, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -19823, 78951, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -16731, 77379, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21221, -16867, 81809, -5168, 0, 0, 24491, 120, 0, 0, 0),
-- Sepulcher Archon
("PatriotsNecropolis", 1, 21222, -21394, 82124, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -19246, 80509, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -20059, 80893, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -19873, 81755, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -19147, 81821, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -18320, 80784, -5168, 0, 0, 17271, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -16580, 80529, -5168, 0, 0, 4708, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -18706, 78940, -5168, 0, 0, 21895, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -20980, 79148, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -21332, 79684, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -18962, 78499, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -20186, 77511, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -19889, 77691, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -16760, 77219, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21222, -16872, 82237, -5168, 0, 0, 20475, 120, 0, 0, 0),
-- Sepulcher Inquisitor
("PatriotsNecropolis", 1, 21223, -13329, 77862, -5168, 0, 0, 62461, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -12321, 79813, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -14516, 79850, -5168, 0, 0, 33359, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -11141, 77372, -5168, 0, 0, 21060, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -12028, 79852, -5168, 0, 0, 52621, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -12237, 78992, -5168, 0, 0, 29298, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -11957, 78566, -5168, 0, 0, 5860, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -11050, 81718, -5168, 0, 0, 52434, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -15958, 82264, -5168, 0, 0, 21418, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -14424, 80567, -5168, 0, 0, 8947, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -15772, 78891, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -15398, 79281, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -14366, 81536, -5168, 0, 0, 32688, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -14735, 78220, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -15917, 77572, -5168, 0, 0, 0, 120, 0, 0, 0),
("PatriotsNecropolis", 1, 21223, -13061, 77862, -5168, 0, 0, 2832, 120, 0, 0, 0),
-- Ol Mahum Sentry
("Elven_Village", 1, 27031, -8700, 72362, -3512, 0, 0, 0, 180, 0, 0, 0),
("Elven_Village", 1, 27031, -8556, 72333, -3512, 0, 0, 0, 180, 0, 0, 0),
-- Prias
("Elven_Village_Npc", 1, 30426, -9076, 72969, -3448, 0, 0, 57344, 60, 0, 0, 0),
-- Trionell
("Elven_Village_Npc", 1, 30430, -1152, 76125, -3576, 0, 0, 56616, 60, 0, 0, 0),
-- Eriel
("Elven_Village_Npc", 1, 30431, -1301, 75883, -3568, 0, 0, 60908, 60, 0, 0, 0),
-- Irene
("Dark_Elf_Village_Npc", 1, 30432, -15404, 71131, -3448, 0, 0, 40440, 60, 0, 0, 0),
-- Kathaway
("Dark_Elf_Village_Npc", 1, 30433, -15648, 71405, -3448, 0, 0, 40608, 60, 0, 0, 0),
-- Sentinel
("Elven_Village_Npc", 1, 31033, -3980, 66860, -3328, 0, 0, 62504, 60, 0, 0, 0),
-- Sentry
("Dark_Elf_Village_Npc", 1, 31034, -20260, 70711, -3584, 0, 0, 32960, 60, 0, 0, 0),
("Dark_Elf_Village_Npc", 1, 31034, -31538, 84791, -3392, 0, 0, 0, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq03_npc1920_02", 1, 31098, -22224, 77376, -5171, 0, 0, 32500, 60, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq03_npc1920_01", 1, 31106, -21392, 77376, -5169, 0, 0, 16500, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq03_npc1920_03", 1, 31500, -21635, 77075, -5168, 0, 0, 16000, 60, 0, 0, 0),
-- Bloody Pixy
("Dark_Elf_Village_Npc", 1, 31845, -19909, 68742, -3552, 0, 0, 37366, 60, 0, 0, 0),
-- Blight Treant
("Dark_Elf_Village_Npc", 1, 31850, -24483, 76369, -3584, 0, 0, 4223, 60, 0, 0, 0),

-- [19_21]

-- Prophet
("Prophet", 1, 4309, -14153, 121252, -2984, 0, 0, 7788, 60, 0, 0, 0),
-- Worshipper
("unset", 1, 4327, -14362, 120670, -2979, 0, 0, 64381, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, -14285, 120814, -2977, 0, 0, 10030, 0, 0, 0, 0),
("unset", 1, 4328, -14294, 120545, -2977, 0, 0, 60910, 0, 0, 0, 0),
-- Vuku Orc
("gludio38_1921_02", 1, 20009, -15448, 98417, -3368, 0, 0, 47741, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -16007, 100167, -3145, 0, 0, 3393, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -16787, 99904, -3293, 0, 0, 9606, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -10726, 99005, -3124, 0, 0, 290, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -12025, 100246, -2796, 0, 0, 36794, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -11357, 98945, -3130, 0, 0, 23712, 30, 0, 0, 0),
("gludio38_1921_02", 1, 20009, -11628, 99632, -2937, 0, 0, 34798, 30, 0, 0, 0),
-- Vuku Orc Archer
("gludio38_1921_01", 1, 20011, -18280, 99868, -3586, 0, 0, 6979, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -19795, 99092, -3727, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -17292, 99171, -3439, 0, 0, 25838, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -15051, 100307, -2962, 0, 0, 71, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -11243, 100474, -2713, 0, 0, 32622, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -12420, 99284, -3066, 0, 0, 36954, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20011, -10563, 100446, -2714, 0, 0, 60304, 30, 0, 0, 0),
-- Shadow Beast
("gludio38_1921_01", 1, 20023, -18713, 99023, -3714, 0, 0, 9864, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -20340, 99086, -3727, 0, 0, 32882, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -15216, 99452, -3632, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -13683, 99116, -3158, 0, 0, 12669, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -10923, 99771, -2865, 0, 0, 61142, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -11908, 98839, -3169, 0, 0, 9162, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20023, -11008, 101107, -2727, 0, 0, 25578, 30, 0, 0, 0),
-- Pincher
("gludio38_1921_01", 1, 20028, -17836, 98521, -3561, 0, 0, 59750, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -13685, 98421, -3324, 0, 0, 26435, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -12860, 98725, -3228, 0, 0, 30108, 30, 0, 0, 0),
("gludio38_1921_01", 1, 20028, -14495, 98796, -3256, 0, 0, 36683, 30, 0, 0, 0),
-- Pinrul
("gludio38_1921_05", 1, 20032, -2403, 98770, -3727, 0, 0, 40649, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -3034, 100732, -3616, 0, 0, 31895, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -2476, 100110, -3695, 0, 0, 56286, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -1671, 99491, -3727, 0, 0, 50583, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -1250, 100219, -3727, 0, 0, 242, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -6151, 102565, -2956, 0, 0, 42995, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -5183, 103362, -3059, 0, 0, 28816, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -2357, 100814, -3655, 0, 0, 47045, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -3473, 101397, -3513, 0, 0, 12374, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -2549, 101508, -3600, 0, 0, 34003, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -4634, 104130, -3065, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -3187, 105583, -3348, 0, 0, 29367, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -5339, 105732, -2979, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -4532, 104664, -3050, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -4258, 106833, -3225, 0, 0, 13021, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20032, -5339, 105376, -2920, 0, 0, 0, 30, 0, 0, 0),
-- Wandering Eye
("gludio35_1822_02", 1, 20055, -27296, 130944, -3684, 0, 0, 21991, 20, 0, 0, 0),
-- Ratman Hunter
("gludio38_1921_04", 1, 20358, -6850, 114634, -3354, 0, 0, 27017, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5520, 114074, -3347, 0, 0, 36232, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5541, 101736, -3116, 0, 0, 55793, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5025, 101545, -3235, 0, 0, 16717, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4067, 101002, -3485, 0, 0, 24223, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4696, 101096, -3336, 0, 0, 22166, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5440, 102686, -3061, 0, 0, 15285, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -3648, 100546, -3569, 0, 0, 52109, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -2981, 101216, -3580, 0, 0, 61859, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4129, 105732, -3176, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -2351, 105921, -3485, 0, 0, 75, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -2666, 104617, -3414, 0, 0, 64792, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -3098, 104200, -3361, 0, 0, 40775, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -3828, 104842, -3215, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -6742, 108744, -3972, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5984, 110715, -3259, 0, 0, 6924, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5714, 111633, -3312, 0, 0, 1177, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -7043, 109634, -3972, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -6676, 113029, -3356, 0, 0, 13314, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4412, 110803, -3326, 0, 0, 18988, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5554, 111149, -3307, 0, 0, 28382, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4476, 109159, -3284, 0, 0, 54904, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4091, 109413, -3317, 0, 0, 6083, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -6840, 112488, -3292, 0, 0, 25268, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -4099, 108986, -3312, 0, 0, 48956, 30, 0, 0, 0),
("gludio38_1921_04", 1, 20358, -5783, 109895, -3236, 0, 0, 36700, 30, 0, 0, 0),
-- Ratman Warrior
("gludio35_1821_01", 1, 20359, -32589, 130878, -2983, 0, 0, 2088, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -23089, 130525, -3664, 0, 0, 47689, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -26001, 128437, -3515, 0, 0, 56448, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -26310, 129875, -3723, 0, 0, 40301, 20, 0, 0, 0),
-- Ratman Spy
("gludio38_1921_05", 1, 20360, -3168, 98370, -3727, 0, 0, 38690, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -3586, 99024, -3689, 0, 0, 22316, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4458, 99340, -3677, 0, 0, 23887, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -1835, 100387, -3714, 0, 0, 29852, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -5238, 100204, -3916, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4416, 101741, -3333, 0, 0, 32295, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4735, 100382, -3916, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4678, 102782, -3185, 0, 0, 2791, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -3785, 101855, -3426, 0, 0, 36736, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -3097, 102083, -3509, 0, 0, 16232, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -6959, 101607, -2869, 0, 0, 30244, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -6114, 101550, -3038, 0, 0, 35154, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -5148, 100813, -3286, 0, 0, 38602, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4936, 103952, -2995, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4029, 105198, -3162, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -5073, 104523, -2896, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4634, 103774, -3097, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -4230, 104842, -3120, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -3495, 103659, -3323, 0, 0, 62211, 30, 0, 0, 0),
("gludio38_1921_05", 1, 20360, -3710, 106715, -3305, 0, 0, 63323, 30, 0, 0, 0),
-- Bugbear Raider
("gludio38_1921_09s", 1, 20775, -3684, 109900, -3378, 0, 0, 22301, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -1285, 110689, -3704, 0, 0, 63649, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -2851, 109654, -3474, 0, 0, 29217, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -2230, 109434, -3571, 0, 0, 25542, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -1668, 109113, -3626, 0, 0, 42458, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -3099, 110508, -3467, 0, 0, 60443, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -1496, 109759, -3669, 0, 0, 47242, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -2708, 108736, -3484, 0, 0, 50915, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -911, 110057, -3687, 0, 0, 4915, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -2316, 110859, -3590, 0, 0, 4180, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -5398, 113089, -3347, 0, 0, 45487, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -5303, 112056, -3348, 0, 0, 43571, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -3898, 111249, -3381, 0, 0, 55573, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -4780, 112824, -3348, 0, 0, 61310, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -5055, 113735, -3347, 0, 0, 13138, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -4856, 111270, -3348, 0, 0, 54545, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -4535, 112322, -3352, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -4443, 111782, -3353, 0, 0, 16362, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -3613, 110781, -3416, 0, 0, 41795, 30, 0, 0, 0),
("gludio38_1921_09s", 1, 20775, -3189, 111279, -3465, 0, 0, 2690, 30, 0, 0, 0),
-- Maille Lizardman
("gludio23_1921_11", 1, 20919, -29208, 115892, -3612, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -29611, 116248, -3519, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -25934, 117651, -3720, 0, 0, 19804, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -27597, 117672, -3720, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -27196, 116960, -3727, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -29913, 116426, -3471, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -30115, 116782, -3440, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -28705, 116070, -3670, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -31322, 116782, -3080, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -28302, 118562, -3720, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -29309, 116070, -3578, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -26895, 116782, -3715, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -28304, 116426, -3718, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -32150, 116279, -2721, 0, 0, 10780, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -29764, 118902, -3590, 0, 0, 31244, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -30510, 123772, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -29805, 123238, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -27821, 123300, -3605, 0, 0, 54852, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -28603, 125356, -3404, 0, 0, 62621, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -22750, 118068, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -22597, 118882, -3668, 0, 0, 55860, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -24366, 122255, -3679, 0, 0, 39103, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -22140, 123387, -3551, 0, 0, 1720, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -21540, 120204, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -18799, 121020, -3240, 0, 0, 8579, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -23071, 122420, -3616, 0, 0, 14355, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -22649, 119314, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -21977, 121805, -3511, 0, 0, 31667, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -23057, 122760, -3624, 0, 0, 4409, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -25894, 124809, -3444, 0, 0, 31080, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -20108, 122371, -3326, 0, 0, 5340, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -25130, 117834, -3705, 0, 0, 31386, 32, 0, 0, 0),
("gludio23_1921_11", 1, 20919, -21339, 119848, -3398, 0, 0, 0, 32, 0, 0, 0),
-- Maille Lizardman Scout
("gludio23_1921_10", 1, 20920, -26147, 111585, -3684, 0, 0, 59432, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27248, 113220, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27248, 113932, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -26443, 112864, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -26497, 114741, -3554, 0, 0, 13732, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -30719, 117138, -3275, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -25046, 116903, -3703, 0, 0, 7623, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -29208, 117316, -3656, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27359, 118363, -3723, 0, 0, 19083, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -29108, 116782, -3656, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27999, 119096, -3727, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -26992, 118384, -3720, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -30215, 116960, -3424, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27699, 116782, -3720, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -30316, 116426, -3386, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -28100, 118918, -3727, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -30014, 116604, -3462, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -30718, 117850, -3229, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -26694, 116782, -3688, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -28704, 117850, -3714, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27266, 123933, -3575, 0, 0, 52650, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27600, 122576, -3628, 0, 0, 54060, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -27037, 124855, -3451, 0, 0, 6923, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -29602, 122526, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -22246, 119670, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -23657, 123810, -3591, 0, 0, 32151, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -21578, 122670, -3510, 0, 0, 30355, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -23446, 121602, -3620, 0, 0, 43379, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -22346, 120916, -3559, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -20907, 121079, -3397, 0, 0, 12119, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -20650, 122372, -3387, 0, 0, 61140, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -22394, 122375, -3575, 0, 0, 43775, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -19734, 121942, -3276, 0, 0, 52976, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -22044, 120738, -3517, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -23113, 123300, -3618, 0, 0, 16177, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -23241, 120565, -3598, 0, 0, 8735, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -25547, 124067, -3602, 0, 0, 28717, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -24747, 123566, -3691, 0, 0, 30536, 32, 0, 0, 0),
("gludio23_1921_10", 1, 20920, -22898, 124046, -3579, 0, 0, 8192, 32, 0, 0, 0),
-- Maille Lizardman Guard
("gludio23_1921_07", 1, 20921, -30104, 106948, -3451, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29298, 108372, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28393, 107838, -3711, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -30761, 106467, -3303, 0, 0, 46454, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31314, 108728, -3564, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29199, 107126, -3544, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -30306, 107304, -3447, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28796, 108194, -3680, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27199, 106218, -3723, 0, 0, 10397, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31413, 107838, -3408, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -32240, 112076, -2516, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31435, 113500, -2656, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -30530, 112610, -2527, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31333, 113322, -2672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -30731, 111898, -2527, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31033, 112076, -2527, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -31737, 112254, -2704, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27752, 113754, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -26443, 113220, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27147, 113042, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28727, 113338, -3393, 0, 0, 48555, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27450, 113220, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -24271, 119291, -3621, 0, 0, 4065, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29487, 112979, -3213, 0, 0, 61958, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27441, 117792, -3723, 0, 0, 29697, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29208, 118028, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28002, 116248, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28201, 117316, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -26223, 118796, -3715, 0, 0, 2213, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -27426, 119195, -3723, 0, 0, 21570, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28402, 117672, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28906, 117850, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -26894, 116426, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29142, 115280, -3545, 0, 0, 55414, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29813, 117316, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28605, 116604, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -26993, 123280, -3635, 0, 0, 3855, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -29504, 124128, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -30007, 123594, -3398, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -28440, 124575, -3476, 0, 0, 51512, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -23885, 122560, -3664, 0, 0, 57072, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -20359, 121267, -3332, 0, 0, 32928, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -21513, 121289, -3457, 0, 0, 47908, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -19479, 121134, -3271, 0, 0, 17442, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -23255, 119670, -3517, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -22764, 121578, -3586, 0, 0, 56166, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -22750, 119848, -3517, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -20713, 121736, -3368, 0, 0, 34826, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -20835, 122933, -3434, 0, 0, 47518, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -21944, 119136, -3517, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -23395, 122394, -3634, 0, 0, 54324, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -23382, 120761, -3613, 0, 0, 43756, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -23455, 118602, -3517, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20921, -22950, 120204, -3517, 0, 0, 0, 32, 0, 0, 0),
-- Maille Lizardman Warrior
("gludio23_1921_03", 1, 20922, -24461, 98326, -3727, 0, 0, 29680, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -23276, 100608, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -24081, 100252, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -23077, 100325, -3622, 0, 0, 43412, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -25189, 100786, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -26315, 99000, -3637, 0, 0, 63826, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -26604, 99989, -3663, 0, 0, 63913, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -27656, 100154, -3727, 0, 0, 7038, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -23175, 99006, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -25414, 101812, -3844, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -23568, 102843, -3651, 0, 0, 47484, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -26260, 102672, -3426, 0, 0, 42461, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -24744, 102424, -3585, 0, 0, 29413, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31458, 103154, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30805, 105715, -3178, 0, 0, 64554, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30752, 104756, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31421, 105362, -3018, 0, 0, 12500, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30954, 103688, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30652, 103510, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -29100, 103230, -3629, 0, 0, 63436, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -27954, 105859, -3650, 0, 0, 51269, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -29862, 105023, -3403, 0, 0, 7693, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -25097, 103537, -3449, 0, 0, 52237, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -28480, 104256, -3702, 0, 0, 55355, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -28989, 106037, -3512, 0, 0, 7639, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -28307, 105626, -3623, 0, 0, 10691, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30811, 108194, -3561, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -27768, 107877, -3723, 0, 0, 46518, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30306, 109084, -3621, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30910, 107660, -3458, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31741, 112378, -2688, 0, 0, 12040, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -28595, 107838, -3680, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30003, 107482, -3528, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31487, 105866, -3032, 0, 0, 30885, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30609, 108906, -3593, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -28696, 106948, -3615, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -29156, 108788, -3690, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -26512, 107667, -3691, 0, 0, 63907, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31937, 113322, -2527, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -32441, 112788, -2352, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30932, 111898, -2288, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -30430, 112788, -2973, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -32644, 113856, -2288, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -31134, 111542, -3077, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_03", 1, 20922, -32543, 113678, -2304, 0, 0, 0, 32, 0, 0, 0),
-- Maille Lizardman Shaman
("gludio23_1921_01", 1, 20923, -27935, 99290, -3727, 0, 0, 47429, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29153, 100219, -3677, 0, 0, 40537, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30141, 99906, -3641, 0, 0, 22662, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -28382, 101580, -3649, 0, 0, 10174, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30630, 98409, -3727, 0, 0, 44218, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30167, 100408, -3604, 0, 0, 37844, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -26710, 99505, -3619, 0, 0, 35927, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30606, 102490, -3344, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -31411, 101778, -3916, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30808, 101066, -3916, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -31815, 102134, -3916, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -27060, 99299, -3643, 0, 0, 55919, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -24685, 100252, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -25145, 99788, -3606, 0, 0, 10942, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -24040, 100635, -3695, 0, 0, 1248, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -25836, 100722, -3691, 0, 0, 14967, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -23678, 99896, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -23420, 100147, -3589, 0, 0, 22313, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -24213, 99944, -3590, 0, 0, 14516, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -25213, 98450, -3723, 0, 0, 43435, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -28392, 101055, -3664, 0, 0, 10970, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -23232, 98515, -3727, 0, 0, 41305, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -24725, 100536, -3686, 0, 0, 53112, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -23137, 101994, -3667, 0, 0, 55075, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -31660, 103510, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29604, 102241, -3564, 0, 0, 7764, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -28963, 102551, -3642, 0, 0, 3736, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -32138, 104299, -2802, 0, 0, 5341, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30752, 103332, -3069, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -31256, 104222, -3069, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -30289, 105276, -3282, 0, 0, 56847, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -27196, 108121, -3720, 0, 0, 13320, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -27037, 109759, -3713, 0, 0, 10453, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -25115, 104609, -3442, 0, 0, 47706, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -27631, 105018, -3719, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29601, 103118, -3544, 0, 0, 42714, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -28637, 103581, -3690, 0, 0, 50916, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -28651, 109678, -3707, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20923, -29055, 109322, -3692, 0, 0, 0, 32, 0, 0, 0),
-- Maille Lizardman Matriarch
("gludio23_1921_01", 1, 20924, -29543, 104894, -3481, 0, 0, 15082, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -28176, 98752, -3727, 0, 0, 20565, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -27763, 100647, -3725, 0, 0, 51235, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -31399, 100346, -3614, 0, 0, 62916, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -28637, 99306, -3727, 0, 0, 37322, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -30606, 101778, -3916, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -31311, 102312, -3916, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29545, 100937, -3574, 0, 0, 34654, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -28927, 101772, -3654, 0, 0, 49618, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -30396, 99271, -3726, 0, 0, 24382, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -24040, 100635, -3695, 0, 0, 1248, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -26661, 102985, -3289, 0, 0, 5529, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -22471, 100252, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -24080, 101320, -3812, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -22582, 101745, -3652, 0, 0, 27524, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -23953, 98776, -3727, 0, 0, 54830, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -24725, 100536, -3686, 0, 0, 53112, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -23595, 101622, -3703, 0, 0, 42523, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29814, 103963, -3428, 0, 0, 14602, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -26543, 100885, -3690, 0, 0, 40652, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -31458, 103510, -3069, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -32712, 104766, -2693, 0, 0, 57603, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -30954, 104400, -3672, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29984, 102962, -3474, 0, 0, 29276, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -26965, 105562, -3687, 0, 0, 828, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29041, 105018, -3538, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29482, 105428, -3468, 0, 0, 33400, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -26777, 103577, -3179, 0, 0, 57344, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -26031, 106716, -3530, 0, 0, 7114, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -28940, 106264, -3522, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -25835, 104147, -3380, 0, 0, 53016, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -27701, 110426, -3720, 0, 0, 45562, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -29696, 99276, -3726, 0, 0, 12675, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20924, -27283, 102517, -3220, 0, 0, 9933, 32, 0, 0, 0),
-- Giant Araneid
("gludio23_1921_07", 1, 20925, -28313, 105007, -3683, 0, 0, 40200, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29864, 107948, -3618, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -26844, 109821, -3694, 0, 0, 19283, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32172, 106412, -2914, 0, 0, 23584, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -30306, 108728, -3613, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29638, 109059, -3665, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29501, 107304, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32745, 107879, -2628, 0, 0, 13796, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -31033, 112432, -2896, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -31736, 112610, -2640, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -31838, 112076, -2688, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -30832, 112432, -2952, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32744, 113678, -2272, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -32240, 113144, -2416, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -31033, 111720, -3055, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27305, 114910, -3646, 0, 0, 6483, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27550, 114110, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27542, 111796, -3654, 0, 0, 38193, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -26342, 113042, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -28255, 114288, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29981, 118408, -3589, 0, 0, 2437, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -30618, 116604, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -26790, 120764, -3723, 0, 0, 40705, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29913, 116070, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -31222, 117672, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29438, 119529, -3701, 0, 0, 11162, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27257, 121968, -3692, 0, 0, 20245, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -28200, 118028, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -23999, 119919, -3621, 0, 0, 4276, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27679, 115756, -3721, 0, 0, 42312, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29712, 117138, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29813, 117672, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -30820, 116960, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -26638, 120003, -3723, 0, 0, 24495, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27422, 120585, -3723, 0, 0, 54888, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -29029, 120470, -3725, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -25784, 118489, -3704, 0, 0, 29502, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -27983, 121368, -3712, 0, 0, 49258, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -28986, 116648, -3671, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -28886, 117182, -3699, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -28483, 116470, -3711, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20925, -23943, 118352, -3671, 0, 0, 63278, 32, 0, 0, 0),
-- Poison Araneid
("gludio23_1921_07", 1, 20926, -27111, 106055, -3722, 0, 0, 26898, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29500, 108372, -3656, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31011, 108550, -3568, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28096, 106967, -3665, 0, 0, 18847, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28594, 108550, -3713, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -26537, 108758, -3660, 0, 0, 10285, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30687, 106060, -3276, 0, 0, 31350, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28869, 107616, -3605, 0, 0, 24782, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30329, 112610, -2527, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30997, 112920, -2799, 0, 0, 7133, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31938, 114034, -2564, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31636, 112788, -2632, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -32442, 114212, -2432, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31033, 112788, -2808, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31938, 111898, -2680, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30069, 113184, -3045, 0, 0, 57687, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -26101, 113786, -3573, 0, 0, 59156, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -27651, 113220, -3536, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28732, 113744, -3413, 0, 0, 60611, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30259, 113645, -2999, 0, 0, 19232, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -27297, 117138, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31423, 116604, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -27157, 116105, -3698, 0, 0, 47630, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -26586, 117498, -3723, 0, 0, 28900, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28108, 122783, -3622, 0, 0, 23917, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28100, 117494, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -30782, 118416, -3236, 0, 0, 39805, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29008, 117316, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -26444, 119348, -3723, 0, 0, 50223, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29107, 116070, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28315, 115334, -3673, 0, 0, 29592, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -26908, 121423, -3727, 0, 0, 40785, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -31423, 116960, -3702, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28177, 121999, -3652, 0, 0, 28526, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29443, 121737, -3689, 0, 0, 29495, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -27621, 119758, -3725, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28626, 120826, -3725, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29230, 120826, -3725, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -29299, 118579, -3704, 0, 0, 32720, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -24973, 117310, -3690, 0, 0, 23570, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -27779, 116648, -3727, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_07", 1, 20926, -28987, 117716, -3706, 0, 0, 0, 32, 0, 0, 0),
-- King of the Araneid
("gludio23_1921_01", 1, 20927, -32007, 102533, -3008, 0, 0, 13779, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -28470, 100083, -3726, 0, 0, 63485, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31603, 100980, -3519, 0, 0, 20093, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -32150, 101578, -3324, 0, 0, 13212, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -30785, 100355, -3599, 0, 0, 35067, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31726, 99782, -3715, 0, 0, 9448, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -29921, 101282, -3534, 0, 0, 18450, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -32617, 103855, -2720, 0, 0, 16291, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31467, 101373, -3422, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27530, 99412, -3705, 0, 0, 13182, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26879, 100292, -3704, 0, 0, 790, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27385, 103287, -3124, 0, 0, 27208, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27085, 98421, -3727, 0, 0, 26925, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25862, 98488, -3723, 0, 0, 40911, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -24245, 103622, -3519, 0, 0, 17744, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27202, 101890, -3324, 0, 0, 2982, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -24410, 99672, -3588, 0, 0, 19981, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25744, 99360, -3633, 0, 0, 23840, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -23802, 102214, -3677, 0, 0, 52562, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -23529, 98465, -3727, 0, 0, 58935, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -24541, 98543, -3727, 0, 0, 59067, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -24506, 101370, -3726, 0, 0, 62107, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25096, 100138, -3659, 0, 0, 29904, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -23576, 100585, -3669, 0, 0, 47013, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -28796, 107126, -3628, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27395, 109032, -3723, 0, 0, 42877, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25381, 105121, -3436, 0, 0, 60406, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -30609, 108550, -3583, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -28729, 109331, -3702, 0, 0, 24376, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -32627, 110039, -2578, 0, 0, 14308, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26088, 105687, -3439, 0, 0, 60066, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27306, 107073, -3723, 0, 0, 34365, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -30205, 109262, -3624, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31736, 112966, -2616, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -32341, 113322, -2352, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -32139, 112254, -2552, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31737, 113322, -2579, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -30630, 111720, -3179, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31535, 112254, -2768, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -31637, 113856, -2645, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26242, 113220, -3573, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -27147, 113754, -3520, 0, 0, 0, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -29501, 114176, -3250, 0, 0, 3659, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -29181, 111357, -3514, 0, 0, 38387, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26888, 111099, -3717, 0, 0, 51144, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26317, 122615, -3696, 0, 0, 56265, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25637, 120595, -3721, 0, 0, 51846, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26409, 120323, -3723, 0, 0, 44415, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25723, 119215, -3687, 0, 0, 39981, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26097, 121575, -3723, 0, 0, 11136, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26411, 118261, -3723, 0, 0, 58777, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25856, 117124, -3653, 0, 0, 49430, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -25802, 115853, -3659, 0, 0, 43278, 32, 0, 0, 0),
("gludio23_1921_01", 1, 20927, -26840, 118977, -3723, 0, 0, 4081, 32, 0, 0, 0),
-- Ratman Sub Chieftain
("gludio38_1921_04", 1, 21093, -4914, 114283, -3347, 0, 0, 2859, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5781, 115928, -3796, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5521, 114886, -3347, 0, 0, 62586, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5177, 115216, -3345, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -4835, 103774, -3056, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -3052, 105109, -3339, 0, 0, 52046, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -2562, 105373, -3435, 0, 0, 45318, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5037, 105198, -2840, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -4936, 105020, -2928, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -4478, 103791, -3149, 0, 0, 35773, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -2924, 106266, -3387, 0, 0, 61127, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6286, 108872, -3156, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5455, 107626, -3157, 0, 0, 57133, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6429, 110988, -3174, 0, 0, 61879, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -4633, 108409, -3259, 0, 0, 39265, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -7353, 109759, -3030, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -4269, 110242, -3335, 0, 0, 23422, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6331, 110410, -3177, 0, 0, 30954, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5133, 109100, -3256, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6930, 109120, -3072, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6408, 109488, -3144, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -6773, 111614, -3206, 0, 0, 39599, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21093, -5715, 108708, -3201, 0, 0, 0, 30, 0, 0, 0),
-- Ratman Chieftain
("gludio38_1921_04", 1, 21094, -6186, 114276, -3347, 0, 0, 31815, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -7103, 115462, -3310, 0, 0, 20022, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -4596, 115808, -3372, 0, 0, 36351, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6137, 115065, -3347, 0, 0, 62101, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6981, 110990, -3104, 0, 0, 45796, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5410, 109474, -3260, 0, 0, 378, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5824, 109459, -3227, 0, 0, 56025, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6136, 112743, -3347, 0, 0, 60455, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -4726, 109667, -3282, 0, 0, 2869, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -3575, 109169, -3361, 0, 0, 3505, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6385, 111557, -3247, 0, 0, 16896, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5507, 110710, -3305, 0, 0, 31577, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5824, 109138, -3218, 0, 0, 0, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6191, 112061, -3319, 0, 0, 18379, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5240, 110110, -3292, 0, 0, 53519, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6261, 109938, -3170, 0, 0, 31833, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -5870, 110329, -3258, 0, 0, 52147, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -3704, 108452, -3334, 0, 0, 65366, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -4935, 110834, -3318, 0, 0, 52707, 30, 0, 0, 0),
("gludio38_1921_04", 1, 21094, -6153, 111254, -3256, 0, 0, 30959, 30, 0, 0, 0),
-- Vivyan
("gludio08_npc1722_042", 1, 30030, -13269, 121884, -2966, 0, 0, 49152, 60, 0, 0, 0),
-- Simplon
("gludio08_npc1921_016", 1, 30253, -15132, 123282, -3107, 0, 0, 12288, 60, 0, 0, 0),
-- Harmony
("gludio08_npc1921_015", 1, 30254, -14934, 124468, -3114, 0, 0, 61440, 60, 0, 0, 0),
-- Haprock
("gludio08_npc1921_019", 1, 30255, -13132, 124988, -3118, 0, 0, 49152, 60, 0, 0, 0),
-- Bella
("gludio08_npc1921_020", 1, 30256, -12736, 122816, -3114, 0, 0, 49152, 60, 0, 0, 0),
-- Rains
("gludio08_npc1921_017", 1, 30288, -13579, 123017, -3103, 0, 0, 49152, 60, 0, 0, 0),
-- Raymond
("gludio08_npc1722_041", 1, 30289, -12784, 121709, -2952, 0, 0, 32768, 60, 0, 0, 0),
-- Manuel
("gludio08_npc1722_042", 1, 30293, -13487, 121541, -2966, 0, 0, 16384, 60, 0, 0, 0),
-- Varan
("gludio08_npc1921_015", 1, 30294, -14933, 124540, -3115, 0, 0, 4096, 60, 0, 0, 0),
-- Tobias
("gludio08_npc1921_018", 1, 30297, -12892, 123143, -3102, 0, 0, 0, 60, 0, 0, 0),
-- Pinter
("gludio08_npc1921_014", 1, 30298, -15349, 124763, -3113, 0, 0, 57344, 60, 0, 0, 0),
-- Sydnia
("gludio08_npc1921_016", 1, 30321, -15238, 123282, -3107, 0, 0, 20480, 60, 0, 0, 0),
-- Ballin
("gludio08_npc1921_019", 1, 30322, -13049, 124737, -3118, 0, 0, 16384, 60, 0, 0, 0),
-- Audiberti
("gludio08_npc1921_020", 1, 30325, -13419, 123068, -3104, 0, 0, 40960, 60, 0, 0, 0),
-- Leona
("gludio08_npc1921_020", 1, 30326, -13691, 123068, -3103, 0, 0, 57344, 60, 0, 0, 0),
-- Sorius
("gludio08_npc1921_017", 1, 30327, -13440, 122643, -3103, 0, 0, 28672, 60, 0, 0, 0),
-- Reisa
("gludio08_npc1921_020", 1, 30328, -13693, 122583, -3103, 0, 0, 8192, 60, 0, 0, 0),
-- Virgil
("gludio08_npc1921_018", 1, 30329, -12791, 123259, -3102, 0, 0, 49152, 60, 0, 0, 0),
-- Sidra
("gludio08_npc1921_018", 1, 30330, -12503, 123054, -3102, 0, 0, 32768, 60, 0, 0, 0),
-- Toma
("gludio08_npc1921_011", 1, 30331, -14708, 121020, -2989, 0, 0, 49152, 60, 0, 0, 0),
-- Bathis
("gludio08_npc1921_011", 1, 30332, -13900, 123822, -3112, 0, 0, 49552, 60, 0, 0, 0),
-- Praga
("gludio08_npc1921_012", 1, 30333, -16623, 124028, -3118, 0, 0, 32768, 60, 0, 0, 0),
-- Babenco
("gludio08_npc1921_012", 1, 30334, -16621, 124330, -3118, 0, 0, 32768, 60, 0, 0, 0),
-- Brynn
("gludio08_npc1921_013", 1, 30335, -14336, 126546, -3148, 0, 0, 16384, 60, 0, 0, 0),
-- Curtis
("gludio08_npc1921_013", 1, 30336, -14005, 126542, -3148, 0, 0, 16384, 60, 0, 0, 0),
-- Moretti
("gludio08_npc1921_010", 1, 30337, -11940, 123789, -3082, 0, 0, 0, 60, 0, 0, 0),
-- Melville
("gludio08_npc1921_010", 1, 30338, -11950, 123473, -3087, 0, 0, 0, 60, 0, 0, 0),
-- Varsak
("gludio08_npc1921_022", 1, 30342, -12188, 122899, -3100, 0, 0, 32768, 60, 0, 0, 0),
-- Rohmer
("gludio08_npc1722_042", 1, 30344, -13269, 121540, -2966, 0, 0, 16384, 60, 0, 0, 0),
-- Ramoniell
("gludio08_npc1722_042", 1, 30345, -13487, 121884, -2960, 0, 0, 49152, 60, 0, 0, 0),
-- Triskel
("gludio08_npc1921_018", 1, 30416, -12506, 123405, -3111, 0, 0, 16384, 60, 0, 0, 0),
-- Samed
("gludio08_npc1921_021", 1, 30434, -14977, 126035, -3143, 0, 0, 32768, 60, 0, 0, 0),
-- Rikadio
("gludio08_npc1722_044", 1, 30503, -13323, 124989, -3118, 0, 0, 0, 60, 0, 0, 0),
-- Mendio
("gludio08_npc1722_043", 1, 30504, -15190, 124756, -3112, 0, 0, 48152, 60, 0, 0, 0),
-- Drikus
("gludio08_npc1921_030", 1, 30505, -12823, 124887, -3126, 0, 0, 0, 60, 0, 0, 0),
-- Buka
("gludio08_npc1921_030", 1, 30506, -12788, 124764, -3126, 0, 0, 0, 60, 0, 0, 0),
-- Racoy
("gludio08_npc1921_030", 1, 30507, -12788, 124976, -3117, 0, 0, 0, 60, 0, 0, 0),
-- Driko
("gludio01_npc1921_303", 1, 30619, -2150, 124443, -3724, 0, 0, 0, 60, 0, 0, 0),
-- Gupu
("gludio23_npc1921_301", 1, 30658, -28103, 120634, -3724, 0, 0, 16384, 60, 0, 0, 0),
-- Orphan Girl
("gludio23_npc1921_302", 1, 30659, -28696, 121931, -3662, 0, 0, 0, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28634, 121898, -3670, 0, 0, 18000, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28882, 121966, -3672, 0, 0, 15500, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -29025, 122017, -3672, 0, 0, 0, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -29120, 122422, -3652, 0, 0, 49152, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28975, 122590, -3642, 0, 0, 49152, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28957, 122744, -3638, 0, 0, 57344, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28997, 122553, -3646, 0, 0, 0, 60, 0, 0, 0),
("gludio23_npc1921_302", 1, 30659, -28978, 122028, -3669, 0, 0, 45056, 60, 0, 0, 0),
-- Borys
("gludio08_npc1921_304", 1, 30729, -15443, 124913, -3130, 0, 0, 16384, 60, 0, 0, 0),
-- Auctioneer
("gludio06_npc1722_064", 1, 30767, -14767, 122955, -3120, 0, 0, 0, 60, 0, 0, 0),
-- Lundy
("gludio08_npc1921_009", 1, 30827, -13908, 123322, -3116, 0, 0, 16384, 60, 0, 0, 0),
-- Lottery Ticket Seller
("Lottery Ticket Seller", 1, 30990, -12676, 122821, -3112, 0, 0, 48000, 5, 0, 0, 0),
-- Broadcasting Tower
("gludio_broadcast", 1, 31031, -13188, 124432, -3110, 0, 0, 16384, 5, 0, 0, 0),
-- Kell
("gludio08_npc1921_026", 1, 31047, -14708, 124160, -3100, 0, 0, 15972, 60, 0, 0, 0),
-- Newbie Helper
("gludio08_npc1921_029", 1, 31077, -13920, 121977, -2984, 0, 0, 33000, 60, 0, 0, 0),
-- Priest of Dawn
("gludio08_npc1921_ssq01", 1, 31079, -13953, 121454, -2984, 0, 0, 33000, 60, 0, 0, 0),
-- Dusk Priestess
("gludio08_npc1921_ssq02", 1, 31086, -14748, 124045, -3112, 0, 0, 48500, 60, 0, 0, 0),
-- Black Marketeer of Mammon
("gludio06_npc1722_ssq03", 1, 31092, -12345, 121695, -2984, 0, 0, 0, 60, 0, 0, 0),
-- Moon Dancer
("unset", 1, 31203, -13908, 123322, -3116, 0, 0, 3355, 5, 0, 0, 0),
-- Berynel
("gludio08_npc1921_032", 1, 31417, -13728, 121632, -2966, 0, 0, 0, 60, 0, 0, 0),
-- Jaka
("gludio08_npc1921_030", 1, 31426, -12823, 124848, -3125, 0, 0, 0, 60, 0, 0, 0),
-- Lanna
("gludio08_npc1921_031", 1, 31440, -15440, 124592, -3113, 0, 0, 0, 60, 0, 0, 0),
-- Pamfus
("gludio08_npc1921_033", 1, 31568, -14768, 124704, -3112, 0, 0, 49000, 60, 0, 0, 0),
-- Grand Olympiad Manager
("dion22_npc2023_04", 1, 31688, -15120, 122096, -3064, 0, 0, 3000, 60, 0, 0, 0),
-- Monument of Heroes 
("dion22_npc2023_03", 1, 31690, -15104, 122040, -3048, 0, 0, 3000, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio08_npc1921_035", 1, 31792, -13328, 122720, -3055, 0, 0, 0, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio08_npc1921_036", 1, 31793, -12466, 123408, -3108, 0, 0, 16500, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio08_npc1921_037", 1, 31794, -13944, 126384, -3144, 0, 0, 49000, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio08_npc1921_038", 1, 31795, -15518, 124297, -3112, 0, 0, 49000, 60, 0, 0, 0),
-- Adventure Guildsman
("gludio08_npc1921_039", 1, 31796, -16464, 123952, -3120, 0, 0, 0, 60, 0, 0, 0),
-- Gershwin
("unset", 1, 32196, -13527, 125585, -3128, 0, 0, 50160, 60, 0, 0, 0),
-- Gwain
("unset", 1, 32197, -13489, 125562, -3128, 0, 0, 49151, 60, 0, 0, 0),
-- Gobie
("unset", 1, 32198, -13565, 125562, -3128, 0, 0, 49151, 60, 0, 0, 0),
-- Dimensional Merchant
("unset", 1, 32478, -13232, 124624, -3120, 0, 0, 49000, 60, 0, 0, 0),
-- Adios
("Gludio", 1, 32479, -14409, 121023, -2984, 0, 0, 28958, 60, 0, 0, 0),
-- Pathfinder Worker
("Gludio", 1, 32484, -13948, 123819, -3112, 0, 0, 49588, 60, 0, 0, 0),
-- Light of Dawn
("Gludio", 1, 32575, -12491, 122331, -2984, 0, 0, 32768, 60, 0, 0, 0),
-- John
("Gludio", 1, 32576, -13976, 121399, -2984, 0, 0, 32768, 60, 0, 0, 0),
-- Tahoo
("gludio08_npc1921_031", 1, 32875, -15162, 124616, -3112, 0, 0, 29865, 60, 0, 0, 0),
-- Gludio Holy Artifact
("GludioArtefact1", 1, 35063, -18113, 107972, -2480, 0, 0, 16384, 60, 0, 0, 0),
-- Mass Gatekeeper
("gludio_mass_teleporter", 1, 35095, -16532, 109387, -1784, 0, 0, 32768, 60, 0, 0, 0),
-- Outer Doorman
("gludio_chamberlain_etc", 1, 35096, -18452, 113261, -2750, 0, 0, 16384, 10800, 0, 0, 0),
("gludio_chamberlain_etc", 1, 35096, -18506, 112913, -2750, 0, 0, 32768, 10800, 0, 0, 0),
-- Inner Doorman
("gludio_chamberlain_etc", 1, 35097, -18279, 110702, -2460, 0, 0, 16384, 10800, 0, 0, 0),
("gludio_chamberlain_etc", 1, 35097, -18345, 110347, -2500, 0, 0, 32768, 10800, 0, 0, 0),
-- Blacksmith
("gludio_blacksmith", 1, 35098, -17644, 109616, -2656, 0, 0, 33000, 60, 0, 0, 0),
-- Warehouse Keeper
("gludio_warehouse", 1, 35099, -18130, 110020, -2656, 0, 0, 49152, 60, 0, 0, 0),
-- Sayres
("gludio_chamberlain_etc", 1, 35100, -18212, 108827, -2472, 0, 0, 16384, 60, 0, 0, 0),
-- Grad
("Wyvern_Manager", 1, 35101, -17952, 108142, -2032, 0, 0, -16384, 60, 0, 0, 0),
-- Greenspan
("gludio19_npc1921_901", 1, 35102, -17876, 108944, -2485, 0, 0, 16384, 60, 0, 0, 0),
-- Manor Manager
("gludio25_npc1725_015", 1, 35103, -15160, 124292, -3104, 0, 0, -32864, 60, 0, 0, 0),
("gludio25_npc1725_015", 1, 35103, -12172, 122648, -3088, 0, 0, 15520, 60, 0, 0, 0),
-- Tyron
("gludio_chamberlain_etc", 1, 35104, -15172, 116723, -3216, 0, 0, 16384, 60, 0, 0, 0),
-- Black
("gludio08_npc1921_002", 1, 35384, -16159, 123728, -3102, 0, 0, 53248, 60, 0, 0, 0),
-- Renny
("gludio08_npc1921_001", 1, 35385, -15882, 123788, -3115, 0, 0, 13288, 60, 0, 0, 0),
-- Boyer
("gludio08_npc1921_006", 1, 35386, -14852, 125413, -3130, 0, 0, 16384, 60, 0, 0, 0),
-- Baback
("gludio08_npc1921_005", 1, 35387, -14731, 125630, -3141, 0, 0, 0, 60, 0, 0, 0),
-- Tim
("gludio08_npc1921_008", 1, 35388, -13745, 125573, -3129, 0, 0, 32768, 60, 0, 0, 0),
-- Loring
("gludio08_npc1921_007", 1, 35389, -14145, 125551, -3140, 0, 0, 32768, 60, 0, 0, 0),
-- Dillon
("gludio08_npc1921_004", 1, 35390, -12866, 124166, -3096, 0, 0, 57344, 60, 0, 0, 0),
-- Latif
("gludio08_npc1921_003", 1, 35391, -12693, 123815, -3115, 0, 0, 49152, 60, 0, 0, 0),
-- Court Magician
("Gludio_castle", 1, 35648, -18340, 108932, -2496, 0, 0, 16384, 60, 0, 0, 0),
-- Warden
("Gludio_castle", 1, 36403, -17962, 109067, -2657, 0, 0, 8388, 60, 0, 0, 0),

-- [19_22]

-- Arachnid Predator
("gludio34_1723_04", 1, 20050, -28398, 134462, -3614, 0, 0, 23188, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -31114, 139144, -3909, 0, 0, 46898, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -32339, 139469, -4012, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -30920, 141783, -4104, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -31322, 141783, -4104, 0, 0, 0, 21, 0, 0, 0),
("gludio34_1723_04", 1, 20050, -31120, 141427, -4104, 0, 0, 0, 21, 0, 0, 0),
-- Wandering Eye
("gludio35_1822_02", 1, 20055, -32030, 134587, -3751, 0, 0, 10133, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -21040, 131406, -3709, 0, 0, 63666, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -30566, 134855, -3706, 0, 0, 13482, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -30934, 138141, -3908, 0, 0, 15625, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -31422, 141249, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_02", 1, 20055, -31523, 141427, -4104, 0, 0, 0, 20, 0, 0, 0),
-- Ol Mahum Guard
("gludio40_1922_01", 1, 20058, -27908, 155770, -3550, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -28513, 155058, -3495, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -28009, 155236, -3556, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -28210, 155236, -3538, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -30552, 158516, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -30754, 157804, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -31157, 157804, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -29546, 157804, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -27103, 159077, -2821, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -26500, 159077, -2821, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -24590, 157756, -3468, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -24288, 157934, -3468, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -18987, 157514, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -19290, 156980, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -19189, 157158, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -18887, 157336, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -15670, 156952, -2545, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -15468, 156596, -2545, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -11512, 161224, -1712, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_01", 1, 20058, -12376, 162567, -2576, 0, 0, 0, 20, 0, 0, 0),
-- Hungry Eye
("gludio35_1822_01", 1, 20059, -29244, 163524, -2785, 0, 0, 39456, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19692, 156980, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -20398, 157870, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19793, 157514, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19894, 158048, -2670, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -15670, 156240, -2545, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -16173, 156774, -2545, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -15066, 157308, -2545, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -20153, 161805, -1883, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19416, 161254, -1704, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19416, 162322, -2010, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -17786, 163566, -2446, 0, 0, 4224, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -16075, 162971, -2477, 0, 0, 60551, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -21295, 133761, -3968, 0, 0, 14480, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30426, 136349, -3685, 0, 0, 56658, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30728, 144148, -3624, 0, 0, 4693, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32504, 144333, -3908, 0, 0, 29043, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31224, 145709, -3787, 0, 0, 9599, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31679, 140129, -3908, 0, 0, 21764, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32339, 139113, -4012, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31725, 141783, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31020, 141961, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31422, 141605, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31926, 141783, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31121, 141783, -4104, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -28412, 154880, -3510, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -28513, 155770, -3484, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -28110, 154702, -3517, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30754, 157448, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30150, 158160, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30351, 158160, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30956, 158516, -3379, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31056, 157626, -3342, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -26912, 161163, -2512, 0, 0, 12792, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -28707, 160172, -2895, 0, 0, 49869, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -30902, 163753, -2937, 0, 0, 1004, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31370, 159968, -3327, 0, 0, 44829, 20, 0, 0, 0),
-- Ol Mahum Shooter
("dion03_2121_01", 1, 20063, -30452, 158338, -3332, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -30049, 157982, -3317, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -29748, 157804, -3316, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -26399, 159255, -2821, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -24489, 158290, -2982, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -24792, 158824, -3468, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -28460, 161799, -2637, 0, 0, 36095, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -30363, 161144, -2997, 0, 0, 30032, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -19692, 157336, -2552, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -18586, 156802, -2552, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -14865, 156596, -2545, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -15167, 157130, -2545, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -19865, 162284, -2042, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -19013, 160898, -1737, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -11109, 161580, -2828, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -11662, 162335, -2447, 0, 0, 62099, 60, 0, 0, 0),
-- Ol Mahum Captain
("gludio40_1922_03", 1, 20066, -26801, 159255, -2821, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -26349, 161217, -2468, 0, 0, 61704, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -29639, 162288, -2778, 0, 0, 37082, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -27923, 162919, -2692, 0, 0, 42373, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -19215, 161966, -1712, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -19214, 160898, -1712, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -16938, 163746, -2531, 0, 0, 61215, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -14500, 162975, -2626, 0, 0, 64744, 20, 0, 0, 0),
-- Ratman Warrior
("gludio35_1821_01", 1, 20359, -21981, 133933, -3967, 0, 0, 17629, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -24944, 131116, -3464, 0, 0, 17297, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -29634, 133840, -3671, 0, 0, 28271, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -29911, 131306, -3804, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -29554, 132480, -3860, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -27184, 132194, -3685, 0, 0, 26754, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -31359, 136514, -3844, 0, 0, 45635, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -32379, 136074, -3907, 0, 0, 39264, 20, 0, 0, 0),
("gludio35_1821_01", 1, 20359, -32026, 133400, -3751, 0, 0, 0, 20, 0, 0, 0),
-- Veelan Bugbear
("gludio02_1922_12", 1, 20401, -17147, 143081, -3972, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -17595, 143326, -3910, 0, 0, 46441, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -17450, 142547, -3972, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -16235, 141102, -3976, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -15530, 141280, -3976, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -12848, 137416, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -12042, 138128, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -12345, 137594, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -10706, 140460, -3682, 0, 0, 42302, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -9265, 140670, -3768, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -10281, 141336, -3667, 0, 0, 48764, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -7258, 143281, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -4553, 146960, -3618, 0, 0, 14152, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20401, -3594, 141148, -3446, 0, 0, 51828, 30, 0, 0, 0),
-- Veelan Bugbear Warrior
("gludio02_1922_15", 1, 20402, -12747, 138306, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -12848, 137772, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -12646, 137772, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -12647, 137416, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -12646, 138128, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -13050, 138484, -3952, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -11453, 140335, -3697, 0, 0, 51340, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -10142, 141687, -3654, 0, 0, 19544, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -10919, 141429, -3668, 0, 0, 21118, 30, 0, 0, 0),
("gludio02_1922_15", 1, 20402, -9667, 141382, -3768, 0, 0, 0, 30, 0, 0, 0),
-- Scavenger Bat
("gludio02_1922_01", 1, 20411, -24539, 141791, -3733, 0, 0, 25886, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -26308, 147462, -3480, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -24137, 146291, -3518, 0, 0, 45694, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -20476, 148178, -3407, 0, 0, 7568, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -21533, 147998, -3504, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -24584, 150173, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -24282, 149639, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -24684, 149283, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -20883, 149800, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -20681, 150156, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -20380, 149266, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -11375, 144333, -3650, 0, 0, 43814, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -10091, 145620, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -9588, 145442, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -10699, 146415, -3726, 0, 0, 2946, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -9588, 145086, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -11521, 148420, -3289, 0, 0, 50067, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -12180, 149408, -3203, 0, 0, 4166, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -12801, 147483, -3139, 0, 0, 25212, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -12512, 148891, -3420, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20411, -13719, 148535, -2984, 0, 0, 0, 30, 0, 0, 0),
-- Zombie Soldier
("gludio02_1922_08", 1, 20457, -20978, 141680, -3896, 0, 0, 48457, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -21056, 140955, -3896, 0, 0, 42128, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -19923, 141311, -3896, 0, 0, 5201, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -20476, 140534, -3896, 0, 0, 64848, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -21148, 140111, -3896, 0, 0, 41807, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -21819, 142709, -3897, 0, 0, 38413, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -22153, 141796, -3896, 0, 0, 50097, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -22192, 142410, -3896, 0, 0, 65279, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -17801, 145300, -3798, 0, 0, 4763, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -19142, 145037, -3811, 0, 0, 44231, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -19722, 145266, -3797, 0, 0, 31364, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -17873, 144951, -3786, 0, 0, 59093, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -20281, 145259, -3769, 0, 0, 39000, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -18877, 145543, -3758, 0, 0, 65086, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -18552, 139974, -3883, 0, 0, 49813, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -17278, 139431, -3875, 0, 0, 45749, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -17727, 140111, -3875, 0, 0, 46111, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -18356, 140821, -3875, 0, 0, 63530, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -16775, 140017, -3875, 0, 0, 51677, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -18025, 143370, -3908, 0, 0, 42504, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -17247, 144000, -3908, 0, 0, 253, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -18342, 142779, -3896, 0, 0, 32610, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -15905, 142020, -3900, 0, 0, 60384, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -16374, 142093, -3894, 0, 0, 62097, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -16049, 140301, -3871, 0, 0, 49407, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -15631, 140746, -3976, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -11860, 140444, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -11458, 140800, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -3485, 145057, -3661, 0, 0, 9833, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -6356, 143834, -3561, 0, 0, 6600, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -7358, 142747, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -5848, 143281, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -11500, 145013, -3626, 0, 0, 22324, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -10090, 145976, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -10393, 144730, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20457, -10494, 144908, -3880, 0, 0, 0, 30, 0, 0, 0),
-- Zombie Warrior
("gludio02_1922_08", 1, 20458, -20430, 143133, -3852, 0, 0, 25363, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -20275, 144205, -3820, 0, 0, 11424, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -20696, 141176, -3896, 0, 0, 47045, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -20083, 140864, -3896, 0, 0, 18586, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -19936, 142716, -3896, 0, 0, 8034, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -18452, 141197, -3892, 0, 0, 27379, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -17226, 140921, -3875, 0, 0, 11684, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -15879, 141562, -3846, 0, 0, 47315, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -15483, 140317, -3810, 0, 0, 58975, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -14211, 142585, -3689, 0, 0, 28306, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -14685, 143384, -3686, 0, 0, 7259, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -14282, 143859, -3618, 0, 0, 10666, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -13720, 144512, -3602, 0, 0, 14213, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20458, -13849, 141936, -3735, 0, 0, 49446, 30, 0, 0, 0),
-- Ruin Bat
("gludio02_1922_12", 1, 20505, -17346, 144667, -3861, 0, 0, 11461, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -17047, 142547, -3972, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -18332, 144118, -3820, 0, 0, 40385, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -17923, 142730, -3896, 0, 0, 32363, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11626, 142389, -3688, 0, 0, 31103, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11753, 141572, -3697, 0, 0, 63868, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11357, 140978, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -12464, 140800, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -4745, 144417, -3611, 0, 0, 54675, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -7006, 145234, -3591, 0, 0, 64354, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -2117, 144188, -3644, 0, 0, 1487, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -5597, 145529, -3598, 0, 0, 12597, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -5755, 144629, -3596, 0, 0, 26126, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -8140, 143100, -3420, 0, 0, 34514, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11052, 145049, -3708, 0, 0, 4987, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11571, 145942, -3589, 0, 0, 18532, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -10252, 147001, -3789, 0, 0, 2954, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -11401, 146556, -3489, 0, 0, 25933, 30, 0, 0, 0),
("gludio02_1922_12", 1, 20505, -7913, 145692, -3618, 0, 0, 32544, 30, 0, 0, 0),
-- Ruin Imp
("gludio02_1922_01", 1, 20506, -23894, 139245, -3691, 0, 0, 52841, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -22112, 141254, -3893, 0, 0, 7182, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -25378, 143650, -4016, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -26230, 144269, -3484, 0, 0, 39391, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -21760, 147381, -3562, 0, 0, 40230, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -21030, 147820, -3504, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -20829, 147464, -3504, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -24180, 150529, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -24383, 149817, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -24986, 149461, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -17904, 147444, -3752, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -16698, 147088, -3752, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -18644, 147458, -3521, 0, 0, 42888, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -18137, 147668, -3501, 0, 0, 43052, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -10494, 144552, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -10695, 145620, -3880, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -13518, 148535, -3420, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -11097, 148753, -3341, 0, 0, 4837, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -12008, 148713, -3420, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -12110, 148179, -3420, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20506, -12814, 148357, -3420, 0, 0, 0, 30, 0, 0, 0),
-- Ruin Imp Elder
("gludio02_1922_08", 1, 20507, -20904, 141573, -3896, 0, 0, 39350, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -20704, 140045, -3896, 0, 0, 42844, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -19972, 140176, -3896, 0, 0, 4405, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -20303, 141884, -3896, 0, 0, 16217, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -18573, 145360, -3883, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -16948, 140224, -3875, 0, 0, 46956, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -16535, 140758, -3875, 0, 0, 13001, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -19449, 139132, -3897, 0, 0, 14683, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -14558, 142605, -3745, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -13574, 143801, -3628, 0, 0, 5148, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -13364, 144973, -3602, 0, 0, 9858, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -14299, 143320, -3687, 0, 0, 18582, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -12364, 140978, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -11343, 141877, -3692, 0, 0, 2317, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -11057, 142316, -3671, 0, 0, 12780, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -12163, 141334, -3940, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -9768, 140492, -3768, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -10774, 141832, -3667, 0, 0, 22160, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -9650, 142099, -3634, 0, 0, 63671, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -6654, 142925, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -7056, 143637, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -5447, 142925, -3804, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -4863, 143943, -3623, 0, 0, 22027, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -4923, 146044, -3638, 0, 0, 4112, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -4109, 142822, -3490, 0, 0, 51640, 30, 0, 0, 0),
("gludio02_1922_08", 1, 20507, -4055, 146155, -3664, 0, 0, 8001, 30, 0, 0, 0),
-- Shield Skeleton
("gludio02_1922_01", 1, 20514, -24474, 140908, -3992, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -23967, 142209, -3761, 0, 0, 56728, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -24682, 142737, -3758, 0, 0, 55605, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -25783, 145173, -3475, 0, 0, 32988, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -28904, 146185, -3565, 0, 0, 30998, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -25820, 148902, -3288, 0, 0, 19354, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -24271, 143472, -4016, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -22588, 145763, -3795, 0, 0, 10864, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -26812, 146928, -3480, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -27371, 148939, -3131, 0, 0, 17450, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -26006, 146216, -3480, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -25829, 147812, -3350, 0, 0, 49152, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -21487, 149444, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -20581, 149266, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -20479, 150156, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -17480, 146948, -3711, 0, 0, 54688, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -17199, 147622, -3752, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -17602, 147978, -3752, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_01", 1, 20514, -18332, 148142, -3386, 0, 0, 26299, 30, 0, 0, 0),
-- Skeleton Infantryman
("gludio02_1922_02", 1, 20515, -23688, 144504, -3819, 0, 0, 43133, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24815, 144073, -3742, 0, 0, 61636, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24698, 145008, -3635, 0, 0, 10741, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -26777, 144928, -3373, 0, 0, 38391, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -22504, 148154, -3350, 0, 0, 130, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -25082, 148748, -3262, 0, 0, 4568, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24342, 147475, -3371, 0, 0, 243, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -27143, 150258, -3052, 0, 0, 22443, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24885, 149283, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24382, 150173, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -24986, 149817, -3216, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -21185, 149266, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -20883, 149444, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -20380, 149622, -3172, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -16758, 148365, -3428, 0, 0, 46300, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -17702, 147444, -3752, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -17327, 146199, -3738, 0, 0, 48682, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -16344, 148011, -3483, 0, 0, 59448, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -22500, 141676, -4008, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -22903, 142388, -4008, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -12541, 147205, -3219, 0, 0, 24900, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -12411, 148357, -3420, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -13343, 149284, -3093, 0, 0, 37439, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -13820, 148713, -2985, 0, 0, 0, 30, 0, 0, 0),
("gludio02_1922_02", 1, 20515, -12665, 149706, -3175, 0, 0, 1141, 30, 0, 0, 0),
-- Ol Mahum Reserve
("dion03_2121_01", 1, 20547, -27807, 155592, -3577, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -28240, 156498, -3488, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -28816, 155592, -3507, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -30552, 158872, -3328, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -30653, 157626, -3632, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -30149, 158516, -3313, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -31057, 158338, -3485, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -29647, 157626, -3386, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -26399, 158899, -2821, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -26198, 159255, -2821, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -24590, 158468, -2913, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -24590, 158112, -3014, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -32078, 161869, -2941, 0, 0, 32940, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -18586, 157158, -2552, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -19048, 158625, -2316, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -19088, 157692, -2552, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -15569, 156774, -2545, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -15266, 156952, -2545, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -14965, 156418, -2545, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -19315, 161076, -1720, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -19843, 161428, -1701, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -19056, 161989, -1924, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -18989, 163103, -2267, 0, 0, 50184, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -13065, 163610, -2738, 0, 0, 15072, 60, 0, 0, 0),
-- Ol Mahum Deserter
("gludio35_1822_01", 1, 20548, -31359, 146709, -3908, 0, 0, 8956, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -31509, 143990, -3774, 0, 0, 8453, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20548, -28670, 145040, -3453, 0, 0, 64835, 20, 0, 0, 0),
-- Undead Priest
("oren01_qm1918_01", 1, 27024, -13500, 147780, -3472, 0, 0, 0, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13597, 148307, -3027, 0, 0, 39352, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13702, 148136, -3472, 0, 0, 0, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13101, 149093, -3118, 0, 0, 6891, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13255, 148211, -3072, 0, 0, 48021, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13500, 148136, -3472, 0, 0, 0, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -13558, 148938, -3038, 0, 0, 34505, 180, 0, 0, 0),
("oren01_qm1918_01", 1, 27024, -12996, 148670, -3472, 0, 0, 0, 180, 0, 0, 0);

INSERT INTO `spawnlist` VALUES

-- Flame Salamander
("gludio02_npc1821_001", 1, 30411, -20352, 144736, -3840, 0, 0, 0, 60, 0, 0, 0),
-- Hungry Eye
("gludio35_1822_01", 1, 20059, -26423, 165134, -2928, 0, 0, 15241, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -21927, 167495, -3407, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -15397, 164879, -2869, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11453, 164455, -2480, 0, 0, 64872, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11537, 165443, -2692, 0, 0, 17721, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -10358, 165207, -3167, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11664, 168373, -2486, 0, 0, 19109, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -9355, 167521, -2567, 0, 0, 54287, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -31594, 164672, -3382, 0, 0, 0, 20, 0, 0, 0),
-- Ol Mahum Shooter
("dion03_2121_01", 1, 20063, -24478, 166883, -2928, 0, 0, 52254, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -27732, 164516, -2928, 0, 0, 40701, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -26987, 163905, -2917, 0, 0, 59310, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -21726, 167495, -3407, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -22129, 168207, -3407, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -16704, 166527, -2452, 0, 0, 2508, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -19865, 165216, -2954, 0, 0, 36707, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -14993, 164167, -2869, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -12037, 167544, -2314, 0, 0, 40308, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -10660, 166097, -3167, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -8313, 169005, -3223, 0, 0, 55399, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -9689, 170725, -3427, 0, 0, 0, 60, 0, 0, 0),
-- Ol Mahum Captain
("gludio40_1922_03", 1, 20066, -31293, 164850, -3382, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -31695, 164138, -3382, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -26310, 166125, -2943, 0, 0, 36304, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -25416, 165677, -3363, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -21826, 167673, -3407, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -21424, 167317, -3407, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -21726, 167851, -3407, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -18411, 165073, -3233, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -18009, 164005, -3233, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -13482, 164994, -2625, 0, 0, 19325, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10459, 165385, -3167, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -12377, 166904, -2162, 0, 0, 26920, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10791, 167312, -2954, 0, 0, 11481, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -8618, 171272, -2812, 0, 0, 49548, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10293, 170013, -3427, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -9085, 169657, -3427, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10163, 168575, -2760, 0, 0, 8361, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -3765, 196516, -2934, 0, 0, 58613, 20, 0, 0, 0),
-- Monster Eye Watcher
("gludio04_1823_01", 1, 20067, -14896, 173080, -3778, 0, 0, 35532, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -13928, 172987, -4091, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -13424, 173165, -4091, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -8122, 177972, -3461, 0, 0, 49152, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -5183, 182579, -3580, 0, 0, 7514, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -7511, 180689, -3494, 0, 0, 38676, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -6078, 182392, -3612, 0, 0, 44532, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -27573, 194937, -3557, 0, 0, 51744, 27, 0, 0, 0),
-- Monster Eye Destroyer
("dion17_2023_01", 1, 20068, -13727, 172987, -4091, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -13626, 173165, -4091, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -5683, 184881, -3518, 0, 0, 55843, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -4596, 183716, -3512, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -771, 165312, -3235, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -669, 164778, -3142, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -3604, 171356, -3059, 0, 0, 22375, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -1823, 169824, -3282, 0, 0, 39806, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -2502, 177443, -3627, 0, 0, 53014, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -3395, 179651, -3262, 0, 0, 15050, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -3512, 178405, -3349, 0, 0, 16982, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -2327, 176107, -3543, 0, 0, 30998, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -519, 175783, -3497, 0, 0, 48531, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -991, 185287, -3704, 0, 0, 39618, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -2034, 173357, -3316, 0, 0, 20442, 29, 0, 0, 0),
-- Lesser Basilisk
("gludio04_1823_02", 1, 20070, -15490, 172463, -4068, 0, 0, 65204, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -8396, 175736, -4145, 0, 0, 57140, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -16363, 172842, -3978, 0, 0, 56756, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -11943, 179209, -4126, 0, 0, 24085, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -9404, 176550, -4191, 0, 0, 22108, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -12533, 175293, -4016, 0, 0, 45840, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -7081, 181737, -3532, 0, 0, 34065, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -5214, 183637, -3549, 0, 0, 17142, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -6014, 190951, -3613, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -5011, 193973, -3413, 0, 0, 16234, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -6216, 192019, -3613, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -5951, 189664, -3555, 0, 0, 38533, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -24642, 169802, -4285, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -22713, 171103, -3628, 0, 0, 51514, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -20755, 171813, -3354, 0, 0, 60048, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -20389, 172934, -3567, 0, 0, 5827, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -24507, 170117, -3629, 0, 0, 47592, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -28424, 194953, -3598, 0, 0, 56196, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -29875, 195988, -3647, 0, 0, 41740, 27, 0, 0, 0),
-- Basilisk
("gludio04_1823_06", 1, 20072, -9730, 178338, -4005, 0, 0, 37725, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -12288, 172213, -3955, 0, 0, 48460, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -14456, 175456, -3721, 0, 0, 37839, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -13363, 178428, -4285, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -12359, 177600, -4084, 0, 0, 58665, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -9983, 181358, -4163, 0, 0, 12577, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -13263, 180250, -4184, 0, 0, 47267, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -13725, 176914, -4203, 0, 0, 41048, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -9502, 183368, -4183, 0, 0, 6156, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -11730, 180057, -4111, 0, 0, 31690, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -9109, 178850, -3832, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -5533, 181551, -3621, 0, 0, 57510, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -4567, 185485, -3767, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -5271, 185663, -3767, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -6709, 187569, -3638, 0, 0, 44315, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -9098, 186330, -3325, 0, 0, 36329, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -30901, 167769, -3628, 0, 0, 52561, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -30859, 169098, -3648, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -30054, 168742, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -29853, 168742, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -30053, 169098, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -26952, 196295, -4067, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -14234, 195682, -3927, 0, 0, 58851, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -12780, 195863, -3927, 0, 0, 6920, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -15608, 196329, -4042, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -8659, 194169, -3898, 0, 0, 5388, 27, 0, 0, 0),
-- Androscorpio
("gludio04_1823_08", 1, 20074, -32285, 170304, -3927, 0, 0, 37996, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -31061, 168742, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -30255, 168742, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -30356, 169276, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -29852, 169098, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -29953, 168920, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -25165, 169804, -3628, 0, 0, 51451, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -22664, 169276, -3177, 0, 0, 63902, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -23925, 172880, -3922, 0, 0, 22109, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -25959, 169708, -3690, 0, 0, 62980, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -24440, 170514, -4285, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -30516, 190513, -3647, 0, 0, 52656, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -28927, 191447, -3809, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20074, -27819, 191625, -3538, 0, 0, 0, 27, 0, 0, 0),
-- Ant Larva
("gludio05_1923_01", 1, 20075, -13065, 175292, -5309, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -13163, 175463, -5225, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -14420, 176411, -5309, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -14728, 176697, -5309, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -13587, 177418, -5307, 0, 0, 50978, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -13699, 178129, -5309, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28347, 174023, -4833, 0, 0, 24576, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -27956, 174694, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28259, 174160, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28158, 173982, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28158, 174338, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28359, 174338, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -27553, 174338, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28158, 174694, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28259, 174516, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28057, 174516, -4874, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -29245, 175245, -5242, 0, 0, 21819, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -29183, 175396, -5242, 0, 0, 16064, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -29150, 175295, -5242, 0, 0, 64267, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -28971, 175803, -5281, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -27934, 176466, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -22343, 190035, -5532, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -22774, 192039, -5415, 0, 0, 38612, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -22998, 191874, -5415, 0, 0, 55863, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -21769, 192386, -5463, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -20366, 192186, -5521, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -19881, 191950, -5525, 0, 0, 59541, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -20986, 192709, -5413, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -19428, 191750, -5530, 0, 0, 61600, 70, 0, 0, 0),
("gludio05_1923_01", 1, 20075, -20360, 191654, -5532, 0, 0, 0, 70, 0, 0, 0),
-- Androscorpio Hunter
("gludio04_1823_08", 1, 20077, -31736, 193160, -3647, 0, 0, 11486, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -32081, 174827, -4209, 0, 0, 59755, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -29017, 174043, -4240, 0, 0, 63829, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -32029, 172196, -4419, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -28704, 171695, -4346, 0, 0, 65166, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -30955, 173756, -4209, 0, 0, 2087, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -31830, 179363, -4209, 0, 0, 12927, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -28091, 179976, -4209, 0, 0, 1918, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -29952, 169276, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -30430, 169059, -3926, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -30155, 168564, -4276, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -32053, 168727, -3628, 0, 0, 3033, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -29075, 168157, -3756, 0, 0, 45864, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -23836, 170514, -4285, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -21446, 172833, -3615, 0, 0, 4710, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -23555, 171202, -3626, 0, 0, 40103, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -22554, 173980, -3927, 0, 0, 9142, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -24070, 168864, -3258, 0, 0, 47065, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -28010, 189932, -3643, 0, 0, 52028, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -30836, 191689, -3647, 0, 0, 59168, 27, 0, 0, 0),
("gludio04_1823_08", 1, 20077, -28524, 191447, -3809, 0, 0, 0, 27, 0, 0, 0),
-- Ant
("gludio04_1823_24", 1, 20079, -9550, 191393, -4209, 0, 0, 7209, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14313, 176202, -5309, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14361, 176869, -5290, 0, 0, 21985, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -13653, 177959, -5355, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -13390, 177794, -5307, 0, 0, 13908, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -13016, 178742, -5389, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14446, 178967, -5424, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14143, 179145, -5424, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14151, 179251, -5305, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14052, 179297, -5323, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14244, 178967, -5424, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -15642, 178279, -5307, 0, 0, 33026, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -14154, 178224, -5307, 0, 0, 64032, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -15271, 176845, -5307, 0, 0, 29525, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -16500, 177809, -5307, 0, 0, 64685, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27654, 174516, -4874, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28241, 174076, -4833, 0, 0, 41977, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27654, 174160, -4874, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27956, 174338, -4874, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27881, 174285, -4833, 0, 0, 3905, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28564, 174024, -4833, 0, 0, 34278, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27924, 174145, -4832, 0, 0, 5681, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28146, 174269, -4833, 0, 0, 38429, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27801, 174846, -4811, 0, 0, 14907, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28397, 174227, -4835, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -29239, 174992, -5199, 0, 0, 14877, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -29045, 175584, -5242, 0, 0, 43411, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28935, 176356, -5242, 0, 0, 55221, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28898, 175979, -5242, 0, 0, 51438, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -27327, 176545, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -26073, 176665, -5312, 0, 0, 31762, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -26106, 177007, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -25498, 178066, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -26310, 178043, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -26474, 178626, -5312, 0, 0, 20926, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -25569, 178218, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28737, 176962, -5242, 0, 0, 7052, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28456, 177268, -5242, 0, 0, 8636, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28184, 177452, -5240, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -28603, 177252, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24809, 186659, -5417, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24385, 186856, -5489, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -23796, 188326, -5415, 0, 0, 57981, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -23750, 188424, -5417, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24080, 188718, -5449, 0, 0, 14352, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24037, 189353, -5466, 0, 0, 46828, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24409, 189114, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -24072, 189000, -5466, 0, 0, 14597, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -22363, 189936, -5532, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -22684, 190118, -5489, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -21128, 192543, -5415, 0, 0, 1270, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -21636, 192549, -5415, 0, 0, 35910, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -21206, 192494, -5415, 0, 0, 65137, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -21482, 192713, -5415, 0, 0, 49372, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20395, 192378, -5501, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20226, 192189, -5532, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20085, 192167, -5528, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20588, 192437, -5467, 0, 0, 20502, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -19714, 190687, -5530, 0, 0, 60130, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20354, 191936, -5577, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_24", 1, 20079, -20429, 191554, -5532, 0, 0, 0, 27, 0, 0, 0),
-- Ant Captain
("gludio04_1823_25", 1, 20080, -20629, 190047, -5466, 0, 0, 23793, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20437, 190456, -5450, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20711, 190135, -5471, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24788, 186856, -5489, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24687, 186678, -5489, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24083, 187034, -5489, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -23867, 188377, -5417, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -23474, 188243, -5415, 0, 0, 53988, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22067, 188176, -5576, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22349, 188211, -5415, 0, 0, 4411, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -21637, 188858, -5530, 0, 0, 38225, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22041, 188299, -5415, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24121, 189486, -5466, 0, 0, 48820, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -23832, 189712, -5415, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24509, 189292, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -24220, 189350, -5466, 0, 0, 21197, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22449, 190084, -5526, 0, 0, 59092, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22603, 190181, -5492, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22758, 190299, -5435, 0, 0, 36991, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -22488, 192389, -5456, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -21999, 192473, -5415, 0, 0, 34920, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -21174, 192707, -5415, 0, 0, 29222, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -19811, 192019, -5525, 0, 0, 25985, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20459, 192497, -5569, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20710, 192596, -5434, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20057, 192039, -5530, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20113, 191919, -5530, 0, 0, 37696, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -20081, 191799, -5532, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13325, 181714, -4269, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -11461, 192258, -3995, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -12816, 187259, -4294, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -28112, 174444, -4342, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -14657, 178297, -5307, 0, 0, 29702, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13428, 177637, -5307, 0, 0, 54571, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13740, 179501, -5424, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13966, 179382, -5347, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13946, 179228, -5335, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -14342, 179150, -5305, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -13622, 179364, -5389, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -14042, 179323, -5424, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -14676, 178905, -5307, 0, 0, 3650, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -14649, 177007, -5307, 0, 0, 28108, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -16465, 177536, -5307, 0, 0, 25131, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -29003, 176818, -5242, 0, 0, 16828, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -28479, 176569, -5242, 0, 0, 4558, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27630, 176593, -5312, 0, 0, 37604, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26290, 178327, -5312, 0, 0, 17313, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26121, 177248, -5312, 0, 0, 17030, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -28255, 177368, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27750, 178144, -5240, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -28137, 177584, -5242, 0, 0, 8682, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27849, 177867, -5242, 0, 0, 8101, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27653, 178202, -5223, 0, 0, 10863, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27621, 178689, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26943, 177260, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26842, 177438, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26641, 177438, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -26943, 177616, -5242, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_25", 1, 20080, -27144, 177616, -5242, 0, 0, 0, 27, 0, 0, 0),
-- Ant Overseer
("gludio05_1923_09", 1, 20081, -14109, 179162, -5303, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -14289, 179168, -5309, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -14461, 179101, -5309, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -14345, 179145, -5424, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -13637, 179468, -5389, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -13841, 179323, -5424, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -14773, 178588, -5307, 0, 0, 46882, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -16708, 177826, -5307, 0, 0, 23659, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -15769, 177003, -5304, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26202, 177577, -5311, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26062, 177080, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24805, 176934, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -25107, 177468, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26106, 178152, -5314, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26182, 178476, -5312, 0, 0, 60586, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -25862, 178265, -5312, 0, 0, 18682, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -25391, 178152, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -28107, 178454, -5242, 0, 0, 19896, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -27318, 178155, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -27044, 177438, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26741, 177616, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -26842, 177794, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -27043, 177794, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -20386, 190259, -5457, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -20489, 190301, -5550, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -20388, 190123, -5550, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24183, 187212, -5489, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -23986, 188405, -5417, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24133, 189175, -5449, 0, 0, 17654, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24137, 188904, -5466, 0, 0, 15989, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24366, 189435, -5468, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24207, 189114, -5520, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -24064, 189443, -5466, 0, 0, 44511, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -22168, 189978, -5530, 0, 0, 42901, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -22977, 190701, -5415, 0, 0, 16208, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -20153, 191936, -5577, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -19412, 191109, -5530, 0, 0, 13898, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -19300, 188817, -5530, 0, 0, 8088, 60, 0, 0, 0),
("gludio05_1923_09", 1, 20081, -19161, 189944, -5460, 0, 0, 24080, 60, 0, 0, 0),
-- Ant Recruit
("gludio05_1923_07", 1, 20082, -21637, 189916, -5530, 0, 0, 48588, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -24587, 186500, -5489, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -21966, 188354, -5576, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -22629, 188159, -5397, 0, 0, 34683, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -21377, 188815, -5530, 0, 0, 30282, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -19055, 189093, -5530, 0, 0, 8812, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -19255, 189368, -5532, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13124, 179060, -5389, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13018, 178353, -5334, 0, 0, 13918, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13459, 179375, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13455, 179393, -5387, 0, 0, 32678, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -12954, 179553, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13358, 179909, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13258, 180301, -5387, 0, 0, 15714, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13588, 181581, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13542, 181641, -5376, 0, 0, 53880, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13790, 181937, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -14207, 180247, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13270, 180698, -5387, 0, 0, 23631, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -14739, 180123, -5387, 0, 0, 127, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13230, 180502, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13508, 180133, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -15813, 178213, -5309, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -13726, 181889, -5387, 0, 0, 45778, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -24603, 177290, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -24704, 177112, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23536, 176952, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23466, 176897, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23265, 176897, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23567, 177075, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23466, 177253, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -23292, 177160, -5309, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -25589, 178169, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -25096, 177716, -5314, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -25569, 178218, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -27519, 178511, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -27923, 178511, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -29001, 178334, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20082, -28900, 178512, -5242, 0, 0, 0, 60, 0, 0, 0),
-- Granite Golem
("dion02_2122_22", 1, 20083, -13169, 182134, -4158, 0, 0, 15976, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -14232, 181892, -4269, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -12107, 183366, -4176, 0, 0, 17971, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -7167, 193125, -3921, 0, 0, 59328, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -10681, 193726, -3913, 0, 0, 33308, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -7557, 194805, -3924, 0, 0, 5835, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -11359, 192792, -3995, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -11763, 192436, -3995, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -13159, 196434, -3927, 0, 0, 6337, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -14788, 190999, -4209, 0, 0, 29320, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -13653, 192326, -4275, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -8831, 192335, -4209, 0, 0, 7925, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -10271, 190955, -4207, 0, 0, 44632, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -15265, 187448, -4317, 0, 0, 23686, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -13895, 188171, -4209, 0, 0, 2038, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -11657, 189688, -4157, 0, 0, 7743, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -14010, 189909, -4139, 0, 0, 11946, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -19858, 185782, -3859, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18650, 185782, -3859, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18028, 184458, -3732, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18952, 186316, -3859, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18852, 185782, -3859, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18851, 185426, -3859, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -21006, 194637, -4286, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -20804, 194637, -4286, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -20805, 194281, -4286, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -22013, 194637, -4286, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -20603, 194637, -4286, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -21971, 191777, -4061, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -21669, 191599, -4061, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -24998, 194180, -3927, 0, 0, 44036, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -22148, 175073, -4282, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -22853, 175963, -4282, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -24208, 177001, -4168, 0, 0, 28088, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -14022, 180203, -4161, 0, 0, 63800, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -23995, 175678, -4179, 0, 0, 59615, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -23504, 180934, -4089, 0, 0, 27946, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -24711, 177850, -4099, 0, 0, 10546, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -27006, 174622, -4342, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -27406, 173554, -4342, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -27408, 174622, -4342, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -28631, 175267, -4174, 0, 0, 6093, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -30467, 174731, -4209, 0, 0, 33012, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -30160, 170957, -4218, 0, 0, 37115, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -32627, 171971, -4209, 0, 0, 48935, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -31645, 188377, -3611, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -31544, 189267, -3867, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -31544, 188555, -3867, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -32683, 188249, -3927, 0, 0, 5658, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -29129, 191447, -3809, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -27920, 191447, -3809, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -27619, 191269, -3809, 0, 0, 0, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18050, 195769, -4209, 0, 0, 7161, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -18333, 194771, -4209, 0, 0, 57134, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -19475, 195153, -4209, 0, 0, 486, 35, 0, 0, 0),
-- Ant Patrol
("gludio05_1923_07", 1, 20084, -20999, 188194, -5530, 0, 0, 25027, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -17430, 190273, -4140, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -17531, 190451, -4160, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -17430, 190629, -4192, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -17531, 190807, -4200, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -20124, 190815, -5530, 0, 0, 29236, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -21826, 188513, -5495, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -21483, 189386, -5530, 0, 0, 14591, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -21982, 188489, -5466, 0, 0, 7523, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -19045, 188952, -5530, 0, 0, 50674, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13466, 179523, -5387, 0, 0, 17265, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13055, 179375, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -12955, 179197, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13018, 179617, -5389, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13055, 179731, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -12981, 179248, -5387, 0, 0, 18832, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -12753, 179553, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13347, 181283, -5387, 0, 0, 24719, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13918, 182001, -5387, 0, 0, 29991, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15543, 182027, -5382, 0, 0, 55549, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15072, 181961, -5387, 0, 0, 64765, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15992, 179878, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15516, 179496, -5387, 0, 0, 59858, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13856, 180228, -5387, 0, 0, 32668, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13059, 179816, -5387, 0, 0, 52075, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15141, 180106, -5387, 0, 0, 33568, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13748, 180126, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13362, 180034, -5387, 0, 0, 17782, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -13609, 179955, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -15251, 178790, -5307, 0, 0, 16208, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -17902, 178546, -5387, 0, 0, 29570, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18770, 178159, -5387, 0, 0, 20718, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18970, 178165, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18869, 178343, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18633, 178431, -5387, 0, 0, 60513, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18367, 178487, -5377, 0, 0, 2165, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -18365, 178521, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24878, 177788, -5312, 0, 0, 58743, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24493, 177752, -5312, 0, 0, 64563, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23357, 176950, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23668, 176897, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23769, 177075, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23668, 177253, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23164, 177075, -5353, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -23296, 177192, -5304, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -26339, 178458, -5305, 0, 0, 33958, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -25291, 177974, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24279, 178890, -5404, 0, 0, 50019, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24493, 179486, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24897, 179842, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24594, 179308, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24695, 179486, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24521, 179479, -5404, 0, 0, 39680, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -24594, 179664, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -28893, 178370, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -28799, 178540, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -28497, 178512, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -29902, 180784, -5242, 0, 0, 20342, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20084, -30281, 179816, -5242, 0, 0, 44766, 60, 0, 0, 0),
-- Puncher
("gludio04_1823_12", 1, 20085, -12242, 194889, -3927, 0, 0, 61784, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -13653, 195389, -3927, 0, 0, 50049, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -13552, 192148, -4275, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -17073, 187727, -4269, 0, 0, 36196, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -13740, 185473, -4209, 0, 0, 47124, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -15299, 188409, -4273, 0, 0, 26413, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -18951, 184892, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -18750, 184892, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -19253, 186850, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -19455, 187206, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -18550, 185604, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -19657, 185782, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -21870, 191955, -4061, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -21066, 191955, -4061, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -21065, 192311, -4061, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -24664, 192089, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -23860, 192089, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -23872, 188480, -4167, 0, 0, 52786, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -24846, 189809, -4149, 0, 0, 14261, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -30341, 180678, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -29735, 181746, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -30945, 181034, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -31080, 178936, -4209, 0, 0, 64141, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -30960, 178599, -4209, 0, 0, 49563, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -22954, 176141, -4282, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -22260, 177476, -4176, 0, 0, 40755, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -20438, 175251, -4282, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -15430, 180271, -4198, 0, 0, 65255, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -18601, 180213, -4209, 0, 0, 1658, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -27206, 173910, -4342, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -27005, 174978, -4342, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -31627, 172196, -4419, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -29397, 173685, -4263, 0, 0, 14867, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -29579, 174695, -4209, 0, 0, 1823, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -31241, 189445, -3867, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -31242, 188733, -3867, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -32361, 187407, -3927, 0, 0, 42631, 27, 0, 0, 0),
("gludio04_1823_12", 1, 20085, -31645, 188733, -3867, 0, 0, 0, 27, 0, 0, 0),
-- Ant Guard
("gludio05_1923_07", 1, 20086, -13358, 179197, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -12854, 179375, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13358, 179553, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13280, 179357, -5387, 0, 0, 57935, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13459, 179731, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -12954, 179909, -5428, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13949, 181994, -5387, 0, 0, 63488, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -14291, 182062, -5387, 0, 0, 15163, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -14561, 180186, -5385, 0, 0, 34555, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13911, 180133, -5387, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13240, 179852, -5387, 0, 0, 46863, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13995, 179292, -5338, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -13923, 180187, -5387, 0, 0, 30759, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -15349, 178277, -5307, 0, 0, 65464, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18127, 178376, -5429, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -17204, 178325, -5307, 0, 0, 26827, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18768, 178165, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18667, 178343, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18566, 178521, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -19071, 178343, -5427, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18713, 179225, -5385, 0, 0, 15345, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18532, 178244, -5387, 0, 0, 54475, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -17949, 181018, -5518, 0, 0, 60451, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18180, 181092, -5520, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -18121, 181224, -5518, 0, 0, 56398, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -24796, 179664, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -25158, 180641, -5404, 0, 0, 20181, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -24752, 179771, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -25143, 180258, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -24492, 179292, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -24393, 179308, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -24475, 179280, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -28799, 178334, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -28803, 178410, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -29225, 178254, -5242, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -29858, 180677, -5229, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -30362, 180143, -5229, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -28165, 179753, -4208, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -26617, 180762, -5451, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -26787, 180755, -5312, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -25622, 180625, -5460, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -26214, 181118, -5451, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -27538, 182451, -5319, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -27637, 182447, -5451, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -27260, 182558, -5397, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -26759, 182699, -5406, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -26931, 182625, -5451, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -23623, 181586, -5603, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -23519, 182305, -5603, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -21797, 185473, -5603, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -20350, 187748, -5603, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -20133, 187756, -5606, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -17329, 190451, -4176, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -17128, 190451, -4184, 0, 0, 0, 60, 0, 0, 0),
("gludio05_1923_07", 1, 20086, -17330, 190807, -4208, 0, 0, 0, 60, 0, 0, 0),
-- Ant Soldier
("gludio04_1823_23", 1, 20087, -19828, 187639, -5601, 0, 0, 57916, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -20350, 187900, -5646, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17229, 190273, -4168, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17229, 190629, -4197, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17631, 190629, -4184, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15846, 181456, -5387, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15644, 181456, -5387, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15707, 182260, -5387, 0, 0, 13705, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15290, 179637, -5387, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15727, 179638, -5387, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -15395, 180108, -5387, 0, 0, 1535, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -18039, 180606, -5518, 0, 0, 11620, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -18286, 180130, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17776, 180444, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17972, 180465, -5518, 0, 0, 5079, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17411, 180651, -5518, 0, 0, 956, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -17290, 180986, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -16822, 181269, -5518, 0, 0, 31288, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -16147, 181262, -5407, 0, 0, 64009, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -20290, 183958, -5682, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25640, 180196, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25159, 180171, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25429, 180370, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -24914, 180040, -5404, 0, 0, 54606, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -24925, 180192, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25530, 180548, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25659, 180622, -5400, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25429, 180726, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25631, 180726, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25126, 180548, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25026, 180014, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -30262, 180677, -5291, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -30001, 180406, -5242, 0, 0, 64767, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -31074, 180746, -5242, 0, 0, 33394, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -31430, 180627, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -31027, 180627, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -31472, 180820, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -31228, 180983, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28314, 180126, -5361, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -27709, 180126, -5361, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -26516, 180940, -5451, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -25615, 180482, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -26502, 180955, -5312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -27334, 182625, -5451, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -27892, 181577, -5312, 0, 0, 55831, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28326, 181871, -5314, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28367, 182120, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28065, 182298, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -27964, 181764, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28288, 182217, -5312, 0, 0, 60277, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28462, 181848, -5314, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -27662, 182298, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -29341, 181251, -5282, 0, 0, 28700, 27, 0, 0, 0),
("gludio04_1823_23", 1, 20087, -28286, 182101, -5312, 0, 0, 40316, 27, 0, 0, 0),
-- Ant Warrior Captain
("gludio04_1923_16", 1, 20088, -19757, 185960, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -19355, 185604, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -15241, 181560, -5387, 0, 0, 45330, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -15786, 182115, -5387, 0, 0, 15770, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -16196, 179815, -5387, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -15751, 180074, -5387, 0, 0, 34815, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18701, 178871, -5387, 0, 0, 19304, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18687, 178557, -5387, 0, 0, 24530, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18466, 178343, -5427, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18667, 178699, -5427, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18823, 178575, -5387, 0, 0, 35582, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18462, 178330, -5387, 0, 0, 37883, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -17792, 180659, -5518, 0, 0, 50049, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18525, 180026, -5556, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -17793, 180808, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -18197, 180452, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -17290, 180274, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -17966, 181194, -5518, 0, 0, 56658, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -17289, 181342, -5520, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -16337, 181290, -5468, 0, 0, 5124, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -19425, 183817, -5601, 0, 0, 16783, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -19387, 183245, -5603, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -20489, 183776, -5718, 0, 0, 4529, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25227, 180014, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -24925, 180548, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25255, 180751, -5404, 0, 0, 42805, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25216, 180175, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -24824, 180370, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -24819, 180825, -5423, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25630, 180014, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25732, 180904, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25227, 180370, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25328, 180548, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -25247, 180893, -5406, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -30192, 178858, -5242, 0, 0, 51835, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -29858, 180321, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -31264, 180669, -5242, 0, 0, 36784, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -31127, 180805, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -30646, 180732, -5242, 0, 0, 38594, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -31430, 180983, -5229, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27506, 180054, -5312, 0, 0, 15570, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27762, 180771, -5312, 0, 0, 20081, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -26565, 180834, -5311, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -26114, 180940, -5451, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -26567, 180949, -5305, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27435, 182447, -5451, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27454, 182442, -5345, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28468, 182298, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28065, 181586, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28468, 182654, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28568, 181764, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27763, 181764, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28569, 182476, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27863, 181942, -5365, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -27764, 182397, -5312, 0, 0, 65245, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28230, 182410, -5312, 0, 0, 57659, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -28602, 181464, -5312, 0, 0, 7498, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -23412, 181832, -5603, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -23840, 181507, -5603, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -23385, 183964, -5758, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -23218, 184141, -5666, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -21449, 185522, -5743, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -22053, 185522, -5743, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -22812, 185440, -5600, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -23277, 185768, -5729, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -19959, 187755, -5601, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_16", 1, 20088, -19540, 187424, -5601, 0, 0, 60357, 27, 0, 0, 0),
-- Noble Ant
("gludio05_1923_28", 1, 20089, -18524, 179819, -5481, 0, 0, 10596, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -18366, 180121, -5520, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -17809, 180856, -5518, 0, 0, 10251, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -18197, 180808, -5520, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -17652, 180971, -5518, 0, 0, 36878, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -18357, 180312, -5520, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -17896, 180968, -5518, 0, 0, 16336, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -16458, 181246, -5493, 0, 0, 61884, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -19524, 183056, -5585, 0, 0, 19264, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -19434, 183497, -5601, 0, 0, 48327, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -20529, 183548, -5720, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -19538, 183888, -5601, 0, 0, 65036, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24695, 179842, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24782, 179780, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24383, 179049, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25025, 180370, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25529, 180192, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25328, 180192, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25362, 180083, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25043, 180263, -5408, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25530, 180904, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24001, 181254, -5599, 0, 0, 6232, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25731, 180548, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25026, 180726, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25783, 180370, -5406, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25493, 181031, -5404, 0, 0, 28765, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28011, 179948, -5361, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -27306, 180482, -5361, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -26315, 180940, -5451, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25658, 180615, -5399, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -25913, 180940, -5451, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -27234, 182447, -5451, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -27133, 182625, -5451, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -27364, 182453, -5352, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28670, 182298, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28569, 182120, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28064, 181942, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -27762, 182120, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28468, 181942, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28367, 182476, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28165, 181764, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28950, 181331, -5312, 0, 0, 20275, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -29363, 181213, -5309, 0, 0, 34567, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28852, 182882, -5314, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28957, 182839, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28881, 183216, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -29158, 183195, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -28755, 183195, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -23728, 182213, -5587, 0, 0, 18568, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -23399, 181989, -5606, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24036, 182276, -5603, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -23970, 184154, -5601, 0, 0, 17058, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -24085, 184019, -5601, 0, 0, 57242, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -21615, 185918, -5601, 0, 0, 5356, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -21314, 186337, -5601, 0, 0, 36510, 70, 0, 0, 0),
("gludio05_1923_28", 1, 20089, -23536, 185644, -5601, 0, 0, 33913, 70, 0, 0, 0),
-- Noble Ant Leader
("gludio05_1923_34", 1, 20090, -19345, 183428, -5644, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -19311, 183918, -5601, 0, 0, 45579, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -19971, 183922, -5593, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -27467, 182542, -5344, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -27439, 182431, -5343, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -26645, 182644, -5408, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -28002, 182128, -5312, 0, 0, 56643, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -29057, 183017, -5365, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -29155, 183102, -5296, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -28856, 183017, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -28855, 183373, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -29057, 183373, -5312, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -23981, 182128, -5603, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -23940, 181685, -5603, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -23538, 181685, -5603, 0, 0, 0, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -23641, 184097, -5601, 0, 0, 1814, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -22666, 183990, -5718, 0, 0, 61998, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -23458, 185678, -5601, 0, 0, 33468, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -21872, 185732, -5601, 0, 0, 38704, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -22963, 185686, -5601, 0, 0, 36922, 70, 0, 0, 0),
("gludio05_1923_34", 1, 20090, -22797, 185668, -5601, 0, 0, 23586, 70, 0, 0, 0),
-- Skeleton Marauder
("dion17_2023_09", 1, 20190, -12918, 179622, -4183, 0, 0, 31275, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -9879, 182448, -4184, 0, 0, 37785, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -10638, 179801, -4080, 0, 0, 28270, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -6240, 185983, -3580, 0, 0, 21074, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -5926, 185369, -3570, 0, 0, 5378, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -5493, 191098, -3444, 0, 0, 12675, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -4919, 191878, -3441, 0, 0, 50324, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -25650, 195633, -3927, 0, 0, 47472, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -24742, 192645, -4150, 0, 0, 58856, 29, 0, 0, 0),
-- Skeleton Raider
("gludio04_1923_03", 1, 20191, -12961, 178428, -4285, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -10834, 178643, -4056, 0, 0, 11055, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -12190, 176459, -3964, 0, 0, 4376, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -12542, 182196, -4096, 0, 0, 14326, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -13729, 181714, -4269, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -16421, 180361, -4202, 0, 0, 35810, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -12723, 181002, -4269, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -11001, 183608, -4166, 0, 0, 30756, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -9080, 183043, -4175, 0, 0, 5509, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -8744, 181181, -4253, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -7370, 186721, -3560, 0, 0, 33914, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -6665, 189117, -3638, 0, 0, 18384, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -5584, 186142, -3302, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -8060, 186518, -3441, 0, 0, 65287, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -9602, 186587, -3317, 0, 0, 54594, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -8064, 190541, -3919, 0, 0, 42885, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -7522, 191695, -3921, 0, 0, 47246, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -11662, 192258, -3995, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -11259, 192614, -3995, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -10933, 190624, -4204, 0, 0, 26200, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -9185, 190101, -4305, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -21811, 193925, -4175, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -20603, 194281, -4175, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -21006, 193925, -4175, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -24621, 196418, -3927, 0, 0, 47944, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -22465, 194493, -4171, 0, 0, 2366, 27, 0, 0, 0),
-- Tyrant
("gludio04_1823_26", 1, 20192, -29376, 185442, -4170, 0, 0, 3571, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -32371, 185798, -4208, 0, 0, 20542, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -19858, 186138, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -19153, 185604, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -18952, 185604, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -19758, 186316, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -19959, 187028, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -19556, 185604, -4208, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -21066, 191599, -4061, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -21669, 191955, -4061, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24664, 192801, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24462, 192801, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24160, 192623, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24362, 192267, -4484, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24881, 187271, -4103, 0, 0, 31491, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24605, 192058, -4155, 0, 0, 43105, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -27311, 186108, -4206, 0, 0, 41537, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -26073, 184931, -4418, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -26375, 185109, -4240, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -26477, 185643, -4176, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -31347, 181034, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -29736, 181390, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -30944, 181390, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -30953, 179811, -4209, 0, 0, 41888, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -31146, 181034, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -29989, 179437, -4209, 0, 0, 36036, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -30832, 177484, -4293, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -28448, 177238, -4112, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -28026, 178068, -3968, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -28529, 178246, -3968, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -22450, 175963, -4282, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -20541, 179046, -4080, 0, 0, 54019, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -17606, 180607, -4208, 0, 0, 4438, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -20005, 174396, -3929, 0, 0, 64321, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -22551, 175429, -4282, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -11697, 178343, -4090, 0, 0, 44730, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -24789, 176362, -4181, 0, 0, 36079, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -27508, 174088, -4342, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -27609, 174622, -4342, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -27713, 173532, -4290, 0, 0, 61234, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20192, -27307, 174444, -4342, 0, 0, 0, 27, 0, 0, 0),
-- Tyrant Kingpin
("gludio04_1823_26", 1, 20193, -31122, 184550, -4208, 0, 0, 30557, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -28828, 183609, -4157, 0, 0, 52530, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -25700, 189770, -4303, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -26338, 188247, -4157, 0, 0, 49470, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -26073, 185643, -4168, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -25671, 185287, -4312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -25570, 185465, -4312, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -25771, 185109, -4418, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -30643, 180856, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -30039, 180856, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -31247, 181568, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -30844, 181212, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -30240, 181568, -4411, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -32428, 179297, -4209, 0, 0, 14778, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -29506, 182105, -4190, 0, 0, 13530, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -31986, 180928, -4209, 0, 0, 27049, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -27926, 178246, -3968, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_26", 1, 20193, -28932, 178602, -3968, 0, 0, 0, 27, 0, 0, 0),
-- Bloody Bee
("dion17_2023_05", 1, 20204, -3791, 170254, -2921, 0, 0, 32269, 29, 0, 0, 0),
("dion17_2023_05", 1, 20204, -2865, 169015, -3000, 0, 0, 49400, 29, 0, 0, 0),
-- Dire Wolf
("dion15_2022_07", 1, 20205, -367, 164956, -3170, 0, 0, 0, 24, 0, 0, 0),
("dion15_2022_07", 1, 20205, -1373, 170644, -3301, 0, 0, 27830, 24, 0, 0, 0),
("dion15_2022_07", 1, 20205, -636, 171429, -3193, 0, 0, 14505, 24, 0, 0, 0),
("dion15_2022_07", 1, 20205, -1984, 168828, -3216, 0, 0, 35600, 24, 0, 0, 0),
("dion15_2022_07", 1, 20205, -44, 180027, -3723, 0, 0, 20988, 24, 0, 0, 0),
-- Kadif Werewolf
("dion17_2023_01", 1, 20206, -266, 164422, -3136, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -3487, 166834, -2708, 0, 0, 19953, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -209, 166841, -3472, 0, 0, 64310, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -1865, 171646, -3251, 0, 0, 49456, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -1775, 175113, -3396, 0, 0, 47198, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -1163, 178455, -3705, 0, 0, 8047, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -1376, 175997, -3575, 0, 0, 54593, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -1902, 180045, -3637, 0, 0, 14963, 29, 0, 0, 0),
("dion17_2023_01", 1, 20206, -720, 169520, -3395, 0, 0, 54123, 29, 0, 0, 0),
-- Glass Jaguar
("dion17_2023_04", 1, 20250, -176, 182782, -3726, 0, 0, 7564, 29, 0, 0, 0),
("dion17_2023_04", 1, 20250, -21, 181536, -3723, 0, 0, 31984, 29, 0, 0, 0),
("dion17_2023_04", 1, 20250, -1898, 181265, -3545, 0, 0, 37485, 29, 0, 0, 0),
("dion17_2023_04", 1, 20250, -941, 186077, -3703, 0, 0, 33468, 29, 0, 0, 0),
-- Ol Mahum Reserve
("dion03_2121_01", 1, 20547, -21353, 164657, -3198, 0, 0, 45346, 60, 0, 0, 0),
("dion03_2121_01", 1, 20547, -14434, 166021, -2432, 0, 0, 9517, 60, 0, 0, 0),
-- Gigantiops
("gludio04_1923_p15", 1, 20745, -16274, 189492, -4203, 0, 0, 38521, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -13572, 188967, -4167, 0, 0, 31116, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -19858, 185782, -4579, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -18471, 185203, -3903, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -19858, 186138, -4093, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -19757, 186316, -4579, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -20060, 186138, -4083, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -19247, 188286, -4152, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -19255, 185782, -4579, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -26073, 184931, -4418, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -25771, 185465, -4418, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -25872, 184931, -4418, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -30341, 180678, -4411, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -29536, 181034, -4411, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -30341, 181034, -4411, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -29112, 181168, -4315, 0, 0, 2321, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -29637, 180856, -4411, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -30039, 180856, -4411, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -32028, 178444, -4209, 0, 0, 3356, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -28730, 178246, -4321, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -22148, 175073, -4282, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -21931, 178186, -4175, 0, 0, 56661, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -21037, 176766, -4196, 0, 0, 51429, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -24625, 180317, -4173, 0, 0, 33061, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -21969, 182410, -4034, 0, 0, 18698, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -26680, 175661, -4075, 0, 0, 38727, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -21745, 175073, -4282, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -23099, 188491, -4666, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -23401, 189381, -4666, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -23301, 188847, -4666, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -23200, 189025, -4666, 0, 0, 0, 55, 0, 0, 0),
("gludio04_1923_p15", 1, 20745, -22697, 188847, -4666, 0, 0, 0, 55, 0, 0, 0),
-- Cave Ant Larva
("gludio44_1923_01", 1, 21265, -27386, 193644, -3942, 0, 0, 48695, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -27559, 193102, -3942, 0, 0, 28214, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -27971, 191681, -3942, 0, 0, 44093, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -29440, 190302, -3942, 0, 0, 37534, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -30042, 189457, -3942, 0, 0, 47841, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -30122, 189233, -3942, 0, 0, 12104, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -29021, 191554, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21265, -28685, 192427, -3942, 0, 0, 0, 70, 0, 0, 0),
-- Cave Ant Larva
("gludio44_1923_01", 1, 21266, -27578, 194579, -3987, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -27311, 193593, -3942, 0, 0, 49874, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -28594, 190624, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -29966, 190638, -3942, 0, 0, 2059, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -30581, 188645, -3942, 0, 0, 3186, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -28580, 192674, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21266, -27735, 194373, -3987, 0, 0, 0, 70, 0, 0, 0),
-- Cave Ant Larva
("gludio44_1923_01", 1, 21267, -27433, 193734, -3942, 0, 0, 41813, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21267, -28063, 191410, -3942, 0, 0, 43874, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21267, -29907, 191065, -3942, 0, 0, 5358, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21267, -29021, 191910, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21267, -28382, 192961, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_01", 1, 21267, -27634, 194551, -3987, 0, 0, 0, 70, 0, 0, 0),
-- Cave Ant Larva
("gludio44_1923_04", 1, 21268, -27426, 193450, -3942, 0, 0, 63919, 70, 0, 0, 0),
("gludio44_1923_04", 1, 21268, -27605, 192394, -3942, 0, 0, 10864, 70, 0, 0, 0),
("gludio44_1923_04", 1, 21268, -28488, 192116, -3942, 0, 0, 0, 70, 0, 0, 0),
("gludio44_1923_04", 1, 21268, -30077, 189156, -3942, 0, 0, 7667, 70, 0, 0, 0),
("gludio44_1923_04", 1, 21268, -28920, 191732, -3942, 0, 0, 0, 70, 0, 0, 0),
-- Skeletal Mercenary
("gludio01_qm1923_01", 1, 27100, -18172, 193940, -4312, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -17870, 194118, -4312, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -25661, 172719, -4170, 0, 0, 53313, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -26589, 175190, -4196, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -22800, 189464, -4632, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -22397, 189464, -4632, 0, 0, 0, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -12375, 189145, -4148, 0, 0, 39761, 180, 0, 0, 0),
("gludio01_qm1923_01", 1, 27100, -11958, 189879, -4155, 0, 0, 38972, 180, 0, 0, 0),
-- Guard Ant
("queen_ant_guard_room", 1, 29004, -21562, 179041, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21139, 179392, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21984, 179183, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22020, 179689, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21281, 179733, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21925, 180003, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21531, 180046, -5846, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22154, 181958, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21672, 181903, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -20992, 181627, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21861, 182279, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21693, 182717, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22070, 182890, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22262, 183156, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21308, 182278, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21113, 182681, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21446, 183135, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -21854, 183450, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -20714, 182103, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -20720, 182775, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -20949, 183233, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22349, 182333, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22406, 182733, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22700, 182486, -5734, 0, 0, 0, 360, 0, 0, 0),
("queen_ant_guard_room", 1, 29004, -22015, 181518, -5734, 0, 0, 0, 360, 0, 0, 0),
-- Casian
("gludio04_npc1923_003", 1, 30612, -16895, 194229, -4207, 0, 0, 11000, 60, 0, 0, 0),
-- Windy Shaoring
("gludio04_npc1923_002", 1, 30660, -21101, 178989, -4094, 0, 0, 0, 60, 0, 0, 0),
-- Sla
("gludio04_npc1923_001", 1, 30666, -671, 179051, -3708, 0, 0, 32768, 60, 0, 0, 0),
-- Weathered Rock
("Wastelands", 1, 32368, -21982, 186630, -4312, 0, 0, 0, 60, 0, 0, 0),

-- [19_24]

-- Hungry Eye
("gludio35_1822_01", 1, 20059, -11980, 201872, -2760, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11779, 201872, -2768, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11678, 202050, -2792, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -11287, 198824, -3465, 0, 0, 17667, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -8176, 201430, -3354, 0, 0, 48548, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -5661, 199673, -3566, 0, 0, 47795, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -4934, 198705, -3780, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -12211, 202490, -2770, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32528, 211072, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -26719, 214285, -3708, 0, 0, 64159, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -29848, 213463, -3723, 0, 0, 3313, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -32108, 213187, -3704, 0, 0, 8523, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -27384, 211044, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -27182, 211400, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -27686, 211222, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -26679, 211578, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -21545, 215547, -3710, 0, 0, 4529, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -25008, 209719, -3205, 0, 0, 45349, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -24621, 214731, -3723, 0, 0, 17074, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -24832, 213437, -3723, 0, 0, 38849, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -21043, 212401, -3704, 0, 0, 0, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -17434, 215565, -3703, 0, 0, 11597, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -21108, 213660, -3706, 0, 0, 2149, 20, 0, 0, 0),
("gludio35_1822_01", 1, 20059, -19800, 214526, -3704, 0, 0, 36909, 20, 0, 0, 0),
-- Ol Mahum Shooter
("dion03_2121_01", 1, 20063, -12384, 202940, -2800, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -11377, 202228, -2852, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -12081, 202406, -2776, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -12081, 203118, -2870, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -8786, 200789, -3123, 0, 0, 37852, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -9191, 200230, -2960, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -3995, 198046, -3293, 0, 0, 33245, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -5438, 198171, -3780, 0, 0, 0, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -5698, 201336, -3707, 0, 0, 27135, 60, 0, 0, 0),
("dion03_2121_01", 1, 20063, -11954, 202830, -3504, 0, 0, 0, 60, 0, 0, 0),
-- Ol Mahum Captain
("gludio40_1922_03", 1, 20066, -11578, 202584, -2888, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -9191, 202208, -3221, 0, 0, 55025, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -11075, 202050, -2866, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -11477, 202050, -2816, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -12584, 202228, -2712, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10476, 205377, -3566, 0, 0, 16902, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -8948, 200090, -3828, 0, 0, 0, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -8089, 203521, -3569, 0, 0, 44836, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -7404, 200373, -3389, 0, 0, 95, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -6785, 199477, -3346, 0, 0, 34730, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -4602, 200311, -3655, 0, 0, 7483, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -6387, 198605, -3161, 0, 0, 53851, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -5171, 202516, -3706, 0, 0, 23515, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -10463, 203058, -3159, 0, 0, 1479, 20, 0, 0, 0),
("gludio40_1922_03", 1, 20066, -13214, 204534, -2701, 0, 0, 3009, 20, 0, 0, 0),
-- Monster Eye Watcher
("gludio04_1823_01", 1, 20067, -28548, 196693, -3661, 0, 0, 44499, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -26814, 199260, -3706, 0, 0, 51376, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -24007, 202163, -3671, 0, 0, 52352, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -24733, 203535, -3664, 0, 0, 21837, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -24685, 201165, -3864, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -20323, 203655, -3661, 0, 0, 44136, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -20093, 197052, -4198, 0, 0, 51484, 27, 0, 0, 0),
("gludio04_1823_01", 1, 20067, -19498, 198974, -4198, 0, 0, 48391, 27, 0, 0, 0),
-- Monster Eye Destroyer
("dion17_2023_01", 1, 20068, -19451, 202038, -3919, 0, 0, 53004, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -18457, 201574, -3917, 0, 0, 54196, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -21953, 201368, -3917, 0, 0, 35196, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -20493, 200560, -4198, 0, 0, 0, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -21836, 199494, -4115, 0, 0, 49514, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -13388, 200628, -3465, 0, 0, 23709, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -9958, 197182, -3465, 0, 0, 3770, 29, 0, 0, 0),
("dion17_2023_01", 1, 20068, -7543, 196683, -3465, 0, 0, 28210, 29, 0, 0, 0),
-- Lesser Basilisk
("gludio04_1823_02", 1, 20070, -27250, 201076, -3792, 0, 0, 19441, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -27961, 199065, -3661, 0, 0, 33937, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -25290, 201521, -3864, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -25918, 202750, -3792, 0, 0, 38281, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -21452, 202249, -3960, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -21856, 203317, -3960, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -18892, 202786, -3851, 0, 0, 11320, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -23046, 200425, -4198, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -12740, 200112, -3465, 0, 0, 27669, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -11450, 199757, -3465, 0, 0, 64639, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -11131, 196872, -3633, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -11049, 198118, -3465, 0, 0, 25764, 27, 0, 0, 0),
("gludio04_1823_02", 1, 20070, -9816, 196734, -3465, 0, 0, 50550, 27, 0, 0, 0),
-- Basilisk
("gludio04_1823_06", 1, 20072, -28495, 197532, -3661, 0, 0, 15726, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -18217, 204654, -3621, 0, 0, 10692, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -19119, 203517, -3786, 0, 0, 42421, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -24710, 198404, -3917, 0, 0, 15103, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -24565, 197349, -3917, 0, 0, 8966, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -25466, 196766, -3917, 0, 0, 42394, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -14850, 197945, -3916, 0, 0, 54843, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -17356, 201351, -3917, 0, 0, 63076, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -13318, 199014, -3651, 0, 0, 44513, 27, 0, 0, 0),
("gludio04_1823_06", 1, 20072, -9640, 198190, -3465, 0, 0, 63349, 27, 0, 0, 0),
-- Granite Golem
("dion02_2122_22", 1, 20083, -14172, 197513, -3917, 0, 0, 18336, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -25784, 197659, -3916, 0, 0, 36885, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -23536, 197201, -3916, 0, 0, 38758, 35, 0, 0, 0),
("dion02_2122_22", 1, 20083, -20999, 196918, -4290, 0, 0, 0, 35, 0, 0, 0),
-- Skeleton Marauder
("dion17_2023_09", 1, 20190, -27711, 198156, -3723, 0, 0, 28440, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -18186, 197501, -4176, 0, 0, 11253, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -15077, 198830, -3916, 0, 0, 54300, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -13599, 197253, -3916, 0, 0, 28244, 29, 0, 0, 0),
("dion17_2023_09", 1, 20190, -14740, 197252, -3916, 0, 0, 49780, 29, 0, 0, 0),
-- Skeleton Raider
("gludio04_1923_03", 1, 20191, -23759, 198506, -3672, 0, 0, 51570, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -26105, 196670, -3916, 0, 0, 24055, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -21603, 196918, -4290, 0, 0, 0, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -18914, 200346, -4006, 0, 0, 16307, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -20599, 198316, -4185, 0, 0, 50624, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -19545, 196694, -4198, 0, 0, 38008, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -18901, 198398, -4198, 0, 0, 5722, 27, 0, 0, 0),
("gludio04_1923_03", 1, 20191, -15306, 197000, -3917, 0, 0, 26689, 27, 0, 0, 0),
-- Langk Lizardman Lieutenant
("gludio22_1824_03", 1, 20357, -31723, 210360, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -30062, 212953, -3723, 0, 0, 2724, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -27841, 213972, -3723, 0, 0, 4675, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -31823, 210182, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -26378, 211044, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -26880, 211578, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -27182, 211756, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -27283, 211578, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -27082, 211222, -3720, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -23153, 212030, -3347, 0, 0, 0, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -25322, 215468, -3704, 0, 0, 8072, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -19511, 215314, -3704, 0, 0, 5549, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -23520, 214836, -3723, 0, 0, 61801, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -21632, 214767, -3708, 0, 0, 22, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -16601, 213921, -3704, 0, 0, 64533, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -15149, 213639, -3704, 0, 0, 52388, 20, 0, 0, 0),
("gludio22_1824_03", 1, 20357, -21692, 211867, -3285, 0, 0, 55978, 20, 0, 0, 0),
-- Lesser Warlike Tyrant
("gludio36_1823_04", 1, 21014, -31733, 196696, -3791, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_04", 1, 21014, -32015, 202108, -3296, 0, 0, 47576, 25, 0, 0, 0),
-- Ol Mahum Van Leader
("gludio36_1823_08", 1, 21015, -31230, 196874, -3791, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -32136, 197052, -3791, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -30454, 199409, -3572, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -31568, 199148, -3506, 0, 0, 59948, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -29849, 200121, -3572, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -28607, 202547, -3533, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -29271, 203654, -3408, 0, 0, 3810, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -31922, 204598, -3396, 0, 0, 30010, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -31180, 200853, -3447, 0, 0, 54332, 25, 0, 0, 0),
("gludio36_1823_08", 1, 21015, -29893, 203004, -3451, 0, 0, 43170, 25, 0, 0, 0),
-- Warlike Tyrant
("gludio36_1824_02", 1, 21016, -31229, 197230, -3791, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -30353, 199943, -3572, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -29865, 202053, -3450, 0, 0, 5468, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -30852, 199604, -3424, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -30334, 204565, -3173, 0, 0, 20147, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -27802, 202903, -3533, 0, 0, 0, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -27913, 204680, -3156, 0, 0, 12466, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -29111, 204533, -3265, 0, 0, 13579, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -28937, 201424, -3450, 0, 0, 17128, 25, 0, 0, 0),
("gludio36_1824_02", 1, 21016, -32391, 203961, -3428, 0, 0, 59035, 25, 0, 0, 0),
-- Langk Lizardman Sentinel
("gludio22_1824_02", 1, 21100, -18218, 213876, -3704, 0, 0, 830, 20, 0, 0, 0),
("gludio22_1824_02", 1, 21100, -20539, 213291, -3704, 0, 0, 0, 20, 0, 0, 0),
-- Langk Lizardman Shaman
("gludio22_1824_05", 1, 21101, -32063, 212116, -3700, 0, 0, 63255, 20, 0, 0, 0),
-- Mimi the Cat
("gludio01_qm1924_01", 1, 27105, -24003, 207704, -3305, 0, 0, 0, 180, 0, 0, 0),
-- Sarien
("gludio04_npc1924_005", 1, 30436, -16832, 210256, -3661, 0, 0, 55000, 60, 0, 0, 0),
-- Rolento
("gludio04_npc1924_006", 1, 30437, -17312, 208976, -3661, 0, 0, 3000, 60, 0, 0, 0),
-- Basilla
("gludio04_npc1924_004", 1, 30638, -23896, 207797, -3176, 0, 0, 16384, 60, 0, 0, 0),
-- Sir Aron Tanford
("gludio42_npc1924_002", 1, 30653, -6774, 202086, -3649, 0, 0, 0, 60, 0, 0, 0),
-- Jax
("gludio04_npc1924_003", 1, 30730, -17305, 209742, -3660, 0, 0, 61440, 60, 0, 0, 0),
-- Black Judge
("gludio04_npc1924_001", 1, 30981, -18960, 209834, -3656, 0, 0, 0, 60, 0, 0, 0),
-- Warpgate
("Wasteland", 1, 32314, -16899, 209827, -3640, 0, 0, 0, 60, 0, 0, 0),

-- [19_25]

-- Dolmen
("hellbound", 1, 32307, -5952, 249344, -3112, 0, 0, 0, 60, 0, 0, 0),

-- [19_26]

-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18445, -13571, 275912, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18446, -11948, 276084, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18447, -12092, 275684, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18448, -10406, 274545, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18449, -10790, 274430, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18450, -11132, 273604, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18451, -10748, 272746, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18452, -10935, 273107, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18453, -12965, 272272, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18454, -13358, 272417, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18455, -14446, 272952, -9032, 0, 0, 0, 15, 0, 0, 0),
("tully_workshop_5th_floor", 1, 18455, -14610, 273721, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18456, -14192, 273509, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18457, -14190, 274500, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18458, -13731, 274675, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18459, -13855, 273649, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18460, -13743, 273238, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Tully's Gatekeeper
("tully_workshop_5th_floor", 1, 18461, -11815, 272753, -9032, 0, 0, 0, 15, 0, 0, 0),
-- Cosmic Scout
("tower_of_infinitum_1st_floor", 1, 22373, -21940, 280046, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -21643, 278200, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -21757, 279782, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -22651, 280082, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -21873, 277941, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -21831, 278311, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -22338, 279787, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22373, -22742, 278432, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22636, 279789, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22124, 278698, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22144, 278799, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -23036, 278758, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22034, 280086, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -21873, 277683, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22484, 279692, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -21892, 279548, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22055, 278037, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22373, -22909, 279146, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22373, -22175, 278972, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22373, -22571, 279440, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22373, -21592, 279836, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22373, -22754, 280046, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22373, -22994, 278375, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22373, -22836, 278968, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22373, -21347, 279418, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22373, -19302, 279853, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22373, -19420, 278091, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22373, -18898, 278699, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22373, -18243, 279777, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22373, -19025, 278174, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22373, -19909, 279034, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22373, -18274, 278217, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22373, -19005, 280126, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22373, -19028, 278118, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22373, -18217, 278684, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22373, -19486, 279456, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22373, -18255, 279962, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22373, -18795, 279055, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22373, -18442, 278688, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22373, -19003, 277986, -13376, 0, 0, 0, 80, 0, 0, 0),
-- Cosmic Watcher
("tower_of_infinitum_1st_floor", 1, 22374, -21364, 277697, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22374, -21439, 278661, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22374, -21568, 279879, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22374, -21503, 278294, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22374, -21367, 279725, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22374, -22340, 278843, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22374, -22292, 280161, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22374, -22133, 280000, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22374, -22159, 279183, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22374, -22312, 277892, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22374, -22505, 278678, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22374, -22460, 278670, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22374, -22933, 278955, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22374, -22162, 278571, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22374, -22390, 277878, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22374, -18136, 278439, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22374, -18745, 279224, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22374, -19811, 279140, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22374, -19660, 278213, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22374, -19068, 279096, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22374, -18789, 280108, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22374, -19656, 278983, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22374, -18801, 279598, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22374, -18554, 278381, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22374, -18446, 279900, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22374, -19125, 277824, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22374, -19051, 279094, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22374, -18275, 280201, -13376, 0, 0, 0, 80, 0, 0, 0),
-- Cosmic Priest
("tower_of_infinitum_1st_floor", 1, 22375, -23076, 278469, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22375, -22914, 280132, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22375, -21752, 279167, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22375, -22089, 277806, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22375, -22781, 278277, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22375, -21760, 278566, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22375, -23046, 279376, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22375, -21943, 279593, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22375, -21369, 278556, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22375, -21592, 278940, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22375, -21532, 279564, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22375, -21477, 277964, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22375, -19671, 278274, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22375, -18773, 278032, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22375, -18167, 277691, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22375, -18683, 278809, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22375, -19436, 279401, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22375, -19735, 279594, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22375, -19886, 280021, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22375, -19640, 278089, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22375, -19306, 279370, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22375, -18459, 278644, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22375, -19805, 278088, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22375, -19002, 279480, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22375, -19404, 279529, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22375, -18378, 279902, -13376, 0, 0, 0, 80, 0, 0, 0),
-- Cosmic Lord
("tower_of_infinitum_1st_floor", 1, 22376, -22956, 279068, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_1st_floor", 1, 22376, -22330, 278874, -15040, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_2nd_floor", 1, 22376, -21779, 278956, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22376, -22685, 279996, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_3rd_floor", 1, 22376, -22368, 278757, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22376, -21377, 278781, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22376, -22951, 277978, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_4th_floor", 1, 22376, -21898, 279620, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22376, -18770, 279994, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22376, -18453, 279887, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22376, -19395, 279355, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22376, -19463, 280151, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_6th_floor", 1, 22376, -18756, 278140, -8256, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22376, -18249, 278160, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22376, -19067, 278109, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22376, -18531, 278059, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_7th_floor", 1, 22376, -18454, 279673, -9920, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22376, -18898, 279401, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22376, -19032, 280016, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22376, -19438, 278045, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_8th_floor", 1, 22376, -18484, 279381, -11648, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22376, -19871, 277949, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22376, -18285, 278348, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22376, -19376, 278718, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22376, -19097, 278991, -13376, 0, 0, 0, 80, 0, 0, 0),
("tower_of_infinitum_9th_floor", 1, 22376, -19633, 278446, -13376, 0, 0, 0, 80, 0, 0, 0),
-- Master Zelos
("tully_workshop_1st_floor", 1, 22377, -13729, 274198, -15300, 0, 0, 0, 10800, 0, 0, 0),
-- Master Festina
("tully_workshop_3rd_floor", 1, 22380, -12496, 273964, -11620, 0, 0, 40960, 10800, 0, 0, 0),
-- Master's Guard
("tully_workshop_3rd_floor", 1, 22381, -12372, 273828, -11620, 0, 0, 24576, 180, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22381, -12648, 274100, -11616, 0, 0, 57343, 180, 0, 0, 0),
-- Master's Guard
("tully_workshop_3rd_floor", 1, 22382, -12404, 274068, -11620, 0, 0, 40960, 180, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22382, -12632, 273828, -11616, 0, 0, 8192, 180, 0, 0, 0),
-- Tully's Toy
("tully_workshop_1st_floor", 1, 22383, -13238, 272762, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12962, 272516, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12074, 272556, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12164, 273077, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -11668, 273141, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -13092, 275025, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -13252, 275208, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12945, 274732, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12379, 275040, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -11970, 274924, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12394, 274807, -15300, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22383, -13337, 273340, -13600, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22383, -11488, 273461, -13600, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22383, -11602, 275025, -13600, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22383, -13590, 273755, -13600, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13152, 274837, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12853, 274674, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13608, 274453, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12857, 274178, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12965, 275082, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13959, 273697, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13009, 273360, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13771, 273338, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13663, 273642, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -13268, 273029, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11621, 273536, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12159, 273458, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11668, 273321, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12041, 272621, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11610, 273106, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11093, 274167, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11357, 274608, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -12248, 275126, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11190, 274249, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22383, -11821, 274915, -12075, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22383, -12707, 272764, -15300, 0, 0, 0, 60, 0, 0, 0),
-- Tully's Golem Guard
("tully_workshop_1st_floor", 1, 22385, -12939, 272715, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -11678, 272732, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -11856, 272870, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -11672, 273526, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -11216, 273701, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -11559, 273722, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -12961, 275113, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22385, -12013, 275217, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -12328, 273060, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -13540, 272915, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -13524, 272702, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -11081, 273193, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -11051, 273407, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -11504, 272791, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -12543, 275261, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -12597, 274811, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -12873, 275250, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -13328, 274946, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -13749, 274063, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22385, -13502, 274558, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -13418, 274286, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -12989, 274309, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -12852, 273239, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -13338, 273326, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -12209, 272784, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -11862, 273155, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -11808, 274290, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22385, -11340, 274463, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -13031, 273002, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -13704, 273287, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -11023, 273519, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -11599, 273920, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -11739, 275161, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -12168, 275042, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -13722, 274272, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22385, -13779, 274875, -10495, 0, 0, 0, 80, 0, 0, 0),
-- Foundry Mystic
("tully_workshop_3rd_floor", 1, 22386, -13267, 274955, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22386, -13191, 273481, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22386, -11818, 273440, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22386, -11885, 274374, -12075, 0, 0, 0, 80, 0, 0, 0),
-- Foundry Mystic
("tully_workshop_1st_floor", 1, 22387, -13081, 272918, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22387, -11115, 273974, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22387, -11683, 273823, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22387, -13123, 274853, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_1st_floor", 1, 22387, -11760, 275044, -15300, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -13257, 272762, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -13311, 273020, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -11610, 273298, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -11509, 272778, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -12199, 274885, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -11870, 275070, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -13277, 274835, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22387, -13427, 273732, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -13373, 272923, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -13741, 273029, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -11592, 273117, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -11517, 273291, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -12186, 275408, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -11763, 274821, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -14055, 274282, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22387, -13396, 274666, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -12233, 278286, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -13742, 278946, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -12559, 278655, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -12318, 280960, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -12340, 280841, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -11868, 281047, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -13453, 279791, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -13320, 280753, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -13748, 280324, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -11100, 279472, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -11470, 279516, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22387, -11474, 279318, -13599, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13274, 278868, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -12085, 278240, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13247, 278451, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13305, 278698, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13569, 278852, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11669, 280590, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11837, 280911, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11657, 280832, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11912, 280725, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -12115, 280883, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13644, 279654, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13649, 279757, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13285, 280500, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13838, 280320, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -13899, 280410, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11655, 278578, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11528, 279157, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11298, 279453, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11662, 278497, -10492, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22387, -11152, 279177, -10492, 0, 0, 0, 80, 0, 0, 0),
-- Foundry Spirit Guard
("tully_workshop_3rd_floor", 1, 22388, -13155, 275259, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -13715, 274467, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -12893, 272625, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -13854, 273628, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -11937, 273167, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -11857, 273493, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -11763, 274750, -12075, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_3rd_floor", 1, 22388, -11831, 274748, -12075, 0, 0, 0, 80, 0, 0, 0),
-- Foundry Spirit Guard
("tully_workshop_2nd_floor", 1, 22389, -12898, 272997, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -12496, 272630, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -11329, 273905, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -11368, 273041, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -12051, 274868, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -12695, 274902, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -13492, 274350, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_2nd_floor", 1, 22389, -13927, 274695, -13600, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -13317, 273194, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -12758, 272413, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -11408, 274235, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -11121, 274238, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -11827, 275324, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -12962, 275422, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -13599, 273820, -10495, 0, 0, 0, 80, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22389, -13943, 274266, -10495, 0, 0, 0, 80, 0, 0, 0),
-- Foundry Foreman
("tully_workshop_4th_floor", 1, 22390, -12786, 272617, -10495, 0, 0, 0, 180, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22390, -10988, 273585, -10495, 0, 0, 0, 180, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22390, -11620, 274892, -10495, 0, 0, 0, 180, 0, 0, 0),
("tully_workshop_4th_floor", 1, 22390, -13220, 274690, -10495, 0, 0, 0, 180, 0, 0, 0),
-- Original Sin Warden
("tully_workshop_6th_floor", 1, 22423, -12856, 278724, -13599, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22423, -11981, 281013, -13599, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22423, -13130, 280552, -13599, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_6th_floor", 1, 22423, -11059, 279526, -13599, 0, 0, 0, 60, 0, 0, 0),
-- Original Sin Warden
("tully_workshop_8th_floor", 1, 22431, -13040, 278330, -10492, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22431, -12588, 281087, -10492, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22431, -13514, 280019, -10492, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_8th_floor", 1, 22431, -11036, 279506, -10492, 0, 0, 0, 60, 0, 0, 0),
-- Teleportation Cubic
("tully_workshop_6th_floor", 1, 32467, -12752, 279696, -13596, 0, 0, 32768, 60, 0, 0, 0),
("tully_workshop_8th_floor", 1, 32467, -12752, 279696, -10492, 0, 0, 32768, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_1_st_floor", 1, 32745, -22208, 277024, -15040, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_2_nd_floor", 1, 32746, -22208, 277072, -13376, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_3_rd_floor", 1, 32747, -22208, 277056, -11648, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_4_th_floor", 1, 32748, -22208, 277072, -9920, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_6_th_floor", 1, 32749, -19024, 277072, -8256, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_7_th_floor", 1, 32750, -19024, 277056, -9920, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_8_th_floor", 1, 32751, -19008, 277040, -11648, 0, 0, 16384, 60, 0, 0, 0),
-- Teleport Device
("tower_of_infinitum_9_st_floor", 1, 32752, -19008, 277024, -13376, 0, 0, 16384, 60, 0, 0, 0),
-- Floor Teleport Device
("tully_workshop_1st_floor", 1, 32753, -13226, 273413, -15304, 0, 0, 0, 60, 0, 0, 0),
("tully_workshop_1st_floor", 1, 32753, -12944, 273952, -15296, 0, 0, 16384, 60, 0, 0, 0),
-- Floor Teleport Device
("tully_workshop_2nd_floor", 1, 32754, -12768, 273440, -13600, 0, 0, 16384, 60, 0, 0, 0),
-- Floor Teleport Device
("tully_workshop_3rd_floor", 1, 32755, -13133, 275690, -11925, 0, 0, 16384, 60, 0, 0, 0),
-- Floor Teleport Device
("tully_workshop_4th_floor", 1, 32756, -12848, 273408, -10496, 0, 0, 16384, 60, 0, 0, 0),

-- [20_10]

-- Lesser Ancient Shaman
("CatacombOfTheForbiddenPath", 1, 21163, 12786, -243887, -9584, 0, 0, 64572, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 13028, -246867, -9586, 0, 0, 60260, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 13197, -245588, -9586, 0, 0, 10228, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 13412, -247110, -9584, 0, 0, 36907, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 13604, -245728, -9584, 0, 0, 62180, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 14018, -245907, -9586, 0, 0, 49005, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 14342, -247208, -9586, 0, 0, 63021, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 16146, -247790, -9586, 0, 0, 48425, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 16429, -248245, -9586, 0, 0, 27857, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 17041, -245824, -9586, 0, 0, 51171, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21163, 17509, -246181, -9586, 0, 0, 31404, 120, 0, 0, 0),
-- Guardian Spirit of Ancient Holy Ground
("CatacombOfTheForbiddenPath", 1, 21164, 15772, -243951, -9586, 0, 0, 62656, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 15999, -244847, -9584, 0, 0, 53736, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 17555, -243716, -9584, 0, 0, 34718, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 17643, -248609, -9584, 0, 0, 64894, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 18359, -248429, -9584, 0, 0, 36123, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 18509, -246082, -9586, 0, 0, 19278, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 18653, -244033, -9584, 0, 0, 49937, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 18797, -246984, -9586, 0, 0, 5276, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21164, 19864, -248564, -9586, 0, 0, 18443, 120, 0, 0, 0),
-- Lesser Ancient Warrior
("CatacombOfTheForbiddenPath", 1, 21165, 20440, -245635, -9586, 0, 0, 42746, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 20757, -246110, -9584, 0, 0, 54022, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 20926, -245605, -9586, 0, 0, 9699, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 20947, -243752, -9586, 0, 0, 29866, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 21286, -248300, -9586, 0, 0, 15641, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 21622, -243713, -9586, 0, 0, 33873, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 22014, -248713, -9586, 0, 0, 23939, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 23027, -246387, -9586, 0, 0, 36465, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 23377, -248343, -9586, 0, 0, 19040, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 23386, -243723, -9586, 0, 0, 63200, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21165, 23403, -245740, -9586, 0, 0, 17424, 120, 0, 0, 0),
-- Lilim Great Magus
("CatacombOfTheForbiddenPath", 1, 21185, 12934, -247316, -9586, 0, 0, 61706, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 12945, -243693, -9584, 0, 0, 1998, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 13332, -245977, -9586, 0, 0, 13326, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 13533, -247160, -9586, 0, 0, 32768, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 13735, -246948, -9584, 0, 0, 54566, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 13824, -245636, -9584, 0, 0, 27932, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 14422, -245797, -9584, 0, 0, 62921, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 15761, -244273, -9586, 0, 0, 49152, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 16100, -243994, -9586, 0, 0, 45932, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 16203, -248339, -9584, 0, 0, 27756, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 16386, -247925, -9584, 0, 0, 39300, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 16679, -246051, -9584, 0, 0, 41032, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 17315, -246202, -9586, 0, 0, 46959, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 17448, -248597, -9586, 0, 0, 58229, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21185, 17601, -244057, -9584, 0, 0, 27202, 120, 0, 0, 0),
-- Lilim Guard Knight
("CatacombOfTheForbiddenPath", 1, 21186, 18491, -246948, -9586, 0, 0, 10279, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 18662, -243726, -9584, 0, 0, 30519, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 18788, -248657, -9586, 0, 0, 15012, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 18848, -246608, -9586, 0, 0, 7980, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 19567, -248405, -9584, 0, 0, 17289, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 20466, -246148, -9586, 0, 0, 25426, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 20586, -245086, -9586, 0, 0, 13685, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 20626, -243858, -9584, 0, 0, 31017, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 20707, -246571, -9584, 0, 0, 46005, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 20948, -248646, -9586, 0, 0, 24342, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 21639, -248545, -9584, 0, 0, 22361, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 21664, -244065, -9586, 0, 0, 29053, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 23092, -248625, -9586, 0, 0, 21657, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 23103, -245933, -9586, 0, 0, 23058, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 23117, -244060, -9586, 0, 0, 40685, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21186, 23434, -246636, -9586, 0, 0, 29202, 120, 0, 0, 0),
-- Nephilim Cardinal
("CatacombOfTheForbiddenPath", 1, 21206, 12957, -245884, -9607, 0, 0, 3578, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 13243, -243874, -9584, 0, 0, 64485, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 13324, -246836, -9586, 0, 0, 24695, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 13805, -247319, -9586, 0, 0, 46325, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 13822, -245284, -9586, 0, 0, 16299, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 14248, -246769, -9586, 0, 0, 43515, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 14348, -245511, -9586, 0, 0, 1969, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 15782, -245059, -9586, 0, 0, 9525, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 16136, -244648, -9586, 0, 0, 65405, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 16156, -248058, -9586, 0, 0, 32267, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 16468, -248547, -9586, 0, 0, 22070, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 16501, -245882, -9586, 0, 0, 35902, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 16864, -246272, -9586, 0, 0, 52800, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 17640, -248345, -9584, 0, 0, 13482, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21206, 17813, -243887, -9584, 0, 0, 183, 120, 0, 0, 0),
-- Nephilim Commander
("CatacombOfTheForbiddenPath", 1, 21207, 18446, -248631, -9586, 0, 0, 18940, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 18479, -246319, -9586, 0, 0, 801, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 18717, -246006, -9584, 0, 0, 15370, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 18835, -243874, -9584, 0, 0, 6204, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 19585, -248612, -9586, 0, 0, 22427, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 20342, -245880, -9586, 0, 0, 34225, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 20811, -244086, -9586, 0, 0, 36650, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 20873, -246459, -9586, 0, 0, 48374, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 20915, -245282, -9586, 0, 0, 5637, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 20988, -248353, -9586, 0, 0, 61173, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 21309, -243632, -9586, 0, 0, 37535, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 21504, -248348, -9586, 0, 0, 22651, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 23104, -248387, -9584, 0, 0, 15599, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 23137, -246634, -9586, 0, 0, 11770, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 23326, -244043, -9584, 0, 0, 44471, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21207, 23338, -245890, -9584, 0, 0, 4663, 120, 0, 0, 0),
-- Tomb Guard
("CatacombOfTheForbiddenPath", 1, 21254, 12957, -245553, -9586, 0, 0, 12703, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 13011, -244023, -9584, 0, 0, 55816, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 13073, -247168, -9586, 0, 0, 50365, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 13715, -245934, -9586, 0, 0, 62264, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 13828, -247053, -9584, 0, 0, 57691, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 14102, -245687, -9584, 0, 0, 5967, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 14300, -246955, -9584, 0, 0, 37856, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 15715, -244647, -9586, 0, 0, 18770, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 16128, -244397, -9586, 0, 0, 37679, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 16282, -248542, -9584, 0, 0, 24123, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 16397, -246114, -9584, 0, 0, 30949, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 16402, -247764, -9586, 0, 0, 23008, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 17389, -243869, -9584, 0, 0, 33922, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 17422, -245759, -9586, 0, 0, 34722, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21254, 17444, -248354, -9586, 0, 0, 20699, 120, 0, 0, 0),
-- Tomb Preacher
("CatacombOfTheForbiddenPath", 1, 21255, 18427, -243849, -9584, 0, 0, 38057, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 18466, -246591, -9586, 0, 0, 58757, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 18762, -248411, -9584, 0, 0, 21491, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 18790, -246223, -9586, 0, 0, 21655, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 19841, -248304, -9586, 0, 0, 27424, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 20504, -243694, -9586, 0, 0, 51304, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 20747, -245532, -9584, 0, 0, 46243, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 20807, -244985, -9584, 0, 0, 8375, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 20937, -245969, -9586, 0, 0, 57544, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 21169, -244047, -9586, 0, 0, 19219, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 21456, -248715, -9586, 0, 0, 12161, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 21957, -248374, -9586, 0, 0, 37642, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 23042, -243749, -9586, 0, 0, 50265, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 23043, -246196, -9586, 0, 0, 36803, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 23138, -245686, -9586, 0, 0, 25395, 120, 0, 0, 0),
("CatacombOfTheForbiddenPath", 1, 21255, 23403, -248641, -9586, 0, 0, 20584, 120, 0, 0, 0),
-- Gatekeeper Ziggurat
("ssq12_npc2320_01", 1, 31125, 12944, -248480, -9577, 0, 0, 0, 60, 0, 0, 0),
-- Dimensional Gate Keeper
("ssq12_npc2320_03", 1, 31507, 12715, -248777, -9607, 0, 0, 16000, 60, 0, 0, 0),

-- [20_13]

-- Greystone Golem
("Orc_Village", 1, 20333, 8783, -137084, -968, 0, 0, 55865, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 8145, -137155, -856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 7380, -135325, -784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 5720, -132618, -2880, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 2486, -132048, -3232, 0, 0, 48875, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 2948, -132618, -3136, 0, 0, 31402, 21, 0, 0, 0),
("Orc_Village", 1, 20333, 2024, -132390, -3224, 0, 0, 0, 21, 0, 0, 0),
-- Maraku Werewolf Chieftain
("Orc_Village", 1, 20364, 16164, -135909, -1056, 0, 0, 16257, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 14384, -136226, -1432, 0, 0, 48961, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 17092, -135969, -960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 10260, -133449, -1592, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 10998, -134384, -1424, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 6857, -137770, -680, 0, 0, 32057, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 6870, -137155, -648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 7125, -136240, -704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 8030, -132276, -2760, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 10998, -132327, -1704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 5258, -131478, -3160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 1100, -131706, -3304, 0, 0, 33679, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 1562, -131934, -3312, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye Patroller
("Orc_Village", 1, 20428, 10752, -134571, -1432, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 10014, -134197, -1424, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 9034, -135408, -1032, 0, 0, 39649, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 8145, -136606, -864, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 7380, -135508, -776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 2486, -133302, -3168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 638, -133530, -3208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 10260, -132514, -1752, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 8954, -131820, -2456, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 3410, -131592, -3256, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Spider
("Orc_Village", 1, 20474, 12720, -131766, -1416, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 10998, -134758, -1352, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 14013, -140250, -1872, 0, 0, 27423, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 14465, -139628, -1576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 10363, -140515, -1872, 0, 0, 58798, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 10926, -142376, -1872, 0, 0, 52885, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 11982, -131953, -1512, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Fang Spider
("Orc_Village", 1, 20476, 21274, -131908, -1584, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 19650, -131568, -1712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 16532, -136140, -960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 16812, -135285, -1080, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 15578, -135531, -1208, 0, 0, 38014, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 10462, -139935, -1872, 0, 0, 21278, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 11139, -140855, -1800, 0, 0, 2180, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 10561, -140878, -1840, 0, 0, 16514, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 10867, -141357, -1872, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Blade Spider
("Orc_Village", 1, 20478, 22289, -131704, -1616, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 18838, -131568, -1712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 13045, -138937, -1872, 0, 0, 45088, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 11892, -140626, -1872, 0, 0, 45616, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 10874, -142074, -1872, 0, 0, 63645, 21, 0, 0, 0),
-- Kasha Bear
("Orc_Village", 1, 20479, 21477, -131840, -1616, 0, 0, 59372, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 21274, -132180, -1576, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 21071, -132180, -1632, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 15972, -134943, -1272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 15132, -136311, -1208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 14770, -136152, -1400, 0, 0, 48320, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 12015, -140472, -1872, 0, 0, 16146, 21, 0, 0, 0),
-- Rosheek
("Orc_Village_Npc", 1, 30590, 12432, -141808, -1877, 0, 0, 16384, 60, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, 12155, -134292, -1184, 0, 0, 58775, 60, 0, 0, 0),

-- [20_14]

-- Ghost Guardian
("lyonn05_2014_14", 1, 20329, 21306, -111396, -3296, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20329, 21844, -111725, -3344, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20329, 22640, -112121, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20329, 23395, -115183, -3412, 0, 0, 60138, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20329, 22308, -119712, -3292, 0, 0, 28672, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20329, 22973, -119859, -3292, 0, 0, 1675, 68, 0, 0, 0),
-- Slave Skeleton
("lyonn05_2014_34", 1, 20340, 13488, -109896, -3484, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 12824, -110048, -3448, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 13056, -110600, -3481, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 14284, -110622, -3392, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 14929, -111182, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 14999, -114519, -3321, 0, 0, 23577, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 14496, -115514, -3396, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 15217, -116877, -3232, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 15937, -118260, -3248, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 17089, -114993, -3160, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 16427, -114895, -3168, 0, 0, 56795, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20340, 16795, -113951, -3115, 0, 0, 65166, 68, 0, 0, 0),
-- Undead Slave
("lyonn05_2014_11", 1, 20341, 20988, -110176, -3352, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21250, -109529, -3292, 0, 0, 6800, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21740, -110558, -3340, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 22138, -107994, -3072, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21897, -107729, -3084, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21753, -107511, -3068, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21292, -107611, -3088, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21120, -107722, -3076, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 20844, -108155, -3076, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21290, -108382, -3056, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21478, -108341, -3016, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 22031, -117770, -3292, 0, 0, 54461, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 22459, -118984, -3332, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 23642, -118462, -3428, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 23640, -116010, -3412, 0, 0, 49889, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 21675, -120434, -3289, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20341, 22543, -120069, -3292, 0, 0, 45209, 68, 0, 0, 0),
-- Maraku Werewolf Chieftain
("Orc_Village", 1, 20364, 14612, -129980, -1128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 9782, -129627, -2272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 9584, -129896, -2312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 10748, -129257, -1928, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 12128, -129016, -1472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 13508, -127811, -1400, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 14336, -127570, -1432, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 7964, -126300, -2344, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 6200, -125998, -2656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 5818, -129186, -3056, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 4534, -129186, -3288, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 5604, -128996, -3072, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 5318, -127206, -3008, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 5318, -127810, -3032, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 4730, -125696, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 8000, -129627, -2832, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 7010, -130165, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 6812, -130165, -2992, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20364, 3464, -127856, -3088, 0, 0, 0, 21, 0, 0, 0),
-- Grave Keeper
("lyonn05_2014_05", 1, 20368, 15003, -114806, -3321, 0, 0, 48933, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 18710, -113141, -3280, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 19070, -113690, -3236, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 16776, -109270, -3040, 0, 0, 14604, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 16723, -109699, -3040, 0, 0, 63760, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 13488, -110252, -3484, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 12962, -110450, -3481, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 14559, -110648, -3346, 0, 0, 62633, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 14929, -111538, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 14868, -114733, -3320, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 15000, -115692, -3396, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 17332, -114481, -3104, 0, 0, 60503, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 17120, -114809, -3117, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20368, 16445, -113970, -3115, 0, 0, 33070, 68, 0, 0, 0),
-- Varangka's Guard
("lyonn05_2014_17", 1, 20374, 23393, -111610, -3343, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_17", 1, 20374, 23756, -110277, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_17", 1, 20374, 23455, -110455, -3384, 0, 0, 0, 68, 0, 0, 0),
-- Varangka's Escort
("lyonn05_2014_17", 1, 20375, 23212, -111605, -3339, 0, 0, 10753, 68, 0, 0, 0),
("lyonn05_2014_17", 1, 20375, 23354, -110633, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_17", 1, 20375, 23354, -110277, -3384, 0, 0, 0, 68, 0, 0, 0),
-- Scarlet Salamander
("lyonn05_2014_01", 1, 20415, 16007, -112618, -3138, 0, 0, 17217, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20415, 16725, -112156, -3138, 0, 0, 5062, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20415, 17359, -112670, -3138, 0, 0, 54975, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20415, 16409, -112974, -3260, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20415, 21100, -115860, -3292, 0, 0, 60856, 68, 0, 0, 0),
-- Scarlet Salamander Elder
("lyonn05_2014_01", 1, 20416, 16197, -112312, -3188, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20416, 16595, -112612, -3196, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20416, 17137, -112208, -3138, 0, 0, 21557, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20416, 16610, -112974, -3260, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20416, 21452, -116219, -3344, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_01", 1, 20416, 21754, -116041, -3344, 0, 0, 0, 68, 0, 0, 0),
-- Evil Eye Watcher
("lyonn05_2014_34", 1, 20427, 12884, -110252, -3484, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 13189, -110847, -3481, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 13982, -110800, -3392, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 14828, -111716, -3384, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 14972, -115184, -3321, 0, 0, 51549, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 15009, -115656, -3321, 0, 0, 31329, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 17282, -115023, -3115, 0, 0, 41364, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 16675, -114896, -3135, 0, 0, 30906, 68, 0, 0, 0),
("lyonn05_2014_34", 1, 20427, 16184, -113944, -3115, 0, 0, 36262, 68, 0, 0, 0),
-- Evil Eye Patroller
("Orc_Village", 1, 20428, 8396, -129627, -2736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 9980, -129358, -2208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 9188, -128013, -2368, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 8990, -128013, -2472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 5176, -130326, -3312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 4320, -127856, -3144, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 4748, -128236, -3112, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20428, 3892, -130516, -3336, 0, 0, 0, 21, 0, 0, 0),
-- Evil Eye Lookout
("lyonn05_2014_05", 1, 20429, 18535, -112800, -3228, 0, 0, 18617, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 18880, -113700, -3280, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 16518, -109108, -3080, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 16707, -110038, -3025, 0, 0, 31120, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 16245, -120101, -3200, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 16447, -119745, -3200, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 17067, -120575, -3196, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 18481, -120614, -3144, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 19358, -120406, -3160, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 19646, -119469, -3161, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20429, 19074, -119079, -3200, 0, 0, 0, 68, 0, 0, 0),
-- Kasha Spider
("Orc_Village", 1, 20474, 14612, -130703, -1128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 8594, -130703, -2592, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 14060, -129257, -1272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 13025, -130739, -1264, 0, 0, 51699, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 12128, -128293, -1552, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 8990, -128013, -2472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 13508, -127329, -1328, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 10748, -126606, -1848, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 7082, -125394, -2384, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 7406, -128820, -2904, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 6032, -129376, -3032, 0, 0, 52162, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 5604, -129376, -3104, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 4962, -130326, -3336, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 5024, -126300, -2960, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 6460, -130706, -3088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 7406, -129627, -2936, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 2999, -125590, -3272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 3554, -126602, -3168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 4436, -124790, -2832, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 5069, -123929, -2600, 0, 0, 57345, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 2379, -121490, -2712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20474, 2224, -120260, -2720, 0, 0, 0, 21, 0, 0, 0);
INSERT INTO `spawnlist` VALUES
("Orc_Village", 1, 20474, 1449, -122310, -2872, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Fang Spider
("Orc_Village", 1, 20476, 21269, -122202, -648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 22265, -122640, -584, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 21020, -120888, -584, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 23173, -124463, -688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 22814, -123091, -640, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 23891, -124463, -688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 24704, -124153, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 25686, -125149, -680, 0, 0, 20338, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 26944, -124965, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 28199, -124806, -704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 21628, -129994, -1680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 19996, -130786, -1680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 14478, -125769, -1160, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 13068, -123859, -1264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 10812, -125960, -1832, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 11940, -123477, -1304, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 8328, -123436, -1992, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 8708, -122380, -1752, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 9088, -121324, -1656, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 7948, -124492, -2176, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 6808, -122116, -2008, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 7188, -121588, -1856, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 2534, -123130, -2784, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 2224, -122720, -2768, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 1449, -123130, -2968, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20476, 829, -123950, -3064, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Blade Spider
("Orc_Village", 1, 20478, 20273, -121180, -736, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 21020, -120304, -472, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 20771, -120450, -568, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 24968, -126864, -704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 25327, -125149, -696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 26144, -126589, -680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 26404, -125149, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 27481, -124120, -728, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 26763, -124806, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 26763, -126521, -704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 26944, -125574, -704, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 21832, -130885, -1672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 19588, -129697, -1672, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 11237, -129244, -1744, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 12365, -129506, -1384, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 12724, -129212, -1344, 0, 0, 17942, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 14196, -126533, -1208, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 13068, -125387, -1264, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 12786, -124050, -1272, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 11940, -123095, -1304, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 9468, -122644, -1648, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 10228, -122644, -1568, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 6378, -124932, -2544, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 7948, -121852, -1800, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 5673, -125800, -2728, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 5532, -124560, -2616, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 5411, -123470, -2480, 0, 0, 62689, 21, 0, 0, 0),
("Orc_Village", 1, 20478, 5668, -121852, -2152, 0, 0, 0, 21, 0, 0, 0),
-- Kasha Bear
("Orc_Village", 1, 20479, 21518, -121618, -568, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 22514, -121618, -640, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 23012, -121764, -680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 23173, -122748, -680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 23881, -124428, -688, 0, 0, 19231, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 25327, -124806, -680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 25184, -124965, -696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 25504, -125777, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 26449, -124519, -712, 0, 0, 56211, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 26404, -127207, -688, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 27481, -125149, -712, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 26944, -124762, -720, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 21628, -129202, -1696, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 21016, -130192, -1680, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 19744, -129651, -1672, 0, 0, 41612, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 14888, -129498, -1200, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 11576, -130703, -1568, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 11852, -129257, -1528, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 11576, -129257, -1624, 0, 0, 41785, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 12413, -129498, -1384, 0, 0, 49542, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 11852, -128052, -1592, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 12786, -125196, -1312, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 12786, -123668, -1280, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 10530, -125005, -1776, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 12222, -123859, -1328, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 9088, -123700, -1840, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 8328, -124492, -2168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 8328, -122116, -1800, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 7376, -127206, -2640, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 6788, -127508, -2760, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 5612, -126904, -2936, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 5318, -126602, -2952, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 1759, -126410, -3248, 0, 0, 43195, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 3848, -125998, -3128, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 2844, -123950, -2984, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 6048, -121852, -2088, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 4148, -122380, -2432, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 2844, -121080, -2632, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 1604, -124770, -3168, 0, 0, 0, 21, 0, 0, 0),
("Orc_Village", 1, 20479, 1294, -121080, -2840, 0, 0, 0, 21, 0, 0, 0),
-- Kuruka Ratman
("lyonn05_2014_06", 1, 20487, 19649, -111558, -3268, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 20227, -112141, -3232, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 19930, -113323, -3272, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 18383, -108269, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 18324, -109831, -3044, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 19055, -117646, -3176, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20487, 17255, -116711, -3160, 0, 0, 0, 68, 0, 0, 0),
-- Kuruka Ratman Hunter
("lyonn05_2014_06", 1, 20488, 19548, -111380, -3268, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 19807, -112142, -3272, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 19859, -113077, -3228, 0, 0, 8887, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 19881, -110684, -3328, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 19225, -107812, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 18182, -108269, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 18381, -108642, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_06", 1, 20488, 18557, -109839, -3072, 0, 0, 0, 68, 0, 0, 0),
-- Quicksilver Beast
("lyonn05_2014_05", 1, 20489, 18527, -112537, -3228, 0, 0, 64838, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 19446, -111982, -3233, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 19908, -112676, -3272, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 19753, -113304, -3228, 0, 0, 50373, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 19283, -113344, -3280, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 18213, -120374, -3192, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_05", 1, 20489, 19330, -117987, -3136, 0, 0, 0, 68, 0, 0, 0),
-- Crypt Horror
("lyonn05_2014_28", 1, 20491, 18225, -108440, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 18423, -110024, -3040, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 16418, -109286, -3080, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 16707, -110678, -3044, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 16485, -110226, -3034, 0, 0, 62892, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 14491, -109929, -3416, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_28", 1, 20491, 20546, -115050, -3292, 0, 0, 21087, 68, 0, 0, 0),
-- Skeleton Longbowman
("lyonn05_2014_11", 1, 20542, 21324, -110922, -3292, 0, 0, 59263, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 20984, -109827, -3328, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21740, -110914, -3340, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21635, -108172, -3072, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21696, -107729, -3084, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21451, -107689, -3068, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 19171, -107435, -3040, 0, 0, 31668, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 20818, -107900, -3076, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 20849, -108087, -3008, 0, 0, 61567, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21182, -108448, -3003, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_11", 1, 20542, 21711, -108400, -3000, 0, 0, 0, 68, 0, 0, 0),
-- Ghost
("lyonn05_2014_14", 1, 20543, 21290, -111310, -3288, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20543, 22080, -112159, -3300, 0, 0, 0, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20543, 22474, -112201, -3339, 0, 0, 52079, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20543, 23765, -115560, -3398, 0, 0, 16510, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20543, 23795, -114718, -3412, 0, 0, 15301, 68, 0, 0, 0),
("lyonn05_2014_14", 1, 20543, 22041, -120251, -3292, 0, 0, 35891, 68, 0, 0, 0),
-- Ragna Orc Overlord
("Orc_Village", 1, 20778, 11777, -106414, -3544, 0, 0, 19074, 180, 0, 0, 0),
("Orc_Village", 1, 20778, 11530, -107034, -3504, 0, 0, 28915, 180, 0, 0, 0),
-- Ragna Orc Priest
("Orc_Village", 1, 20779, 11474, -105852, -3552, 0, 0, 723, 180, 0, 0, 0),
("Orc_Village", 1, 20779, 11424, -106324, -3544, 0, 0, 32398, 180, 0, 0, 0),
-- Kasha Imp
("Orc_Village", 1, 21117, 6864, -113135, -1736, 0, 0, 15277, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 6131, -110268, -1840, 0, 0, 39019, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 6954, -116040, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 7163, -115810, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 7888, -118374, -1784, 0, 0, 21705, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 8432, -118133, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 8432, -120061, -1816, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 8432, -119097, -1784, 0, 0, 37372, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 6528, -118856, -1832, 0, 0, 28354, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 1520, -117721, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 922, -116786, -2384, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 2417, -118282, -2688, 0, 0, 64827, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 2716, -116973, -2368, 0, 0, 30266, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 6005, -117721, -1920, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 5753, -112653, -1776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 5909, -114660, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 4652, -111117, -2040, 0, 0, 36613, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 4216, -111034, -2088, 0, 0, 47718, 20, 0, 0, 0),
("Orc_Village", 1, 21117, 5590, -109949, -2000, 0, 0, 25393, 20, 0, 0, 0),
-- Baar Dre Vanul
("Orc_Village", 1, 21118, 6949, -109439, -1760, 0, 0, 51254, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 8432, -116928, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 7888, -119097, -1784, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 7344, -118856, -1792, 0, 0, 33104, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 922, -116973, -2408, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 2716, -118095, -2616, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5407, -118469, -2088, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 4510, -118095, -2352, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5984, -118615, -1928, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 4446, -115120, -2064, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5073, -113970, -1840, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 6118, -114430, -1736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5909, -114200, -1736, 0, 0, 16662, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5876, -111786, -1808, 0, 0, 44468, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 4585, -112047, -2088, 0, 0, 21974, 20, 0, 0, 0),
("Orc_Village", 1, 21118, 5505, -109793, -2040, 0, 0, 12720, 20, 0, 0, 0),
-- Hobgoblin
("Orc_Village", 1, 21119, 2190, -109912, -2376, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1465, -108912, -2680, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 3548, -103435, -2232, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1792, -106356, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1874, -104743, -2480, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1037, -106051, -2648, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 2915, -106272, -2648, 0, 0, 5030, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1874, -108013, -2752, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 1316, -108340, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 305, -108512, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21119, 3668, -108032, -2616, 0, 0, 1530, 20, 0, 0, 0),
-- Kasha Imp Turen
("Orc_Village", 1, 21120, 450, -110912, -2488, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 1465, -110912, -2344, 0, 0, 20958, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 1610, -109712, -2488, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 1047, -103815, -2424, 0, 0, 51124, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 2874, -103546, -2296, 0, 0, 59301, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 3397, -103791, -2336, 0, 0, 63213, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 758, -105724, -2624, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 758, -106378, -2688, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21120, 479, -107032, -2736, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Dire Wolf
("Orc_Village", 1, 21121, 1175, -109312, -2648, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1610, -109712, -2488, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1465, -109112, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1568, -100296, -1880, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 602, -98791, -1968, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 924, -101371, -1928, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3744, -101876, -1896, 0, 0, 7819, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2051, -99651, -1896, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3548, -104089, -2408, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3641, -106483, -2672, 0, 0, 38135, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 758, -107032, -2736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1874, -107686, -2736, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 4995, -106698, -2736, 0, 0, 41991, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 4168, -106456, -2688, 0, 0, 29163, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 8900, -101717, -2320, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 6568, -101081, -2128, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 7267, -100572, -2064, 0, 0, 25269, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 6278, -100003, -1992, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 9254, -99497, -2168, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 5635, -101305, -2096, 0, 0, 63288, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 5345, -101573, -2096, 0, 0, 57063, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 5513, -98853, -1864, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 4901, -98738, -1856, 0, 0, 0, 20, 0, 0, 0),
-- Kasha Bugbear
("Orc_Village", 1, 21122, 602, -99436, -1960, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2271, -101090, -1808, 0, 0, 29085, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1792, -102141, -1968, 0, 0, 30565, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 602, -102016, -2008, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3910, -101509, -1840, 0, 0, 13928, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2343, -100128, -1856, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3178, -100081, -1720, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5120, -103261, -2344, 0, 0, 13055, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 4779, -103022, -2232, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5430, -103709, -2448, 0, 0, 7765, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5241, -103076, -2344, 0, 0, 13150, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 7431, -102105, -2376, 0, 0, 61761, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 9990, -100477, -2216, 0, 0, 43946, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 9873, -100708, -2224, 0, 0, 56427, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 9431, -99127, -2176, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5215, -101776, -2088, 0, 0, 46493, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5513, -99773, -1976, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 5054, -98853, -1872, 0, 0, 0, 20, 0, 0, 0),
-- Baar Dre Vanul Destroyer
("Orc_Village", 1, 21123, 441, -100081, -1960, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2868, -101003, -1768, 0, 0, 30470, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3677, -100118, -1760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2373, -98791, -1864, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 5907, -103133, -2424, 0, 0, 27383, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 6810, -102846, -2480, 0, 0, 11451, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 6568, -102213, -2360, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 6479, -100917, -2096, 0, 0, 62593, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 9011, -100726, -2168, 0, 0, 50885, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 9077, -99127, -2136, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 8192, -98942, -1864, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 5666, -99773, -1992, 0, 0, 36459, 20, 0, 0, 0),
-- Evil Eye Seer
("Orc_Village", 1, 21257, 7565, -114511, -1736, 0, 0, 19739, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 6780, -113751, -1736, 0, 0, 42630, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 6403, -111103, -1736, 0, 0, 34827, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 6353, -111904, -1744, 0, 0, 15927, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 6940, -109102, -1776, 0, 0, 29499, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 10608, -119579, -1736, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 8432, -119338, -1800, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 8976, -119820, -1720, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 8160, -119338, -1792, 0, 0, 55473, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 3912, -119217, -2504, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 922, -118282, -2608, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 1819, -117908, -2584, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 922, -117347, -2472, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 5282, -116500, -1888, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 4237, -113280, -2072, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village", 1, 21257, 4518, -112350, -2088, 0, 0, 0, 60, 0, 0, 0),
-- Varangka's Messenger
("Orc_Village", 1, 27041, 16576, -118592, -760, 0, 0, 0, 300, 0, 0, 0),
-- Orc Escort
("Orc_Village", 1, 27042, 16591, -118669, -752, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 27042, 16582, -118600, -760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 27042, 16519, -118510, -768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 27042, 16447, -118523, -768, 0, 0, 0, 20, 0, 0, 0),
-- Evil Eye Lord
("Orc_Village_Npc", 1, 27133, 16156, -119917, -3168, 0, 0, 0, 180, 0, 0, 0),
-- Ancestor Martankus
("Orc_Village_Npc", 1, 30649, 21420, -107787, -2926, 0, 0, 30893, 60, 0, 0, 0),
-- Dubabah
("Orc_Village_Npc", 1, 30672, 19092, -117187, -3136, 0, 0, 32768, 60, 0, 0, 0),
-- Corpse Of Kamur
("Orc_Village_Npc", 1, 30675, 19412, -118142, -3136, 0, 0, 0, 60, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, 8193, -122361, -1864, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, 6240, -101131, -2136, 0, 0, 18479, 60, 0, 0, 0),
-- Aren
("Valley of Lords", 1, 32056, 26828, -125028, -712, 0, 0, 23536, 60, 0, 0, 0),

-- [20_15]

-- Ragna Orc Overlord
("Orc_Village", 1, 20778, 9356, -90304, -2792, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20778, 10292, -90760, -2864, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20778, 10500, -90988, -2856, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20778, 10604, -90532, -2872, 0, 0, 0, 180, 0, 0, 0),
-- Ragna Orc Priest
("Orc_Village", 1, 20779, 9564, -90532, -2856, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20779, 10084, -91672, -2856, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20779, 9356, -89848, -2736, 0, 0, 0, 180, 0, 0, 0),
("Orc_Village", 1, 20779, 10812, -91216, -2824, 0, 0, 0, 180, 0, 0, 0),
-- Kasha Dire Wolf
("Orc_Village", 1, 21121, 329, -77090, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1841, -78175, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1085, -77307, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2030, -76439, -2112, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1276, -74916, -1784, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1976, -75696, -1904, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2396, -74786, -1848, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1144, -80893, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1059, -81026, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 624, -82886, -2568, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 784, -82402, -2608, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3986, -83649, -2400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3380, -83838, -2528, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1720, -85832, -2264, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1114, -84392, -2256, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 486, -88838, -1952, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2917, -89242, -1832, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3478, -89242, -1816, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2768, -91917, -3120, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 13430, -93854, -2792, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 12812, -93206, -2712, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 12400, -91910, -2488, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 14048, -92072, -2584, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 12415, -94352, -2712, 0, 0, 60763, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 15516, -95736, -2624, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 12916, -96532, -2776, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 16036, -96731, -2696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 504, -96656, -1904, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 340, -96953, -1912, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 1466, -95198, -3008, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 3128, -97844, -1912, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21121, 2892, -92904, -3144, 0, 0, 4155, 20, 0, 0, 0),
-- Kasha Bugbear
("Orc_Village", 1, 21122, 1841, -79694, -2392, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1463, -79477, -2376, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 329, -77524, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 329, -77741, -2232, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1556, -74136, -1856, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1399, -81159, -2672, 0, 0, 34713, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1059, -81026, -2656, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 944, -82523, -2592, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 224, -82523, -2720, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3582, -82704, -2400, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2774, -83460, -2592, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2774, -82137, -2576, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 205, -87272, -1984, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 407, -86152, -2136, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2169, -87828, -2104, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3104, -88636, -1856, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3478, -89040, -1800, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 12194, -91586, -2432, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 11164, -92558, -2784, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 12606, -94178, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 12916, -95338, -2696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 14216, -96134, -2776, 0, 0, 36724, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 14460, -93206, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 14736, -95537, -2720, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 16036, -96532, -2640, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1816, -97844, -1904, 0, 0, 52891, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1816, -97547, -1920, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 1466, -94426, -3144, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 2800, -97349, -2016, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3159, -92397, -3152, 0, 0, 14329, 20, 0, 0, 0),
("Orc_Village", 1, 21122, 3042, -93189, -3152, 0, 0, 41804, 20, 0, 0, 0),
-- Baar Dre Vanul Destroyer
("Orc_Village", 1, 21123, 2030, -79477, -2304, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1841, -77090, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3542, -78826, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2597, -78609, -2224, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2676, -74526, -1872, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 889, -80361, -2632, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 549, -81691, -2728, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 464, -82402, -2672, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 864, -83370, -2544, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3582, -82893, -2416, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3986, -82515, -2144, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3077, -83838, -2560, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1518, -85352, -2264, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1518, -85032, -2280, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1922, -86472, -2232, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 673, -87626, -1968, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2356, -87626, -2136, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2356, -89848, -2088, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 11988, -93368, -2768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 11782, -93854, -2744, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 13018, -93530, -2760, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 13956, -94343, -2808, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 12656, -95338, -2696, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 14085, -96184, -2776, 0, 0, 51069, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 15256, -95139, -2744, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 14553, -96288, -2768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 13176, -96930, -2768, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 668, -97250, -1944, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 340, -98042, -1992, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1060, -94192, -3144, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 1094, -93268, -3136, 0, 0, 10932, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 536, -93654, -3152, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 350, -93075, -3096, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 3732, -97816, -1872, 0, 0, 0, 20, 0, 0, 0),
("Orc_Village", 1, 21123, 2854, -94325, -2976, 0, 0, 0, 20, 0, 0, 0),
-- Centurion
("Orc_Village_Npc", 1, 31036, 2844, -81857, -2552, 0, 0, 17746, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, 13479, -94376, -2832, 0, 0, 0, 60, 0, 0, 0),
("Orc_Village_Npc", 1, 31036, 2037, -94506, -3144, 0, 0, 0, 60, 0, 0, 0),

-- [20_16]

-- Worshipper
("unset", 1, 4327, 28006, -49397, -1319, 0, 0, 15229, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, 27875, -49312, -1317, 0, 0, 52676, 0, 0, 0, 0),
("unset", 1, 4328, 28150, -49302, -1320, 0, 0, 6133, 0, 0, 0, 0),
-- Gods' Altar
("RuneArtefact1", 1, 35469, 9132, -49152, 1088, 0, 0, 0, 60, 0, 0, 0),
-- Mass Gatekeeper
("rune_mass_gatekeeper", 1, 35502, 11127, -49148, 3843, 0, 0, 18512, 60, 0, 0, 0),
-- Outer Doorman
("rune_chamberlain_etc", 1, 35503, 18616, -48956, -1216, 0, 0, 0, 60, 0, 0, 0),
("rune_chamberlain_etc", 1, 35503, 17908, -48960, -1200, 0, 0, 33000, 60, 0, 0, 0),
-- Inner Doorman
("rune_chamberlain_etc", 1, 35504, 15688, -49036, -1056, 0, 0, 33000, 60, 0, 0, 0),
("rune_chamberlain_etc", 1, 35504, 15860, -49020, -1056, 0, 0, 0, 60, 0, 0, 0),
-- Inner Doorman
("rune_chamberlain_etc", 1, 35505, 12780, -51060, -1088, 0, 0, 0, 60, 0, 0, 0),
("rune_chamberlain_etc", 1, 35505, 12736, -51184, -1088, 0, 0, 49000, 60, 0, 0, 0),
-- Dungeon Gatekeeper
("rune03_npc2016_18", 1, 35506, 11532, -49136, -1087, 0, 0, 0, 60, 0, 0, 0),
-- Blacksmith
("rune_blacksmith", 1, 35507, 12872, -48752, -1088, 0, 0, 33000, 60, 0, 0, 0),
-- Warehouse Keeper
("rune_warehouse", 1, 35508, 12864, -49184, -1088, 0, 0, 39746, 60, 0, 0, 0),
-- Frederick
("rune_chamberlain_etc", 1, 35509, 10211, -49084, -307, 0, 0, 36736, 60, 0, 0, 0),
-- Titus
("rune_chamberlain_etc", 1, 35510, 12318, -47703, 1296, 0, 0, 22879, 60, 0, 0, 0),
-- Gompus
("rune_chamberlain_etc", 1, 35511, 10840, -49273, -565, 0, 0, 2366, 60, 0, 0, 0),
-- Sherman
("rune_castle_npc", 1, 35513, 26976, -48968, -1296, 0, 0, 0, 120, 0, 0, 0),
-- Court Magician
("Rune_castle", 1, 35655, 10280, -48766, -546, 0, 0, 182, 60, 0, 0, 0),
-- Warden
("Rune_castle", 1, 36410, 11534, -48907, -1088, 0, 0, 0, 60, 0, 0, 0),

-- [20_17]

-- Worshipper
("unset", 1, 4327, 10812, -24193, -3644, 0, 0, 5844, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, 10823, -24045, -3644, 0, 0, 10305, 0, 0, 0, 0),
("unset", 1, 4328, 10964, -24256, -3644, 0, 0, 767, 0, 0, 0, 0),
-- Ancient Egg
("primeval_isle", 1, 18344, 14166, -17484, -3080, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 16736, -16956, -3224, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 15620, -16016, -3192, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 15120, -14388, -3168, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 19692, -20050, -3280, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 20152, -18138, -3192, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 19776, -15772, -3080, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 21041, -18281, -3152, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 22580, -20164, -2608, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 23364, -16019, -3000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 25429, -18906, -2608, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 25856, -16560, -2728, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 26928, -19264, -2360, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 27626, -17214, -2616, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 27714, -15192, -2616, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 25460, -11611, -2504, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 26764, -11673, -2440, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 22088, -13789, -3160, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 21762, -13789, -3136, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 21442, -10724, -2816, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 18309, -11008, -2864, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 14581, -9014, -3240, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18344, 15132, -12764, -3136, 0, 0, 0, 60, 0, 0, 0),
-- Sprigant
("primeval_isle", 1, 18345, 14754, -19035, -3160, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 15776, -18796, -3200, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 16870, -15128, -3184, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 20291, -19814, -3304, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 18836, -17822, -3208, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 19776, -15772, -3080, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 19828, -20535, -3160, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 21396, -17228, -2984, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 23092, -20888, -2632, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 24092, -18191, -2728, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 23068, -14990, -3040, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 25856, -16451, -2720, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 26742, -15692, -2648, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 25534, -13774, -2560, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 26149, -13010, -2568, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 22522, -12423, -2584, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 20784, -14098, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 20800, -11608, -2800, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 20481, -9820, -2864, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 20300, -8632, -2728, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 14798, -9839, -3280, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 15015, -9839, -3280, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 16144, -13360, -3176, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18345, 14620, -14092, -3200, 0, 0, 0, 60, 0, 0, 0),
-- Sprigant
("primeval_isle", 1, 18346, 14816, -16588, -3144, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 18060, -19662, -3264, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 17708, -17348, -3216, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 16120, -14536, -3152, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 20916, -18719, -3248, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 21936, -17592, -2952, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 23348, -21431, -2544, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 22088, -14407, -3096, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 21396, -15226, -3056, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 22328, -16166, -2984, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 25561, -17650, -2760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 24665, -18334, -2712, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 26842, -18800, -2504, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 27331, -16887, -2656, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 28200, -15092, -2544, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 27714, -15792, -2672, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 25329, -12819, -2552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 26149, -12819, -2560, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 23368, -10282, -2632, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 22726, -10503, -2704, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 25912, -11002, -2472, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 20784, -14201, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 18852, -12196, -2760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 19033, -10117, -2784, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 16968, -8189, -3200, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 16317, -9289, -3264, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 14879, -13211, -3168, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 18346, 16903, -14105, -3160, 0, 0, 0, 60, 0, 0, 0),
-- Velociraptor
("primeval_isle", 1, 22196, 13994, -17411, -3024, 0, 0, 45478, 60, 0, 0, 0),
("primeval_isle", 1, 22196, 20291, -21347, -3008, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22196, 21501, -15017, -3056, 0, 0, 35394, 60, 0, 0, 0),
("primeval_isle", 1, 22196, 27957, -15092, -2584, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22196, 24628, -20888, -2584, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22196, 21014, -12492, -2704, 0, 0, 34228, 60, 0, 0, 0),
-- Velociraptor
("primeval_isle", 1, 22198, 15831, -17587, -3216, 0, 0, 36791, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 16601, -16695, -3232, 0, 0, 46776, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 14187, -14327, -3192, 0, 0, 19512, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 16433, -14860, -3176, 0, 0, 53930, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 16828, -15716, -3184, 0, 0, 46776, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 18917, -19494, -3304, 0, 0, 39678, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 20099, -16677, -3056, 0, 0, 50973, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 18599, -17658, -3216, 0, 0, 45638, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 19751, -18203, -3232, 0, 0, 54007, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 18895, -14436, -2976, 0, 0, 37369, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 21226, -19092, -3248, 0, 0, 8790, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 20676, -18312, -3192, 0, 0, 29597, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 20858, -18057, -3128, 0, 0, 13415, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 23691, -20688, -2704, 0, 0, 2098, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 23813, -19178, -2792, 0, 0, 40874, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 21014, -14673, -3056, 0, 0, 58892, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 22899, -15499, -3040, 0, 0, 13792, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 22360, -15116, -3048, 0, 0, 26323, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 24935, -17794, -2736, 0, 0, 14110, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 26837, -17189, -2728, 0, 0, 2555, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 25133, -14833, -2736, 0, 0, 13178, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 27289, -17133, -2680, 0, 0, 1285, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 27247, -12938, -2320, 0, 0, 9592, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 26734, -12967, -2384, 0, 0, 46861, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 24300, -12260, -2520, 0, 0, 19382, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 22820, -10983, -2672, 0, 0, 52543, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 26991, -11802, -2432, 0, 0, 11492, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 27629, -11835, -2312, 0, 0, 22415, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 20372, -10947, -2832, 0, 0, 11057, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 19292, -10868, -2872, 0, 0, 13418, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 19916, -11127, -2832, 0, 0, 49701, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 16554, -10619, -3264, 0, 0, 44140, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 14134, -12048, -3016, 0, 0, 52072, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 13243, -12371, -2984, 0, 0, 17289, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 14622, -13249, -3160, 0, 0, 26674, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 17083, -13234, -3128, 0, 0, 38724, 60, 0, 0, 0),
("primeval_isle", 1, 22198, 17141, -12939, -3120, 0, 0, 14324, 60, 0, 0, 0),
-- Pterosaur
("primeval_isle", 1, 22199, 19776, -18928, -3288, 0, 0, 29550, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 19506, -15408, -3072, 0, 0, 45143, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 20416, -20909, -3080, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 20166, -21128, -3024, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 21166, -20033, -3296, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 21666, -17410, -2960, 0, 0, 48218, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 24092, -18763, -2760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 23216, -16901, -2968, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 26446, -17868, -2704, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 27228, -15892, -2656, 0, 0, 63512, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 24628, -21069, -2552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 23718, -14304, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 24714, -13583, -2472, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 26969, -13774, -2304, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 24556, -11814, -2536, 0, 0, 12097, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 24358, -11423, -2544, 0, 0, 47567, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 23796, -9840, -2552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 20800, -12492, -2712, 0, 0, 8316, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 19938, -12196, -2760, 0, 0, 54770, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 20190, -9774, -2848, 0, 0, 28636, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 16957, -11057, -3184, 0, 0, 48183, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 15470, -9402, -3256, 0, 0, 19447, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 15883, -6539, -3056, 0, 0, 8564, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 15232, -7364, -3136, 0, 0, 7538, 60, 0, 0, 0),
("primeval_isle", 1, 22199, 14879, -12764, -3144, 0, 0, 10867, 60, 0, 0, 0),
-- Ornithomimus
("primeval_isle", 1, 22202, 14803, -18319, -3184, 0, 0, 13313, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 15809, -17684, -3216, 0, 0, 46886, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 16434, -14637, -3176, 0, 0, 62148, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 19580, -16612, -3112, 0, 0, 31467, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 18599, -17658, -3216, 0, 0, 45638, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 20581, -15799, -3040, 0, 0, 56814, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 21226, -19092, -3248, 0, 0, 8790, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 23813, -19178, -2792, 0, 0, 40874, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 26512, -16107, -2664, 0, 0, 5209, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 25591, -15496, -2728, 0, 0, 43240, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 24109, -11614, -2536, 0, 0, 19382, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 24296, -11642, -2536, 0, 0, 51852, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 21724, -11239, -2760, 0, 0, 36497, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 19865, -11852, -2784, 0, 0, 11057, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 20037, -10471, -2832, 0, 0, 58222, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 16554, -10619, -3264, 0, 0, 44140, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 14808, -12260, -3104, 0, 0, 38595, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 15660, -9943, -3272, 0, 0, 7959, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 14556, -14047, -3208, 0, 0, 11117, 60, 0, 0, 0),
("primeval_isle", 1, 22202, 15257, -13397, -3176, 0, 0, 52907, 60, 0, 0, 0),
-- Deinonychus
("primeval_isle", 1, 22205, 15964, -18408, -3184, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 20002, -18075, -3200, 0, 0, 4918, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 24060, -18407, -2736, 0, 0, 22587, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 21526, -14486, -3088, 0, 0, 63875, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 27258, -16633, -2672, 0, 0, 62354, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 25152, -11442, -2496, 0, 0, 32732, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 15353, -8810, -3264, 0, 0, 35093, 60, 0, 0, 0),
("primeval_isle", 1, 22205, 14932, -13501, -3184, 0, 0, 51680, 60, 0, 0, 0),
-- Wild Strider
("primeval_isle", 1, 22213, 2854, -12579, -3576, 0, 0, 34011, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 5591, -12989, -3656, 0, 0, 5629, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 2047, -11495, -3472, 0, 0, 48888, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 5564, -10073, -3624, 0, 0, 16220, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 5465, -9186, -3672, 0, 0, 42960, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 5851, -7792, -3648, 0, 0, 19619, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 5220, -7422, -3504, 0, 0, 44857, 60, 0, 0, 0),
("primeval_isle", 1, 22213, 6318, -13788, -3696, 0, 0, 0, 60, 0, 0, 0),
-- Elroki
("primeval_isle", 1, 22214, 5555, -19711, -3608, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22214, 3635, -17650, -3624, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22214, 5937, -17281, -3696, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22214, 3505, -15371, -3536, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22214, 7379, -14776, -3704, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22214, 5533, -14304, -3704, 0, 0, 0, 60, 0, 0, 0),
-- Tyrannosaurus
("primeval_isle", 1, 22215, 19506, -15772, -3080, 0, 0, 49220, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 22253, -17062, -2976, 0, 0, 47449, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 23348, -20888, -2672, 0, 0, 0, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 25047, -18477, -2712, 0, 0, 0, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 27331, -16669, -2664, 0, 0, 21125, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 27714, -14692, -2552, 0, 0, 0, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 26555, -11574, -2464, 0, 0, 28153, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 21295, -11123, -2784, 0, 0, 41953, 1800, 0, 0, 0),
("primeval_isle", 1, 22215, 19605, -11234, -2816, 0, 0, 57601, 1800, 0, 0, 0),
-- Tyrannosaurus
("primeval_isle", 1, 22216, 19220, -11806, -2776, 0, 0, 0, 1800, 0, 0, 0),
-- Tyrannosaurus
("primeval_isle", 1, 22217, 26740, -16596, -2688, 0, 0, 13790, 1800, 0, 0, 0),
-- Velociraptor
("primeval_isle", 1, 22218, 16928, -16220, -3208, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 18156, -15044, -3072, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 18740, -20244, -3288, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 19588, -18612, -3280, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 22476, -16607, -2984, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 24086, -17759, -2760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 20586, -15408, -3056, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 23068, -15578, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 24856, -18477, -2720, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 25856, -17759, -2728, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 27014, -19612, -2280, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 26149, -13201, -2472, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 27379, -13774, -2272, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 23426, -11814, -2528, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 25460, -12017, -2520, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 22298, -12492, -2600, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22218, 20481, -11899, -2792, 0, 0, 0, 60, 0, 0, 0),
-- Ornithomimus
("primeval_isle", 1, 22219, 5740, -21105, -3416, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 6005, -21428, -3368, 0, 0, 56875, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 4673, -18463, -3672, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 5990, -20441, -3488, 0, 0, 35825, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7841, -19086, -3640, 0, 0, 2749, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7536, -19177, -3680, 0, 0, 50136, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3662, -20256, -3352, 0, 0, 54896, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3499, -19936, -3344, 0, 0, 39889, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3832, -16545, -3712, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2890, -17128, -3552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 6886, -17570, -3640, 0, 0, 2127, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7568, -16765, -3648, 0, 0, 65095, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7884, -17896, -3560, 0, 0, 26450, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2435, -14860, -3320, 0, 0, 1472, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3530, -16223, -3568, 0, 0, 23278, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 4745, -16026, -3608, 0, 0, 24667, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 6072, -16082, -3712, 0, 0, 11763, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3730, -12596, -3760, 0, 0, 13589, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3800, -12939, -3760, 0, 0, 10514, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2541, -14066, -3400, 0, 0, 43397, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2240, -13831, -3336, 0, 0, 51029, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 5247, -13936, -3712, 0, 0, 55267, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2649, -11653, -3576, 0, 0, 31384, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3644, -9112, -3600, 0, 0, 10958, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 2424, -9830, -3664, 0, 0, 32760, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3475, -7014, -3320, 0, 0, 12488, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 3883, -7791, -3464, 0, 0, 58561, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 6373, -8269, -3752, 0, 0, 28750, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7613, -9365, -3584, 0, 0, 31384, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7807, -6790, -3496, 0, 0, 15331, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 7096, -10205, -3656, 0, 0, 25226, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 8493, -14360, -3696, 0, 0, 58478, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 8447, -14972, -3680, 0, 0, 43838, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 16248, -18905, -3208, 0, 0, 62181, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 15545, -14345, -3152, 0, 0, 37252, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 16797, -14914, -3184, 0, 0, 47955, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 19867, -18814, -3272, 0, 0, 46214, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 20541, -21785, -2912, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 21517, -17370, -2968, 0, 0, 35667, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 21778, -17677, -2936, 0, 0, 42809, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 23732, -21793, -2472, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 24415, -18026, -2728, 0, 0, 47224, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 20601, -16115, -3040, 0, 0, 5817, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 21715, -15043, -3064, 0, 0, 18224, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 22988, -15056, -3048, 0, 0, 24773, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 25238, -19192, -2616, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 25381, -18030, -2720, 0, 0, 37429, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 27696, -12843, -2288, 0, 0, 2912, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 22705, -12047, -2584, 0, 0, 11659, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 22557, -12195, -2592, 0, 0, 8985, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 20001, -11823, -2800, 0, 0, 5742, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 19860, -8608, -2712, 0, 0, 23278, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 14740, -13586, -3192, 0, 0, 56592, 60, 0, 0, 0),
("primeval_isle", 1, 22219, 15961, -13299, -3176, 0, 0, 23849, 60, 0, 0, 0),
-- Deinonychus
("primeval_isle", 1, 22220, 6500, -21747, -3360, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7070, -20677, -3512, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 6337, -20992, -3464, 0, 0, 47823, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7750, -19025, -3656, 0, 0, 47856, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3725, -19583, -3456, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3567, -19023, -3480, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3428, -19970, -3328, 0, 0, 58624, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 2526, -17406, -3456, 0, 0, 25124, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4791, -18210, -3672, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7670, -18162, -3568, 0, 0, 60029, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7529, -18324, -3600, 0, 0, 6790, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 2329, -14459, -3304, 0, 0, 20401, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 2263, -14413, -3296, 0, 0, 43787, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3472, -16237, -3568, 0, 0, 64470, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4769, -15984, -3600, 0, 0, 57626, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 8400, -14727, -3688, 0, 0, 3944, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7743, -15212, -3688, 0, 0, 39560, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7344, -15943, -3680, 0, 0, 999, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 6104, -15894, -3720, 0, 0, 6434, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 2377, -14095, -3344, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3569, -13603, -3584, 0, 0, 53989, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4056, -13377, -3760, 0, 0, 18749, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 2223, -10800, -3504, 0, 0, 21869, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4885, -12207, -3616, 0, 0, 24852, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3972, -10085, -3664, 0, 0, 99, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 3625, -9647, -3632, 0, 0, 30401, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4912, -9772, -3760, 0, 0, 20985, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 5639, -6667, -3456, 0, 0, 40267, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 4395, -5955, -3096, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 6605, -6511, -3424, 0, 0, 59625, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 7524, -7265, -3576, 0, 0, 29596, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 6946, -7563, -3624, 0, 0, 23480, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 8533, -14092, -3704, 0, 0, 8330, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 15382, -16330, -3192, 0, 0, 1154, 60, 0, 0, 0),
("primeval_isle", 1, 22220, 27994, -15015, -2568, 0, 0, 26953, 60, 0, 0, 0),
-- Pachycephalosaurus
("primeval_isle", 1, 22221, 5550, -21747, -3328, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4790, -21319, -3360, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4515, -18883, -3640, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4357, -19723, -3520, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4831, -20143, -3528, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7830, -20891, -3440, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7260, -20249, -3552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7023, -19421, -3672, 0, 0, 6856, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7427, -19087, -3680, 0, 0, 17965, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6761, -18795, -3696, 0, 0, 42642, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3409, -19303, -3400, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3226, -18173, -3592, 0, 0, 16383, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3408, -18472, -3528, 0, 0, 54826, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2534, -16823, -3408, 0, 0, 49249, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2623, -16590, -3424, 0, 0, 51707, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4380, -16915, -3696, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5202, -16915, -3768, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5063, -16754, -3760, 0, 0, 60895, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6484, -16981, -3656, 0, 0, 30857, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6865, -17218, -3640, 0, 0, 13481, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7632, -17527, -3624, 0, 0, 36125, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7290, -17949, -3632, 0, 0, 41723, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4020, -14420, -3560, 0, 0, 34611, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3058, -16226, -3520, 0, 0, 5289, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2622, -14776, -3352, 0, 0, 54344, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3202, -14387, -3456, 0, 0, 51752, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2126, -14612, -3256, 0, 0, 39739, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2799, -16284, -3456, 0, 0, 51410, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5339, -15805, -3600, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5276, -15717, -3600, 0, 0, 61603, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4948, -15117, -3600, 0, 0, 18012, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4015, -14728, -3536, 0, 0, 26687, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6743, -15042, -3712, 0, 0, 40455, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7329, -16262, -3664, 0, 0, 64669, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7186, -15079, -3704, 0, 0, 20920, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2739, -14221, -3392, 0, 0, 50390, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3162, -13973, -3488, 0, 0, 41980, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3320, -13538, -3568, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3867, -12582, -3744, 0, 0, 15955, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3624, -12461, -3760, 0, 0, 7632, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 2143, -13640, -3344, 0, 0, 28869, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5940, -13991, -3704, 0, 0, 49806, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5858, -13460, -3744, 0, 0, 5177, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5727, -13232, -3744, 0, 0, 46388, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4480, -13080, -3656, 0, 0, 54075, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4256, -13549, -3760, 0, 0, 42499, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5112, -13453, -3696, 0, 0, 61702, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3443, -11119, -3648, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3091, -11798, -3648, 0, 0, 21092, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3226, -11598, -3664, 0, 0, 19588, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5676, -10581, -3624, 0, 0, 52082, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6335, -8905, -3728, 0, 0, 64221, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4372, -9162, -3600, 0, 0, 27867, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4035, -9273, -3616, 0, 0, 19890, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3077, -7069, -3328, 0, 0, 24676, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 3490, -6459, -3152, 0, 0, 43726, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4665, -6367, -3256, 0, 0, 46465, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4799, -7319, -3472, 0, 0, 64813, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 4834, -6816, -3392, 0, 0, 46528, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 5402, -6969, -3488, 0, 0, 43631, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6492, -8691, -3752, 0, 0, 6152, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6315, -9882, -3760, 0, 0, 25283, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 7001, -7352, -3584, 0, 0, 12697, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6356, -7920, -3752, 0, 0, 45919, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6044, -11899, -3632, 0, 0, 56213, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 6312, -13399, -3744, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 8496, -14856, -3664, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 8408, -14648, -3688, 0, 0, 40150, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 8492, -14488, -3688, 0, 0, 27163, 60, 0, 0, 0),
("primeval_isle", 1, 22221, 8353, -14856, -3680, 0, 0, 35185, 60, 0, 0, 0),
-- Wild Strider
("primeval_isle", 1, 22222, 4702, -21182, -3376, 0, 0, 62215, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5779, -19023, -3648, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5779, -18603, -3712, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6657, -20845, -3504, 0, 0, 59087, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7640, -20998, -3432, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7830, -20356, -3480, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7900, -19254, -3616, 0, 0, 15909, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3409, -19583, -3376, 0, 0, 20880, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3725, -18883, -3520, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3183, -18745, -3416, 0, 0, 55655, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3323, -18355, -3544, 0, 0, 55960, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4342, -18154, -3632, 0, 0, 52338, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4928, -17840, -3688, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7054, -17512, -3632, 0, 0, 60019, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7807, -18037, -3544, 0, 0, 15532, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7215, -18197, -3616, 0, 0, 64958, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7492, -18198, -3584, 0, 0, 33148, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 2461, -14689, -3312, 0, 0, 58927, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3057, -14557, -3416, 0, 0, 44338, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 2538, -16257, -3352, 0, 0, 12432, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 2514, -16395, -3368, 0, 0, 52689, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4580, -15008, -3576, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5613, -15990, -3760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4632, -16542, -3728, 0, 0, 15309, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6388, -14576, -3768, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7796, -14921, -3696, 0, 0, 29456, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8155, -15676, -3616, 0, 0, 58625, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6200, -15001, -3736, 0, 0, 23907, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6782, -15458, -3696, 0, 0, 17517, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8061, -16121, -3624, 0, 0, 38472, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7479, -16179, -3664, 0, 0, 64587, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3059, -13898, -3520, 0, 0, 20457, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 2494, -13702, -3440, 0, 0, 10250, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6084, -13078, -3712, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5000, -13685, -3760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5850, -13216, -3760, 0, 0, 12789, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5821, -13577, -3712, 0, 0, 52791, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4867, -13171, -3656, 0, 0, 36245, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5530, -12785, -3640, 0, 0, 19053, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 2081, -11002, -3464, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3612, -11153, -3680, 0, 0, 1972, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4515, -11911, -3552, 0, 0, 22359, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4406, -11588, -3616, 0, 0, 53351, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 5442, -10190, -3632, 0, 0, 6978, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3180, -8904, -3568, 0, 0, 56099, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3557, -8853, -3576, 0, 0, 31723, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3668, -9487, -3624, 0, 0, 34285, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3127, -9267, -3640, 0, 0, 19739, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6119, -8354, -3640, 0, 0, 7252, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4593, -9162, -3600, 0, 0, 37372, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4065, -7881, -3472, 0, 0, 10617, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 3559, -7394, -3376, 0, 0, 51662, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4274, -7265, -3408, 0, 0, 1587, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 4171, -6049, -3080, 0, 0, 7432, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7624, -8200, -3624, 0, 0, 57279, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7501, -9024, -3600, 0, 0, 3475, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7655, -8088, -3632, 0, 0, 62606, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6947, -6446, -3448, 0, 0, 55262, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7542, -7985, -3640, 0, 0, 53713, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 7856, -14254, -3696, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6318, -13552, -3680, 0, 0, 61462, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 6264, -13191, -3768, 0, 0, 28395, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8373, -14306, -3696, 0, 0, 8560, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8336, -14856, -3680, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8388, -14612, -3688, 0, 0, 38622, 60, 0, 0, 0),
("primeval_isle", 1, 22222, 8615, -14764, -3656, 0, 0, 56131, 60, 0, 0, 0),
-- Velociraptor
("primeval_isle", 1, 22223, 13725, -17202, -2904, 0, 0, 11451, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 15489, -19599, -3128, 0, 0, 33780, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 14432, -17324, -3104, 0, 0, 954, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 14495, -18281, -3168, 0, 0, 39942, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 15336, -16539, -3192, 0, 0, 36376, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 16928, -17508, -3208, 0, 0, 65108, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 18272, -17506, -3224, 0, 0, 53227, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 15897, -15401, -3176, 0, 0, 39942, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 14259, -14344, -3184, 0, 0, 23389, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 18156, -14680, -3016, 0, 0, 20244, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 19506, -16500, -3104, 0, 0, 40300, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 19118, -17877, -3208, 0, 0, 38291, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 20416, -20690, -3168, 0, 0, 1722, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 19284, -20535, -3160, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 23416, -21111, -2616, 0, 0, 39139, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 23901, -18620, -2760, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 23519, -18048, -2688, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 23718, -14407, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 22772, -15725, -3040, 0, 0, 3809, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 27272, -20076, -2200, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 26977, -16905, -2696, 0, 0, 6366, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 27471, -15492, -2632, 0, 0, 61862, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 25739, -13010, -2584, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 26354, -13965, -2392, 0, 0, 36130, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 24556, -12220, -2528, 0, 0, 23617, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 25632, -11563, -2496, 0, 0, 57950, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 24782, -11408, -2536, 0, 0, 22240, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 24104, -10190, -2520, 0, 0, 13481, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 21762, -13892, -3128, 0, 0, 57140, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 20799, -10068, -2872, 0, 0, 3582, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 20705, -9773, -2864, 0, 0, 29343, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 22097, -9952, -2792, 0, 0, 47915, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 20632, -8033, -2656, 0, 0, 31186, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 19505, -9946, -2832, 0, 0, 11031, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 16403, -9172, -3272, 0, 0, 9772, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 16317, -9014, -3272, 0, 0, 40690, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 14798, -9289, -3264, 0, 0, 61954, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 15375, -8485, -3248, 0, 0, 64016, 60, 0, 0, 0),
("primeval_isle", 1, 22223, 17156, -12317, -3120, 0, 0, 29824, 60, 0, 0, 0),
-- Ornithomimus
("primeval_isle", 1, 22224, 16215, -15205, -3168, 0, 0, 6694, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 19227, -19567, -3320, 0, 0, 65273, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 20916, -20909, -3104, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 24381, -17323, -2776, 0, 0, 52129, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 27960, -18916, -2432, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 21791, -13388, -3128, 0, 0, 51751, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 16100, -11489, -3232, 0, 0, 44238, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 14581, -10114, -3304, 0, 0, 49021, 60, 0, 0, 0),
("primeval_isle", 1, 22224, 16539, -13842, -3168, 0, 0, 24436, 60, 0, 0, 0),
-- Deinonychus
("primeval_isle", 1, 22225, 19994, -20153, -3248, 0, 0, 33359, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 19806, -14510, -2992, 0, 0, 34867, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 20166, -20909, -3080, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 23476, -20526, -2728, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 22032, -15872, -3016, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 27444, -18916, -2440, 0, 0, 3407, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 27888, -18064, -2576, 0, 0, 28804, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 18852, -11602, -2800, 0, 0, 14531, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 15294, -9753, -3272, 0, 0, 9868, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 14370, -13944, -3208, 0, 0, 45515, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 16720, -12948, -3128, 0, 0, 60701, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 19033, -10711, -2800, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22225, 22836, -19440, -2680, 0, 0, 0, 60, 0, 0, 0),
-- Ornithomimus
("primeval_isle", 1, 22742, 5346, -19478, -3608, 0, 0, 9120, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 7362, -21596, -3360, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 8172, -18772, -3600, 0, 0, 56020, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 6308, -19807, -3616, 0, 0, 33373, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 4862, -18216, -3672, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 4169, -18216, -3608, 0, 0, 57701, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 6703, -17124, -3640, 0, 0, 49856, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 3286, -16235, -3536, 0, 0, 61875, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 4225, -15484, -3568, 0, 0, 10692, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 1932, -13524, -3280, 0, 0, 27757, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 6106, -14292, -3704, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22742, 5150, -12336, -3632, 0, 0, 24454, 60, 0, 0, 0),
-- Deinonychus
("primeval_isle", 1, 22743, 5396, -20292, -3552, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 6294, -21596, -3376, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 8172, -18772, -3600, 0, 0, 56104, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 7516, -19737, -3608, 0, 0, 43073, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 3782, -18729, -3528, 0, 0, 36207, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 3507, -18681, -3496, 0, 0, 1787, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 7372, -17284, -3632, 0, 0, 50792, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 3228, -14414, -3456, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 3286, -16235, -3536, 0, 0, 61875, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 1932, -13524, -3280, 0, 0, 27757, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 5150, -12336, -3632, 0, 0, 24454, 60, 0, 0, 0),
("primeval_isle", 1, 22743, 7060, -13284, -3680, 0, 0, 64056, 60, 0, 0, 0),
-- Dinn
("primeval_isle", 1, 32105, 11952, -24016, -3644, 0, 0, 32000, 60, 0, 0, 0),
-- Singsing
("primeval_isle", 1, 32106, 10304, -25024, -3680, 0, 0, 0, 60, 0, 0, 0),
-- 
("primeval_isle", 1, 32108, 9295, -21759, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 3911, -19921, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 7393, -17864, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 2384, -16325, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 7049, -15082, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 2581, -10953, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 2839, -7120, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 9437, -10691, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 15342, -20151, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 14505, -17450, -1000, 0, 0, 40058, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 21715, -20295, -1000, 0, 0, 9259, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 24656, -21219, -900, 0, 0, 10105, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 20985, -14537, -800, 0, 0, 3411, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 21491, -15245, -836, 0, 0, 20132, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 27622, -19076, -1000, 0, 0, 10456, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 27933, -18073, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 23895, -14234, -628, 0, 0, 58130, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 23845, -11954, -700, 0, 0, 18015, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 27638, -11281, -900, 0, 0, 32761, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 21845, -7732, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 16052, -8284, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 17698, -6461, -1000, 0, 0, 57224, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 13777, -13921, -1000, 0, 0, 0, 60, 0, 0, 0),
("primeval_isle", 1, 32108, 8586, -25312, -1000, 0, 0, 0, 60, 0, 0, 0),
-- Shilen's Stone Statue
("primeval_isle", 1, 32109, 23664, -8464, -1345, 0, 0, 33000, 60, 0, 0, 0),
-- Orahochin
("primeval_isle", 1, 32111, 7344, -5440, -3219, 0, 0, 50000, 60, 0, 0, 0),
-- Gariachin
("primeval_isle", 1, 32112, 5376, -2720, -3200, 0, 0, 16500, 60, 0, 0, 0),
-- Marquez
("primeval_isle", 1, 32113, 11712, -23616, -3644, 0, 0, 40000, 60, 0, 0, 0),
-- Mushika
("primeval_isle", 1, 32114, 6538, -2529, -2936, 0, 0, 42000, 60, 0, 0, 0),
-- Asamah
("primeval_isle", 1, 32115, 6360, -2573, -2936, 0, 0, 0, 60, 0, 0, 0),
-- Kirikachin
("primeval_isle", 1, 32116, 12736, -14448, -3168, 0, 0, 0, 60, 0, 0, 0),
-- Karakawei
("primeval_isle", 1, 32117, 6264, -2187, -2960, 0, 0, 26000, 60, 0, 0, 0),
-- Mantarasa Egg
("primeval_isle", 1, 32118, 15748, -19810, -3008, 0, 0, 0, 60, 0, 0, 0),
-- Ulu Kaimu
("primeval_isle", 1, 32119, 23707, -19108, -2820, 0, 0, 0, 60, 0, 0, 0),
-- Balu Kaimu
("primeval_isle", 1, 32120, 27723, -11684, -2302, 0, 0, 0, 60, 0, 0, 0),
-- Chuta Kaimu
("primeval_isle", 1, 32121, 18714, -9635, -2795, 0, 0, 0, 60, 0, 0, 0),
-- Warrior's Grave
("primeval_isle", 1, 32122, 13123, -8895, -3122, 0, 0, 0, 60, 0, 0, 0),
-- Asher 
("primeval_isle", 1, 32714, 11504, -23344, -3644, 0, 0, 39000, 60, 0, 0, 0),

-- [20_18]

-- Worshipper
("unset", 1, 4327, 1828, 21917, -3345, 0, 0, 49730, 0, 0, 0, 0),
-- Altar Guard
("unset", 1, 4328, 1970, 21840, -3348, 0, 0, 56189, 0, 0, 0, 0),
("unset", 1, 4328, 1703, 21815, -3348, 0, 0, 40172, 0, 0, 0, 0),
-- Gremlin
("Dark_Elf_Village", 1, 18342, 28249, 11122, -4232, 0, 0, 44107, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 27834, 10517, -4232, 0, 0, 16383, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 27955, 11534, -4232, 0, 0, 24797, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28285, 10771, -4232, 0, 0, 37219, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28173, 11588, -4232, 0, 0, 21290, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28514, 11638, -4232, 0, 0, 2538, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28167, 11282, -4232, 0, 0, 51165, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28660, 11630, -4232, 0, 0, 38869, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 27828, 10465, -4232, 0, 0, 17818, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28800, 11173, -4232, 0, 0, 18651, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28604, 10683, -4232, 0, 0, 1592, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28958, 10876, -4232, 0, 0, 56673, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28990, 11241, -4232, 0, 0, 58793, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28762, 11570, -4232, 0, 0, 23446, 60, 0, 0, 0),
("Dark_Elf_Village", 1, 18342, 28800, 11276, -4232, 0, 0, 54830, 60, 0, 0, 0),
-- Goblin
("Dark_Elf_Village", 1, 20003, 30746, 12664, -3712, 0, 0, 12215, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 30748, 13185, -3720, 0, 0, 52023, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 26425, 16414, -3616, 0, 0, 5289, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 30895, 14064, -3688, 0, 0, 42078, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 31247, 12652, -3664, 0, 0, 55746, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 31565, 14348, -3624, 0, 0, 15546, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 27994, 17658, -3536, 0, 0, 30384, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 30387, 18552, -3720, 0, 0, 20794, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 31747, 17477, -3640, 0, 0, 60466, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 24590, 20688, -3536, 0, 0, 0, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 25050, 20589, -3528, 0, 0, 56505, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 25908, 21698, -3536, 0, 0, 44878, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 30014, 20324, -3720, 0, 0, 3393, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 31545, 7097, -3640, 0, 0, 15408, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 28351, 6990, -3720, 0, 0, 24351, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 21762, 6502, -3536, 0, 0, 22880, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 20129, 5660, -3464, 0, 0, 62579, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 18274, 8141, -3632, 0, 0, 52659, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20003, 19211, 8082, -3632, 0, 0, 35726, 15, 0, 0, 0),
-- Imp
("Dark_Elf_Village", 1, 20004, 30694, 14571, -3672, 0, 0, 19087, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 31013, 13758, -3680, 0, 0, 10265, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 30793, 16641, -3720, 0, 0, 9061, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 28674, 17545, -3600, 0, 0, 27083, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 21612, 19818, -3408, 0, 0, 58524, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 24402, 22813, -3384, 0, 0, 64863, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 29377, 19059, -3688, 0, 0, 62569, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 29336, 5370, -3584, 0, 0, 9211, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 28987, 7863, -3720, 0, 0, 15165, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 28004, 7934, -3720, 0, 0, 3983, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 24930, 5851, -3640, 0, 0, 12584, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 26051, 5747, -3616, 0, 0, 28117, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 24875, 7122, -3672, 0, 0, 14635, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 23473, 6619, -3608, 0, 0, 23962, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 22710, 6988, -3616, 0, 0, 10910, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 21633, 7587, -3616, 0, 0, 46120, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 19206, 7294, -3512, 0, 0, 8807, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 3036, 22161, -3456, 0, 0, 3055, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20004, 1991, 23301, -3488, 0, 0, 32333, 15, 0, 0, 0),
-- Imp Elder
("Dark_Elf_Village", 1, 20005, 25133, 20385, -3512, 0, 0, 60417, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 23912, 23016, -3368, 0, 0, 0, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 30660, 19784, -3720, 0, 0, 19445, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 29174, 19970, -3712, 0, 0, 40143, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 29113, 20023, -3712, 0, 0, 33636, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 29946, 19294, -3720, 0, 0, 23569, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 31551, 7425, -3640, 0, 0, 44028, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 31721, 9071, -3696, 0, 0, 59824, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 31005, 8893, -3712, 0, 0, 54248, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 29183, 6643, -3672, 0, 0, 24883, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 28179, 8064, -3720, 0, 0, 44599, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 24488, 5694, -3616, 0, 0, 22015, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 26445, 7424, -3712, 0, 0, 25470, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 26155, 6169, -3648, 0, 0, 9259, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 23659, 4108, -3472, 0, 0, 61480, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 20838, 6244, -3496, 0, 0, 34433, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 17827, 7756, -3552, 0, 0, 31304, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20005, 736, 21630, -3272, 0, 0, 28496, 15, 0, 0, 0),
-- Ashen Wolf
("Dark_Elf_Village", 1, 20456, 29878, 14528, -3672, 0, 0, 3671, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 32147, 12317, -3592, 0, 0, 19067, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 31254, 12373, -3672, 0, 0, 48759, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 27361, 17845, -3504, 0, 0, 22461, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 23011, 18423, -3536, 0, 0, 41509, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 23948, 19395, -3480, 0, 0, 47479, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 22172, 21773, -3368, 0, 0, 36902, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 23010, 20797, -3368, 0, 0, 54958, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 26347, 20384, -3552, 0, 0, 43182, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 22938, 22732, -3368, 0, 0, 34700, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 26142, 4937, -3560, 0, 0, 42480, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 24297, 5422, -3568, 0, 0, 16515, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 22693, 6510, -3552, 0, 0, 0, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 21508, 6087, -3504, 0, 0, 17374, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 19105, 8293, -3656, 0, 0, 35007, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20456, 24574, 4174, -3464, 0, 0, 9407, 15, 0, 0, 0),
-- Young Brown Keltir
("Dark_Elf_Village", 1, 20529, 25431, 8067, -3648, 0, 0, 57563, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 25662, 8170, -3656, 0, 0, 8585, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 25061, 12670, -3632, 0, 0, 39807, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 26172, 13299, -3688, 0, 0, 61530, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 26197, 13123, -3688, 0, 0, 208, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 25295, 12357, -3648, 0, 0, 27657, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 24043, 8634, -3584, 0, 0, 7458, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 23420, 8855, -3560, 0, 0, 18483, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 23044, 9338, -3560, 0, 0, 27608, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 23702, 9629, -3568, 0, 0, 55229, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 24556, 9972, -3624, 0, 0, 33798, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 23693, 12220, -3616, 0, 0, 40961, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 24538, 13287, -3608, 0, 0, 31738, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 22683, 14770, -3640, 0, 0, 26520, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 26176, 14882, -3640, 0, 0, 3159, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 25421, 14487, -3640, 0, 0, 27095, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 27809, 14784, -3720, 0, 0, 54174, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 27963, 15547, -3664, 0, 0, 64086, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 27068, 15570, -3648, 0, 0, 34928, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 21578, 13472, -3616, 0, 0, 45279, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 21473, 16968, -3592, 0, 0, 25836, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 22025, 17189, -3544, 0, 0, 64291, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 22840, 7737, -3616, 0, 0, 28977, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20529, 21472, 9315, -3616, 0, 0, 55286, 15, 0, 0, 0),
-- Brown Keltir
("Dark_Elf_Village", 1, 20532, 24970, 8190, -3648, 0, 0, 0, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 25128, 9569, -3640, 0, 0, 15344, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 26094, 8396, -3664, 0, 0, 35349, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 24886, 12687, -3624, 0, 0, 3661, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 25250, 12809, -3632, 0, 0, 4372, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 26320, 13400, -3696, 0, 0, 14489, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 23363, 9408, -3560, 0, 0, 57198, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 23898, 8120, -3632, 0, 0, 44728, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 22996, 10363, -3648, 0, 0, 63233, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 22670, 8281, -3576, 0, 0, 39072, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 23347, 16025, -3616, 0, 0, 3619, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 24704, 15629, -3616, 0, 0, 31538, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 22485, 16490, -3576, 0, 0, 52206, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 21127, 16569, -3584, 0, 0, 38058, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 25898, 19336, -3488, 0, 0, 26117, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 26432, 19547, -3520, 0, 0, 31112, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 26860, 19143, -3504, 0, 0, 12493, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 24179, 7583, -3616, 0, 0, 28363, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20532, 21861, 9129, -3608, 0, 0, 20352, 15, 0, 0, 0),
-- Elder Brown Keltir
("Dark_Elf_Village", 1, 20536, 25385, 14132, -3640, 0, 0, 62805, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 26432, 12704, -3704, 0, 0, 35094, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 23332, 13348, -3600, 0, 0, 44804, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 24081, 13390, -3600, 0, 0, 41347, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 22755, 15378, -3640, 0, 0, 12568, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 25903, 16139, -3616, 0, 0, 53160, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 28322, 14572, -3720, 0, 0, 15447, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 28356, 16414, -3632, 0, 0, 12106, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 26051, 17118, -3592, 0, 0, 36965, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 21439, 14435, -3616, 0, 0, 58220, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 21999, 16554, -3608, 0, 0, 10711, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 26055, 19633, -3504, 0, 0, 61007, 15, 0, 0, 0),
("Dark_Elf_Village", 1, 20536, 26204, 20380, -3544, 0, 0, 45411, 15, 0, 0, 0),
-- Mitraell
("Dark_Elf_Village_Npc", 1, 30129, 28384, 11008, -4232, 0, 0, 32000, 60, 0, 0, 0),
-- Undrias
("Dark_Elf_Village_Npc", 1, 30130, 25856, 10832, -3720, 0, 0, 24576, 60, 0, 0, 0),
-- Newbie Helper
("Dark_Elf_Village_Npc", 1, 30131, 28384, 11056, -4232, 0, 0, 32000, 60, 0, 0, 0),
-- Cecktinon
("Dark_Elf_Village_Npc", 1, 30132, 28225, 12998, -3720, 0, 0, 16500, 60, 0, 0, 0),
-- Kartia
("Dark_Elf_Village_Npc", 1, 30133, 27921, 12991, -3720, 0, 0, 16500, 60, 0, 0, 0),
-- Teleport Device
("Dark_Elf_Village_Npc", 1, 30134, 9670, 15537, -4568, 0, 0, 5892, 60, 0, 0, 0),
-- Iria
("Dark_Elf_Village_Npc", 1, 30135, 10761, 17970, -4554, 0, 0, 49152, 60, 0, 0, 0),
-- Payne
("Dark_Elf_Village_Npc", 1, 30136, 10823, 18013, -4554, 0, 0, 61440, 60, 0, 0, 0),
-- Vollodos
("Dark_Elf_Village_Npc", 1, 30137, 11951, 15661, -4554, 0, 0, 28672, 60, 0, 0, 0),
-- Minaless
("Dark_Elf_Village_Npc", 1, 30138, 12009, 15704, -4554, 0, 0, 16384, 60, 0, 0, 0),
-- Dorankus
("Dark_Elf_Village_Npc", 1, 30139, 13380, 17430, -4536, 0, 0, 14384, 60, 0, 0, 0),
-- Erviante
("Dark_Elf_Village_Npc", 1, 30140, 13464, 17751, -4536, 0, 0, 47000, 60, 0, 0, 0),
-- Talloth
("Dark_Elf_Village_Npc", 1, 30141, 11012, 14128, -4240, 0, 0, 14500, 60, 0, 0, 0),
-- Trudy
("Dark_Elf_Village_Npc", 1, 30143, 11283, 14226, -4240, 0, 0, 31000, 60, 0, 0, 0),
-- Harne
("Dark_Elf_Village_Npc", 1, 30144, 10344, 14445, -4240, 0, 0, 63640, 60, 0, 0, 0),
-- Vlasty
("Dark_Elf_Village_Npc", 1, 30145, 11258, 14431, -4240, 0, 0, 46500, 60, 0, 0, 0),
-- Rayla
("Dark_Elf_Village_Npc", 1, 30224, 15120, 15656, -4376, 0, 0, 14384, 60, 0, 0, 0),
-- Vellior
("Dark_Elf_Village_Npc", 1, 30305, 10315, 14293, -4240, 0, 0, 4096, 60, 0, 0, 0),
-- Karrod
("Dark_Elf_Village_Npc", 1, 30307, 10580, 17574, -4552, 0, 0, 14000, 60, 0, 0, 0),
-- Kayleen
("Dark_Elf_Village_Npc", 1, 30346, 6532, 19903, -3688, 0, 0, 30000, 60, 0, 0, 0),
-- Marion
("Dark_Elf_Village_Npc", 1, 30347, 6449