/*
 * Copyright © 2004-2025 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.datapack.ai.npc.Abercrombie;

import com.l2jserver.datapack.ai.npc.AbstractNpcAI;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * Mercenary Supplier Abercrombie AI.
 * @author Zoey76
 */
public final class Abercrombie extends AbstractNpcAI {
	// NPC
	private static final int ABERCROMBIE = 31555;
	// Items
	private static final int GOLDEN_RAM_BADGE_RECRUIT = 7246;
	private static final int GOLDEN_RAM_BADGE_SOLDIER = 7247;
	
	public Abercrombie() {
		super(Abercrombie.class.getSimpleName(), "ai/npc");
		bindFirstTalk(ABERCROMBIE);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player) {
		final String htmltext;
		if (hasQuestItems(player, GOLDEN_RAM_BADGE_SOLDIER)) {
			htmltext = "31555-07.html";
		} else if (hasQuestItems(player, GOLDEN_RAM_BADGE_RECRUIT)) {
			htmltext = "31555-01.html";
		} else {
			htmltext = "31555-09.html";
		}
		return htmltext;
	}
}
