/*
 * Copyright © 2004-2025 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.datapack.ai.npc.MonumentOfHeroes;

import com.l2jserver.datapack.ai.npc.AbstractNpcAI;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.Util;

/**
 * Monument of Heroes AI.
 * @author Adry_85
 */
public final class MonumentOfHeroes extends AbstractNpcAI {
	// NPCs
	private static final int[] MONUMENTS = {
		31690,
		31769,
		31770,
		31771,
		31772
	};
	// Items
	private static final int WINGS_OF_DESTINY_CIRCLET = 6842;
	private static final int[] WEAPONS = {
		6611, // Infinity Blade
		6612, // Infinity Cleaver
		6613, // Infinity Axe
		6614, // Infinity Rod
		6615, // Infinity Crusher
		6616, // Infinity Scepter
		6617, // Infinity Stinger
		6618, // Infinity Fang
		6619, // Infinity Bow
		6620, // Infinity Wing
		6621, // Infinity Spear
		9388, // Infinity Rapier
		9389, // Infinity Sword
		9390, // Infinity Shooter
	};
	
	public MonumentOfHeroes() {
		super(MonumentOfHeroes.class.getSimpleName(), "ai/npc");
		bindStartNpc(MONUMENTS);
		bindTalk(MONUMENTS);
	}
	
	@Override
	public String onEvent(String event, L2Npc npc, L2PcInstance player) {
		switch (event) {
			case "HeroWeapon": {
				if (player.isHero()) {
					return hasAtLeastOneQuestItem(player, WEAPONS) ? "already_have_weapon.htm" : "weapon_list.htm";
				}
				return "no_hero_weapon.htm";
			}
			case "HeroCirclet": {
				if (player.isHero()) {
					if (!hasQuestItems(player, WINGS_OF_DESTINY_CIRCLET)) {
						giveItems(player, WINGS_OF_DESTINY_CIRCLET, 1);
					} else {
						return "already_have_circlet.htm";
					}
				} else {
					return "no_hero_circlet.htm";
				}
				break;
			}
			default: {
				int weaponId = Integer.parseInt(event);
				if (Util.contains(WEAPONS, weaponId)) {
					giveItems(player, weaponId, 1);
				}
				break;
			}
		}
		return super.onEvent(event, npc, player);
	}
}