/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.geodriver.regions;

import com.l2jserver.geodriver.Block;
import com.l2jserver.geodriver.Region;
import com.l2jserver.geodriver.blocks.ComplexBlock;
import com.l2jserver.geodriver.blocks.FlatBlock;
import com.l2jserver.geodriver.blocks.MultilayerBlock;
import java.nio.ByteBuffer;

public final class NormalRegion
implements Region {
    private final Block[] _blocks = new Block[65536];

    public NormalRegion(ByteBuffer bb) {
        block5: for (int blockOffset = 0; blockOffset < 65536; ++blockOffset) {
            byte blockType = bb.get();
            switch (blockType) {
                case 0: {
                    this._blocks[blockOffset] = new FlatBlock(bb);
                    continue block5;
                }
                case 1: {
                    this._blocks[blockOffset] = new ComplexBlock(bb);
                    continue block5;
                }
                case 2: {
                    this._blocks[blockOffset] = new MultilayerBlock(bb);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Invalid block type " + blockType + "!");
                }
            }
        }
    }

    private Block getBlock(int geoX, int geoY) {
        return this._blocks[geoX / 8 % 256 * 256 + geoY / 8 % 256];
    }

    @Override
    public boolean checkNearestNswe(int geoX, int geoY, int worldZ, int nswe) {
        return this.getBlock(geoX, geoY).checkNearestNswe(geoX, geoY, worldZ, nswe);
    }

    @Override
    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this.getBlock(geoX, geoY).getNearestZ(geoX, geoY, worldZ);
    }

    @Override
    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        return this.getBlock(geoX, geoY).getNextLowerZ(geoX, geoY, worldZ);
    }

    @Override
    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        return this.getBlock(geoX, geoY).getNextHigherZ(geoX, geoY, worldZ);
    }

    @Override
    public boolean hasGeo() {
        return true;
    }
}

