/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.LoadersManager;
import org.aeonbits.owner.Preprocessor;
import org.aeonbits.owner.Tokenizer;
import org.aeonbits.owner.crypto.Decryptor;
import org.aeonbits.owner.crypto.IdentityDecryptor;
import org.aeonbits.owner.util.Util;

public interface Config
extends Serializable {

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface PreprocessorClasses {
        public Class<? extends Preprocessor>[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ConverterClass {
        public Class<? extends Converter> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface TokenizerClass {
        public Class<? extends Tokenizer> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface Separator {
        public String value();
    }

    public static enum DisableableFeature {
        VARIABLE_EXPANSION,
        PARAMETER_FORMATTING;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface DisableFeature {
        public DisableableFeature[] value();
    }

    public static enum HotReloadType {
        SYNC,
        ASYNC;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface HotReload {
        public long value() default 5L;

        public TimeUnit unit() default TimeUnit.SECONDS;

        public HotReloadType type() default HotReloadType.SYNC;
    }

    public static enum LoadType {
        FIRST{

            @Override
            Properties load(List<URI> uris, LoadersManager loaders) {
                Properties result = new Properties();
                for (URI uri : uris) {
                    try {
                        loaders.load(result, uri);
                        break;
                    }
                    catch (IOException ex) {
                        Util.ignore();
                    }
                }
                return result;
            }
        }
        ,
        MERGE{

            @Override
            Properties load(List<URI> uris, LoadersManager loaders) {
                Properties result = new Properties();
                for (URI uri : Util.reverse(uris)) {
                    try {
                        loaders.load(result, uri);
                    }
                    catch (IOException ex) {
                        Util.ignore();
                    }
                }
                return result;
            }
        };


        abstract Properties load(List<URI> var1, LoadersManager var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface DecryptorClass {
        public Class<? extends Decryptor> value() default IdentityDecryptor.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface EncryptedValue {
        public Class<? extends Decryptor> value() default IdentityDecryptor.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface Key {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface DefaultValue {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface Sources {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface LoadPolicy {
        public LoadType value() default LoadType.FIRST;
    }
}

