/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.commons.UPnPService;
import com.l2jserver.commons.dao.ServerNameDAO;
import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.IPv4Filter;
import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.MonsterRace;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.bbs.service.ForumsBBSManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.data.json.ExperienceData;
import com.l2jserver.gameserver.data.sql.impl.AnnouncementsTable;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.sql.impl.CharSummonTable;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.sql.impl.CrestTable;
import com.l2jserver.gameserver.data.sql.impl.NpcBufferTable;
import com.l2jserver.gameserver.data.sql.impl.OfflineTradersTable;
import com.l2jserver.gameserver.data.sql.impl.SummonSkillsTable;
import com.l2jserver.gameserver.data.sql.impl.TeleportLocationTable;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.data.xml.impl.ArmorSetsData;
import com.l2jserver.gameserver.data.xml.impl.BuyListData;
import com.l2jserver.gameserver.data.xml.impl.CategoryData;
import com.l2jserver.gameserver.data.xml.impl.ClassListData;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemData;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemGroupsData;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemHPBonusData;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemOptionsData;
import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.data.xml.impl.FishData;
import com.l2jserver.gameserver.data.xml.impl.FishingMonstersData;
import com.l2jserver.gameserver.data.xml.impl.FishingRodsData;
import com.l2jserver.gameserver.data.xml.impl.HennaData;
import com.l2jserver.gameserver.data.xml.impl.HitConditionBonusData;
import com.l2jserver.gameserver.data.xml.impl.InitialEquipmentData;
import com.l2jserver.gameserver.data.xml.impl.InitialShortcutData;
import com.l2jserver.gameserver.data.xml.impl.KarmaData;
import com.l2jserver.gameserver.data.xml.impl.MultisellData;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.data.xml.impl.OptionData;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.data.xml.impl.PlayerCreationPointData;
import com.l2jserver.gameserver.data.xml.impl.PlayerTemplateData;
import com.l2jserver.gameserver.data.xml.impl.PlayerXpPercentLostData;
import com.l2jserver.gameserver.data.xml.impl.RecipeData;
import com.l2jserver.gameserver.data.xml.impl.SecondaryAuthData;
import com.l2jserver.gameserver.data.xml.impl.SiegeScheduleData;
import com.l2jserver.gameserver.data.xml.impl.SkillLearnData;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.data.xml.impl.StaticObjectData;
import com.l2jserver.gameserver.data.xml.impl.TransformData;
import com.l2jserver.gameserver.data.xml.impl.UIData;
import com.l2jserver.gameserver.datatables.AugmentationData;
import com.l2jserver.gameserver.datatables.BotReportTable;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.MerchantPriceConfigTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.handler.EffectHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.instancemanager.GlobalVariablesManager;
import com.l2jserver.gameserver.instancemanager.GraciaSeedsManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemAuctionManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.AutoSpawnHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.TvTManager;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.L2GamePacketHandler;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.script.faenor.FaenorScriptEngine;
import com.l2jserver.gameserver.scripting.ScriptEngineManager;
import com.l2jserver.gameserver.status.Status;
import com.l2jserver.gameserver.taskmanager.KnownListUpdateTaskManager;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.util.DeadLockDetector;
import com.l2jserver.mmocore.AcceptFilter;
import com.l2jserver.mmocore.ClientFactory;
import com.l2jserver.mmocore.MMOExecutor;
import com.l2jserver.mmocore.PacketHandler;
import com.l2jserver.mmocore.SelectorConfig;
import com.l2jserver.mmocore.SelectorThread;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameServer {
    private static final Logger LOG = LoggerFactory.getLogger(GameServer.class);
    private static final String DATAPACK = "-dp";
    private static final String SCRIPT = "-s";
    private static final String GEODATA = "-gd";
    private final SelectorThread<L2GameClient> _selectorThread;
    private final L2GamePacketHandler _gamePacketHandler;
    private final DeadLockDetector _deadDetectThread;
    public static GameServer gameServer;
    public static final Calendar dateTimeServerStarted;

    public GameServer() throws Exception {
        long serverLoadStart = GameServer.startTimedSection("Database");
        ConnectionFactory.builder().withUrl(Configuration.database().getURL()).withUser(Configuration.database().getUser()).withPassword(Configuration.database().getPassword()).withMaxIdleTime(Configuration.database().getMaxIdleTime()).withMaxPoolSize(Configuration.database().getMaxConnections()).build();
        DAOFactory.getInstance();
        if (!IdFactory.getInstance().isInitialized()) {
            LOG.error("Could not read object IDs from database. Please check your configuration.");
            throw new Exception("Could not initialize the Id factory!");
        }
        GameServer.endTimedSection("Database", serverLoadStart);
        ThreadPoolManager.getInstance();
        EventDispatcher.getInstance();
        ScriptEngineManager.getInstance();
        long worldStart = GameServer.startTimedSection("World");
        GameTimeController.init();
        InstanceManager.getInstance();
        L2World.getInstance();
        MapRegionManager.getInstance();
        AnnouncementsTable.getInstance();
        GlobalVariablesManager.getInstance();
        GameServer.endTimedSection("World", worldStart);
        long dataStart = GameServer.startTimedSection("Data");
        CategoryData.getInstance();
        SecondaryAuthData.getInstance();
        GameServer.endTimedSection("Data", dataStart);
        long effectsStart = GameServer.startTimedSection("Effects");
        EffectHandler.getInstance().executeScript();
        GameServer.endTimedSection("Effects", effectsStart);
        long esgStart = GameServer.startTimedSection("Enchant Skill Groups");
        EnchantSkillGroupsData.getInstance();
        GameServer.endTimedSection("Enchant Skill Groups", esgStart);
        long skillTreesStart = GameServer.startTimedSection("Skill Trees");
        SkillTreesData.getInstance();
        GameServer.endTimedSection("Skill Trees", skillTreesStart);
        long skillsStart = GameServer.startTimedSection("Skills");
        SkillData.getInstance();
        SummonSkillsTable.getInstance();
        GameServer.endTimedSection("Skills", skillsStart);
        long itemsStart = GameServer.startTimedSection("Items");
        ItemTable.getInstance();
        EnchantItemGroupsData.getInstance();
        EnchantItemData.getInstance();
        EnchantItemOptionsData.getInstance();
        OptionData.getInstance();
        EnchantItemHPBonusData.getInstance();
        MerchantPriceConfigTable.getInstance().loadInstances();
        BuyListData.getInstance();
        MultisellData.getInstance();
        RecipeData.getInstance();
        ArmorSetsData.getInstance();
        FishData.getInstance();
        FishingMonstersData.getInstance();
        FishingRodsData.getInstance();
        HennaData.getInstance();
        GameServer.endTimedSection("Items", itemsStart);
        long charactersStart = GameServer.startTimedSection("Characters");
        ClassListData.getInstance();
        InitialEquipmentData.getInstance();
        InitialShortcutData.getInstance();
        ExperienceData.getInstance();
        PlayerXpPercentLostData.getInstance();
        KarmaData.getInstance();
        HitConditionBonusData.getInstance();
        PlayerTemplateData.getInstance();
        PlayerCreationPointData.getInstance();
        CharNameTable.getInstance();
        AdminData.getInstance();
        RaidBossPointsManager.getInstance();
        PetDataTable.getInstance();
        CharSummonTable.getInstance().init();
        GameServer.endTimedSection("Characters", charactersStart);
        long bbsStart = GameServer.startTimedSection("BBS");
        if (Configuration.general().enableCommunityBoard()) {
            ForumsBBSManager.getInstance().load();
        }
        GameServer.endTimedSection("BBS", bbsStart);
        long clansStart = GameServer.startTimedSection("Clans");
        ClanTable.getInstance();
        ClanHallSiegeManager.getInstance();
        ClanHallManager.getInstance();
        AuctionManager.getInstance();
        GameServer.endTimedSection("Clans", clansStart);
        long geodataStart = GameServer.startTimedSection("Geodata");
        GeoData.getInstance();
        if (Configuration.geodata().getPathFinding() > 0) {
            PathFinding.getInstance();
        }
        GameServer.endTimedSection("Geodata", geodataStart);
        long npcsStart = GameServer.startTimedSection("NPCs");
        SkillLearnData.getInstance();
        NpcData.getInstance();
        WalkingManager.getInstance();
        StaticObjectData.getInstance();
        ZoneManager.getInstance();
        DoorData.getInstance();
        CastleManager.getInstance().loadInstances();
        NpcBufferTable.getInstance();
        GrandBossManager.getInstance().initZones();
        EventDroplist.getInstance();
        GameServer.endTimedSection("NPCs", npcsStart);
        long auctionStart = GameServer.startTimedSection("Auction Manager");
        ItemAuctionManager.getInstance();
        GameServer.endTimedSection("Auction Manager", auctionStart);
        long olympiadStart = GameServer.startTimedSection("Olympiad");
        Olympiad.getInstance();
        Hero.getInstance();
        GameServer.endTimedSection("Olympiad", olympiadStart);
        long sevenSignsStart = GameServer.startTimedSection("Seven Signs");
        SevenSigns.getInstance();
        GameServer.endTimedSection("Seven Signs", sevenSignsStart);
        long cacheStart = GameServer.startTimedSection("Cache");
        HtmCache.getInstance();
        CrestTable.getInstance();
        TeleportLocationTable.getInstance();
        UIData.getInstance();
        PartyMatchWaitingList.getInstance();
        PartyMatchRoomList.getInstance();
        PetitionManager.getInstance();
        AugmentationData.getInstance();
        CursedWeaponsManager.getInstance();
        TransformData.getInstance();
        BotReportTable.getInstance();
        QuestManager.getInstance();
        BoatManager.getInstance();
        AirShipManager.getInstance();
        GraciaSeedsManager.getInstance();
        GameServer.endTimedSection("Cache", cacheStart);
        long handlersStart = GameServer.startTimedSection("Handlers");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/handlers/MasterHandler.java");
        GameServer.endTimedSection("Handlers", handlersStart);
        long aiStart = GameServer.startTimedSection("AI");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/ai/AILoader.java");
        GameServer.endTimedSection("AI", aiStart);
        long instancesStart = GameServer.startTimedSection("Instances");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/instances/InstanceLoader.java");
        GameServer.endTimedSection("Instances", instancesStart);
        long graciaStart = GameServer.startTimedSection("Gracia");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/gracia/GraciaLoader.java");
        GameServer.endTimedSection("Gracia", graciaStart);
        long hellboundStart = GameServer.startTimedSection("Hellbound");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/hellbound/HellboundLoader.java");
        GameServer.endTimedSection("Hellbound", hellboundStart);
        long questsStart = GameServer.startTimedSection("Quests");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/quests/QuestLoader.java");
        ScriptEngineManager.getInstance().executeScript("com/l2jserver/datapack/quests/TerritoryWarScripts/TerritoryWarSuperClass.java");
        GameServer.endTimedSection("Quests", questsStart);
        long scriptsStart = GameServer.startTimedSection("Scripts");
        ScriptEngineManager.getInstance().executeScriptList(new File(Configuration.server().getDatapackRoot(), "data/scripts.cfg"));
        GameServer.endTimedSection("Scripts", scriptsStart);
        long spawnsStart = GameServer.startTimedSection("Spawns");
        SpawnTable.getInstance().load();
        DayNightSpawnManager.getInstance().trim().notifyChangeMode();
        FourSepulchersManager.getInstance().init();
        DimensionalRiftManager.getInstance();
        RaidBossSpawnManager.getInstance();
        GameServer.endTimedSection("Spawns", spawnsStart);
        long siegeStart = GameServer.startTimedSection("Siege");
        SiegeManager.getInstance().getSieges();
        CastleManager.getInstance().activateInstances();
        FortManager.getInstance().loadInstances();
        FortManager.getInstance().activateInstances();
        FortSiegeManager.getInstance();
        SiegeScheduleData.getInstance();
        MerchantPriceConfigTable.getInstance().updateReferences();
        TerritoryWarManager.getInstance();
        CastleManorManager.getInstance();
        MercTicketManager.getInstance();
        GameServer.endTimedSection("Siege", siegeStart);
        long otherStart = GameServer.startTimedSection("Other");
        if (Configuration.general().saveDroppedItem()) {
            ItemsOnGroundManager.getInstance();
        }
        if (Configuration.general().getAutoDestroyDroppedItemAfter() > 0 || Configuration.general().getAutoDestroyHerbTime() > 0L) {
            ItemsAutoDestroy.getInstance();
        }
        MonsterRace.getInstance();
        SevenSigns.getInstance().spawnSevenSignsNPC();
        SevenSignsFestival.getInstance();
        AutoSpawnHandler.getInstance();
        FaenorScriptEngine.getInstance();
        if (Configuration.customs().allowWedding()) {
            CoupleManager.getInstance();
        }
        TaskManager.getInstance();
        AntiFeedManager.getInstance().registerEvent(0);
        if (Configuration.general().allowMail()) {
            MailManager.getInstance();
        }
        PunishmentManager.getInstance();
        Runtime.getRuntime().addShutdownHook(Shutdown.getInstance());
        LOG.info("Free Object Ids remaining {}.", (Object)IdFactory.getInstance().size());
        TvTManager.getInstance();
        KnownListUpdateTaskManager.getInstance();
        if ((Configuration.customs().offlineTradeEnable() || Configuration.customs().offlineCraftEnable()) && Configuration.customs().restoreOffliners()) {
            OfflineTradersTable.getInstance().restoreOfflineTraders();
        }
        GameServer.endTimedSection("Other", otherStart);
        if (Configuration.general().deadLockDetector()) {
            this._deadDetectThread = new DeadLockDetector();
            this._deadDetectThread.setDaemon(true);
            this._deadDetectThread.start();
        } else {
            this._deadDetectThread = null;
        }
        System.gc();
        long freeMem = (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 0x100000L;
        long totalMem = Runtime.getRuntime().maxMemory() / 0x100000L;
        LOG.info("Started, free memory {} Mb of {} Mb", (Object)freeMem, (Object)totalMem);
        Toolkit.getDefaultToolkit().beep();
        LoginServerThread.getInstance().start();
        SelectorConfig sc = new SelectorConfig();
        sc.MAX_READ_PER_PASS = Configuration.mmo().getMaxReadPerPass();
        sc.MAX_SEND_PER_PASS = Configuration.mmo().getMaxSendPerPass();
        sc.SLEEP_TIME = Configuration.mmo().getSleepTime();
        sc.HELPER_BUFFER_COUNT = Configuration.mmo().getHelperBufferCount();
        sc.TCP_NODELAY = Configuration.mmo().isTcpNoDelay();
        this._gamePacketHandler = new L2GamePacketHandler();
        this._selectorThread = new SelectorThread(sc, (MMOExecutor)this._gamePacketHandler, (PacketHandler)this._gamePacketHandler, (ClientFactory)this._gamePacketHandler, (AcceptFilter)new IPv4Filter());
        InetAddress bindAddress = null;
        if (!Configuration.server().getHost().equals("*")) {
            try {
                bindAddress = InetAddress.getByName(Configuration.server().getHost());
            }
            catch (UnknownHostException ex) {
                LOG.warn("Bind address is invalid, using all available IPs!", ex);
            }
        }
        try {
            this._selectorThread.openServerSocket(bindAddress, Configuration.server().getPort());
            this._selectorThread.start();
            LOG.info("Now listening on {}:{}", (Object)Configuration.server().getHost(), (Object)Configuration.server().getPort());
        }
        catch (IOException ex) {
            LOG.error("Failed to open server socket!", ex);
            System.exit(1);
        }
        if (Configuration.server().enableUPnP()) {
            GameServer.startTimedSection("UPnP");
            UPnPService.getInstance().load(Configuration.server().getPort(), "L2J Game Server");
        }
        if (Configuration.telnet().isEnabled()) {
            new Status(Configuration.telnet().getPort(), Configuration.telnet().getPassword()).start();
        } else {
            LOG.info("Telnet server is currently disabled.");
        }
        LOG.info("Maximum numbers of connected players {}.", (Object)Configuration.server().getMaxOnlineUsers());
        LOG.info("Server {} loaded in {} seconds.", (Object)ServerNameDAO.getServer((int)Configuration.hexId().getServerID()), (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - serverLoadStart));
    }

    public static void main(String[] args) throws Exception {
        String geodata;
        String scriptRoot;
        String datapackRoot = Util.parseArg((String[])args, (String)DATAPACK, (boolean)true);
        if (datapackRoot != null) {
            Configuration.server().setProperty("DatapackRoot", datapackRoot);
        }
        if ((scriptRoot = Util.parseArg((String[])args, (String)SCRIPT, (boolean)true)) != null) {
            Configuration.server().setProperty("ScriptRoot", scriptRoot);
        }
        if ((geodata = Util.parseArg((String[])args, (String)GEODATA, (boolean)true)) != null) {
            Configuration.geodata().setProperty("GeoDataPath", geodata);
        }
        gameServer = new GameServer();
    }

    public long getUsedMemoryMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public SelectorThread<L2GameClient> getSelectorThread() {
        return this._selectorThread;
    }

    public L2GamePacketHandler getL2GamePacketHandler() {
        return this._gamePacketHandler;
    }

    public DeadLockDetector getDeadLockDetectorThread() {
        return this._deadDetectThread;
    }

    public static long startTimedSection(String sectionName) {
        StringBuilder sBuilder = new StringBuilder("=[ " + sectionName + " ]");
        while (sBuilder.length() < 61) {
            sBuilder.insert(0, "-");
        }
        LOG.info(sBuilder.toString());
        return System.currentTimeMillis();
    }

    private static void endTimedSection(String sectionName, long startTime) {
        LOG.info("[ {} loaded in {}ms ]", (Object)sectionName, (Object)(System.currentTimeMillis() - startTime));
    }

    static {
        dateTimeServerStarted = Calendar.getInstance();
    }
}

