/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ItemsAutoDestroy {
    private final Map<Integer, L2ItemInstance> _items = new ConcurrentHashMap<Integer, L2ItemInstance>();

    protected ItemsAutoDestroy() {
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this::removeItems, 5000L, 5000L);
    }

    public static ItemsAutoDestroy getInstance() {
        return SingletonHolder._instance;
    }

    public synchronized void addItem(L2ItemInstance item) {
        item.setDropTime(System.currentTimeMillis());
        this._items.put(item.getObjectId(), item);
    }

    public synchronized void removeItems() {
        long curtime = System.currentTimeMillis();
        for (L2ItemInstance item : this._items.values()) {
            if (item == null) continue;
            if (item.getDropTime() == 0L || item.getItemLocation() != ItemLocation.VOID) {
                this._items.remove(item.getObjectId());
                continue;
            }
            if (item.getItem().getAutoDestroyTime() > 0) {
                if (curtime - item.getDropTime() <= (long)item.getItem().getAutoDestroyTime()) continue;
                L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
                L2World.getInstance().removeObject(item);
                this._items.remove(item.getObjectId());
                if (!Configuration.general().saveDroppedItem()) continue;
                ItemsOnGroundManager.getInstance().removeObject(item);
                continue;
            }
            if (item.getItem().hasExImmediateEffect()) {
                if (curtime - item.getDropTime() <= Configuration.general().getAutoDestroyHerbTime()) continue;
                L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
                L2World.getInstance().removeObject(item);
                this._items.remove(item.getObjectId());
                if (!Configuration.general().saveDroppedItem()) continue;
                ItemsOnGroundManager.getInstance().removeObject(item);
                continue;
            }
            long sleep = Configuration.general().getAutoDestroyDroppedItemAfter() == 0 ? 3600000 : Configuration.general().getAutoDestroyDroppedItemAfter() * 1000;
            if (curtime - item.getDropTime() <= sleep) continue;
            L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
            L2World.getInstance().removeObject(item);
            this._items.remove(item.getObjectId());
            if (!Configuration.general().saveDroppedItem()) continue;
            ItemsOnGroundManager.getInstance().removeObject(item);
        }
    }

    private static class SingletonHolder {
        protected static final ItemsAutoDestroy _instance = new ItemsAutoDestroy();

        private SingletonHolder() {
        }
    }
}

