/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.network.BaseSendablePacket;
import com.l2jserver.commons.security.crypt.NewCrypt;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.gameserverpackets.AuthRequest;
import com.l2jserver.gameserver.network.gameserverpackets.BlowFishKey;
import com.l2jserver.gameserver.network.gameserverpackets.ChangeAccessLevel;
import com.l2jserver.gameserver.network.gameserverpackets.ChangePassword;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerAuthRequest;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerInGame;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerLogout;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerTracert;
import com.l2jserver.gameserver.network.gameserverpackets.ReplyCharacters;
import com.l2jserver.gameserver.network.gameserverpackets.SendMail;
import com.l2jserver.gameserver.network.gameserverpackets.ServerStatus;
import com.l2jserver.gameserver.network.gameserverpackets.TempBan;
import com.l2jserver.gameserver.network.loginserverpackets.AuthResponse;
import com.l2jserver.gameserver.network.loginserverpackets.ChangePasswordResponse;
import com.l2jserver.gameserver.network.loginserverpackets.InitLS;
import com.l2jserver.gameserver.network.loginserverpackets.KickPlayer;
import com.l2jserver.gameserver.network.loginserverpackets.LoginServerFail;
import com.l2jserver.gameserver.network.loginserverpackets.PlayerAuthResponse;
import com.l2jserver.gameserver.network.loginserverpackets.RequestCharacters;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.network.serverpackets.LoginFail;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.mmocore.SendablePacket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServerThread
extends Thread {
    protected static final Logger LOG = LoggerFactory.getLogger(LoginServerThread.class);
    protected static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final int TEENAGER = 15;
    private static final int ADULT = 18;
    private final String _hostname;
    private final int _port;
    private final int _gamePort;
    private Socket _loginSocket;
    private OutputStream _out;
    private NewCrypt _blowfish;
    private final byte[] _hexID;
    private final boolean _acceptAlternate;
    private final int _requestID;
    private final boolean _reserveHost;
    private int _maxPlayer;
    private final List<WaitingClient> _waitingClients;
    private final Map<String, L2GameClient> _accountsInGameServer = new ConcurrentHashMap<String, L2GameClient>();
    private int _status;
    private String _serverName;
    private final List<String> _subnets;
    private final List<String> _hosts;

    protected LoginServerThread() {
        super("LoginServerThread");
        this._port = Configuration.server().getLoginPort();
        this._gamePort = Configuration.server().getPort();
        this._hostname = Configuration.server().getLoginHost();
        if (Configuration.hexId().getHexID() == null) {
            this._hexID = Util.generateHex((int)16);
            this._requestID = Configuration.server().getRequestServerId();
            Configuration.hexId().setProperty("ServerID", String.valueOf(this._requestID));
        } else {
            this._hexID = Configuration.hexId().getHexID().toByteArray();
            this._requestID = Configuration.hexId().getServerID();
        }
        this._acceptAlternate = Configuration.server().acceptAlternateId();
        this._reserveHost = Configuration.server().reserveHostOnLogin();
        this._subnets = Configuration.ip().getSubnets();
        this._hosts = Configuration.ip().getHosts();
        this._waitingClients = new CopyOnWriteArrayList<WaitingClient>();
        this._maxPlayer = Configuration.server().getMaxOnlineUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                LOG.info("Connecting to login server on {}:{}", (Object)this._hostname, (Object)this._port);
                this._loginSocket = new Socket(this._hostname, this._port);
                InputStream in = this._loginSocket.getInputStream();
                this._out = new BufferedOutputStream(this._loginSocket.getOutputStream());
                byte[] blowfishKey = Util.generateHex((int)40);
                if (blowfishKey[0] == 0) {
                    blowfishKey[0] = (byte)Rnd.get((int)32, (int)64);
                }
                this._blowfish = new NewCrypt("_;v.]05-31!|+-%xT!^[$\u0000");
                block36: while (!this.isInterrupted()) {
                    int lengthLo = in.read();
                    int lengthHi = in.read();
                    int length = lengthHi * 256 + lengthLo;
                    if (lengthHi < 0) {
                        LOG.info("LoginServerThread: Login terminated the connection.");
                        break;
                    }
                    byte[] incoming = new byte[length - 2];
                    int receivedBytes = 0;
                    int newBytes = 0;
                    int left = length - 2;
                    while (newBytes != -1 && receivedBytes < length - 2) {
                        newBytes = in.read(incoming, receivedBytes, left);
                        receivedBytes += newBytes;
                        left -= newBytes;
                    }
                    if (receivedBytes != length - 2) {
                        LOG.warn("Incomplete Packet is sent to the server, closing connection.(LS)");
                        break;
                    }
                    this._blowfish.decrypt(incoming, 0, incoming.length);
                    boolean checksumOk = NewCrypt.verifyChecksum((byte[])incoming);
                    if (!checksumOk) {
                        LOG.warn("Incorrect packet checksum, ignoring packet (LS)");
                        break;
                    }
                    int packetType = incoming[0] & 0xFF;
                    switch (packetType) {
                        case 0: {
                            RSAPublicKey publicKey;
                            InitLS init = new InitLS(incoming);
                            try {
                                KeyFactory kfac = KeyFactory.getInstance("RSA");
                                BigInteger modulus = new BigInteger(init.getRSAKey());
                                Iterator<L2PcInstance> kspec1 = new RSAPublicKeySpec(modulus, RSAKeyGenParameterSpec.F4);
                                publicKey = (RSAPublicKey)kfac.generatePublic((KeySpec)((Object)kspec1));
                            }
                            catch (GeneralSecurityException e) {
                                LOG.warn("Trouble while init the public key send by login");
                                break;
                            }
                            this.sendPacket(new BlowFishKey(blowfishKey, publicKey));
                            this._blowfish = new NewCrypt(blowfishKey);
                            this.sendPacket(new AuthRequest(this._requestID, this._acceptAlternate, this._hexID, this._gamePort, this._reserveHost, this._maxPlayer, this._subnets, this._hosts));
                            break;
                        }
                        case 1: {
                            LoginServerFail lsf = new LoginServerFail(incoming);
                            LOG.info("Damn! Registration Failed: {}", (Object)lsf.getReasonString());
                            break;
                        }
                        case 2: {
                            AuthResponse aresp = new AuthResponse(incoming);
                            int serverID = aresp.getServerId();
                            this._serverName = aresp.getServerName();
                            LoginServerThread.saveHexid(serverID, this.hexToString(this._hexID));
                            LOG.info("Registered on login as Server {}: {}", (Object)serverID, (Object)this._serverName);
                            ServerStatus st = new ServerStatus();
                            if (Configuration.general().getServerListBrackets()) {
                                st.addAttribute(3, 1);
                            } else {
                                st.addAttribute(3, 0);
                            }
                            st.addAttribute(2, Configuration.general().getServerListType());
                            if (Configuration.general().serverGMOnly()) {
                                st.addAttribute(1, 5);
                            } else {
                                st.addAttribute(1, 0);
                            }
                            if (Configuration.general().getServerListAge() == 15) {
                                st.addAttribute(5, 15);
                            } else if (Configuration.general().getServerListAge() == 18) {
                                st.addAttribute(5, 18);
                            } else {
                                st.addAttribute(5, 0);
                            }
                            this.sendPacket(st);
                            if (L2World.getInstance().getAllPlayersCount() <= 0) continue block36;
                            List<WaitingClient> playerList = new ArrayList<WaitingClient>();
                            for (L2PcInstance player : L2World.getInstance().getPlayers()) {
                                playerList.add((WaitingClient)((Object)player.getAccountName()));
                            }
                            this.sendPacket(new PlayerInGame(playerList));
                            break;
                        }
                        case 3: {
                            PlayerAuthResponse par = new PlayerAuthResponse(incoming);
                            String account = par.getAccount();
                            WaitingClient wcToRemove = null;
                            List<WaitingClient> playerList = this._waitingClients;
                            synchronized (playerList) {
                                for (WaitingClient wc : this._waitingClients) {
                                    if (!wc.account.equals(account)) continue;
                                    wcToRemove = wc;
                                }
                            }
                            if (wcToRemove == null) continue block36;
                            if (par.isAuthed()) {
                                PlayerInGame pig = new PlayerInGame(par.getAccount());
                                this.sendPacket(pig);
                                wcToRemove.gameClient.setState(L2GameClient.GameClientState.AUTHED);
                                wcToRemove.gameClient.setSessionId(wcToRemove.session);
                                CharSelectionInfo cl = new CharSelectionInfo(wcToRemove.account, wcToRemove.gameClient.getSessionId().playOkID1);
                                wcToRemove.gameClient.getConnection().sendPacket((SendablePacket)cl);
                                wcToRemove.gameClient.setCharSelection(cl.getCharInfo());
                            } else {
                                LOG.warn("Session key is not correct. Closing connection for account {}.", (Object)wcToRemove.account);
                                wcToRemove.gameClient.close(new LoginFail(1));
                                this._accountsInGameServer.remove(wcToRemove.account);
                            }
                            this._waitingClients.remove(wcToRemove);
                            break;
                        }
                        case 4: {
                            KickPlayer kp = new KickPlayer(incoming);
                            this.doKickPlayer(kp.getAccount());
                            break;
                        }
                        case 5: {
                            RequestCharacters rc = new RequestCharacters(incoming);
                            this.getCharsOnServer(rc.getAccount());
                            break;
                        }
                        case 6: {
                            new ChangePasswordResponse(incoming);
                        }
                    }
                }
            }
            catch (UnknownHostException e) {
                LOG.warn("Unknown host!", e);
            }
            catch (SocketException e) {
                LOG.warn("LoginServer not avaible, trying to reconnect...");
            }
            catch (IOException e) {
                LOG.warn("Disconnected from Login, Trying to reconnect!", e);
            }
            finally {
                try {
                    this._loginSocket.close();
                    if (this.isInterrupted()) {
                        return;
                    }
                }
                catch (Exception e) {}
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingClientAndSendRequest(String acc, L2GameClient client, SessionKey key) {
        WaitingClient wc = new WaitingClient(acc, client, key);
        List<WaitingClient> list = this._waitingClients;
        synchronized (list) {
            this._waitingClients.add(wc);
        }
        PlayerAuthRequest par = new PlayerAuthRequest(acc, key);
        try {
            this.sendPacket(par);
        }
        catch (IOException e) {
            LOG.warn("Error while sending player auth request!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaitingClient(L2GameClient client) {
        WaitingClient toRemove = null;
        List<WaitingClient> list = this._waitingClients;
        synchronized (list) {
            for (WaitingClient c : this._waitingClients) {
                if (c.gameClient != client) continue;
                toRemove = c;
            }
            if (toRemove != null) {
                this._waitingClients.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLogout(String account) {
        if (account == null) {
            return;
        }
        PlayerLogout pl = new PlayerLogout(account);
        try {
            this.sendPacket(pl);
        }
        catch (IOException e) {
            LOG.warn("Error while sending logout packet to login!");
        }
        finally {
            this._accountsInGameServer.remove(account);
        }
    }

    public boolean addGameServerLogin(String account, L2GameClient client) {
        return this._accountsInGameServer.putIfAbsent(account, client) == null;
    }

    public void sendAccessLevel(String account, int level) {
        ChangeAccessLevel cal = new ChangeAccessLevel(account, level);
        try {
            this.sendPacket(cal);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendClientTracert(String account, String[] address) {
        PlayerTracert ptc = new PlayerTracert(account, address[0], address[1], address[2], address[3], address[4]);
        try {
            this.sendPacket(ptc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMail(String account, String mailId, String ... args) {
        SendMail sem = new SendMail(account, mailId, args);
        try {
            this.sendPacket(sem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendTempBan(String account, String ip, long time) {
        TempBan tbn = new TempBan(account, ip, time);
        try {
            this.sendPacket(tbn);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String hexToString(byte[] hex) {
        return new BigInteger(hex).toString(16);
    }

    public void doKickPlayer(String account) {
        L2GameClient client = this._accountsInGameServer.get(account);
        if (client != null) {
            LOG_ACCOUNTING.warn("Kicked by login: {}", (Object)client);
            client.setAdditionalClosePacket(SystemMessage.getSystemMessage(SystemMessageId.ANOTHER_LOGIN_WITH_ACCOUNT));
            client.closeNow();
        }
    }

    private void getCharsOnServer(String account) {
        int chars = 0;
        ArrayList<Long> charToDel = new ArrayList<Long>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT deletetime FROM characters WHERE account_name=?");){
            ps.setString(1, account);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ++chars;
                    long delTime = rs.getLong("deletetime");
                    if (delTime == 0L) continue;
                    charToDel.add(delTime);
                }
            }
        }
        catch (SQLException e) {
            LOG.warn("Exception: getCharsOnServer!", e);
        }
        ReplyCharacters rec = new ReplyCharacters(account, chars, charToDel);
        try {
            this.sendPacket(rec);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(BaseSendablePacket sl) throws IOException {
        byte[] data = sl.getContent();
        NewCrypt.appendChecksum((byte[])data);
        this._blowfish.crypt(data, 0, data.length);
        int len = data.length + 2;
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.write(len & 0xFF);
            this._out.write(len >> 8 & 0xFF);
            this._out.write(data);
            this._out.flush();
        }
    }

    public void setMaxPlayer(int maxPlayer) {
        this.sendServerStatus(4, maxPlayer);
        this._maxPlayer = maxPlayer;
    }

    public int getMaxPlayer() {
        return this._maxPlayer;
    }

    public void sendServerStatus(int id, int value) {
        ServerStatus ss = new ServerStatus();
        ss.addAttribute(id, value);
        try {
            this.sendPacket(ss);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendServerType() {
        ServerStatus ss = new ServerStatus();
        ss.addAttribute(2, Configuration.general().getServerListType());
        try {
            this.sendPacket(ss);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendChangePassword(String accountName, String charName, String oldpass, String newpass) {
        ChangePassword cp = new ChangePassword(accountName, charName, oldpass, newpass);
        try {
            this.sendPacket(cp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getStatusString() {
        return ServerStatus.STATUS_STRING[this._status];
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerStatus(int status) {
        switch (status) {
            case 0: {
                this.sendServerStatus(1, 0);
                this._status = status;
                break;
            }
            case 4: {
                this.sendServerStatus(1, 4);
                this._status = status;
                break;
            }
            case 3: {
                this.sendServerStatus(1, 3);
                this._status = status;
                break;
            }
            case 5: {
                this.sendServerStatus(1, 5);
                this._status = status;
                break;
            }
            case 1: {
                this.sendServerStatus(1, 1);
                this._status = status;
                break;
            }
            case 2: {
                this.sendServerStatus(1, 2);
                this._status = status;
                break;
            }
            default: {
                throw new IllegalArgumentException("Status does not exists:" + status);
            }
        }
    }

    public L2GameClient getClient(String name) {
        return name != null ? this._accountsInGameServer.get(name) : null;
    }

    public static void saveHexid(int serverId, String hexId) {
        Path hexIdFilePath = Configuration.getCustomOrDefaultPath("hexid.txt");
        Configuration.hexId().setProperty("ServerID", String.valueOf(serverId));
        Configuration.hexId().setProperty("HexID", hexId);
        try {
            Files.createDirectories(hexIdFilePath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(hexIdFilePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                Configuration.hexId().store(out, "the hexID to auth into login");
                LOG.info("Saved {}.", (Object)hexIdFilePath);
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to save {}.", (Object)hexIdFilePath, (Object)ex);
        }
    }

    public static LoginServerThread getInstance() {
        return SingletonHolder._instance;
    }

    private static class WaitingClient {
        public String account;
        public L2GameClient gameClient;
        public SessionKey session;

        public WaitingClient(String acc, L2GameClient client, SessionKey key) {
            this.account = acc;
            this.gameClient = client;
            this.session = key;
        }
    }

    public static class SessionKey {
        public int playOkID1;
        public int playOkID2;
        public int loginOkID1;
        public int loginOkID2;

        public SessionKey(int loginOK1, int loginOK2, int playOK1, int playOK2) {
            this.playOkID1 = playOK1;
            this.playOkID2 = playOK2;
            this.loginOkID1 = loginOK1;
            this.loginOkID2 = loginOK2;
        }

        public String toString() {
            return "PlayOk: " + this.playOkID1 + " " + this.playOkID2 + " LoginOk:" + this.loginOkID1 + " " + this.loginOkID2;
        }
    }

    private static class SingletonHolder {
        protected static final LoginServerThread _instance = new LoginServerThread();

        private SingletonHolder() {
        }
    }
}

