/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.skills.Skill;

public class L2DoorAI
extends L2CharacterAI {
    public L2DoorAI(L2DoorInstance creature) {
        super(creature);
    }

    @Override
    protected void onIntentionIdle() {
    }

    @Override
    protected void onIntentionActive() {
    }

    @Override
    protected void onIntentionRest() {
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
    }

    @Override
    protected void onIntentionCast(Skill skill, L2Object target) {
    }

    @Override
    protected void onIntentionMoveTo(Location destination) {
    }

    @Override
    protected void onIntentionFollow(L2Character target) {
    }

    @Override
    protected void onIntentionPickUp(L2Object item) {
    }

    @Override
    protected void onIntentionInteract(L2Object object) {
    }

    @Override
    protected void onEvtThink() {
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        ThreadPoolManager.getInstance().executeGeneral(new onEventAttackedDoorTask((L2DoorInstance)this._actor, attacker));
    }

    @Override
    protected void onEvtAggression(L2Character target, long aggro) {
    }

    @Override
    protected void onEvtStunned(L2Character attacker) {
    }

    @Override
    protected void onEvtSleeping(L2Character attacker) {
    }

    @Override
    protected void onEvtRooted(L2Character attacker) {
    }

    @Override
    protected void onEvtReadyToAct() {
    }

    @Override
    protected void onEvtUserCmd(Object arg0, Object arg1) {
    }

    @Override
    protected void onEvtArrived() {
    }

    @Override
    protected void onEvtArrivedRevalidate() {
    }

    @Override
    protected void onEvtArrivedBlocked(Location blocked_at_loc) {
    }

    @Override
    protected void onEvtForgetObject(L2Object object) {
    }

    @Override
    protected void onEvtCancel() {
    }

    @Override
    protected void onEvtDead() {
    }

    private class onEventAttackedDoorTask
    implements Runnable {
        private final L2DoorInstance _door;
        private final L2Character _attacker;

        public onEventAttackedDoorTask(L2DoorInstance door, L2Character attacker) {
            this._door = door;
            this._attacker = attacker;
        }

        @Override
        public void run() {
            for (L2DefenderInstance guard : this._door.getKnownDefenders()) {
                if (!L2DoorAI.this._actor.isInsideRadius(guard, guard.getTemplate().getClanHelpRange(), false, true) || Math.abs(this._attacker.getZ() - guard.getZ()) >= 200) continue;
                guard.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this._attacker, 15);
            }
        }
    }
}

