/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.config;

import com.l2jserver.gameserver.config.converter.ClassMasterSetting;
import com.l2jserver.gameserver.config.converter.ClassMasterSettingConverter;
import com.l2jserver.gameserver.config.converter.Days2MillisecondsConverter;
import com.l2jserver.gameserver.config.converter.MapIntegerIntegerConverter;
import com.l2jserver.gameserver.config.converter.PatternConverter;
import com.l2jserver.gameserver.config.converter.Seconds2MillisecondsConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Reloadable;

@Config.Sources(value={"file:${L2J_HOME}/custom/game/config/character.properties", "file:./config/character.properties", "classpath:config/character.properties"})
@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.HotReload(value=5L, unit=TimeUnit.MINUTES, type=Config.HotReloadType.ASYNC)
public interface CharacterConfiguration
extends Reloadable {
    @Config.Key(value="Delevel")
    public boolean delevel();

    @Config.Key(value="DecreaseSkillOnDelevel")
    public boolean decreaseSkillOnDelevel();

    @Config.Key(value="WeightLimit")
    public int getWeightLimit();

    @Config.Key(value="RunSpeedBoost")
    public int getRunSpeedBoost();

    @Config.Key(value="DeathPenaltyChance")
    public int getDeathPenaltyChance();

    @Config.Key(value="RespawnRestoreCP")
    public double getRespawnRestoreCP();

    @Config.Key(value="RespawnRestoreHP")
    public double getRespawnRestoreHP();

    @Config.Key(value="RespawnRestoreMP")
    public double getRespawnRestoreMP();

    @Config.Key(value="HpRegenMultiplier")
    public double getHpRegenMultiplier();

    @Config.Key(value="MpRegenMultiplier")
    public double getMpRegenMultiplier();

    @Config.Key(value="CpRegenMultiplier")
    public double getCpRegenMultiplier();

    @Config.Key(value="ModifySkillDuration")
    public boolean modifySkillDuration();

    @Config.Key(value="SkillDuration")
    @Config.ConverterClass(value=MapIntegerIntegerConverter.class)
    public Map<Integer, Integer> getSkillDuration();

    @Config.Key(value="ModifySkillReuse")
    public boolean modifySkillReuse();

    @Config.Key(value="SkillReuse")
    @Config.ConverterClass(value=MapIntegerIntegerConverter.class)
    public Map<Integer, Integer> getSkillReuse();

    @Config.Key(value="AutoLearnSkills")
    public boolean autoLearnSkills();

    @Config.Key(value="AutoLearnForgottenScrollSkills")
    public boolean autoLearnForgottenScrollSkills();

    @Config.Key(value="AutoLootHerbs")
    public boolean autoLootHerbs();

    @Config.Key(value="MaxBuffAmount")
    public int getMaxBuffAmount();

    @Config.Key(value="MaxTriggeredBuffAmount")
    public int getMaxTriggeredBuffAmount();

    @Config.Key(value="MaxDanceAmount")
    public int getMaxDanceAmount();

    @Config.Key(value="DanceCancelBuff")
    public boolean danceCancelBuff();

    @Config.Key(value="DanceConsumeAdditionalMP")
    public boolean danceConsumeAdditionalMP();

    @Config.Key(value="StoreDances")
    public boolean storeDances();

    @Config.Key(value="AutoLearnDivineInspiration")
    public boolean autoLearnDivineInspiration();

    @Config.Key(value="CancelByHit")
    public String cancelByHit();

    default public boolean cancelBow() {
        return this.cancelByHit().equalsIgnoreCase("all") || this.cancelByHit().equalsIgnoreCase("bow");
    }

    default public boolean cancelCast() {
        return this.cancelByHit().equalsIgnoreCase("all") || this.cancelByHit().equalsIgnoreCase("cast");
    }

    @Config.Key(value="MagicFailures")
    public boolean magicFailures();

    @Config.Key(value="PlayerFakeDeathUpProtection")
    public int getPlayerFakeDeathUpProtection();

    @Config.Key(value="StoreSkillCooltime")
    public boolean storeSkillCooltime();

    @Config.Key(value="SubclassStoreSkillCooltime")
    public boolean subclassStoreSkillCooltime();

    @Config.Key(value="ShieldBlocks")
    public boolean shieldBlocks();

    @Config.Key(value="PerfectShieldBlockRate")
    public int getPerfectShieldBlockRate();

    @Config.Key(value="EffectTickRatio")
    public int getEffectTickRatio();

    @Config.Key(value="AllowClassMasters")
    public boolean allowClassMasters();

    @Config.Key(value="ConfigClassMaster")
    @Config.ConverterClass(value=ClassMasterSettingConverter.class)
    public ClassMasterSetting getClassMaster();

    @Config.Key(value="AllowEntireTree")
    public boolean allowEntireTree();

    @Config.Key(value="AlternateClassMaster")
    public boolean alternateClassMaster();

    @Config.Key(value="LifeCrystalNeeded")
    public boolean lifeCrystalNeeded();

    @Config.Key(value="EnchantSkillSpBookNeeded")
    public boolean enchantSkillSpBookNeeded();

    @Config.Key(value="DivineInspirationSpBookNeeded")
    public boolean divineInspirationSpBookNeeded();

    @Config.Key(value="SkillLearn")
    public boolean skillLearn();

    @Config.Key(value="SubclassWithoutQuests")
    public boolean subclassWithoutQuests();

    @Config.Key(value="SubclassEverywhere")
    public boolean subclassEverywhere();

    @Config.Key(value="TransformationWithoutQuest")
    public boolean transformationWithoutQuest();

    @Config.Key(value="FeeDeleteTransferSkills")
    public int getFeeDeleteTransferSkills();

    @Config.Key(value="FeeDeleteSubClassSkills")
    public int getFeeDeleteSubClassSkills();

    @Config.Key(value="SummonStoreSkillCooltime")
    public boolean summonStoreSkillCooltime();

    @Config.Key(value="RestoreServitorOnReconnect")
    public boolean restoreServitorOnReconnect();

    @Config.Key(value="RestorePetOnReconnect")
    public boolean restorePetOnReconnect();

    @Config.Key(value="MaxExpBonus")
    public double getMaxExpBonus();

    @Config.Key(value="MaxSpBonus")
    public double getMaxSpBonus();

    @Config.Key(value="MaxRunSpeed")
    public int getMaxRunSpeed();

    @Config.Key(value="MaxPCritRate")
    public int getMaxPCritRate();

    @Config.Key(value="MaxMCritRate")
    public int getMaxMCritRate();

    @Config.Key(value="MaxPAtkSpeed")
    public int getMaxPAtkSpeed();

    @Config.Key(value="MaxMAtkSpeed")
    public int getMaxMAtkSpeed();

    @Config.Key(value="MaxEvasion")
    public int getMaxEvasion();

    @Config.Key(value="MinAbnormalStateSuccessRate")
    public int getMinAbnormalStateSuccessRate();

    @Config.Key(value="MaxAbnormalStateSuccessRate")
    public int getMaxAbnormalStateSuccessRate();

    @Config.Key(value="MaxPlayerLevel")
    public int getMaxPlayerLevel();

    @Config.Key(value="MaxPetLevel")
    public int getMaxPetLevel();

    @Config.Key(value="MaxSubclass")
    public int getMaxSubclass();

    @Config.Key(value="BaseSubclassLevel")
    public int getBaseSubclassLevel();

    @Config.Key(value="MaxSubclassLevel")
    public int getMaxSubclassLevel();

    @Config.Key(value="MaxPvtStoreSellSlotsDwarf")
    public int getMaxPvtStoreSellSlotsDwarf();

    @Config.Key(value="MaxPvtStoreSellSlotsOther")
    public int getMaxPvtStoreSellSlotsOther();

    @Config.Key(value="MaxPvtStoreBuySlotsDwarf")
    public int getMaxPvtStoreBuySlotsDwarf();

    @Config.Key(value="MaxPvtStoreBuySlotsOther")
    public int getMaxPvtStoreBuySlotsOther();

    @Config.Key(value="MaximumSlotsForNoDwarf")
    public int getMaximumSlotsForNoDwarf();

    @Config.Key(value="MaximumSlotsForDwarf")
    public int getMaximumSlotsForDwarf();

    @Config.Key(value="MaximumSlotsForGMPlayer")
    public int getMaximumSlotsForGMPlayer();

    @Config.Key(value="MaximumSlotsForQuestItems")
    public int getMaximumSlotsForQuestItems();

    @Config.Key(value="MaximumWarehouseSlotsForDwarf")
    public int getMaximumWarehouseSlotsForDwarf();

    @Config.Key(value="MaximumWarehouseSlotsForNoDwarf")
    public int getMaximumWarehouseSlotsForNoDwarf();

    @Config.Key(value="MaximumWarehouseSlotsForClan")
    public int getMaximumWarehouseSlotsForClan();

    @Config.Key(value="MaximumFreightSlots")
    public int getMaximumFreightSlots();

    @Config.Key(value="FreightPrice")
    public int getFreightPrice();

    @Config.Key(value="NpcTalkBlockingTime")
    public int getNpcTalkBlockingTime();

    @Config.Key(value="FriendListLimit")
    public int getFriendListLimit();

    @Config.Key(value="BlockListLimit")
    public int getBlockListLimit();

    @Config.Key(value="EnchantChanceElementStone")
    public int getEnchantChanceElementStone();

    @Config.Key(value="EnchantChanceElementCrystal")
    public int getEnchantChanceElementCrystal();

    @Config.Key(value="EnchantChanceElementJewel")
    public int getEnchantChanceElementJewel();

    @Config.Key(value="EnchantChanceElementEnergy")
    public int getEnchantChanceElementEnergy();

    @Config.Key(value="EnchantBlacklist")
    public Set<Integer> getEnchantBlacklist();

    @Config.Key(value="AugmentationNGSkillChance")
    public int getAugmentationNGSkillChance();

    @Config.Key(value="AugmentationMidSkillChance")
    public int getAugmentationMidSkillChance();

    @Config.Key(value="AugmentationHighSkillChance")
    public int getAugmentationHighSkillChance();

    @Config.Key(value="AugmentationTopSkillChance")
    public int getAugmentationTopSkillChance();

    @Config.Key(value="AugmentationAccSkillChance")
    public int getAugmentationAccSkillChance();

    @Config.Key(value="AugmentationBaseStatChance")
    public int getAugmentationBaseStatChance();

    @Config.Key(value="AugmentationNGGlowChance")
    public int getAugmentationNGGlowChance();

    @Config.Key(value="AugmentationMidGlowChance")
    public int getAugmentationMidGlowChance();

    @Config.Key(value="AugmentationHighGlowChance")
    public int getAugmentationHighGlowChance();

    @Config.Key(value="AugmentationTopGlowChance")
    public int getAugmentationTopGlowChance();

    @Config.Key(value="RetailLikeAugmentation")
    public boolean retailLikeAugmentation();

    @Config.Key(value="RetailLikeAugmentationNoGradeChance")
    public List<Integer> getRetailLikeAugmentationNoGradeChance();

    @Config.Key(value="RetailLikeAugmentationMidGradeChance")
    public List<Integer> getRetailLikeAugmentationMidGradeChance();

    @Config.Key(value="RetailLikeAugmentationHighGradeChance")
    public List<Integer> getRetailLikeAugmentationHighGradeChance();

    @Config.Key(value="RetailLikeAugmentationTopGradeChance")
    public List<Integer> getRetailLikeAugmentationTopGradeChance();

    @Config.Key(value="RetailLikeAugmentationAccessory")
    public boolean retailLikeAugmentationAccessory();

    @Config.Key(value="AugmentationBlacklist")
    public Set<Integer> getAugmentationBlacklist();

    @Config.Key(value="AllowAugmentPvPItems")
    public boolean allowAugmentPvPItems();

    @Config.Key(value="KarmaPlayerCanBeKilledInPeaceZone")
    public boolean karmaPlayerCanBeKilledInPeaceZone();

    @Config.Key(value="KarmaPlayerCanUseGK")
    public boolean karmaPlayerCanUseGK();

    @Config.Key(value="KarmaPlayerCanTeleport")
    public boolean karmaPlayerCanTeleport();

    @Config.Key(value="KarmaPlayerCanShop")
    public boolean karmaPlayerCanShop();

    @Config.Key(value="KarmaPlayerCanTrade")
    public boolean karmaPlayerCanTrade();

    @Config.Key(value="KarmaPlayerCanUseWareHouse")
    public boolean karmaPlayerCanUseWareHouse();

    @Config.Key(value="MaxPersonalFamePoints")
    public int getMaxPersonalFamePoints();

    @Config.Key(value="FortressZoneFameTaskFrequency")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getFortressZoneFameTaskFrequency();

    @Config.Key(value="FortressZoneFameAcquirePoints")
    public int getFortressZoneFameAcquirePoints();

    @Config.Key(value="CastleZoneFameTaskFrequency")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getCastleZoneFameTaskFrequency();

    @Config.Key(value="CastleZoneFameAcquirePoints")
    public int getCastleZoneFameAcquirePoints();

    @Config.Key(value="FameForDeadPlayers")
    public boolean fameForDeadPlayers();

    @Config.Key(value="Crafting")
    public boolean crafting();

    @Config.Key(value="CraftMasterwork")
    public boolean craftMasterwork();

    @Config.Key(value="DwarfRecipeLimit")
    public int getDwarfRecipeLimit();

    @Config.Key(value="CommonRecipeLimit")
    public int getCommonRecipeLimit();

    @Config.Key(value="AlternativeCrafting")
    public boolean alternativeCrafting();

    @Config.Key(value="CraftingSpeed")
    public double getCraftingSpeed();

    @Config.Key(value="CraftingXpRate")
    public double getCraftingXpRate();

    @Config.Key(value="CraftingSpRate")
    public double getCraftingSpRate();

    @Config.Key(value="CraftingRareXpRate")
    public double getCraftingRareXpRate();

    @Config.Key(value="CraftingRareSpRate")
    public double getCraftingRareSpRate();

    @Config.Key(value="BlacksmithUseRecipes")
    public boolean blacksmithUseRecipes();

    @Config.Key(value="StoreRecipeShopList")
    public boolean storeRecipeShopList();

    @Config.Key(value="ClanLeaderDateChange")
    public int getClanLeaderDateChange();

    @Config.Key(value="ClanLeaderHourChange")
    public String getClanLeaderHourChange();

    @Config.Key(value="ClanLeaderInstantActivation")
    public boolean clanLeaderInstantActivation();

    @Config.Key(value="DaysBeforeJoinAClan")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeJoinAClan();

    @Config.Key(value="DaysBeforeCreateAClan")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeCreateAClan();

    @Config.Key(value="DaysToPassToDissolveAClan")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysToPassToDissolveAClan();

    @Config.Key(value="DaysBeforeJoiningAllianceAfterLeaving")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeJoiningAllianceAfterLeaving();

    @Config.Key(value="DaysBeforeJoinAllyWhenDismissed")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeJoinAllyWhenDismissed();

    @Config.Key(value="DaysBeforeAcceptNewClanWhenDismissed")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeAcceptNewClanWhenDismissed();

    @Config.Key(value="DaysBeforeCreateNewAllyWhenDissolved")
    @Config.ConverterClass(value=Days2MillisecondsConverter.class)
    public long getDaysBeforeCreateNewAllyWhenDissolved();

    @Config.Key(value="MaxNumOfClansInAlly")
    public int getMaxNumOfClansInAlly();

    @Config.Key(value="MembersCanWithdrawFromClanWH")
    public boolean membersCanWithdrawFromClanWH();

    @Config.Key(value="RemoveCastleCirclets")
    public boolean removeCastleCirclets();

    @Config.Key(value="ClanMembersForWar")
    public int getClanMembersForWar();

    @Config.Key(value="PartyRange")
    public int getPartyRange();

    @Config.Key(value="PartyRange2")
    public int getPartyRange2();

    @Config.Key(value="PartyEvenlyDistributeAllStackableItems")
    public boolean getPartyEvenlyDistributeAllStackableItems();

    @Config.Key(value="PartyEvenlyDistributeAllOtherItems")
    public boolean getPartyEvenlyDistributeAllOtherItems();

    @Config.Key(value="PartyEvenlyDistributeItems")
    public List<Integer> getPartyEvenlyDistributeItems();

    @Config.Key(value="LeavePartyLeader")
    public boolean leavePartyLeader();

    @Config.Key(value="InitialEquipmentEvent")
    public boolean initialEquipmentEvent();

    @Config.Key(value="StartingAdena")
    public int getStartingAdena();

    @Config.Key(value="StartingLevel")
    public int getStartingLevel();

    @Config.Key(value="StartingSP")
    public int getStartingSP();

    @Config.Key(value="MaxAdena")
    public long getMaxAdena();

    @Config.Key(value="AutoLoot")
    public boolean autoLoot();

    @Config.Key(value="AutoLootRaids")
    public boolean autoLootRaids();

    @Config.Key(value="RaidLootRightsInterval")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getRaidLootRightsInterval();

    @Config.Key(value="RaidLootRightsCCSize")
    public int getRaidLootRightsCCSize();

    @Config.Key(value="UnstuckInterval")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getUnstuckInterval();

    @Config.Key(value="TeleportWatchdogTimeout")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getTeleportWatchdogTimeout();

    @Config.Key(value="PlayerSpawnProtection")
    public int getPlayerSpawnProtection();

    @Config.Key(value="PlayerSpawnProtectionAllowedItems")
    public Set<Integer> getPlayerSpawnProtectionAllowedItems();

    @Config.Key(value="PlayerTeleportProtection")
    public int getPlayerTeleportProtection();

    @Config.Key(value="RandomRespawnInTown")
    public boolean randomRespawnInTown();

    @Config.Key(value="OffsetOnTeleport")
    public boolean offsetOnTeleport();

    @Config.Key(value="MaxOffsetOnTeleport")
    public int getMaxOffsetOnTeleport();

    @Config.Key(value="PetitioningAllowed")
    public boolean petitioningAllowed();

    @Config.Key(value="MaxPetitionsPerPlayer")
    public int getMaxPetitionsPerPlayer();

    @Config.Key(value="MaxPetitionsPending")
    public int getMaxPetitionsPending();

    @Config.Key(value="FreeTeleporting")
    public boolean freeTeleporting();

    @Config.Key(value="DeleteCharAfterDays")
    public int getDeleteCharAfterDays();

    @Config.Key(value="ExponentXp")
    public int getExponentXp();

    @Config.Key(value="ExponentSp")
    public int getExponentSp();

    @Config.Key(value="PartyXpCutoffMethod")
    public String getPartyXpCutoffMethod();

    @Config.Key(value="PartyXpCutoffPercent")
    public double getPartyXpCutoffPercent();

    @Config.Key(value="PartyXpCutoffLevel")
    public int getPartyXpCutoffLevel();

    @Config.Key(value="PartyXpCutoffGaps")
    @Config.ConverterClass(value=MapIntegerIntegerConverter.class)
    public Map<Integer, Integer> getPartyXpCutoffGaps();

    @Config.Key(value="PartyXpCutoffGapPercent")
    public List<Integer> getPartyXpCutoffGapPercent();

    @Config.Key(value="Tutorial")
    public boolean tutorial();

    @Config.Key(value="ExpertisePenalty")
    public boolean expertisePenalty();

    @Config.Key(value="StoreUISettings")
    public boolean storeUISettings();

    @Config.Key(value="SilenceModeExclude")
    public boolean silenceModeExclude();

    @Config.Key(value="ValidateTriggerSkills")
    public boolean validateTriggerSkills();

    @Config.Key(value="PlayerNameTemplate")
    @Config.ConverterClass(value=PatternConverter.class)
    public Pattern getPlayerNameTemplate();

    @Config.Key(value="PetNameTemplate")
    @Config.ConverterClass(value=PatternConverter.class)
    public Pattern getPetNameTemplate();

    @Config.Key(value="ForbiddenNames")
    public Set<String> getForbiddenNames();

    @Config.Key(value="CharMaxNumber")
    public int getCharMaxNumber();
}

