/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.PetSkillSaveDAO;
import com.l2jserver.gameserver.data.sql.impl.SummonEffectsTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetSkillSaveDAOMySQL
implements PetSkillSaveDAO {
    private static final Logger LOG = LoggerFactory.getLogger(PetSkillSaveDAOMySQL.class);
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_pet_skills_save (petObjItemId,skill_id,skill_level,remaining_time,buff_index) VALUES (?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT petObjItemId,skill_id,skill_level,remaining_time,buff_index FROM character_pet_skills_save WHERE petObjItemId=? ORDER BY buff_index";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_pet_skills_save WHERE petObjItemId=?";

    @Override
    public void insert(L2PetInstance pet, boolean storeEffects) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement(DELETE_SKILL_SAVE);
             PreparedStatement ps2 = con.prepareStatement(ADD_SKILL_SAVE);){
            ps1.setInt(1, pet.getControlObjectId());
            ps1.execute();
            int buff_index = 0;
            LinkedList<Integer> storedSkills = new LinkedList<Integer>();
            if (storeEffects) {
                for (BuffInfo info : pet.getEffectList().getEffects()) {
                    Skill skill;
                    if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Configuration.character().storeDances() || storedSkills.contains(skill.getReuseHashCode())) continue;
                    storedSkills.add(skill.getReuseHashCode());
                    ps2.setInt(1, pet.getControlObjectId());
                    ps2.setInt(2, skill.getId());
                    ps2.setInt(3, skill.getLevel());
                    ps2.setInt(4, info.getTime());
                    ps2.setInt(5, ++buff_index);
                    ps2.execute();
                    SummonEffectsTable.getInstance().addPetEffect(pet.getControlObjectId(), skill, info.getTime());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not store pet effect data!", e);
        }
    }

    @Override
    public void load(L2PetInstance pet) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement(RESTORE_SKILL_SAVE);
             PreparedStatement ps2 = con.prepareStatement(DELETE_SKILL_SAVE);){
            if (!SummonEffectsTable.getInstance().containsPetId(pet.getControlObjectId())) {
                ps1.setInt(1, pet.getControlObjectId());
                try (ResultSet rs = ps1.executeQuery();){
                    while (rs.next()) {
                        int effectCurTime = rs.getInt("remaining_time");
                        Skill skill = SkillData.getInstance().getSkill(rs.getInt("skill_id"), rs.getInt("skill_level"));
                        if (skill == null || !skill.hasEffects(EffectScope.GENERAL)) continue;
                        SummonEffectsTable.getInstance().addPetEffect(pet.getControlObjectId(), skill, effectCurTime);
                    }
                }
            }
            ps2.setInt(1, pet.getControlObjectId());
            ps2.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not restore {} active effect data!", (Object)pet, (Object)e);
        }
    }
}

