/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.PlayerSkillSaveDAO;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.TimeStamp;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerSkillSaveDAOMySQLImpl
implements PlayerSkillSaveDAO {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerSkillSaveDAOMySQLImpl.class);
    private static final String INSERT = "INSERT INTO character_skills_save (charId,skill_id,skill_level,remaining_time,reuse_delay,systime,restore_type,class_index,buff_index) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SELECT = "SELECT skill_id,skill_level,remaining_time, reuse_delay, systime, restore_type FROM character_skills_save WHERE charId=? AND class_index=? ORDER BY buff_index";
    private static final String DELETE = "DELETE FROM character_skills_save WHERE charId=? AND class_index=?";

    @Override
    public void delete(L2PcInstance player, int classIndex) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, classIndex);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Could not delete all effect data for player {}!", (Object)player, (Object)ex);
        }
    }

    @Override
    public void delete(L2PcInstance player) {
        this.delete(player, player.getClassIndex());
    }

    @Override
    public void insert(L2PcInstance player, boolean storeEffects) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            Map<Integer, TimeStamp> reuseTimeStamps;
            int buff_index = 0;
            ArrayList<Integer> storedSkills = new ArrayList<Integer>();
            if (storeEffects) {
                for (BuffInfo info : player.getEffectList().getEffects()) {
                    Skill skill;
                    if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Configuration.character().storeDances() || storedSkills.contains(skill.getReuseHashCode())) continue;
                    storedSkills.add(skill.getReuseHashCode());
                    ps.setInt(1, player.getObjectId());
                    ps.setInt(2, skill.getId());
                    ps.setInt(3, skill.getLevel());
                    ps.setInt(4, info.getTime());
                    TimeStamp t = player.getSkillReuseTimeStamp(skill.getReuseHashCode());
                    ps.setLong(5, t != null && t.hasNotPassed() ? t.getReuse() : 0L);
                    ps.setLong(6, t != null && t.hasNotPassed() ? t.getStamp() : 0L);
                    ps.setInt(7, 0);
                    ps.setInt(8, player.getClassIndex());
                    ps.setInt(9, ++buff_index);
                    ps.execute();
                }
            }
            if ((reuseTimeStamps = player.getSkillReuseTimeStamps()) != null) {
                for (Map.Entry<Integer, TimeStamp> ts : reuseTimeStamps.entrySet()) {
                    TimeStamp t;
                    int hash = ts.getKey();
                    if (storedSkills.contains(hash) || (t = ts.getValue()) == null || !t.hasNotPassed()) continue;
                    storedSkills.add(hash);
                    ps.setInt(1, player.getObjectId());
                    ps.setInt(2, t.getSkillId());
                    ps.setInt(3, t.getSkillLvl());
                    ps.setInt(4, -1);
                    ps.setLong(5, t.getReuse());
                    ps.setLong(6, t.getStamp());
                    ps.setInt(7, 1);
                    ps.setInt(8, player.getClassIndex());
                    ps.setInt(9, ++buff_index);
                    ps.execute();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not store {} effect data!", (Object)player, (Object)e);
        }
    }

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, player.getClassIndex());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int remainingTime = rs.getInt("remaining_time");
                    long reuseDelay = rs.getLong("reuse_delay");
                    long systime = rs.getLong("systime");
                    int restoreType = rs.getInt("restore_type");
                    Skill skill = SkillData.getInstance().getSkill(rs.getInt("skill_id"), rs.getInt("skill_level"));
                    if (skill == null) continue;
                    long time = systime - System.currentTimeMillis();
                    if (time > 10L) {
                        player.disableSkill(skill, time);
                        player.addTimeStamp(skill, reuseDelay, systime);
                    }
                    if (restoreType > 0) continue;
                    skill.applyEffects(player, player, false, remainingTime);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not restore {} active effect data!", (Object)player, (Object)e);
        }
    }
}

