/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.SubclassDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.SubClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubclassDAOMySQLImpl
implements SubclassDAO {
    private static final Logger LOG = LoggerFactory.getLogger(SubclassDAOMySQLImpl.class);
    private static final String SELECT = "SELECT class_id,exp,sp,level,class_index FROM character_subclasses WHERE charId=? ORDER BY class_index";
    private static final String INSERT = "INSERT INTO character_subclasses (charId,class_id,exp,sp,level,class_index) VALUES (?,?,?,?,?,?)";
    private static final String UPDATE = "UPDATE character_subclasses SET exp=?,sp=?,level=?,class_id=? WHERE charId=? AND class_index =?";
    private static final String DELETE = "DELETE FROM character_subclasses WHERE charId=? AND class_index=?";

    @Override
    public void update(L2PcInstance player) {
        if (player.getTotalSubClasses() <= 0) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE);){
            for (SubClass subClass : player.getSubClasses().values()) {
                ps.setLong(1, subClass.getExp());
                ps.setInt(2, subClass.getSp());
                ps.setInt(3, subClass.getLevel());
                ps.setInt(4, subClass.getClassId());
                ps.setInt(5, player.getObjectId());
                ps.setInt(6, subClass.getClassIndex());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            LOG.error("Could not store sub class data for {} : {}", (Object)player, (Object)e);
        }
    }

    @Override
    public boolean insert(L2PcInstance player, SubClass newClass) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, newClass.getClassId());
            ps.setLong(3, newClass.getExp());
            ps.setInt(4, newClass.getSp());
            ps.setInt(5, newClass.getLevel());
            ps.setInt(6, newClass.getClassIndex());
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Could not add character sub class for {}, {}", (Object)player, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public void delete(L2PcInstance player, int classIndex) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, classIndex);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Could not delete subclass for {} to class index {}, {}", player, classIndex, e);
        }
    }

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    SubClass subClass = new SubClass(player);
                    subClass.setClassId(rs.getInt("class_id"));
                    subClass.setExp(rs.getLong("exp"));
                    subClass.setLevel(rs.getInt("level"));
                    subClass.setSp(rs.getInt("sp"));
                    subClass.setClassIndex(rs.getInt("class_index"));
                    player.getSubClasses().put(subClass.getClassIndex(), subClass);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not restore classes for {}, {}", (Object)player, (Object)e);
        }
    }
}

