/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.TeleportBookmarkDAO;
import com.l2jserver.gameserver.model.TeleportBookmark;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeleportBookmarkDAOMySQLImpl
implements TeleportBookmarkDAO {
    private static final Logger LOG = LoggerFactory.getLogger(TeleportBookmarkDAOMySQLImpl.class);
    private static final String INSERT = "INSERT INTO character_tpbookmark (charId,Id,x,y,z,icon,tag,name) values (?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "UPDATE character_tpbookmark SET icon=?,tag=?,name=? where charId=? AND Id=?";
    private static final String SELECT = "SELECT Id,x,y,z,icon,tag,name FROM character_tpbookmark WHERE charId=?";
    private static final String DELETE = "DELETE FROM character_tpbookmark WHERE charId=? AND Id=?";

    @Override
    public void delete(L2PcInstance player, int id) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, id);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Could not delete character teleport bookmark data!", ex);
        }
    }

    @Override
    public void insert(L2PcInstance player, int id, int x, int y, int z, int icon, String tag, String name) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, id);
            ps.setInt(3, x);
            ps.setInt(4, y);
            ps.setInt(5, z);
            ps.setInt(6, icon);
            ps.setString(7, tag);
            ps.setString(8, name);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("Could not insert character teleport bookmark data!", ex);
        }
    }

    @Override
    public void update(L2PcInstance player, int id, int icon, String tag, String name) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE);){
            ps.setInt(1, icon);
            ps.setString(2, tag);
            ps.setString(3, name);
            ps.setInt(4, player.getObjectId());
            ps.setInt(5, id);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Could not update character teleport bookmark data!", ex);
        }
    }

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    player.getTpbookmarks().put(rs.getInt("Id"), new TeleportBookmark(rs.getInt("Id"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("icon"), rs.getString("tag"), rs.getString("name")));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed restoring character teleport bookmark!", ex);
        }
    }
}

