/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharNameTable {
    private static final Logger LOG = LoggerFactory.getLogger(CharNameTable.class);
    private final Map<Integer, String> _chars = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, Integer> _accessLevels = new ConcurrentHashMap<Integer, Integer>();

    protected CharNameTable() {
        if (Configuration.general().cacheCharNames()) {
            this.loadAll();
        }
    }

    public final void addName(L2PcInstance player) {
        if (player != null) {
            this.addName(player.getObjectId(), player.getName());
            this._accessLevels.put(player.getObjectId(), player.getAccessLevel().getLevel());
        }
    }

    private void addName(int objectId, String name) {
        if (name != null && !name.equals(this._chars.get(objectId))) {
            this._chars.put(objectId, name);
        }
    }

    public final void removeName(int objId) {
        this._chars.remove(objId);
        this._accessLevels.remove(objId);
    }

    public final int getIdByName(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        for (Map.Entry<Integer, String> entry : this._chars.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        if (Configuration.general().cacheCharNames()) {
            return -1;
        }
        int id = -1;
        int accessLevel = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT charId,accesslevel FROM characters WHERE char_name=?");){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    id = rs.getInt(1);
                    accessLevel = rs.getInt(2);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check existing char name!", ex);
        }
        if (id > 0) {
            this._chars.put(id, name);
            this._accessLevels.put(id, accessLevel);
            return id;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getNameById(int id) {
        if (id <= 0) {
            return null;
        }
        String name = this._chars.get(id);
        if (name != null) {
            return name;
        }
        if (Configuration.general().cacheCharNames()) {
            return null;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT char_name,accesslevel FROM characters WHERE charId=?");){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                name = rs.getString(1);
                this._chars.put(id, name);
                this._accessLevels.put(id, rs.getInt(2));
                String string = name;
                return string;
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check existing char id!", ex);
        }
        return null;
    }

    public final int getAccessLevelById(int objectId) {
        if (this.getNameById(objectId) != null) {
            return this._accessLevels.get(objectId);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public boolean doesCharNameExist(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAccountCharacterCount(String account) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(char_name) FROM characters WHERE account_name=?");){
            ps.setString(1, account);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check existing char count!", ex);
        }
        return 0;
    }

    private void loadAll() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT charId, char_name, accesslevel FROM characters");){
            while (rs.next()) {
                int id = rs.getInt(1);
                this._chars.put(id, rs.getString(2));
                this._accessLevels.put(id, rs.getInt(3));
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not load char name!", ex);
        }
        LOG.info("Loaded {} char names.", (Object)this._chars.size());
    }

    public static CharNameTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final CharNameTable INSTANCE = new CharNameTable();

        private SingletonHolder() {
        }
    }
}

