/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSummonTable {
    private static final Logger LOG = LoggerFactory.getLogger(CharSummonTable.class);
    private static final Map<Integer, Integer> _pets = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> _servitors = new ConcurrentHashMap<Integer, Integer>();
    private static final String INIT_PET = "SELECT ownerId, item_obj_id FROM pets WHERE restore=TRUE";
    private static final String INIT_SUMMONS = "SELECT ownerId, summonSkillId FROM character_summons";
    private static final String LOAD_SUMMON = "SELECT curHp, curMp, time FROM character_summons WHERE ownerId = ? AND summonSkillId = ?";
    private static final String REMOVE_SUMMON = "DELETE FROM character_summons WHERE ownerId = ?";
    private static final String SAVE_SUMMON = "REPLACE INTO character_summons (ownerId,summonSkillId,curHp,curMp,time) VALUES (?,?,?,?,?)";

    public Map<Integer, Integer> getPets() {
        return _pets;
    }

    public Map<Integer, Integer> getServitors() {
        return _servitors;
    }

    public void init() {
        ResultSet rs;
        Statement s;
        Connection con;
        if (Configuration.character().restoreServitorOnReconnect()) {
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    s = con.createStatement();
                    try {
                        rs = s.executeQuery(INIT_SUMMONS);
                        try {
                            while (rs.next()) {
                                _servitors.put(rs.getInt("ownerId"), rs.getInt("summonSkillId"));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error while loading saved servitor!", e);
            }
        }
        if (Configuration.character().restorePetOnReconnect()) {
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    s = con.createStatement();
                    try {
                        rs = s.executeQuery(INIT_PET);
                        try {
                            while (rs.next()) {
                                _pets.put(rs.getInt("ownerId"), rs.getInt("item_obj_id"));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error while loading saved pet!", e);
            }
        }
    }

    public void removeServitor(L2PcInstance activeChar) {
        _servitors.remove(activeChar.getObjectId());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(REMOVE_SUMMON);){
            ps.setInt(1, activeChar.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Summon cannot be removed!", e);
        }
    }

    public void restorePet(L2PcInstance activeChar) {
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(_pets.get(activeChar.getObjectId()));
        if (item == null) {
            LOG.warn("Null pet summoning item for player {}!", (Object)activeChar);
            return;
        }
        L2PetData petData = PetDataTable.getInstance().getPetDataByItemId(item.getId());
        if (petData == null) {
            LOG.warn("Null pet data for: {} and summoning item {}!", (Object)activeChar, (Object)item);
            return;
        }
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(petData.getNpcId());
        if (npcTemplate == null) {
            LOG.warn("Null pet NPC template for player {} and pet ID {}!", (Object)activeChar, (Object)petData.getNpcId());
            return;
        }
        L2PetInstance pet = L2PetInstance.spawnPet(npcTemplate, activeChar, item);
        if (pet == null) {
            LOG.warn("Null pet instance for player {} and pet NPC template {}!", (Object)activeChar, (Object)npcTemplate);
            return;
        }
        pet.setShowSummonAnimation(true);
        pet.setTitle(activeChar.getName());
        if (!pet.isRespawned()) {
            pet.setCurrentHp(pet.getMaxHp());
            pet.setCurrentMp(pet.getMaxMp());
            pet.setExp(pet.getExpForThisLevel());
            pet.setCurrentFed(pet.getMaxFed());
        }
        pet.setRunning();
        if (!pet.isRespawned()) {
            pet.storeMe();
        }
        item.setEnchantLevel(pet.getLevel());
        activeChar.setPet(pet);
        pet.spawnMe(activeChar.getX() + 50, activeChar.getY() + 100, activeChar.getZ());
        pet.startFeed();
        pet.setFollowStatus(true);
        pet.getOwner().sendPacket(new PetItemList(pet.getInventory().getItems()));
        pet.broadcastStatusUpdate();
    }

    public void restoreServitor(L2PcInstance activeChar) {
        int skillId = _servitors.get(activeChar.getObjectId());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(LOAD_SUMMON);){
            ps.setInt(1, activeChar.getObjectId());
            ps.setInt(2, skillId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int curHp = rs.getInt("curHp");
                    int curMp = rs.getInt("curMp");
                    int time = rs.getInt("time");
                    Skill skill = SkillData.getInstance().getSkill(skillId, activeChar.getSkillLevel(skillId));
                    if (skill == null) {
                        this.removeServitor(activeChar);
                        return;
                    }
                    skill.applyEffects(activeChar, activeChar);
                    if (!activeChar.hasServitor()) continue;
                    L2ServitorInstance summon = (L2ServitorInstance)activeChar.getSummon();
                    summon.setCurrentHp(curHp);
                    summon.setCurrentMp(curMp);
                    summon.setLifeTimeRemaining(time);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Servitor cannot be restored!", e);
        }
    }

    public void saveSummon(L2ServitorInstance summon) {
        if (summon == null || summon.getLifeTimeRemaining() <= 0) {
            return;
        }
        _servitors.put(summon.getOwner().getObjectId(), summon.getReferenceSkill());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SAVE_SUMMON);){
            ps.setInt(1, summon.getOwner().getObjectId());
            ps.setInt(2, summon.getReferenceSkill());
            ps.setInt(3, (int)Math.round(summon.getCurrentHp()));
            ps.setInt(4, (int)Math.round(summon.getCurrentMp()));
            ps.setInt(5, summon.getLifeTimeRemaining());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Failed to store summon {} from {}!", summon, summon.getOwner(), e);
        }
    }

    public static CharSummonTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CharSummonTable _instance = new CharSummonTable();

        private SingletonHolder() {
        }
    }
}

