/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Crest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrestTable {
    private static final Logger LOG = LoggerFactory.getLogger(CrestTable.class);
    private final Map<Integer, L2Crest> _crests = new ConcurrentHashMap<Integer, L2Crest>();
    private final AtomicInteger _nextId = new AtomicInteger(1);

    protected CrestTable() {
        this.load();
    }

    public synchronized void load() {
        this._crests.clear();
        HashSet<Integer> crestsInUse = new HashSet<Integer>();
        for (L2Clan clan : ClanTable.getInstance().getClans()) {
            if (clan.getCrestId() != 0) {
                crestsInUse.add(clan.getCrestId());
            }
            if (clan.getCrestLargeId() != 0) {
                crestsInUse.add(clan.getCrestLargeId());
            }
            if (clan.getAllyCrestId() == 0) continue;
            crestsInUse.add(clan.getAllyCrestId());
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement statement = con.createStatement(1003, 1008);
             ResultSet rs = statement.executeQuery("SELECT `crest_id`, `data`, `type` FROM `crests` ORDER BY `crest_id` DESC");){
            while (rs.next()) {
                int id = rs.getInt("crest_id");
                if (this._nextId.get() <= id) {
                    this._nextId.set(id + 1);
                }
                if (!crestsInUse.contains(id) && id != this._nextId.get() - 1) {
                    rs.deleteRow();
                    continue;
                }
                byte[] data = rs.getBytes("data");
                L2Crest.CrestType crestType = L2Crest.CrestType.getById(rs.getInt("type"));
                if (crestType != null) {
                    this._crests.put(id, new L2Crest(id, data, crestType));
                    continue;
                }
                LOG.warn("Unknown crest type {} found in database!", (Object)rs.getInt("type"));
            }
        }
        catch (Exception ex) {
            LOG.warn("There was an error while loading crests from database!", ex);
        }
        LOG.info("Loaded {} crests.", (Object)this._crests.size());
        for (L2Clan clan : ClanTable.getInstance().getClans()) {
            if (clan.getCrestId() != 0 && this.getCrest(clan.getCrestId()) == null) {
                LOG.info("Removing non-existent crest Id {} for clan {}.", (Object)clan.getCrestId(), (Object)clan.getName());
                clan.setCrestId(0);
                clan.changeClanCrest(0);
            }
            if (clan.getCrestLargeId() != 0 && this.getCrest(clan.getCrestLargeId()) == null) {
                LOG.info("Removing non-existent large crest Id {} for clan {}.", (Object)clan.getCrestId(), (Object)clan.getName());
                clan.setCrestLargeId(0);
                clan.changeLargeCrest(0);
            }
            if (clan.getAllyCrestId() == 0 || this.getCrest(clan.getAllyCrestId()) != null) continue;
            LOG.info("Removing non-existent ally crest Id {} for clan {}.", (Object)clan.getCrestId(), (Object)clan.getName());
            clan.setAllyCrestId(0);
            clan.changeAllyCrest(0, true);
        }
    }

    public L2Crest getCrest(int crestId) {
        return this._crests.get(crestId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public L2Crest createCrest(byte[] data, L2Crest.CrestType crestType) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            L2Crest l2Crest;
            block14: {
                PreparedStatement statement = con.prepareStatement("INSERT INTO `crests`(`crest_id`, `data`, `type`) VALUES(?, ?, ?)");
                try {
                    L2Crest crest = new L2Crest(this.getNextId(), data, crestType);
                    statement.setInt(1, crest.getId());
                    statement.setBytes(2, crest.getData());
                    statement.setInt(3, crest.getType().getId());
                    statement.executeUpdate();
                    this._crests.put(crest.getId(), crest);
                    l2Crest = crest;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return l2Crest;
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while saving crest in database!", ex);
            return null;
        }
    }

    public void removeCrest(int crestId) {
        this._crests.remove(crestId);
        if (crestId == this._nextId.get() - 1) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement statement = con.prepareStatement("DELETE FROM `crests` WHERE `crest_id` = ?");){
            statement.setInt(1, crestId);
            statement.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("There has been an  error while deleting crest from database!", ex);
        }
    }

    public int getNextId() {
        return this._nextId.getAndIncrement();
    }

    public static CrestTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final CrestTable INSTANCE = new CrestTable();

        private SingletonHolder() {
        }
    }
}

