/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineTradersTable {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineTradersTable.class);
    private static final String SAVE_OFFLINE_STATUS = "INSERT INTO character_offline_trade (`charId`,`time`,`type`,`title`) VALUES (?,?,?,?)";
    private static final String SAVE_ITEMS = "INSERT INTO character_offline_trade_items (`charId`,`item`,`count`,`price`) VALUES (?,?,?,?)";
    private static final String CLEAR_OFFLINE_TABLE = "DELETE FROM character_offline_trade";
    private static final String CLEAR_OFFLINE_TABLE_ITEMS = "DELETE FROM character_offline_trade_items";
    private static final String LOAD_OFFLINE_STATUS = "SELECT * FROM character_offline_trade";
    private static final String LOAD_OFFLINE_ITEMS = "SELECT * FROM character_offline_trade_items WHERE charId = ?";

    public void storeOffliners() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement stm1 = con.prepareStatement(CLEAR_OFFLINE_TABLE);
             PreparedStatement stm2 = con.prepareStatement(CLEAR_OFFLINE_TABLE_ITEMS);
             PreparedStatement stm3 = con.prepareStatement(SAVE_OFFLINE_STATUS);
             PreparedStatement stm_items = con.prepareStatement(SAVE_ITEMS);){
            stm1.execute();
            stm2.execute();
            con.setAutoCommit(false);
            block34: for (L2PcInstance pc : L2World.getInstance().getPlayers()) {
                try {
                    if (pc.getPrivateStoreType() == PrivateStoreType.NONE || !pc.isInOfflineMode()) continue;
                    stm3.setInt(1, pc.getObjectId());
                    stm3.setLong(2, pc.getOfflineStartTime());
                    stm3.setInt(3, pc.getPrivateStoreType().getId());
                    String title = null;
                    switch (pc.getPrivateStoreType()) {
                        case BUY: {
                            if (!Configuration.customs().offlineTradeEnable()) continue block34;
                            title = pc.getBuyList().getTitle();
                            for (TradeItem tradeItem : pc.getBuyList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, tradeItem.getItem().getId());
                                stm_items.setLong(3, tradeItem.getCount());
                                stm_items.setLong(4, tradeItem.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case SELL: 
                        case PACKAGE_SELL: {
                            if (!Configuration.customs().offlineTradeEnable()) continue block34;
                            title = pc.getSellList().getTitle();
                            for (TradeItem tradeItem : pc.getSellList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, tradeItem.getObjectId());
                                stm_items.setLong(3, tradeItem.getCount());
                                stm_items.setLong(4, tradeItem.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case MANUFACTURE: {
                            if (!Configuration.customs().offlineCraftEnable()) continue block34;
                            title = pc.getStoreName();
                            for (L2ManufactureItem i : pc.getManufactureItems().values()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getRecipeId());
                                stm_items.setLong(3, 0L);
                                stm_items.setLong(4, i.getCost());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                    }
                    stm3.setString(4, title);
                    stm3.executeUpdate();
                    stm3.clearParameters();
                    con.commit();
                }
                catch (Exception ex) {
                    LOG.warn("There has been an error while saving offline trader {}!", (Object)pc, (Object)ex);
                }
            }
            LOG.info("Offline traders stored.");
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while saving offline traders!", ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreOfflineTraders() {
        OfflineTradersTable.LOG.info("Loading offline traders...");
        nTraders = 0;
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                stm = con.createStatement();
                try {
                    rs = stm.executeQuery("SELECT * FROM character_offline_trade");
                    try {
                        while (rs.next()) {
                            time = rs.getLong("time");
                            if (Configuration.customs().getOfflineMaxDays() > 0) {
                                cal = Calendar.getInstance();
                                cal.setTimeInMillis(time);
                                cal.add(6, Configuration.customs().getOfflineMaxDays());
                                if (cal.getTimeInMillis() <= System.currentTimeMillis()) continue;
                            }
                            if ((type = PrivateStoreType.findById(rs.getInt("type"))) == null) {
                                OfflineTradersTable.LOG.warn("PrivateStoreType with Id {} could not be found!", (Object)rs.getInt("type"));
                                continue;
                            }
                            if (type == PrivateStoreType.NONE) continue;
                            player = null;
                            try {
                                client = new L2GameClient(null);
                                client.setDetached(true);
                                player = L2PcInstance.load(rs.getInt("charId"));
                                client.setActiveChar(player);
                                player.setOnlineStatus(true, false);
                                client.setAccountName(player.getAccountNamePlayer());
                                L2World.getInstance().addPlayerToWorld(player);
                                client.setState(L2GameClient.GameClientState.IN_GAME);
                                player.setClient(client);
                                player.setOfflineStartTime(time);
                                player.spawnMe(player.getX(), player.getY(), player.getZ());
                                LoginServerThread.getInstance().addGameServerLogin(player.getAccountName(), client);
                                stm_items = con.prepareStatement("SELECT * FROM character_offline_trade_items WHERE charId = ?");
                                try {
                                    stm_items.setInt(1, player.getObjectId());
                                    items = stm_items.executeQuery();
                                    try {
                                        switch (1.$SwitchMap$com$l2jserver$gameserver$enums$PrivateStoreType[type.ordinal()]) {
                                            case 1: {
                                                while (items.next()) {
                                                    if (player.getBuyList().addItemByItemId(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                                    throw new NullPointerException();
                                                }
                                                player.getBuyList().setTitle(rs.getString("title"));
                                                ** break;
lbl48:
                                                // 1 sources

                                                break;
                                            }
                                            case 2: 
                                            case 3: {
                                                while (items.next()) {
                                                    if (player.getSellList().addItem(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                                    throw new NullPointerException();
                                                }
                                                player.getSellList().setTitle(rs.getString("title"));
                                                player.getSellList().setPackaged(type == PrivateStoreType.PACKAGE_SELL);
                                                ** break;
lbl56:
                                                // 1 sources

                                                break;
                                            }
                                            case 4: {
                                                while (items.next()) {
                                                    player.getManufactureItems().put(items.getInt(2), new L2ManufactureItem(items.getInt(2), items.getLong(4)));
                                                }
                                                player.setStoreName(rs.getString("title"));
                                                break;
                                            }
                                        }
                                    }
                                    finally {
                                        if (items != null) {
                                            items.close();
                                        }
                                    }
                                }
                                finally {
                                    if (stm_items != null) {
                                        stm_items.close();
                                    }
                                }
                                player.sitDown();
                                if (Configuration.customs().offlineSetNameColor()) {
                                    player.getAppearance().setNameColor(Configuration.customs().getOfflineNameColor());
                                }
                                player.setPrivateStoreType(type);
                                player.setOnlineStatus(true, true);
                                player.restoreEffects();
                                player.broadcastUserInfo();
                                ++nTraders;
                            }
                            catch (Exception ex) {
                                OfflineTradersTable.LOG.warn("There has been an error loading trader {}!", (Object)player, (Object)ex);
                                if (player == null) continue;
                                player.deleteMe();
                            }
                        }
                        OfflineTradersTable.LOG.info("Loaded  {} offline trader(s).", (Object)nTraders);
                        stm1 = con.createStatement();
                        try {
                            stm1.execute("DELETE FROM character_offline_trade");
                            stm1.execute("DELETE FROM character_offline_trade_items");
                            return;
                        }
                        finally {
                            if (stm1 != null) {
                                stm1.close();
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stm != null) {
                        stm.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception ex) {
            OfflineTradersTable.LOG.warn("There has been an error while loading offline traders!", ex);
        }
    }

    public static OfflineTradersTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final OfflineTradersTable INSTANCE = new OfflineTradersTable();

        private SingletonHolder() {
        }
    }
}

