/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.actor.L2Summon;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummonSkillsTable {
    private static final Logger LOG = LoggerFactory.getLogger(SummonSkillsTable.class);
    private final Map<Integer, Map<Integer, L2PetSkillLearn>> _skillTrees = new HashMap<Integer, Map<Integer, L2PetSkillLearn>>();

    protected SummonSkillsTable() {
        this.load();
    }

    public void load() {
        this._skillTrees.clear();
        int count = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT templateId, minLvl, skillId, skillLvl FROM pets_skills");){
            while (rs.next()) {
                int npcId = rs.getInt("templateId");
                Map skillTree = this._skillTrees.computeIfAbsent(npcId, k -> new HashMap());
                int id = rs.getInt("skillId");
                int lvl = rs.getInt("skillLvl");
                skillTree.put(SkillData.getSkillHashCode(id, lvl + 1), new L2PetSkillLearn(id, lvl, rs.getInt("minLvl")));
                ++count;
            }
        }
        catch (Exception ex) {
            LOG.error("Error while loading pet skill tree!", ex);
        }
        LOG.info("Loaded {} summon skills.", (Object)count);
    }

    public int getAvailableLevel(L2Summon cha, int skillId) {
        int lvl = 0;
        if (!this._skillTrees.containsKey(cha.getId())) {
            LOG.warn("Pet Id {} does not have any skills assigned!", (Object)cha.getId());
            return lvl;
        }
        Collection<L2PetSkillLearn> skills = this._skillTrees.get(cha.getId()).values();
        for (L2PetSkillLearn temp : skills) {
            if (temp.getId() != skillId) continue;
            if (temp.getLevel() == 0) {
                int maxLvl;
                if (cha.getLevel() < 70) {
                    lvl = cha.getLevel() / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (cha.getLevel() - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillData.getInstance().getMaxLevel(temp.getId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > cha.getLevel() || temp.getLevel() <= lvl) continue;
            lvl = temp.getLevel();
        }
        return lvl;
    }

    public List<Integer> getAvailableSkills(L2Summon cha) {
        ArrayList<Integer> skillIds = new ArrayList<Integer>();
        if (!this._skillTrees.containsKey(cha.getId())) {
            LOG.warn("Pet Id {} does not have any skills assigned!", (Object)cha.getId());
            return skillIds;
        }
        Collection<L2PetSkillLearn> skills = this._skillTrees.get(cha.getId()).values();
        for (L2PetSkillLearn temp : skills) {
            if (skillIds.contains(temp.getId())) continue;
            skillIds.add(temp.getId());
        }
        return skillIds;
    }

    public static SummonSkillsTable getInstance() {
        return SingletonHolder._instance;
    }

    public static final class L2PetSkillLearn {
        private final int _id;
        private final int _level;
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            this._id = id;
            this._level = lvl;
            this._minLevel = minLvl;
        }

        public int getId() {
            return this._id;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }

    private static class SingletonHolder {
        protected static final SummonSkillsTable _instance = new SummonSkillsTable();

        private SingletonHolder() {
        }
    }
}

