/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2AdminCommandAccessRight;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class AdminData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(AdminData.class);
    private final Map<Integer, L2AccessLevel> _accessLevels = new HashMap<Integer, L2AccessLevel>();
    private final Map<String, L2AdminCommandAccessRight> _adminCommandAccessRights = new HashMap<String, L2AdminCommandAccessRight>();
    private final Map<L2PcInstance, Boolean> _gmList = new ConcurrentHashMap<L2PcInstance, Boolean>();
    private int _highestLevel = 0;

    protected AdminData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._accessLevels.clear();
        this._adminCommandAccessRights.clear();
        this.parseDatapackFile("config/accessLevels.xml");
        LOG.info("Loaded {} access levels.", (Object)this._accessLevels.size());
        this.parseDatapackFile("config/adminCommands.xml");
        LOG.info("Loaded {} access commands.", (Object)this._adminCommandAccessRights.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                Node attr;
                NamedNodeMap attrs;
                StatsSet set;
                if ("access".equalsIgnoreCase(d.getNodeName())) {
                    set = new StatsSet();
                    attrs = d.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        attr = attrs.item(i);
                        set.set(attr.getNodeName(), attr.getNodeValue());
                    }
                    L2AccessLevel level = new L2AccessLevel(set);
                    if (level.getLevel() > this._highestLevel) {
                        this._highestLevel = level.getLevel();
                    }
                    this._accessLevels.put(level.getLevel(), level);
                    continue;
                }
                if (!"admin".equalsIgnoreCase(d.getNodeName())) continue;
                set = new StatsSet();
                attrs = d.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    attr = attrs.item(i);
                    set.set(attr.getNodeName(), attr.getNodeValue());
                }
                L2AdminCommandAccessRight command = new L2AdminCommandAccessRight(set);
                this._adminCommandAccessRights.put(command.getAdminCommand(), command);
            }
        }
    }

    public L2AccessLevel getAccessLevel(int accessLevelNum) {
        if (accessLevelNum < 0) {
            return this._accessLevels.get(-1);
        }
        if (!this._accessLevels.containsKey(accessLevelNum)) {
            this._accessLevels.put(accessLevelNum, new L2AccessLevel());
        }
        return this._accessLevels.get(accessLevelNum);
    }

    public L2AccessLevel getMasterAccessLevel() {
        return this._accessLevels.get(this._highestLevel);
    }

    public boolean hasAccessLevel(int id) {
        return this._accessLevels.containsKey(id);
    }

    public boolean hasAccess(String adminCommand, L2AccessLevel accessLevel) {
        L2AdminCommandAccessRight acar = this._adminCommandAccessRights.get(adminCommand);
        if (acar == null) {
            if (accessLevel.getLevel() > 0 && accessLevel.getLevel() == this._highestLevel) {
                acar = new L2AdminCommandAccessRight(adminCommand, true, accessLevel.getLevel());
                this._adminCommandAccessRights.put(adminCommand, acar);
                LOG.info("No rights defined for admin command {} auto setting access level {}!", (Object)adminCommand, (Object)accessLevel.getLevel());
            } else {
                LOG.info("No rights defined for admin command {}!", (Object)adminCommand);
                return false;
            }
        }
        return acar.hasAccess(accessLevel);
    }

    public boolean requireConfirm(String command) {
        L2AdminCommandAccessRight acar = this._adminCommandAccessRights.get(command);
        if (acar == null) {
            LOG.info("No rights defined for admin command {}.", (Object)command);
            return false;
        }
        return acar.getRequireConfirm();
    }

    public List<L2PcInstance> getAllGms(boolean includeHidden) {
        ArrayList<L2PcInstance> tmpGmList = new ArrayList<L2PcInstance>();
        for (Map.Entry<L2PcInstance, Boolean> entry : this._gmList.entrySet()) {
            if (!includeHidden && entry.getValue().booleanValue()) continue;
            tmpGmList.add(entry.getKey());
        }
        return tmpGmList;
    }

    public List<String> getAllGmNames(boolean includeHidden) {
        ArrayList<String> tmpGmList = new ArrayList<String>();
        for (Map.Entry<L2PcInstance, Boolean> entry : this._gmList.entrySet()) {
            if (!entry.getValue().booleanValue()) {
                tmpGmList.add(entry.getKey().getName());
                continue;
            }
            if (!includeHidden) continue;
            tmpGmList.add(entry.getKey().getName() + " (invis)");
        }
        return tmpGmList;
    }

    public void addGm(L2PcInstance player, boolean hidden) {
        this._gmList.put(player, hidden);
    }

    public void deleteGm(L2PcInstance player) {
        this._gmList.remove(player);
    }

    public void showGm(L2PcInstance player) {
        if (this._gmList.containsKey(player)) {
            this._gmList.put(player, false);
        }
    }

    public void hideGm(L2PcInstance player) {
        if (this._gmList.containsKey(player)) {
            this._gmList.put(player, true);
        }
    }

    public boolean isGmOnline(boolean includeHidden) {
        for (Map.Entry<L2PcInstance, Boolean> entry : this._gmList.entrySet()) {
            if (!includeHidden && entry.getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void sendListToPlayer(L2PcInstance player) {
        if (this.isGmOnline(player.isGM())) {
            player.sendPacket(SystemMessageId.GM_LIST);
            for (String name : this.getAllGmNames(player.isGM())) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.GM_C1);
                sm.addString(name);
                player.sendPacket(sm);
            }
        } else {
            player.sendPacket(SystemMessageId.NO_GM_PROVIDING_SERVICE_NOW);
        }
    }

    public void broadcastToGMs(L2GameServerPacket packet) {
        for (L2PcInstance gm : this.getAllGms(true)) {
            gm.sendPacket(packet);
        }
    }

    public void broadcastMessageToGMs(String message) {
        for (L2PcInstance gm : this.getAllGms(true)) {
            gm.sendMessage(message);
        }
    }

    public static AdminData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final AdminData INSTANCE = new AdminData();

        private SingletonHolder() {
        }
    }
}

