/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.StatFunction;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnchantItemHPBonusData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantItemHPBonusData.class);
    private static final float FULL_ARMOR_MODIFIER = 1.5f;
    private final Map<CrystalType, List<Integer>> _armorHPBonuses = new EnumMap<CrystalType, List<Integer>>(CrystalType.class);

    protected EnchantItemHPBonusData() {
        this.load();
    }

    @Override
    public void load() {
        this._armorHPBonuses.clear();
        this.parseDatapackFile("data/stats/enchantHPBonus.xml");
        LOG.info("Loaded {} Enchant HP Bonuses.", (Object)this._armorHPBonuses.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"enchantHP".equalsIgnoreCase(d.getNodeName())) continue;
                ArrayList<Integer> bonuses = new ArrayList<Integer>(12);
                for (Node e = d.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!"bonus".equalsIgnoreCase(e.getNodeName())) continue;
                    bonuses.add(Integer.parseInt(e.getTextContent()));
                }
                this._armorHPBonuses.put(this.parseEnum(d.getAttributes(), CrystalType.class, "grade"), bonuses);
            }
        }
        if (!this._armorHPBonuses.isEmpty()) {
            ItemTable it = ItemTable.getInstance();
            Set<Integer> armorIds = it.getAllArmorsId();
            for (Integer itemId : armorIds) {
                L2Item item = it.getTemplate(itemId);
                if (item == null || item.getCrystalType() == CrystalType.NONE) continue;
                switch (item.getBodyPart()) {
                    case 1: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 32768: 
                    case 0x10000000: {
                        item.attach(new FuncTemplate(null, null, StatFunction.ENCHANTHP.getName(), -1, Stats.MAX_HP, 0.0));
                        break;
                    }
                }
            }
        }
    }

    public final int getHPBonus(L2ItemInstance item) {
        List<Integer> values = this._armorHPBonuses.get((Object)item.getItem().getItemGradeSPlus());
        if (values == null || values.isEmpty() || item.getOlyEnchantLevel() <= 0) {
            return 0;
        }
        int bonus = values.get(Math.min(item.getOlyEnchantLevel(), values.size()) - 1);
        if (item.getItem().getBodyPart() == 32768) {
            return (int)((float)bonus * 1.5f);
        }
        return bonus;
    }

    public static EnchantItemHPBonusData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final EnchantItemHPBonusData INSTANCE = new EnchantItemHPBonusData();

        private SingletonHolder() {
        }
    }
}

