/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantSkillGroupsData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantSkillGroupsData.class);
    public static final int NORMAL_ENCHANT_BOOK = 6622;
    public static final int SAFE_ENCHANT_BOOK = 9627;
    public static final int CHANGE_ENCHANT_BOOK = 9626;
    public static final int UNTRAIN_ENCHANT_BOOK = 9625;
    private final Map<Integer, L2EnchantSkillGroup> _enchantSkillGroups = new HashMap<Integer, L2EnchantSkillGroup>();
    private final Map<Integer, L2EnchantSkillLearn> _enchantSkillTrees = new HashMap<Integer, L2EnchantSkillLearn>();

    protected EnchantSkillGroupsData() {
        this.load();
    }

    @Override
    public void load() {
        this._enchantSkillGroups.clear();
        this._enchantSkillTrees.clear();
        this.parseDatapackFile("data/enchantSkillGroups.xml");
        int routes = 0;
        for (L2EnchantSkillGroup group : this._enchantSkillGroups.values()) {
            routes += group.getEnchantGroupDetails().size();
        }
        LOG.info("Loaded {} groups and {} routes.", (Object)this._enchantSkillGroups.size(), (Object)routes);
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"group".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                int id = this.parseInteger(attrs, "id");
                L2EnchantSkillGroup group = this._enchantSkillGroups.get(id);
                if (group == null) {
                    group = new L2EnchantSkillGroup(id);
                    this._enchantSkillGroups.put(id, group);
                }
                for (Node b = d.getFirstChild(); b != null; b = b.getNextSibling()) {
                    if (!"enchant".equalsIgnoreCase(b.getNodeName())) continue;
                    attrs = b.getAttributes();
                    StatsSet set = new StatsSet();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    group.addEnchantDetail(new L2EnchantSkillGroup.EnchantSkillHolder(set));
                }
            }
        }
    }

    public int addNewRouteForSkill(int skillId, int maxLvL, int route, int group) {
        L2EnchantSkillLearn enchantableSkill = this._enchantSkillTrees.get(skillId);
        if (enchantableSkill == null) {
            enchantableSkill = new L2EnchantSkillLearn(skillId, maxLvL);
            this._enchantSkillTrees.put(skillId, enchantableSkill);
        }
        if (this._enchantSkillGroups.containsKey(group)) {
            enchantableSkill.addNewEnchantRoute(route, group);
            return this._enchantSkillGroups.get(group).getEnchantGroupDetails().size();
        }
        LOG.error("There has been an error while loading generating enchant skill Id {}, route {} and group {}!", skillId, route, group);
        return 0;
    }

    public L2EnchantSkillLearn getSkillEnchantmentForSkill(Skill skill) {
        L2EnchantSkillLearn esl = this.getSkillEnchantmentBySkillId(skill.getId());
        if (esl != null && skill.getLevel() >= esl.getBaseLevel()) {
            return esl;
        }
        return null;
    }

    public L2EnchantSkillLearn getSkillEnchantmentBySkillId(int skillId) {
        return this._enchantSkillTrees.get(skillId);
    }

    public L2EnchantSkillGroup getEnchantSkillGroupById(int id) {
        return this._enchantSkillGroups.get(id);
    }

    public int getEnchantSkillSpCost(Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getSpCost();
        }
        return Integer.MAX_VALUE;
    }

    public int getEnchantSkillAdenaCost(Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getAdenaCost();
        }
        return Integer.MAX_VALUE;
    }

    public byte getEnchantSkillRate(L2PcInstance player, Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getRate(player);
        }
        return 0;
    }

    public static EnchantSkillGroupsData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final EnchantSkillGroupsData INSTANCE = new EnchantSkillGroupsData();

        private SingletonHolder() {
        }
    }
}

