/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2Fish;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(FishData.class);
    private final Map<Integer, L2Fish> _fishNormal = new HashMap<Integer, L2Fish>();
    private final Map<Integer, L2Fish> _fishEasy = new HashMap<Integer, L2Fish>();
    private final Map<Integer, L2Fish> _fishHard = new HashMap<Integer, L2Fish>();

    protected FishData() {
        this.load();
    }

    @Override
    public void load() {
        this._fishEasy.clear();
        this._fishNormal.clear();
        this._fishHard.clear();
        this.parseDatapackFile("data/stats/fishing/fishes.xml");
        LOG.info("Loaded {} fish.", (Object)(this._fishEasy.size() + this._fishNormal.size() + this._fishHard.size()));
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            block6: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fish".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2Fish fish = new L2Fish(set);
                switch (fish.getFishGrade()) {
                    case 0: {
                        this._fishEasy.put(fish.getFishId(), fish);
                        continue block6;
                    }
                    case 1: {
                        this._fishNormal.put(fish.getFishId(), fish);
                        continue block6;
                    }
                    case 2: {
                        this._fishHard.put(fish.getFishId(), fish);
                    }
                }
            }
        }
    }

    public List<L2Fish> getFish(int level, int group, int grade) {
        Map<Integer, L2Fish> fish;
        ArrayList<L2Fish> result = new ArrayList<L2Fish>();
        switch (grade) {
            case 0: {
                fish = this._fishEasy;
                break;
            }
            case 1: {
                fish = this._fishNormal;
                break;
            }
            case 2: {
                fish = this._fishHard;
                break;
            }
            default: {
                LOG.warn("Unmanaged fish grade!");
                return result;
            }
        }
        for (L2Fish f : fish.values()) {
            if (f.getFishLevel() != level || f.getFishGroup() != group) continue;
            result.add(f);
        }
        if (result.isEmpty()) {
            LOG.warn("Cannot find any fish for level: {} group: {} and grade: {}!", level, group, grade);
        }
        return result;
    }

    public static FishData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final FishData INSTANCE = new FishData();

        private SingletonHolder() {
        }
    }
}

