/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2FishingRod;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishingRodsData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(FishingRodsData.class);
    private final Map<Integer, L2FishingRod> _fishingRods = new HashMap<Integer, L2FishingRod>();

    protected FishingRodsData() {
        this.load();
    }

    @Override
    public void load() {
        this._fishingRods.clear();
        this.parseDatapackFile("data/stats/fishing/fishingRods.xml");
        LOG.info("Loaded {} fishing rods.", (Object)this._fishingRods.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fishingRod".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2FishingRod fishingRod = new L2FishingRod(set);
                this._fishingRods.put(fishingRod.getFishingRodItemId(), fishingRod);
            }
        }
    }

    public L2FishingRod getFishingRod(int itemId) {
        return this._fishingRods.get(itemId);
    }

    public static FishingRodsData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final FishingRodsData INSTANCE = new FishingRodsData();

        private SingletonHolder() {
        }
    }
}

