/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PlayerXpPercentLostData
implements IXmlReader {
    private final double[] _playerXpPercentLost = new double[Configuration.character().getMaxPlayerLevel() + 1];

    protected PlayerXpPercentLostData() {
        Arrays.fill(this._playerXpPercentLost, 1.0);
        this.load();
    }

    @Override
    public void load() {
        this.parseDatapackFile("data/stats/chars/playerXpPercentLost.xml");
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"xpLost".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                this._playerXpPercentLost[this.parseInteger((NamedNodeMap)attrs, (String)"level").intValue()] = this.parseDouble(attrs, "val");
            }
        }
    }

    public double getXpPercent(int level) {
        if (level > Configuration.character().getMaxPlayerLevel()) {
            LOG.warn("Require to high level inside PlayerXpPercentLostData ({})", (Object)level);
            return this._playerXpPercentLost[Configuration.character().getMaxPlayerLevel()];
        }
        return this._playerXpPercentLost[level];
    }

    public static PlayerXpPercentLostData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PlayerXpPercentLostData _instance = new PlayerXpPercentLostData();

        private SingletonHolder() {
        }
    }
}

