/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.SiegeScheduleDate;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SiegeScheduleData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(SiegeScheduleData.class);
    private final List<SiegeScheduleDate> _scheduleData = new ArrayList<SiegeScheduleDate>();

    protected SiegeScheduleData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._scheduleData.clear();
        this.parseFile(new File("config/SiegeSchedule.xml"));
        LOG.info("Loaded {} siege schedulers.", (Object)this._scheduleData.size());
        if (this._scheduleData.isEmpty()) {
            this._scheduleData.add(new SiegeScheduleDate(new StatsSet()));
            LOG.info("Emergency Loaded {} default siege schedulers.", (Object)this._scheduleData.size());
        }
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node cd = n.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                if (!"schedule".equals(cd.getNodeName())) continue;
                StatsSet set = new StatsSet();
                NamedNodeMap attrs = cd.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node node = attrs.item(i);
                    String key = node.getNodeName();
                    String val = node.getNodeValue();
                    if ("day".equals(key) && !Util.isDigit(val)) {
                        val = Integer.toString(this.getValueForField(val));
                    }
                    set.set(key, val);
                }
                this._scheduleData.add(new SiegeScheduleDate(set));
            }
        }
    }

    private int getValueForField(String field) {
        try {
            return Calendar.class.getField(field).getInt(Calendar.class);
        }
        catch (Exception ex) {
            LOG.warn("Unable to get value!", ex);
            return -1;
        }
    }

    public List<SiegeScheduleDate> getScheduleDates() {
        return this._scheduleData;
    }

    public static SiegeScheduleData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final SiegeScheduleData INSTANCE = new SiegeScheduleData();

        private SingletonHolder() {
        }
    }
}

