/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SkillLearnData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(SkillLearnData.class);
    private final Map<Integer, List<ClassId>> _skillLearn = new HashMap<Integer, List<ClassId>>();

    protected SkillLearnData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._skillLearn.clear();
        this.parseDatapackFile("data/skillLearn.xml");
        LOG.info("Loaded {} skill learn data.", (Object)this._skillLearn.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                if (!"npc".equalsIgnoreCase(list_node.getNodeName())) continue;
                LinkedList<ClassId> classIds = new LinkedList<ClassId>();
                for (Node c = list_node.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"classId".equalsIgnoreCase(c.getNodeName())) continue;
                    classIds.add(ClassId.getClassId(Integer.parseInt(c.getTextContent())));
                }
                this._skillLearn.put(this.parseInteger(list_node.getAttributes(), "id"), classIds);
            }
        }
    }

    public List<ClassId> getSkillLearnData(int npcId) {
        return this._skillLearn.get(npcId);
    }

    public static SkillLearnData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final SkillLearnData INSTANCE = new SkillLearnData();

        private SingletonHolder() {
        }
    }
}

