/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class BotReportTable {
    private static final Logger LOG = LoggerFactory.getLogger(BotReportTable.class);
    private static final int COLUMN_BOT_ID = 1;
    private static final int COLUMN_REPORTER_ID = 2;
    private static final int COLUMN_REPORT_TIME = 3;
    public static final int ATTACK_ACTION_BLOCK_ID = -1;
    public static final int TRADE_ACTION_BLOCK_ID = -2;
    public static final int PARTY_ACTION_BLOCK_ID = -3;
    public static final int ACTION_BLOCK_ID = -4;
    public static final int CHAT_BLOCK_ID = -5;
    private static final String SQL_LOAD_REPORTED_CHAR_DATA = "SELECT * FROM bot_reported_char_data";
    private static final String SQL_INSERT_REPORTED_CHAR_DATA = "INSERT INTO bot_reported_char_data VALUES (?,?,?)";
    private static final String SQL_CLEAR_REPORTED_CHAR_DATA = "DELETE FROM bot_reported_char_data";
    private Map<Integer, Long> _ipRegistry;
    private Map<Integer, ReporterCharData> _charRegistry;
    private Map<Integer, ReportedCharData> _reports;
    private Map<Integer, PunishHolder> _punishments;

    BotReportTable() {
        if (Configuration.general().enableBotReportButton()) {
            this._ipRegistry = new HashMap<Integer, Long>();
            this._charRegistry = new ConcurrentHashMap<Integer, ReporterCharData>();
            this._reports = new ConcurrentHashMap<Integer, ReportedCharData>();
            this._punishments = new ConcurrentHashMap<Integer, PunishHolder>();
            try {
                File punishments = new File("./config/botreport_punishments.xml");
                if (!punishments.exists()) {
                    throw new FileNotFoundException(punishments.getName());
                }
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(punishments, (DefaultHandler)new PunishmentsLoader());
            }
            catch (Exception ex) {
                LOG.warn("Could not load punishments from /config/botreport_punishments.xml", ex);
            }
            this.loadReportedCharData();
            this.scheduleResetPointTask();
        }
    }

    private void loadReportedCharData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(SQL_LOAD_REPORTED_CHAR_DATA);){
            long lastResetTime = 0L;
            try {
                String[] hour = Configuration.general().getBotReportPointsResetHour().split(":");
                Calendar c = Calendar.getInstance();
                c.set(11, Integer.parseInt(hour[0]));
                c.set(12, Integer.parseInt(hour[1]));
                if (System.currentTimeMillis() < c.getTimeInMillis()) {
                    c.set(6, c.get(6) - 1);
                }
                lastResetTime = c.getTimeInMillis();
            }
            catch (Exception hour) {
                // empty catch block
            }
            while (rs.next()) {
                Object rcd;
                int botId = rs.getInt(1);
                int reporter = rs.getInt(2);
                long date = rs.getLong(3);
                if (this._reports.containsKey(botId)) {
                    this._reports.get(botId).addReporter(reporter, date);
                } else {
                    rcd = new ReportedCharData();
                    ((ReportedCharData)rcd).addReporter(reporter, date);
                    this._reports.put(rs.getInt(1), (ReportedCharData)rcd);
                }
                if (date <= lastResetTime) continue;
                rcd = this._charRegistry.get(reporter);
                if (rcd != null) {
                    ((ReporterCharData)rcd).setPoints(((ReporterCharData)rcd).getPointsLeft() - 1);
                    continue;
                }
                rcd = new ReporterCharData();
                ((ReporterCharData)rcd).setPoints(6);
                this._charRegistry.put(reporter, (ReporterCharData)rcd);
            }
            LOG.info("Loaded {} bot reports.", (Object)this._reports.size());
        }
        catch (Exception ex) {
            LOG.warn("Could not load reported char data!", ex);
        }
    }

    public void saveReportedCharData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement st = con.createStatement();
             PreparedStatement ps = con.prepareStatement(SQL_INSERT_REPORTED_CHAR_DATA);){
            st.execute(SQL_CLEAR_REPORTED_CHAR_DATA);
            for (Map.Entry<Integer, ReportedCharData> entrySet : this._reports.entrySet()) {
                Map<Integer, Long> reportTable = entrySet.getValue()._reporters;
                for (int reporterId : reportTable.keySet()) {
                    ps.setInt(1, entrySet.getKey());
                    ps.setInt(2, reporterId);
                    ps.setLong(3, reportTable.get(reporterId));
                    ps.execute();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not update reported char data in database!", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportBot(L2PcInstance reporter) {
        L2Object target = reporter.getTarget();
        if (target == null) {
            return false;
        }
        L2PcInstance bot = target.getActingPlayer();
        if (bot == null || target.getObjectId() == reporter.getObjectId()) {
            return false;
        }
        if (bot.isInsideZone(ZoneId.PEACE) || bot.isInsideZone(ZoneId.PVP)) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHARACTER_IN_PEACE_OR_BATTLE_ZONE);
            return false;
        }
        if (bot.isInOlympiadMode()) {
            reporter.sendPacket(SystemMessageId.TARGET_NOT_REPORT_CANNOT_REPORT_PEACE_PVP_ZONE_OR_OLYMPIAD_OR_CLAN_WAR_ENEMY);
            return false;
        }
        if (bot.getClan() != null && bot.getClan().isAtWarWith(reporter.getClan())) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CLAN_WAR_ENEMY);
            return false;
        }
        if (bot.getExp() == bot.getStat().getStartingExp()) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHAR_WHO_ACQUIRED_XP);
            return false;
        }
        ReportedCharData rcd = this._reports.get(bot.getObjectId());
        ReporterCharData rcdRep = this._charRegistry.get(reporter.getObjectId());
        int reporterId = reporter.getObjectId();
        BotReportTable botReportTable = this;
        synchronized (botReportTable) {
            if (this._reports.containsKey(reporterId)) {
                reporter.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_AND_CANNOT_REPORT);
                return false;
            }
            int ip = BotReportTable.hashIp(reporter);
            if (!BotReportTable.timeHasPassed(this._ipRegistry, ip)) {
                reporter.sendPacket(SystemMessageId.CANNOT_REPORT_TARGET_ALREDY_REPORTED_BY_CLAN_ALLY_MEMBER_OR_SAME_IP);
                return false;
            }
            if (rcd != null) {
                if (rcd.alreadyReportedBy(reporterId)) {
                    reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHAR_AT_THIS_TIME_1);
                    return false;
                }
                if (!Configuration.general().allowReportsFromSameClanMembers() && rcd.reportedBySameClan(reporter.getClan())) {
                    reporter.sendPacket(SystemMessageId.CANNOT_REPORT_TARGET_ALREDY_REPORTED_BY_CLAN_ALLY_MEMBER_OR_SAME_IP);
                    return false;
                }
            }
            if (rcdRep != null) {
                if (rcdRep.getPointsLeft() == 0) {
                    reporter.sendPacket(SystemMessageId.YOU_HAVE_USED_ALL_POINTS_POINTS_ARE_RESET_AT_NOON);
                    return false;
                }
                long reuse = System.currentTimeMillis() - rcdRep.getLastReportTime();
                if (reuse < Configuration.general().getBotReportDelay()) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_CAN_REPORT_IN_S1_MINS_YOU_HAVE_S2_POINTS_LEFT);
                    sm.addInt((int)(reuse / 60000L));
                    sm.addInt(rcdRep.getPointsLeft());
                    reporter.sendPacket(sm);
                    return false;
                }
            }
            long curTime = System.currentTimeMillis();
            if (rcd == null) {
                rcd = new ReportedCharData();
                this._reports.put(bot.getObjectId(), rcd);
            }
            rcd.addReporter(reporterId, curTime);
            if (rcdRep == null) {
                rcdRep = new ReporterCharData();
            }
            rcdRep.registerReport(curTime);
            this._ipRegistry.put(ip, curTime);
            this._charRegistry.put(reporterId, rcdRep);
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_WAS_REPORTED_AS_BOT);
        sm.addCharName(bot);
        reporter.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_USED_REPORT_POINT_ON_C1_YOU_HAVE_C2_POINTS_LEFT);
        sm.addCharName(bot);
        sm.addInt(rcdRep.getPointsLeft());
        reporter.sendPacket(sm);
        this.handleReport(bot, rcd);
        return true;
    }

    private void handleReport(L2PcInstance bot, ReportedCharData rcd) {
        this.punishBot(bot, this._punishments.get(rcd.getReportCount()));
        for (int key : this._punishments.keySet()) {
            if (key >= 0 || Math.abs(key) > rcd.getReportCount()) continue;
            this.punishBot(bot, this._punishments.get(key));
        }
    }

    private void punishBot(L2PcInstance bot, PunishHolder ph) {
        if (ph != null) {
            ph._punish.applyEffects(bot, bot);
            if (ph._systemMessageId > -1) {
                bot.sendPacket(SystemMessageId.getSystemMessageId(ph._systemMessageId));
            }
        }
    }

    void addPunishment(int neededReports, int skillId, int skillLevel, int sysMsg) {
        Skill sk = SkillData.getInstance().getSkill(skillId, skillLevel);
        if (sk != null) {
            this._punishments.put(neededReports, new PunishHolder(sk, sysMsg));
        } else {
            LOG.warn("Could not add punishment for {} report(s): Skill {}-{} does not exist!", neededReports, skillId, skillLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetPointsAndSchedule() {
        Map<Integer, ReporterCharData> map = this._charRegistry;
        synchronized (map) {
            for (ReporterCharData rcd : this._charRegistry.values()) {
                rcd.setPoints(7);
            }
        }
        this.scheduleResetPointTask();
    }

    private void scheduleResetPointTask() {
        try {
            String[] hour = Configuration.general().getBotReportPointsResetHour().split(":");
            Calendar c = Calendar.getInstance();
            c.set(11, Integer.parseInt(hour[0]));
            c.set(12, Integer.parseInt(hour[1]));
            if (System.currentTimeMillis() > c.getTimeInMillis()) {
                c.set(6, c.get(6) + 1);
            }
            ThreadPoolManager.getInstance().scheduleGeneral(new ResetPointTask(), c.getTimeInMillis() - System.currentTimeMillis());
        }
        catch (Exception ex) {
            ThreadPoolManager.getInstance().scheduleGeneral(new ResetPointTask(), TimeUnit.DAYS.toMillis(1L));
            LOG.warn("Could not properly schedule bot report points reset task. Scheduled in 24 hours!", ex);
        }
    }

    private static int hashIp(L2PcInstance player) {
        String con = player.getClient().getConnection().getInetAddress().getHostAddress();
        String[] rawByte = con.split("\\.");
        int[] rawIp = new int[4];
        for (int i = 0; i < 4; ++i) {
            rawIp[i] = Integer.parseInt(rawByte[i]);
        }
        return rawIp[0] | rawIp[1] << 8 | rawIp[2] << 16 | rawIp[3] << 24;
    }

    private static boolean timeHasPassed(Map<Integer, Long> map, int objectId) {
        if (map.containsKey(objectId)) {
            return System.currentTimeMillis() - map.get(objectId) > Configuration.general().getBotReportDelay();
        }
        return true;
    }

    public static BotReportTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private final class PunishmentsLoader
    extends DefaultHandler {
        PunishmentsLoader() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attr) {
            if (qName.equals("punishment")) {
                int reportCount = -1;
                int skillId = -1;
                int skillLevel = 1;
                int sysMessage = -1;
                try {
                    reportCount = Integer.parseInt(attr.getValue("neededReportCount"));
                    skillId = Integer.parseInt(attr.getValue("skillId"));
                    String level = attr.getValue("skillLevel");
                    String systemMessageId = attr.getValue("sysMessageId");
                    if (level != null) {
                        skillLevel = Integer.parseInt(level);
                    }
                    if (systemMessageId != null) {
                        sysMessage = Integer.parseInt(systemMessageId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BotReportTable.this.addPunishment(reportCount, skillId, skillLevel, sysMessage);
            }
        }
    }

    private static final class ReportedCharData {
        Map<Integer, Long> _reporters = new HashMap<Integer, Long>();

        ReportedCharData() {
        }

        int getReportCount() {
            return this._reporters.size();
        }

        boolean alreadyReportedBy(int objectId) {
            return this._reporters.containsKey(objectId);
        }

        void addReporter(int objectId, long reportTime) {
            this._reporters.put(objectId, reportTime);
        }

        boolean reportedBySameClan(L2Clan clan) {
            if (clan == null) {
                return false;
            }
            for (int reporterId : this._reporters.keySet()) {
                if (!clan.isMember(reporterId)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ReporterCharData {
        private long _lastReport = 0L;
        private byte _reportPoints = (byte)7;

        ReporterCharData() {
        }

        void registerReport(long time) {
            this._reportPoints = (byte)(this._reportPoints - 1);
            this._lastReport = time;
        }

        long getLastReportTime() {
            return this._lastReport;
        }

        byte getPointsLeft() {
            return this._reportPoints;
        }

        void setPoints(int points) {
            this._reportPoints = (byte)points;
        }
    }

    static class PunishHolder {
        final Skill _punish;
        final int _systemMessageId;

        PunishHolder(Skill sk, int sysMsg) {
            this._punish = sk;
            this._systemMessageId = sysMsg;
        }
    }

    class ResetPointTask
    implements Runnable {
        ResetPointTask() {
        }

        @Override
        public void run() {
            BotReportTable.this.resetPointsAndSchedule();
        }
    }

    private static final class SingletonHolder {
        static final BotReportTable INSTANCE = new BotReportTable();

        private SingletonHolder() {
        }
    }
}

