/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CastleManager
implements InstanceListManager {
    private static final Logger LOG = LoggerFactory.getLogger(CastleManager.class);
    private final List<Castle> _castles = new ArrayList<Castle>();
    private final Map<Integer, Long> _castleSiegeDate = new ConcurrentHashMap<Integer, Long>();
    private static final int[] _castleCirclets = new int[]{0, 6838, 6835, 6839, 6837, 6840, 6834, 6836, 8182, 8183};

    public int findNearestCastleIndex(L2Object obj) {
        return this.findNearestCastleIndex(obj, Long.MAX_VALUE);
    }

    public int findNearestCastleIndex(L2Object obj, long maxDistance) {
        int index = this.getCastleIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this._castles.size(); ++i) {
                double distance;
                Castle castle = this._castles.get(i);
                if (castle == null || !((double)maxDistance > (distance = castle.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public Castle getCastleById(int castleId) {
        for (Castle temp : this._castles) {
            if (temp.getResidenceId() != castleId) continue;
            return temp;
        }
        return null;
    }

    public Castle getCastleByOwner(L2Clan clan) {
        for (Castle temp : this._castles) {
            if (temp.getOwnerId() != clan.getId()) continue;
            return temp;
        }
        return null;
    }

    public Castle getCastle(String name) {
        for (Castle temp : this._castles) {
            if (!temp.getName().equalsIgnoreCase(name.trim())) continue;
            return temp;
        }
        return null;
    }

    public Castle getCastle(int x, int y, int z) {
        for (Castle temp : this._castles) {
            if (!temp.checkIfInZone(x, y, z)) continue;
            return temp;
        }
        return null;
    }

    public Castle getCastle(L2Object activeObject) {
        return this.getCastle(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public int getCastleIndex(int castleId) {
        for (int i = 0; i < this._castles.size(); ++i) {
            Castle castle = this._castles.get(i);
            if (castle == null || castle.getResidenceId() != castleId) continue;
            return i;
        }
        return -1;
    }

    public int getCastleIndex(L2Object activeObject) {
        return this.getCastleIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public int getCastleIndex(int x, int y, int z) {
        for (int i = 0; i < this._castles.size(); ++i) {
            Castle castle = this._castles.get(i);
            if (castle == null || !castle.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public List<Castle> getCastles() {
        return this._castles;
    }

    public boolean hasOwnedCastle() {
        boolean hasOwnedCastle = false;
        for (Castle castle : this._castles) {
            if (castle.getOwnerId() <= 0) continue;
            hasOwnedCastle = true;
            break;
        }
        return hasOwnedCastle;
    }

    public void validateTaxes(int sealStrifeOwner) {
        int maxTax = switch (sealStrifeOwner) {
            case 1 -> 5;
            case 2 -> 25;
            default -> 15;
        };
        for (Castle castle : this._castles) {
            if (castle.getTaxPercent() <= maxTax) continue;
            castle.setTaxPercent(maxTax);
        }
    }

    public int getCirclet() {
        return this.getCircletByCastleId(1);
    }

    public int getCircletByCastleId(int castleId) {
        if (castleId > 0 && castleId < 10) {
            return _castleCirclets[castleId];
        }
        return 0;
    }

    public void removeCirclet(L2Clan clan, int castleId) {
        for (L2ClanMember member : clan.getMembers()) {
            this.removeCirclet(member, castleId);
        }
    }

    public void removeCirclet(L2ClanMember member, int castleId) {
        if (member == null) {
            return;
        }
        L2PcInstance player = member.getPlayerInstance();
        int circletId = this.getCircletByCastleId(castleId);
        if (circletId != 0) {
            if (player != null) {
                try {
                    L2ItemInstance circlet = player.getInventory().getItemByItemId(circletId);
                    if (circlet != null) {
                        if (circlet.isEquipped()) {
                            player.getInventory().unEquipItemInSlot(circlet.getLocationSlot());
                        }
                        player.destroyItemByItemId("CastleCircletRemoval", circletId, 1L, player, true);
                    }
                    return;
                }
                catch (NullPointerException circlet) {
                    // empty catch block
                }
            }
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement("DELETE FROM items WHERE owner_id = ? and item_id = ?");){
                ps.setInt(1, member.getObjectId());
                ps.setInt(2, circletId);
                ps.execute();
            }
            catch (Exception ex) {
                LOG.warn("Failed to remove castle circlets offline for player {}!", (Object)player, (Object)ex);
            }
        }
    }

    @Override
    public void loadInstances() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id FROM castle ORDER BY id");){
            while (rs.next()) {
                this._castles.add(new Castle(rs.getInt("id")));
            }
            LOG.info("Loaded {} castles.", (Object)this._castles.size());
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading castles from database!", ex);
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Castle castle : this._castles) {
            castle.activateInstance();
        }
    }

    public void registerSiegeDate(int castleId, long siegeDate) {
        this._castleSiegeDate.put(castleId, siegeDate);
    }

    public int getSiegeDates(long siegeDate) {
        int count = 0;
        for (long date : this._castleSiegeDate.values()) {
            if (Math.abs(date - siegeDate) >= 1000L) continue;
            ++count;
        }
        return count;
    }

    public static CastleManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CastleManager _instance = new CastleManager();

        private SingletonHolder() {
        }
    }
}

