/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.CursedWeapon;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FeedableBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CursedWeaponsManager {
    private static final Logger LOG = LoggerFactory.getLogger(CursedWeaponsManager.class);
    private Map<Integer, CursedWeapon> _cursedWeapons;

    protected CursedWeaponsManager() {
        this.init();
    }

    private void init() {
        this._cursedWeapons = new HashMap<Integer, CursedWeapon>();
        if (!Configuration.general().allowCursedWeapons()) {
            return;
        }
        this.load();
        this.restore();
        this.controlPlayers();
        LOG.info("Loaded {} cursed weapon(s).", (Object)this._cursedWeapons.size());
    }

    public void reload() {
        this.init();
    }

    private void load() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Configuration.server().getDatapackRoot(), "data/cursedWeapons.xml");
            if (!file.exists()) {
                LOG.warn("Couldn't find {}!", (Object)file.getAbsoluteFile());
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    int id = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int skillId = Integer.parseInt(attrs.getNamedItem("skillId").getNodeValue());
                    String name = attrs.getNamedItem("name").getNodeValue();
                    CursedWeapon cw = new CursedWeapon(id, skillId, name);
                    for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        int val;
                        if ("dropRate".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDropRate(val);
                            continue;
                        }
                        if ("duration".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDuration(val);
                            continue;
                        }
                        if ("durationLost".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDurationLost(val);
                            continue;
                        }
                        if ("disappearChance".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDisappearChance(val);
                            continue;
                        }
                        if (!"stageKills".equalsIgnoreCase(cd.getNodeName())) continue;
                        attrs = cd.getAttributes();
                        val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                        cw.setStageKills(val);
                    }
                    this._cursedWeapons.put(id, cw);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error parsing cursed weapons file!", ex);
        }
    }

    private void restore() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT itemId, charId, playerKarma, playerPkKills, nbKills, endTime FROM cursed_weapons");){
            while (rs.next()) {
                CursedWeapon cw = this._cursedWeapons.get(rs.getInt("itemId"));
                cw.setPlayerId(rs.getInt("charId"));
                cw.setPlayerKarma(rs.getInt("playerKarma"));
                cw.setPlayerPkKills(rs.getInt("playerPkKills"));
                cw.setNbKills(rs.getInt("nbKills"));
                cw.setEndTime(rs.getLong("endTime"));
                cw.reActivate();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not restore cursed weapons data!", ex);
        }
    }

    private void controlPlayers() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT owner_id FROM items WHERE item_id=?");){
            for (CursedWeapon cw : this._cursedWeapons.values()) {
                block35: {
                    if (cw.isActivated()) continue;
                    int itemId = cw.getItemId();
                    ps.setInt(1, itemId);
                    try (ResultSet rset = ps.executeQuery();){
                        if (!rset.next()) break block35;
                        int playerId = rset.getInt("owner_id");
                        LOG.warn("Player {} owns the cursed weapon {} but he shouldn't!", (Object)playerId, (Object)itemId);
                        try (PreparedStatement delete = con.prepareStatement("DELETE FROM items WHERE owner_id=? AND item_id=?");){
                            delete.setInt(1, playerId);
                            delete.setInt(2, itemId);
                            if (delete.executeUpdate() != 1) {
                                LOG.warn("There has been an error while deleting cursed weapon {} from player Id {}!", (Object)itemId, (Object)playerId);
                            }
                        }
                        try (PreparedStatement update = con.prepareStatement("UPDATE characters SET karma=?, pkkills=? WHERE charId=?");){
                            update.setInt(1, cw.getPlayerKarma());
                            update.setInt(2, cw.getPlayerPkKills());
                            update.setInt(3, playerId);
                            if (update.executeUpdate() != 1) {
                                LOG.warn("There has been an error while updating karma & pkkills for player Id {}!", (Object)cw.getPlayerId());
                            }
                        }
                        CursedWeaponsManager.removeFromDb(itemId);
                    }
                }
                ps.clearParameters();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check cursed weapons data!", ex);
        }
    }

    public synchronized void checkDrop(L2Attackable attackable, L2PcInstance player) {
        if (attackable.getInstanceId() != 0) {
            return;
        }
        if (attackable instanceof L2DefenderInstance || attackable instanceof L2RiftInvaderInstance || attackable instanceof L2FestivalMonsterInstance || attackable instanceof L2GuardInstance || attackable instanceof L2GrandBossInstance || attackable instanceof L2FeedableBeastInstance || attackable instanceof L2FortCommanderInstance) {
            return;
        }
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActive() && cw.checkDrop(attackable, player)) break;
        }
    }

    public void activate(L2PcInstance player, L2ItemInstance item) {
        CursedWeapon cw = this._cursedWeapons.get(item.getId());
        if (player.isCursedWeaponEquipped()) {
            CursedWeapon cw2 = this._cursedWeapons.get(player.getCursedWeaponEquippedId());
            cw2.setNbKills(cw2.getStageKills() - 1);
            cw2.increaseKills();
            cw.setPlayer(player);
            cw.endOfLife();
        } else {
            cw.activate(player, item);
        }
    }

    public void drop(int itemId, L2Character killer) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        cw.dropIt(killer);
    }

    public void increaseKills(int itemId) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        cw.increaseKills();
    }

    public int getLevel(int itemId) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        return cw.getLevel();
    }

    public static void announce(SystemMessage sm) {
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void checkPlayer(L2PcInstance player) {
        if (player == null) {
            return;
        }
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActivated() || player.getObjectId() != cw.getPlayerId()) continue;
            cw.setPlayer(player);
            cw.setItem(player.getInventory().getItemByItemId(cw.getItemId()));
            cw.giveSkill();
            player.setCursedWeaponEquippedId(cw.getItemId());
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTE_OF_USAGE_TIME_ARE_LEFT_FOR_S1);
            sm.addString(cw.getName());
            sm.addInt((int)((cw.getEndTime() - System.currentTimeMillis()) / 60000L));
            player.sendPacket(sm);
        }
    }

    public int checkOwnsWeaponId(int ownerId) {
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActivated() || ownerId != cw.getPlayerId()) continue;
            return cw.getItemId();
        }
        return -1;
    }

    public static void removeFromDb(int itemId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM cursed_weapons WHERE itemId = ?");){
            ps.setInt(1, itemId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Failed to remove cursed weapon Id {}!", (Object)itemId, (Object)ex);
        }
    }

    public void saveData() {
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            cw.saveData();
        }
    }

    public boolean isCursed(int itemId) {
        return this._cursedWeapons.containsKey(itemId);
    }

    public Collection<CursedWeapon> getCursedWeapons() {
        return this._cursedWeapons.values();
    }

    public Set<Integer> getCursedWeaponsIds() {
        return this._cursedWeapons.keySet();
    }

    public CursedWeapon getCursedWeapon(int itemId) {
        return this._cursedWeapons.get(itemId);
    }

    public void givePassive(int itemId) {
        try {
            this._cursedWeapons.get(itemId).giveSkill();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static CursedWeaponsManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CursedWeaponsManager _instance = new CursedWeaponsManager();

        private SingletonHolder() {
        }
    }
}

