/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DayNightSpawnManager {
    private static final Logger LOG = LoggerFactory.getLogger(DayNightSpawnManager.class);
    private final List<L2Spawn> _dayCreatures = new ArrayList<L2Spawn>();
    private final List<L2Spawn> _nightCreatures = new ArrayList<L2Spawn>();
    private final Map<L2Spawn, L2RaidBossInstance> _bosses = new HashMap<L2Spawn, L2RaidBossInstance>();

    private DayNightSpawnManager() {
    }

    public void addDayCreature(L2Spawn spawnDat) {
        this._dayCreatures.add(spawnDat);
    }

    public void addNightCreature(L2Spawn spawnDat) {
        this._nightCreatures.add(spawnDat);
    }

    public void spawnDayCreatures() {
        this.spawnCreatures(this._nightCreatures, this._dayCreatures, "night", "day");
    }

    public void spawnNightCreatures() {
        this.spawnCreatures(this._dayCreatures, this._nightCreatures, "day", "night");
    }

    private void spawnCreatures(List<L2Spawn> unSpawnCreatures, List<L2Spawn> spawnCreatures, String unspawnLogInfo, String spawnLogInfo) {
        try {
            int i;
            if (!unSpawnCreatures.isEmpty()) {
                i = 0;
                for (L2Spawn spawn : unSpawnCreatures) {
                    if (spawn == null) continue;
                    spawn.stopRespawn();
                    L2Npc last = spawn.getLastSpawn();
                    if (last == null) continue;
                    last.deleteMe();
                    ++i;
                }
                LOG.info("Removed {} {} creatures.", (Object)i, (Object)unspawnLogInfo);
            }
            i = 0;
            for (L2Spawn spawnDat : spawnCreatures) {
                if (spawnDat == null) continue;
                spawnDat.startRespawn();
                spawnDat.doSpawn();
                ++i;
            }
            LOG.info("Spawned {} {} creatures.", (Object)i, (Object)spawnLogInfo);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while spawning creatures!", ex);
        }
    }

    private void changeMode(int mode) {
        if (this._nightCreatures.isEmpty() && this._dayCreatures.isEmpty() && this._bosses.isEmpty()) {
            return;
        }
        switch (mode) {
            case 0: {
                this.spawnDayCreatures();
                this.specialNightBoss(0);
                break;
            }
            case 1: {
                this.spawnNightCreatures();
                this.specialNightBoss(1);
            }
        }
    }

    public DayNightSpawnManager trim() {
        ((ArrayList)this._nightCreatures).trimToSize();
        ((ArrayList)this._dayCreatures).trimToSize();
        return this;
    }

    public void notifyChangeMode() {
        if (GameTimeController.getInstance().isNight()) {
            this.changeMode(1);
        } else {
            this.changeMode(0);
        }
    }

    public void cleanUp() {
        this._nightCreatures.clear();
        this._dayCreatures.clear();
        this._bosses.clear();
    }

    private void specialNightBoss(int mode) {
        try {
            for (L2Spawn spawn : this._bosses.keySet()) {
                L2RaidBossInstance boss = this._bosses.get(spawn);
                if (boss == null && mode == 1) {
                    boss = (L2RaidBossInstance)spawn.doSpawn();
                    RaidBossSpawnManager.getInstance().notifySpawnNightBoss(boss);
                    this._bosses.put(spawn, boss);
                    continue;
                }
                if (boss == null && mode == 0) continue;
                if (boss != null && boss.getId() == 25328 && boss.getRaidStatus().equals((Object)RaidBossSpawnManager.StatusEnum.ALIVE)) {
                    this.handleHellmann(boss, mode);
                }
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while spawning special night boss!", ex);
        }
    }

    private void handleHellmann(L2RaidBossInstance boss, int mode) {
        switch (mode) {
            case 0: {
                boss.deleteMe();
                LOG.info("Deleting Hellmann raidboss.");
                break;
            }
            case 1: {
                if (!boss.isVisible()) {
                    boss.spawnMe();
                }
                LOG.info("Spawning Hellmann raidboss.");
            }
        }
    }

    public L2RaidBossInstance handleBoss(L2Spawn bossSpawn) {
        if (this._bosses.containsKey(bossSpawn)) {
            return this._bosses.get(bossSpawn);
        }
        if (GameTimeController.getInstance().isNight()) {
            L2RaidBossInstance raidboss = (L2RaidBossInstance)bossSpawn.doSpawn();
            this._bosses.put(bossSpawn, raidboss);
            return raidboss;
        }
        this._bosses.put(bossSpawn, null);
        return null;
    }

    public static DayNightSpawnManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final DayNightSpawnManager INSTANCE = new DayNightSpawnManager();

        private SingletonHolder() {
        }
    }
}

